/*
YARA rules generated with ./peid2yara.py
BY: Jaume Martin
GITHUB: https://git.todoparami.net/Xumeiquer/PEiD_to_Yara
GENERATED ON: 2016-08-29 21:22:29.883920

Rules generated from:

https://raw.githubusercontent.com/joxeankoret/pyew/VERSION_3X/plugins/UserDB.TXT
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/userdb_panda.txt
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/userdb_jclausing.txt
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/userdb_exeinfope.txt
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/eppackersigs.peid
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/epcompilersigs.peid
https://raw.githubusercontent.com/AlienVault-Labs/AlienVaultLabs/master/peid2yar/dbs/UserDB.TXT
https://raw.githubusercontent.com/cuckoosandbox/cuckoo/master/data/peutils/UserDB.TXT
http://handlers.sans.org/jclausing/userdb.txt
https://raw.githubusercontent.com/seifreed/PEID/master/userdb.txt
https://raw.githubusercontent.com/guelfoweb/peframe/5beta/peframe/signatures/userdb.txt


*/

import "pe"

rule NsPacK_V33_LiuXingPing_additional: PEiD
{
    strings:
        $a = { 9C 60 BD ?? ?? ?? ?? 01 AD 54 3A 40 ?? FF B5 50 3A 40 ?? 6A 40 FF 95 88 3A 40 ?? 50 50 2D ?? ?? ?? ?? 89 85 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_ACProtect_109_additional: PEiD
{
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 90 90 90 EB 06 00 00 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule PEnguinCrypt_v10: PEiD
{
    strings:
        $a = { B8 93 ?? ?? 00 55 50 67 64 FF 36 00 00 67 64 89 26 00 00 BD 4B 48 43 42 B8 04 00 00 00 CC 3C 04 75 04 90 90 C3 90 67 64 8F 06 00 00 58 5D BB 00 00 40 00 33 C9 33 C0 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30xx_Jitit_Software_additional: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 00 00 00 01 68 00 ?? 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 }
    condition:
        $a at pe.entry_point

}

rule PEBundle_v02_v20x_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 01 AD ?? ?? ?? ?? 01 AD }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_19901992: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB BF ?? ?? 8B 36 ?? ?? 2B F7 81 FE ?? ?? 72 ?? BE ?? ?? FA 8E D7 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Cpp_1999_additional: PEiD
{
    strings:
        $a = { EB 02 CD 20 2B C8 68 80 ?? ?? 00 EB 02 1E BB 5E EB 02 CD 20 68 B1 2B 6E 37 40 5B 0F B6 C9 }
    condition:
        $a at pe.entry_point

}

rule PerlApp_602_ActiveState: PEiD
{
    strings:
        $a = { 68 2C EA 40 00 FF D3 83 C4 0C 85 C0 0F 85 CD 00 00 00 6A 09 57 68 20 EA 40 00 FF D3 83 C4 0C 85 C0 75 12 8D 47 09 50 FF 15 1C D1 40 00 59 A3 B8 07 41 00 EB 55 6A 08 57 68 14 EA 40 00 FF D3 83 C4 0C 85 C0 75 11 8D 47 08 50 FF 15 1C D1 40 00 59 89 44 24 10 EB 33 6A 09 57 68 08 EA 40 00 FF D3 83 C4 0C 85 C0 74 22 6A 08 57 68 FC E9 40 00 FF D3 83 C4 0C 85 C0 74 11 6A 0B 57 68 F0 E9 40 00 FF D3 83 C4 0C 85 C0 75 55 }
        $b = { 68 9C E1 40 00 FF 15 A4 D0 40 00 85 C0 59 74 0F 50 FF 15 1C D1 40 00 85 C0 59 89 45 FC 75 62 6A 00 8D 45 F8 FF 75 0C F6 45 14 01 50 8D 45 14 50 E8 9B 01 00 00 83 C4 10 85 C0 0F 84 E9 00 00 00 8B 45 F8 83 C0 14 50 FF D6 85 C0 59 89 45 FC 75 0E FF 75 14 FF 15 78 D0 40 00 E9 C9 00 00 00 68 8C E1 40 00 FF 75 14 50 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Symantec_Visual_Cafe_v30_additional: PEiD
{
    strings:
        $a = { 53 FF 15 ?? ?? ?? 00 B3 22 38 18 74 03 80 C3 FE 8A 48 01 40 33 D2 3A CA 74 0A 3A CB 74 06 8A 48 01 40 EB F2 38 10 74 01 40 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule Elicense_System_V4000_ViaTech_Inc: PEiD
{
    strings:
        $a = { 00 00 00 00 63 79 62 00 65 6C 69 63 65 6E 34 30 2E 64 6C 6C 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule nBinder_v361: PEiD
{
    strings:
        $a = { 6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C 00 5C 6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C }
        $b = { 6E 73 70 61 63 6B 24 40 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_v30_EXE_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser_additional: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? FF 57 89 E5 8D 9C 24 80 C1 FF FF 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? 00 57 83 C3 04 53 68 ?? ?? ?? 00 56 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v107b_DLL: PEiD
{
    strings:
        $a = { 90 90 90 75 }
        $b = { 60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_C_for_Windows: PEiD
{
    strings:
        $a = { 33 ED 55 9A ?? ?? ?? ?? 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule Ciphator_46: PEiD
{
    strings:
        $a = { 93 93 E8 E4 0C 54 4C 4F 53 53 20 65 72 72 6F 72 05 23 00 00 00 00 00 00 8C C0 2E 31 06 18 0D B8 00 0D CD 21 33 C0 8E D8 66 0F B7 C8 0E 8F 06 06 00 68 DF 0C 8F 06 04 00 8C C8 8E D8 8E C0 B9 44 06 BE D8 0C 8B FE 2E 8B 16 14 00 FD CD 01 E2 FC }
    condition:
        $a at pe.entry_point

}

rule Vx_Phoenix927_additional: PEiD
{
    strings:
        $a = { E8 00 00 5E 81 C6 ?? ?? BF 00 01 B9 04 00 F3 A4 E8 }
    condition:
        $a at pe.entry_point

}

rule Thoreador_12_Sergi: PEiD
{
    strings:
        $a = { 55 E8 00 00 00 00 5D 83 ED 06 81 ED E2 00 00 00 60 EB 6F 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule QinYingShieldLicense_V10X_V121_Lei_Peng_20080122: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 05 ?? ?? ?? ?? 9C 50 C2 04 00 55 8B EC 56 57 53 34 99 47 49 34 33 EF 31 CD F5 B0 CB B5 B0 A3 A1 A3 A1 B9 FE B9 FE B9 FE B9 FE BF C9 CF A7 D1 BD A3 AC C4 E3 B2 BB D6 AA B5 C0 D5 E2 C0 EF B5 C4 D6 B8 C1 EE CA C7 CA B2 C3 B4 A3 A1 B9 FE B9 FE B9 FE 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SEN_Debug_Protector_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BB ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 29 ?? ?? 4E E8 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1337_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE_Stealth_25: PEiD
{
    strings:
        $a = { 60 90 EB 22 45 78 65 53 74 65 61 6C 74 68 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D E8 00 00 00 00 5D 81 ED 40 1E 40 00 B9 99 09 00 00 8D BD 88 1E 40 00 8B F7 AC }
    condition:
        $a at pe.entry_point

}

rule Symantec_Visual_Cafe_v30: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 5D 8B C5 2D ?? 50 81 ED 05 ?? ?? ?? 8B C5 2B 85 03 0F ?? ?? 89 85 03 0F ?? ?? 8B F0 03 B5 0B 0F ?? ?? 8B F8 03 BD 07 0F ?? ?? 83 7F 0C ?? 74 2B 56 57 8B 7F 10 03 F8 }
        $b = { 64 8B 05 ?? ?? ?? ?? 55 8B EC 6A FF 68 ?? ?? 40 ?? 68 ?? ?? 40 ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 08 50 53 56 57 89 65 E8 C7 45 FC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Stones_PE_Encruptor_v113: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_Dll_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V11X_Method2_bagie_additional: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule CrypKey_V56X_DLL_Kenonic_Controls_Ltd_additional: PEiD
{
    strings:
        $a = { 8B 0C 24 E9 C0 8D 01 ?? C1 3A 6E CA 5D 7E 79 6D B3 64 5A 71 EA }
    condition:
        $a at pe.entry_point

}

rule ExeSafeguard_v10_simonzh_h_additional: PEiD
{
    strings:
        $a = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF BA A3 22 3F 9A C0 60 EB 4D EB 47 DF 69 4E 58 DF 59 79 F3 EB 01 DF 78 EE DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 8D B5 EE 19 40 00 EB 47 EB 47 DF 69 4E 58 DF 59 7A EE EB 01 DF 7B E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF 22 3F 9A C0 8B FE EB 4C EB 47 DF 69 4E 58 DF 59 74 F2 EB 01 DF 75 ED 0F 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 B9 2B CB 00 00 EB 4B EB 47 DF 69 4E 58 DF 59 78 EF }
    condition:
        $a at pe.entry_point

}

rule VPacker_ttui: PEiD
{
    strings:
        $a = { 89 C6 C7 45 E0 01 00 00 00 F7 03 00 00 FF FF 75 18 0F B7 03 50 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 EB 13 53 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 83 C7 04 FF 45 E0 4E 75 C4 8B F3 83 3E 00 75 88 8B 45 E4 8B 40 10 03 45 DC 8B 55 14 83 C2 20 89 02 68 00 80 00 00 6A 00 8B 45 D4 50 FF 55 EC 8B 55 DC 8B 42 3C 03 45 DC 83 C0 04 8B D8 83 C3 14 8D 45 E0 50 6A 40 68 00 10 00 00 52 FF 55 E8 8D 43 60 }
        $b = { 89 C6 C7 45 E0 01 00 00 00 F7 03 00 00 FF FF 75 18 0F B7 03 50 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 EB 13 53 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 83 C7 04 FF 45 E0 4E 75 C4 8B F3 83 3E 00 75 88 8B 45 E4 8B 40 10 03 45 DC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Turbo_C_20_1988_EXE: PEiD
{
    strings:
        $a = { BA 00 00 2E 89 16 00 01 B4 30 00 00 8B 2E 02 00 8B 1E 2C 00 8E DA A3 00 00 8C 06 00 00 89 1E 00 00 89 2E 00 00 C7 06 00 00 FF FF E8 00 00 C4 3E 00 00 8B C7 8B D8 B9 FF 7F 26 81 3D 38 37 75 19 26 8B 55 02 80 FA 3D 75 10 80 E6 DF FF 06 00 00 }
    condition:
        $a at pe.entry_point

}

rule codeCrypter_031_Tibbar_additional: PEiD
{
    strings:
        $a = { 50 58 53 5B 90 BB ?? ?? ?? 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v123_RC1: PEiD
{
    strings:
        $a = { 68 01 ?? ?? 00 E8 01 00 00 00 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v123_RC4_build_0807_dll_Alexey_Solodovnikov_h_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V07_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 00 EB FB FF 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? EB 01 ?? 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 ?? EB FB ?? 83 04 24 0C C3 }
    condition:
        $a at pe.entry_point

}

rule Trap_118_EXE: PEiD
{
    strings:
        $a = { 8C D0 BB 99 CB 8E D3 33 C9 8E D0 B9 7D 04 EB 04 90 EA CD 20 E2 F8 33 D2 E5 21 50 B9 00 05 EB 03 90 CD 20 81 F9 E2 03 74 0F 90 90 83 C1 FE 83 C2 01 EB EB FA EB FE EA F0 FA B8 FE 00 E7 21 58 E7 21 66 8C E3 66 B8 00 00 01 00 8E E0 66 8C E0 8E }
    condition:
        $a at pe.entry_point

}

rule beria_v007_public_WIP_symbiont_h_additional: PEiD
{
    strings:
        $a = { 83 EC 18 53 8B 1D 00 30 ?? ?? 55 56 57 68 30 07 00 00 33 ED 55 FF D3 8B F0 3B F5 74 0D 89 AE 20 07 00 00 E8 88 0F 00 00 EB 02 33 F6 6A 10 55 89 35 30 40 ?? ?? FF D3 8B F0 3B F5 74 09 89 2E E8 3C FE FF FF EB 02 33 F6 6A 18 55 89 35 D8 43 ?? ?? FF D3 8B F0 3B F5 74 37 8B 46 0C 3B C5 8B 3D 04 30 ?? ?? 89 2E 89 6E 04 89 6E 08 74 06 50 FF D7 89 6E 0C 8B 46 10 3B C5 74 06 50 FF D7 89 6E 10 8B 46 14 3B C5 74 0A 50 FF D7 89 6E 14 EB 02 33 F6 6A 10 55 89 35 A4 40 ?? ?? FF D3 8B F0 3B F5 74 09 E8 08 12 00 00 8B C6 EB 02 33 C0 8B 48 08 8B 51 04 8B 09 8B 35 30 30 ?? ?? A3 D4 43 ?? ?? 8B 00 03 D0 52 03 C8 51 FF D6 8B 3D 24 30 ?? ?? 50 FF D7 }
    condition:
        $a at pe.entry_point

}

rule YZPack_12_UsAr_additional: PEiD
{
    strings:
        $a = { 60 33 C0 8D 48 07 50 E2 FD 8B EC 64 8B 40 30 78 0C 8B 40 0C }
    condition:
        $a at pe.entry_point

}

rule PECompact_2xx_Slim_Loader_BitSum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 }
    condition:
        $a at pe.entry_point

}

rule PE_Armor_049_Hying_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSVCpp_DLL_v8_typical_OEP_recognized_h: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 75 09 83 3D ?? ?? ?? ?? 00 EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 ?? ?? ?? FF 85 C0 75 04 33 C0 EB 4E 57 56 53 E8 ?? ?? ?? FF 83 FE 01 89 45 0C 75 0C 85 C0 75 37 57 50 53 E8 ?? ?? ?? FF 85 F6 74 05 83 FE 03 75 26 57 56 53 E8 ?? ?? ?? FF 85 C0 75 03 21 45 0C 83 7D 0C 00 74 11 A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 0C 8B 45 0C 5F 5E 5B 5D C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_MinGW_GCC_2x_Anorganix: PEiD
{
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 }
    condition:
        $a at pe.entry_point

}

rule RSCs_Process_Patcher_v151: PEiD
{
    strings:
        $a = { 68 00 20 40 00 E8 C3 01 00 00 80 38 00 74 0D 66 81 78 FE 22 20 75 02 EB 03 40 EB EE 8B F8 B8 04 60 40 00 68 C4 20 40 00 68 D4 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 9F 01 00 00 85 C0 0F 84 39 01 00 00 BE 00 60 40 00 8B 06 A3 28 21 40 00 83 }
        $b = { 68 00 20 40 00 E8 C3 01 00 00 80 38 00 74 0D 66 81 78 FE 22 20 75 02 EB 03 40 EB EE 8B F8 B8 04 60 40 00 68 C4 20 40 00 68 D4 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 9F 01 00 00 85 C0 0F 84 39 01 00 00 BE 00 60 40 00 8B 06 A3 28 21 40 00 83 C6 40 83 7E FC 00 0F 84 8F 00 00 00 8B 3E 83 C6 04 85 FF 0F 84 E5 00 00 00 81 FF 72 21 73 63 74 7A 0F B7 1E 8B CF 8D 7E 02 C7 05 24 21 40 00 00 00 00 00 83 05 24 21 40 00 01 50 A1 28 21 40 00 39 05 24 21 40 00 58 0F 84 D8 00 00 00 60 6A 00 53 68 2C 21 40 00 51 FF 35 C4 20 40 00 E8 0A 01 00 00 61 60 FC BE 2C 21 40 00 8B CB F3 A6 61 75 C2 03 FB 60 E8 3E 00 00 00 6A 00 53 57 51 FF 35 C4 20 40 00 E8 FB 00 00 00 85 C0 0F 84 A2 00 00 00 61 03 FB 8B F7 E9 71 FF FF FF 60 FF 35 C8 20 40 00 E8 CB 00 00 00 61 C7 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PESpin_V13betaX_cyberbobnbsp_nbsp_SignByfly_20080311: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB ?? ?? ?? ?? ?? ?? ?? 8B 42 3C 03 C2 ?? ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 }
    condition:
        $a at pe.entry_point

}

rule ThinstallVS_v3104_Jitit_Software: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB CC 1A 00 00 2B C3 50 68 00 00 ?? ?? 68 00 28 00 00 68 C8 00 00 00 E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_SFX_Custom: PEiD
{
    strings:
        $a = { E8 21 48 00 00 E9 16 FE FF FF 51 C7 01 08 B4 00 30 E8 A4 48 00 00 59 C3 56 8B F1 E8 EA FF FF FF F6 ?? ?? ?? ?? 74 07 56 E8 F6 04 00 00 59 8B C6 5E C2 04 00 8B 44 24 04 83 C1 09 51 83 C0 09 50 }
    condition:
        $a at pe.entry_point

}

rule Vx_VirusConstructorbased_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 5D 81 ?? ?? ?? 06 1E E8 ?? ?? E8 ?? ?? ?? ?? 2E ?? ?? ?? ?? ?? ?? B4 4A BB FF FF CD 21 83 ?? ?? B4 4A CD 21 }
    condition:
        $a at pe.entry_point

}

rule eXcalibur_v103_forgotus_h: PEiD
{
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 }
        $b = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A 60 9C 9C 6A 63 73 0B EB 02 E8 E8 E8 06 00 00 00 E8 E8 73 F7 E8 E8 83 C4 04 EB 02 E8 E8 FF 0C 24 71 01 E8 79 E0 7A 01 E8 83 C4 04 9D EB 01 E8 E8 01 00 00 00 E9 5D 81 ED AE 28 40 00 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 E7 02 00 00 E8 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 B4 02 00 00 E8 60 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_2021_protected_IAT_wwwstrongbitcom: PEiD
{
    strings:
        $a = { A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1350_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 02 ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 20 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 ?? ?? ?? ?? EB 01 ?? EB 02 ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 01 ?? E8 }
        $b = { EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 02 ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 20 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 50 EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Trivial173_by_SMTSMF_additional: PEiD
{
    strings:
        $a = { EB ?? ?? 28 54 72 69 76 69 61 6C 31 37 33 20 62 79 20 53 4D 54 2F 53 4D 46 29 }
    condition:
        $a at pe.entry_point

}

rule PUNiSHER_V15_FEUERRADER: PEiD
{
    strings:
        $a = { 3F 00 00 80 66 20 ?? 00 7E 20 ?? 00 92 20 ?? 00 A4 20 ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 }
    condition:
        $a at pe.entry_point

}

rule StarForce_Protection_Driver_Protection_Technology: PEiD
{
    strings:
        $a = { 57 68 ?? 0D 01 00 68 00 ?? ?? 00 E8 50 ?? FF FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_239_minimum_protection_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E9 ?? ?? ?? FF 50 C1 C8 18 89 05 ?? ?? ?? ?? C3 C1 C0 18 51 E9 ?? ?? ?? FF 84 C0 0F 84 6A F9 FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF E8 CF E9 FF FF B8 01 00 00 00 E9 ?? ?? ?? FF 2B D0 68 A0 36 80 D4 59 81 C9 64 98 FF 99 E9 ?? ?? ?? FF 84 C0 }
    condition:
        $a at pe.entry_point

}

rule UPX_v070_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 8C CB B9 ?? ?? BE ?? ?? 89 F7 1E A9 ?? ?? 8D ?? ?? ?? 8E D8 05 ?? ?? 8E C0 FD F3 A5 FC 2E ?? ?? ?? ?? 73 }
    condition:
        $a at pe.entry_point

}

rule MinGW_32x_main: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 E4 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 E4 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 00 41 40 00 89 EC 5D }
        $b = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Hide_PE_101_BGCorp: PEiD
{
    strings:
        $a = { ?? BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 F8 FF E2 0D 0A 2D 3D 5B 20 48 69 64 65 50 45 20 62 79 20 42 47 43 6F 72 70 20 5D 3D 2D }
        $b = { BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 F8 FF E2 0D 0A 2D 3D 5B 20 48 69 64 65 50 45 20 62 79 20 42 47 43 6F 72 70 20 5D 3D 2D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MacroMedia_ShockWave_Movie_file: PEiD
{
    strings:
        $a = { 46 57 53 }
    condition:
        $a at pe.entry_point

}

rule UPX_020_EXE: PEiD
{
    strings:
        $a = { 8C CB B9 00 00 BE 00 00 89 F7 1E A9 B5 80 8D 87 05 00 8E D8 05 00 00 8E C0 FD F3 A5 FC 2E 80 6C 13 10 73 E8 AF AD 0E 0E 0E 06 1F 07 16 68 00 00 BD FF FF F7 E1 93 CB 55 50 58 21 03 03 02 07 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V1X_Oreans_Technologies_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 43 4F 4D 43 54 4C 33 32 2E 64 6C 6C 00 00 00 49 6E 69 74 43 6F 6D 6D 6F 6E 43 6F 6E 74 72 6F 6C 73 00 00 00 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 43 72 65 61 74 65 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule theWRAP_by_TronDoc: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF 8B F0 B2 01 A1 B4 C3 40 00 E8 F1 5B F4 FF 89 03 33 D2 8B 03 E8 42 1E F5 FF 66 B9 02 00 BA FC FF FF FF 8B C6 8B 38 FF 57 0C BA B8 A7 4D 00 B9 04 00 00 00 8B C6 8B 38 FF 57 04 83 3D B8 A7 4D 00 00 0F 84 5E 01 00 00 8B 15 B8 A7 4D 00 83 C2 04 F7 DA 66 B9 02 00 8B C6 8B 38 FF 57 0C 8B 0D B8 A7 4D 00 8B D6 8B 03 E8 2B 1F F5 FF 8B C6 E8 B4 5B F4 FF 33 D2 8B 03 E8 DF 1D F5 FF BA F0 44 4E 00 B9 01 00 00 00 8B 03 8B 30 FF 56 04 80 3D F0 44 4E 00 0A 75 3F BA B8 A7 4D 00 B9 04 00 00 00 8B 03 8B 30 FF 56 04 8B 15 B8 A7 }
        $b = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Visual_Cpp_50_SP3: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 00 40 00 68 00 00 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 C4 98 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 6A 02 FF 15 00 00 40 00 83 C4 04 C7 05 00 00 40 00 FF FF FF FF C7 05 00 00 40 00 FF FF FF FF FF 15 00 00 }
    condition:
        $a at pe.entry_point

}

rule XComp_097_098_EXE_JoKo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 9C 60 E8 75 06 00 00 34 ?? 01 00 00 00 00 00 00 00 00 00 4C ?? 01 00 34 ?? 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 59 ?? 01 00 6A ?? 01 00 79 ?? 01 00 88 ?? 01 00 96 ?? 01 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 47 65 74 50 72 6F 63 41 64 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V18X_V19X_Oreans_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D ?? ?? ?? ?? EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 05 89 48 01 61 E9 }
        $b = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPAck_1061b: PEiD
{
    strings:
        $a = { 90 90 75 00 E9 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1988_additional: PEiD
{
    strings:
        $a = { 8C D8 BB ?? ?? 8E DB 8C D3 8B CC FA 8E ?? ?? ?? BC }
    condition:
        $a at pe.entry_point

}

rule PRO_PACK_v208_emphasis_on_packed_size_locked_additional: PEiD
{
    strings:
        $a = { 83 EC ?? 8B EC BE ?? ?? FC E8 ?? ?? 05 ?? ?? 8B C8 E8 ?? ?? 8B }
    condition:
        $a at pe.entry_point

}

rule RoboForm_Installer: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 E0 F3 40 00 68 44 90 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 68 F0 40 00 33 D2 8A D4 89 15 04 6B 41 00 8B C8 81 E1 FF 00 00 00 89 0D }
    condition:
        $a at pe.entry_point

}

rule ASPack_108: PEiD
{
    strings:
        $a = { 90 90 90 75 01 90 E9 }
    condition:
        $a at pe.entry_point

}

rule PeCompact2_253_276_BitSum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 55 53 51 57 56 52 8D 98 C9 11 00 10 8B 53 18 52 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 5A 8B F8 50 52 8B 33 8B 43 20 03 C2 8B 08 89 4B 20 8B 43 1C 03 C2 8B 08 89 4B 1C 03 F2 8B 4B 0C 03 CA 8D 43 1C 50 57 56 FF }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Borland_Delphi_60_70: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 53 8B D8 33 C0 A3 09 09 09 00 6A 00 E8 09 09 00 FF A3 09 09 09 00 A1 09 09 09 00 A3 09 09 09 00 33 C0 A3 09 09 09 00 33 C0 A3 09 09 09 00 E8 }
    condition:
        $a at pe.entry_point

}

rule SuckStop_v111_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? ?? ?? BE ?? ?? B4 30 CD 21 EB ?? 9B }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig4_h: PEiD
{
    strings:
        $a = { FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
        $b = { C3 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule RLPack_v118_Basic_DLL_LZMA: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A }
    condition:
        $a at pe.entry_point

}

rule DOS_Extender_by_Doug_Hoffmann_1994: PEiD
{
    strings:
        $a = { 16 53 66 5B 72 EC 3B C8 75 E8 36 66 89 36 D2 01 57 36 8B 3E 00 00 8B 0E 06 00 8B 36 18 00 66 C1 CB 10 66 0F B7 C3 8B D0 AD 8B 1C 3B DF 0F 8D 08 00 03 DA 8E C3 26 67 01 10 83 C6 02 E2 EA B4 0F CD 10 2E A2 00 00 5F 16 1F 66 8F 06 D6 01 66 8F }
    condition:
        $a at pe.entry_point

}

rule PolyCrypt_PE_214b215_JLab_Software_Creations_h_signed_additional: PEiD
{
    strings:
        $a = { 50 6F 6C 79 43 72 79 70 74 20 50 45 20 28 63 29 20 32 30 30 34 2D 32 30 30 35 2C 20 4A 4C 61 62 53 6F 66 74 77 61 72 65 2E 00 50 00 43 00 50 00 45 }
    condition:
        $a at pe.entry_point

}

rule MingWin32_Dev_Cpp_v4991_h: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 ?? ?? 00 00 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v10061_additional: PEiD
{
    strings:
        $a = { E8 AF 1C 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_LTC_13: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 E9 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098_tE: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_13x_14x_DLL_Risco_Software_Inc_additional: PEiD
{
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 ?? BA ?? ?? CD 21 B8 ?? ?? CD 21 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_MinGW_GCC_2x: PEiD
{
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_70_DLL: PEiD
{
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule N_Joy_10_NEX_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 9C 3B 40 00 E8 8C FC FF FF 6A 00 68 E4 39 40 00 6A 0A 6A 00 E8 40 FD FF FF E8 EF F5 FF FF 8D 40 00 }
    condition:
        $a at pe.entry_point

}

rule mPack_003_DeltaAziz: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 33 C0 89 45 F0 B8 A8 76 00 10 E8 67 C4 FF FF 33 C0 55 68 C2 78 00 10 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 08 A5 00 10 33 C0 55 68 A5 78 00 10 64 FF 30 64 89 20 A1 08 A5 00 10 E8 FA C9 FF FF 83 F8 FF 75 0A E8 88 B2 FF FF E9 1B 01 00 00 C7 05 14 A5 00 10 32 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 C9 C9 FF FF BA 14 A5 00 10 A1 08 A5 00 10 B9 04 00 00 00 E8 C5 C9 FF FF 83 3D 14 A5 00 10 32 77 0A E8 47 B2 FF FF E9 DA 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 92 C9 FF FF BA 18 A5 }
        $b = { 55 8B EC 83 C4 F0 33 C0 89 45 F0 B8 A8 76 00 10 E8 67 C4 FF FF 33 C0 55 68 C2 78 00 10 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 08 A5 00 10 33 C0 55 68 A5 78 00 10 64 FF 30 64 89 20 A1 08 A5 00 10 E8 FA C9 FF FF 83 F8 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Eddie2000: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? FC 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 50 06 56 1E 8B FE 33 C0 50 8E D8 C5 ?? ?? ?? B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule aPack_082_d_EXE: PEiD
{
    strings:
        $a = { 8C CB BA 00 00 03 DA 8D 87 00 00 FC 33 F6 33 FF 48 4B 8E C0 8E DB B9 08 00 F3 A5 4A 75 EE 8E C3 8E D8 33 FF BE 2F 00 05 00 00 0E 50 6A 00 CB }
    condition:
        $a at pe.entry_point

}

rule HackStop_099_EXE: PEiD
{
    strings:
        $a = { B4 30 CD 21 86 E0 3D 00 03 73 06 B0 FF B4 4C CD 21 50 B8 EB 04 58 EB FB 9A B8 00 33 CD 21 50 E8 D5 03 8D B2 00 B8 01 33 CD 21 50 B8 EB 06 58 EB FB 66 AE 12 E8 C0 03 8D EB 02 40 93 50 55 52 8C D2 FA 50 B8 EB 04 58 EB FB 9A 8C C8 8E D0 EB 02 }
    condition:
        $a at pe.entry_point

}

rule NoobyProtect_SE_Public_V1150_Nooby_20090201: PEiD
{
    strings:
        $a = { E9 ?? 00 00 00 4E 6F 6F 62 79 50 72 6F 74 65 63 74 20 53 45 20 31 2E 31 2E 35 2E 30 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V215_V220_SetiSoft_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SecurePE_1X_wwwdeepzoneorg: PEiD
{
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3 }
    condition:
        $a at pe.entry_point

}

rule Software_Compress_V12_BG_Software_Protect_Technologies: PEiD
{
    strings:
        $a = { E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 }
    condition:
        $a at pe.entry_point

}

rule LY_WGKX_wwwszleyucom_additional: PEiD
{
    strings:
        $a = { 4D 5A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 53 46 58 }
    condition:
        $a at pe.entry_point

}

rule Unnamed_Scrambler_25A_p0ke: PEiD
{
    strings:
        $a = { 55 8B EC B9 0B 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 6C 3E 40 00 E8 F7 EA FF FF 33 C0 55 68 60 44 40 00 64 FF 30 64 89 20 BA 70 44 40 00 B8 B8 6C 40 00 E8 62 F3 FF FF 8B D8 85 DB 75 07 6A 00 E8 A1 EB FF FF BA E8 64 40 00 8B C3 8B 0D B8 6C 40 00 E8 37 D3 FF FF C7 05 BC 6C 40 00 0A 00 00 00 BB 68 6C 40 00 BE 90 6C 40 00 BF E8 64 40 00 B8 C0 6C 40 00 BA 04 00 00 00 E8 07 EC FF FF 83 3B 00 74 04 33 C0 89 03 8B D7 8B C6 E8 09 F3 FF FF 89 03 83 3B 00 0F 84 BB 04 00 00 B8 C0 6C 40 00 8B 16 E8 06 E2 FF FF B8 C0 6C 40 00 E8 24 E1 FF FF 8B D0 8B 03 8B 0E E8 D1 D2 FF FF 8B C7 A3 20 6E 40 00 8D 55 EC 33 C0 E8 0C D4 FF FF 8B 45 EC B9 1C 6E 40 00 BA 18 6E 40 00 }
        $b = { 55 8B EC B9 0B 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 6C 3E 40 00 E8 F7 EA FF FF 33 C0 55 68 60 44 40 00 64 FF 30 64 89 20 BA 70 44 40 00 B8 B8 6C 40 00 E8 62 F3 FF FF 8B D8 85 DB 75 07 6A 00 E8 A1 EB FF FF BA E8 64 40 00 8B C3 8B 0D B8 6C 40 00 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_Pack_Master_10_PEX_Clone_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 01 01 00 00 E8 83 C4 04 E8 01 90 90 90 E9 5D 81 ED D3 22 40 90 E8 04 02 90 90 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_1451_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? ?? 05 00 ?? ?? ?? A3 08 ?? ?? ?? A1 08 ?? ?? ?? B9 81 ?? ?? ?? 2B 48 18 89 0D 0C ?? ?? ?? 83 3D 10 ?? ?? ?? 00 74 16 A1 08 ?? ?? ?? 8B 0D 0C ?? ?? ?? 03 48 14 }
    condition:
        $a at pe.entry_point

}

rule XCR_v012_X_Lock: PEiD
{
    strings:
        $a = { 60 9C E8 00 00 00 00 8B DD 5D 81 ED ?? ?? ?? ?? 89 9D }
    condition:
        $a at pe.entry_point

}

rule PKLITE32_v11_PKWare: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 00 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_1992_1994_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C C8 8E D8 8C 1E ?? ?? 8C 06 ?? ?? 8C 06 ?? ?? 8C 06 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1989_1994_additional: PEiD
{
    strings:
        $a = { 0E 1F 8C C6 B4 ?? 50 BB ?? ?? CD 21 73 ?? 58 CD 21 72 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V1304_cyberbobnbsp_nbsp_SignByfly_20080310: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 ?? EB 01 ?? EB 0D ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB ?? ?? ?? ?? ?? ?? ?? 8B 42 3C 03 C2 ?? ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 ?? ?? ?? ?? EB 06 ?? ?? ?? ?? ?? ?? F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 }
    condition:
        $a at pe.entry_point

}

rule ICE_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 2D 6C 68 ?? 2D }
    condition:
        $a at pe.entry_point

}

rule SafeGuard_V10X_simonzh2000: PEiD
{
    strings:
        $a = { E8 00 00 00 00 EB 29 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 59 9C 81 C1 E2 FF FF FF EB 01 ?? 9D FF E1 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098_additional: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E }
    condition:
        $a at pe.entry_point

}

rule Upack_0399_Dwing_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 38 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22007121_WFS_SignByfly_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 45 50 45 3A 20 45 6E 63 72 79 70 74 50 45 20 56 32 2E 32 30 30 37 2E 31 32 2E 31 2C 20 43 6F 70 79 72 69 67 68 74 20 28 43 29 20 57 46 53 00 00 48 6F 6D 65 50 61 67 65 3A 20 77 77 77 2E 65 6E 63 72 79 70 74 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_V15_Vaska_Sign_by_fly: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? ?? EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_152_Stub_engine_16_GlOFF_additional: PEiD
{
    strings:
        $a = { E8 46 FD FF FF 50 E8 0C 00 00 00 FF 25 08 20 40 00 FF 25 0C 20 40 00 FF 25 10 20 40 00 FF 25 14 20 40 00 FF 25 18 20 40 00 FF 25 1C 20 40 00 FF 25 20 20 40 00 FF 25 24 20 40 00 FF 25 28 20 40 00 FF 25 00 20 40 00 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_104_Win32_DLL_Berczi_Gabor_Pierre_Muller_Peter_Vreman: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? ?? 00 55 89 E5 53 56 57 8B 7D 08 89 3D ?? ?? ?? ?? 8B 7D 0C 89 3D ?? ?? ?? ?? 8B 7D 10 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule PeCompact_v208_Bitsum_Technologiessignature_by_loveboom: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D }
    condition:
        $a at pe.entry_point

}

rule PE_Protect_09: PEiD
{
    strings:
        $a = { E9 ?? 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 20 28 43 29 6F }
    condition:
        $a at pe.entry_point

}

rule TheHypers_protector_TheHyper: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? 02 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_1214_SE_DLL_SIS_Team_additional: PEiD
{
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE FC 11 DB }
    condition:
        $a at pe.entry_point

}

rule AVI_movie_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 41 56 49 ?? 4C 49 53 54 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v14_CGSoftLabs: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 34 2E 2E B8 }
        $b = { 65 58 50 72 2D 76 2E 31 2E 34 2E }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MSLRH_v032a_fake_MSVCpp_DLL_Method_4_emadicius_h: PEiD
{
    strings:
        $a = { 55 8B EC 56 57 BF 01 00 00 00 8B 75 0C 85 F6 5F 5E 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Ciphator_v46_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 93 93 E8 ?? ?? 58 6A 00 0E 68 ?? ?? CF EB }
    condition:
        $a at pe.entry_point

}

rule PE_Armor_046_China_Cracking_Group: PEiD
{
    strings:
        $a = { E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_ASM: PEiD
{
    strings:
        $a = { E8 01 00 00 00 5A 5E E8 02 00 00 00 BA DD 5E 03 F2 EB 01 64 BB 80 ?? ?? 00 8B FA EB 01 A8 }
    condition:
        $a at pe.entry_point

}

rule AHPack_V01_FEUERRADER: PEiD
{
    strings:
        $a = { 60 68 54 ?? ?? 00 B8 48 ?? ?? 00 FF 10 68 B3 ?? ?? 00 50 B8 44 ?? ?? 00 FF 10 68 00 }
    condition:
        $a at pe.entry_point

}

rule MPRESS_V097_V099_MATCODE_Softwarenbsp_nbsp_SignByfly_20080416: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 05 49 01 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 2B C0 3B FE 73 28 AC 0A C0 74 23 8A C8 24 3F C1 E0 10 66 AD 80 E1 40 74 0F 8B D6 8B CF 03 F0 E8 60 00 00 00 03 F8 EB D8 8B C8 F3 A4 EB D2 5E 5A 83 EA 05 2B C9 3B CA 73 26 8B D9 AC 41 24 FE 3C E8 75 F2 43 83 C1 04 AD 0B C0 78 06 3B C2 73 E5 EB 06 03 C3 78 DF 03 C2 2B C3 89 46 FC EB D6 E8 00 00 00 00 5F 81 C7 69 FF FF FF B0 E9 AA B8 45 01 00 00 AB E8 00 00 00 00 58 05 A3 00 00 00 E9 93 00 00 00 53 56 57 8B F9 8B F2 8B DA 03 D8 51 55 33 C0 8B EB 8B DE 2B D2 2B C9 EB 4F 3B DD 73 6C 2B C9 66 8B 03 8D 5B 02 8A CC 80 E4 0F 0B C0 75 02 B4 10 C0 E9 04 80 C1 03 80 F9 12 72 19 8A 0B 66 83 C1 12 43 66 81 F9 11 01 72 0B 66 8B 0B 81 C1 11 01 00 00 43 43 8B F7 2B F0 F3 A4 12 D2 74 0A 72 B9 8A 03 43 88 07 47 EB F2 3B DD 73 1D 0A 13 F9 74 03 43 EB E6 8B 43 01 89 07 8B 43 05 89 47 04 8D 5B 09 8D 7F 08 33 C0 EB DF 5D 8B C7 59 2B C1 5F 5E 5B C3 E9 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development_h2_additional: PEiD
{
    strings:
        $a = { E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule HSI_JPEG_graphics_file: PEiD
{
    strings:
        $a = { 68 73 69 31 00 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_CodeSafe_20_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Borland_Delphi_50_KOLMCK_Anorganix: PEiD
{
    strings:
        $a = { 55 8B EC 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 FF 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 EB 04 00 00 00 01 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Soft_Defender_v112_additional: PEiD
{
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 BE 01 00 00 03 C8 74 BD 75 BB E8 }
    condition:
        $a at pe.entry_point

}

rule Free_Pascal_v1010_win32_console: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? 00 01 E8 ?? ?? 00 00 C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5 ?? EC }
    condition:
        $a at pe.entry_point

}

rule UPX_v0896_v102_v105_v122_Delphi_stub_additional: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? C7 87 ?? ?? ?? ?? ?? ?? ?? ?? 57 83 CD FF EB 0E ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_v04_beta_1_by_Alex: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 }
        $b = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 00 00 00 00 49 E8 01 00 00 00 68 83 C4 04 85 C9 75 DF E8 B9 02 00 00 E8 01 00 00 00 C7 83 C4 04 8D 95 63 14 40 00 E8 01 00 00 00 C7 83 C4 04 90 90 90 E8 CA 01 00 00 01 02 03 04 05 68 90 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UnoPiX_103_110_BaGiE: PEiD
{
    strings:
        $a = { 83 EC 04 C7 04 24 00 ?? ?? ?? C3 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 00 00 00 00 00 02 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 10 }
        $b = { 83 EC 04 C7 04 24 00 ?? ?? ?? C3 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 00 00 00 00 00 02 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule XCF_File_Format_by_Adeline_Software_additional: PEiD
{
    strings:
        $a = { 46 72 61 6D 65 4C 65 6E F4 0F }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Seek_and_Destroy_Patch_additional: PEiD
{
    strings:
        $a = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 63 05 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 5A 05 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 4B 05 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 3C 05 00 00 6A 00 FF 75 08 E8 0E 05 00 00 A3 CA 39 40 00 C7 05 D2 39 40 00 2C 00 00 00 C7 05 D6 39 40 00 10 00 00 00 C7 05 DA 39 40 00 00 08 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 DD 04 00 00 C7 05 DA 39 40 00 00 00 00 00 C7 05 F6 39 40 00 00 30 40 00 C7 05 FA 39 40 00 01 00 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 AB 04 00 00 EB 5F EB 54 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1989_1994: PEiD
{
    strings:
        $a = { 0E 1F 8C C6 B4 ?? 50 BB ?? ?? CD 21 73 ?? 58 CD 21 72 }
    condition:
        $a at pe.entry_point

}

rule VBOX_v42_MTE: PEiD
{
    strings:
        $a = { 8C E0 0B C5 8C E0 0B C4 03 C5 74 00 74 00 8B C5 }
    condition:
        $a at pe.entry_point

}

rule PeCompact_2xx_Slim_Loader_BitSum_Technologies_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 02 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule Visual_Studio_NET_2003_Hotfix_Custom: PEiD
{
    strings:
        $a = { 6A 60 68 E8 87 00 01 E8 37 14 00 00 BF 94 00 00 00 8B C7 E8 B3 05 00 00 89 65 E8 8B F4 89 3E 56 FF 15 14 10 00 01 8B 4E 10 89 0D 58 22 01 01 8B 46 04 A3 64 22 01 01 8B 56 08 89 15 68 22 01 01 }
    condition:
        $a at pe.entry_point

}

rule PE_Encrypt_10_Liwuyue_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D 0F 05 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1987_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? 9A ?? ?? ?? ?? B8 ?? ?? 50 9A ?? ?? ?? ?? 92 }
    condition:
        $a at pe.entry_point

}

rule SDProtector_Pro_112_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_PolyCryptor_vxx_Extranger_additional: PEiD
{
    strings:
        $a = { 55 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 }
    condition:
        $a at pe.entry_point

}

rule Wise_Installer_Stub_11010291: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 40 0F 00 00 53 56 57 6A 04 FF 15 F4 30 40 00 FF 15 74 30 40 00 8A 08 89 45 E8 80 F9 22 75 48 8A 48 01 40 89 45 E8 33 F6 84 C9 74 0E 80 F9 22 74 09 8A 48 01 40 89 45 E8 EB EE 80 38 22 75 04 40 89 45 E8 80 38 20 75 09 40 80 38 20 74 FA 89 45 }
    condition:
        $a at pe.entry_point

}

rule PGMPACK_v013_additional: PEiD
{
    strings:
        $a = { FA 1E 17 50 B4 30 CD 21 3C 02 73 ?? B4 4C CD 21 FC BE ?? ?? BF ?? ?? E8 ?? ?? E8 ?? ?? BB ?? ?? BA ?? ?? 8A C3 8B F3 }
    condition:
        $a at pe.entry_point

}

rule MinGW_32x_Dll_WinMain_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 96 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 }
    condition:
        $a at pe.entry_point

}

rule TTPpack_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5D 81 ED F5 8F 40 00 60 33 F6 E8 11 00 00 00 8B 64 24 08 64 8F 05 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_ACProtect_109: PEiD
{
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 90 90 90 EB 06 00 00 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9 }
        $b = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule TurboBAT_v310_50_Patched_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 06 B8 ?? ?? 8E C0 B9 ?? ?? 26 ?? ?? ?? ?? 80 ?? ?? 26 ?? ?? ?? 24 ?? 3A C4 90 90 }
    condition:
        $a at pe.entry_point

}

rule Vx_Trivial25: PEiD
{
    strings:
        $a = { B4 4E FE C6 CD 21 B8 ?? 3D BA ?? 00 CD 21 93 B4 40 CD }
    condition:
        $a at pe.entry_point

}

rule MingWin32_GCC_V3X: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? 40 00 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Visual_Protect_Visage: PEiD
{
    strings:
        $a = { 55 8B EC 51 53 56 57 C7 05 ?? ?? ?? 00 00 00 00 00 68 ?? ?? ?? 00 FF 15 00 ?? ?? 00 A3 ?? ?? ?? 00 68 ?? ?? ?? 00 A1 ?? ?? ?? 00 50 FF 15 04 ?? ?? 00 A3 ?? ?? ?? 00 6A 00 FF 15 ?? ?? ?? 00 A3 ?? ?? ?? 00 8B 0D ?? ?? ?? 00 51 E8 ?? ?? 00 00 83 C4 04 89 45 FC 83 7D FC 00 74 03 FF 65 FC 5F 5E 5B 8B E5 }
    condition:
        $a at pe.entry_point

}

rule Zortech_C_v200_1988_1989_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 8E D8 8C ?? ?? ?? 26 8B ?? ?? ?? 89 1E ?? ?? 8B D8 2B 1E ?? ?? 89 1E }
    condition:
        $a at pe.entry_point

}

rule ExeTools_COM2EXE_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 5D 83 ED ?? 8C DA 2E 89 96 ?? ?? 83 C2 ?? 8E DA 8E C2 2E 01 96 ?? ?? 60 }
    condition:
        $a at pe.entry_point

}

rule NeoLite_v10_additional: PEiD
{
    strings:
        $a = { 8B 44 24 04 23 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FE 05 ?? ?? ?? ?? 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule RECSmall_v101_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C D8 1E E8 ?? ?? 5D 83 ?? ?? 81 ?? ?? ?? B9 ?? ?? 40 8E D8 2B DB B2 55 }
    condition:
        $a at pe.entry_point

}

rule RLP_073beta_ap0x_h: PEiD
{
    strings:
        $a = { 60 8B DD E8 00 00 00 00 5D 95 32 C0 95 89 9D 80 00 00 00 B8 42 31 40 00 BB 41 30 40 00 2B C3 03 C5 33 D2 8A 10 40 B9 ?? ?? 00 00 8B F9 30 10 8A 10 40 49 75 F8 64 EF 86 3D 30 00 00 0F B9 FF 4B 89 52 5C 4C BD 77 C2 0C CE 88 4E 2D E8 00 00 00 5D 0D DB 5E 56 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V307_SetiSoft_Team_20090603: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 00 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 00 00 E0 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    strings:
        $a = { 0F B6 D0 E8 01 00 00 00 0C 5A B8 80 ?? ?? 00 EB 02 00 DE 8D 35 F4 00 00 00 F7 D2 EB 02 0E EA 8B 38 EB 01 A0 C1 F3 11 81 EF 84 88 F4 4C EB 02 CD 20 83 F7 22 87 D3 33 FE C1 C3 19 83 F7 26 E8 02 00 00 00 BC DE 5A 81 EF F7 EF 6F 18 EB 02 CD 20 83 EF 7F EB 01 }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Registration_file_v10_additional: PEiD
{
    strings:
        $a = { 24 46 41 52 45 47 24 4D 2D ?? ?? ?? ?? 31 }
    condition:
        $a at pe.entry_point

}

rule MacroMedia_ShockWave_Movie_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 46 57 53 }
    condition:
        $a at pe.entry_point

}

rule LTC_v13_additional: PEiD
{
    strings:
        $a = { 60 EB 03 C7 84 E8 EB 03 C7 84 9A E8 00 00 00 00 5D 81 ED 10 00 00 00 EB 03 C7 84 E9 64 A0 23 00 00 00 EB }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development_h1_additional: PEiD
{
    strings:
        $a = { 06 8C C8 8E C0 BE ?? ?? 26 ?? ?? 34 ?? 26 ?? ?? 46 81 ?? ?? ?? 75 ?? 40 B3 ?? B3 ?? F3 }
    condition:
        $a at pe.entry_point

}

rule aPack_098_i_m_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 00 01 BF 00 01 50 57 FC B2 80 BD 00 01 50 AC F6 D0 AA FF D5 73 F8 FF D5 41 73 12 FF D5 BB 10 00 72 24 FF D5 12 DB 73 FA 75 00 93 EB 00 B7 01 FF D5 12 FF 72 00 FF D5 72 F6 FF D5 13 C9 FF D5 72 F8 80 EF 03 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V30_V30X_SetiSoft_Team_20090215: PEiD
{
    strings:
        $a = { 00 2E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 E0 2E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 E0 2E 72 73 72 63 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 40 00 00 40 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v123_RC4_build_0807_exe_Alexey_Solodovnikov_h: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_V2X_SoftComplete_Developement: PEiD
{
    strings:
        $a = { A4 ?? ?? 00 00 00 00 00 FF FF FF FF 3C ?? ?? 00 94 ?? ?? 00 D8 ?? ?? 00 00 00 00 00 FF FF FF FF }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_V102_Ashkbiz_Danehkar_Sign_by_fly: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 3A 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 C3 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Stelth_PE_101: PEiD
{
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 BA ?? ?? ?? ?? FF E2 BA E0 10 40 00 B8 68 24 1A 40 89 02 83 C2 03 B8 40 00 E8 EE 89 02 83 C2 FD FF E2 2D 3D 5B 20 48 69 64 65 50 45 20 5D 3D 2D 90 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SmokesCrypt_v12: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8A 14 08 80 F2 ?? 88 14 08 41 83 F9 ?? 75 F1 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1337_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_FSG_10_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B E9 }
    condition:
        $a at pe.entry_point

}

rule ExeJoiner_10_Yoda_f2f_additional: PEiD
{
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50 }
    condition:
        $a at pe.entry_point

}

rule EXELOCK_666_15: PEiD
{
    strings:
        $a = { BA ?? ?? BF ?? ?? EB ?? EA ?? ?? ?? ?? 79 ?? 7F ?? 7E ?? 1C ?? 48 78 ?? E3 ?? 45 14 ?? 5A E9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_70_Custom_additional: PEiD
{
    strings:
        $a = { 60 BE 00 B0 44 00 8D BE 00 60 FB FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 }
    condition:
        $a at pe.entry_point

}

rule Vx_Backfont900: PEiD
{
    strings:
        $a = { E8 ?? ?? B4 30 CD 21 3C 03 ?? ?? B8 ?? ?? BA ?? ?? CD 21 81 FA ?? ?? ?? ?? BA ?? ?? 8C C0 48 8E C0 8E D8 80 ?? ?? ?? 5A ?? ?? 03 ?? ?? ?? 40 8E D8 80 ?? ?? ?? 5A ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_Pro_v261: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 2A 6A 00 00 E9 3E 6A 00 00 E9 39 6A 00 00 E8 6E FB FF FF 7E 04 01 00 ?? 96 00 00 ?? ?? ?? ?? ?? ?? F1 ?? ?? ?? A4 ?? ?? ?? A1 ?? ?? ?? E0 ?? ?? ?? 19 ?? ?? ?? BE ?? ?? ?? 13 }
    condition:
        $a at pe.entry_point

}

rule tElock_099_additional: PEiD
{
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? ?? 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_Protector_v10x_2: PEiD
{
    strings:
        $a = { EB ?? ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB }
    condition:
        $a at pe.entry_point

}

rule CrunchPE_v30xx: PEiD
{
    strings:
        $a = { EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? FF 74 }
    condition:
        $a at pe.entry_point

}

rule PolyBox_C_Anskya: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 B8 E4 41 00 10 E8 3A E1 FF FF 33 C0 55 68 11 44 00 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 6A 0A 68 20 44 00 10 A1 1C 71 00 10 50 E8 CC E1 ?? ?? ?? ?? 85 DB 0F 84 77 01 00 00 53 A1 1C 71 00 10 50 E8 1E E2 FF FF 8B F0 85 F6 0F 84 61 01 00 00 53 A1 1C 71 00 10 50 E8 E0 E1 FF FF 85 C0 0F 84 4D 01 00 00 50 E8 DA E1 FF FF 8B D8 85 DB 0F 84 3D 01 00 00 56 B8 70 80 00 10 B9 01 00 00 00 8B 15 98 41 00 10 E8 9E DE FF FF 83 C4 04 A1 70 80 00 10 8B CE 8B D3 E8 E1 E1 FF FF 6A 00 6A 00 A1 70 80 00 10 B9 30 44 00 10 8B D6 E8 F8 FD FF FF }
        $b = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WATCOM_C_1991_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FB B9 ?? ?? 8E C1 BB ?? ?? 83 ?? ?? 83 E3 ?? 26 89 1E ?? ?? 26 8C 1E ?? ?? 03 DC }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_v20_1984_additional: PEiD
{
    strings:
        $a = { 90 90 CD AB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 38 34 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v212_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 }
    condition:
        $a at pe.entry_point

}

rule FSG_v131: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 BB ?? ?? ?? ?? B2 80 A4 B6 80 FF D3 73 F9 33 C9 }
    condition:
        $a at pe.entry_point

}

rule FSG_v133: PEiD
{
    strings:
        $a = { BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 }
    condition:
        $a at pe.entry_point

}

rule RLPack_FullEdition_V120_LZMA_430_ap0x_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 10 00 00 08 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22008618_WFS: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 E8 52 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 43 72 65 61 74 65 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v126b1_v126b2: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? 05 0E }
    condition:
        $a at pe.entry_point

}

rule RLPack_V120_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD A8 0C 00 00 00 74 0E 83 BD AC 0C 00 00 00 74 05 E8 F2 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 2D 0C 00 00 89 85 C0 0C 00 00 5B 60 FF B5 94 0C 00 00 56 FF B5 C0 0C 00 00 FF D3 61 8B B5 C0 0C 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 EB 72 56 FF 95 25 0C 00 00 0B C0 75 05 E8 E6 02 00 00 85 C0 0F 84 AB 00 00 00 89 85 B8 0C 00 00 8B C6 EB 2E 8B 85 BC 0C 00 00 8B 00 50 FF B5 B8 0C 00 00 E8 2E 02 00 00 85 C0 0F 84 85 00 00 00 89 07 83 85 BC 0C 00 00 04 83 C7 04 8B 85 BC 0C 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 80 3E 01 75 89 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 94 0C 00 00 FF 95 31 0C 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule Kodak_Color_management_for_Windows_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4B 43 4D 53 }
    condition:
        $a at pe.entry_point

}

rule EXE_Manager_30: PEiD
{
    strings:
        $a = { B4 30 1E 06 CD 21 2E A3 08 00 BF 0A 00 B9 89 0A 33 C0 2E 03 05 47 E2 FA 2E 3B 06 06 00 74 09 B8 07 0E CD 10 33 C0 50 CB BF 0A 00 B9 45 05 2E 8B 16 04 00 FA 33 C0 8E C0 26 FF 36 0C 00 26 FF 36 0E 00 26 C7 06 0C 00 45 01 26 8C 0E 0E 00 2E 89 }
    condition:
        $a at pe.entry_point

}

rule EXE_Manager_32: PEiD
{
    strings:
        $a = { B4 30 1E 06 CD 21 2E A3 08 00 BF 0A 00 B9 F6 0B 33 C0 2E 03 05 47 E2 FA 2E 3B 06 06 00 74 09 B8 07 0E CD 10 33 C0 50 CB BD 0A 00 B9 FB 05 2E 8B 1E 04 00 FA 33 C0 8E C0 26 FF 36 0C 00 26 FF 36 0E 00 26 C7 06 0C 00 70 01 26 8C 0E 0E 00 BE 47 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v13_CGSoftLabs: PEiD
{
    strings:
        $a = { 45 78 50 72 2D 76 2E 31 2E 33 2E }
        $b = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 33 2E 2E B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 13 A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 89 ?? ?? E9 ?? ?? 00 00 C7 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule BlackEnergy_DDoS_Bot_Crypter_additional: PEiD
{
    strings:
        $a = { 55 ?? ?? 81 EC 1C 01 00 00 53 56 57 6A 04 BE 00 30 00 00 56 FF 35 00 20 11 13 6A 00 E8 ?? 03 00 00 ?? ?? 83 C4 10 ?? FF 89 7D F4 0F }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? B8 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_130824_beta: PEiD
{
    strings:
        $a = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 89 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Borland_Delphi_60_70_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 53 8B D8 33 C0 A3 00 00 00 00 6A 00 E8 00 00 00 FF A3 00 00 00 00 A1 00 00 00 00 A3 00 00 00 00 33 C0 A3 }
    condition:
        $a at pe.entry_point

}

rule EXELOCK_666_15_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BA ?? ?? BF ?? ?? EB ?? EA ?? ?? ?? ?? 79 ?? 7F ?? 7E ?? 1C ?? 48 78 ?? E3 ?? 45 14 ?? 5A E9 }
    condition:
        $a at pe.entry_point

}

rule Themida_1201_compressed_Oreans_Technologies_h: PEiD
{
    strings:
        $a = { B8 00 00 ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_19881989_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? CD 20 BF ?? ?? 8B ?? ?? ?? 2B F7 81 ?? ?? ?? 72 }
    condition:
        $a at pe.entry_point

}

rule PeX_099_Eng_bartCrackPl: PEiD
{
    strings:
        $a = { E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_3_Portions_Copyright_c_198396_Borland_h_additional: PEiD
{
    strings:
        $a = { 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 36 20 42 6F 72 6C 61 6E 64 00 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_111_Method_2NT_bagieTMX_h: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 40 00 00 C0 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 EB 01 CD 64 A1 30 00 00 00 EB 01 CD 8B 48 0C E3 6F EB 01 CD 05 AC 00 00 00 EB 01 CD 66 81 38 93 08 EB 01 CD 75 0A EB 01 CD B8 38 FF FF FF EB 14 EB 01 CD 66 81 38 28 0A 75 4A EB 01 CD B8 1A FF FF FF EB 00 EB 01 CD 31 C9 EB 01 CD 51 EB 01 CD 51 EB 01 CD 6A 11 EB 01 CD 6A FE EB 01 CD E8 03 00 00 00 EB 01 CD 83 04 24 18 EB }
    condition:
        $a at pe.entry_point

}

rule RCryptor_15_by_Vaska_UsAr_sign_individual_version_21032007_2215: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 40 A1 14 13 FF 54 24 04 83 44 24 04 4F B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 2B 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 19 40 EB F3 E8 00 00 00 00 C3 }
    condition:
        $a at pe.entry_point

}

rule The_aPE_Inline_Patch_ExtraStealth_SuperStealth_additional: PEiD
{
    strings:
        $a = { E8 02 ?? ?? ?? EB 01 C3 3E 8B 44 24 FC 50 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Basic_50_60_Anorganix: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule CrunchPE_10xx_BitArts: PEiD
{
    strings:
        $a = { 55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 75 09 C6 85 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V13X_vcasm_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 55 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 47 64 69 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MPEG_Layer_IIIII_music_file_Hint_FILE_START_additional: PEiD
{
    strings:
        $a = { FF FE }
    condition:
        $a at pe.entry_point

}

rule CRYPToCRACks_PE_Protector_v093_Lucas_Fleischer_h: PEiD
{
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 00 81 EB 00 01 00 00 75 BE 90 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 7A ?? ?? ?? 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 C1 00 46 61 74 61 6C 45 78 69 74 }
    condition:
        $a at pe.entry_point

}

rule Vx_Caz1204: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 83 EE 03 1E 06 B8 FF FF CD 2F 3C 10 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_ExeSmasher_Anorganix: PEiD
{
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Lockless_Intro_Pack_Anorganix: PEiD
{
    strings:
        $a = { 2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD }
    condition:
        $a at pe.entry_point

}

rule PCrypt_v351_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 50 43 52 59 50 54 FF 76 33 2E 35 31 00 E9 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v16_Vaska_additional: PEiD
{
    strings:
        $a = { 33 D0 68 ?? ?? ?? ?? FF D2 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule InstallShield_Cabinet_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 49 53 63 }
    condition:
        $a at pe.entry_point

}

rule MPRESS_V107_V125_MATCODE_Softwarenbsp_nbsp_SignByfly_20080730: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 05 9E 02 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 51 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 8B D6 8B CF E8 56 00 00 00 5E 5A 83 EA 05 2B C9 3B CA 73 26 8B D9 AC 41 24 FE 3C E8 75 F2 43 83 C1 04 AD 0B C0 78 06 3B C2 73 E5 EB 06 03 C3 78 DF 03 C2 2B C3 89 46 FC EB D6 E8 00 00 00 00 5F 81 C7 8D FF FF FF B0 E9 AA B8 9A 02 00 00 AB E8 00 00 00 00 58 05 1C 02 00 00 E9 0C 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_Poly_21_Extranger_additional: PEiD
{
    strings:
        $a = { 55 50 8B C4 83 C0 04 C7 00 ?? ?? ?? ?? 58 C3 90 }
    condition:
        $a at pe.entry_point

}

rule APatch_GUI_v11: PEiD
{
    strings:
        $a = { 52 31 C0 E8 FF FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1364_Obsidium_Software_20090428: PEiD
{
    strings:
        $a = { EB 02 ?? ?? 50 EB 04 ?? ?? ?? ?? E8 29 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 1E EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 64 FF 30 EB 02 ?? ?? 64 89 20 EB 01 ?? EB 01 ?? 8B 00 EB 01 ?? C3 EB 02 ?? ?? E9 ?? ?? ?? ?? EB 02 ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule NME_11_Public_by_redlime_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 B8 30 35 14 13 E8 9A E6 FF FF 33 C0 55 68 6C 36 14 13 64 FF 30 64 89 20 B8 08 5C 14 13 BA 84 36 14 13 E8 7D E2 FF FF E8 C0 EA FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 04 F8 FF FF 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 F4 F7 FF FF 8B }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_v112_LITE: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_DEF_10_Anorganix: PEiD
{
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_1xx_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 2C 53 56 33 F6 57 56 89 75 DC 89 75 F4 BB A4 9E 40 00 FF 15 60 70 40 00 BF C0 B2 40 00 68 04 01 00 00 57 50 A3 AC B2 40 00 FF 15 4C 70 40 00 56 56 6A 03 56 6A 01 68 00 00 00 80 57 FF 15 9C 70 40 00 8B F8 83 FF FF 89 7D EC 0F 84 C3 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v20_Vaska_additional: PEiD
{
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? 02 00 00 F7 D1 83 F1 FF 59 BA 32 21 ?? 00 F7 D1 83 F1 FF F7 D1 83 F1 FF 80 02 E3 F7 D1 83 F1 FF C0 0A 05 F7 D1 83 F1 FF 80 02 6F F7 D1 83 F1 FF 80 32 A4 F7 D1 83 F1 FF 80 02 2D F7 D1 83 F1 FF 42 49 85 C9 75 }
    condition:
        $a at pe.entry_point

}

rule LHARC_SFX_Archive_v113L_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FC BC ?? ?? BB ?? ?? E8 ?? ?? 8C C8 05 ?? ?? 8E C0 B8 ?? ?? CD 21 BE ?? ?? 26 ?? ?? ?? ?? 26 ?? ?? ?? ?? ?? ?? AC E8 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V50X_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC ?? 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3 }
    condition:
        $a at pe.entry_point

}

rule Crunch_5_Bit_Arts_additional: PEiD
{
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v1xx_v2xx_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 50 8C 4C 00 68 D0 82 4A 00 64 A1 }
    condition:
        $a at pe.entry_point

}

rule LockProg_v05a_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? E8 ?? ?? E8 ?? ?? BF ?? ?? 8B EC 8B ?? ?? 2E ?? ?? ?? 03 F9 89 0D B4 30 CD 21 3C 02 73 ?? B4 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule XComp_V098_LZMA_JoKo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 9C 60 E8 75 06 00 00 34 ?? ?? 00 00 00 00 00 00 00 00 00 4C ?? ?? 00 34 ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_V22X_softcompletecom_additional: PEiD
{
    strings:
        $a = { FF E0 E8 04 00 00 00 FF FF FF FF 5E C3 00 }
    condition:
        $a at pe.entry_point

}

rule Mess_107_EXE: PEiD
{
    strings:
        $a = { 4D 45 53 53 B9 FF FF 83 C4 04 F3 26 AC E3 46 EB 50 0D 0A 0D 0A 53 74 6F 6E 65 68 65 61 64 27 73 20 4D 45 53 53 20 76 31 2E 30 37 20 FE 20 52 65 67 67 65 64 20 74 6F 20 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1338_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 57 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule MaskPE_16_yzkzero: PEiD
{
    strings:
        $a = { 36 81 2C 24 ?? ?? ?? 00 C3 60 }
    condition:
        $a at pe.entry_point

}

rule Adlib_Sample_Audio_file: PEiD
{
    strings:
        $a = { 47 4F 4C 44 20 53 41 4D 50 4C 45 }
    condition:
        $a at pe.entry_point

}

rule E_additional: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A7 1A 00 00 B9 6C 1A 00 00 BA 20 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD EC 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule NsPack_30_North_Star_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 66 8B 06 66 83 F8 00 74 15 8B F5 8D B5 ?? ?? FF FF 66 8B 06 66 83 F8 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 }
    condition:
        $a at pe.entry_point

}

rule USSR_V031_SpiritST: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 2E 55 53 53 52 00 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Slowload_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 03 D6 B4 40 CD 21 B8 02 42 33 D2 33 C9 CD 21 8B D6 B9 78 01 }
    condition:
        $a at pe.entry_point

}

rule FSG_v10_additional: PEiD
{
    strings:
        $a = { 23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB F4 00 00 00 EB 02 04 FA EB 01 FA EB 01 5F EB 02 CD 20 8A 16 EB 02 11 31 80 E9 31 EB 02 30 11 C1 E9 11 80 EA 04 EB 02 F0 EA 33 CB 81 EA AB AB 19 08 04 D5 03 C2 80 EA 33 0F B6 C9 0F BE 0E 88 16 EB 01 5F EB 01 6B 46 EB 01 6D 0F BE C0 4B EB 02 CD 20 0F BE C9 2B C9 3B D9 75 B0 EB 01 99 C1 C1 05 91 9D B2 E3 22 E2 A1 E2 F2 22 E2 A0 ?? ?? ?? E2 35 CA EC E2 E2 E2 E4 B4 57 E7 6C F8 28 F4 B4 A5 94 62 15 BD 86 95 E4 E1 F6 06 55 DA 15 AB E1 F6 06 55 FA 15 A2 E1 F6 06 55 03 95 E4 23 92 F2 E1 F6 06 F4 A2 55 DB 57 21 8C CD BE CA 25 E2 E2 E2 0D AD 57 F2 CA 1A E2 E2 E2 CD 0A 8E B3 CA 56 23 F5 AB CD FE 73 2A A3 C2 EA 8E CA 04 E2 E2 E2 1F E2 5F E2 E2 55 EC 62 DE E7 55 E8 65 DA 61 59 E4 }
    condition:
        $a at pe.entry_point

}

rule Solidshield_Protector_V1X_DLL_Solidshield_Technologies: PEiD
{
    strings:
        $a = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF }
    condition:
        $a at pe.entry_point

}

rule InterLok_V5X_PACE_Anti_Piracy_SignByfly: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC A4 00 00 00 53 56 33 F6 57 39 35 ?? ?? ?? ?? 75 53 8D 45 DC 6A 1C 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 05 8B 45 E0 EB 22 8B 7D 08 6A 02 57 FF 15 ?? ?? ?? ?? 85 C0 75 0B 66 81 3F 4D 5A 75 04 8B C7 EB 07 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 48 3C 03 C8 89 ?? ?? ?? ?? ?? EB 06 8B ?? ?? ?? ?? ?? 66 8B 59 16 C1 EB 0D 83 E3 01 74 0A 83 7D 0C 01 0F 85 38 01 00 00 8D 45 F8 50 8D 45 FC 50 E8 47 01 00 00 8B F8 59 3B FE 59 75 52 83 7D FC FF FF 75 F8 75 17 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 0C EB 18 FF 75 FC 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 10 6A 30 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? E9 BB 00 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 57 FF D7 57 6A 01 8B F0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 F6 0F 84 96 00 00 00 83 FE F6 7F 32 74 29 83 FE 97 74 75 83 FE F3 74 18 83 FE F4 74 0C 83 FE F5 75 2B B8 ?? ?? ?? ?? EB 4F B8 ?? ?? ?? ?? EB 48 B8 ?? ?? ?? ?? EB 41 B8 ?? ?? ?? ?? EB 3A 83 FE FA 74 30 83 FE FC 74 24 83 FE FD 74 18 56 8D 45 E0 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 0C 8D 45 E0 EB 13 B8 ?? ?? ?? ?? EB 0C B8 ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? 6A 30 68 ?? ?? ?? ?? 50 6A 00 FF 15 ?? ?? ?? ?? 85 DB 75 08 6A 01 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C2 0C 00 }
        $b = { 55 8B EC 81 EC A4 00 00 00 53 56 33 F6 57 39 35 ?? ?? ?? ?? 75 53 8D 45 DC 6A 1C 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 05 8B 45 E0 EB 22 8B 7D 08 6A 02 57 FF 15 ?? ?? ?? ?? 85 C0 75 0B 66 81 3F 4D 5A 75 04 8B C7 EB 07 56 FF 15 ?? ?? ?? ?? A3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_JDPack_1x_JDProtect_09: PEiD
{
    strings:
        $a = { 60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule The_Norton_Antivirus_Information_file: PEiD
{
    strings:
        $a = { 54 68 65 20 4E 6F 72 74 6F 6E 20 41 6E 74 69 56 69 72 75 73 20 49 6E 66 6F 72 6D 61 74 69 6F 6E 20 46 69 6C 65 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_20_additional: PEiD
{
    strings:
        $a = { 83 EC 0C 53 55 56 57 C7 44 24 10 70 92 40 00 33 DB C6 44 24 14 20 FF 15 2C 70 40 00 53 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 2D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 }
    condition:
        $a at pe.entry_point

}

rule Soft_Defender_v112: PEiD
{
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 BE 01 00 00 03 C8 74 BD 75 BB E8 }
    condition:
        $a at pe.entry_point

}

rule Dropper_Creator_V01_Conflict: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 8D 05 ?? ?? ?? ?? 29 C5 8D 85 ?? ?? ?? ?? 31 C0 64 03 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v20_Ian_Luck: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8B D8 03 ?? 68 54 BC ?? ?? 6A 00 FF 50 18 8B CC 8D A0 54 BC ?? ?? 8B C3 8D 90 E0 15 ?? ?? 68 }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encryptor_v20: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 42 30 40 ?? FF 95 32 35 40 ?? B8 37 30 40 ?? 03 C5 2B 85 1B 34 40 ?? 89 85 27 34 40 ?? 83 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_PEtite_21_emadicius_h: PEiD
{
    strings:
        $a = { B8 00 50 40 00 6A 00 68 BB 21 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 83 C4 04 61 66 9D 64 8F 05 00 00 00 00 83 C4 08 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule PcShare_v40_: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 90 34 40 00 68 B6 28 40 00 64 A1 }
    condition:
        $a at pe.entry_point

}

rule RLPack_v118_Basic_DLL_aPLib_Ap0x_additional: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_or_Borland_Cpp_additional: PEiD
{
    strings:
        $a = { BA ?? ?? 2E 89 16 ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA }
    condition:
        $a at pe.entry_point

}

rule PEBundle_v244_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 83 BD }
    condition:
        $a at pe.entry_point

}

rule Pack_Master_v10: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED D3 22 40 00 E8 04 02 00 00 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 }
    condition:
        $a at pe.entry_point

}

rule UPack_v011_Dwing: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 1C F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9E 0C 10 00 00 B0 01 67 E3 29 8B D7 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Cpp_19901992: PEiD
{
    strings:
        $a = { B8 00 30 CD 21 3C 03 73 ?? 0E 1F BA ?? ?? B4 09 CD 21 06 33 C0 50 CB }
    condition:
        $a at pe.entry_point

}

rule Mew_11_SE_v12_Eng_Northfox_: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C }
    condition:
        $a at pe.entry_point

}

rule Stirling_Archive: PEiD
{
    strings:
        $a = { 13 5D 65 8C 3A }
    condition:
        $a at pe.entry_point

}

rule NTPacker_V2X_ErazerZ: PEiD
{
    strings:
        $a = { 4B 57 69 6E 64 6F 77 73 00 10 55 54 79 70 65 73 00 00 3F 75 6E 74 4D 61 69 6E 46 75 6E 63 74 69 6F 6E 73 00 00 47 75 6E 74 42 79 70 61 73 73 00 00 B7 61 50 4C 69 62 75 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule BIN_Lock_tm_1994_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 31 C0 8E C0 26 ?? ?? ?? ?? ?? ?? 26 ?? ?? ?? ?? 26 ?? ?? ?? ?? ?? ?? 26 ?? ?? ?? ?? 2E ?? ?? ?? ?? ?? ?? 2E ?? ?? ?? ?? CC CD 01 EB }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V31_LiuXingPing_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? ?? ?? 8A 03 3C 00 74 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_C_1988_1989_1990_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FB 8C C9 BB ?? ?? 8E C1 26 ?? ?? ?? ?? 26 ?? ?? ?? 3D ?? ?? 73 ?? B8 ?? ?? 03 D8 8E D1 8B E3 26 ?? ?? ?? ?? 83 ?? ?? 83 ?? ?? 8B D3 D1 EA D1 EA D1 EA D1 EA 8B ?? ?? ?? 8C C0 2B C8 3B D1 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v2xx: PEiD
{
    strings:
        $a = { 60 E8 70 05 ?? ?? EB }
        $b = { A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SVK_Protector_v132_Eng_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
        $b = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
        $c = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule VMProtect_v125_PolyTech_additional: PEiD
{
    strings:
        $a = { 8B 45 00 83 C5 02 66 8B 00 66 89 45 00 E9 A5 06 00 00 8B 45 00 66 8B 55 04 83 C5 06 66 89 10 E9 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V041_cyberbob_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 02 D2 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F ?? ?? ?? ?? ?? BB ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 ?? 68 3C 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 59 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 ?? E8 1A 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_302: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 89 E5 8D 9C }
    condition:
        $a at pe.entry_point

}

rule Vaccine_103_110: PEiD
{
    strings:
        $a = { FA 33 DB B9 00 00 0E 1F 33 F6 FC AD 35 00 00 03 D8 E2 F8 81 FB 00 00 74 42 E8 26 00 94 A0 A9 AB 20 A8 A7 AC A5 AD A5 AD 21 20 8F E0 AE A4 AE AB A6 A0 E2 EC 20 28 79 2F 6E 29 3F 20 07 24 00 01 00 00 B4 09 5A 8B F2 CD 21 C6 04 02 B4 0A CD 21 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v21_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB }
    condition:
        $a at pe.entry_point

}

rule Hyings_PE_Armor_075exe_Hying_CCG_h: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 42 6F 47 5F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C9 }
        $b = { 00 00 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 00 ?? ?? 01 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 74 ?? ?? ?? 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Enigma_protector_112_Vladimir_Sukhov_h_additional: PEiD
{
    strings:
        $a = { 55 46 41 C6 D2 C1 00 00 }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_04_beta_1_by_Alex: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 }
    condition:
        $a at pe.entry_point

}

rule Upack_v036_alpha_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { AB E2 E5 5D 59 8B 76 68 51 59 46 AD 85 C0 }
    condition:
        $a at pe.entry_point

}

rule ComProtector_10: PEiD
{
    strings:
        $a = { B9 00 00 BB 03 01 BF 00 01 2E 8A 07 34 B9 FE C8 C0 C0 9A 2E 88 05 2E 00 0D 2E 00 2D 47 43 E2 E9 B9 CD 01 E8 00 00 5B 83 C3 12 90 2E C0 07 A4 2E 30 0F 2E 30 2F 43 E2 F3 42 DC AC 09 94 A0 C0 6C D7 BC 2C 0F 00 A2 6B F2 0F CD 7D ED AC 89 29 99 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v22_wwwun4seencompetite: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        $a at pe.entry_point

}

rule WWPack32_v100_v111_v112_v120_additional: PEiD
{
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_25_: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A7 1A 00 00 B9 6C 1A 00 00 BA 20 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD EC 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule Vx_Lehigh555_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5E 83 ?? ?? 8B DE 81 ?? ?? ?? 53 81 ?? ?? ?? B4 19 CD 21 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B4 4A CD 21 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_JDPack_1x_JDProtect_09_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule UPX_Scrambler_RC_v1x: PEiD
{
    strings:
        $a = { 90 61 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF }
        $b = { 66 C7 05 ?? ?? ?? ?? 75 07 E9 ?? FE FF FF 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule RLPack_V121_aPlib_043_ap0x_20080504: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 D6 05 00 00 EB 0C 8B 85 D2 05 00 00 89 85 D6 05 00 00 E8 4C 01 00 00 8D B5 FE 05 00 00 8D 9D 85 04 00 00 33 FF E8 77 01 00 00 EB 1B 8B 85 D6 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD E2 05 00 00 00 74 0E 83 BD E6 05 00 00 00 74 05 E8 15 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 6B 05 00 00 89 85 FA 05 00 00 5B FF B5 FA 05 00 00 56 FF D3 83 C4 08 8B B5 FA 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 EB 6E 56 FF 95 63 05 00 00 0B C0 75 05 E8 08 03 00 00 85 C0 0F 84 95 00 00 00 89 85 F2 05 00 00 8B C6 EB 2A 8B 85 F6 05 00 00 8B 00 50 FF B5 F2 05 00 00 E8 50 02 00 00 85 C0 74 73 89 07 83 85 F6 05 00 00 04 83 C7 04 8B 85 F6 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 80 3E 01 75 8D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 FA 05 00 00 FF 95 6F 05 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 FA 05 00 00 FF 95 6F 05 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule DWC_Archive: PEiD
{
    strings:
        $a = { 44 57 43 }
    condition:
        $a at pe.entry_point

}

rule UPX_v0896_v102_v105_v122_Delphi_stub_Laszlo_Markus: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? C7 87 ?? ?? ?? ?? ?? ?? ?? ?? 57 83 CD FF EB 0E ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B }
    condition:
        $a at pe.entry_point

}

rule Goats_PE_Mutilator_16: PEiD
{
    strings:
        $a = { E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_06_additional: PEiD
{
    strings:
        $a = { FA B8 ?? ?? BE ?? ?? 33 F0 0E 17 2E ?? ?? ?? BA ?? ?? 87 E6 5B 33 DC }
    condition:
        $a at pe.entry_point

}

rule nBinder_v40: PEiD
{
    strings:
        $a = { 5C 6E 62 34 5F 74 6D 70 5F 30 31 33 32 34 35 34 33 35 30 5C 00 00 00 00 00 00 00 00 00 E9 55 43 4C FF 01 1A 00 00 00 00 96 30 07 77 2C 61 0E EE BA 51 09 99 19 C4 6D 07 8F F4 6A 70 35 A5 63 E9 A3 95 64 9E 32 88 DB 0E A4 B8 DC 79 }
        $b = { 5C 6E 6D 72 5F 74 65 6D 70 2E 6E 6D 72 00 00 00 72 62 00 00 58 C7 41 00 10 F8 41 00 11 01 00 00 00 00 00 00 46 E1 00 00 46 E1 00 00 35 00 00 00 F6 88 41 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WATCOM_CCpp: PEiD
{
    strings:
        $a = { 53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F }
        $b = { E9 ?? ?? ?? ?? ?? ?? ?? ?? 57 41 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PackItBitch_V10_archphase_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Spanz_additional: PEiD
{
    strings:
        $a = { E8 00 00 5E 81 EE ?? ?? 8D 94 ?? ?? B4 1A CD 21 C7 84 }
    condition:
        $a at pe.entry_point

}

rule Windows_PIF_file: PEiD
{
    strings:
        $a = { 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 02 }
    condition:
        $a at pe.entry_point

}

rule LY_WGKX_V2X_wwwszleyucom_SignByfly_20080122: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 01 00 4D 79 46 75 6E 00 62 73 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_Modified_Stub_b_Farb_rausch_Consumer_Consulting: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC }
    condition:
        $a at pe.entry_point

}

rule Ningishzida_10_CyberDoom: PEiD
{
    strings:
        $a = { 9C 60 96 E8 00 00 00 00 5D 81 ED 03 25 40 00 B9 04 1B 00 00 8D BD 4B 25 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        $a at pe.entry_point

}

rule PCIENC_Cryptor: PEiD
{
    strings:
        $a = { 06 50 43 49 45 4E }
    condition:
        $a at pe.entry_point

}

rule FileShield_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 50 1E EB ?? 90 00 00 8B D8 }
    condition:
        $a at pe.entry_point

}

rule vprotector_12_vcasm_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_WATCOM_CCpp_EXE: PEiD
{
    strings:
        $a = { E9 00 00 00 00 90 90 90 90 57 41 E9 }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V30_LiuXingPing_additional: PEiD
{
    strings:
        $a = { 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? E9 ?? ?? E8 ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Vx_Backfont900_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? B4 30 CD 21 3C 03 ?? ?? B8 ?? ?? BA ?? ?? CD 21 81 FA ?? ?? ?? ?? BA ?? ?? 8C C0 48 8E C0 8E D8 80 ?? ?? ?? 5A ?? ?? 03 ?? ?? ?? 40 8E D8 80 ?? ?? ?? 5A ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule ARJ_SFX_Custom_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8D 90 5C 01 00 00 68 00 00 40 00 83 3A 00 0F 84 C6 C1 FF FF 8B 04 24 8B 0A 0F BA F1 1F 73 13 FD 8B F0 8B F8 03 72 04 03 7A 08 F3 A5 83 C2 0C FC EB D9 83 C2 10 8B 5A }
    condition:
        $a at pe.entry_point

}

rule Upack_010_012_beta_Dwing: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 }
    condition:
        $a at pe.entry_point

}

rule StarForce_ProActive_11_StarForce_Technology_additional: PEiD
{
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 }
    condition:
        $a at pe.entry_point

}

rule Petite_21: PEiD
{
    strings:
        $a = { 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8 }
    condition:
        $a at pe.entry_point

}

rule Petite_20: PEiD
{
    strings:
        $a = { B8 00 00 00 00 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 18 8B CC 8D A0 54 BC 00 00 8B C3 8D 90 E0 15 00 00 68 00 00 00 00 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 E3 00 00 FF 8B }
    condition:
        $a at pe.entry_point

}

rule ActiveMARKTM_R5311140_Trymedia_additional: PEiD
{
    strings:
        $a = { 79 07 0F B7 07 47 50 47 B9 57 48 F2 AE 55 FF 96 84 ?? 00 00 09 C0 74 07 89 03 83 C3 04 EB D8 FF 96 88 ?? 00 00 61 E9 ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1400_Obsidium_Software_20091005: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? 50 EB 02 ?? ?? E8 ?? 00 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 71 49 EB 01 ?? EB 03 ?? ?? ?? 33 C0 EB 01 ?? 64 FF 30 EB 01 ?? 64 89 20 EB 02 ?? ?? EB 02 ?? ?? 8B 00 EB 03 ?? ?? ?? 58 EB 02 ?? ?? C3 EB 03 ?? ?? ?? E9 ?? 00 00 00 EB 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 03 ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Themida_18xx_Oreans_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D 37 ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 }
    condition:
        $a at pe.entry_point

}

rule WinUpack_v030_beta_By_Dwing_h_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_V020_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 67 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 E9 07 01 00 00 8B 5D 0C 83 C2 30 FF 16 73 53 83 C2 30 FF 16 72 1B 83 C2 30 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C B1 80 8A 00 EB CF 83 C2 60 FF 16 87 5D 10 73 0D 83 C2 30 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 95 7C 07 00 00 FF 56 0C 5B 91 E9 9C 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE32Pack_v139_SteelBytes: PEiD
{
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? 00 ?? ?? 00 3B DB 74 01 BE 5D 8B D5 81 ED EC 8D 40 00 }
    condition:
        $a at pe.entry_point

}

rule USERNAME_v300_Hint_DOS_EP_additional: PEiD
{
    strings:
        $a = { FB 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 8C C8 2B C1 8B C8 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 33 C0 8E D8 06 0E 07 FC 33 F6 }
    condition:
        $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_One_layer_encryption_MANtiCORE: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? 00 B9 ?? 01 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3 }
    condition:
        $a at pe.entry_point

}

rule MarjinZ_EXE_Scrambler_SE_by_MarjinZ: PEiD
{
    strings:
        $a = { E8 A3 02 00 00 E9 35 FD FF FF FF 25 C8 20 00 10 6A 14 68 C0 21 00 10 E8 E4 01 00 00 FF 35 7C 33 00 10 8B 35 8C 20 00 10 FF D6 59 89 45 E4 83 F8 FF 75 0C FF 75 08 FF 15 88 20 00 10 59 EB 61 6A 08 E8 02 03 00 00 59 83 65 FC 00 FF 35 7C 33 00 10 FF D6 89 45 E4 FF 35 78 33 00 10 FF D6 89 45 E0 8D 45 E0 50 8D 45 E4 50 FF 75 08 E8 D1 02 00 00 89 45 DC FF 75 E4 8B 35 74 20 00 10 FF D6 A3 7C 33 00 10 FF 75 E0 FF D6 83 C4 1C A3 78 33 00 10 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 DC E8 A0 01 00 00 C3 }
        $b = { E8 A3 02 00 00 E9 35 FD FF FF FF 25 C8 20 00 10 6A 14 68 C0 21 00 10 E8 E4 01 00 00 FF 35 7C 33 00 10 8B 35 8C 20 00 10 FF D6 59 89 45 E4 83 F8 FF 75 0C FF 75 08 FF 15 88 20 00 10 59 EB 61 6A 08 E8 02 03 00 00 59 83 65 FC 00 FF 35 7C 33 00 10 FF D6 89 45 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule X_Pack_v142: PEiD
{
    strings:
        $a = { 72 ?? C3 8B DE 83 ?? ?? C1 ?? ?? 8C D8 03 C3 8E D8 8B DF 83 ?? ?? C1 ?? ?? 8C C0 03 C3 8E C0 C3 }
    condition:
        $a at pe.entry_point

}

rule UPX_Modified_Stub_c_Farb_rausch_Consumer_Consulting: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF FC B2 80 E8 00 00 00 00 5B 83 C3 66 A4 FF D3 73 FB 31 C9 FF D3 73 14 31 C0 FF D3 73 1D 41 B0 10 FF D3 10 C0 73 FA 75 3C AA EB E2 E8 4A 00 00 00 49 E2 10 E8 40 00 00 00 EB 28 AC D1 E8 74 45 11 C9 EB 1C 91 48 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt_WinRAR_SFX_additional: PEiD
{
    strings:
        $a = { EB 01 02 EB 02 CD 20 B8 80 ?? 42 00 EB 01 55 BE F4 00 00 00 13 DF 13 D8 0F B6 38 D1 F3 F7 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_v190g_Risco_software_Inc: PEiD
{
    strings:
        $a = { 60 0F 87 02 00 00 00 1B F8 E8 01 00 00 00 73 83 04 24 06 C3 }
    condition:
        $a at pe.entry_point

}

rule ExeTools_COM2EXE: PEiD
{
    strings:
        $a = { E8 ?? ?? 5D 83 ED ?? 8C DA 2E 89 96 ?? ?? 83 C2 ?? 8E DA 8E C2 2E 01 96 ?? ?? 60 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_71_additional: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 39 75 0C 0F 84 ?? ?? ?? ?? 33 C0 40 5E 5D C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule ASPack_102b: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 96 78 43 00 B8 90 78 43 00 03 C5 2B 85 7D 7C 43 00 89 85 89 7C 43 00 80 BD 74 7C 43 00 00 75 15 FE 85 74 7C 43 00 E8 1D 00 00 00 E8 F7 01 00 00 E8 8E 02 00 00 8B 85 75 7C 43 00 03 85 89 7C 43 00 89 44 24 1C 61 FF }
    condition:
        $a at pe.entry_point

}

rule PKLite_150_COM: PEiD
{
    strings:
        $a = { 50 B8 00 00 BA 00 00 3B C4 73 79 8B C4 2D 42 03 25 F0 FF 8B F8 B9 A1 00 BE 8E 01 FC F3 A5 8B D8 B1 04 D3 EB 8C D9 03 D9 53 33 DB 53 CB 90 32 01 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_vxx_DLL: PEiD
{
    strings:
        $a = { 9C 60 50 8D 88 00 ?? ?? ?? 8D 90 ?? ?? 00 00 8B DC 8B E1 68 00 00 ?? ?? 53 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 DA 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 72 04 03 7A 08 8B 0A F3 A5 83 C2 0C FC EB D4 8B 7A 08 03 F8 8B 5A 04 85 DB 74 13 52 53 57 03 02 50 E8 7B 00 00 00 85 C0 74 2E 5F 5F 58 5A 8B 4A 0C C1 F9 02 F3 AB 8B 4A 0C 83 E1 03 F3 AA 83 C2 10 EB A0 45 52 52 4F 52 21 00 43 6F 72 72 75 70 74 20 44 61 74 61 21 00 8B 64 24 24 8B 04 24 83 C4 26 8B D0 66 81 C2 6D 01 6A 10 8B D8 66 05 66 01 50 52 6A 00 8B 13 FF 14 1A 6A FF FF 93 ?? ?? 00 00 56 57 8B 7C 24 0C 8B 74 24 10 8B 4C 24 14 C1 F9 02 F3 A5 8B 4C 24 14 83 E1 03 F3 A4 5F 5E C3 }
        $b = { 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PESpin_v1304_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 CD 4E 40 00 8B 42 3C 03 C2 89 85 D7 4E 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D EB 4E 40 00 53 8F 85 E1 4C 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD 90 4F 40 00 8D 5B 04 8B 1B 89 9D 95 4F 40 00 E8 00 00 00 00 58 01 68 05 68 D3 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC FF 25 10 BB ?? 00 00 00 B9 84 12 00 00 8D BD C6 4F 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C EB 04 01 EB 0? }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_v168_v184_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 87 DD 8B 85 E6 90 40 01 85 33 90 40 66 C7 85 90 40 90 90 01 85 DA 90 40 01 85 DE 90 40 01 85 E2 90 40 BB 7B 11 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_V80_Debug: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v250_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B8 ?? ?? ?? 68 F8 ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 20 ?? ?? ?? 33 D2 8A D4 89 15 D0 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_R_Full_text_index_file: PEiD
{
    strings:
        $a = { 6C 6C 2D 74 65 78 74 20 69 6E 64 65 78 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2501_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A8 1A 00 00 B9 6D 1A 00 00 BA 21 1B 00 00 BE 00 10 00 00 BF C0 53 00 00 BD F0 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule Windows_9x_User_password_file: PEiD
{
    strings:
        $a = { E3 82 85 96 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Lockless_Intro_Pack: PEiD
{
    strings:
        $a = { 2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD }
    condition:
        $a at pe.entry_point

}

rule DEF_v10_additional: PEiD
{
    strings:
        $a = { BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? 10 40 00 C3 }
    condition:
        $a at pe.entry_point

}

rule Unpacked_BS_SFX_Archive_v19: PEiD
{
    strings:
        $a = { 1E 33 C0 50 B8 ?? ?? 8E D8 FA 8E D0 BC ?? ?? FB B8 ?? ?? CD 21 3C 03 73 }
    condition:
        $a at pe.entry_point

}

rule HideProtect_V1016C_SoftWar_Company_SignByfly: PEiD
{
    strings:
        $a = { 90 90 90 E9 D8 }
    condition:
        $a at pe.entry_point

}

rule Vx_Eddie1530_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? FC 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 2E ?? ?? ?? ?? 50 06 56 1E 33 C0 50 1F C4 ?? ?? ?? 2E ?? ?? ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule Obsidium_10061_Obsidium_Software: PEiD
{
    strings:
        $a = { E8 AF 1C 00 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V10_V12_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 }
    condition:
        $a at pe.entry_point

}

rule HackStop_117EXE: PEiD
{
    strings:
        $a = { 52 B8 02 30 1E CD 21 86 E0 3D FE 02 73 02 CD 20 0E 1F B4 09 E8 03 00 24 24 EA 5A CD 21 EB 02 D8 88 1F 5A 53 BB EB 04 5B EB FB 9A B4 30 CD 21 FA 8B EC 8B 46 FA 05 0C 00 FF E0 81 EB 02 EB F0 81 46 FA 1A 00 83 EC 06 CF 82 B0 AD E6 64 53 BB EB }
    condition:
        $a at pe.entry_point

}

rule PENinja_modified: PEiD
{
    strings:
        $a = { 5D 8B C5 81 ED B2 2C 40 00 2B 85 94 3E 40 00 2D 71 02 00 00 89 85 98 3E 40 00 0F B6 B5 9C 3E 40 00 8B FD }
    condition:
        $a at pe.entry_point

}

rule PEBundle_v20b5_v23: PEiD
{
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 01 AD ?? ?? ?? ?? 01 AD }
    condition:
        $a at pe.entry_point

}

rule RCC_II286_v102_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA BD ?? ?? 93 C8 ?? ?? ?? 54 62 E9 }
    condition:
        $a at pe.entry_point

}

rule NsPack_34_North_Star: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF 80 38 01 0F 84 42 02 00 00 C6 00 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 ?? ?? FF FF FF B5 ?? ?? FF FF 8B D6 8B CF 8B 85 ?? ?? FF FF 05 AA 05 00 00 FF D0 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB C5 }
        $b = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF 80 38 01 0F 84 42 02 00 00 C6 00 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Mew_10_V10_Eng_Northfox: PEiD
{
    strings:
        $a = { 33 C0 E9 ?? ?? FF FF }
    condition:
        $a at pe.entry_point

}

rule North_Star_PE_Shrinker_v13_by_Liuxingping: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 73 ?? FF FF 8B 06 83 F8 00 74 11 8D B5 7F ?? FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 4F ?? FF FF 2B D0 89 95 4F ?? FF FF 01 95 67 ?? FF FF 8D B5 83 ?? FF FF 01 }
        $b = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 73 ?? FF FF 8B 06 83 F8 00 74 11 8D B5 7F ?? FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 4F ?? FF FF 2B D0 89 95 4F ?? FF FF 01 95 67 ?? FF FF 8D B5 83 ?? FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 A3 ?? FF FF 85 C0 0F 84 06 03 00 00 89 85 63 ?? FF FF E8 00 00 00 00 5B B9 31 89 40 00 81 E9 2E 86 40 00 03 D9 50 53 E8 3D 02 00 00 61 03 BD 47 ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 A7 ?? FF FF FF B5 A3 ?? FF FF 56 57 FF 95 63 ?? FF FF 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB CE 68 00 80 00 00 6A 00 FF B5 63 ?? FF FF FF 95 A7 ?? FF FF 8D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PAK_SFX_Archive_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 55 8B EC 83 ?? ?? A1 ?? ?? 2E ?? ?? ?? 2E ?? ?? ?? ?? ?? 8C D7 8E C7 8D ?? ?? BE ?? ?? FC AC 3C 0D }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1339_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 28 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 CF 27 00 00 }
        $b = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 28 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PKLITE32_v11: PEiD
{
    strings:
        $a = { 55 8B EC A1 ?? ?? ?? ?? 85 C0 74 09 B8 01 00 00 00 5D C2 0C 00 8B 45 0C 57 56 53 8B 5D 10 }
        $b = { 55 8B EC A1 ?? ?? ?? ?? 85 C0 74 09 B8 01 ?? ?? ?? 5D C2 0C ?? 8B 45 0C 57 56 53 8B 5D 10 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule dxp_Decrementing_1_byte_XOR_at_OEP: PEiD
{
    strings:
        $a = { ?? ?? 83 EC ?? D9 34 24 8B 44 24 ?? ?? ?? ?? BF ?? ?? ?? ?? 8A 17 ?? ?? 8B C8 81 E1 ?? ?? ?? ?? EB ?? ?? ?? 30 10 FE CA 48 49 }
    condition:
        $a at pe.entry_point

}

rule Upack_v010_v012Beta_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SDProtector_Pro_Edition_116_Randy_Li_h: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41 }
        $b = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 93 03 00 00 03 C8 74 C4 75 C2 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_239_DLL_compressed_resources_additional: PEiD
{
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 C1 C0 0F E9 ?? ?? ?? 00 87 04 24 58 89 45 FC E9 ?? ?? ?? FF FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 18 E9 ?? ?? ?? ?? 8B 55 08 09 42 F8 E9 ?? ?? ?? FF 83 7D F0 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 34 24 5E 8B 45 FC 33 D2 56 8B F2 E9 ?? ?? ?? 00 BA ?? ?? ?? ?? E8 ?? ?? ?? 00 A3 ?? ?? ?? ?? C3 E9 ?? ?? ?? 00 C3 83 C4 04 C3 E9 ?? ?? ?? FF 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 E8 ?? ?? ?? 00 E9 ?? ?? ?? FF C1 C2 03 81 CA ?? ?? ?? ?? 81 C2 ?? ?? ?? ?? 03 C2 5A E9 ?? ?? ?? FF 81 E7 ?? ?? ?? ?? 81 EF ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? 89 07 E9 ?? ?? ?? ?? 0F 89 ?? ?? ?? ?? 87 14 24 5A 50 C1 C8 10 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_V3104_V3332_Thinstall_Company_20080318: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB CC 1A 00 00 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 C8 00 00 00 E8 2C FF FF FF E9 ?? FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 C3 B9 08 00 00 00 E8 01 00 00 00 C3 33 C0 E8 E1 FF FF FF 13 C0 E2 F7 C3 33 C9 41 E8 D4 FF FF FF 13 C9 E8 CD FF FF FF 72 F2 C3 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_112_Vladimir_Sukhov: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E EB 04 ?? ?? ?? ?? B8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 01 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 05 F6 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 B9 44 1A }
        $b = { 60 E8 00 00 00 00 5D 83 C5 FA 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
        $c = { 60 E8 00 00 00 00 5D 83 C5 FA 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E EB 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_200_30X_Markus_Oberhumer_amp_Laszlo_Molnar_amp_John_Reiser: PEiD
{
    strings:
        $a = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF ?? ?? ?? ?? ?? 95 8A 07 47 08 C0 74 DC 89 F9 57 48 F2 AE 55 FF ?? ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB E1 FF ?? ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? ?? ?? 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 E9 }
        $b = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_Pack_Master_10_PEX_Clone_additional: PEiD
{
    strings:
        $a = { 60 E8 01 01 00 00 E8 83 C4 04 E8 01 90 90 90 E9 5D 81 ED D3 22 40 90 E8 04 02 90 90 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FF FF E9 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v21: PEiD
{
    strings:
        $a = { 60 E9 3D }
        $b = { 60 E8 72 05 00 00 EB 33 87 DB 90 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cue_60: PEiD
{
    strings:
        $a = { EB 02 CD 20 ?? CF ?? ?? 80 ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b6_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 9A 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 01 85 92 60 40 ?? BB 14 }
    condition:
        $a at pe.entry_point

}

rule nPack_v11xxx_NEOx: PEiD
{
    strings:
        $a = { 83 3D ?? ?? ?? 00 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 08 ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 ?? 02 00 00 E8 ?? 06 00 00 E8 ?? 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? 00 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 }
    condition:
        $a at pe.entry_point

}

rule BJFnt_v13_additional: PEiD
{
    strings:
        $a = { EB ?? 2E 90 ?? ?? 8C DB 8C CA 8E DA FA 8B EC BE ?? ?? BC ?? ?? BF }
    condition:
        $a at pe.entry_point

}

rule DrHalo_or_DrGenius_Palette_Graphics_format: PEiD
{
    strings:
        $a = { 41 48 E3 00 00 00 0A 00 }
    condition:
        $a at pe.entry_point

}

rule LHA_SFX_Archive_v205_v213_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? FC BC ?? ?? 8C C8 05 ?? ?? 8E C0 EB ?? ?? ?? ?? ?? E8 ?? ?? 06 1F B4 30 CD 21 8B D8 1E 3C 03 72 ?? 36 ?? ?? ?? ?? 33 C0 8B F8 B9 }
    condition:
        $a at pe.entry_point

}

rule Exe_Locker_v10_IonIce: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 8B 6C 24 20 81 ED 05 00 00 00 3E 8F 85 6C 00 00 00 3E 8F 85 68 00 00 00 3E 8F 85 64 00 00 00 3E 8F 85 60 00 00 00 3E 8F 85 5C 00 00 00 3E 8F 85 58 00 00 00 3E 8F 85 54 00 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_TrojanShock_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? BE ?? ?? E8 ?? ?? B2 00 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? BE ?? ?? E8 ?? ?? B8 00 4C CD 21 ?? 50 52 AC }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1333_Obsidium_Software_SignByhaggar: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 27 }
    condition:
        $a at pe.entry_point

}

rule NoobyProtect_SE_Public_V1200_Nooby_20090201: PEiD
{
    strings:
        $a = { E9 ?? 00 00 00 4E 6F 6F 62 79 50 72 6F 74 65 63 74 20 53 45 20 31 2E 32 2E 30 2E 30 }
    condition:
        $a at pe.entry_point

}

rule BlackEnergy_DDoS_Bot_Crypter: PEiD
{
    strings:
        $a = { 55 ?? ?? 81 EC 1C 01 00 00 53 56 57 6A 04 BE 00 30 00 00 56 FF 35 00 20 11 13 6A 00 E8 ?? 03 00 00 ?? ?? 83 C4 10 ?? FF 89 7D F4 0F }
    condition:
        $a at pe.entry_point

}

rule FishPE_V10X_hellfish_Sign_by_fly: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? C3 90 09 00 00 00 2C 00 00 00 ?? ?? ?? ?? C4 03 00 00 BC A0 00 00 00 40 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 99 00 00 00 00 8A 00 00 00 10 00 00 ?? ?? 00 00 ?? ?? ?? ?? 00 00 02 00 00 00 A0 00 00 18 01 00 00 ?? ?? ?? ?? 00 00 0C 00 00 00 B0 00 00 38 0A 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 C0 00 00 40 39 00 00 ?? ?? ?? ?? 00 00 08 00 00 00 00 01 00 C8 06 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_v17_Exeshield_Corp: PEiD
{
    strings:
        $a = { EB 06 68 90 1F 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 }
    condition:
        $a at pe.entry_point

}

rule SciFax_Graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 44 54 3D 00 }
    condition:
        $a at pe.entry_point

}

rule PeX_v099_Eng_bartCrackPl: PEiD
{
    strings:
        $a = { E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
        $b = { E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 50 65 58 20 28 63 29 20 62 79 20 62 61 72 74 5E 43 72 61 63 6B 50 6C 20 62 65 74 61 20 72 65 6C 65 61 73 65 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 60 E8 01 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Shrinker_34: PEiD
{
    strings:
        $a = { 55 8B EC 56 57 75 6B 68 00 01 00 00 E8 11 0B 00 00 83 C4 04 }
    condition:
        $a at pe.entry_point

}

rule Shrinker_33: PEiD
{
    strings:
        $a = { 00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Shrinker_32: PEiD
{
    strings:
        $a = { 55 8B EC 56 57 75 65 68 00 01 00 00 E8 F1 E6 FF FF 83 C4 04 }
    condition:
        $a at pe.entry_point

}

rule CipherWall_Self_ExtratorDecryptor_Console_v15: PEiD
{
    strings:
        $a = { 90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 0B 6E 5B 9B 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 }
        $b = { 90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 0B 6E 5B 9B 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 12 10 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 06 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Borland_Delphi_3_Portions_Copyright_c_198397_Borland: PEiD
{
    strings:
        $a = { 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 37 20 42 6F 72 6C 61 6E 64 00 }
    condition:
        $a at pe.entry_point

}

rule Norton_Speed_Disk_Configuration_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4E 6F 72 74 6F 6E 20 53 70 65 65 64 }
    condition:
        $a at pe.entry_point

}

rule yzpack_V20_UsAr_Sign_by_fly: PEiD
{
    strings:
        $a = { 25 ?? ?? ?? ?? 61 87 CC 55 45 45 55 81 ED CA 00 00 00 55 A4 B3 02 FF 14 24 73 F8 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 1F B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3C AA EB DC FF 54 24 04 2B CB 75 0F FF 54 24 08 EB 27 AC D1 E8 74 30 13 C9 EB 1B 91 48 C1 E0 08 AC FF 54 24 08 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 99 BD ?? ?? ?? ?? FF 65 28 }
    condition:
        $a at pe.entry_point

}

rule Histogram_graphics_file: PEiD
{
    strings:
        $a = { 6D 68 77 61 6E 68 00 04 01 02 01 02 }
    condition:
        $a at pe.entry_point

}

rule CALS_Raster_graphics_format_additional: PEiD
{
    strings:
        $a = { 73 72 63 64 6F 63 69 64 3A 20 }
    condition:
        $a at pe.entry_point

}

rule FSG_131_Eng_dulekxt: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80 A4 B6 80 FF D3 73 F9 33 C9 FF D3 73 16 33 C0 FF D3 73 23 B6 80 41 B0 10 FF D3 12 C0 73 FA 75 42 AA EB E0 E8 46 00 00 00 02 F6 83 D9 01 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 48 13 C9 EB }
        $b = { C1 E0 06 EB 02 CD 20 EB 01 27 EB 01 24 BE 80 ?? 42 00 49 EB 01 99 8D 1D F4 00 00 00 EB 01 5C F7 D8 1B CA EB 01 31 8A 16 80 E9 41 EB 01 C2 C1 E0 0A EB 01 A1 81 EA A8 8C 18 A1 34 46 E8 01 00 00 00 62 59 32 D3 C1 C9 02 EB 01 68 80 F2 1A 0F BE C9 F7 D1 2A D3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_MinGW_GCC_2x_Anorganix: PEiD
{
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 }
    condition:
        $a at pe.entry_point

}

rule GIF89a_Graphics_format: PEiD
{
    strings:
        $a = { 47 49 46 38 39 61 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32_Bczi_Gor_Pierre_Muller_Peter_Vreman: PEiD
{
    strings:
        $a = { C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 00 E8 C5 01 00 00 89 D8 E8 3E 02 00 00 E8 B9 01 00 00 E8 54 02 00 00 8B 5D FC C9 C3 8D 76 00 00 00 00 00 00 00 00 00 00 00 00 00 55 89 E5 C6 05 10 80 40 00 00 E8 D1 03 00 00 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? 70 40 00 55 31 ED 89 E0 A3 20 80 40 00 66 8C D5 89 2D 30 80 40 00 E8 B9 03 00 00 31 ED E8 72 FF FF FF 5D E8 BC 03 00 00 C9 C3 00 00 00 00 00 00 00 00 00 00 55 89 E5 83 EC 08 E8 15 04 00 00 A1 ?? 70 40 00 89 45 F8 B8 01 00 00 00 89 45 FC 3B 45 F8 7F 2A FF 4D FC 90 FF 45 FC 8B 45 FC 83 3C C5 ?? 70 40 00 00 74 09 8B 04 C5 ?? 70 40 }
        $b = { 55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Compiler_additional: PEiD
{
    strings:
        $a = { 8C C3 83 C3 10 2E 01 1E ?? 02 2E 03 1E ?? 02 53 1E }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Basic_v50v60: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 00 00 00 00 00 00 30 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_V038_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5B 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? 69 ED 00 0C 00 00 8D AC 2B 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 50 33 C9 E9 FB 00 00 00 04 F9 1A C0 B1 30 8B 6B 08 03 D1 FF 16 73 49 03 D1 FF 16 72 17 03 D1 FF 16 72 27 24 02 04 09 50 8B C7 2B 43 08 8A 00 E9 CD 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 24 03 04 08 50 55 8D 93 78 07 00 00 FF 56 54 5D 91 E9 95 00 00 00 24 03 04 07 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 54 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 4C 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 10 }
    condition:
        $a at pe.entry_point

}

rule Trainer_Creation_Kit_5_Trainer: PEiD
{
    strings:
        $a = { 6A 00 68 80 00 00 00 6A 02 6A 00 6A 00 68 00 00 00 40 68 25 45 40 00 E8 3C 02 00 00 50 6A 00 68 40 45 40 00 68 00 10 00 00 68 00 30 40 00 50 E8 54 02 00 00 58 50 E8 17 02 00 00 6A 00 E8 2E 02 00 00 A3 70 45 40 00 68 25 45 40 00 E8 2B 02 00 00 A3 30 45 40 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1337_20070623_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 27 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 23 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 01 ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 01 ?? E8 F7 26 00 00 }
    condition:
        $a at pe.entry_point

}

rule Reflexive_Arcade_Installer: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 98 48 42 00 68 B4 DC 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 08 31 42 00 33 D2 8A D4 89 15 8C CA 42 00 8B C8 81 E1 FF 00 00 00 89 0D }
    condition:
        $a at pe.entry_point

}

rule DoPs_CryptExe_104: PEiD
{
    strings:
        $a = { 8B DC EB 01 EA BC 03 00 EB 01 EA 83 FC 03 74 05 EB 01 EA CD 20 EB 01 EA 8B E3 2E 89 26 13 00 EB 01 EA E8 C1 01 EA 2E 8B 26 13 00 1E 33 C0 8E D8 FA FF 06 06 00 2E F7 06 00 00 EB 00 FF 0E 06 00 FB 1F 2E 8C 1E 15 00 2E 8C 16 11 00 2E 89 26 13 }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_20_junkcode_additional: PEiD
{
    strings:
        $a = { EB 25 00 00 F7 BF 00 00 00 00 00 00 00 00 00 00 12 00 E8 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 00 00 E8 00 00 00 00 5D 81 ED 2C 10 40 00 8D B5 14 10 40 00 E8 33 00 00 00 89 85 10 10 40 00 BF 00 00 40 00 8B F7 03 7F 3C 8B 4F 54 51 56 8D 85 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v120_extra_3_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? 8B FC 81 ?? ?? ?? 57 57 52 80 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_104_Win32_Berczi_Gabor_Pierre_Muller_Peter_Vreman_: PEiD
{
    strings:
        $a = { 55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? DB E3 D9 2D ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version_Anorganix_additional: PEiD
{
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule codeCrypter_031_Tibbar: PEiD
{
    strings:
        $a = { 50 58 53 5B 90 BB ?? ?? ?? 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule PoPa_001_Packer_on_Pascal_bagie: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 A4 3E 00 10 E8 30 F6 FF FF 33 C0 55 68 BE 40 00 10 ?? ?? ?? ?? 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 62 E7 FF FF 8B 45 EC E8 32 F2 FF FF 50 E8 B4 F6 FF FF A3 64 66 00 10 33 D2 55 68 93 40 00 10 64 FF 32 64 89 22 83 3D 64 66 00 10 FF 0F 84 3A 01 00 00 6A 00 6A 00 6A 00 A1 64 66 00 10 50 E8 9B F6 FF FF 83 E8 10 50 A1 64 66 00 10 50 E8 BC F6 FF FF 6A 00 68 80 66 00 10 6A 10 68 68 66 00 10 A1 64 66 00 10 50 E8 8B F6 FF FF }
        $b = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 A4 3E 00 10 E8 30 F6 FF FF 33 C0 55 68 BE 40 00 10 ?? ?? ?? ?? 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 62 E7 FF FF 8B 45 EC E8 32 F2 FF FF 50 E8 B4 F6 FF FF A3 64 66 00 10 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Go32Stub_v200T_DOS_Extender_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 3C }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Morphine_12_Anorganix_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 E2 90 90 90 EB 08 82 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v25_Retail_Slim_Loader_Bitsum_Technologies_: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30xx_Jitit_Software: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 00 00 00 01 68 00 ?? 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 }
    condition:
        $a at pe.entry_point

}

rule UPX_070_PE_DLL: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 99 01 00 00 60 E8 00 00 00 00 58 83 E8 48 50 8D B8 00 00 00 FF 57 66 81 87 00 00 00 00 00 00 8D B0 FC 01 00 00 83 CD FF 31 DB EB 0C 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKLite_103_COM: PEiD
{
    strings:
        $a = { B8 00 00 BA 00 00 3B C4 73 67 8B C4 2D 44 03 25 F0 FF 8B F8 B9 A2 00 BE 7C 01 FC F3 A5 8B D8 B1 04 D3 EB 8C D9 03 D9 53 33 DB 53 CB 03 01 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v252b2_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B0 ?? ?? ?? 68 60 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 24 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Windows_Cabinet_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4D 53 43 46 }
    condition:
        $a at pe.entry_point

}

rule PackerAspack_v212_wwwaspackcom: PEiD
{
    strings:
        $a = { ?8 ?? ?0 00 ?? ?? ?? ?? ?D ?? ?? ?? ?? ?? ?? ?? ?? ?? 5? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F ?? ?? ?3 ?? ?? ?? 8? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F 95 ?? ?? ?? ?? 8? ?? ?D ?? ?? ?? ?? 5? }
    condition:
        $a at pe.entry_point

}

rule RE_Crypt_v07x_Crudd_RET_h1_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED E7 1A 40 00 E8 A1 00 00 00 E8 D1 00 00 00 E8 85 01 00 00 F7 85 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v10059_Final_additional: PEiD
{
    strings:
        $a = { E8 AB 1C }
    condition:
        $a at pe.entry_point

}

rule DotFix_Nice_Protect_21_GPcH_Soft: PEiD
{
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 50 B8 ?? ?? ?? ?? 03 C5 FF 10 BB ?? ?? ?? ?? 03 DD 83 C3 0C 53 50 B8 ?? ?? ?? ?? 03 C5 FF 10 6A 40 68 00 10 00 00 FF 74 24 2C 6A 00 FF D0 89 44 24 1C 61 C3 }
        $b = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 }
        $c = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MS_Run_Time_Library_OS2_FORTRAN_Compiler_1989_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 86 E0 2E A3 ?? ?? 3D ?? ?? 73 }
    condition:
        $a at pe.entry_point

}

rule AI1_Creator_1_Beta_2_by_MZ: PEiD
{
    strings:
        $a = { E8 FE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { E8 FE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Pohernah_103_by_Kas: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PolyCryptor_by_SMT_Version_v3v4: PEiD
{
    strings:
        $a = { EB ?? 28 50 6F 6C 79 53 63 72 79 70 74 20 ?? ?? ?? 20 62 79 20 53 4D 54 29 }
    condition:
        $a at pe.entry_point

}

rule UPX_Alternative_stub_additional: PEiD
{
    strings:
        $a = { B9 ?? ?? BE ?? ?? BF C0 FF FD }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v300a_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_p_Virus_Shield_additional: PEiD
{
    strings:
        $a = { 03 05 40 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule X_Pack_v142_Hint_HDR_FILESIZE_32: PEiD
{
    strings:
        $a = { 72 ?? C3 8B DE 83 ?? ?? C1 ?? ?? 8C D8 03 C3 8E D8 8B DF 83 ?? ?? C1 ?? ?? 8C C0 03 C3 8E C0 C3 }
    condition:
        $a at pe.entry_point

}

rule GLBS_Install_Stub_32_bit_Wise: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 2C 05 00 00 53 56 57 6A 01 5E 6A 04 89 75 E8 FF 15 54 40 40 00 FF 15 50 40 40 00 8B F8 89 7D F4 8A 07 3C 22 0F 85 ?? 00 00 00 8A 47 01 47 89 7D F4 33 DB 3A C3 74 0D 3C 22 74 09 8A 47 01 47 89 7D F4 EB EF 80 3F 22 75 04 47 89 7D F4 80 3F 20 75 09 47 80 3F 20 74 FA 89 7D F4 53 FF 15 6C }
    condition:
        $a at pe.entry_point

}

rule RJcrush_v100_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 FC 8C C8 BA ?? ?? 03 D0 52 BA ?? ?? 52 BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 }
    condition:
        $a at pe.entry_point

}

rule Free_Pascal_v1010_win32_GUI_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5 }
    condition:
        $a at pe.entry_point

}

rule Zortech_C_v30: PEiD
{
    strings:
        $a = { FA FC B8 ?? ?? ?? 8C C8 8E D8 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_DEF_10_Anorganix: PEiD
{
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 E9 }
    condition:
        $a at pe.entry_point

}

rule Possibly_PCX_graphics_format: PEiD
{
    strings:
        $a = { 10 ?? 01 }
        $b = { 0A ?? 01 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WinZip_32_bit_SFX_v6x_module_additional: PEiD
{
    strings:
        $a = { FF 15 ?? ?? ?? 00 B1 22 38 08 74 02 B1 20 40 80 38 00 74 10 38 08 74 06 40 80 38 00 75 F6 80 38 00 74 01 40 33 C9 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v260_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 D0 ?? ?? ?? 68 34 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 68 ?? ?? ?? 33 D2 8A D4 89 15 84 }
    condition:
        $a at pe.entry_point

}

rule SWAG_Archive: PEiD
{
    strings:
        $a = { ?? ?? 2D 73 77 31 2D }
        $b = { 2D 73 77 31 2D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule STUD_RC4_10_Jamie_Edition_ScanTime_UnDetectable_by_MarjinZ_additional: PEiD
{
    strings:
        $a = { 68 2C 11 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 00 00 00 38 00 00 00 00 00 00 00 37 BB 71 EC A4 E1 98 4C 9B FE 8F 0F FA 6A 07 F6 00 00 00 00 00 00 01 00 00 00 20 20 46 6F 72 20 73 74 75 64 00 20 54 6F 00 00 00 00 06 00 00 00 CC 1A 40 00 07 00 00 00 D4 18 40 00 07 00 00 00 7C 18 40 00 07 00 00 00 2C 18 40 00 07 00 00 00 E0 17 40 00 56 42 35 21 F0 1F 2A 00 00 00 00 00 00 00 00 00 00 00 00 00 7E 00 00 00 00 00 00 00 00 00 00 00 00 00 0A 00 09 04 00 00 00 00 00 00 E8 13 40 00 F4 13 40 00 00 F0 30 00 00 FF FF FF 08 00 00 00 01 00 00 00 00 00 00 00 E9 00 00 00 04 11 40 00 04 11 40 00 C8 10 40 00 78 00 00 00 7C 00 00 00 81 00 00 00 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 61 61 61 00 53 74 75 64 00 00 73 74 75 64 00 00 01 00 01 00 30 16 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 B4 16 40 00 10 30 40 00 07 00 00 00 24 12 40 00 0E 00 20 00 00 00 00 00 1C 9E 21 00 EC 11 40 00 5C 10 40 00 E4 1A 40 00 2C 34 40 00 68 17 40 00 58 17 40 00 78 17 40 00 8C 17 40 00 8C 10 40 00 62 10 40 00 92 10 40 00 F8 1A 40 00 24 19 40 00 98 10 40 00 9E 10 40 00 77 04 18 FF 04 1C FF 05 00 00 24 01 00 0D 14 00 78 1C 40 00 48 21 40 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Anorganix_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Crunch_V50_Bitarts_additional: PEiD
{
    strings:
        $a = { 03 05 C0 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_120_Beta_PE_Packer: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 EB ?? 45 78 50 72 2D 76 2E 31 2E 32 2E 2E }
    condition:
        $a at pe.entry_point

}

rule EYouDiDai_YueHeiFengGao: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 56 57 0F 31 8B D8 0F 31 8B D0 2B D3 C1 EA 10 B8 ?? ?? ?? ?? 0F 6E C0 B8 ?? ?? ?? ?? 0F 6E C8 0F F5 C1 0F 7E C0 0F 77 03 C2 ?? ?? ?? ?? ?? FF E0 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_132_Eng_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_kkryptor_9kryptor_a_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 ?? ?? ?? ?? 5E B9 00 00 00 00 2B C0 02 04 0E D3 C0 49 79 F8 41 8D 7E 2C 33 46 ?? 66 B9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_8_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule Pack_Master_v10_additional: PEiD
{
    strings:
        $a = { 60 E8 01 ?? ?? ?? ?? 83 C4 04 E8 01 ?? ?? ?? ?? 5D 81 }
    condition:
        $a at pe.entry_point

}

rule WarWind_Save_file: PEiD
{
    strings:
        $a = { 57 41 52 53 41 56 }
    condition:
        $a at pe.entry_point

}

rule PECompact_2x_Jeremy_Collake: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 }
    condition:
        $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_NTkrnl_team_h: PEiD
{
    strings:
        $a = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 79 }
        $b = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Thinstall_v2460_Jitit: PEiD
{
    strings:
        $a = { 55 8B EC 51 53 56 57 6A 00 6A 00 FF 15 F4 18 40 00 50 E8 87 FC FF FF 59 59 A1 94 1A 40 00 8B 40 10 03 05 90 1A 40 00 89 45 FC 8B 45 FC FF E0 5F 5E 5B C9 C3 00 00 00 76 0C 00 00 D4 0C 00 00 1E }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_2609_Jitit: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 BB AD 19 00 00 2B C3 50 68 ?? ?? ?? ?? 68 B0 1C 00 00 68 80 00 00 00 E8 35 FF FF FF E9 99 FF FF FF 00 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_Extranger: PEiD
{
    strings:
        $a = { 50 60 E8 00 00 00 00 5D 81 ED 07 10 40 00 68 80 0B 00 00 8D 85 1F 10 40 00 50 E8 84 0B 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_020_beta_Dwing_: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b7: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 9A 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 01 85 92 60 40 ?? BB 14 }
    condition:
        $a at pe.entry_point

}

rule Safeguard_10_Simonzh_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 EB 29 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V120_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 27 05 00 00 89 85 B6 05 00 00 5B FF B5 B6 05 00 00 56 FF D3 83 C4 08 8B B5 B6 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 EB 6E 56 FF 95 1F 05 00 00 0B C0 75 05 E8 C9 02 00 00 85 C0 0F 84 94 00 00 00 89 85 AE 05 00 00 8B C6 EB 2A 8B 85 B2 05 00 00 8B 00 50 FF B5 AE 05 00 00 E8 11 02 00 00 85 C0 74 72 89 07 83 85 B2 05 00 00 04 83 C7 04 8B 85 B2 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 80 3E 01 75 8D 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 B6 05 00 00 FF 95 2B 05 00 00 68 00 80 00 00 6A 00 FF B5 B6 05 00 00 FF 95 2B 05 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_SVKP_13x_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 00 00 00 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 00 00 00 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ACProtect_V14X_risco: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 7C 83 04 24 06 C3 }
    condition:
        $a at pe.entry_point

}

rule NsPack_V14_LiuXingPing_: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B1 85 40 00 2D AA 85 40 00 }
    condition:
        $a at pe.entry_point

}

rule PassCOM_v20_PPC_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? BE ?? ?? B9 ?? ?? 87 1C EB ?? FB FA 87 ?? ?? ?? 87 ?? ?? ?? FB 1F 58 4B EB ?? 50 1E 33 C0 8E D8 EB }
    condition:
        $a at pe.entry_point

}

rule LX_Exe_Executable_Image: PEiD
{
    strings:
        $a = { 4C 58 }
    condition:
        $a at pe.entry_point

}

rule EEXE_112_113: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 03 73 00 BA 1F 00 0E 1F B4 09 CD 21 B8 FF 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Basic_v10_1987_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 2E 8C ?? ?? ?? 2E C7 }
    condition:
        $a at pe.entry_point

}

rule Vx_Trivial46: PEiD
{
    strings:
        $a = { B4 4E B1 20 BA ?? ?? CD 21 BA ?? ?? B8 ?? 3D CD 21 }
    condition:
        $a at pe.entry_point

}

rule RLPack_117p_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? 00 00 8D 9D ?? ?? 00 00 33 FF E8 ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 37 FF D3 }
    condition:
        $a at pe.entry_point

}

rule COMPACK_v45_2_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BE ?? ?? E8 ?? ?? 5D 83 ?? ?? 55 50 53 51 52 0E 07 0E 1F 8B CE }
    condition:
        $a at pe.entry_point

}

rule UPX_123_Markus_Laszlo: PEiD
{
    strings:
        $a = { 31 2E 32 33 00 55 50 58 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 83 ?? ?? 6A 00 FF 15 F8 10 0B B0 8D ?? ?? ?? 51 6A 08 6A 00 6A 00 68 }
    condition:
        $a at pe.entry_point

}

rule STNPEE_113: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 97 3B 40 00 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v14_CGSoftLabs_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 34 2E 2E B8 }
    condition:
        $a at pe.entry_point

}

rule UPX_071_072_PE: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 83 CD FF 31 DB 5E 8D BE FA 00 00 FF 57 66 81 87 00 00 00 00 00 00 81 C6 B3 01 00 00 EB 0A 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098b1_tHE_EGOiSTE: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF }
    condition:
        $a at pe.entry_point

}

rule ActiveMARK_5x_Trymedia_Systems_Inc_h_additional: PEiD
{
    strings:
        $a = { 20 2D 2D 4D 50 52 4D 4D 47 56 41 2D 2D 00 75 73 65 72 33 32 2E 64 6C 6C 00 4D 65 73 73 61 67 65 42 6F 78 41 00 54 68 69 73 20 61 70 70 6C 69 63 61 74 69 6F 6E 20 63 61 6E 6E 6F 74 20 72 75 6E 20 77 69 74 68 20 61 6E 20 61 63 74 69 76 65 20 64 65 62 75 67 }
    condition:
        $a at pe.entry_point

}

rule Upack_036_beta_Dwing_additional: PEiD
{
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? 00 E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD 03 C3 50 97 AD 91 F3 A5 5E AD 56 91 01 1E AD E2 FB AD 8D 6E 10 01 5D 00 8D 7D 1C B5 ?? F3 AB 5E AD 53 50 51 97 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 }
    condition:
        $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4X_SafeNet_SignByfly: PEiD
{
    strings:
        $a = { 60 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 66 C7 ?? ?? ?? ?? ?? ?? ?? E9 13 09 00 00 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 ?? ?? 89 ?? ?? 83 ?? ?? ?? 75 05 E9 C1 11 00 00 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? A1 ?? ?? ?? ?? 33 ?? ?? ?? ?? ?? 89 ?? ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 89 ?? ?? E9 CE 0E 00 00 E9 36 11 00 00 E9 3D 11 00 00 E9 38 11 00 00 66 ?? ?? ?? ?? ?? EB 04 66 ?? ?? ?? 8B ?? ?? 25 FF FF 00 00 83 ?? ?? 0F 8D DF 00 00 00 8B ?? ?? 25 FF FF 00 00 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 83 ?? ?? 89 ?? ?? ?? ?? ?? EB 7E }
        $b = { 60 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Unknown_by_SMT_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 83 ?? ?? 57 EB }
    condition:
        $a at pe.entry_point

}

rule tElock_096_tE: PEiD
{
    strings:
        $a = { E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C }
        $b = { E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ACProtect_13x_14x_DLL_Risco_Software_Inc: PEiD
{
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 ?? BA ?? ?? CD 21 B8 ?? ?? CD 21 }
        $b = { 80 7C 24 08 01 0F 85 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_012_beta_Dwing: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD ?? ?? ?? A5 ?? C0 33 C9 ?? ?? ?? ?? ?? ?? ?? F3 AB ?? ?? 0A ?? ?? ?? ?? AD 50 97 51 ?? 87 F5 58 8D 54 86 5C ?? D5 72 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B6 5F FF C1 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_NorthStar_PE_Shrinker_13: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_PECompact_14x_emadicius: PEiD
{
    strings:
        $a = { EB 06 68 2E A8 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A }
    condition:
        $a at pe.entry_point

}

rule Vx_Gotcha879: PEiD
{
    strings:
        $a = { E8 ?? ?? 5B 81 EB ?? ?? 9C FC 2E ?? ?? ?? ?? ?? ?? ?? 8C D8 05 ?? ?? 2E ?? ?? ?? ?? 50 2E ?? ?? ?? ?? ?? ?? 8B C3 05 ?? ?? 8B F0 BF 00 01 B9 20 00 F3 A4 0E B8 00 01 50 B8 DA DA CD 21 }
    condition:
        $a at pe.entry_point

}

rule ChSfx_small_v11_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BA ?? ?? E8 ?? ?? 8B EC 83 EC ?? 8C C8 BB ?? ?? B1 ?? D3 EB 03 C3 8E D8 05 ?? ?? 89 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_v27_Exeshield_Corp: PEiD
{
    strings:
        $a = { EB 06 68 F4 86 06 00 C3 9C 60 E8 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule GEM_Image_graphics_file: PEiD
{
    strings:
        $a = { 00 01 00 08 00 04 00 02 }
    condition:
        $a at pe.entry_point

}

rule MingWin32_GCC_3x: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? 00 E8 ?? FE FF FF 90 8D B4 26 00 00 00 00 55 }
        $b = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? 40 00 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_LCC_Win32_1x_Anorganix: PEiD
{
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 E9 }
    condition:
        $a at pe.entry_point

}

rule TrueType_Font_file: PEiD
{
    strings:
        $a = { 00 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 4F 53 2F 32 }
        $b = { 00 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 4C 54 53 48 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_v211c_additional: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 59 04 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v114_v120_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 20 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_041_FEUERRADER: PEiD
{
    strings:
        $a = { 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 90 90 90 FF E0 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PESpin_v01_Cyberbob_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 B3 28 40 00 8B 42 3C 03 C2 89 85 BD 28 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D D1 28 40 00 53 8F 85 C4 27 40 00 BB ?? 00 00 00 B9 A5 08 00 00 8D BD 75 29 40 00 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D BD AA 30 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 07 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D C4 28 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 59 81 C1 1D 00 00 00 52 51 C1 E9 05 23 D1 FF }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_Small_build_017_GlOFF: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 86 FF 86 DB 86 FF 68 00 01 00 00 68 18 20 40 00 6A 00 E8 FF 01 00 00 8A E4 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 18 20 40 00 E8 D5 01 00 00 A3 00 20 40 00 40 0F 84 97 01 00 00 8A E4 6A 02 6A 00 6A FB FF 35 00 20 40 00 E8 E0 01 00 00 86 FF 86 DB 86 FF 6A 00 8D 45 FC 50 6A 04 8D 45 F8 50 FF 35 00 20 40 00 E8 BD 01 00 00 8A E4 6A 00 8D 45 FC 50 6A 01 8D 45 F3 50 }
    condition:
        $a at pe.entry_point

}

rule tElock_098_tE: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 }
        $b = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule TurboBAT_v310_50_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BA ?? ?? B4 09 ?? ?? 06 B8 ?? ?? 8E C0 B9 ?? ?? 26 ?? ?? ?? ?? 80 ?? ?? 26 ?? ?? ?? 24 0F 3A C4 ?? ?? 26 ?? ?? ?? 24 0F 3A C4 }
    condition:
        $a at pe.entry_point

}

rule RLPack_Full_Edition_117_iBox_aPLib_Ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 79 29 00 00 8D 9D 2C 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 }
    condition:
        $a at pe.entry_point

}

rule EP_10: PEiD
{
    strings:
        $a = { 50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1 }
    condition:
        $a at pe.entry_point

}

rule Zurenava_DOS_Extender_v045_v049_additional: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 56 FC F3 A5 5F E9 }
    condition:
        $a at pe.entry_point

}

rule NET_executable_Microsoft_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 5F 43 6F 72 45 78 65 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C 00 00 00 00 00 FF 25 }
    condition:
        $a at pe.entry_point

}

rule ORiEN_V1X_V2X_Fisun_AV_Sign_by_fly: PEiD
{
    strings:
        $a = { 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D }
        $b = { E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Slowload: PEiD
{
    strings:
        $a = { 03 D6 B4 40 CD 21 B8 02 42 33 D2 33 C9 CD 21 8B D6 B9 78 01 }
    condition:
        $a at pe.entry_point

}

rule Duals_eXe_10: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 08 03 00 00 89 28 33 FF 8D 85 7D 02 00 00 8D 8D 08 03 00 00 2B C8 8B 9D 58 03 00 00 E8 1C 02 00 00 8D 9D 61 02 00 00 8D B5 7C 02 00 00 46 80 3E 00 74 24 56 FF 95 0A 04 00 00 46 80 3E 00 }
    condition:
        $a at pe.entry_point

}

rule Inbuild_v10_hard_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B9 ?? ?? BB ?? ?? 2E ?? ?? 2E ?? ?? 43 E2 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V1X_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 45 6E 69 67 6D 61 20 70 72 6F 74 65 63 74 6F 72 20 76 31 }
    condition:
        $a at pe.entry_point

}

rule XCR_v012_additional: PEiD
{
    strings:
        $a = { 60 9C E8 ?? ?? ?? ?? 8B DD 5D 81 ED ?? ?? ?? ?? 89 9D }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Borland_Cpp_: PEiD
{
    strings:
        $a = { EB 01 2E EB 02 A5 55 BB 80 ?? ?? 00 87 FE 8D 05 AA CE E0 63 EB 01 75 BA 5E CE E0 63 EB 02 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2521_Jitit: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A7 1A 00 00 B9 6C 1A 00 00 BA 20 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD EC 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v30_additional: PEiD
{
    strings:
        $a = { 83 EC 44 56 FF 15 70 61 44 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C 3C 20 7E 08 8A 46 01 46 3C 20 7F F8 8A 06 84 C0 74 0C 3C 20 7F 08 8A 46 01 46 84 C0 75 F4 8D 44 24 04 C7 44 24 30 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_Patch_or_any_Version_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { 60 E8 09 00 00 00 17 CD 00 00 E9 06 02 }
    condition:
        $a at pe.entry_point

}

rule RLPack_120_Basic_Edition_aPLib: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 }
        $b = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule DiskDupe_c_MSD_Configuration_file: PEiD
{
    strings:
        $a = { 4D 53 44 20 44 61 74 61 20 56 65 72 73 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_EXE32Pack_13x_emadicius: PEiD
{
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC 56 3B D2 74 02 81 85 57 E8 00 00 00 00 3B DB 74 01 90 83 C4 14 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Packman_v0001_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? 48 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cue_70_DLL: PEiD
{
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_V21X_SoftCompletecom: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? ?? ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Packer_Northfox: PEiD
{
    strings:
        $a = { 54 59 68 61 7A 79 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v71_DLL_Debug_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 55 89 E5 83 EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 55 ?? ?? ?? ?? ?? ?? ?? ?? ?? FF ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule SDProtector_Pro_Edition_116_Randy_Li_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 93 03 00 00 03 C8 74 C4 75 C2 E8 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_PE_Intro_10: PEiD
{
    strings:
        $a = { 8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_02_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA 8C DE 8C CF 8E DF 8E C7 83 C7 ?? BB }
    condition:
        $a at pe.entry_point

}

rule ICE_Archive: PEiD
{
    strings:
        $a = { ?? ?? 2D 6C 68 ?? 2D }
        $b = { 2D 6C 68 ?? 2D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_Modified_Stub_b_Farb_rausch_Consumer_Consulting_: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 31 C0 31 DB 31 C9 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 89 D8 E2 D9 8D BE ?? ?? ?? ?? 8B 07 09 C0 74 45 8B 5F 04 8D 84 30 ?? ?? ?? ?? 01 F3 50 83 C7 08 FF 96 ?? ?? ?? ?? 95 8A 07 47 08 C0 74 DC 89 F9 79 07 0F B7 07 47 50 47 B9 57 48 F2 AE 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB D8 FF 96 ?? ?? ?? ?? 61 E9 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_V06_SMoKE: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED D4 1A 40 00 EB 01 00 8D B5 5E 1B 40 00 BA A1 0B 00 00 EB 01 00 8D 8D FF 26 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 }
    condition:
        $a at pe.entry_point

}

rule Krypton_v03: PEiD
{
    strings:
        $a = { 8B 0C 24 E9 C0 8D 01 ?? C1 3A 6E CA 5D 7E 79 6D B3 64 5A 71 EA }
    condition:
        $a at pe.entry_point

}

rule Krypton_v02: PEiD
{
    strings:
        $a = { 8B 0C 24 E9 0A 7C 01 ?? AD 42 40 BD BE 9D 7A 04 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v1250_Obsidium_Software: PEiD
{
    strings:
        $a = { E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 0D 33 C0 C3 64 67 FF 36 00 00 64 67 89 26 00 00 50 33 C0 8B 00 C3 E9 FA 00 00 00 E8 D5 FF FF FF 58 64 67 8F 06 00 00 83 C4 04 E8 2B 13 00 00 }
    condition:
        $a at pe.entry_point

}

rule FixupPak_v120: PEiD
{
    strings:
        $a = { 55 E8 00 00 00 00 5D 81 ED ?? ?? 00 00 BE 00 ?? 00 00 03 F5 BA 00 00 ?? ?? 2B D5 8B DD 33 C0 AC 3C 00 74 3D 3C 01 74 0E 3C 02 74 0E 3C 03 74 0D 03 D8 29 13 EB E7 66 AD EB F6 AD EB F3 AC 0F B6 C8 3C 00 74 06 3C 01 74 09 EB 0A 66 AD 0F B7 C8 EB 03 AD 8B C8 }
        $b = { 55 E8 00 00 00 00 5D 81 ED ?? ?? 00 00 BE 00 ?? 00 00 03 F5 BA 00 00 ?? ?? 2B D5 8B DD 33 C0 AC 3C 00 74 3D 3C 01 74 0E 3C 02 74 0E 3C 03 74 0D 03 D8 29 13 EB E7 66 AD EB F6 AD EB F3 AC 0F B6 C8 3C 00 74 06 3C 01 74 09 EB 0A 66 AD 0F B7 C8 EB 03 AD 8B C8 AC 0F B6 C0 03 D8 29 13 E2 FA EB BC 8D 85 ?? ?? 00 00 5D FF E0 00 00 00 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Krypton_v05: PEiD
{
    strings:
        $a = { 54 E8 ?? ?? ?? ?? 5D 8B C5 81 ED 71 44 ?? ?? 2B 85 64 60 ?? ?? EB 43 DF }
    condition:
        $a at pe.entry_point

}

rule Krypton_v04: PEiD
{
    strings:
        $a = { 54 E8 ?? ?? ?? ?? 5D 8B C5 81 ED 61 34 ?? ?? 2B 85 60 37 ?? ?? 83 E8 06 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v140b2_v140b4_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 60 12 }
    condition:
        $a at pe.entry_point

}

rule unknown_by_GyikSoft_1: PEiD
{
    strings:
        $a = { 8C C9 81 C1 00 00 51 B9 00 00 51 00 00 00 00 00 00 06 00 00 00 00 00 83 EB 18 53 51 B8 00 00 8C CA 03 D0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 48 79 EE 00 00 00 00 00 00 BE 00 00 CB }
    condition:
        $a at pe.entry_point

}

rule MicroJoiner_17_coban2k_additional: PEiD
{
    strings:
        $a = { BE E0 11 ?? ?? FF 36 E9 C3 00 00 00 48 01 ?? ?? 0B 01 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 82 8E FE FF FF 58 8B 4E 40 5F E3 }
    condition:
        $a at pe.entry_point

}

rule unknown_by_GyikSoft_2: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 50 B8 00 00 50 B0 FF 06 8C D2 06 83 EA 1E 50 B0 08 52 FC 50 8C D2 8C CD BB 00 00 03 EB 4A 8E DD 8E C2 4D B9 08 00 33 FF BE 00 00 AD 35 00 00 AB E2 F9 4B 79 E8 8E DA 0E BE 00 00 33 DB 8B FB 07 CB }
    condition:
        $a at pe.entry_point

}

rule kkryptor_5_rsc: PEiD
{
    strings:
        $a = { E8 03 00 00 00 E9 EB 6C 58 40 FF E0 }
    condition:
        $a at pe.entry_point

}

rule Stirling_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 13 5D 65 8C 3A }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v200_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 02 41 00 68 C4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_13017_Obsidium_software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 28 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 }
    condition:
        $a at pe.entry_point

}

rule JExeCompressor_V10_UsAr_additional: PEiD
{
    strings:
        $a = { 8D 2D D3 4A E5 14 0F BB F7 0F BA E5 73 0F AF D5 8D 0D 0C 9F E6 11 C0 F8 EF F6 DE 80 DC 5B F6 DA 0F A5 C1 0F C1 F1 1C F3 4A 81 E1 8C 1F 66 91 0F BE C6 11 EE 0F C0 E7 33 D9 64 F2 C0 DC 73 0F C0 D5 55 8B EC BA C0 1F 41 00 8B C2 B9 97 00 00 00 80 32 79 50 B8 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_36x_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD AB 76 }
    condition:
        $a at pe.entry_point

}

rule PENightMare_2_Beta: PEiD
{
    strings:
        $a = { 60 E9 ?? ?? ?? ?? EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1342_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 50 EB 04 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Basic_60_DLL_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 5A 68 90 90 90 90 68 90 90 90 90 52 E9 90 90 FF }
    condition:
        $a at pe.entry_point

}

rule aPack_058_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 8E 01 BF 00 01 50 57 FC B6 01 BD 6F 01 FF D5 73 4C FF D5 73 18 FF D5 73 2A BB 86 01 33 C9 FF D3 FF D3 FF D3 FF D3 8B D9 43 B1 01 EB 26 E8 3E 00 49 49 AC 8A E1 93 E8 35 00 83 FB 40 73 15 83 C1 04 EB 10 AC }
    condition:
        $a at pe.entry_point

}

rule codeCrypter_031: PEiD
{
    strings:
        $a = { 50 58 53 5B 90 BB ?? ?? 40 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
        $b = { 50 58 53 5B 90 BB ?? ?? 40 00 FF E3 90 CC CC CC 55 8B EC 5D C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ENIGMA_Protector_V10_V12_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_3035_Jtit: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 }
        $b = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 C3 B9 08 00 00 00 E8 01 00 00 00 C3 33 C0 E8 E1 FF FF FF 13 C0 E2 F7 C3 33 C9 41 E8 D4 FF FF FF 13 C9 E8 CD FF FF FF 72 F2 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Cruncher_v10_additional: PEiD
{
    strings:
        $a = { 2E ?? ?? ?? ?? 2E ?? ?? ?? B4 30 CD 21 3C 03 73 ?? BB ?? ?? 8E DB 8D ?? ?? ?? B4 09 CD 21 06 33 C0 50 CB }
    condition:
        $a at pe.entry_point

}

rule UPX_v062_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 ?? ?? ?? FF 57 66 81 87 ?? ?? ?? ?? ?? ?? 8D B0 EC 01 ?? ?? 83 CD FF 31 DB EB 07 90 8A 06 46 88 07 47 01 DB 75 07 }
    condition:
        $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    strings:
        $a = { EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA }
        $b = { EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA 73 8B CF 81 C2 96 44 EB 04 EB 02 CD 20 88 16 E8 02 00 00 00 44 A2 59 46 E8 01 00 00 00 AD 59 4B 80 C1 13 83 FB 00 75 B2 F7 D9 96 8F 80 4D 0C 4C 91 50 1C 0C 50 8A ?? ?? ?? 50 E9 34 16 50 4C 4C 0E 7E 9B 49 C6 32 02 3E 7E 7B 5E 8C C5 6B 50 3F 0E 0F 38 C8 95 18 D1 65 11 2C B8 87 28 C3 4C 0B 3C AC D9 2D 15 4E 8F 1C 40 4F 28 98 3E 10 C1 45 DB 8F 06 3F EC 48 61 4C 50 50 81 DF C3 20 34 84 10 10 0C 1F 68 DC FF 24 8C 4D 29 F5 1D 2C BF 74 CF F0 24 C0 08 2E 0C 0C 10 51 0C 91 10 10 81 16 D0 54 4B D7 42 C3 54 CB C9 4E }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Exe_Stealth_275a_WebtoolMaster_additional: PEiD
{
    strings:
        $a = { EB 00 EB 17 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 60 90 E8 00 00 00 00 5D 81 ED C4 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 }
    condition:
        $a at pe.entry_point

}

rule DEF_100_Eng_bartxt: PEiD
{
    strings:
        $a = { BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEiD_Bundle_v100_BoB_BobSoft: PEiD
{
    strings:
        $a = { 60 E8 21 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A }
    condition:
        $a at pe.entry_point

}

rule ActiveMARK_5x_Trymedia_SystemsInc_h_additional: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 1C F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9E 0C 10 00 00 B0 01 67 E3 29 8B D7 2B 56 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF D5 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 55 CC 33 C9 E9 DF 00 00 00 8B 5E 0C 83 C2 30 FF D5 73 50 83 C2 30 FF D5 72 1B 83 C2 30 FF D5 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 46 0C B1 80 8A 00 EB CF 83 C2 60 FF D5 87 5E 10 73 0D 83 C2 30 FF D5 87 5E 14 73 03 87 5E 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 96 7C 07 00 00 FF 55 D0 5B 91 EB 77 3C 07 B0 07 72 02 B0 0A 50 87 5E 10 87 5E 14 89 5E 18 8D 96 C4 0B 00 00 FF 55 D0 50 48 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_50p_MFC_Anorganix: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v12_Alexey_Solodovnikov_h1: PEiD
{
    strings:
        $a = { 90 60 E8 1B 00 00 00 E9 FC 8D B5 0F 06 00 00 8B FE B9 97 00 00 00 AD 35 78 56 34 12 AB 49 75 F6 EB 04 5D 45 55 C3 E9 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_06_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? B4 30 CD 21 86 E0 2E A3 ?? ?? 3D ?? ?? 73 }
    condition:
        $a at pe.entry_point

}

rule ICrypt_10_by_BuGGz: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 70 3B 00 10 E8 3C FA FF FF 33 C0 55 68 6C 3C 00 10 64 FF 30 64 89 20 6A 0A 68 7C 3C 00 10 A1 50 56 00 10 50 E8 D8 FA FF FF 8B D8 53 A1 50 56 00 10 50 E8 0A FB FF FF 8B F8 53 A1 50 56 00 10 50 E8 D4 FA FF FF 8B D8 53 E8 D4 FA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 64 56 00 10 E8 25 F6 FF FF B8 64 56 00 10 E8 13 F6 FF FF 8B CF 8B D6 E8 E6 FA FF FF 53 E8 90 FA FF FF 8D 4D EC BA 8C 3C 00 10 A1 64 56 00 10 E8 16 FB FF FF 8B 55 EC B8 64 56 00 10 E8 C5 F4 FF FF B8 64 56 00 10 E8 DB F5 FF FF E8 56 FC FF FF 33 C0 5A 59 59 64 89 10 68 73 3C 00 10 8D 45 EC E8 4D F4 FF FF C3 E9 E3 EE FF FF EB F0 5F 5E 5B E8 4D F3 FF FF 00 53 45 54 ?? ?? ?? ?? 00 FF FF FF FF 08 00 00 00 76 6F 74 72 65 63 6C 65 }
        $b = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 70 3B 00 10 E8 3C FA FF FF 33 C0 55 68 6C 3C 00 10 64 FF 30 64 89 20 6A 0A 68 7C 3C 00 10 A1 50 56 00 10 50 E8 D8 FA FF FF 8B D8 53 A1 50 56 00 10 50 E8 0A FB FF FF 8B F8 53 A1 50 56 00 10 50 E8 D4 FA FF FF 8B }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Unknown_Protected_Mode_compiler_2: PEiD
{
    strings:
        $a = { FA FC 0E 1F E8 ?? ?? 8C C0 66 0F B7 C0 66 C1 E0 ?? 66 67 A3 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_1: PEiD
{
    strings:
        $a = { FA BC ?? ?? 8C C8 8E D8 E8 ?? ?? E8 ?? ?? E8 ?? ?? 66 B8 ?? ?? ?? ?? 66 C1 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_Run_Time_systempDOS4GW_DOS_Extender_1988_93_additional: PEiD
{
    strings:
        $a = { BF ?? ?? 8E D7 81 C4 ?? ?? BE ?? ?? 2B F7 8B C6 B1 ?? D3 }
    condition:
        $a at pe.entry_point

}

rule AVP_Antiviral_Database_additional: PEiD
{
    strings:
        $a = { 41 56 50 20 41 6E 74 69 76 69 72 61 6C 20 44 61 74 61 62 61 73 65 }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_10_beta_2_by_Alex_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Borland_Delphi_30_Anorganix_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_60_DLL_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v102_dllocx_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
        $b = { 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
        $c = { 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_v032_beta_Dwing: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 32 }
    condition:
        $a at pe.entry_point

}

rule PEnguinCrypt_10_Pingvin: PEiD
{
    strings:
        $a = { B8 93 ?? ?? 00 55 50 67 64 FF 36 00 00 67 64 89 26 00 00 BD 4B 48 43 42 B8 04 00 00 00 CC 3C 04 75 04 90 90 C3 90 67 64 8F 06 00 00 58 5D BB 00 00 40 00 33 C9 33 C0 32 0C 03 40 81 F8 00 01 00 00 75 F4 BB 75 ?? ?? 00 33 C0 32 0C 03 40 81 F8 36 01 00 00 75 F4 A1 35 ?? ?? 00 8B D9 68 75 ?? ?? 00 6A 40 }
    condition:
        $a at pe.entry_point

}

rule SecureEXE_30_ZipWorx: PEiD
{
    strings:
        $a = { E9 B8 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule VMProtect246_PolyTech: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 60 C7 ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 60 E8 }
    condition:
        $a at pe.entry_point

}

rule HACKSTOP_v118_additional: PEiD
{
    strings:
        $a = { 52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? FD 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB }
    condition:
        $a at pe.entry_point

}

rule PackerUPX_CompresorGratuito_wwwupxsourceforgenet: PEiD
{
    strings:
        $a = { 60 BE ?? ?0 ?? 00 8D BE ?? ?? F? FF }
    condition:
        $a at pe.entry_point

}

rule HASP_HL_Protection_V1X_Aladdin: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 8B C4 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 04 E9 A5 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule Borland_Pascal_70_for_Windows: PEiD
{
    strings:
        $a = { 9A FF FF 00 00 9A FF FF 00 00 55 89 E5 31 C0 9A FF FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule SoftProtect_wwwsoftprotectbyru_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? 01 }
    condition:
        $a at pe.entry_point

}

rule RAZOR_1911_encruptor_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? BF ?? ?? 3B FC 72 ?? B4 4C CD 21 BE ?? ?? B9 ?? ?? FD F3 A5 FC }
    condition:
        $a at pe.entry_point

}

rule DAEMON_Protect_v067_additional: PEiD
{
    strings:
        $a = { 60 60 9C 8C C9 32 C9 E3 0C 52 0F 01 4C 24 FE 5A 83 C2 0C 8B 1A 9D 61 }
    condition:
        $a at pe.entry_point

}

rule RTPatch_software_update_package_data_file: PEiD
{
    strings:
        $a = { 4B 2A }
    condition:
        $a at pe.entry_point

}

rule PECompact_v20_beta_Jeremy_Collake: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 05 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Vcasm_Protector_V1X_vcasm: PEiD
{
    strings:
        $a = { EB ?? 5B 56 50 72 6F 74 65 63 74 5D }
    condition:
        $a at pe.entry_point

}

rule fEaRzCrypter_v10_fEaRz_additional: PEiD
{
    strings:
        $a = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 ?? 53 56 57 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 ?? 6A 00 }
    condition:
        $a at pe.entry_point

}

rule XPack_165_EXE: PEiD
{
    strings:
        $a = { 8B EC EB 01 E8 B8 82 03 FF E0 FA 33 C0 8E D0 BC 10 00 2E 8F 06 C1 03 2E 8F 06 C6 03 EB 01 9A 0E BB B6 03 53 5F EB 01 9A 17 8B E5 FB 48 D1 E8 EB 01 9A CE 9A 9C EB 01 9A 59 80 CD 01 51 9D EB 01 9A 1E 33 DB 8E DB C7 47 10 00 00 C7 47 12 00 00 }
    condition:
        $a at pe.entry_point

}

rule CExe_v10a: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 0C 02 ?? ?? 56 BE 04 01 ?? ?? 8D 85 F8 FE FF FF 56 50 6A ?? FF 15 54 10 40 ?? 8A 8D F8 FE FF FF 33 D2 84 C9 8D 85 F8 FE FF FF 74 16 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Stones_PE_Encryptor_20_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 53 51 52 56 57 55 E8 00 00 00 00 5D 81 ED 42 30 40 00 FF 95 32 35 40 00 B8 37 30 40 00 03 C5 2B 85 1B 34 }
    condition:
        $a at pe.entry_point

}

rule ExeLock_v100_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 8C C8 8E C0 BE ?? ?? 26 ?? ?? 34 ?? 26 ?? ?? 46 81 ?? ?? ?? 75 ?? 40 B3 ?? B3 ?? F3 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_40_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 }
    condition:
        $a at pe.entry_point

}

rule MinGW_GCC_DLL_2xx: PEiD
{
    strings:
        $a = { 55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Windows_Metafile: PEiD
{
    strings:
        $a = { D7 CD C6 9A }
    condition:
        $a at pe.entry_point

}

rule ASPack_v104b_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 2B 85 ?? 0B DE ?? 89 85 17 DE ?? ?? 80 BD 01 DE }
    condition:
        $a at pe.entry_point

}

rule Shrinker_33_additional: PEiD
{
    strings:
        $a = { 00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Upack_Patch_Dwing: PEiD
{
    strings:
        $a = { 81 3A 00 00 00 02 00 00 00 00 }
        $b = { 2A A3 F2 54 CE }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CryExe_v40_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E9 ?? ?? 31 ED EB ?? F5 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_vxx: PEiD
{
    strings:
        $a = { 60 ?? ?? ?? ?? ?? 90 5D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 DD }
    condition:
        $a at pe.entry_point

}

rule Portable_BitMap_PBM_Graphics_format: PEiD
{
    strings:
        $a = { 50 36 0A }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_LTC_13_Anorganix: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 E9 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_VOB_ProtectCD_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 5F 81 EF 00 00 00 00 BE 00 00 40 00 8B 87 00 00 00 00 03 C6 57 56 8C A7 00 00 00 00 FF 10 89 87 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_10_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 2E FF 2E ?? ?? BB ?? ?? E8 ?? ?? CB }
    condition:
        $a at pe.entry_point

}

rule Morphine_v27_Holy_Father_Ratter29A_h_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
    condition:
        $a at pe.entry_point

}

rule Real_Networks_VideoAudio_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 2E 52 4D 46 }
    condition:
        $a at pe.entry_point

}

rule Upack_V036_Dwing_additional: PEiD
{
    strings:
        $a = { 0B 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 10 00 00 10 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 02 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MoleBoxPro_2522_Mole_Studio: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? 00 00 E9 ?? ?? 00 00 E9 ?? ?? 00 00 E8 6E FB FF FF 7E ?? ?? 00 ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A4 ?? ?? ?? A1 ?? ?? ?? E0 ?? ?? ?? 19 ?? ?? ?? BE ?? ?? ?? 13 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1B ?? ?? ?? D5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9E ?? ?? ?? ?? ?? ?? ?? FC }
    condition:
        $a at pe.entry_point

}

rule CodeCrypt_v015b: PEiD
{
    strings:
        $a = { E9 31 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_PEBundle_02_3x_emadicius: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_Win16_1991: PEiD
{
    strings:
        $a = { 9A FF FF 00 00 0B C0 75 03 E9 D5 00 8C 06 16 00 89 1E 1C 00 89 36 1A 00 89 3E 18 00 89 16 1E 00 B8 FF FF 50 9A FF FF 00 00 33 C0 1E 07 BF DE 03 B9 7E 0A 2B CF FC F3 AA 33 C0 50 9A FF FF 00 00 FF 36 18 00 9A FF FF 00 00 0B C0 75 03 E9 91 00 }
    condition:
        $a at pe.entry_point

}

rule Pe123_v2006412_additional: PEiD
{
    strings:
        $a = { 8B C0 60 9C E8 01 00 00 00 C3 53 E8 72 00 00 00 50 E8 1C 03 00 00 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B }
    condition:
        $a at pe.entry_point

}

rule MultiEdits_compiled_macros_Hint_FILE_START: PEiD
{
    strings:
        $a = { 1E AA }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v177_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B0 71 40 00 68 6C 37 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule Gardian_Angel_10: PEiD
{
    strings:
        $a = { 06 8C C8 8E D8 8E C0 FC BF ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule Vcasm_Protector_10e_vcasm_additional: PEiD
{
    strings:
        $a = { EB 0A 5B 56 50 72 6F 74 65 63 74 5D }
    condition:
        $a at pe.entry_point

}

rule Special_EXE_Pasword_Protector_V101_Eng_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v13b_Vaska_additional: PEiD
{
    strings:
        $a = { 61 83 EF 4F 60 68 ?? ?? ?? ?? FF D7 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v09781: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 49 87 40 ?? 87 DD 8B 85 CE 87 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v09782: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB D1 84 40 ?? 87 DD 8B 85 56 85 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_13037_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V13X_vcasm: PEiD
{
    strings:
        $a = { 00 00 00 00 55 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 47 64 69 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule TaiShanXiangYu_LockSoft_V10_zlocksoft_SignByfly: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED E3 00 42 00 8B D5 81 C2 32 01 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? 8B D5 81 ?? ?? ?? ?? ?? 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 ?? ?? ?? E9 ?? ?? ?? ?? 33 C0 64 FF 30 64 89 20 43 CC C3 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V540_Silicon_Realms_Toolworks_20080214: PEiD
{
    strings:
        $a = { E8 93 3E 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 B4 1F 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 AF 1D 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 40 1D 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_v31_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? 50 9C FC BE ?? ?? 8B FE 8C C8 05 ?? ?? 8E C0 06 57 B9 }
    condition:
        $a at pe.entry_point

}

rule iLUCRYPT_4019: PEiD
{
    strings:
        $a = { 8B EC FA C7 46 FE 00 00 4C 4C C3 FB BF 00 0A B8 00 00 2E 31 05 D1 C8 4F 81 FF 00 00 EB 00 73 F2 }
    condition:
        $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4X_SafeNet_SignByfly_additional: PEiD
{
    strings:
        $a = { 60 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D }
    condition:
        $a at pe.entry_point

}

rule CHECKPRG_c_1992_additional: PEiD
{
    strings:
        $a = { 33 C0 BE ?? ?? 8B D8 B9 ?? ?? BF ?? ?? BA ?? ?? 47 4A 74 }
    condition:
        $a at pe.entry_point

}

rule DotFix_Nice_Protect_V21_GPcH_Soft_SignByhaggar_additional: PEiD
{
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 }
    condition:
        $a at pe.entry_point

}

rule Silicon_Realms_Install_Stub_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 50 92 40 00 68 E4 69 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 FC 90 40 00 33 D2 8A D4 89 15 94 E8 40 00 8B C8 81 E1 FF 00 00 00 89 0D 90 E8 40 00 C1 E1 08 03 CA 89 0D 8C E8 40 00 C1 E8 10 A3 88 E8 40 00 33 F6 56 E8 2F 0B 00 00 59 85 C0 75 08 }
    condition:
        $a at pe.entry_point

}

rule Go32Stub_v200_DOS_Extender_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 80 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_PEBundle_02_3x_emadicius_additional: PEiD
{
    strings:
        $a = { EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 EB 03 CD 20 EB EB 01 EB E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 EB EB 03 CD 20 03 61 9D 83 C4 04 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 }
    condition:
        $a at pe.entry_point

}

rule PluginToExe_v101_BoB_BobSoft_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 29 C0 5D 81 ED C6 41 40 00 50 8F 85 71 40 40 00 50 FF 95 A5 41 40 00 89 85 6D 40 40 00 FF 95 A1 41 40 00 50 FF 95 B5 41 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 B9 41 40 00 89 85 75 40 40 00 EB 6C 6A 01 8F 85 71 40 40 00 6A 58 6A }
    condition:
        $a at pe.entry_point

}

rule Thinstall_2628_Jtit_h: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 BB 34 1D 00 00 2B C3 50 68 00 00 40 00 68 00 40 00 00 68 BC 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_WATCOM_CCue_EXE: PEiD
{
    strings:
        $a = { E9 00 00 00 00 90 90 90 90 57 41 E9 }
    condition:
        $a at pe.entry_point

}

rule EXEJoiner_v10: PEiD
{
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 C6 00 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_V310X_Thinstall_Company_additional: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 }
    condition:
        $a at pe.entry_point

}

rule FSG_v130_Eng_dulekxt: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 }
        $b = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE 0F 75 06 47 FF 37 AF EB 09 FE 0F 0F 84 ?? ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 ?? ?? ?? 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule VProtector_V11A_vcasm_additional: PEiD
{
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D 00 E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_vxx_additional: PEiD
{
    strings:
        $a = { 90 60 90 E8 00 00 00 00 5D 81 ED D1 27 40 00 B9 15 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_ExeSmasher_Anorganix: PEiD
{
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B E9 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_1_additional: PEiD
{
    strings:
        $a = { FA BC ?? ?? 8C C8 8E D8 E8 ?? ?? E8 ?? ?? E8 ?? ?? 66 B8 ?? ?? ?? ?? 66 C1 }
    condition:
        $a at pe.entry_point

}

rule Anti007_V25_V26_NsPacK_Private: PEiD
{
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53 }
    condition:
        $a at pe.entry_point

}

rule UPX_050_070: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D }
    condition:
        $a at pe.entry_point

}

rule muckis_protector_II_mucki: PEiD
{
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 00 00 00 31 C0 89 41 14 89 41 18 80 6A 00 E8 85 C0 74 12 64 8B 3D 18 00 00 00 8B 7F 30 0F B6 47 02 85 C0 74 01 C3 C7 04 24 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 C3 }
        $b = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 00 00 00 31 C0 89 41 14 89 41 18 80 6A 00 E8 85 C0 74 12 64 8B 3D 18 00 00 00 8B 7F 30 0F B6 47 02 85 C0 74 01 C3 C7 04 24 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ORiEN_201_A_Fisun: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule NsPack_29_North_Star: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8A 06 3C 00 74 12 8B F5 8D B5 ?? ?? FF FF 8A 06 3C 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 }
        $b = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8A 06 3C 00 74 12 8B F5 8D B5 ?? ?? FF FF 8A 06 3C 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Macromedia_Windows_Flash_ProjectorPlayer_50: PEiD
{
    strings:
        $a = { 83 EC 44 56 FF 15 70 61 44 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C 3C 20 7E 08 8A 46 01 46 3C 20 7F F8 8A 06 84 C0 74 0C 3C 20 7F 08 8A 46 01 46 84 C0 75 F4 8D 44 24 04 C7 44 24 30 00 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1341_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 C3 27 00 00 }
        $b = { EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Alpha_BMP_graphics_file: PEiD
{
    strings:
        $a = { FF FF 00 01 64 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Doom666_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? 5E 83 EE ?? B8 CF 7B CD 21 3D CF 7B ?? ?? 0E 1F 81 C6 ?? ?? BF ?? ?? B9 ?? ?? FC F3 A4 06 1F 06 B8 ?? ?? 50 CB B4 48 BB 2C 00 CD 21 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1258_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? EB 01 ?? 58 EB 01 ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 01 ?? E8 7B 21 00 00 }
        $b = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EP_v20: PEiD
{
    strings:
        $a = { 60 BE ?? B0 42 ?? 8D BE ?? 60 FD FF C7 87 B0 E4 02 ?? 31 3C 4B DF 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 ?? ?? ?? 01 DB ?? ?? ?? }
        $b = { 6A ?? 60 E9 01 01 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule JDPack_2x_JDPack_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 68 51 40 00 68 04 25 40 00 64 A1 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ExeStealth_WebToolMaster: PEiD
{
    strings:
        $a = { EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F }
    condition:
        $a at pe.entry_point

}

rule REC_v034_3_additional: PEiD
{
    strings:
        $a = { 06 1E B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB }
    condition:
        $a at pe.entry_point

}

rule eXPressorProtection_150X_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02 66 F0 68 ?? ?? ?? ?? E8 0E 05 00 00 59 EB 01 DD 83 65 F4 00 EB 07 8B 45 F4 40 89 45 F4 83 7D F4 61 73 1F EB 02 DA 1A 8B 45 F4 0F ?? ?? ?? ?? ?? ?? 33 45 F4 8B 4D F4 88 ?? ?? ?? ?? ?? EB 01 EB EB }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_additional: PEiD
{
    strings:
        $a = { F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? A7 BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68 }
    condition:
        $a at pe.entry_point

}

rule NsPack_v37_North_Star: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 8D ?? ?? ?? FF 80 39 01 0F 84 42 02 00 00 C6 01 01 8B C5 2B 85 ?? ?? ?? FF 89 85 ?? ?? ?? FF 01 85 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 01 06 55 56 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? ?? FF 85 C0 0F 84 69 03 00 00 89 85 ?? ?? ?? FF E8 00 00 00 00 5B B9 67 03 00 00 03 D9 50 53 E8 B0 02 00 00 5E 5D 8B 36 8B FD 03 BD ?? ?? ?? FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 34 01 13 8B 33 03 7B 04 57 51 53 FF B5 ?? ?? ?? FF FF B5 ?? ?? ?? FF 8B D6 8B CF 8B 85 ?? ?? ?? FF 05 AA 05 00 00 FF D0 5B 59 5F 83 F9 00 74 05 83 C3 08 EB C7 68 00 80 00 00 6A 00 FF B5 ?? ?? ?? FF FF 95 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 00 74 14 8A 1A 38 1F 75 E9 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 EB 0A 8A 5F 04 86 C4 C1 C0 10 86 C4 2B C7 03 C6 89 07 83 C7 05 80 EB E8 8B C3 E2 C6 E8 3A 01 00 00 8D 8D }
    condition:
        $a at pe.entry_point

}

rule SimplePack_10X_bagie: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B FA 6A 00 FF 93 ?? ?? 00 00 89 C5 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 8B 86 88 00 00 00 09 C0 }
    condition:
        $a at pe.entry_point

}

rule RLPack_116_LZMA_compression_ap0x_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 EB 09 00 00 89 85 3A 0A 00 00 EB 14 60 FF B5 3A 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 08 83 3C 37 00 75 E6 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 EB 09 00 00 89 85 56 0A 00 00 5B 60 FF B5 3A 0A 00 00 56 FF B5 56 0A 00 00 FF D3 61 8B B5 56 0A 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 E7 00 00 00 83 C0 04 89 85 52 0A 00 00 E9 97 00 00 00 56 FF 95 E3 09 00 00 89 85 4E 0A 00 00 85 C0 0F 84 C2 }
    condition:
        $a at pe.entry_point

}

rule Hasp_4_envelope_dongle_Alladin: PEiD
{
    strings:
        $a = { 5C 5C 2E 5C 48 41 52 44 4C 4F 43 4B 2E 56 58 44 ?? ?? ?? ?? 5C 5C 2E 5C 46 45 6E 74 65 44 65 }
        $b = { 10 02 D0 51 0F 00 83 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule eXpressor_v145_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 50 53 56 57 BE ?? ?? ?? ?? 8D 7D F4 A5 A5 66 A5 8B }
    condition:
        $a at pe.entry_point

}

rule Upack_01x_020_021_024_beta_Dwing_additional: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 ?? ?? ?? ?? 33 }
    condition:
        $a at pe.entry_point

}

rule Vx_Lucee1888_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5E 83 ?? ?? FC 50 53 B8 ?? ?? CD 21 3D ?? ?? 75 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v0971_v0976_additional: PEiD
{
    strings:
        $a = { EB 06 68 C3 9C 60 E8 5D 55 5B 81 ED 8B 85 01 85 66 C7 85 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v310: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 }
        $b = { 55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 44 00 33 F6 56 E8 72 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 3D 13 00 00 FF 15 30 40 44 00 A3 84 B7 44 00 E8 FB 11 00 00 A3 E0 A1 44 00 E8 A4 0F 00 00 E8 E6 0E 00 00 E8 4E F6 FF FF 89 75 D0 8D 45 A4 50 FF 15 38 40 44 00 E8 77 0E 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 7C 41 44 00 50 E8 49 D4 FE FF 89 45 A0 50 E8 3C F6 FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 B5 0C 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 2E F6 FF FF 83 3D E8 A1 44 00 01 75 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Armadillo_v1xx_v2xx_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 }
    condition:
        $a at pe.entry_point

}

rule DOS32_v33_DOS_Extender_and_Loader_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 1F FC 9C 5B 8B C3 80 F4 ?? 50 9D 9C 58 3A E7 75 ?? BA ?? ?? B4 09 CD 21 B4 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_13_FinalBuild_81026: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 62 01 00 00 50 45 00 00 4C 01 01 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PROTECT_EXECOM_v60: PEiD
{
    strings:
        $a = { 1E B4 30 CD 21 3C 02 73 ?? CD 20 BE ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule PESpin_03_Cyberbob_h_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule PEiD_653_624_Six_to_Four_v10: PEiD
{
    strings:
        $a = { 50 55 4C 50 83 ?? ?? FC BF ?? ?? BE ?? ?? B5 ?? 57 F3 A5 C3 33 ED }
    condition:
        $a at pe.entry_point

}

rule tElock_v051_additional: PEiD
{
    strings:
        $a = { C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 5E 8B FE 68 79 01 59 EB 01 EB AC 54 E8 03 5C EB 08 }
    condition:
        $a at pe.entry_point

}

rule pirit_v15_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 5B 24 55 50 44 FB 32 2E 31 5D }
    condition:
        $a at pe.entry_point

}

rule EPW_v130_additional: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 83 C0 10 2E }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_PCGuard_403_415_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 }
        $b = { 90 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WATCOM_CCpp_32_Run_Time_System_1989_1994_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 1F 8C C6 B4 ?? 50 BB ?? ?? CD 21 73 ?? 58 CD 21 72 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v177: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B0 71 40 00 68 6C 37 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

/* False positive - #39
rule Armadillo_v171: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 }
    condition:
        $a at pe.entry_point

}*/

rule AsCrypt_v01_SToRM_4: PEiD
{
    strings:
        $a = { 80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 E2 }
    condition:
        $a at pe.entry_point

}

rule UPX_071_072_PE_DLL: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 95 01 00 00 60 E8 00 00 00 00 83 CD FF 31 DB 5E 8D BE EF 00 00 FF 57 66 81 87 00 00 00 00 00 00 81 C6 B1 01 00 00 EB 07 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE }
    condition:
        $a at pe.entry_point

}

rule RLPack_V112_V114_LZMA_430_ap0x_Sign_by_fly: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 60 }
    condition:
        $a at pe.entry_point

}

rule AsCrypt_v01_SToRM_3: PEiD
{
    strings:
        $a = { 80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 51 ?? ?? ?? 01 00 00 00 83 ?? ?? E2 }
    condition:
        $a at pe.entry_point

}

rule AsCrypt_v01_SToRM_1: PEiD
{
    strings:
        $a = { 81 ?? ?? ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? E2 ?? EB }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ASProtect_Anorganix_additional: PEiD
{
    strings:
        $a = { 60 90 90 90 90 90 90 5D 90 90 90 90 90 90 90 90 90 90 90 03 DD E9 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_V20_risco_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 44 24 0C 50 }
    condition:
        $a at pe.entry_point

}

rule Krypton_v04_yadolockless: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED 61 34 ?? 00 2B 85 60 37 ?? 00 83 E8 06 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v146: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 60 12 }
    condition:
        $a at pe.entry_point

}

rule Pohernah_Crypter_V102_Kas: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 25 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 01 28 40 00 89 44 24 1C 61 FF E0 }
        $b = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_v0761_dos_exe_additional: PEiD
{
    strings:
        $a = { B9 ?? ?? BE ?? ?? 89 F7 1E A9 ?? ?? 8C C8 05 ?? ?? 8E D8 05 ?? ?? 8E C0 FD F3 A5 FC }
    condition:
        $a at pe.entry_point

}

rule Video_Lan_Client: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Code_Lock: PEiD
{
    strings:
        $a = { 43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B E9 }
    condition:
        $a at pe.entry_point

}

rule NsPack_v31_North_Star: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 }
        $b = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 ?? ?? FF FF FF B5 ?? ?? FF FF 8B D6 8B CF 8B 85 ?? ?? FF FF 05 AA 05 00 00 FF D0 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB C5 68 00 80 00 00 6A 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_v147_v150_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 90 40 ?? 87 DD 8B 85 A2 90 40 ?? 01 85 03 90 40 ?? 66 C7 85 ?? 90 40 ?? 90 90 01 85 9E 90 40 ?? BB 2D 12 }
    condition:
        $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_One_layer_encryption_MANtiCORE_: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? 00 B9 ?? 01 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3 }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V36_LiuXingPing_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D ?? ?? ?? ?? ?? 83 38 01 0F 84 47 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1988_1995_Open_Watcom: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? ?? ?? ?? ?? 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encryptor_v20_additional: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 42 30 40 ?? FF 95 32 35 40 ?? B8 37 30 40 ?? 03 C5 2B 85 1B 34 40 ?? 89 85 27 34 40 ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v253_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 40 ?? ?? ?? ?? 68 54 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF ?? ?? ?? 15 58 33 D2 8A D4 89 }
    condition:
        $a at pe.entry_point

}

rule tElock_v092a_additional: PEiD
{
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_13_Extranger: PEiD
{
    strings:
        $a = { 57 57 8D 7C 24 04 50 B8 00 ?? ?? ?? AB 58 5F C3 }
    condition:
        $a at pe.entry_point

}

rule tElock_10_private_tE_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 }
    condition:
        $a at pe.entry_point

}

rule Solidshield_Protector_V1X_DLL_Solidshield_Technologies_SignByfly: PEiD
{
    strings:
        $a = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF FF 83 FE 02 57 8B 7D 10 75 53 FF 75 24 FF 75 20 FF 75 1C FF 75 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 20 3C 01 75 04 8B C6 EB 6A 57 FF 75 0C E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 14 3C 01 74 DF 6A 03 5E 83 FE 03 75 1B 57 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? 83 FE 04 75 0D FF 75 2C FF 75 28 E8 ?? ?? ?? ?? 59 59 83 FE 05 75 11 FF 75 30 FF 75 2C FF 75 28 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5F 5E 5D C3 }
        $b = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_Armadillo_300_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 2A 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 85 E9 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V120_aPlib_043_ap0x_SignByfly: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 27 05 00 00 89 85 B6 05 00 00 5B FF B5 B6 05 00 00 56 FF D3 83 C4 08 8B B5 B6 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 EB 6E 56 FF 95 1F 05 00 00 0B C0 75 05 E8 C9 02 00 00 85 C0 0F 84 94 00 00 00 89 85 AE 05 00 00 8B C6 EB 2A 8B 85 B2 05 00 00 8B 00 50 FF B5 AE 05 00 00 E8 11 02 00 00 85 C0 74 72 89 07 83 85 B2 05 00 00 04 83 C7 04 8B 85 B2 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 80 3E 01 75 8D 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 B6 05 00 00 FF 95 2B 05 00 00 68 00 80 00 00 6A 00 FF B5 B6 05 00 00 FF 95 2B 05 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule PESpin_v1304_Cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Inno_Installer_v512_collides_with_Borland_Delphi_20_Overlay: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 CC 53 56 57 33 C0 89 45 F0 89 45 DC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V20X_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V121_aPlib_043_ap0xnbsp_nbsp_SignByfly_20080504: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 D6 05 00 00 EB 0C 8B 85 D2 05 00 00 89 85 D6 05 00 00 E8 4C 01 00 00 8D B5 FE 05 00 00 8D 9D 85 04 00 00 33 FF E8 77 01 00 00 EB 1B 8B 85 D6 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD E2 05 00 00 00 74 0E 83 BD E6 05 00 00 00 74 05 E8 15 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 6B 05 00 00 89 85 FA 05 00 00 5B FF B5 FA 05 00 00 56 FF D3 83 C4 08 8B B5 FA 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 EB 6E 56 FF 95 63 05 00 00 0B C0 75 05 E8 08 03 00 00 85 C0 0F 84 95 00 00 00 89 85 F2 05 00 00 8B C6 EB 2A 8B 85 F6 05 00 00 8B 00 50 FF B5 F2 05 00 00 E8 50 02 00 00 85 C0 74 73 89 07 83 85 F6 05 00 00 04 83 C7 04 8B 85 F6 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 80 3E 01 75 8D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 FA 05 00 00 FF 95 6F 05 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 FA 05 00 00 FF 95 6F 05 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_226_DLL_minimum_protection_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 E8 ?? ?? ?? 00 89 45 F8 E9 ?? ?? ?? ?? 0F 83 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 14 24 5A 57 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 58 81 C0 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 81 C8 ?? ?? ?? ?? 81 E0 }
        $b = { 50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_105b_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED CE 3A 44 00 B8 C8 3A 44 00 03 C5 2B 85 B5 3E 44 00 89 85 C1 3E 44 00 80 BD AC 3E 44 }
    condition:
        $a at pe.entry_point

}

rule C_Cpp_Library_file: PEiD
{
    strings:
        $a = { F0 0D 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_V194_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    strings:
        $a = { FF D5 80 A7 ?? ?? ?? ?? ?? 58 50 54 50 53 57 FF D5 58 61 8D 44 24 ?? 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        $a at pe.entry_point

}

rule CodeCrypt_016b_0161b: PEiD
{
    strings:
        $a = { EB 02 0F 4D 55 EB 02 0F C7 E8 00 00 00 00 EB 02 83 3D 5D EB 03 0F CA 0F 81 ED 6D 23 40 00 52 8B 54 24 08 E8 A5 FD FF FF 89 95 D1 2A 40 00 5A EB 02 0F 4D EB 02 FF 1D EB 02 0F C7 EB 02 0F C0 EB 03 0F CA 0F EB 03 FF 1D 34 EB 02 83 3D EB 02 C7 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b5_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 49 }
    condition:
        $a at pe.entry_point

}

rule UCEXE_v23_v24_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 50 1E 0E 1F FC 33 F6 E8 ?? ?? 16 07 33 F6 33 FF B9 ?? ?? F3 A5 06 B8 ?? ?? 50 CB }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v1304_Obsidium_Software_h_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_v141: PEiD
{
    strings:
        $a = { 60 76 03 77 01 7B 74 03 75 01 78 47 87 EE E8 01 00 00 00 76 83 C4 04 85 EE EB 01 7F 85 F2 EB 01 79 0F 86 01 00 00 00 FC EB 01 78 79 02 87 F2 61 51 8F 05 19 38 01 01 60 EB 01 E9 E9 01 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule DotFix_Nice_Protect_V21_GPcH_Soft_SignByhaggar: PEiD
{
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 50 B8 ?? ?? ?? ?? 03 C5 FF 10 BB ?? ?? ?? ?? 03 DD 83 C3 0C 53 50 B8 ?? ?? ?? ?? 03 C5 FF 10 6A 40 68 00 10 00 00 FF 74 24 2C 6A 00 FF D0 89 44 24 1C 61 C3 }
        $b = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_v110_Eng_dulekxt_Borland_Cpp_1999_: PEiD
{
    strings:
        $a = { EB 02 CD 20 2B C8 68 80 ?? ?? 00 EB 02 1E BB 5E EB 02 CD 20 68 B1 2B 6E 37 40 5B 0F B6 C9 }
    condition:
        $a at pe.entry_point

}

rule RJoiner_12a_Vaska_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 0C 01 00 00 8D 85 F4 FE FF FF 56 50 68 04 01 00 00 FF 15 0C 10 40 00 94 90 94 8D 85 F4 FE FF FF 50 FF 15 08 10 40 00 94 90 94 BE 00 20 40 00 94 90 94 83 3E FF 74 7D 53 57 33 DB 8D 7E 04 94 90 94 53 68 80 00 00 00 6A 02 53 6A 01 68 00 00 00 C0 57 FF 15 04 10 40 00 89 45 F8 94 90 94 8B 06 8D 74 06 04 94 90 94 8D 45 FC 53 50 8D 46 04 FF 36 50 FF 75 F8 FF 15 00 10 40 00 94 90 94 FF 75 F8 FF 15 10 10 40 00 94 90 94 8D 85 F4 FE FF FF 6A 0A 50 53 57 68 20 10 40 00 53 FF 15 18 10 40 00 94 90 94 8B 06 8D 74 06 04 94 90 94 83 3E FF 75 89 5F 5B 33 C0 5E C9 C2 10 00 CC CC 24 11 }
    condition:
        $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v40: PEiD
{
    strings:
        $a = { 83 EC 44 56 FF 15 24 41 43 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        $a at pe.entry_point

}

rule ILUCRYPT_v4015_exe_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8B EC FA C7 46 F7 ?? ?? 42 81 FA ?? ?? 75 F9 FF 66 F7 }
    condition:
        $a at pe.entry_point

}

rule PC_Guard_150_for_Win16: PEiD
{
    strings:
        $a = { 50 53 51 52 56 57 55 1E 06 06 33 C0 50 2E FF 1E 01 0F 0B C0 74 F4 50 8C CB 53 50 2E FF 1E 09 0F 0B C0 75 03 58 EB EF 8E D8 58 07 A3 ED 0E 89 3E EB 0E 8C 06 EF 0E B8 D7 8A BF EA 0E 2D 62 8A 8B D0 B9 75 0E 96 FD F6 C1 1F 75 02 8B F2 AC BB 88 }
    condition:
        $a at pe.entry_point

}

rule FreeBASIC_016b_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_v30_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5D 81 ED 05 10 40 00 8D B5 24 10 40 00 8B FE B9 0F 00 00 00 BB ?? ?? ?? ?? AD 33 C3 E2 FA }
    condition:
        $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_01_015_NTkrnl_Software_additional: PEiD
{
    strings:
        $a = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 79 }
    condition:
        $a at pe.entry_point

}

rule RobinPE_vnew_Robin: PEiD
{
    strings:
        $a = { 60 6A 00 6A 20 6A 02 6A 00 6A 03 68 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule HideProtect_1016_SoftWar_Company_additional: PEiD
{
    strings:
        $a = { 90 90 90 E9 D8 ?? 05 00 95 ?? 53 00 95 4A 50 00 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_30: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F4 53 56 57 }
        $b = { A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 83 ?? ?? ?? ?? 0F ?? ?? ?? ?? ?? 80 ?? ?? ?? ?? ?? ?? 74 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Turbo_Pascal_v55_Unit: PEiD
{
    strings:
        $a = { 54 50 55 36 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_70_DLL_Method_3_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB }
    condition:
        $a at pe.entry_point

}

rule yC_13_by_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC C0 00 00 00 53 56 57 8D BD 40 FF FF FF B9 30 00 00 00 B8 CC CC CC CC F3 AB 60 E8 00 00 00 00 5D 81 ED 84 52 41 00 B9 75 5E 41 00 81 E9 DE 52 41 00 8B D5 81 C2 DE 52 41 00 8D 3A 8B F7 33 C0 EB 04 90 EB 01 C2 AC }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_v10: PEiD
{
    strings:
        $a = { 60 9C BE 00 10 40 00 8B FE B9 28 03 00 00 BB 78 56 34 12 AD 33 C3 AB E2 FA 9D 61 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_153_Stub_engine_171_GlOFF: PEiD
{
    strings:
        $a = { E8 02 FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A8 10 40 00 }
        $b = { 86 D6 90 86 F2 B9 93 60 08 FE 90 86 D6 90 86 F2 B9 9D 13 45 01 86 D6 90 86 F2 81 C2 93 60 08 FE 33 C9 B9 30 74 4D FF 86 D6 90 86 F2 33 C9 C7 05 B4 17 40 00 00 00 00 00 90 68 00 01 00 00 68 D1 17 40 00 6A 00 E8 CE 02 00 00 90 33 C9 86 D6 90 86 F2 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 D1 17 40 00 E8 9E 02 00 00 A3 CD 17 40 00 86 D6 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule LZEXE_v091_v100a_3: PEiD
{
    strings:
        $a = { 50 06 0E 1F 8B 0E }
    condition:
        $a at pe.entry_point

}

rule LZEXE_v091_v100a_2: PEiD
{
    strings:
        $a = { BF ?? ?? 06 89 F9 0E 41 1F 8C CB 89 FE }
    condition:
        $a at pe.entry_point

}

rule LZEXE_v091_v100a_1: PEiD
{
    strings:
        $a = { 06 0E 1F 8B ?? ?? ?? 8B F1 4E 89 F7 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 }
        $b = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB 27 ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 07 74 EF FE 07 75 06 47 FF 37 AF EB 09 FE 07 0F 84 1A ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 1B ?? ?? 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Simple_UPX_Cryptor_v3042005_multi_layer_encryption_MANtiCORE_: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V20X_Jitit: PEiD
{
    strings:
        $a = { B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        $a at pe.entry_point

}

rule ARJ_SFX_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4D 5A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 4A 53 58 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_FSG_10: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B }
    condition:
        $a at pe.entry_point

}

rule PEEncrypt_v40b_JunkCode: PEiD
{
    strings:
        $a = { 66 ?? ?? 00 66 83 ?? 00 }
    condition:
        $a at pe.entry_point

}

rule PESpin_v13beta_Cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Aspack_v212_wwwaspackcom_additional: PEiD
{
    strings:
        $a = { ?8 ?? ?0 00 ?? ?? ?? ?? ?D ?? ?? ?? ?? ?? ?? ?? ?? ?? 5? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F ?? ?? ?3 ?? ?? ?? 8? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F 95 ?? ?? ?? ?? 8? ?? ?D ?? ?? ?? ?? 5? }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_Packed_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BD ?? ?? 89 ?? ?? ?? 81 ?? ?? ?? ?? ?? 8C ?? ?? ?? 8C C8 05 ?? ?? 8E C0 BE ?? ?? 8B FE 0E 57 54 59 F3 A4 06 68 ?? ?? CB }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v20_Hide_EP_Vaska: PEiD
{
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 DC 20 ?? 00 F7 D1 83 F1 FF E8 00 00 00 00 F7 D1 83 F1 FF C3 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_50_60_: PEiD
{
    strings:
        $a = { 33 D2 0F BE D2 EB 01 C7 EB 01 D8 8D 05 80 ?? ?? ?? EB 02 CD 20 EB 01 F8 BE F4 00 00 00 EB }
    condition:
        $a at pe.entry_point

}

rule TurboBAT_v310_50_Patched_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 06 B8 ?? ?? 8E C0 B9 ?? ?? 26 ?? ?? ?? ?? 80 ?? ?? 26 ?? ?? ?? 24 ?? 3A C4 90 90 }
    condition:
        $a at pe.entry_point

}

rule ExeShield_Protector_V36_wwwexeshieldcom: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC }
    condition:
        $a at pe.entry_point

}

rule RLPack_116_aPLib_compression_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 53 03 00 00 8D 9D 02 02 00 00 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 E8 02 00 00 89 85 4F 03 00 00 5B FF B5 4F 03 00 00 56 FF D3 83 C4 08 8B B5 4F 03 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 CD 00 00 00 83 C0 04 89 85 4B 03 00 00 E9 93 00 00 00 56 FF 95 E0 02 00 00 85 C0 0F 84 AE 00 00 00 89 85 47 03 00 00 8B C6 EB 5B 8B 85 4B 03 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 4B 03 00 00 C7 00 20 20 20 00 EB 06 FF B5 4B 03 00 00 FF B5 47 03 00 00 FF 95 E4 02 00 00 85 C0 74 6B 89 07 83 C7 04 8B }
    condition:
        $a at pe.entry_point

}

rule EXEPACK_v531009_LINK_v369: PEiD
{
    strings:
        $a = { 8B E8 8C C0 }
    condition:
        $a at pe.entry_point

}

rule Upack_024_beta_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 AD 91 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V50X_Silicon_Realms_Toolworks_SignByfly: PEiD
{
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC ?? 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3 }
    condition:
        $a at pe.entry_point

}

rule Vx_CIH_Version_12_TTIT_WIN95CIH_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 55 8D ?? ?? ?? 33 DB 64 87 03 E8 ?? ?? ?? ?? 5B 8D }
    condition:
        $a at pe.entry_point

}

rule MIDI_Music_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4D 54 68 64 00 00 00 06 ?? ?? ?? ?? ?? ?? 4D 54 }
    condition:
        $a at pe.entry_point

}

rule ANDpakk2_006_by_Dmitry_quotANDquot_Andreev: PEiD
{
    strings:
        $a = { 60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD 00 FB FF FF 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_V3035_V3043_Thinstall_Company_Sign_by_fly: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB }
    condition:
        $a at pe.entry_point

}

rule SND_music_file: PEiD
{
    strings:
        $a = { 00 00 F8 2A ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_DLL_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 75 09 83 3D ?? ?? ?? ?? ?? EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 15 FF FF FF 85 C0 75 04 33 C0 EB 4E }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_10X_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 83 C4 04 EB 02 ?? ?? 60 E8 24 00 00 00 00 00 ?? EB 02 ?? ?? 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        $a at pe.entry_point

}

rule Morphine_v33_Silent_Software_Silent_Shield_c2005_h_additional: PEiD
{
    strings:
        $a = { BB 00 BD 46 00 83 EC 04 89 1C 24 ?? B9 ?? 00 00 00 80 33 ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Macromedia_Flash_Projector_60_Anorganix_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C E9 }
    condition:
        $a at pe.entry_point

}

rule PECompact_20x_Heuristic_Mode_Jeremy_Collake: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule EXE_Stealth_v11_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        $a at pe.entry_point

}

rule Khrome_Crypt_03: PEiD
{
    strings:
        $a = { B9 EB 09 B8 05 FE EB FC 80 C4 3B EB F4 EB 37 90 FE DF DF DF DF DF DF DF DF DF DF DF DF DF DF FE DD 20 4B 68 72 6F 6D 65 20 43 72 79 70 74 20 DE FE DC DC DC DC DC DC DC DC DC DC DC DC DC DC FE EF 00 00 00 00 00 EB 02 66 BC D9 FF EB 02 66 BC }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_V01b_V08_SMoKE_additional: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 ?? ?? ?? 5D EB 05 45 55 EB 04 ?? EB F9 ?? C3 E8 00 00 00 00 5D EB 01 ?? 81 ?? ?? ?? ?? ?? EB 02 ?? ?? 8D ?? ?? ?? ?? ?? EB 02 ?? ?? BA 9F 11 00 00 EB 01 ?? 8D ?? ?? ?? ?? ?? 8B 09 E8 14 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V10_cyberbob_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 ?? ?? ?? ?? ?? ?? ?? C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB FF 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 ?? ?? ?? ?? 83 04 24 0C C3 }
    condition:
        $a at pe.entry_point

}

rule ExeShield_36_wwwexeshieldcom: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F }
    condition:
        $a at pe.entry_point

}

rule FakeNinja_V28_Private_Spirit_SignByfly: PEiD
{
    strings:
        $a = { 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 17 E5 FF 60 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_041_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_PE_Pack_099_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Code_Lock_Anorganix: PEiD
{
    strings:
        $a = { 43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Lockless_Intro_Pack_Anorganix_additional: PEiD
{
    strings:
        $a = { 2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PENightMare_2_Beta: PEiD
{
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A E9 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_VIRUSI_Worm_Hybris_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 EB 16 A8 54 00 00 47 41 42 4C 4B 43 47 43 00 00 00 00 00 00 52 49 53 00 FC 68 4C 70 40 00 FF 15 }
    condition:
        $a at pe.entry_point

}

rule PE_Lock_NT_v202c_additional: PEiD
{
    strings:
        $a = { EB 02 C7 85 1E EB 03 CD 20 C7 9C EB 02 69 B1 60 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_07_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C C8 05 ?? ?? 50 B8 ?? ?? 50 B0 ?? 06 8C D2 06 83 }
    condition:
        $a at pe.entry_point

}

rule ExeSafeguard_v10_simonzh: PEiD
{
    strings:
        $a = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE }
        $b = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF BA A3 22 3F 9A C0 60 EB 4D EB 47 DF 69 4E 58 DF 59 79 F3 EB 01 DF 78 EE DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 8D B5 EE 19 40 00 EB 47 EB 47 DF 69 4E 58 DF 59 7A EE EB 01 DF 7B E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF 22 3F 9A C0 8B FE EB 4C EB 47 DF 69 4E 58 DF 59 74 F2 EB 01 DF 75 ED 0F 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 B9 2B CB 00 00 EB 4B EB 47 DF 69 4E 58 DF 59 78 EF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_WATCOM_CCpp_EXE_Anorganix: PEiD
{
    strings:
        $a = { E9 00 00 00 00 90 90 90 90 57 41 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_19881989: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? CD 20 BF ?? ?? 8B ?? ?? ?? 2B F7 81 ?? ?? ?? 72 }
    condition:
        $a at pe.entry_point

}

rule Inno_Installer_v512: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 CC 53 56 57 33 C0 89 45 F0 89 45 DC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 }
        $b = { 9C 60 E8 00 00 00 00 58 BB DC 1E 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 50 00 00 68 D8 00 00 00 E8 C1 FE FF FF E9 97 FF FF FF CC CC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PEBundle_20b5_31x_Jeremy_Collake: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 00 87 DD 01 AD ?? ?? ?? ?? 01 AD }
    condition:
        $a at pe.entry_point

}

rule ExeJoiner_10_Yoda_additional: PEiD
{
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50 E8 E2 02 00 00 83 F8 FF 0F 84 6D 02 00 00 A3 0C 12 40 00 8B D8 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 E3 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 1E 12 40 00 FF 35 08 12 40 00 E8 C4 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 }
    condition:
        $a at pe.entry_point

}

rule X_Hider_10_GlobaL: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 33 C0 89 45 EC B8 54 20 44 44 E8 DF F8 FF FF 33 C0 55 68 08 21 44 44 64 FF 30 64 89 20 8D 55 EC B8 1C 21 44 44 E8 E0 F9 FF FF 8B 55 EC B8 40 ?? ?? 44 E8 8B F5 FF FF 6A 00 6A 00 6A 02 6A 00 6A 01 68 00 00 00 40 A1 40 ?? ?? 44 E8 7E F6 FF FF 50 E8 4C F9 FF FF 6A 00 50 E8 4C F9 FF FF A3 28 ?? ?? 44 E8 CE FE FF FF 33 C0 5A 59 59 64 89 10 68 0F 21 44 44 8D 45 EC E8 F1 F4 FF FF C3 E9 BB F2 FF FF EB F0 E8 FC F3 FF FF FF FF FF FF 0E 00 00 00 63 3A 5C 30 30 30 30 30 30 31 2E 64 61 74 00 }
        $b = { 85 D2 74 23 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 30 00 00 00 89 C2 58 52 8B 48 FC E8 48 FB FF FF 5A 58 EB 03 FF 42 F8 87 10 85 D2 74 13 8B 4A F8 49 7C 0D FF 4A F8 75 08 8D 42 F8 E8 5C FA FF FF C3 8D 40 00 85 C0 7E 24 50 83 C0 0A 83 E0 FE 50 E8 2F FA FF FF 5A 66 C7 44 02 FE 00 00 83 C0 08 5A 89 50 FC C7 40 F8 01 00 00 00 C3 31 C0 C3 90 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PE_PACK_10: PEiD
{
    strings:
        $a = { 50 FC AD 33 C2 AB 8B D0 E2 F8 }
        $b = { 74 00 E9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule DBPE_vxxx_additional: PEiD
{
    strings:
        $a = { 03 05 80 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule CrypKey_V61X_DLL_CrypKey_Canada_Inc: PEiD
{
    strings:
        $a = { 83 3D ?? ?? ?? ?? 00 75 34 68 ?? ?? ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule ARM_Protector_03_by_SMoKE: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 13 24 40 00 EB 02 83 09 8D B5 A4 24 40 00 EB 02 83 09 BA 4B 15 00 00 EB 01 00 8D 8D EF 39 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 }
        $b = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 13 24 40 00 EB 02 83 09 8D B5 A4 24 40 00 EB 02 83 09 BA 4B 15 00 00 EB 01 00 8D 8D EF 39 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_02_DEF_10_Anorganix: PEiD
{
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_REALBasic: PEiD
{
    strings:
        $a = { 55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule DzA_Patcher_v13_Loader: PEiD
{
    strings:
        $a = { BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 }
        $b = { BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 48 20 40 00 E8 C2 00 00 00 E8 C8 FF FF FF BF 40 40 40 00 FF 35 4C 20 40 00 E8 A1 00 00 00 8B 0F 83 F9 00 74 B1 60 6A 00 6A 04 6A 01 51 FF 35 48 20 40 00 E8 75 00 00 00 61 60 BB 5C 20 40 00 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 75 00 00 00 61 A0 5C 20 40 00 8A 5F 05 3A C3 74 14 FF 35 4C 20 40 00 E8 4B 00 00 00 6A 03 E8 4A 00 00 00 EB A2 60 8D 5F 04 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 4B 00 00 00 61 83 C7 06 FF 35 4C 20 40 00 E8 1E 00 00 00 6A 03 E8 1D 00 00 00 E9 72 FF FF FF FF 25 70 30 40 00 FF 25 78 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PowerBASICWin_800: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 14 04 00 00 E9 19 02 }
    condition:
        $a at pe.entry_point

}

rule XJ_XPAL_LiNSoN: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 44 53 56 57 66 9C }
    condition:
        $a at pe.entry_point

}

rule PowerBASICCC_30x: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? ?? 00 04 00 0F 85 }
    condition:
        $a at pe.entry_point

}

rule FreeCryptor_01_build_002_GlOFF: PEiD
{
    strings:
        $a = { 8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 90 68 27 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08 }
    condition:
        $a at pe.entry_point

}

rule PROTECT_EXECOM_v60_additional: PEiD
{
    strings:
        $a = { 1E B4 30 CD 21 3C 02 73 ?? CD 20 BE ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule PECompact_20betastudent_version_Jeremy_Collake: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? EE 05 12 13 13 12 50 64 FF 35 00 00 00 00 64 89 25 00 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_14_SE_SIS_Team_additional: PEiD
{
    strings:
        $a = { 68 90 03 00 00 E8 C6 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 4F 68 04 01 00 00 68 10 22 60 }
    condition:
        $a at pe.entry_point

}

rule Vx_VCL_encrypted_Hint_DOS_EP_additional: PEiD
{
    strings:
        $a = { 01 B9 ?? ?? 81 35 ?? ?? 47 47 E2 F8 C3 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_2312_Jitit: PEiD
{
    strings:
        $a = { 6A 00 FF 15 ?? ?? ?? ?? E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_com: PEiD
{
    strings:
        $a = { B9 ?? ?? BE ?? ?? BF C0 FF FD }
    condition:
        $a at pe.entry_point

}

rule PKZIP_Archive: PEiD
{
    strings:
        $a = { 50 4B 03 04 }
    condition:
        $a at pe.entry_point

}

rule LHA_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 6C 68 35 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2545_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { E8 F2 FF FF FF 50 68 ?? ?? ?? ?? 68 40 1B 00 00 E8 42 FF FF FF E9 9D FF FF FF 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4093_Dll_SafeNet: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 19 FF FF FF E9 AF EC FF FF 90 90 90 90 90 55 8B EC 83 EC 18 53 56 57 8B 45 08 8B 00 C1 E8 10 89 45 FC 8B 45 08 8B 00 25 FF FF 00 00 89 45 F8 C7 45 F4 5A 01 00 00 C7 45 EC 35 4E 00 00 8B 45 F4 0F AF 45 F8 25 FF FF 00 00 89 45 F0 83 7D }
    condition:
        $a at pe.entry_point

}

rule tElock_v071b7_additional: PEiD
{
    strings:
        $a = { 60 E8 48 11 00 00 C3 83 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_v135_risco_software_Inc_Anticrack_Software_h: PEiD
{
    strings:
        $a = { 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 47 65 74 50 72 6F 63 }
    condition:
        $a at pe.entry_point

}

rule EXE_v10_: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 08 4B 40 00 68 36 3A 40 00 64 A1 }
    condition:
        $a at pe.entry_point

}

rule Windows_Group_file: PEiD
{
    strings:
        $a = { 50 4D 43 43 }
    condition:
        $a at pe.entry_point

}

rule Exe_Shield_v27: PEiD
{
    strings:
        $a = { EB 06 68 F4 86 06 00 C3 9C 60 E8 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_ASPack_212_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_CodeSafe_20_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 E9 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Extractable_p_Password_checking: PEiD
{
    strings:
        $a = { 03 05 80 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule A3E_TXT2COM: PEiD
{
    strings:
        $a = { 1E 33 C0 50 BE ?? ?? 81 C6 ?? ?? B8 ?? ?? 8E C0 BF ?? ?? B9 ?? ?? F3 A5 CB }
    condition:
        $a at pe.entry_point

}

rule RPolyCrypt_v_10_personal_polycryptor_sign_from_pinch_additional: PEiD
{
    strings:
        $a = { 50 58 97 97 60 61 8B 04 24 80 78 F3 6A E8 00 00 00 00 58 E8 00 00 00 00 58 91 91 EB 00 0F 85 6B F4 76 6F E8 00 00 00 00 83 C4 04 E8 00 00 00 00 58 90 E8 00 00 00 00 83 C4 04 8B 04 24 80 78 F1 }
    condition:
        $a at pe.entry_point

}

rule Exact_Audio_Copy: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E FC 83 ?? ?? 81 ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 50 06 56 1E B8 FE 4B CD 21 81 FF BB 55 ?? ?? 07 ?? ?? ?? 07 B4 49 CD 21 BB FF FF B4 48 CD 21 }
        $b = { E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WWPACK_v302_v302a_v304_Relocations_pack: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 8C CD 81 ED ?? ?? 8B DD 81 EB ?? ?? 8B D3 FC FA 1E 8E DB 01 15 33 C0 2E AC }
    condition:
        $a at pe.entry_point

}

rule EXEStealth_v275a_WebtoolMaster_h_additional: PEiD
{
    strings:
        $a = { EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 90 60 90 E8 00 00 00 00 5D 81 ED F7 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 74 28 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 C5 }
    condition:
        $a at pe.entry_point

}

rule TMT_Pascal_v040_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 1F 06 8C 06 ?? ?? 26 A1 ?? ?? A3 ?? ?? 8E C0 66 33 FF 66 33 C9 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v265b1_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 38 ?? ?? ?? 68 40 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 F4 }
    condition:
        $a at pe.entry_point

}

rule Obsiduim_1304_Obsiduim_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 }
    condition:
        $a at pe.entry_point

}

rule PENinja_modified_pDZA: PEiD
{
    strings:
        $a = { 5D 8B C5 81 ED B2 2C 40 00 2B 85 94 3E 40 00 2D 71 02 00 00 89 85 98 3E 40 00 0F B6 B5 9C 3E 40 00 8B FD }
    condition:
        $a at pe.entry_point

}

rule UPX_Alternative_stub_Laszlo_Markus: PEiD
{
    strings:
        $a = { EB 02 EB EA EB FC 8A 06 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_198889: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 02 CD 20 BF 00 00 8B 36 02 00 2B F7 81 FE 00 10 72 03 BE 00 10 FA 8E D7 81 C4 00 00 FB 73 }
    condition:
        $a at pe.entry_point

}

rule TPCs_COM_Scrambler_v100_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 2E ?? ?? ?? ?? 8E C0 8C D8 BE ?? ?? BF ?? ?? 2E ?? ?? ?? ?? 26 ?? ?? ?? 26 ?? ?? ?? ?? 26 ?? ?? ?? 26 ?? ?? ?? ?? ?? ?? 0E 07 B9 ?? ?? FC F3 A4 CC }
    condition:
        $a at pe.entry_point

}

rule DIET_v100d_additional: PEiD
{
    strings:
        $a = { FC 06 1E 0E 8C C8 01 ?? ?? ?? BA ?? ?? 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule WinRAR_32_bit_SFX_Module: PEiD
{
    strings:
        $a = { E9 ?? ?? 00 00 00 00 00 00 90 90 90 ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Basic_50_60_Anorganix_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule MetaWare_High_C_Run_Time_Library_p_Phar_Lap_DOS_Extender_1983_89: PEiD
{
    strings:
        $a = { B8 ?? ?? 50 B8 ?? ?? 50 CB }
    condition:
        $a at pe.entry_point

}

rule PEiD_813_32Lite_v003a_Oleg_Prokhorov: PEiD
{
    strings:
        $a = { 60 06 FC 1E 07 BE ?? ?? ?? ?? 6A 04 68 00 10 ?? ?? 68 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V120_Dll_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 AA 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD A8 0C 00 00 00 74 0E 83 BD AC 0C 00 00 00 74 05 E8 F2 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 2D 0C 00 00 89 85 C0 0C 00 00 5B 60 FF B5 94 0C 00 00 56 FF B5 C0 0C 00 00 FF D3 61 8B B5 C0 0C 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 EB 72 56 FF 95 25 0C 00 00 0B C0 75 05 E8 E6 02 00 00 85 C0 0F 84 AB 00 00 00 89 85 B8 0C 00 00 8B C6 EB 2E 8B 85 BC 0C 00 00 8B 00 50 FF B5 B8 0C 00 00 E8 2E 02 00 00 85 C0 0F 84 85 00 00 00 89 07 83 85 BC 0C 00 00 04 83 C7 04 8B 85 BC 0C 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 80 3E 01 75 89 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 94 0C 00 00 FF 95 31 0C 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule Vx_Grazie883_additional: PEiD
{
    strings:
        $a = { 1E 0E 1F 50 06 BF 70 03 B4 1A BA 70 03 CD 21 B4 47 B2 00 BE 32 04 CD 21 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_23_SKE_build_0426_Beta_additional: PEiD
{
    strings:
        $a = { 68 01 60 40 00 E8 01 00 00 00 C3 C3 0D 6C 65 3E 09 84 BB 91 89 38 D0 5A 1D 60 6D AF D5 51 2D A9 2F E1 62 D8 C1 5A 8D 6B 6E 94 A7 F9 1D 26 8C 8E FB 08 A8 7E 9D 3B 0C DF 14 5E 62 14 7D 78 D0 6E }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60: PEiD
{
    strings:
        $a = { 51 }
        $b = { ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 0D ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
        $c = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule KByS_V028_DLL_shoooo: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 03 C2 FF E0 ?? ?? ?? ?? 60 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule CrunchPE_v50: PEiD
{
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_additional: PEiD
{
    strings:
        $a = { 33 C2 2C FB 8D 3D 7E 45 B4 80 E8 02 00 00 00 8A 45 58 68 02 ?? 8C 7F EB 02 CD 20 5E 80 C9 16 03 F7 EB 02 40 B0 68 F4 00 00 00 80 F1 2C 5B C1 E9 05 0F B6 C9 8A 16 0F B6 C9 0F BF C7 2A D3 E8 02 00 00 00 99 4C 58 80 EA 53 C1 C9 16 2A D3 E8 02 00 00 00 9D CE }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_REALBasic: PEiD
{
    strings:
        $a = { 55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01 }
    condition:
        $a at pe.entry_point

}

rule nMacro_recorder_10_additional: PEiD
{
    strings:
        $a = { 5C 6E 6D 72 5F 74 65 6D 70 2E 6E 6D 72 00 00 00 72 62 00 00 58 C7 41 00 10 F8 41 00 11 01 00 00 00 00 00 00 46 E1 00 00 46 E1 00 00 35 00 00 00 F6 88 41 00 }
    condition:
        $a at pe.entry_point

}

rule JDPack_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 83 ED 06 80 BD E0 04 ?? ?? 01 0F 84 F2 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_FSG_10_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B }
    condition:
        $a at pe.entry_point

}

rule ARM_Protector_02_SMoKE: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 09 20 40 00 EB 02 83 09 8D B5 9A 20 40 00 EB 02 83 09 BA 0B 12 00 00 EB 01 00 8D 8D A5 32 40 00 }
    condition:
        $a at pe.entry_point

}

rule PC_Shrinker_v071_Virogen: PEiD
{
    strings:
        $a = { 9C 60 BD ?? ?? ?? ?? 01 AD 54 3A 40 00 FF B5 50 3A 40 00 6A 40 FF 95 88 3A 40 00 50 50 2D ?? ?? ?? 00 89 85 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Cpp_70_DLL_Anorganix: PEiD
{
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule WinRAR_SFX: PEiD
{
    strings:
        $a = { E8 E3 FE FF FF 33 C0 50 50 50 50 E8 BE 2B 00 00 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v1033_dllocx_Ashkbiz_Danehkar_h_additional: PEiD
{
    strings:
        $a = { 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 00 00 00 00 5D 81 ED 07 E2 40 00 8B D5 81 C2 56 E2 40 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 4B 0C 41 00 81 E9 01 E3 40 00 8B D5 81 C2 01 E3 40 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 9C 22 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 CC CC CC CC AC }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_04_beta_1_by_Alex_additional: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 }
    condition:
        $a at pe.entry_point

}

rule MEW_11_SE_v10_Northfox_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Lattice_C_v30: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 8E D8 B8 ?? ?? 8E }
    condition:
        $a at pe.entry_point

}

rule WinUpack_v039_final_By_Dwing_c2005_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 39 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? ?? 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? 56 10 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 99 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B 7E 34 0F 82 AC FE FF FF 58 5F 59 E3 1B 8A 07 47 04 18 3C 02 73 F7 8B 07 3C ?? 75 F3 B0 00 0F C8 03 46 38 2B C7 AB E2 E5 5E 5D 59 46 AD 85 C0 74 1F 51 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V220070411_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        $a at pe.entry_point

}

rule SysPack_v01_Hint_DOS_EP: PEiD
{
    strings:
        $a = { ?? ?? 0E 2E ?? ?? ?? ?? 06 53 2E ?? ?? ?? ?? 26 ?? ?? ?? ?? 74 ?? 26 ?? ?? ?? ?? ?? 5B 07 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V118_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 ?? 83 3C 37 00 75 E6 }
    condition:
        $a at pe.entry_point

}

rule tElock_v07x_v084: PEiD
{
    strings:
        $a = { 60 E8 02 ?? ?? ?? CD 20 E8 ?? ?? ?? ?? 5E 2B C9 58 74 }
        $b = { 60 E8 00 00 C3 83 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_0977: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB A0 86 40 00 87 DD 8B 85 2A 87 40 00 01 85 94 86 40 00 66 C7 85 91 86 40 00 90 90 BB E1 06 00 00 03 9D 2E 87 40 00 03 9D 2A 87 40 00 53 53 53 58 2D FB }
    condition:
        $a at pe.entry_point

}

rule EXE32Pack_v137_additional: PEiD
{
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED 4C 8E 40 }
    condition:
        $a at pe.entry_point

}

rule PECompact_0978: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 24 88 40 00 87 DD 8B 85 A9 88 40 00 01 85 18 88 40 00 66 C7 85 15 88 40 00 90 90 BB A8 09 00 00 03 9D AD 88 40 00 03 9D A9 88 40 00 53 53 53 58 2D 7F }
    condition:
        $a at pe.entry_point

}

rule Inset_Systems_PIX_Graphics_format: PEiD
{
    strings:
        $a = { 03 00 ?? 00 00 00 20 00 }
    condition:
        $a at pe.entry_point

}

rule Unnamed_Scrambler_12C_12D_p0ke_additional: PEiD
{
    strings:
        $a = { 55 8B EC B9 05 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 ?? 3A ?? ?? E8 ?? EC FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? D7 FF FF E8 ?? ?? FF FF B8 20 ?? ?? ?? 33 C9 BA 04 01 00 00 E8 ?? DB FF FF 68 04 01 00 00 68 20 ?? ?? ?? 6A 00 FF 15 10 ?? ?? ?? BA ?? ?? ?? ?? B8 14 ?? ?? ?? E8 ?? ?? FF FF 85 C0 0F 84 ?? 04 00 00 BA 18 ?? ?? ?? 8B 0D 14 ?? ?? ?? E8 ?? ?? FF FF 8B 05 88 ?? ?? ?? 8B D0 B8 54 ?? ?? ?? E8 ?? E3 FF FF B8 54 ?? ?? ?? E8 ?? E2 FF FF 8B D0 B8 18 ?? ?? ?? 8B 0D 88 ?? ?? ?? E8 ?? D6 FF FF FF 35 34 ?? ?? ?? FF 35 30 ?? ?? ?? FF 35 3C ?? ?? ?? FF 35 38 ?? ?? ?? 8D 55 E8 A1 88 ?? ?? ?? E8 ?? F0 FF FF 8B 55 E8 B9 54 }
    condition:
        $a at pe.entry_point

}

rule IDA_Interactive_Disassembler_database_Hint_FILE_START: PEiD
{
    strings:
        $a = { 49 44 41 }
    condition:
        $a at pe.entry_point

}

rule Lotus_Word_Pro_document_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 57 6F 72 64 50 72 6F ?? ?? ?? ?? ?? ?? ?? ?? ?? 4C 57 50 37 }
    condition:
        $a at pe.entry_point

}

rule Splice_11_by_Tw1sted_L0gic: PEiD
{
    strings:
        $a = { 68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC 29 40 00 07 00 00 00 BC 28 40 00 07 00 00 00 74 28 40 00 07 00 00 00 2C 28 40 00 07 00 00 00 08 23 40 00 01 00 00 00 38 21 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 8C 21 40 00 08 ?? 40 00 01 00 00 00 AC 19 40 00 00 00 00 00 00 00 00 00 00 00 00 00 AC 19 40 00 4F 00 43 00 50 00 00 00 E7 AF 58 2F 9A 4C 17 4D B7 A9 CA 3E 57 6F F7 76 }
        $b = { 68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_v080_v084_additional: PEiD
{
    strings:
        $a = { 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 ?? ?? ?? 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE FC }
    condition:
        $a at pe.entry_point

}

rule RCryptor_V16d_Vaska_Sign_by_fly: PEiD
{
    strings:
        $a = { 60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule Xtreme_Protector_100_105_Rafael_Ahucha_Sergio_Lara: PEiD
{
    strings:
        $a = { E9 ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule y0das_Crypter_v11_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 8A 1C 40 00 B9 9E 00 00 00 8D BD 4C 23 40 00 8B F7 33 }
    condition:
        $a at pe.entry_point

}

rule Gem_VDI_Image_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 01 00 ?? 00 ?? 00 01 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1987_or_Borland_Cpp_1991_additional: PEiD
{
    strings:
        $a = { FB BA ?? ?? 2E 89 ?? ?? ?? B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule PESHiELD_v0251: PEiD
{
    strings:
        $a = { 5D 83 ED 06 EB 02 EA 04 8D }
    condition:
        $a at pe.entry_point

}

rule aPack_v098b_com_additional: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? 8B CF FC 57 F3 A4 C3 BF ?? ?? 57 57 BE ?? ?? B2 ?? BD ?? ?? 50 A4 }
    condition:
        $a at pe.entry_point

}

rule PE_Lock_NT_v203_additional: PEiD
{
    strings:
        $a = { EB 02 C7 85 1E EB 03 CD 20 C7 9C EB 02 69 B1 60 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule UPX_v071_DLL_additional: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 95 01 00 00 60 E8 00 00 00 00 83 }
    condition:
        $a at pe.entry_point

}

rule Sphinx_C_v_19_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? B4 34 CD 21 8C 06 ?? ?? 89 1E ?? ?? B8 ?? ?? E8 ?? ?? B8 ?? ?? BB }
    condition:
        $a at pe.entry_point

}

rule VProtect_2050618Cloud_CoooLie: PEiD
{
    strings:
        $a = { 60 F6 D3 66 F7 D2 66 F7 D2 F6 D3 61 66 91 60 F7 D3 F7 D3 61 66 91 8B 67 28 8B C9 66 55 66 5D 61 66 8B FF 66 52 66 5A 66 50 66 58 8D 80 F3 FF FF FF 9C 9D 8D 80 0D 00 00 00 60 61 9D 51 8D 80 E5 FF FF FF 8D 80 1B 00 00 00 59 8D 9B ED FF FF FF 50 66 87 CE 8B D2 66 87 CE 58 8D 9B 13 00 00 00 8D 89 FB FF FF FF 60 66 F7 D3 8D 89 FD FF FF FF 8D 89 03 00 00 00 66 F7 D3 61 8D 89 05 00 00 00 66 53 8D AD F5 FF FF FF 8A FF 8D AD 0B 00 00 00 66 5B }
    condition:
        $a at pe.entry_point

}

rule Vx_Keypress1212_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? E8 ?? ?? E8 ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EA ?? ?? ?? ?? 1E 33 DB 8E DB BB }
    condition:
        $a at pe.entry_point

}

rule WIBU_Key_V410A_WIBU_SYSTEMS_AG_Sign_by_fly: PEiD
{
    strings:
        $a = { F7 05 ?? ?? ?? ?? FF 00 00 00 75 12 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cue_50p_MFC: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9 }
    condition:
        $a at pe.entry_point

}

rule GHF_Protector_GPcH_additional: PEiD
{
    strings:
        $a = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 A0 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Cpp: PEiD
{
    strings:
        $a = { 03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 AB EB 02 CD 20 5E 80 CB AA 2B F1 EB 02 CD 20 43 0F BE 38 13 D6 80 C3 47 2B FE EB 01 F4 03 FE EB 02 4F 4E 81 EF 93 53 7C 3C 80 C3 29 81 F7 8A 8F 67 8B 80 C3 C7 2B FE }
        $b = { C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Exe_Locker_V10_IonIce: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 8B 6C 24 20 81 ED 05 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v140b5_v140b6: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 8A 11 }
    condition:
        $a at pe.entry_point

}

rule Werus_Crypter_10_by_Kas: PEiD
{
    strings:
        $a = { BB E8 12 40 00 80 33 05 E9 7D FF FF FF }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2021_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF ?? 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
        $b = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule fds0ft_c0m_pr0tect_v04b_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C CA 2E ?? ?? ?? ?? B4 30 8B ?? ?? ?? 8B ?? ?? ?? 8E DA A3 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule Comt_010d_original: PEiD
{
    strings:
        $a = { 45 4E 43 2E 43 4F 4D 2E 42 26 46 3D 0D 0A 25 30 30 25 40 40 50 5A 2D 72 6D 2D 72 6D 2D 4C 23 50 5F 52 5E 4E 31 35 52 58 2D 71 6E 2D 71 6E 50 2D 40 21 50 59 2D 21 70 2D 21 60 2D 21 30 50 5D 3D 0D 0A 58 2D 62 21 50 5F 57 52 5E 21 35 47 47 21 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_SKE_2122_dll_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v133a_dulekxt: PEiD
{
    strings:
        $a = { BE A8 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 }
    condition:
        $a at pe.entry_point

}

rule SLR_OPTLINK_1: PEiD
{
    strings:
        $a = { 87 C0 EB ?? 71 ?? 02 D8 }
    condition:
        $a at pe.entry_point

}

rule StarForce_Protection_Driver_Protection_Technology_h: PEiD
{
    strings:
        $a = { 57 68 ?? 0D 01 00 68 00 ?? ?? 00 E8 50 ?? FF FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule vfpexeNc_v600_Wang_JianGuo: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 63 58 E8 01 00 00 00 7A 58 2D 0D 10 40 00 8D 90 C1 10 40 00 52 50 8D 80 49 10 40 00 5D 50 8D 85 65 10 40 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC }
    condition:
        $a at pe.entry_point

}

rule UPX_v072_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 83 ?? ?? 31 DB 5E 8D ?? ?? ?? ?? ?? 57 66 ?? ?? ?? ?? ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_PENinja_131_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 }
    condition:
        $a at pe.entry_point

}

rule ExeSafeguard_v10_simonzh_additional: PEiD
{
    strings:
        $a = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE }
    condition:
        $a at pe.entry_point

}

rule EPW_v130: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 83 C0 10 2E }
    condition:
        $a at pe.entry_point

}

rule IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER_h: PEiD
{
    strings:
        $a = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
        $b = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Obsidium_V1258_V133X_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 ?? 00 00 00 EB 02 ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule Vx_Hafen1641_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 01 ?? ?? ?? CE CC 25 ?? ?? 25 ?? ?? 25 ?? ?? 40 51 D4 ?? ?? ?? CC 47 CA ?? ?? 46 8A CC 44 88 CC }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b2_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
    condition:
        $a at pe.entry_point

}

rule Installer_VISE_Custom_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D }
    condition:
        $a at pe.entry_point

}

rule Petite_v_after_v14_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule UPXLock_v11_CyberDoom_Bob_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? 00 60 }
    condition:
        $a at pe.entry_point

}

rule DOS32_33: PEiD
{
    strings:
        $a = { 0E 1F FC 9C 5B 8B C3 80 F4 40 50 9D 9C 58 3A E7 75 0B BA 87 20 B4 09 CD 21 B4 4C CD 21 8C 06 CA 00 26 A1 2C 00 A3 C8 00 8C 0E 98 00 8C 06 9C 00 8C 06 A0 00 0E 07 33 C0 BF A0 22 B9 A0 51 2B CF D1 E9 F3 AB BA EE 0D 81 EA C4 47 B9 6A 10 BB BF }
    condition:
        $a at pe.entry_point

}

rule aPack_069_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE A0 01 BF 00 01 50 57 FC B6 01 BD 81 01 FF D5 73 61 FF D5 73 1C FF D5 73 3F BB 98 01 33 C9 FF D3 FF D3 FF D3 FF D3 8B D9 B1 01 85 DB 75 3A 93 EB 3C E8 4C 00 49 49 75 0A 2E 8B 1E 00 01 E8 40 00 EB 26 49 AC }
    condition:
        $a at pe.entry_point

}

rule IMPostor_Pack_10_Mahdi_Hezavehi_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? 00 83 C6 01 FF E6 00 00 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? 02 ?? ?? 00 10 00 00 00 02 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_V12_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 80 BD E0 04 00 00 01 0F 84 F2 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_: PEiD
{
    strings:
        $a = { 91 EB 02 CD 20 BF 50 BC 04 6F 91 BE D0 ?? ?? 6F EB 02 CD 20 2B F7 EB 02 F0 46 8D 1D F4 00 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_18X_19X_SetiSoft_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 }
    condition:
        $a at pe.entry_point

}

rule T_PACK_v05c_m1: PEiD
{
    strings:
        $a = { 68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 8E FE }
    condition:
        $a at pe.entry_point

}

rule T_PACK_v05c_m2: PEiD
{
    strings:
        $a = { 68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 CE FD }
    condition:
        $a at pe.entry_point

}

rule Virtual_Image_Maker_Graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 53 4F 4D 56 }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_BeRo_Farbrausch: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC ?? ?? ?? ?? A4 ?? ?? ?? ?? 00 ?? ?? ?? ?? 33 C9 E8 64 00 00 00 73 1C ?? ?? ?? ?? 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 ?? ?? ?? ?? D4 E8 }
        $b = { 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 BA ?? ?? ?? ?? 8D B2 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule bambam_V004_bedrock: PEiD
{
    strings:
        $a = { BF ?? ?? ?? ?? 83 C9 FF 33 C0 68 ?? ?? ?? ?? F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 11 0A 00 00 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 BF ?? ?? ?? ?? 8B D1 68 ?? ?? ?? ?? C1 E9 02 F3 AB 8B CA 83 E1 03 F3 }
    condition:
        $a at pe.entry_point

}

rule ACE_SFX_Archive_Hint_HDR_FILESIZE_p_7: PEiD
{
    strings:
        $a = { 2A 2A 41 43 45 2A 2A }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v19x: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 98 ?? ?? ?? 68 10 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Microsoft_Visual_Basic_50_60_Anorganix: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_03: PEiD
{
    strings:
        $a = { 06 1E 57 56 50 53 51 52 BD ?? ?? 0E 1F 8C }
    condition:
        $a at pe.entry_point

}

rule Encriptor_100: PEiD
{
    strings:
        $a = { B9 60 EA BE 87 01 BF 87 01 AC D0 C8 AA E2 FA BE 6E 01 BF 48 EE AC AA 81 FE 87 01 75 F8 8C C8 BF 48 EE FF E7 BE 88 01 BF 00 01 B9 60 EA F3 A4 B8 00 00 BB 00 00 B9 00 00 BF 00 01 FF E7 24 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_01: PEiD
{
    strings:
        $a = { EB ?? ?? BE ?? ?? BF ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_07: PEiD
{
    strings:
        $a = { 8C C8 05 ?? ?? 50 B8 ?? ?? 50 B0 ?? 06 8C D2 06 83 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_06: PEiD
{
    strings:
        $a = { FA B8 ?? ?? BE ?? ?? 33 F0 0E 17 2E ?? ?? ?? BA ?? ?? 87 E6 5B 33 DC }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_05: PEiD
{
    strings:
        $a = { FA BB ?? ?? B9 ?? ?? 87 E5 87 27 03 E3 91 8A CB 80 E1 ?? D3 C4 91 33 E3 87 27 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_04: PEiD
{
    strings:
        $a = { BC ?? ?? C3 2E FF 2E ?? ?? CF }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_08: PEiD
{
    strings:
        $a = { 8B C4 2D ?? ?? 24 00 8B F8 57 B9 ?? ?? BE ?? ?? F3 A5 FD C3 97 4F 4F }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    strings:
        $a = { 1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13 }
        $b = { 1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13 D6 83 C7 32 F7 DA 03 FE EB 02 CD 20 87 FA 88 10 EB 02 CD 20 40 E8 02 00 00 00 F1 F8 5B 4E 2B D2 85 F6 75 AF EB 02 DE 09 EB 01 EF 34 4A 7C BC 7D 3D 7F 90 C1 82 41 ?? ?? ?? 87 DB 71 94 8B 8C 8D 90 61 05 96 1C A9 DA A7 68 5A 4A 19 CD 76 40 50 A0 9E B4 C5 15 9B D7 6E A5 BB CC 1C C2 DE 6C AC C2 D3 23 D2 65 B5 F5 65 C6 B6 CC DD CC 7B 2F B6 33 FE 6A AC 9E AB 07 C5 C6 C7 F3 94 3F DB B4 05 CE CF D0 BC FA 7F A5 BD 4A 18 EB A2 C5 F7 6D 25 9F BF E8 8D CA 05 E4 E5 E6 24 E8 66 EA EB 5F F7 6E EB F5 64 F8 76 EC 74 6D F9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SDProtector_V11X_Randy_Li_Sign_by_fly: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1 }
    condition:
        $a at pe.entry_point

}

rule PKTINY_v10_with_TINYPROG_v38_additional: PEiD
{
    strings:
        $a = { 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? E9 ?? ?? E8 ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_440_Silicon_Realms_Toolworks_h: PEiD
{
    strings:
        $a = { 31 2E 31 2E 34 00 00 00 C2 E0 94 BE 93 FC DE C6 B6 24 83 F7 D2 A4 92 77 40 27 CF EB D8 6F 50 B4 B5 29 24 FA 45 08 04 52 D5 1B D2 8C 8A 1E 6E FF 8C 5F 42 89 F1 83 B1 27 C5 69 57 FC 55 0A DD 44 BE 2A 02 97 6B 65 15 AA 31 E9 28 7D 49 1B DF B5 5D 08 A8 BA A8 }
        $b = { 31 2E 31 2E 34 00 00 00 C2 E0 94 BE 93 FC DE C6 B6 24 83 F7 D2 A4 92 77 40 27 CF EB D8 6F 50 B4 B5 29 24 FA 45 08 04 52 D5 1B D2 8C 8A 1E 6E FF 8C 5F 42 89 F1 83 B1 27 C5 69 57 FC 55 0A DD 44 BE 2A 02 97 6B 65 15 AA 31 E9 28 7D 49 1B DF B5 5D 08 A8 BA A8 73 DC F6 D1 05 42 55 53 79 73 74 65 6D 00 00 53 00 79 00 73 00 74 00 65 00 6D 00 00 00 00 00 44 44 45 20 50 72 6F 63 65 73 73 69 6E 67 00 00 53 77 50 44 44 45 00 00 44 00 44 00 45 00 20 00 50 00 72 00 6F 00 63 00 65 00 73 00 73 00 69 00 6E 00 67 00 00 00 00 00 53 00 77 00 50 00 44 00 44 00 45 00 00 00 00 00 3C 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Sentinel_UltraPro_Dongle_V110_SafeNet_Inc_SignByfly_additional: PEiD
{
    strings:
        $a = { A1 ?? ?? ?? ?? 85 C0 0F 85 59 06 00 00 55 56 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE ?? ?? ?? 0D 01 ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 BD 0F 00 00 83 C4 }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Registration_file_v10_Hint_FILE_START: PEiD
{
    strings:
        $a = { 24 46 41 52 45 47 24 4D 2D ?? ?? ?? ?? 31 }
    condition:
        $a at pe.entry_point

}

rule Upx_Lock_10_12_CyberDoom_Team_X_BoB_BobSoft: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 48 12 40 00 60 E8 2B 03 00 00 61 }
    condition:
        $a at pe.entry_point

}

rule GameGuard_nProtect_additional: PEiD
{
    strings:
        $a = { 31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE ?? ?? ?? ?? 31 FF 74 06 61 E9 4A 4D 50 30 8D BE ?? ?? ?? ?? 31 C9 74 06 61 E9 4A 4D 50 30 B8 7D 00 00 00 39 C2 B8 4C 00 00 00 F7 D0 75 3F 64 A1 30 00 00 00 85 C0 78 23 8B 40 0C 8B 40 0C C7 40 20 00 10 00 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 85 C0 75 16 E9 12 00 00 00 31 C0 64 A0 20 00 00 00 85 C0 75 05 E9 01 00 00 00 61 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v133_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A2 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 ?? 80 40 ?? 90 90 01 85 9E 80 40 ?? BB 2D 12 }
    condition:
        $a at pe.entry_point

}

rule UPX_v0896_v102_v105_v122_DLL_additional: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? 00 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_runtime_system_1995: PEiD
{
    strings:
        $a = { 53 56 57 55 8B 00 24 14 8B 00 24 18 8B 6C 24 1C 83 00 03 0F 87 00 01 00 00 89 00 2E FF 24 85 }
    condition:
        $a at pe.entry_point

}

rule eXPressorProtectionV1701_CGSoftLabs_20090606: PEiD
{
    strings:
        $a = { C3 EB 01 ?? 55 8B EC 83 EC 0C 53 56 57 EB 01 ?? 83 ?? ?? ?? ?? ?? ?? 74 08 EB 01 ?? E9 56 01 00 00 EB 02 ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB 01 ?? E8 ?? ?? ?? ?? EB 02 ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 ?? EB 02 ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 01 ?? 83 65 F8 00 EB 07 8B 45 F8 40 89 45 F8 83 7D F8 61 73 1F EB 02 ?? ?? 8B 45 F8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 01 EB EB ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 83 C4 10 89 45 F4 EB 02 ?? ?? 83 7D F4 00 75 0A 6A 00 A1 ?? ?? ?? ?? FF 50 14 EB 01 ?? F3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? 89 45 FC 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 F4 E8 01 00 00 00 81 83 04 24 06 C3 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v20_Hide_EP_Vaska_additional: PEiD
{
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 DC 20 ?? 00 F7 D1 83 F1 FF E8 00 00 00 00 F7 D1 83 F1 FF C3 }
    condition:
        $a at pe.entry_point

}

rule DIET_v102b_v110a_v120_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 3B FC 72 ?? B4 4C CD 21 FD F3 A5 FC }
    condition:
        $a at pe.entry_point

}

rule Pi_Cryptor_10_by_Scofield: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF 74 4E 6A 00 53 E8 CD FA FF FF 8B F8 81 EF AC 26 00 00 6A 00 6A 00 68 AC 26 00 00 53 E8 DE FA FF FF 89 F8 E8 E3 F1 FF FF 89 C6 6A 00 68 28 31 06 00 57 56 53 E8 AE FA FF FF 53 E8 80 FA FF FF 89 FA 81 EA 72 01 00 00 8B C6 E8 55 FE FF FF 89 C6 89 F0 09 C0 74 05 E8 A8 FB FF FF 31 C0 }
        $b = { 55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF 74 4E 6A 00 53 E8 CD FA FF FF 8B F8 81 EF AC 26 00 00 6A 00 6A 00 68 AC 26 00 00 53 E8 DE FA FF FF 89 F8 E8 E3 F1 FF FF 89 C6 6A 00 68 28 31 06 00 57 56 53 E8 AE FA FF FF 53 E8 80 FA FF FF 89 FA 81 EA 72 01 00 00 8B C6 E8 55 FE FF FF 89 C6 89 F0 09 C0 74 05 E8 A8 FB FF FF 31 C0 5A 59 59 64 89 10 68 3D 1F 06 00 8D 45 EC E8 C3 F6 FF FF C3 }
        $c = { 55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_140b2_140b4: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 00 87 DD 8B 85 A6 A0 40 00 01 85 03 A0 40 00 66 C7 85 00 A0 40 00 90 90 01 85 9E A0 40 00 BB 86 11 00 00 03 9D AA A0 40 00 03 9D A6 A0 40 00 }
    condition:
        $a at pe.entry_point

}

rule EPW_130_COM: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 BB 03 00 81 C3 00 01 2E 8B 07 8C CB 03 C3 83 C0 10 50 B8 D1 00 50 CB 8C C0 83 C0 10 8E C0 83 C0 05 8E D8 2E 8B 0E 00 00 2B F6 2B FF FC F3 A4 0E 1F BA 1E 00 B4 09 CD 21 BB 0E 00 B9 10 00 B4 00 CD 16 3C 0D 74 09 3C }
    condition:
        $a at pe.entry_point

}

rule Vx_Agiplan1536_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 50 B0 ?? BA ?? ?? EE BA ?? ?? EC 3C ?? 76 ?? E9 ?? ?? B8 ?? ?? CD 21 8C D8 8E C0 83 ?? ?? 75 ?? E9 ?? ?? BA ?? ?? B8 ?? ?? CD 21 B8 ?? ?? CD 21 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_CrunchPE_Heuristic_Anorganix: PEiD
{
    strings:
        $a = { 55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule PC_Guard_v500d: PEiD
{
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C }
        $b = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 85 E1 EA 41 00 9C EB 01 D5 9D EB 01 0B 58 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 85 F9 EA 41 00 9C EB 01 D5 9D EB 01 0B 89 9D E5 EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 8D E9 EA 41 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 95 ED EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 B5 F1 EA 41 00 9C EB 01 D5 9D EB 01 0B 89 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule HACKSTOP_v119: PEiD
{
    strings:
        $a = { 52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? D6 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB }
    condition:
        $a at pe.entry_point

}

rule Vx_CIH_Version_12_TTIT_WIN95CIH_additional: PEiD
{
    strings:
        $a = { 55 8D ?? ?? ?? 33 DB 64 87 03 E8 ?? ?? ?? ?? 5B 8D }
    condition:
        $a at pe.entry_point

}

rule HACKSTOP_v113: PEiD
{
    strings:
        $a = { 52 B8 ?? ?? 1E CD 21 86 E0 3D ?? ?? 73 ?? CD 20 0E 1F B4 09 E8 ?? ?? 24 ?? EA }
    condition:
        $a at pe.entry_point

}

rule EXE_Stealth_v272_additional: PEiD
{
    strings:
        $a = { EB 00 EB 2F 53 68 61 72 65 77 61 72 65 20 2D 20 }
    condition:
        $a at pe.entry_point

}

rule JEDMICS_CCITT4_Graphics_format: PEiD
{
    strings:
        $a = { 80 00 00 00 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule CreateInstall_200335: PEiD
{
    strings:
        $a = { 81 EC 0C 04 00 00 53 56 57 55 68 60 50 40 00 6A 01 6A 00 FF 15 D8 80 40 00 8B F0 FF 15 D4 80 40 00 3D B7 00 00 00 75 0F 56 FF 15 B8 80 40 00 6A 02 FF 15 A4 80 40 00 33 DB E8 F2 FE FF FF 68 02 7F 00 00 89 1D 94 74 40 00 53 89 1D 98 74 40 00 FF 15 E4 80 40 }
    condition:
        $a at pe.entry_point

}

rule Phar_Lap_DOS_Extender_1986_91_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 8C D8 8E C0 B8 ?? ?? 8E D8 BB ?? ?? 8C C0 2B D8 81 ?? ?? ?? B4 4A CD 21 }
    condition:
        $a at pe.entry_point

}

rule aPack_v098_m_additional: PEiD
{
    strings:
        $a = { 1E 06 8C C8 8E D8 05 ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B2 ?? BD ?? ?? 33 C9 50 A4 BB ?? ?? 3B F3 76 }
    condition:
        $a at pe.entry_point

}

rule aPack_066_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 9C 01 BF 00 01 50 57 FC B6 01 BD 7D 01 FF D5 73 5D FF D5 73 1C FF D5 73 3B BB 94 01 33 C9 FF D3 FF D3 FF D3 FF D3 8B D9 B1 01 85 DB 75 36 93 EB 38 E8 48 00 49 49 75 06 2E A1 00 01 EB 08 49 AC 8A E1 2E A3 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v123_RC4_build_0807_dll_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule COOLcryptor_09_kongfoo: PEiD
{
    strings:
        $a = { E8 03 00 00 00 E9 EB 07 FF 04 24 EB 01 FF C3 E8 03 00 00 00 EB 02 EA C3 EB 08 8D 8D 72 08 }
    condition:
        $a at pe.entry_point

}

rule PEnguinCrypt_v10_additional: PEiD
{
    strings:
        $a = { B8 8C D3 15 33 75 81 3E E8 0F 00 9A E8 F9 FF 9A 9C EB 01 9A 59 80 CD 01 51 9D EB }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_10_JunkCode_additional: PEiD
{
    strings:
        $a = { 60 9C BE 00 10 40 00 8B FE B9 ?? ?? ?? ?? BB 78 56 34 12 AD 33 C3 AB E2 FA 9D 61 E9 ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule Borland_Pascal_v70_for_Windows: PEiD
{
    strings:
        $a = { A1 C1 A3 83 75 57 51 33 C0 }
        $b = { 9A FF FF 00 00 9A FF FF 00 00 55 89 E5 31 C0 9A FF FF 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_108_additional: PEiD
{
    strings:
        $a = { 90 90 90 75 01 90 E9 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_V310X_Thinstall_Company: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 }
        $b = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Jam_211_EXE: PEiD
{
    strings:
        $a = { 50 06 16 07 BE 22 02 8B FE B9 12 01 FD FA F3 2E A5 FB 06 BD 78 00 55 CB BE 00 00 8B FE BD 00 00 55 8D 9E 00 00 8D 97 00 00 B9 00 00 80 EF 10 8E DB 80 EE 10 8E C2 F3 A5 B5 80 3B DD 77 EE 33 C9 BE 00 00 8B FE 8E DA 8E C3 FC BA 01 00 EB 5E 5D }
    condition:
        $a at pe.entry_point

}

rule Vx_FaxFreeTopo_additional: PEiD
{
    strings:
        $a = { FA 06 33 C0 8E C0 B8 ?? ?? 26 ?? ?? ?? ?? 50 8C C8 26 ?? ?? ?? ?? 50 CC 58 9D 58 26 ?? ?? ?? ?? 58 26 ?? ?? ?? ?? 07 FB }
    condition:
        $a at pe.entry_point

}

rule SimplePack_1X_Method2_bagie_additional: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190c: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 10 F2 40 00 68 74 9D 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_V01_V015_NTkrnl_Software: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190a: PEiD
{
    strings:
        $a = { 55 8B EC 64 FF 68 10 F2 40 00 68 14 9B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule WARNING_TROJAN_ADinjector_additional: PEiD
{
    strings:
        $a = { 90 61 BE 00 20 44 00 8D BE 00 F0 FB FF C7 87 9C E0 04 00 6A F0 8A 5E 57 83 CD FF EB 0E }
    condition:
        $a at pe.entry_point

}

rule EPW_120_COM: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 BB 03 00 81 C3 00 01 2E 8B 07 8C CB 03 C3 05 10 00 50 B8 F3 00 50 CB 8C C0 05 10 00 8E C0 05 05 00 8E D8 2E 8B 0E 00 00 2B F6 2B FF FC F3 A4 0E 1F BA 20 00 B4 09 CD 21 BB 00 00 B9 10 00 B8 20 09 CD 10 BA 0E 00 B4 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_620: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 55 8B EC 83 EC 50 53 56 57 BE 90 90 90 90 8D 7D F4 A5 A5 66 A5 8B }
    condition:
        $a at pe.entry_point

}

rule SuckStop_v111_additional: PEiD
{
    strings:
        $a = { 68 2C 11 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 00 00 00 38 00 00 00 00 00 00 00 37 BB 71 EC A4 E1 98 4C 9B FE 8F 0F FA 6A 07 F6 00 00 00 00 00 00 01 00 00 00 20 20 46 6F 72 20 73 74 75 64 00 20 54 6F 00 00 00 00 06 00 00 00 CC 1A 40 00 07 00 00 00 D4 }
    condition:
        $a at pe.entry_point

}

rule XCR_v013_additional: PEiD
{
    strings:
        $a = { 93 71 08 ?? ?? ?? ?? ?? ?? ?? ?? 8B D8 78 E2 ?? ?? ?? ?? 9C 33 C3 ?? ?? ?? ?? 60 79 CE ?? ?? ?? ?? E8 01 ?? ?? ?? ?? 83 C4 04 E8 AB FF FF FF ?? ?? ?? ?? 2B E8 ?? ?? ?? ?? 03 C5 FF 30 ?? ?? ?? ?? C6 ?? EB }
    condition:
        $a at pe.entry_point

}

rule PE_Diminisher_V01_Teraphy: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v150_Device_driver_compression: PEiD
{
    strings:
        $a = { B4 09 BA 14 01 CD 21 B8 00 4C CD 21 F8 9C 50 53 51 52 56 57 55 1E 06 BB }
    condition:
        $a at pe.entry_point

}

rule ExeSplitter_12_Bill_Prisoner_TPOC_additional: PEiD
{
    strings:
        $a = { E9 95 02 00 00 64 A1 00 00 00 00 83 38 FF 74 04 8B 00 EB F7 8B 40 04 C3 55 8B EC B8 00 00 00 00 8B 75 08 81 E6 00 00 FF FF B9 06 00 00 00 56 56 E8 B0 00 00 00 5E 83 F8 01 75 06 8B C6 C9 C2 04 00 81 EE 00 00 01 00 E2 E5 C9 C2 04 00 55 8B EC 8B 75 0C 8B DE }
    condition:
        $a at pe.entry_point

}

rule PEtite_v13_additional: PEiD
{
    strings:
        $a = { 66 9C 60 50 8D 88 ?? F0 ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 68 ?? ?? ?? ?? 53 50 80 04 24 08 50 80 04 24 42 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_1X_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    strings:
        $a = { 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 52 65 67 43 6C 6F 73 65 4B 65 79 00 00 00 53 79 73 46 72 65 65 53 74 72 69 6E 67 00 00 00 43 72 65 61 74 65 46 6F 6E 74 41 00 00 00 53 68 65 6C 6C 45 78 65 63 75 74 65 41 00 00 }
        $b = { 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_2xx_BitSum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version: PEiD
{
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_PE_Protect_09_Anorganix: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 }
    condition:
        $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v60: PEiD
{
    strings:
        $a = { 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        $a at pe.entry_point

}

rule D1S1G_v11_beta_D1N: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 ?? ?? 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00 }
        $b = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WWPACK_v305c4_Extractable_p_Virus_Shield: PEiD
{
    strings:
        $a = { 03 05 40 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_MSVCpp_60_DLL_emadicius_h: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule LCC_Win32_v1x_additional: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 ?? ?? 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? 00 00 83 EC 10 }
    condition:
        $a at pe.entry_point

}

rule ZM_Exe_Executable_Image: PEiD
{
    strings:
        $a = { 5A 4D }
    condition:
        $a at pe.entry_point

}

rule PuNkMoD_10_PuNkDuDe: PEiD
{
    strings:
        $a = { 94 B9 60 01 00 00 BC ?? ?? 40 00 80 34 0C ?? E2 FA EB DF }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_07: PEiD
{
    strings:
        $a = { 2E 8C 1E ?? ?? BB ?? ?? 8E DB 1E E8 ?? ?? 1F 8B 1E ?? ?? 0B DB 74 ?? 8C D1 8B D4 FA 8E D3 BC ?? ?? FB }
    condition:
        $a at pe.entry_point

}

rule aPack_099_f_m_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 00 01 BF 00 01 50 57 FC B2 80 BD 00 01 50 A4 FF D5 73 FB FF D5 41 73 12 FF D5 BB 10 00 72 00 FF D5 12 DB 73 FA 75 00 93 EB 00 B7 01 FF D5 12 FF 72 00 FF D5 72 F6 FF D5 13 C9 FF D5 72 F8 80 EF 03 72 00 8A }
    condition:
        $a at pe.entry_point

}

rule UPX_p_ECLiPSE_layer: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 33 D2 EB 01 0F 56 EB 01 0F E8 03 00 00 00 EB 01 0F EB 01 0F 5E EB 01 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_151_GlOFF: PEiD
{
    strings:
        $a = { 90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 8F 02 00 00 A3 19 30 40 00 90 87 FF 90 8B 15 09 30 40 00 81 C2 04 01 00 00 F7 DA 6A 02 6A 00 52 }
        $b = { 90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PEncrypt_v30: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5D 81 ED 05 10 40 00 8D B5 24 10 40 00 8B FE B9 0F 00 00 00 BB ?? ?? ?? ?? AD 33 C3 E2 FA }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_LZMA: PEiD
{
    strings:
        $a = { 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 }
    condition:
        $a at pe.entry_point

}

rule HiJaak_Image_Draw_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 47 53 44 31 02 00 11 00 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_16d_by_Vaska_UsAr_sign_21032007_2222_additional: PEiD
{
    strings:
        $a = { 8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 40 A1 14 13 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 F2 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 E8 40 EB F3 C3 }
    condition:
        $a at pe.entry_point

}

rule Inno_Setup_Module_v109a_additional: PEiD
{
    strings:
        $a = { 55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 68 }
    condition:
        $a at pe.entry_point

}

rule FSG_v133_Eng_dulekxt: PEiD
{
    strings:
        $a = { BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF }
    condition:
        $a at pe.entry_point

}

rule UPXHiT_001_sibaway7yahoocom: PEiD
{
    strings:
        $a = { E2 FA 94 FF E0 61 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MarjinZ_EXE_Scrambler_SE_by_MarjinZ_additional: PEiD
{
    strings:
        $a = { E8 A3 02 00 00 E9 35 FD FF FF FF 25 C8 20 00 10 6A 14 68 C0 21 00 10 E8 E4 01 00 00 FF 35 7C 33 00 10 8B 35 8C 20 00 10 FF D6 59 89 45 E4 83 F8 FF 75 0C FF 75 08 FF 15 88 20 00 10 59 EB 61 6A 08 E8 02 03 00 00 59 83 65 FC 00 FF 35 7C 33 00 10 FF D6 89 45 }
    condition:
        $a at pe.entry_point

}

rule AutoLogic_Graphics_format: PEiD
{
    strings:
        $a = { FF 04 00 07 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v090_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? 40 00 C3 9C 60 BD ?? ?? 00 00 B9 02 00 00 00 B0 90 8D BD 7A 42 40 00 F3 AA 01 AD D9 43 40 00 FF B5 }
    condition:
        $a at pe.entry_point

}

rule Vx_Gotcha879_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5B 81 EB ?? ?? 9C FC 2E ?? ?? ?? ?? ?? ?? ?? 8C D8 05 ?? ?? 2E ?? ?? ?? ?? 50 2E ?? ?? ?? ?? ?? ?? 8B C3 05 ?? ?? 8B F0 BF 00 01 B9 20 00 F3 A4 0E B8 00 01 50 B8 DA DA CD 21 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V10X_V17X_DLL_Oreans_Technologies_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? ?? ?? ?? 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 }
    condition:
        $a at pe.entry_point

}

rule Added_HYPDOC_v10_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? E8 ?? ?? E8 ?? ?? 2E C6 ?? ?? ?? ?? 2E C6 06 ?? ?? ?? B9 ?? ?? 2E 8A 26 ?? ?? B0 ?? E8 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Cpp_620: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 55 8B EC 83 EC 50 53 56 57 BE 90 90 90 90 8D 7D F4 A5 A5 66 A5 8B }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ExeSmasher: PEiD
{
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B E9 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V01_cyberbob_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F 85 ?? ?? ?? ?? BB ?? ?? ?? ?? B9 A5 08 00 00 8D ?? ?? ?? ?? ?? 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule LameCrypt_v10_additional: PEiD
{
    strings:
        $a = { 60 66 9C BB ?? ?? ?? ?? 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61 }
    condition:
        $a at pe.entry_point

}

rule ASDPack_v10_asd_additional: PEiD
{
    strings:
        $a = { 55 8B EC 56 53 E8 5C 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 ?? ?? ?? 00 00 00 00 00 00 00 40 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1258_V133X_Obsidium_Software_Sign_by_fly: PEiD
{
    strings:
        $a = { EB 01 ?? E8 ?? 00 00 00 EB 02 ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule NsPack_31_by_North_Star_Liu_Xing_Ping: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 }
    condition:
        $a at pe.entry_point

}

rule RPolyCryptor_V142_Vaska_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PE_Protect_09_by_Cristoph_Gabler_1998_additional: PEiD
{
    strings:
        $a = { 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 }
    condition:
        $a at pe.entry_point

}

rule Visual_Cpp_31: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 00 00 40 00 68 00 00 40 00 50 64 89 25 00 00 00 00 83 EC 10 53 56 57 89 65 E8 FF 15 00 00 00 00 33 D2 8B C8 8A D4 81 E1 FF 00 00 00 C1 E8 10 89 15 00 00 40 00 89 0D 00 00 40 00 A3 00 00 40 00 C1 E1 08 03 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_QBasic_v30_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 8C C8 8E D8 E8 ?? ?? 8A 17 0A D2 74 ?? B4 ?? CD 21 43 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22006710_V220070411_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 00 }
        $b = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EncryptPE_12003518_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_2422_2428_Jitit: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D 9B 1A 00 00 B9 84 1A 00 00 BA 14 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD E0 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule SelfEnc_10: PEiD
{
    strings:
        $a = { BB 0F 01 B9 8F 18 33 C0 2E 80 2F 00 43 E2 F9 }
    condition:
        $a at pe.entry_point

}

rule Encapsulated_Postscript_graphics_file_v20_EPSF_12: PEiD
{
    strings:
        $a = { 25 21 50 53 2D 41 64 6F 62 65 2D 32 2E 30 20 45 50 53 46 2D 31 2E 32 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig1h_additional: PEiD
{
    strings:
        $a = { CC FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_FullEdition_V120_V121_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 10 00 00 08 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Windows_Help_file: PEiD
{
    strings:
        $a = { 3F 5F 03 }
    condition:
        $a at pe.entry_point

}

rule AinEXE_21: PEiD
{
    strings:
        $a = { A1 02 00 2D E1 0B 8E D0 BC 00 BE 8C D8 36 A3 00 BE 05 10 00 36 A3 02 BE 2E A1 0E 00 8A D4 B1 04 D2 EA FE C9 D3 E0 8C D3 36 8B 2E 02 BE 2E 03 2E 0E 00 FD 81 ED 00 10 80 EF 10 8E DD 8E C3 BE FE FF 8B FE FE CA 78 07 B9 00 80 F3 A5 EB E5 8B C8 }
    condition:
        $a at pe.entry_point

}

rule LHARC_SFX_Archive_v1131c_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? ?? ?? ?? ?? 24 4C 48 61 72 ?? 27 73 ?? 53 46 58 }
    condition:
        $a at pe.entry_point

}

rule Free_Pascal_v1010_win32_console_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? 00 01 E8 ?? ?? 00 00 C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5 ?? EC }
    condition:
        $a at pe.entry_point

}

rule Trivial173_by_SMTSMF: PEiD
{
    strings:
        $a = { EB ?? ?? 28 54 72 69 76 69 61 6C 31 37 33 20 62 79 20 53 4D 54 2F 53 4D 46 29 }
    condition:
        $a at pe.entry_point

}

rule EXELOCK_666_105: PEiD
{
    strings:
        $a = { BA 7E 08 BF 27 01 EB 01 EA E8 FB FE 48 79 7A 7F 2C 7E 2A 1C FA 48 78 F5 E3 AE 45 14 04 5A E9 F8 9E 89 18 96 01 5A B1 E0 08 E6 F2 8E FB 4A B1 9C 1D 9C 08 84 11 B1 F1 1F 1C F6 E5 22 CB 23 44 A0 CC 1B D9 BD D2 78 B6 B7 74 A6 E6 AF C4 71 62 AE }
    condition:
        $a at pe.entry_point

}

rule EXELOCK_666_104: PEiD
{
    strings:
        $a = { BA 20 08 BF E3 00 EB 01 EA E8 3F FF 7C 29 79 2F 1F F7 9C 75 F6 E6 A9 40 17 F9 A5 14 FB 9B 8E 1D EB 0D 55 BC E3 0D E1 F7 8D E6 55 AC FD 19 9B 0D E5 1D BE FC 1C 19 F1 E0 21 F6 1C 79 A3 C9 A7 DC BE DF 77 BB B4 71 A1 E3 AC D9 6E 7F AD AD 6A AE }
    condition:
        $a at pe.entry_point

}

rule Pe123_2006412: PEiD
{
    strings:
        $a = { 8B C0 60 9C E8 01 00 00 00 C3 53 E8 72 00 00 00 50 E8 1C 03 00 00 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B }
    condition:
        $a at pe.entry_point

}

rule EXELOCK_666_103: PEiD
{
    strings:
        $a = { BA 6C 07 BF 20 01 EB 01 EA E8 02 FF 7C 29 79 2F 1F F7 51 75 F6 E6 A9 40 17 F9 A5 14 FB 9B 8E 1D 7C 0D 55 BC E3 0D E1 F7 8D E6 55 AC 66 19 9B 0D 6E 1D BE FC 1C 19 F1 E0 21 F6 1C 79 A3 C9 A7 DC BE DF 77 BB B4 71 A1 E3 AC D9 6E 7F AD AD 6A AE }
    condition:
        $a at pe.entry_point

}

rule PCShrink_v040b_additional: PEiD
{
    strings:
        $a = { 9C 60 BD ?? ?? ?? ?? 01 ?? ?? ?? ?? ?? FF ?? ?? ?? ?? ?? 6A ?? FF ?? ?? ?? ?? ?? 50 50 2D }
    condition:
        $a at pe.entry_point

}

rule EXEStealth_275_WebtoolMaster_additional: PEiD
{
    strings:
        $a = { 33 C9 B4 4E CD 21 73 02 FF ?? BA ?? 00 B8 ?? 3D CD 21 }
    condition:
        $a at pe.entry_point

}

rule PESpin_13x_Cyberbob_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Thinstall_3035_Jtit_additional: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_Full_Edition_117_iBox_aPLib_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 79 29 00 00 8D 9D 2C 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 }
    condition:
        $a at pe.entry_point

}

rule Packanoid_V10_Arkanoid: PEiD
{
    strings:
        $a = { BF ?? ?? ?? ?? BE ?? ?? ?? ?? E8 9D 00 00 00 B8 ?? ?? ?? ?? 8B 30 8B 78 04 BB ?? ?? ?? ?? 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b2_Jeremy_Collake: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 94 60 }
    condition:
        $a at pe.entry_point

}

rule Unknown_SFX_Archive_IDSKA32_Hint_FILE_START: PEiD
{
    strings:
        $a = { 69 64 73 6B 61 33 32 }
    condition:
        $a at pe.entry_point

}

rule FreeBASIC_016b: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 90 90 90 90 90 90 90 90 90 90 }
        $b = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule AZProtect_0001_by_AlexZ_aka_AZCRC_additional: PEiD
{
    strings:
        $a = { FC 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 8B C2 C1 C0 10 66 8B C1 C3 F0 DA 55 8B EC 53 56 33 C9 33 DB 8B 4D 0C 8B 55 10 8B 75 08 4E 4A 83 }
    condition:
        $a at pe.entry_point

}

rule Launcher_Generator_103: PEiD
{
    strings:
        $a = { 68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_NorthStar_PE_Shrinker_13_Anorganix: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 00 00 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_UPX_0896_102_105_124_emadicius_h: PEiD
{
    strings:
        $a = { 60 BE 00 90 8B 00 8D BE 00 80 B4 FF 57 83 CD FF EB 3A 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 0B 75 19 8B 1E 83 EE FC 11 DB 72 10 58 61 90 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule SPEC_beta_3: PEiD
{
    strings:
        $a = { 5B 53 50 45 43 5D E8 00 00 00 00 5D 8B C5 81 ED 41 24 40 00 2B 85 89 26 40 00 83 E8 0B 89 85 8D 26 40 00 0F B6 B5 91 26 40 00 8B FD 8B 9D 8D 26 40 00 8B 87 96 26 40 00 03 D8 8B 8F 9A 26 40 00 8A 85 7C 26 40 00 00 03 FE C0 43 E2 F9 83 C7 08 }
    condition:
        $a at pe.entry_point

}

rule Diet_110a120_EXE: PEiD
{
    strings:
        $a = { FC 06 1E 0E 8C C8 01 06 35 01 BA 00 00 03 C2 8B D8 05 00 00 8E DB 8E C0 33 F6 33 FF B9 08 00 F3 A5 4B 48 4A 79 EE 8E C3 8E D8 BE 52 00 AD 8B E8 B2 10 EA 00 00 00 00 64 6C 7A }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_22004810_22005314_WFS_additional: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 7A }
    condition:
        $a at pe.entry_point

}

rule PureBasic_DLL_Neil_Hodgson: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 75 ?? 8B 44 24 04 A3 ?? ?? ?? 10 E8 }
    condition:
        $a at pe.entry_point

}

rule Vx_VCL_Hint_DOS_EP: PEiD
{
    strings:
        $a = { AC B9 00 80 F2 AE B9 04 00 AC AE 75 ?? E2 FA 89 }
    condition:
        $a at pe.entry_point

}

rule mPack_V003_DeltaAziz_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 ?? ?? 33 C0 89 45 F0 B8 ?? ?? ?? ?? E8 67 C4 FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 FA C9 FF FF 83 F8 FF 75 0A E8 88 B2 FF FF E9 1B 01 00 00 C7 05 ?? ?? ?? ?? 32 00 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 C9 C9 FF FF BA ?? ?? ?? ?? A1 ?? ?? ?? ?? B9 04 00 00 00 E8 C5 C9 FF FF 83 3D ?? ?? ?? ?? 32 77 0A E8 47 B2 FF FF E9 DA 00 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 92 C9 FF FF BA 18 A5 00 10 A1 ?? ?? ?? ?? B9 04 00 00 00 E8 8E C9 FF FF 83 F8 04 74 0A E8 14 B2 FF FF E9 A7 00 00 00 E8 0A CB FF FF A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 63 C9 FF FF 83 F8 FF 75 0A E8 F1 B1 FF FF E9 84 00 00 00 6A 00 6A 00 B8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 D4 CD FF FF 84 C0 75 07 E8 CF B1 FF FF EB 65 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 0F FA FF FF 3B 05 ?? ?? ?? ?? 75 0D A1 ?? ?? ?? ?? 8B 40 3C E8 6E FB FF FF 6A 03 E8 07 C4 FF FF A1 ?? ?? ?? ?? E8 C1 C6 FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 AA C6 FF FF A1 ?? ?? ?? ?? E8 A0 C6 FF FF C3 E9 AE B0 FF FF EB E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 A7 B5 FF FF C3 E9 91 B0 FF FF EB F0 E8 62 B4 FF FF }
    condition:
        $a at pe.entry_point

}

rule Vprotect_V200_CoooLie: PEiD
{
    strings:
        $a = { 57 5F 8D BF FA FF FF FF 55 66 8B C0 5D 8D BF 06 00 00 00 8A D2 8B C9 66 50 8D AD FD FF FF FF 8D AD 03 00 00 00 66 58 87 DF 66 F7 D2 55 8A C9 5D 66 F7 D2 87 DF 8B 67 28 50 66 8B C0 58 61 F6 D5 53 5B F6 D5 66 87 C6 51 59 66 87 C6 F7 D6 66 52 66 5A F7 D6 9D 8D B6 E5 FF FF FF 66 51 F6 D2 8B D2 F6 D2 66 59 8D B6 1B 00 00 00 66 51 66 59 }
    condition:
        $a at pe.entry_point

}

rule ExeShield_v37_ExeShield_Team_h: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F }
        $b = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F 8C B9 0A FC EC E4 82 97 AE 0F 18 D2 47 1B 65 EA 46 A5 FD 3E 9D 75 2A 62 80 60 F9 B0 0D E1 AC 12 0E 9D 24 D5 43 CE 9A D6 18 BF 22 DA 1F 72 76 B0 98 5B C2 64 BC AE D8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SVK_Protector_v132_Eng_Pavol_Cerven_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
    condition:
        $a at pe.entry_point

}

rule UPX_v20_Markus_Laszlo_Reiser_h_additional: PEiD
{
    strings:
        $a = { 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB ?? FF 96 ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? 00 00 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v12x_New_Strain_additional: PEiD
{
    strings:
        $a = { 68 01 ?? ?? ?? E8 01 ?? ?? ?? C3 C3 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_V102_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 3A 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 C3 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 }
    condition:
        $a at pe.entry_point

}

rule PC_Guard_v405d_v410d_v415d_additional: PEiD
{
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D EB 01 }
    condition:
        $a at pe.entry_point

}

rule Private_EXE_Protector_20_SetiSoft_additional: PEiD
{
    strings:
        $a = { 89 ?? ?? 38 00 00 00 8B ?? 00 00 00 00 81 ?? ?? ?? ?? ?? 89 ?? 00 00 00 00 81 ?? 04 00 00 00 81 ?? 04 00 00 00 81 ?? 00 00 00 00 0F 85 D6 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule ANDpakk2_apk2_V018_Dmitry_AND_Andreev_20080731: PEiD
{
    strings:
        $a = { FC BE ?? ?? ?? ?? BF ?? ?? ?? ?? 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD ?? ?? ?? ?? 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3 }
    condition:
        $a at pe.entry_point

}

rule PrivateEXE_v20a_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 06 60 C8 ?? ?? ?? 0E 68 ?? ?? 9A ?? ?? ?? ?? 3D ?? ?? 0F ?? ?? ?? 50 50 0E 68 ?? ?? 9A ?? ?? ?? ?? 0E }
    condition:
        $a at pe.entry_point

}

rule Vx_Hafen809_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 1C ?? 81 EE ?? ?? 50 1E 06 8C C8 8E D8 06 33 C0 8E C0 26 ?? ?? ?? 07 3D }
    condition:
        $a at pe.entry_point

}

rule pex_V099_params_additional: PEiD
{
    strings:
        $a = { E9 F5 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule CodeCrypt_015b_defiler: PEiD
{
    strings:
        $a = { E9 31 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F }
    condition:
        $a at pe.entry_point

}

rule PowerBASICCC_40_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 68 05 00 00 E9 6E 03 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v099_Jeremy_Collake: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 2F 85 40 ?? 87 DD 8B 85 B4 85 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_SKE_23_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 E5 0B 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C }
    condition:
        $a at pe.entry_point

}

rule Diet_145f_EXE: PEiD
{
    strings:
        $a = { F9 9C EB 09 00 00 0A 00 00 00 55 F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA 00 00 03 D0 52 BA 00 00 52 BA 00 00 03 C2 8B D8 05 00 00 8E DB 8E C0 33 F6 33 FF B9 08 00 F3 A5 4B 48 4A 79 EE 8E C3 8E D8 BE 67 00 AD 8B E8 B2 10 CB 64 6C 7A }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Protect_09_Anorganix_additional: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9 }
    condition:
        $a at pe.entry_point

}

rule Vx_Predator2448: PEiD
{
    strings:
        $a = { 0E 1F BF ?? ?? B8 ?? ?? B9 ?? ?? 49 ?? ?? ?? ?? 2A C1 4F 4F ?? ?? F9 CC }
    condition:
        $a at pe.entry_point

}

rule PUNiSHER_V15_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 3F 00 00 80 66 20 ?? 00 7E 20 ?? 00 92 20 ?? 00 A4 20 ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Morphine_12: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Trilobytes_JPEG_graphics_Library: PEiD
{
    strings:
        $a = { 84 10 FF FF FF FF 1E 00 01 10 08 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule XPack_167_additional: PEiD
{
    strings:
        $a = { B8 8C D3 15 33 75 81 3E E8 0F 00 9A E8 F9 FF 9A 9C EB 01 9A 59 80 CD 01 51 9D EB }
    condition:
        $a at pe.entry_point

}

rule Phonebook_packed_datafile_Hint_FILE_START: PEiD
{
    strings:
        $a = { 21 50 48 32 50 41 43 4B 24 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v42_DLL: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 68 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 53 56 }
        $b = { 53 B8 ?? ?? ?? ?? 8B ?? ?? ?? 56 57 85 DB 55 75 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CRYPT_Version_17_c_Dismember: PEiD
{
    strings:
        $a = { 0E 17 9C 58 F6 ?? ?? 74 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v13037_Obsidium_Software_h_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Microsoft_Visual_Cpp_70_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 89 65 00 8B F4 89 3E 56 FF 15 }
    condition:
        $a at pe.entry_point

}

rule SecuPack_v15: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 CC 3A 40 ?? E8 E0 FC FF FF 33 C0 55 68 EA 3C 40 ?? 64 FF 30 64 89 20 6A ?? 68 80 ?? ?? ?? 6A 03 6A ?? 6A 01 ?? ?? ?? 80 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V18X_V19X_DLL_Oreans_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D ?? ?? ?? ?? EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 05 89 48 01 61 E9 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190b4: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 08 E2 40 00 68 B4 96 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule RUE_132: PEiD
{
    strings:
        $a = { 68 00 01 60 BF 03 01 B9 00 00 B0 00 2E 30 05 FE C0 47 E2 F8 61 C7 06 00 01 E9 00 C6 06 02 01 00 C3 48 69 6E 74 3A 20 27 00 27 20 77 61 73 20 63 6F 6E 76 65 72 74 65 64 20 75 73 69 6E 67 20 52 4F 53 45 27 73 20 52 55 45 21 20 73 55 4D 73 44 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190b3: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 08 E2 40 00 68 94 95 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190b1: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 E0 C1 40 00 68 04 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule ASDPack_20_asd: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8D 49 00 1F 01 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 90 }
        $b = { 8B 44 24 04 56 57 53 E8 CD 01 00 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ActiveMARKTM_additional: PEiD
{
    strings:
        $a = { 79 11 7F AB 9A 4A 83 B5 C9 6B 1A 48 F9 27 B4 25 }
    condition:
        $a at pe.entry_point

}

rule AVI_movie_file: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 41 56 49 ?? 4C 49 53 54 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_VOB_ProtectCD_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 5F 81 EF 00 00 00 00 BE 00 00 40 00 8B 87 00 00 00 00 03 C6 57 56 8C A7 00 00 00 00 FF 10 89 87 00 00 00 00 5E 5F }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 5F 81 EF 00 00 00 00 BE 00 00 40 00 8B 87 00 00 00 00 03 C6 57 56 8C A7 00 00 00 00 FF 10 89 87 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Gleam_100: PEiD
{
    strings:
        $a = { 83 EC 0C 53 56 57 E8 24 02 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_Microsoft_Visual_Cpp_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v252_beta2: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? B0 ?? ?? ?? ?? 68 60 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF ?? ?? ?? 15 24 }
    condition:
        $a at pe.entry_point

}

rule Sc_Obfuscator_SuperCRacker_Sign_by_fly: PEiD
{
    strings:
        $a = { 60 33 C9 8B 1D ?? ?? ?? ?? 03 1D ?? ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D ?? ?? ?? ?? 75 E7 A1 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 61 FF 25 ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_SVKP_111_emadicius_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 64 A0 23 00 00 00 83 C5 06 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule MIDI_Music_file: PEiD
{
    strings:
        $a = { 4D 54 68 64 00 00 00 06 ?? ?? ?? ?? ?? ?? 4D 54 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v11_BRS_additional: PEiD
{
    strings:
        $a = { 60 E9 ?? 05 }
    condition:
        $a at pe.entry_point

}

rule CorelDraw_8_CDR_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 44 52 38 }
    condition:
        $a at pe.entry_point

}

rule Warning_may_be_SimbyOZ_polycryptor_by_3xpl01t_ver_2xx_25032007_2200: PEiD
{
    strings:
        $a = { 57 57 8D 7C 24 04 50 B8 00 D0 17 13 AB 58 5F C3 00 00 }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt_15_BitShape_Software: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 55 20 40 00 B9 7B 09 00 00 8D BD 9D 20 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        $a at pe.entry_point

}

rule MinGW_v32x_mainCRTStartup: PEiD
{
    strings:
        $a = { E8 FF FF E8 FF }
        $b = { 55 89 E5 83 EC 08 6A 00 6A 00 6A 00 6A 00 E8 0D 00 00 00 B8 00 00 00 00 C9 C3 90 90 90 90 90 90 FF 25 38 20 40 00 90 90 00 00 00 00 00 00 00 00 FF FF FF FF 00 00 00 00 FF FF FF FF 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Simple_UPX_Cryptor_V3042005_MANtiCORE_additional: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? ?? ?? ?? ?? E2 FA 61 68 ?? ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule PESpin_01_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1333_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Registration_file_v11_additional: PEiD
{
    strings:
        $a = { 24 46 41 52 45 47 24 45 4E 43 3D ?? 26 26 52 45 47 3D ?? 26 26 45 58 50 3D }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22006115_WFS: PEiD
{
    strings:
        $a = { 45 50 45 3A 20 45 6E 63 72 79 70 74 50 45 20 56 32 2E 32 30 30 36 2E 31 2E 31 35 }
        $b = { 60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_50p_MFC_Anorganix_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9 }
    condition:
        $a at pe.entry_point

}

rule Vx_Modification_of_Hi924: PEiD
{
    strings:
        $a = { 50 53 51 52 1E 06 9C B8 21 35 CD 21 53 BB ?? ?? 26 ?? ?? 49 48 5B }
    condition:
        $a at pe.entry_point

}

rule EmbedPE_V100_V124_cyclotron_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_Debug_: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_V13X_V14X_RiSco: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_151_GlOFF_additional: PEiD
{
    strings:
        $a = { 90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Upack_v032_Beta_Patch_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule Vx_MTE_non_encrypted: PEiD
{
    strings:
        $a = { F7 D9 80 E1 FE 75 02 49 49 97 A3 ?? ?? 03 C1 24 FE 75 02 48 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1987_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FB 8C CA 2E 89 16 ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA }
    condition:
        $a at pe.entry_point

}

rule CPAV_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 4D 5A B1 01 93 01 00 00 02 }
    condition:
        $a at pe.entry_point

}

rule MSCC_10: PEiD
{
    strings:
        $a = { 0E 07 BE 00 00 BF 00 01 B9 05 00 F3 A4 B9 64 02 BE 10 01 AC CC 98 03 D8 E2 F9 FA 53 50 58 4C 4C 5B 3B C3 5B FB 74 02 FA F4 1E 33 C0 8E D8 F7 16 05 00 EB 01 9A F7 16 05 00 1F 50 58 4C 4C 5B 3B C3 75 7A B9 00 00 BE 05 01 BF 05 01 B3 00 FE C3 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable: PEiD
{
    strings:
        $a = { 03 05 00 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule XcomOR_v099i_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 66 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? D3 ?? ?? C2 ?? ?? B9 ?? ?? EB ?? 0F 23 F8 0F 23 D8 0F 23 F8 0F 23 C8 E2 }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Dongle_V54200_Rainbow_Technologies_SignByfly: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 50 1E DF 80 E8 ?? ?? ?? ?? 68 B9 10 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 12 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 07 2A A3 00 E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 88 B5 5B FF E8 ?? ?? ?? ?? 68 B9 30 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 }
        $b = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_V036_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? C1 E5 08 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 18 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 1C 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 1C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 14 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 3C E2 E3 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v4x: PEiD
{
    strings:
        $a = { 64 A1 ?? ?? ?? ?? 55 8B EC 6A FF 68 68 50 64 83 53 56 57 89 }
        $b = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 89 25 00 00 00 00 83 EC ?? 53 56 57 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Themida_10xx_18xx_no_compression_Oreans_Technologies_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8D 45 80 8B 5D 08 C7 85 7C FF FF FF 00 00 00 00 8B 8D 7C FF FF FF D1 C3 88 18 41 89 8D 7C FF FF FF 81 BD 7C FF FF FF 80 00 00 00 75 E3 C7 85 7C FF FF FF 00 00 00 00 8D BA ?? ?? ?? ?? 8D 75 80 8A 0E BB F4 01 00 00 B8 AB 37 54 78 D3 D0 8A 0F D3 D0 4B 75 F7 0F AF C3 47 46 8B 8D 7C FF FF FF 41 89 8D 7C FF FF FF 81 F9 80 00 00 00 75 D1 61 C9 C2 04 00 55 8B EC 83 C4 F0 8B 75 08 C7 45 FC 00 00 00 00 EB 04 FF 45 FC 46 80 3E 00 75 F7 BA 00 00 00 00 8B 75 08 8B 7D 0C EB 7F C7 45 F8 00 00 00 00 EB }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1352_Obsidium_Software_SignByfly: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 03 ?? ?? ?? E8 }
        $b = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_LCC_Win32_DLL_Anorganix_additional: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_JDPack_1x_JDProtect_09_Anorganix_additional: PEiD
{
    strings:
        $a = { 60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_V131_Build_20070615_Dll_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 81 ED ?? ?? ?? ?? E9 49 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 8A 84 24 28 00 00 00 80 F8 01 0F 84 07 00 00 00 B8 ?? ?? ?? ?? FF E0 E9 04 00 00 00 ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 81 C0 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 30 10 40 49 0F 85 F6 FF FF FF E9 04 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule QuickLink_II_Fax_Graphics_format: PEiD
{
    strings:
        $a = { 51 4C 49 49 46 41 58 20 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_EXE32Pack_13x_emadicius_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V11A_V12_vcasm: PEiD
{
    strings:
        $a = { 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 76 63 61 73 6D 5F 70 72 6F 74 65 63 74 5F 32 30 30 35 5F 33 5F 31 38 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_v029_beta_Dwing_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 29 }
    condition:
        $a at pe.entry_point

}

rule Vx_Danish_tiny_additional: PEiD
{
    strings:
        $a = { 33 C9 B4 4E CD 21 73 02 FF ?? BA ?? 00 B8 ?? 3D CD 21 }
    condition:
        $a at pe.entry_point

}

rule PEQuake_006_forgat_additional: PEiD
{
    strings:
        $a = { E8 A5 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? ?? 00 5B ?? ?? 00 6E ?? ?? 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 }
    condition:
        $a at pe.entry_point

}

rule ShellModify_01_pll621_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 98 66 41 00 68 3C 3D 41 00 64 A1 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Basic_50_60_additional: PEiD
{
    strings:
        $a = { C1 CB 10 EB 01 0F B9 03 74 F6 EE 0F B6 D3 8D 05 83 ?? ?? EF 80 F3 F6 2B C1 EB 01 DE 68 77 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_420_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 F0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 84 A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 80 A5 4C 00 C1 E1 08 03 CA 89 0D 7C A5 4C 00 C1 E8 10 A3 78 A5 }
    condition:
        $a at pe.entry_point

}

rule MetaWare_High_C_p_Phar_Lap_DOS_Extender_1983_89_Hint_DOS_EP_additional: PEiD
{
    strings:
        $a = { EB ?? 33 ED 2E 8E 1E ?? ?? 26 A1 ?? ?? A3 ?? ?? 26 8B 1E ?? ?? B1 ?? 4B }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v114_v120: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 20 }
    condition:
        $a at pe.entry_point

}

rule Wicat_GED_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 0D 00 40 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Protect_09: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v42: PEiD
{
    strings:
        $a = { 64 A1 ?? ?? ?? ?? 55 8B EC 6A FF 68 68 50 64 83 53 56 57 89 }
        $b = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? C7 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ChSfx_small_v11_additional: PEiD
{
    strings:
        $a = { BA ?? ?? E8 ?? ?? 8B EC 83 EC ?? 8C C8 BB ?? ?? B1 ?? D3 EB 03 C3 8E D8 05 ?? ?? 89 }
    condition:
        $a at pe.entry_point

}

rule MASK_v23_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 55 57 CD 03 FC 4D 41 53 4B FA 8B EC 83 ?? ?? ?? FF ?? ?? 5D 49 E8 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_emadicius_additional: PEiD
{
    strings:
        $a = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        $a at pe.entry_point

}

rule Packanoid_v1_Arkanoid_additional: PEiD
{
    strings:
        $a = { BF ?? ?? ?? 00 81 FF ?? ?? ?? 00 74 10 81 2F ?? 00 00 00 83 C7 04 BB 05 ?? ?? 00 FF E3 BE ?? ?? ?? 00 FF E6 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Fish_PE_Shield_112116_HellFish: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC 83 7D DC 00 75 08 E8 BD FE FF FF 89 45 DC E8 E1 FD FF FF 8B 00 03 45 DC 89 45 E4 E8 DC FE FF FF 8B D8 BA 8E 4E 0E EC 8B C3 E8 2E FF FF FF 89 45 F4 BA 04 49 32 D3 8B C3 E8 1F FF FF FF 89 45 F8 BA 54 CA AF 91 8B C3 E8 10 FF FF FF 89 45 F0 BA AC 33 06 03 8B C3 E8 01 FF FF FF 89 45 EC BA 1B C6 46 79 8B C3 E8 F2 FE FF FF 89 45 E8 BA AA FC 0D 7C 8B C3 E8 E3 FE FF FF 89 45 FC 8B 45 E4 8B 58 04 03 5D E4 8B FB 8B 45 E4 8B 30 4E 85 F6 72 2B }
        $b = { 60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 ?? ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 ?? ?? 00 ?? ?? 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 00 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 40 }
        $c = { 55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CodeSafe_20: PEiD
{
    strings:
        $a = { 83 3D 14 00 00 01 00 0F 84 08 00 00 00 A1 14 00 00 01 FF E0 C3 55 8B EC 83 EC 10 53 56 57 E8 C4 01 00 00 A1 98 00 00 01 2B 05 94 00 00 01 89 45 F4 A1 D4 00 00 01 03 05 C8 00 00 01 89 45 F8 A1 98 00 00 01 39 45 F8 0F 85 22 00 00 00 A1 A4 00 }
    condition:
        $a at pe.entry_point

}

rule TINYPROG_v36_v39_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? EB ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Sc_Obfuscator_SuperCRacker_additional: PEiD
{
    strings:
        $a = { 60 33 C9 8B 1D ?? ?? ?? ?? 03 1D ?? ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D ?? ?? ?? ?? 75 E7 A1 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 61 FF 25 ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v200_alpha_38_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F 00 50 57 56 FF D1 58 03 43 08 8B F8 8B 53 14 8B F0 8B 46 FC 83 C0 04 2B F0 89 56 08 8B 4B 10 89 4E 18 FF D7 89 85 BB 10 00 10 5E 5A 5F 59 5B 5D 9D FF E0 8B 80 BB 10 00 10 FF E0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule yzpack_V11_UsAr: PEiD
{
    strings:
        $a = { 60 33 C0 8D 48 07 50 E2 FD 8B EC 64 8B 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 8B 40 34 8D 40 7C 8B 40 3C 89 45 04 E8 F3 07 00 00 60 8B 5D 04 8B 73 3C 8B 74 33 78 03 F3 56 8B 76 20 03 F3 33 C9 49 92 41 AD 03 C3 52 33 FF 0F B6 10 38 F2 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_V20_Private_Vaskanbsp_nbsp_SignByfly_additional: PEiD
{
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? ?? ?? ?? F7 D1 83 F1 FF 59 BA ?? ?? ?? ?? F7 D1 83 F1 FF F7 D1 83 F1 FF 80 02 ?? F7 D1 83 F1 FF C0 0A ?? F7 D1 83 F1 FF 80 02 ?? F7 D1 83 F1 FF 80 32 ?? F7 D1 83 F1 FF 80 02 ?? F7 D1 83 F1 FF 42 49 85 C9 75 CD 1C 4F 8D 5B FD 62 1E 1C 4F 8D 5B FD 4D 9D B9 ?? ?? ?? ?? 1C 4F 8D 5B FD 22 1C 4F 8D 5B FD 8E A2 B9 B9 E2 83 DB E2 E5 4D CD 1E BF 60 AB 1F 4D DB 1E 1E 3D 1E 92 1B 8E DC 7D EC A4 E2 4D E5 20 C6 CC }
    condition:
        $a at pe.entry_point

}

rule Hyings_PE_Armor_075exe_Hying_CCG_h_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 42 6F 47 5F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C9 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_13_Extranger_additional: PEiD
{
    strings:
        $a = { 57 57 8D 7C 24 04 50 B8 00 ?? ?? ?? AB 58 5F C3 }
    condition:
        $a at pe.entry_point

}

rule PE_Crypter_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D B9 ?? ?? ?? ?? 80 31 15 41 81 F9 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1355_Obsidium_Software_20080411: PEiD
{
    strings:
        $a = { EB 01 ?? E8 2B 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 23 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 02 ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 ?? ?? ?? ?? EB 01 ?? E8 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 01 ?? E8 }
    condition:
        $a at pe.entry_point

}

rule NSIS_Installer_NullSoft: PEiD
{
    strings:
        $a = { 83 EC 20 53 55 56 33 DB 57 89 5C 24 18 C7 44 24 10 ?? ?? ?? ?? C6 44 24 14 20 FF 15 30 70 40 00 53 FF 15 80 72 40 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_NorthStar_PE_Shrinker_13_Anorganix: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Stony_Brook_Pascal_v614_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 31 ED 9A ?? ?? ?? ?? 55 89 E5 ?? EC ?? ?? 9A }
    condition:
        $a at pe.entry_point

}


rule SPEC_b2_additional: PEiD
{
    strings:
        $a = { 55 57 51 53 E8 ?? ?? ?? ?? 5D 8B C5 81 ED ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 83 E8 09 89 85 ?? ?? ?? ?? 0F B6 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_Dll_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule NoobyProtect_SE_Public_V1210_Nooby_20090201: PEiD
{
    strings:
        $a = { E9 ?? 00 00 00 4E 6F 6F 62 79 50 72 6F 74 65 63 74 20 53 45 20 31 2E 32 2E 31 2E 30 }
    condition:
        $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_multi_layer_encryption_additional: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule NeoLite_10_101: PEiD
{
    strings:
        $a = { 8B 44 24 04 8D 54 24 FC 23 05 11 10 00 00 E8 C3 04 00 00 FF 35 CC 13 00 00 50 FF 25 D4 13 00 00 94 9A 8D 91 9A 93 CC CD 00 B8 93 90 9D 9E 93 BE 93 93 90 9C 00 B8 93 90 9D 9E 93 B9 8D 9A 9A 00 B8 9A 8B B2 90 9B 8A 93 9A B7 9E 91 9B 93 }
    condition:
        $a at pe.entry_point

}

rule Upx_Lock_v10_CyberDoom_Team_X: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 48 12 40 00 60 E8 2B 03 00 00 61 }
    condition:
        $a at pe.entry_point

}

rule LY_WGKX_wwwszleyucom: PEiD
{
    strings:
        $a = { 4D 79 46 75 6E 00 62 73 }
        $b = { 4D 5A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 53 46 58 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_PESHiELD_025_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_V21X_SoftCompletecom_: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? ?? ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 }
    condition:
        $a at pe.entry_point

}

rule Anti007_V27_V35_NsPacK_Private_additional: PEiD
{
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 54 }
    condition:
        $a at pe.entry_point

}

rule Mess_107_COM: PEiD
{
    strings:
        $a = { 46 55 43 4B 59 4F 55 1A FF 5F B9 FF FF F3 26 AC E3 02 EB 0C B8 00 70 50 9D 9C 58 25 00 70 75 18 BA 29 01 B4 09 CD 21 CD 20 33 38 36 2B 20 72 65 71 75 69 72 65 64 21 24 B4 30 CD 21 3C 02 77 02 CD 20 BD 47 01 FF E5 FA 66 33 C0 0F 23 F8 0F 23 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_PECompact_14p: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 EB 06 68 90 90 90 90 C3 9C 60 E8 02 90 90 90 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
    condition:
        $a at pe.entry_point

}

rule Symantec_C_v400_p_Libraries_additional: PEiD
{
    strings:
        $a = { FA B8 ?? ?? DB E3 8E D8 8C 06 ?? ?? 8B D8 2B 1E ?? ?? 89 1E ?? ?? 26 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1352_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 }
    condition:
        $a at pe.entry_point

}

rule Vx_CIH_Version_12_TTIT_WIN95CIH_: PEiD
{
    strings:
        $a = { 55 8D ?? ?? ?? 33 DB 64 87 03 E8 ?? ?? ?? ?? 5B 8D }
    condition:
        $a at pe.entry_point

}

rule North_Star_PE_Shrinker_13_Liuxingping_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 }
    condition:
        $a at pe.entry_point

}

rule Vx_Noon1163_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5B 50 56 B4 CB CD 21 3C 07 ?? ?? 81 ?? ?? ?? 2E ?? ?? 4D 5A ?? ?? BF 00 01 89 DE FC }
    condition:
        $a at pe.entry_point

}

rule Protect_31_EXE: PEiD
{
    strings:
        $a = { 2E A3 00 00 8C D8 2E A3 02 00 8C C8 2E A3 06 00 2E 89 2E 04 00 33 C0 8E D8 FA FC BE 04 00 0E 07 BF 08 00 A5 A5 BE 0C 00 A5 A5 1E 07 BE 04 00 BF 0C 00 B8 D4 01 AB 87 FE AB 2E A1 06 00 87 FE AB 87 F7 AB 89 E0 8C D3 0E 17 BC 85 00 B9 CD 01 4C }
    condition:
        $a at pe.entry_point

}

rule MEW_11_SE_12: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { E9 ?? ?? ?? ?? 0C ?? ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Thinstall_24x_25x_Jitit_Software_additional: PEiD
{
    strings:
        $a = { 6A 00 FF 15 20 50 40 00 E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        $a at pe.entry_point

}

rule NsPack_v23_North_Star_h: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8B 06 83 F8 00 74 11 8D B5 ?? ?? FF FF 8B 06 83 F8 01 0F 84 4B 02 00 00 C7 06 01 00 00 00 8B D5 8B 85 ?? ?? FF FF 2B D0 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 8B 36 8B FD }
    condition:
        $a at pe.entry_point

}

rule Crypto_Lock_202_Eng_Ryan_Thian_additional: PEiD
{
    strings:
        $a = { 60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_10069_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 A3 1C 00 00 }
    condition:
        $a at pe.entry_point

}

rule SDProtector_11x_Randy_Li: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 }
        $b = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PC_Guard_v500d_additional: PEiD
{
    strings:
        $a = { FC 2E 8C 0E ?? ?? A1 ?? ?? 8C CB 81 C3 ?? ?? 3B C3 72 ?? 2D ?? ?? 2D ?? ?? FA BC ?? ?? 8E D0 FB }
    condition:
        $a at pe.entry_point

}

rule PAK_SFX_Archive_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 ?? ?? A1 ?? ?? 2E ?? ?? ?? 2E ?? ?? ?? ?? ?? 8C D7 8E C7 8D ?? ?? BE ?? ?? FC AC 3C 0D }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Xtreme_Protector_105_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 E8 00 00 00 00 5D 81 00 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule GEM_Image_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 01 00 08 00 04 00 02 }
    condition:
        $a at pe.entry_point

}

rule CRC2COM_v124_packed_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 8B FC 83 EF ?? 83 EC ?? BE ?? ?? B9 ?? ?? 57 F3 A4 5F FF E7 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v14xp_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Basic_50_60: PEiD
{
    strings:
        $a = { C1 CB 10 EB 01 0F B9 03 74 F6 EE 0F B6 D3 8D 05 83 ?? ?? EF 80 F3 F6 2B C1 EB 01 DE 68 77 }
    condition:
        $a at pe.entry_point

}

rule Vx_Igor_additional: PEiD
{
    strings:
        $a = { 1E B8 CD 7B CD 21 81 FB CD 7B 75 03 E9 87 00 33 DB 0E 1F 8C }
    condition:
        $a at pe.entry_point

}

rule NsPack_14_Liuxingping_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 ?? ?? 40 00 2D ?? ?? 40 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_V028_V0399_Dwing_20080321: PEiD
{
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? ?? E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD 03 C3 50 97 AD 91 F3 A5 5E AD 56 91 01 1E AD E2 FB AD 8D 6E 10 01 5D 00 8D 7D 1C B5 1C F3 AB 5E AD 53 50 51 97 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 FF 66 1C B1 30 8B 5D 0C 03 D1 FF 16 73 4C 03 D1 FF 16 72 19 03 D1 FF 16 72 29 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C 8A 00 FF 66 18 83 C2 60 FF 16 87 5D 10 73 0C 03 D1 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8B D5 03 56 38 FF 56 0C 5B 91 FF 66 30 3C 07 B0 07 72 02 B0 0A 50 87 5D 10 87 5D 14 89 5D 18 8B D5 03 56 3C FF 56 0C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D 9C 85 7C 03 00 00 FF 56 04 3C 04 8B D8 72 5F 33 DB D1 E8 13 DB 48 43 91 43 D3 E3 80 F9 05 8D 94 9D 7C 01 00 00 76 2E 80 E9 04 33 C0 8B 55 00 D1 6D 08 8B 12 0F CA 2B 55 04 03 C0 3B 55 08 72 07 8B 55 08 40 01 55 04 FF 56 10 E2 E0 }
    condition:
        $a at pe.entry_point

}

rule HACKSTOP_v111c_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 CD 21 86 E0 3D ?? ?? 73 ?? B4 ?? CD 21 B0 ?? B4 4C CD 21 53 BB ?? ?? 5B EB }
    condition:
        $a at pe.entry_point

}

rule Microsoft_QBasic: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 02 CD 20 BF 00 00 8B 36 02 00 2B F7 81 FE 00 10 72 03 BE 00 10 FA 8E D7 81 C4 00 00 FB 73 0B 33 C0 36 C7 06 00 00 00 00 EB 7D 83 E4 FE 36 89 26 00 00 8B C6 B1 04 D3 E0 48 36 A3 00 00 03 F7 89 36 02 00 8C C3 2B DE F7 DB }
    condition:
        $a at pe.entry_point

}

rule ActiveMark_Trymedia_Systems_Inc: PEiD
{
    strings:
        $a = { 89 25 ?? ?? ?? ?? 33 ED 55 8B EC E8 ?? ?? ?? ?? 8B D0 81 E2 FF 00 00 00 89 15 ?? ?? ?? ?? 8B D0 C1 EA 08 81 E2 FF 00 00 00 A3 ?? ?? ?? ?? D1 E0 0F 93 C3 33 C0 8A C3 A3 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? BB ?? ?? ?? ?? C7 03 44 00 00 00 }
        $b = { 89 25 ?? ?? ?? ?? EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FreeJoiner_Small_build_033_GlOFF: PEiD
{
    strings:
        $a = { 50 66 33 C3 66 8B C1 58 E8 AC FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 50 66 33 C3 66 8B C1 58 E8 AC FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PESpin_1304_Cyberbob_h_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 AC DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Armadillo_301_305: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F }
    condition:
        $a at pe.entry_point

}

rule TAV_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 4D 5A CB }
    condition:
        $a at pe.entry_point

}

rule Safeguard_103_Simonzh: PEiD
{
    strings:
        $a = { E8 ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v260b2_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 90 ?? ?? ?? 68 24 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 60 ?? ?? ?? 33 D2 8A D4 89 15 3C }
    condition:
        $a at pe.entry_point

}

rule BJFnt_v12_RC_additional: PEiD
{
    strings:
        $a = { EB 02 09 94 0F B7 FF 68 80 ?? ?? 00 81 F6 8E 00 00 00 5B EB 02 11 C2 8D 05 F4 00 00 00 47 }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Compiled_Datafile_Version_additional: PEiD
{
    strings:
        $a = { 46 69 6C 65 20 41 6E 61 6C 79 7A 65 72 20 43 6F 6D 70 69 6C 65 64 20 44 61 74 61 66 69 6C 65 20 56 65 72 73 69 6F 6E }
    condition:
        $a at pe.entry_point

}

rule Comprot_v10b_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5E 8B EE 81 ?? ?? ?? 8D ?? ?? ?? B9 ?? ?? F6 14 46 E2 ?? 4B }
    condition:
        $a at pe.entry_point

}

rule Pohernah_Crypter_V103_Kas: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED }
    condition:
        $a at pe.entry_point

}

rule XMI_music_file_additional: PEiD
{
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 58 4D 49 44 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_FSG_10_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_VOB_ProtectCD_5: PEiD
{
    strings:
        $a = { 36 3E 26 8A C0 60 E8 00 00 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule SLVc0deProtector_06_SLV: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_LCC_Win32_DLL: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule Upack_021_beta_Dwing_: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 6A 04 95 A5 33 C0 AB 48 AB F7 D8 59 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 }
    condition:
        $a at pe.entry_point

}

rule AntiKill_PAGELK_Trojan_20090624: PEiD
{
    strings:
        $a = { 50 45 00 00 4C 01 05 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 E0 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 02 00 00 04 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 00 60 02 00 00 10 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 10 00 00 10 00 00 00 00 10 00 00 10 00 00 00 00 00 00 10 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 2E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 60 5F 50 41 47 45 4C 4B 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 40 2E 69 64 61 74 61 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 2E 72 73 72 63 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 40 2E 72 65 6C 6F 63 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_MEW_11_SE_10_Anorganix: PEiD
{
    strings:
        $a = { E9 09 00 00 00 00 00 00 02 00 00 00 0C 90 }
    condition:
        $a at pe.entry_point

}

rule VOB_ProtectCD_5_additional: PEiD
{
    strings:
        $a = { 36 3E 26 8A C0 60 E8 }
    condition:
        $a at pe.entry_point

}

rule Pelles_C_300_400_450_EXE_X86_CRT_LIB_additional: PEiD
{
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 02 E8 ?? ?? ?? ?? 59 A3 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_PESHiELD_025_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC E9 }
    condition:
        $a at pe.entry_point

}

rule Petite_12_c1998_Ian_Luck_h: PEiD
{
    strings:
        $a = { 66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 09 00 0A 00 0B 00 0D 00 0F 00 11 00 13 00 17 00 1B 00 1F 00 23 00 2B 00 33 00 3B 00 43 00 53 00 63 00 73 00 83 00 A3 00 C3 00 E3 00 02 01 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01 01 02 02 02 }
        $b = { 66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 09 00 0A 00 0B 00 0D 00 0F 00 11 00 13 00 17 00 1B 00 1F 00 23 00 2B 00 33 00 3B 00 43 00 53 00 63 00 73 00 83 00 A3 00 C3 00 E3 00 02 01 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01 01 02 02 02 02 03 03 03 03 04 04 04 04 05 05 05 05 00 70 70 01 00 02 00 03 00 04 00 05 00 07 00 09 00 0D 00 11 00 19 00 21 00 31 00 41 00 61 00 81 00 C1 00 01 01 81 01 01 02 01 03 01 04 01 06 01 08 01 0C 01 10 01 18 01 20 01 30 01 40 01 60 00 00 00 00 01 01 02 02 03 03 04 04 05 05 06 06 07 07 08 08 09 09 0A 0A 0B 0B 0C 0C 0D 0D 10 11 12 00 08 07 09 06 0A 05 0B 04 0C 03 0D 02 0E 01 0F 58 2C 08 50 8B C8 8B D0 81 C1 ?? D2 00 00 81 C2 ?? ?? 00 00 89 20 8B E1 50 81 2C 24 00 ?? ?? ?? FF 30 50 80 04 24 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PEBundle_005_Jeremy_Collake: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 00 87 DD 8D 85 A8 22 40 00 50 FF 95 42 23 40 00 0B C0 0F 85 B5 01 00 00 6A 04 68 00 10 00 00 68 00 02 00 00 6A 00 FF 95 4A 23 40 00 0B C0 0F 84 99 01 00 00 89 85 D0 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_WAV_Audio_file_additional: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 57 41 56 45 66 6D 74 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_BJFNT_12: PEiD
{
    strings:
        $a = { EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 00 }
    condition:
        $a at pe.entry_point

}

rule SHOWV20_Show_Text_Utility_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? B8 ?? ?? 2B ?? ?? ?? A3 ?? ?? E8 ?? ?? E8 ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule SoftComp_1x_BG_Soft_PT: PEiD
{
    strings:
        $a = { E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24 8B 04 24 89 85 2A 0F 41 00 58 8B 85 2A 0F 41 00 }
    condition:
        $a at pe.entry_point

}

rule NsPack_v37_North_Star_h: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 8D ?? ?? ?? FF 80 39 01 0F 84 42 02 00 00 C6 01 01 8B C5 2B 85 ?? ?? ?? FF 89 85 ?? ?? ?? FF 01 85 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 01 06 55 56 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? ?? FF 85 C0 0F 84 69 03 00 00 89 85 ?? ?? ?? FF E8 00 00 00 00 5B B9 67 03 00 00 03 D9 50 53 E8 B0 02 00 00 5E 5D 8B 36 8B FD 03 BD ?? ?? ?? FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 34 01 13 8B 33 03 7B 04 57 51 53 FF B5 ?? ?? ?? FF FF B5 ?? ?? ?? FF 8B D6 8B CF 8B 85 ?? ?? ?? FF 05 AA 05 00 00 FF D0 5B 59 5F 83 F9 00 74 05 83 C3 08 EB C7 68 00 80 00 00 6A 00 FF B5 ?? ?? ?? FF FF 95 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 00 74 14 8A 1A 38 1F 75 E9 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 EB 0A 8A 5F 04 86 C4 C1 C0 10 86 C4 2B C7 03 C6 89 07 83 C7 05 80 EB E8 8B C3 E2 C6 E8 3A 01 00 00 8D 8D }
    condition:
        $a at pe.entry_point

}

rule REC_v032_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 1E 52 B8 ?? ?? 1E CD 21 86 E0 3D }
    condition:
        $a at pe.entry_point

}

rule HideProtect_V1016C_SoftWar_Company: PEiD
{
    strings:
        $a = { 90 90 90 E9 D8 }
    condition:
        $a at pe.entry_point

}

rule _MSLRH_v032a_emadicius_additional: PEiD
{
    strings:
        $a = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        $a at pe.entry_point

}

rule Dev_Cpp_v5_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 14 6A ?? FF 15 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Borland_Cpp_DLL_Method_2: PEiD
{
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule MPEG_movie_file: PEiD
{
    strings:
        $a = { 00 00 01 BA 2F FF FD E6 C1 80 18 61 00 00 01 BB }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V230_V23X_SetiSoft_Team_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Explosion1000_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 1E 06 50 81 ?? ?? ?? 56 FC B8 21 35 CD 21 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 26 ?? ?? ?? ?? ?? ?? 74 ?? 8C D8 48 8E D8 }
    condition:
        $a at pe.entry_point

}

rule Image_Systems_Technology_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 03 3A ?? ?? 00 ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_v081_v084_Modified: PEiD
{
    strings:
        $a = { 01 DB 07 8B 1E 83 EE FC 11 DB ED B8 01 ?? ?? ?? 01 DB 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 }
        $b = { 01 DB ?? 07 8B 1E 83 EE FC 11 DB ?? ED B8 01 00 00 00 01 DB ?? 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 EF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Sierras_audio_file: PEiD
{
    strings:
        $a = { 8D 0C 53 4F 4C 00 22 56 0D }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v_If_you_know_this_version_post_on_PEiD_board: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? 00 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 DD 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Basic_40: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 E8 ?? FF FF FF 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule SLVc0deProtector_v061_SLV_additional: PEiD
{
    strings:
        $a = { EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 }
    condition:
        $a at pe.entry_point

}

rule FreeCryptor_01_build_002_GlOFF_additional: PEiD
{
    strings:
        $a = { 8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 90 68 27 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08 }
    condition:
        $a at pe.entry_point

}

rule CrypKey_V61X_DLL_CrypKey_Canada_Inc_additional: PEiD
{
    strings:
        $a = { 83 3D ?? ?? ?? 00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Encapsulated_Postscript_graphics_file_v30_EPSF_30_Hint_FILE_START: PEiD
{
    strings:
        $a = { 25 21 50 53 2D 41 64 6F 62 65 2D 33 2E 30 20 45 50 53 46 2D 33 2E 30 }
    condition:
        $a at pe.entry_point

}

rule Duals_eXe_10_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 08 03 00 00 89 28 33 FF 8D 85 7D 02 00 00 8D 8D 08 03 00 00 2B C8 8B 9D 58 03 00 00 E8 1C 02 00 00 8D 9D 61 02 00 00 8D B5 7C 02 00 00 46 80 3E 00 74 24 56 FF 95 0A 04 00 00 46 80 3E 00 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v1300_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 04 25 80 34 CA E8 29 00 00 00 EB 02 C1 81 EB 01 3A 8B 54 24 0C EB 02 32 92 83 82 B8 00 00 00 22 EB 02 F2 7F 33 C0 EB 04 65 7E 14 79 C3 EB 04 05 AD 7F 45 EB 04 05 65 0B E8 64 67 FF 36 00 00 EB 04 0D F6 A8 7F 64 67 89 26 00 00 EB 04 8D 68 C7 FB EB 01 6B }
    condition:
        $a at pe.entry_point

}

rule PolyCrypt_PE_214b215_JLab_Software_Creations: PEiD
{
    strings:
        $a = { 91 8B F4 AD FE C9 80 34 08 ?? E2 FA C3 60 E8 ED FF FF FF EB }
    condition:
        $a at pe.entry_point

}

rule DOS16M_DOS_Extender_c_Tenberry_Software_Inc_1987_1995: PEiD
{
    strings:
        $a = { BF ?? ?? 8E C7 8E D7 BC ?? ?? 36 ?? ?? ?? ?? FF ?? ?? ?? 36 ?? ?? ?? ?? BE ?? ?? AC 8A D8 B7 00 ?? ?? 8B ?? ?? ?? 4F 8E C7 }
    condition:
        $a at pe.entry_point

}

rule NoClip_41: PEiD
{
    strings:
        $a = { FF 26 00 02 9C 50 53 51 8C D8 A3 0C 01 FA 8E D0 FB 81 C4 00 01 FF 16 00 00 EB 01 A1 FF 16 00 00 74 03 E9 86 00 A1 0C 01 03 06 16 01 73 02 83 BF 03 C1 50 B8 4E 03 75 02 FF 1E 50 8B EC BF 70 01 E8 15 10 4F E8 38 10 56 EB 01 A1 B8 00 29 CD 21 }
    condition:
        $a at pe.entry_point

}

rule Jovian_VI_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 56 49 ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_ASPack_211d_emadicius: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule TheHypers_protector_TheHyper_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? ?? 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 0C 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 53 8B 06 FF 10 89 47 04 E8 0F 00 00 00 47 65 74 50 72 6F 63 65 73 73 48 65 61 70 00 53 8B 06 FF 10 89 47 08 E8 0A 00 00 00 48 65 61 70 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 47 0C E8 09 00 00 00 48 65 61 70 46 72 65 65 00 53 8B 06 FF 10 89 47 10 57 FF 76 08 FF 76 0C FF 56 10 8B E5 5D }
    condition:
        $a at pe.entry_point

}

rule PEncrypt_v31: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? 00 F0 0F C6 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V520_Silicon_Realms_Toolworks_20080214: PEiD
{
    strings:
        $a = { E8 38 3D 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 98 1E 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 EC 1C 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 7D 1C 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? ?? 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 FE 1A 00 00 59 89 7D FC FF 75 08 E8 56 45 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 96 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 C0 FA FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 A4 19 00 00 59 C3 3B DF 75 0D 8B 45 10 3B C7 74 06 C7 00 0C 00 00 00 8B C3 E8 CC 1D 00 00 C3 55 8B EC 51 83 65 FC 00 57 8D 45 FC 50 FF 75 0C FF 75 08 E8 CA FE FF FF 8B F8 83 C4 0C 85 FF 75 19 56 8B 75 FC 85 F6 74 10 E8 C9 1B 00 00 85 C0 74 07 E8 C0 1B 00 00 89 30 5E 8B C7 5F C9 C3 6A 0C 68 ?? ?? ?? ?? E8 3B 1D 00 00 8B 75 08 85 F6 74 75 83 3D ?? ?? ?? ?? ?? 75 43 6A 04 E8 FF 19 00 00 59 83 65 FC 00 56 E8 84 3C 00 00 59 89 45 E4 85 C0 74 09 56 50 E8 A0 3C 00 00 59 59 C7 45 FC FE FF FF FF E8 0B 00 00 00 83 7D E4 00 75 37 FF 75 08 EB 0A 6A 04 E8 ED 18 00 00 59 C3 }
    condition:
        $a at pe.entry_point

}

rule Symantec_Visual_Cafe_30: PEiD
{
    strings:
        $a = { 64 8B 05 00 00 00 00 55 8B EC 6A FF 68 00 00 40 00 68 00 00 40 00 50 64 89 25 00 00 00 00 83 EC 08 50 53 56 57 89 65 E8 C7 45 FC 00 00 00 00 E8 00 0D 00 00 E8 00 0C 00 00 6A 00 FF 15 00 00 40 00 A3 00 00 40 00 E8 00 0C 00 00 FF 15 00 00 40 }
    condition:
        $a at pe.entry_point

}

rule PrincessSandy_v10_eMiNENCE_Process_Patcher_Patch_additional: PEiD
{
    strings:
        $a = { 68 27 11 40 00 E8 3C 01 00 00 6A 00 E8 41 01 00 00 A3 00 20 40 00 8B 58 3C 03 D8 0F B7 43 14 0F B7 4B 06 8D 7C 18 18 81 3F 2E 4C 4F 41 74 0B 83 C7 28 49 75 F2 E9 A7 00 00 00 8B 5F 0C 03 1D 00 20 40 00 89 1D 04 20 40 00 8B FB 83 C7 04 68 4C 20 40 00 68 08 }
    condition:
        $a at pe.entry_point

}

rule PEX_v099_additional: PEiD
{
    strings:
        $a = { E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 50 65 58 20 28 63 29 20 62 79 20 62 61 72 74 5E 43 72 61 63 6B 50 6C 20 62 65 74 61 20 72 65 6C 65 61 73 65 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 60 E8 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development: PEiD
{
    strings:
        $a = { 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule RLP_v073beta_ap0x_h_additional: PEiD
{
    strings:
        $a = { 60 8B DD E8 00 00 00 00 5D 95 32 C0 95 89 9D 80 00 00 00 B8 42 31 40 00 BB 41 30 40 00 2B C3 03 C5 33 D2 8A 10 40 B9 ?? ?? 00 00 8B F9 30 10 8A 10 40 49 75 F8 64 EF 86 3D 30 00 00 0F B9 FF 4B 89 52 5C 4C BD 77 C2 0C CE 88 4E 2D E8 00 00 00 5D 0D DB 5E 56 41 87 FC 0F F3 05 40 81 68 4B 93 71 40 BB 87 3C 40 40 8B 88 06 75 70 40 40 8B BB B3 43 C4 8F 93 2B F3 4A 88 06 07 30 F5 EA 2A 35 F0 4B 8A C3 07 C1 C6 02 C4 34 C0 74 74 32 02 C4 45 0B 3C 96 BE 0A 82 C3 DE 36 A9 7E 5A 51 A6 BC 63 A8 66 CB 30 58 20 8C CC 85 53 9F C1 E4 10 80 11 20 1E 48 D2 E8 F7 28 5C 26 89 5C 94 89 5A F8 1C 0B 74 7E 33 4E 9B 29 56 F2 2B 84 42 8A 95 16 76 64 08 7B 70 8F A0 0B A8 3A C1 C7 B5 3E D9 70 }
    condition:
        $a at pe.entry_point

}

rule VIRUS_I_WormKLEZ: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 40 D2 40 ?? 68 04 AC 40 ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 BC D0 }
    condition:
        $a at pe.entry_point

}

rule V_Load_09: PEiD
{
    strings:
        $a = { 33 F6 2E F6 06 B0 06 FF 74 12 0E 58 8B D8 81 E3 00 F0 75 08 B1 04 D3 E0 2B F0 D3 EE 06 5B 0E 58 2B C3 B1 04 BB 3A 07 8B D3 D3 EB 81 E2 0F 00 74 01 43 2B F3 7D 02 03 F3 03 D8 03 DE B8 00 4A CD 21 73 04 B4 4C CD 21 A1 2C 00 2E A3 0A 07 2E 8C }
    condition:
        $a at pe.entry_point

}

rule RLPack_118_Dll_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 5C 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 A7 03 00 00 89 85 16 04 00 00 5B FF B5 16 04 00 00 56 FF D3 83 C4 ?? 8B B5 16 04 00 00 8B C6 EB 01 }
    condition:
        $a at pe.entry_point

}

rule FACRYPT_v10_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B9 ?? ?? B3 ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 49 43 32 E4 03 D0 E3 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_Borland_Delphi_DLL_Anorganix: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 B4 B8 90 90 90 90 E8 00 00 00 00 E8 00 00 00 00 8D 40 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_LCC_Win32_1x_Anorganix_additional: PEiD
{
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 E9 }
    condition:
        $a at pe.entry_point

}

rule BopCrypt_v10_additional: PEiD
{
    strings:
        $a = { 60 BD ?? ?? ?? ?? E8 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_vxx: PEiD
{
    strings:
        $a = { B8 EF BE AD DE 50 6A ?? FF 15 10 19 40 ?? E9 AD FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Code_Lock_vxx_additional: PEiD
{
    strings:
        $a = { 47 8B C2 05 1E 00 52 8B D0 B8 02 3D CD 21 8B D8 5A }
    condition:
        $a at pe.entry_point

}

rule EmbedPE_v124_cyclotron: PEiD
{
    strings:
        $a = { 83 EC 50 60 68 ?? ?? ?? ?? E8 CB FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule MacPaint_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 00 00 02 FF FF FF FF }
    condition:
        $a at pe.entry_point

}

rule UPX_V194_Markus_Oberhumer_Laszlo_Molnar_John_Reiser_additional: PEiD
{
    strings:
        $a = { FF D5 80 A7 ?? ?? ?? ?? ?? 58 50 54 50 53 57 FF D5 58 61 8D 44 24 ?? 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_V11X_V15X_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 00 10 40 00 E8 01 00 00 00 9A 83 C4 10 8B E5 5D E9 }
    condition:
        $a at pe.entry_point

}

rule TXT2COM_Read_A_Matic_v10_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E D8 8C 06 ?? ?? FA 8E D0 BC ?? ?? FB B4 ?? CD 21 A3 ?? ?? 06 50 B4 34 CD 21 }
    condition:
        $a at pe.entry_point

}

rule tElock_099_10_private_tE_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5D ?? ?? ?? ?? ?? 81 ED ?? ?? ?? ?? ?? ?? E8 ?? ?? 81 FC ?? ?? ?? ?? 8D ?? ?? ?? BF ?? ?? 57 A4 A5 }
    condition:
        $a at pe.entry_point

}

rule ASPR_Stripper_v2x_unpacked_additional: PEiD
{
    strings:
        $a = { BB ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 29 ?? ?? 4E E8 }
    condition:
        $a at pe.entry_point

}

rule Petite_v22_Compresor_wwwun4seencompetite: PEiD
{
    strings:
        $a = { B8 00 ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule eXPressorProtection_V1601_CGSoftLabsnbsp_nbsp_SignByfly_20080308: PEiD
{
    strings:
        $a = { EB 01 ?? EB 01 ?? 55 8B EC 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? ?? 74 08 EB 01 ?? E9 56 01 00 00 EB 02 ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB 01 ?? E8 E2 05 00 00 EB 02 ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 ?? EB 02 ?? ?? 68 ?? ?? ?? ?? E8 0E 05 00 00 59 EB 01 ?? 83 65 F4 00 EB 07 8B 45 F4 40 89 45 F4 83 7D F4 61 73 1F EB 02 ?? ?? 8B 45 F4 0F B6 ?? ?? ?? ?? ?? 33 45 F4 8B 4D F4 88 81 ?? ?? ?? ?? EB 01 ?? EB D4 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 83 C4 10 89 45 FC EB 02 ?? ?? 83 7D FC 00 75 0A 6A 00 A1 ?? ?? ?? ?? FF 50 14 EB 01 ?? F3 E8 A0 05 00 00 A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC E8 01 00 00 00 ?? 83 04 24 06 C3 }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt_101: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 EB 02 CD 20 EB 03 FF CD 20 56 57 55 89 A3 4B 20 00 00 8B EB 80 BB FA 1F 00 00 01 0F 84 D3 17 00 00 C6 83 FA 1F 00 00 01 80 BB 21 20 00 00 00 75 26 8B 83 07 20 00 00 53 2B D8 EB 02 CD 20 EB 03 FF }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt_102: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 85 C0 73 02 F7 }
    condition:
        $a at pe.entry_point

}

rule Apex_c_beta_500mhz: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Protection_Plus_vxx_additional: PEiD
{
    strings:
        $a = { 50 60 29 C0 64 FF 30 E8 ?? ?? ?? ?? 5D 83 ED 3C 89 E8 89 A5 14 ?? ?? ?? 2B 85 1C ?? ?? ?? 89 85 1C ?? ?? ?? 8D 85 27 03 ?? ?? 50 8B ?? 85 C0 0F 85 C0 ?? ?? ?? 8D BD 5B 03 ?? ?? 8D B5 43 03 ?? ?? E8 DD ?? ?? ?? 89 85 1F 03 ?? ?? 6A 40 68 ?? 10 ?? ?? 8B 85 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_v60_v70_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule UPX_p_ECLiPSE_layer_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 33 D2 EB 01 0F 56 EB 01 0F E8 03 00 00 00 EB 01 0F EB 01 0F 5E EB 01 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_XCR_011_Anorganix: PEiD
{
    strings:
        $a = { 60 8B F0 33 DB 83 C3 01 83 C0 01 }
    condition:
        $a at pe.entry_point

}

rule tElock_v042_additional: PEiD
{
    strings:
        $a = { C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 52 8B FE 68 79 01 59 EB 01 EB AC 54 E8 03 5C EB 08 }
    condition:
        $a at pe.entry_point

}

rule UPX_120_Markus_Laszlo: PEiD
{
    strings:
        $a = { 31 2E 32 30 00 55 50 58 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1333_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B ?? 24 0C EB 01 ?? 83 ?? B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 }
    condition:
        $a at pe.entry_point

}

rule EP_v10: PEiD
{
    strings:
        $a = { 50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1 }
        $b = { 50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1 C0 30 ?? 68 ?? ?? F3 00 C3 AA }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Thinstall_Virtualization_Suite_V3049_V3080_Thinstall_Company: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 2C 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB }
        $b = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 2C 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_PEtite_2x_level_0: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 B8 00 90 90 00 6A 00 68 90 90 90 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8 03 00 68 }
    condition:
        $a at pe.entry_point

}

rule VMProtect_v125_PolyTech: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 55 50 52 }
        $b = { 8B 45 00 83 C5 02 66 8B 00 66 89 45 00 E9 A5 06 00 00 8B 45 00 66 8B 55 04 83 C5 06 66 89 10 E9 }
        $c = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 06 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PE_Packer_Vecna: PEiD
{
    strings:
        $a = { FC 8B 35 70 01 40 00 83 EE 40 6A 40 68 00 30 10 }
    condition:
        $a at pe.entry_point

}

rule COM2EXE_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 8C CA 81 C2 ?? ?? 3B 16 ?? ?? 76 ?? BA ?? ?? B4 09 CD 21 CD 20 }
    condition:
        $a at pe.entry_point

}

rule Xenocode_Virtual_Application_Studio_2009_Xenocode_20090203: PEiD
{
    strings:
        $a = { 58 00 65 00 6E 00 6F 00 63 00 6F 00 64 00 65 00 20 00 56 00 69 00 72 00 74 00 75 00 61 00 6C 00 20 00 41 00 70 00 70 00 6C 00 69 00 61 00 6E 00 63 00 65 00 20 00 52 00 75 00 6E 00 74 00 69 00 6D 00 65 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 31 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 32 00 3A 00 20 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 33 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 34 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 35 00 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_V10X_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 83 C4 04 EB 02 ?? ?? 60 E8 24 00 00 00 00 00 ?? EB 02 ?? ?? 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 ?? ?? 89 C4 61 EB 2E ?? ?? ?? ?? ?? ?? ?? EB 01 ?? 31 C0 EB 01 ?? 64 FF 30 EB 01 ?? 64 89 20 EB 02 ?? ?? 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 ?? 58 61 EB 01 }
    condition:
        $a at pe.entry_point

}

rule LC_300_1986: PEiD
{
    strings:
        $a = { FA B8 00 00 05 10 00 B1 04 D3 E8 8C CB 03 C3 8E D8 8E D0 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_v254_Teggo_additional: PEiD
{
    strings:
        $a = { 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 8B 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 24 61 58 58 FF D0 E8 ?? ?? 00 00 6A 00 FF 15 ?? ?? ?? 00 CC CC CC CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule ORiEN_V1X_V2X_Fisun_AV_Sign_by_fly_additional: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F }
    condition:
        $a at pe.entry_point

}

rule NeoLite_104: PEiD
{
    strings:
        $a = { 8B 44 24 04 8D 54 24 FC 23 05 11 10 00 00 E8 EB 04 00 00 FF 35 F4 13 00 00 50 FF 25 FC 13 00 00 94 9A 8D 91 9A 93 CC CD 00 B8 93 90 9D 9E 93 BE 93 93 90 9C 00 B8 93 90 9D 9E 93 B9 8D 9A 9A 00 B8 9A 8B B2 90 9B 8A 93 9A B7 9E 91 9B 93 9A BE }
    condition:
        $a at pe.entry_point

}

rule EXE_Manager_Version_30_1994_c_Solar_Designer_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 1E 06 CD 21 2E ?? ?? ?? BF ?? ?? B9 ?? ?? 33 C0 2E ?? ?? 47 E2 }
    condition:
        $a at pe.entry_point

}

rule bambam_V001_bedrock: PEiD
{
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1 }
        $b = { 6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_Yodas_Protector_102_Anorganix: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 90 90 }
    condition:
        $a at pe.entry_point

}

rule eXPressorPacK_V150X_CGSoftLabs: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 83 A5 ?? ?? ?? ?? ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C ?? 75 23 8B 45 08 A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 04 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_37x_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 B8 3B 01 00 00 03 C5 33 DB 81 C3 01 01 01 01 31 18 81 38 78 54 00 00 74 04 31 18 EB EC }
    condition:
        $a at pe.entry_point

}

rule FreeHand_8_document_Hint_FILE_START: PEiD
{
    strings:
        $a = { 41 47 44 33 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_v20b4_additional: PEiD
{
    strings:
        $a = { 83 EC 10 53 55 56 57 C7 44 24 14 F0 91 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 88 72 40 00 BE 00 D4 42 00 BF 00 04 00 00 56 57 A3 60 6F 42 00 FF 15 C4 70 40 00 E8 9F FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 60 71 40 00 68 E4 91 40 00 56 FF D3 E8 7C FF FF FF 85 C0 0F 84 59 01 00 00 BE E0 66 42 00 56 FF 15 68 70 40 00 68 D8 91 40 00 56 E8 FE 27 00 00 57 FF 15 BC 70 40 00 BE 00 C0 42 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 C0 42 00 22 A3 E0 6E 42 00 8B C6 75 0A C6 44 24 13 22 B8 01 C0 42 00 8B 3D 10 72 40 00 EB 09 3A 4C 24 13 74 09 50 FF D7 8A 08 84 C9 75 F1 50 FF D7 8B F0 89 74 24 1C EB 05 56 FF D7 8B F0 80 3E 20 74 F6 80 3E 2F 75 44 46 80 3E 53 75 0C 8A 46 01 0C 20 3C 20 75 03 83 CD 02 81 3E 4E 43 52 }
    condition:
        $a at pe.entry_point

}

rule WinZip_32_bit_SFX_v8x_module_additional: PEiD
{
    strings:
        $a = { 53 FF 15 ?? ?? ?? 00 B3 22 38 18 74 03 80 C3 FE 8A 48 01 40 33 D2 3A CA 74 0A 3A CB 74 06 8A 48 01 40 EB F2 38 10 74 01 40 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule Upack_V038_Dwing_20080321: PEiD
{
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5B 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? 69 ED 00 0C 00 00 8D AC 2B 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 50 33 C9 E9 FB 00 00 00 04 F9 1A C0 B1 30 8B 6B 08 03 D1 FF 16 73 49 03 D1 FF 16 72 17 03 D1 FF 16 72 27 24 02 04 09 50 8B C7 2B 43 08 8A 00 E9 CD 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 24 03 04 08 50 55 8D 93 78 07 00 00 FF 56 54 5D 91 E9 95 00 00 00 24 03 04 07 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 54 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 4C 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 10 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v102a_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 3E D9 43 ?? B8 38 ?? ?? ?? 03 C5 2B 85 0B DE 43 ?? 89 85 17 DE 43 ?? 80 BD 01 DE 43 ?? ?? 75 15 FE 85 01 DE 43 ?? E8 1D ?? ?? ?? E8 79 02 ?? ?? E8 12 03 ?? ?? 8B 85 03 DE 43 ?? 03 85 17 DE 43 ?? 89 44 24 1C 61 FF }
    condition:
        $a at pe.entry_point

}

rule CubiComp_PictureMaker_graphics_format_red_Hint_FILE_START: PEiD
{
    strings:
        $a = { 16 0C FF 02 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_Watcom_CCpp_DLL_Anorganix: PEiD
{
    strings:
        $a = { 53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F 87 01 00 00 00 F1 }
    condition:
        $a at pe.entry_point

}

rule HACKSTOP_v119_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? D6 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ACProtect_109_Anorganix: PEiD
{
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_131_Build_20070615_Dll_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 81 ED ?? ?? ?? ?? E9 49 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 8A 84 24 28 00 00 00 80 F8 01 0F 84 07 00 00 00 B8 ?? ?? ?? ?? FF E0 E9 04 00 00 00 ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 81 C0 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 30 10 40 49 0F 85 F6 FF FF FF E9 04 00 00 00 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 81 ED ?? ?? ?? ?? E9 49 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_02_VOB_ProtectCD_5: PEiD
{
    strings:
        $a = { 36 3E 26 8A C0 60 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32_Brczi_Gbor_Pierre_Muller_Peter_Vreman_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? ?? 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
    condition:
        $a at pe.entry_point

}

rule MingWin32_v_h_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? 00 E8 ?? FE FF FF 90 8D B4 26 00 00 00 00 55 }
    condition:
        $a at pe.entry_point

}

rule PESHiELD_v01b_MTE_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B9 1B 01 ?? ?? D1 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v140b2_v140b4: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 86 11 }
    condition:
        $a at pe.entry_point

}

rule NT_Shell_40: PEiD
{
    strings:
        $a = { 2E 8C 1E FE 00 8C CA 8E DA 8E C2 FA 8E D2 BC FE 00 FB E8 00 00 EB 01 EA B9 A7 1E 5E 8B FE EB 01 EA 83 C7 65 2B CF EB 01 EA 32 D2 33 ED 33 DB EB 01 CD 8A 05 8A F0 EB 01 EA 2A C2 34 00 EB 01 EA 2C 00 51 EB 01 CD 8B CD EB 01 EA EB 01 EA D2 C8 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V11X_Method1_bagie: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B FA BD ?? ?? ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Borland_Delphi_60_70: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 53 8B D8 33 C0 A3 09 09 09 00 6A 00 E8 09 09 00 FF A3 09 09 09 00 A1 09 09 09 00 A3 09 09 09 00 33 C0 A3 09 09 09 00 33 C0 A3 09 09 09 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Vx_Heloween1172_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? 56 50 06 0E 1F 8C C0 01 ?? ?? 01 ?? ?? 80 ?? ?? ?? ?? 8B ?? ?? A3 ?? ?? 8A ?? ?? A2 ?? ?? B8 ?? ?? CD 21 3D }
    condition:
        $a at pe.entry_point

}

rule PESpin_v11_Cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Armadillo_301_350a_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD B8 43 }
    condition:
        $a at pe.entry_point

}

rule UPolyX_04_by_delikon: PEiD
{
    strings:
        $a = { 55 8B EC ?? ?? ?? ?? ?? ?? 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 E9 ?? E2 ?? C3 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V1820_p_Oreans_Technologies: PEiD
{
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 68 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v13_v14_Vaska_additional: PEiD
{
    strings:
        $a = { 55 8B EC 8B 44 24 04 83 E8 4F 68 ?? ?? ?? ?? FF D0 58 59 50 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V1X_Method2_bagie: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v300a: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB }
    condition:
        $a at pe.entry_point

}

rule SoftSentry_v30_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 E9 B0 06 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Basic_50_60_: PEiD
{
    strings:
        $a = { C1 CB 10 EB 01 0F B9 03 74 F6 EE 0F B6 D3 8D 05 83 ?? ?? EF 80 F3 F6 2B C1 EB 01 DE 68 77 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Joiner_sign_from_pinch_26032007_0212_additional: PEiD
{
    strings:
        $a = { 44 90 4C 90 B9 DE 00 00 00 BA 00 10 40 00 83 C2 03 44 90 4C B9 07 00 00 00 44 90 4C 33 C9 C7 05 08 30 40 00 00 00 00 00 90 68 00 01 00 00 68 21 30 40 00 6A 00 E8 C5 02 00 00 90 6A 00 68 80 }
    condition:
        $a at pe.entry_point

}

rule UPX_124_Markus_Laszlo: PEiD
{
    strings:
        $a = { 31 2E 32 34 00 55 50 58 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_PE_Pack_099_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A }
    condition:
        $a at pe.entry_point

}

rule FASM_15x: PEiD
{
    strings:
        $a = { 6A 00 FF 15 ?? ?? 40 00 A3 ?? ?? 40 00 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_additional: PEiD
{
    strings:
        $a = { 03 05 00 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule FreeCryptor_03_GlOFF: PEiD
{
    strings:
        $a = { 1E 98 3? }
    condition:
        $a at pe.entry_point

}

rule Upack_V022_V023_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    strings:
        $a = { 6A 07 BE ?? ?? ?? ?? AD 8B F8 59 95 F3 A5 AD ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 59 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF ?? ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 E9 07 01 00 00 8B 5D 0C 83 C2 30 FF 16 73 53 83 C2 30 FF 16 72 1B 83 C2 30 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C B1 80 8A 00 EB CF 83 C2 60 FF 16 87 5D 10 73 0D 83 C2 30 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 95 7C 07 00 00 FF 56 0C 5B 91 E9 9C 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_20_RC2: PEiD
{
    strings:
        $a = { 83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 }
    condition:
        $a at pe.entry_point

}

rule Minke_101_by_Codius_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 ?? ?? ?? ?? ?? 10 E8 7A F6 FF FF BE 68 66 00 10 33 C0 55 68 DB 40 00 10 64 FF 30 64 89 20 E8 FA F8 FF FF BA EC 40 00 10 8B C6 E8 F2 FA FF FF 8B D8 B8 6C 66 00 10 8B 16 E8 88 F2 FF FF B8 6C 66 00 10 E8 76 F2 FF FF 8B D0 8B C3 8B 0E E8 E3 E4 FF FF E8 2A F9 FF FF E8 C1 F8 FF FF B8 6C 66 00 10 8B 16 E8 6D FA FF FF E8 14 F9 FF FF E8 AB F8 FF FF 8B 06 E8 B8 E3 FF FF 8B D8 B8 6C 66 00 10 E8 38 F2 FF FF 8B D3 8B 0E E8 A7 E4 FF ?? ?? ?? ?? C4 FB FF FF E8 E7 F8 FF FF 8B C3 E8 B0 E3 FF FF E8 DB F8 FF FF 33 C0 5A 59 59 64 89 10 68 E2 40 00 10 C3 E9 50 EB FF FF EB F8 5E 5B E8 BB EF FF FF 00 00 00 43 41 31 38 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v10b_Ashkbiz_Danehkar_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v70_DLL: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 }
        $b = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 ?? ?? 83 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_Modifier_v01x: PEiD
{
    strings:
        $a = { 50 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_3_Portions_Copyright_c_198396_Borland_h: PEiD
{
    strings:
        $a = { 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 36 20 42 6F 72 6C 61 6E 64 00 }
    condition:
        $a at pe.entry_point

}

rule Tiny_Xor_01: PEiD
{
    strings:
        $a = { FC B8 00 00 BB 00 00 B9 00 00 BE 03 01 30 04 02 C3 86 C4 86 DF 46 E2 F5 BE 00 01 C7 04 00 00 C6 44 02 00 33 C0 33 DB 33 C9 FF E6 }
    condition:
        $a at pe.entry_point

}

rule kkrunchy_023_alpha_2_Ryd_additional: PEiD
{
    strings:
        $a = { BD ?? ?? ?? ?? C7 45 00 ?? ?? ?? 00 B8 ?? ?? ?? 00 89 45 04 89 45 54 50 C7 45 10 ?? ?? ?? 00 FF 4D 0C FF 45 14 FF 45 58 C6 45 1C 08 B8 00 08 00 00 8D 7D 30 AB AB AB AB BB 00 00 D8 00 BF ?? ?? ?? 01 31 C9 41 8D 74 09 01 B8 CA 8E 2A 2E 99 F7 F6 01 C3 89 D8 }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_DLL_LZBRS_BeRo_Farbrausch: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 ?? ?? ?? ?? 72 03 A4 EB F2 E8 ?? ?? ?? ?? 8D 51 FF E8 ?? ?? ?? ?? 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33 }
    condition:
        $a at pe.entry_point

}

rule Vx_Sonik_Youth_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8A 16 02 00 8A 07 32 C2 88 07 43 FE C2 81 FB }
    condition:
        $a at pe.entry_point

}

rule DBPE_v233_Ding_Boy: PEiD
{
    strings:
        $a = { EB 20 ?? ?? 40 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9C 55 57 56 52 51 53 9C E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 9C 6A 10 73 0B EB 02 C1 51 E8 06 ?? ?? ?? C4 11 73 F7 5B CD 83 C4 04 EB 02 99 EB FF 0C 24 71 }
    condition:
        $a at pe.entry_point

}

rule Winkript_v10: PEiD
{
    strings:
        $a = { 33 C0 8B B8 00 ?? ?? ?? 8B 90 04 ?? ?? ?? 85 FF 74 1B 33 C9 50 EB 0C 8A 04 39 C0 C8 04 34 1B 88 04 39 41 3B CA 72 F0 58 }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encryptor_v10_Stone: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 63 3A 40 ?? 2B 95 C2 3A 40 ?? 83 EA 0B 89 95 CB 3A 40 ?? 8D B5 CA 3A 40 ?? 0F B6 36 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_CD_Cops_II: PEiD
{
    strings:
        $a = { 53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 E9 }
    condition:
        $a at pe.entry_point

}

rule UPX_v0761_pe_exe: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 66 ?? ?? ?? ?? ?? ?? 57 83 ?? ?? 31 DB EB }
    condition:
        $a at pe.entry_point

}

rule PESpin_03_cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B }
    condition:
        $a at pe.entry_point

}

rule Vcasm_Protector_10: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 }
    condition:
        $a at pe.entry_point

}

rule XPack_152_164_EXE: PEiD
{
    strings:
        $a = { 8B EC FA 33 C0 8E D0 BC 10 00 2E 8F 06 CD 03 2E 8F 06 D2 03 EB 01 9A 0E BB C2 03 53 5F EB 01 9A 17 8B E5 FB 48 D1 E8 EB 01 9A CE 9A 9C EB 01 9A 59 80 CD 01 51 9D EB 01 9A 1E 33 DB 8E DB C7 47 10 00 00 C7 47 12 00 00 0E 1F 8B EC EB 01 9A FA }
    condition:
        $a at pe.entry_point

}

rule ROD_High_TECH_Ayman: PEiD
{
    strings:
        $a = { 60 8B 15 1D 13 40 00 F7 E0 8D 82 83 19 00 00 E8 58 0C 00 00 }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Automatic_Protection_641_Safenet_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule y0das_Crypter_v10_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED E7 1A 40 00 E8 A1 00 00 00 E8 D1 00 00 00 E8 85 01 00 00 F7 85 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_PESHiELD_025_emadicius: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 0D 0A 0D 0A 0D 0A 52 65 67 69 73 74 41 72 65 64 20 74 6F 3A 20 4E 4F 4E 2D 43 4F 4D 4D 45 52 43 49 41 4C 21 21 0D 0A 0D 0A 0D 00 58 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule PECompact_200_alpha_38: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F }
    condition:
        $a at pe.entry_point

}

rule R_Crypt_091: PEiD
{
    strings:
        $a = { 68 00 01 60 BF 03 01 B9 00 00 B0 00 2E 30 05 FE C0 47 E2 F8 61 C7 06 00 01 00 00 C6 06 02 01 00 C3 }
    condition:
        $a at pe.entry_point

}

rule EPW_120_EXE: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 05 10 00 2E A3 0A 00 8E D8 A1 08 00 2E 03 06 0A 00 2E A3 0C 00 A1 0E 00 2E 03 06 0A 00 2E A3 06 00 A1 10 00 2E A3 04 00 A1 14 00 2E A3 00 00 A1 16 00 2E 03 06 0A 00 2E A3 02 00 0E 1F BA 32 00 }
    condition:
        $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_V01_NTkrnl_Software: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule PESpin_11_Cyberbob_h_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule CryptCom_v11: PEiD
{
    strings:
        $a = { BF ?? ?? 57 BE ?? ?? ?? B9 ?? ?? F3 A4 C3 8B ?? ?? ?? 8B ?? ?? ?? BF ?? ?? 57 BE ?? ?? ?? AD 33 C2 AB E2 ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? B8 }
    condition:
        $a at pe.entry_point

}

rule FreeHand_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 41 47 44 32 }
    condition:
        $a at pe.entry_point

}

rule CauseWay_DOS_Extender_v264_v325_1992_95_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 8B E8 8C C6 0E 1F 8C C0 05 ?? ?? 01 ?? ?? ?? B8 ?? ?? CD 21 3C ?? 73 }
    condition:
        $a at pe.entry_point

}

rule HACKSTOP_v110p1_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 86 E0 3D 00 03 73 ?? B4 2F CD 21 B4 2A CD 21 B4 2C CD 21 B0 FF B4 4C CD 21 50 B8 ?? ?? 58 EB }
    condition:
        $a at pe.entry_point

}

rule Morphnah_Beta_Kas_additional: PEiD
{
    strings:
        $a = { 2E 6E 61 68 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 A0 00 00 E0 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_p_Virus_Shield: PEiD
{
    strings:
        $a = { 03 05 40 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_Encrypted_without_selfcheck: PEiD
{
    strings:
        $a = { B3 ?? B9 ?? ?? BE ?? ?? BF ?? ?? EB ?? 54 69 ?? ?? ?? ?? 03 ?? ?? 32 C3 AA 43 49 E3 ?? EB ?? BE ?? ?? 8B C6 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v410_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 D0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 7C A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 78 A5 4C 00 C1 E1 08 03 CA 89 0D 74 A5 4C 00 C1 E8 10 A3 70 A5 4C 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4C 00 A3 84 BB 4C 00 E8 01 12 00 00 A3 D0 A5 4C 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v12_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 CA ?? ?? ?? 03 ?? 04 ?? 05 ?? 06 ?? 07 ?? 08 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ACProtect_109_Anorganix_additional: PEiD
{
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v2xx: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_DLL: PEiD
{
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 }
        $b = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Cpp_30_old_crap: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? FF }
        $b = { 64 A1 00 00 00 00 55 ?? ?? 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? 00 00 83 EC 10 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_CD_Cops_II_Anorganix_additional: PEiD
{
    strings:
        $a = { 53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 E9 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_V13X_V14X_RiSco_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v15x_CGSoftLabs_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 58 02 00 00 53 56 57 83 A5 CC FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C 01 75 23 }
    condition:
        $a at pe.entry_point

}

rule MetaWare_High_C_p_Phar_Lap_DOS_Extender_1983_89_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E D8 B8 ?? ?? CD 21 A3 ?? ?? 3C 03 7D ?? B4 09 }
    condition:
        $a at pe.entry_point

}

rule Go32Stub_v200T_DOS_Extender: PEiD
{
    strings:
        $a = { 0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 3C }
    condition:
        $a at pe.entry_point

}

rule ASPack_v2000_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 70 05 00 00 EB 4C }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v261_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 28 ?? ?? ?? 68 E4 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 6C ?? ?? ?? 33 D2 8A D4 89 15 0C }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_DEF_10: PEiD
{
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 E9 }
    condition:
        $a at pe.entry_point

}

rule SoftDefender_V11X_Randy_Li: PEiD
{
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 }
    condition:
        $a at pe.entry_point

}

rule CrypWrap_CrypKey_Canada_Inc: PEiD
{
    strings:
        $a = { E8 B8 ?? ?? ?? E8 90 02 ?? ?? 83 F8 ?? 75 07 6A ?? E8 ?? ?? ?? ?? FF 15 49 8F 40 ?? A9 ?? ?? ?? 80 74 0E }
    condition:
        $a at pe.entry_point

}

rule Utah_RLE_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 52 CC 00 00 00 00 ?? ?? ?? ?? 09 ?? 08 ?? 08 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1987_or_Borland_Cpp_1991_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FB BA ?? ?? 2E 89 ?? ?? ?? B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule Morphine_27_Holy_Father_Ratter29A_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        $a at pe.entry_point

}

rule nPack_V112752006Beta_NEOx_SignByfly_200800212: PEiD
{
    strings:
        $a = { 55 8B EC 51 51 56 57 BE ?? ?? ?? ?? 8D 7D F8 66 A5 A4 BE ?? ?? ?? ?? 8D 7D FC 8D 45 FC 66 A5 50 8D 45 F8 50 A4 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 5F 5E 75 05 E8 02 00 00 00 C9 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 1A 02 00 00 E8 CA 06 00 00 E8 19 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3 }
        $b = { 55 8B EC 51 51 56 57 BE ?? ?? ?? ?? 8D 7D F8 66 A5 A4 BE ?? ?? ?? ?? 8D 7D FC 8D 45 FC 66 A5 50 8D 45 F8 50 A4 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 5F 5E 75 05 E8 02 00 00 00 C9 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Phonebook_configuration_file_Version_v3v4: PEiD
{
    strings:
        $a = { 50 68 6F 6E 65 62 6F 6F 6B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 63 6F }
        $b = { 02 6F ?? ?? ?? 0A 0A 06 8D ?? ?? ?? 01 0B 16 0C 38 36 00 00 00 02 08 6F ?? ?? ?? 0A 0D 09 06 08 59 61 D2 13 04 09 1E 63 08 61 D2 13 05 07 08 11 05 1E 62 11 04 60 D1 9D 08 17 58 0C 08 07 8E 69 38 0B 00 00 00 28 ?? ?? ?? 0A 2A 38 EC FF FF FF 3F C0 FF FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    strings:
        $a = { EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_LCC_Win32_1x_Anorganix: PEiD
{
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 E9 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v25_Retail_Bitsum_Technologies_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule aPack_090_m_p_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 00 01 BF 00 01 50 57 FC B2 80 BD 00 01 50 A4 FF D5 73 FB FF D5 73 14 FF D5 73 00 33 DB B1 04 FF D5 13 DB E2 FA 75 00 93 AA EB E4 E8 00 00 49 E2 07 5B 53 E8 00 00 EB 00 49 AC 8A E1 93 E8 }
    condition:
        $a at pe.entry_point

}

rule Guardant_Stealth_aka_Novex_Dongle: PEiD
{
    strings:
        $a = { 50 53 51 52 57 56 8B 75 1C 8B 3E 8B 5D 08 8A FB 03 5D 10 8B 45 0C 8B 4D 14 8B 55 18 80 FF }
        $b = { 55 8B EC 83 C4 F0 60 E8 51 FF FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_v02Beta_additional: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 95 A5 33 C0 33 }
    condition:
        $a at pe.entry_point

}

rule Vx_KBDflags1024_additional: PEiD
{
    strings:
        $a = { 8B EC 2E 89 2E 24 03 BC 00 04 8C D5 2E 89 2E 22 }
    condition:
        $a at pe.entry_point

}

rule Unknown_encryptor_3_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 1E 06 8C D8 05 ?? ?? 8E D8 8E C0 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 8B E8 2E }
    condition:
        $a at pe.entry_point

}

rule PKLITE32_11_PKWARE_Inc_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 00 00 00 00 E8 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule UPX_Modified_stub_additional: PEiD
{
    strings:
        $a = { 50 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD }
    condition:
        $a at pe.entry_point

}

rule PESpin_v07_Cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 88 39 40 00 8B 42 3C 03 C2 89 85 92 39 40 00 EB 01 DB 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D A6 39 40 00 53 8F 85 4A 38 40 00 BB ?? 00 00 00 B9 EC 0A 00 00 8D BD 36 3A 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 56 44 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 B3 5F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D 99 39 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_v032_Beta_Patch: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule Escargot_01_final_ppMeat: PEiD
{
    strings:
        $a = { EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 49 C6 04 01 40 0B C9 75 F7 BE 00 10 ?? ?? B9 00 ?? ?? 00 EB 05 49 80 34 31 40 0B C9 75 F7 58 0B C0 74 08 33 C0 C7 00 DE C0 AD 0B BE ?? ?? ?? ?? E9 AC 00 00 00 8B 46 0C BB 00 00 ?? ?? 03 C3 50 50 }
        $b = { EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Petite_22_c1998_99_Ian_Luck_h_additional: PEiD
{
    strings:
        $a = { 66 9C 60 50 8D 88 ?? F0 ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 68 ?? ?? ?? ?? 53 50 80 04 24 08 50 80 04 24 42 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Delphi_Borland_Cpp_additional: PEiD
{
    strings:
        $a = { C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6 }
    condition:
        $a at pe.entry_point

}

rule VBOX_v43_v46_additional: PEiD
{
    strings:
        $a = { 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 8B C5 }
    condition:
        $a at pe.entry_point

}

rule ARC_SFX_Archive: PEiD
{
    strings:
        $a = { 8C C8 8C DB 8E D8 8E C0 89 ?? ?? ?? 2B C3 A3 ?? ?? 89 ?? ?? ?? BE ?? ?? B9 ?? ?? BF ?? ?? BA ?? ?? FC AC 32 C2 8A D8 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1338_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 57 27 00 00 }
        $b = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER_additional: PEiD
{
    strings:
        $a = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        $a at pe.entry_point

}

rule modified_HACKSTOP_v111f_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 52 B4 30 CD 21 52 FA ?? FB 3D ?? ?? EB ?? CD 20 0E 1F B4 09 E8 }
    condition:
        $a at pe.entry_point

}

rule FACRYPT_v10: PEiD
{
    strings:
        $a = { B9 ?? ?? B3 ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 49 43 32 E4 03 D0 E3 }
    condition:
        $a at pe.entry_point

}

rule PMODEW_v112_116_121_133_DOS_extender_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC 16 07 BF ?? ?? 8B F7 57 B9 ?? ?? F3 A5 06 1E 07 1F 5F BE ?? ?? 06 0E A4 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_Dll_aPlib_043_ap0xnbsp_nbsp_Sign_by_fly: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule WinRAR_32_bit_SFX_Module_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Rec_014: PEiD
{
    strings:
        $a = { 06 1E 0E 0E 07 1F 52 B8 00 30 1E CD 21 86 E0 3D FF 02 73 02 CD 20 0E 1F B4 09 E8 03 00 24 24 EA 5A CD 21 1F 5A 53 BB EB 04 5B EB FB 9A EB 2D FE 20 E7 E4 9B 20 30 2E 31 34 20 28 87 29 20 EB 98 20 E7 30 24 EE 20 FE 20 9F AD 64 30 3A 20 32 3A }
    condition:
        $a at pe.entry_point

}

rule Inno_Setup_Module_v2018_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 B8 53 56 57 33 C0 89 45 F0 89 45 BC 89 45 B8 E8 73 71 FF FF E8 DA 85 FF FF E8 81 A7 FF FF E8 C8 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v160_v165_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 80 40 ?? 87 DD 8B 85 D2 80 40 ?? 01 85 33 80 40 ?? 66 C7 85 ?? 80 40 ?? 90 90 01 85 CE 80 40 ?? BB BB 12 }
    condition:
        $a at pe.entry_point

}

rule OS2_Icon_Graphics_format: PEiD
{
    strings:
        $a = { 43 49 4E 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule AMGC_Archive: PEiD
{
    strings:
        $a = { AD 36 22 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_40_50_: PEiD
{
    strings:
        $a = { EB 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 75 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v102_dllocx_Ashkbiz_Danehkar_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
    condition:
        $a at pe.entry_point

}

rule PEStubOEP_v1x: PEiD
{
    strings:
        $a = { 40 48 BE 00 ?? ?? 00 40 48 60 33 C0 B8 ?? ?? ?? 00 FF E0 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule EXE_Stealth_v27_additional: PEiD
{
    strings:
        $a = { EB 00 60 EB 00 E8 00 00 00 00 5D 81 ED B0 27 40 }
    condition:
        $a at pe.entry_point

}

rule eXPressorPacK_150X_CGSoftLabs: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 83 A5 ?? ?? ?? ?? ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C ?? 75 23 8B 45 08 A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 04 }
    condition:
        $a at pe.entry_point

}

rule Crunch_v40_additional: PEiD
{
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D 00 E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 74 F3 75 F1 EB 24 64 FF 35 00 00 00 00 EB 12 FF 9C 74 03 75 01 E9 81 0C 24 00 01 00 00 9D 90 EB F4 64 89 25 00 00 00 00 EB E6 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 58 EB 13 C7 83 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 AD CD 20 E8 05 00 00 00 0F 01 EB 05 E8 EB FB 00 00 83 C4 04 E8 08 00 00 00 0F 01 83 C0 }
    condition:
        $a at pe.entry_point

}

rule Exe_Shield_v17: PEiD
{
    strings:
        $a = { EB 06 68 90 1F 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1337_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule Password_protector_my_SMT_additional: PEiD
{
    strings:
        $a = { C8 50 01 00 60 E8 EC 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 44 69 61 6C 6F 67 42 6F 78 49 6E 64 69 72 65 63 74 50 61 72 61 6D 41 00 53 65 6E 64 4D 65 73 73 61 67 65 41 00 45 6E 64 44 69 61 6C 6F }
    condition:
        $a at pe.entry_point

}

rule SoftProtect_wwwsoftprotectbyru: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? 01 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_11_additional: PEiD
{
    strings:
        $a = { B4 51 CD 21 8E DB B8 ?? ?? 83 E8 ?? 8E C0 33 F6 33 FF B9 ?? ?? FC F3 A5 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_13x_Eng_Pavol_Cerven_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
    condition:
        $a at pe.entry_point

}

rule Vx_GRUNT1Family_additional: PEiD
{
    strings:
        $a = { 01 B9 ?? 00 31 17 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Protect_09_Anorganix: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9 }
    condition:
        $a at pe.entry_point

}

rule RJcrush_v100_additional: PEiD
{
    strings:
        $a = { 06 FC 8C C8 BA ?? ?? 03 D0 52 BA ?? ?? 52 BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 }
    condition:
        $a at pe.entry_point

}

rule Vx_Heloween1172: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? 56 50 06 0E 1F 8C C0 01 ?? ?? 01 ?? ?? 80 ?? ?? ?? ?? 8B ?? ?? A3 ?? ?? 8A ?? ?? A2 ?? ?? B8 ?? ?? CD 21 3D }
    condition:
        $a at pe.entry_point

}

rule Armadillo_300a_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F }
    condition:
        $a at pe.entry_point

}

rule ARJ_SFX_Archive: PEiD
{
    strings:
        $a = { 4D 5A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 4A 53 58 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_BJFNT_11b_Anorganix: PEiD
{
    strings:
        $a = { EB 01 EA 9C EB 01 EA 53 EB 01 EA 51 EB 01 EA 52 EB 01 EA 56 90 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v22: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v20: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8B D8 03 ?? 68 54 BC ?? ?? 6A ?? FF 50 18 8B CC 8D A0 54 BC ?? ?? 8B C3 8D 90 E0 15 ?? ?? 68 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v21: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v50_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 68 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 53 56 57 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V500_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC FF 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_additional: PEiD
{
    strings:
        $a = { A1 ?? ?? ?? ?? C1 E0 02 A3 }
    condition:
        $a at pe.entry_point

}

rule MinGW_v32x_Dll_mainCRTStartup: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 6A ?? 6A ?? 6A ?? 6A ?? E8 0D ?? ?? ?? B8 ?? ?? ?? ?? C9 C3 90 90 90 90 90 90 FF 25 38 20 40 ?? 90 90 ?? ?? ?? ?? ?? ?? ?? ?? FF FF FF FF ?? ?? ?? ?? FF FF FF }
        $b = { 55 89 E5 83 EC 08 6A 00 6A 00 6A 00 6A 00 E8 0D 00 00 00 B8 00 00 00 00 C9 C3 90 90 90 90 90 90 FF 25 38 20 00 10 90 90 00 00 00 00 00 00 00 00 FF FF FF FF 00 00 00 00 FF FF FF FF 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_2021_wwwstrongbitcom_SignByhaggar_additional: PEiD
{
    strings:
        $a = { A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V120_Dll_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 6F 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 27 05 00 00 89 85 B6 05 00 00 5B FF B5 B6 05 00 00 56 FF D3 83 C4 08 8B B5 B6 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 EB 6E 56 FF 95 1F 05 00 00 0B C0 75 05 E8 C9 02 00 00 85 C0 0F 84 94 00 00 00 89 85 AE 05 00 00 8B C6 EB 2A 8B 85 B2 05 00 00 8B 00 50 FF B5 AE 05 00 00 E8 11 02 00 00 85 C0 74 72 89 07 83 85 B2 05 00 00 04 83 C7 04 8B 85 B2 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 80 3E 01 75 8D 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 B6 05 00 00 FF 95 2B 05 00 00 68 00 80 00 00 6A 00 FF B5 B6 05 00 00 FF 95 2B 05 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule PKZIP_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 50 4B 03 04 }
    condition:
        $a at pe.entry_point

}

rule Vx_SYP: PEiD
{
    strings:
        $a = { 47 8B C2 05 1E 00 52 8B D0 B8 02 3D CD 21 8B D8 5A }
    condition:
        $a at pe.entry_point

}

rule PECompact_V2X_Bitsum_Technologies_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_V12_SIS_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 91 02 6D 61 6C 6C 6F 63 00 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 C5 02 73 74 72 73 74 72 00 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 }
    condition:
        $a at pe.entry_point

}

rule Upack_028_0399_relocated_image_base_Delphi_NET_DLL_or_something_else_Dwing_h: PEiD
{
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? 00 E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD 03 C3 50 97 AD 91 F3 A5 5E AD 56 91 01 1E AD E2 FB AD 8D 6E 10 01 5D 00 8D 7D 1C B5 ?? F3 AB 5E AD 53 50 51 97 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v100c_2_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BA ?? ?? A1 ?? ?? 2D ?? ?? 8C CB 81 C3 ?? ?? 3B C3 77 ?? 05 ?? ?? 3B C3 77 ?? B4 09 BA ?? ?? CD 21 CD 20 90 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_ZCode_101: PEiD
{
    strings:
        $a = { E9 12 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E9 FB FF FF FF C3 68 00 00 00 00 64 FF 35 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v126b1_v126b2_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? 05 0E }
    condition:
        $a at pe.entry_point

}

rule MEW_11_SE_12_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 0C ?? ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SuckStop_111: PEiD
{
    strings:
        $a = { 4B 41 4F 54 58 EB 02 8E 7C BE 10 00 B4 30 CD 21 EB 0A 9B 00 00 00 00 00 BF 00 00 B9 3C 03 77 02 CD 20 4E 75 E7 6A 00 0E 6A 69 FE C3 CF AC 66 64 33 06 0C 00 66 65 2B 06 90 06 8C EA 03 C2 CF 32 C7 AA CF 47 72 65 65 74 7A 20 74 6F 20 61 6C 6C }
    condition:
        $a at pe.entry_point

}

rule SuckStop_110: PEiD
{
    strings:
        $a = { 4B 41 4F 54 5C EB 02 8E 7C BE 10 00 B4 30 CD 21 EB 0A 9B 00 00 00 00 00 BF 00 00 B9 3C 03 77 02 CD 20 4E 75 E7 6A 00 0E 6A 5E FE C3 CF AC 66 64 33 06 0C 00 66 65 2B 06 90 06 8C EA 03 C2 CF 32 C7 AA CF 41 6E 61 72 63 68 79 20 77 69 6C 6C 20 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_FORTRAN_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC 8C DB 8E C3 BB ?? ?? B9 ?? ?? 9A ?? ?? ?? ?? 80 ?? ?? ?? ?? 74 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule UPolyX_delikon: PEiD
{
    strings:
        $a = { FF 96 ?? ?? ?? 00 61 E9 ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_Debug: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4E 65 6F 4C 69 74 65 }
        $b = { E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule code: PEiD
{
    strings:
        $a = { 83 EC 50 60 68 ?? ?? ?? ?? E8 CB FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_multi_layer_encryption: PEiD
{
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8A 14 08 80 F2 ?? 88 14 08 41 83 F9 ?? 75 F1 }
        $b = { 60 B8 ?? ?? ?? 00 B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_v11_additional: PEiD
{
    strings:
        $a = { BB D0 01 40 ?? BF ?? 10 40 ?? BE }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_Desktop_File_additional: PEiD
{
    strings:
        $a = { 54 75 72 62 6F 20 50 61 73 63 61 6C 20 44 65 73 6B 74 6F 70 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1337_20070620_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule tElock_v095_additional: PEiD
{
    strings:
        $a = { E9 D5 E4 FF FF 00 }
    condition:
        $a at pe.entry_point

}

rule shoooos_Pack_shoooo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 11 55 07 8B EC B8 ?? ?? ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v13_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 45 78 50 72 2D 76 2E 31 2E 33 2E }
    condition:
        $a at pe.entry_point

}

rule Private_EXE_v20a: PEiD
{
    strings:
        $a = { 53 E8 00 00 00 00 5B 8B C3 2D }
        $b = { 53 E8 ?? ?? ?? ?? 5B 8B C3 2D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PKLITE_v200b_extra_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 02 00 72 ?? B4 09 BA ?? ?? CD 21 B8 01 4C CD 21 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA ?? ?? ?? ?? F3 A5 C3 59 2D ?? ?? 8E D0 51 2D ?? ?? 50 80 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_additional: PEiD
{
    strings:
        $a = { F7 D9 80 E1 FE 75 02 49 49 97 A3 ?? ?? 03 C1 24 FE 75 02 48 }
    condition:
        $a at pe.entry_point

}

rule RLP_V073beta_ap0x_additional: PEiD
{
    strings:
        $a = { 2E 72 6C 70 00 00 00 00 00 50 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 }
    condition:
        $a at pe.entry_point

}

rule ProActivate_V10X_TurboPower_Software_Company_additional: PEiD
{
    strings:
        $a = { 55 8B EC B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 ?? ?? ?? ?? 90 90 90 90 90 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 C0 05 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0D 00 00 00 E8 85 E2 FF FF 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 7A 81 3D ?? ?? ?? ?? 43 52 43 33 75 6E 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 62 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 56 81 3D ?? ?? ?? ?? 43 52 43 33 75 4A 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 3E 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 32 81 3D ?? ?? ?? ?? 43 52 43 33 }
    condition:
        $a at pe.entry_point

}

rule eXPressorProtection_V150X_CGSoftLabs_Sign_by_fly: PEiD
{
    strings:
        $a = { EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02 66 F0 68 ?? ?? ?? ?? E8 0E 05 00 00 59 EB 01 DD 83 65 F4 00 EB 07 8B 45 F4 40 89 45 F4 83 7D F4 61 73 1F EB 02 DA 1A 8B 45 F4 0F ?? ?? ?? ?? ?? ?? 33 45 F4 8B 4D F4 88 ?? ?? ?? ?? ?? EB 01 EB EB }
        $b = { EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPXHiT_v001_DJ_Siba: PEiD
{
    strings:
        $a = { 94 BC ?? ?? ?? 00 B9 ?? 00 00 00 80 34 0C ?? E2 FA 94 FF E0 61 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_24x_25x_Jitit_Software: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? BD ?? ?? ?? ?? 03 E8 }
        $b = { 6A 00 FF 15 20 50 40 00 E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Haryanto_additional: PEiD
{
    strings:
        $a = { 81 EB 2A 01 8B 0F 1E 5B 03 CB 0E 51 B9 10 01 51 CB }
    condition:
        $a at pe.entry_point

}

rule PC_PE_Encryptor_Alpha_preview: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 ?? 2B 8D EE 32 40 00 83 E9 0B 89 8D F2 32 40 ?? 80 BD D1 32 40 ?? 01 0F 84 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v140_v145_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 8A 11 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_V2736_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB F3 1C 00 00 2B C3 50 68 00 00 40 00 68 00 26 00 00 68 CC 00 00 00 E8 C1 FE FF FF E9 97 FF FF FF CC CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule CopyControl_v303: PEiD
{
    strings:
        $a = { CC 90 90 EB 0B 01 50 51 52 53 54 61 33 61 2D 35 CA D1 07 52 D1 A1 3C }
    condition:
        $a at pe.entry_point

}

rule CERBERUS_v20: PEiD
{
    strings:
        $a = { 9C 2B ED 8C ?? ?? 8C ?? ?? FA E4 ?? 88 ?? ?? 16 07 BF ?? ?? 8E DD 9B F5 B9 ?? ?? FC F3 A5 }
    condition:
        $a at pe.entry_point

}

rule DotFix_Nice_Protect_21_GPcH_Soft_additional: PEiD
{
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v1304_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 01 ?? 33 C0 EB 01 ?? 8B 00 EB 01 ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 01 ?? E8 3B 26 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_V2021_protected_IAT_wwwstrongbitcom: PEiD
{
    strings:
        $a = { A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 ?? ?? ?? 70 ?? ?? ?? 84 ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 }
    condition:
        $a at pe.entry_point

}

rule Reg2Exe_225_by_Jan_Vorel_additional: PEiD
{
    strings:
        $a = { 6A 00 E8 CF 20 00 00 A3 F4 45 40 00 E8 CB 20 00 00 6A 0A 50 6A 00 FF 35 F4 45 40 00 E8 07 00 00 00 50 E8 BB 20 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 F8 45 40 00 E8 06 19 00 00 83 C4 0C 8B 44 24 04 A3 FC 45 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 }
    condition:
        $a at pe.entry_point

}

rule Zylom_encrypted_game_Zylom_games: PEiD
{
    strings:
        $a = { 2E 74 65 78 74 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 72 64 61 74 61 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 64 61 74 61 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 72 73 72 63 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 7A 79 6C 6D 73 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 60 2E 7A 79 6C 6D 69 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 }
    condition:
        $a at pe.entry_point

}

rule UPX_v060_v061: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 58 83 E8 3D 50 8D B8 FF 57 66 81 87 8D B0 F0 01 83 CD FF 31 DB 90 90 90 EB 08 90 90 8A 06 46 88 07 47 01 DB 75 }
        $b = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 ?? ?? ?? FF 57 8D B0 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_293_LZMA: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 89 E5 8D 9C 24 ?? ?? ?? ?? 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? ?? 57 83 C3 04 53 68 ?? ?? ?? ?? 56 83 C3 04 53 50 C7 03 03 00 02 00 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule SQZ_Archive: PEiD
{
    strings:
        $a = { 48 4C 53 51 5A }
    condition:
        $a at pe.entry_point

}

rule PC_Shrinker_v029_Virogen: PEiD
{
    strings:
        $a = { ?? BD ?? ?? ?? ?? 01 AD 55 39 40 00 8D B5 35 39 40 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_13045_SoftComplete_Development: PEiD
{
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 31 C0 89 41 14 89 41 18 80 A1 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22007411_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEtite_v22_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        $a at pe.entry_point

}

rule AinEXE_222: PEiD
{
    strings:
        $a = { A1 02 00 2D E1 0B 8E D0 BC 00 BE 8C D8 36 A3 00 BE 05 10 00 36 A3 02 BE 2E A1 0E 00 8A D4 B1 04 D2 EA D3 E0 8C D3 36 8B 2E 02 BE 2E 03 2E 0E 00 FD FE CA 78 17 81 ED 00 10 80 EF 10 8E DD 8E C3 BE FE FF 8B FE B9 00 80 F3 A5 EB E5 8B F0 B9 04 }
    condition:
        $a at pe.entry_point

}

rule vfpexeNc_V500_Wang_JianGuo_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC }
    condition:
        $a at pe.entry_point

}

rule ChinaProtect_dummy_Sign_by_fly: PEiD
{
    strings:
        $a = { C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 56 8B ?? ?? ?? 6A 40 68 00 10 00 00 8D ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 89 30 83 C0 04 5E C3 8B 44 ?? ?? 56 8D ?? ?? 68 00 40 00 00 FF 36 56 E8 ?? ?? ?? ?? 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 5E C3 }
    condition:
        $a at pe.entry_point

}

rule Metrowerks_CodeWarrior_v20_Console: PEiD
{
    strings:
        $a = { 55 89 E5 55 B8 FF FF FF FF 50 50 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule Adys_Glue_v010: PEiD
{
    strings:
        $a = { 2E 8C 06 ?? ?? 0E 07 33 C0 8E D8 BE ?? ?? BF ?? ?? FC B9 ?? ?? 56 F3 A5 1E 07 5F }
    condition:
        $a at pe.entry_point

}

rule _v10_Li_Jianjun: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 }
    condition:
        $a at pe.entry_point

}

rule Shrink_20_2: PEiD
{
    strings:
        $a = { 50 9C FC BE 27 01 8B FE 8C C8 05 00 10 8E C0 06 57 B9 41 00 F3 A4 8B 0E 23 01 BE 68 01 F3 A4 CB 00 00 00 00 BE 68 01 8B 0E 23 01 8A 26 25 01 1E 06 1F 07 BF 00 01 57 AC 3A C4 74 13 8A D8 AA E2 F6 5B 9D 58 06 53 8B D9 8B F1 8B F9 06 1F CB AC }
    condition:
        $a at pe.entry_point

}

rule Ionic_Wind_Software_additional: PEiD
{
    strings:
        $a = { 9B DB E3 9B DB E2 D9 2D 00 ?? ?? 00 55 89 E5 E8 }
    condition:
        $a at pe.entry_point

}

rule Shrink_20_1: PEiD
{
    strings:
        $a = { E9 00 00 50 9C FC BE 27 01 8B FE 8C C8 05 00 10 8E C0 06 57 B9 41 00 F3 A4 8B 0E 23 01 BE 68 01 F3 A4 CB 00 00 00 00 BE 68 01 8B 0E 23 01 8A 26 25 01 1E 06 1F 07 BF 00 01 57 AC 3A C4 74 13 8A D8 AA E2 F6 5B 9D 58 06 53 8B D9 8B F1 8B F9 06 }
    condition:
        $a at pe.entry_point

}

rule PECompact_V2X_Bitsum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 }
    condition:
        $a at pe.entry_point

}

rule ExeCode_v10_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FA 8C C3 02 DF 50 33 C0 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 8E D0 BC ?? ?? BE ?? ?? B9 ?? ?? 33 FF 2E ?? ?? ?? ?? ?? ?? 32 DB B0 ?? E6 64 AC }
    condition:
        $a at pe.entry_point

}

rule Erdas_LANGIS_Image_graphics_format_additional: PEiD
{
    strings:
        $a = { 48 45 41 44 37 34 00 00 03 00 }
    condition:
        $a at pe.entry_point

}

rule PC_Guard_v303d_v305d_additional: PEiD
{
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Code_Lock_Anorganix: PEiD
{
    strings:
        $a = { 43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B }
    condition:
        $a at pe.entry_point

}

rule AntiDote_10_Demo_12_SIS_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C }
    condition:
        $a at pe.entry_point

}

rule Mask_23: PEiD
{
    strings:
        $a = { 55 57 CD 03 FC 4D 41 53 4B FA 8B EC 83 6E 06 03 FF 76 06 5D 49 E8 00 00 5B 81 EB A6 05 50 D6 51 52 56 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_V23X_MoleStudiocom: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ProPack_208_m2_EXE: PEiD
{
    strings:
        $a = { 8C D3 8E C3 8C CA 8E DA 8B 0E 08 00 8B F1 83 EE 02 8B FE D1 E9 FD F3 A5 53 B8 2E 00 50 8B 2E 0A 00 CB B8 00 10 3B C5 76 02 8B C5 2B E8 2B D0 2B D8 8E DA 8E C3 B1 03 D3 E0 8B C8 D1 E0 48 48 8B F0 8B F8 F3 A5 0B ED 75 D9 FC 8E C2 8E DB BE 12 }
    condition:
        $a at pe.entry_point

}

rule Mask_25: PEiD
{
    strings:
        $a = { 55 57 CD 03 FC 4D 41 53 4B FD 50 FA 8B C4 F7 DC BC 01 00 94 49 FB D6 51 52 1F 52 56 B4 30 CD 21 C7 06 00 00 0D 0A C7 06 00 00 07 24 BA 00 00 B4 09 EB 00 B9 53 01 56 5D BE 00 00 56 5F B8 15 35 CD 21 06 53 BA 00 00 0E 07 B4 25 CD 21 EB 1B 05 }
    condition:
        $a at pe.entry_point

}

rule Upack_v0399_Dwing: PEiD
{
    strings:
        $a = { 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? 00 00 00 40 00 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 02 00 00 00 00 00 00 ?? 00 00 00 00 00 10 00 00 ?? 00 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? 00 14 00 00 00 00 ?? ?? 00 ?? ?? 00 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? 00 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? 00 ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 }
        $b = { 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? 00 00 00 40 00 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 02 00 00 00 00 00 00 ?? 00 00 00 00 00 10 00 00 ?? 00 00 00 00 10 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Matrix_Dongle_TDi_GmbH: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 E8 B6 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? E8 00 00 00 00 5B 2B D9 8B F8 8B 4C 24 2C 33 C0 2B CF F2 AA 8B 3C 24 8B 0A 2B CF 89 5C 24 20 80 37 A2 47 49 75 F9 8D 64 24 04 FF 64 24 FC 60 C7 42 08 ?? ?? ?? ?? E8 C5 FF FF FF C3 C2 F7 29 4E 29 5A 29 E6 86 8A 89 63 5C A2 65 E2 A3 A2 }
        $b = { E8 00 00 00 00 E8 00 00 00 00 59 5A 2B CA 2B D1 E8 1A FF FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Trilobytes_RNR_graphics_library: PEiD
{
    strings:
        $a = { 84 10 ?? ?? ?? ?? ?? ?? ?? 10 }
    condition:
        $a at pe.entry_point

}

rule ILUCRYPT_v4015_exe: PEiD
{
    strings:
        $a = { 8B EC FA C7 46 F7 ?? ?? 42 81 FA ?? ?? 75 F9 FF 66 F7 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_nSPack_13_emadicius: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 }
    condition:
        $a at pe.entry_point

}

rule BAFF_BMPs_graphics_library_Hint_FILE_START: PEiD
{
    strings:
        $a = { 42 41 46 46 01 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_v0399_Dwing_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 39 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? ?? 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? 56 10 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 99 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B 7E 34 0F 82 AC FE FF FF 58 5F 59 E3 1B 8A 07 47 04 18 3C 02 73 F7 8B 07 3C ?? 75 F3 B0 00 0F C8 03 46 38 2B C7 AB E2 E5 5E 5D 59 46 AD 85 C0 74 1F 51 56 97 FF D1 93 AC 84 C0 75 FB 38 06 74 EA 8B C6 79 05 46 33 C0 66 AD 50 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V125_Obsidium_Software: PEiD
{
    strings:
        $a = { E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 0D 33 C0 C3 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1304_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Inset_Systems_IGF_graphics_file: PEiD
{
    strings:
        $a = { 01 80 04 00 01 00 58 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_022_023_beta_Dwing_: PEiD
{
    strings:
        $a = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 59 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 }
    condition:
        $a at pe.entry_point

}

rule NsPack_30_by_North_Star_Liu_Xing_Ping_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 55 F9 FF FF 66 8B 06 66 83 F8 00 74 15 8B F5 8D B5 7D F9 FF FF 66 8B 06 66 83 F8 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 11 F9 FF FF 89 95 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_v50_Unit_Hint_FILE_START: PEiD
{
    strings:
        $a = { 54 50 55 35 00 }
    condition:
        $a at pe.entry_point

}

rule DzA_Patcher_13_Loader: PEiD
{
    strings:
        $a = { BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 }
    condition:
        $a at pe.entry_point

}

rule CopyControl_v303_additional: PEiD
{
    strings:
        $a = { 1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13 D6 83 C7 32 F7 DA 03 FE EB 02 CD 20 87 FA 88 10 EB 02 CD 20 40 E8 02 00 00 00 F1 F8 5B 4E 2B D2 85 F6 75 AF EB 02 DE 09 EB 01 EF 34 4A 7C BC 7D 3D 7F 90 C1 82 41 ?? ?? ?? 87 DB 71 94 8B 8C 8D 90 61 05 96 1C A9 DA A7 68 5A 4A 19 CD 76 40 50 A0 9E B4 C5 15 9B D7 6E A5 BB CC 1C C2 DE 6C AC C2 D3 23 D2 65 B5 F5 65 C6 B6 CC DD CC 7B 2F B6 33 FE 6A AC 9E AB 07 C5 C6 C7 F3 94 3F DB B4 05 CE CF D0 BC FA 7F A5 BD 4A 18 EB A2 C5 F7 6D 25 9F BF E8 8D CA 05 E4 E5 E6 24 E8 66 EA EB 5F F7 6E EB F5 64 F8 76 EC 74 6D F9 }
    condition:
        $a at pe.entry_point

}

rule Datafile_from_Norton_Utilities: PEiD
{
    strings:
        $a = { 50 4E 43 49 }
    condition:
        $a at pe.entry_point

}

rule PEiD_Bundle_v102_v104_BoB_BobSoft: PEiD
{
    strings:
        $a = { 60 E8 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 36 ?? ?? ?? 2E ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 44 }
    condition:
        $a at pe.entry_point

}

rule aPack_098_f_m_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 00 01 BF 00 01 50 57 FC B2 80 BD 00 01 50 A4 FF D5 73 FB FF D5 41 73 12 FF D5 BB 10 00 72 24 FF D5 12 DB 73 FA 75 00 93 EB 00 B7 01 FF D5 12 FF 72 00 FF D5 72 F6 FF D5 13 C9 FF D5 72 F8 80 EF 03 72 00 8A }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b1_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 28 63 40 ?? 87 DD 8B 85 AD 63 }
    condition:
        $a at pe.entry_point

}

rule COM2EXE_Hint_FILE_START_p14: PEiD
{
    strings:
        $a = { F0 FF FE FF }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_12003518_WFS_additional: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 97 3B 40 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v123b3_v1241_Jeremy_Collake: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? D2 08 }
    condition:
        $a at pe.entry_point

}

rule Unknown_by_SMT: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 83 ?? ?? 57 EB }
    condition:
        $a at pe.entry_point

}

rule nPack_v11_150_200_Beta_NEOx: PEiD
{
    strings:
        $a = { 83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? 00 E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 }
        $b = { 83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule tElock_098_tE_additional: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2223_protected_IAT: PEiD
{
    strings:
        $a = { CC ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? B4 ?? ?? ?? 08 ?? ?? ?? 00 00 00 00 FF FF FF FF E8 ?? ?? ?? 04 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4C ?? ?? ?? 60 ?? ?? ?? 70 ?? ?? ?? 84 ?? ?? ?? 94 ?? ?? ?? A4 ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v14_CGSoftLabs_: PEiD
{
    strings:
        $a = { 65 58 50 72 2D 76 2E 31 2E 34 2E }
    condition:
        $a at pe.entry_point

}

rule CryEXE_40: PEiD
{
    strings:
        $a = { E9 A1 FF E8 5C FF 55 E9 08 00 A5 12 BB 06 00 E8 95 FF E9 62 FF B9 FE 0C BE 0B 0F 2E 8A 14 89 F3 80 C2 46 80 F2 73 81 F3 E4 35 80 EA 22 30 DA 30 FA 2E 88 14 4E 49 74 02 EB E1 E5 46 C2 A3 2B 4B F8 59 54 DC 59 09 F4 A5 01 52 F5 56 B2 D3 7E 1B }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_DLL_LZBRS_additional: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 ?? ?? ?? ?? 72 03 A4 EB F2 E8 ?? ?? ?? ?? 8D 51 FF E8 ?? ?? ?? ?? 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v250b3: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B8 ?? ?? ?? 68 F8 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 20 ?? ?? ?? 33 D2 8A D4 89 15 D0 }
    condition:
        $a at pe.entry_point

}

rule Morphine_27_Holy_Father_Ratter29A_h: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
        $b = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Excalibur_103_forgot: PEiD
{
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PEtite_2x_level_0_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 B8 00 90 90 00 6A 00 68 90 90 90 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8 03 00 68 }
    condition:
        $a at pe.entry_point

}

rule BJFnt_v11b_additional: PEiD
{
    strings:
        $a = { EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 60 E8 03 ?? ?? ?? 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 EB 01 83 9C EB 01 D5 EB 08 35 9D EB 01 89 EB 03 0B EB F7 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 59 83 01 01 80 39 5C 75 F2 33 C4 74 0C 23 C4 0B C4 C6 01 59 C6 01 59 EB E2 90 E8 44 14 ?? ?? 8D 85 CF 13 ?? ?? C7 ?? ?? ?? ?? ?? E8 61 0E ?? ?? E8 2E 14 ?? ?? 8D 85 E4 01 ?? ?? 50 E8 E2 15 ?? ?? 83 BD 23 01 ?? ?? 01 75 07 E8 21 0D ?? ?? EB 09 8D 85 CF 13 ?? ?? 83 08 01 83 BD 1F 01 ?? ?? 01 75 07 E8 3E 0C ?? ?? EB 05 E8 A8 0C ?? ?? E8 B3 02 ?? ?? 8D 85 63 02 ?? ?? 50 E8 A3 15 ?? ?? 8D 85 F5 02 ?? ?? 50 E8 97 15 ?? ?? E8 E2 01 ?? ?? 8D 85 09 05 ?? ?? 50 E8 86 15 ?? ?? 8D 85 F8 0F ?? ?? 50 E8 7A 15 ?? ?? 8D 85 88 0F ?? ?? 50 E8 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V0X_V12X_vcasm: PEiD
{
    strings:
        $a = { 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 76 63 61 73 6D 5F 70 72 6F 74 65 63 74 5F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 58 EB 13 C7 83 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 AD CD 20 EB 01 0F 31 F0 EB 0C 33 C8 EB 03 EB 09 0F 59 74 05 75 F8 51 EB F1 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 49 75 F1 EB 05 EB F9 EB F0 D6 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 C0 02 EB 01 E9 50 C3 }
    condition:
        $a at pe.entry_point

}

rule Vx_EVC161_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 06 FA 33 DB 8E C3 26 ?? ?? ?? ?? 8F ?? ?? ?? 26 ?? ?? ?? ?? 8F ?? ?? ?? B8 21 25 BA ?? ?? CD 21 FB 07 BA ?? ?? CD 27 }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt32_v102_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5B 83 ?? ?? EB ?? 52 4E 44 21 }
    condition:
        $a at pe.entry_point

}

rule PESHiELD_v025_additional: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Basic_v50: PEiD
{
    strings:
        $a = { 68 }
        $b = { FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Anti007_NsPacK_Private_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule TopSpeed_v301_1989: PEiD
{
    strings:
        $a = { 1E BA ?? ?? 8E DA 8B ?? ?? ?? 8B ?? ?? ?? FF ?? ?? ?? 50 53 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ExeSmasher_Anorganix: PEiD
{
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B E9 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_Microsoft_Visual_Cpp_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_2xx_Mole_Studio: PEiD
{
    strings:
        $a = { 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 8C 36 00 00 E9 A0 36 00 00 E9 9B 36 00 00 E8 4A FF FF FF 79 ?? ?? ?? ?? ?? ?? ?? 4E }
    condition:
        $a at pe.entry_point

}

rule FSG_13_additional: PEiD
{
    strings:
        $a = { BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 3C AA EB E0 FF 53 08 02 F6 83 D9 01 75 0E FF 53 04 EB 26 AC D1 E8 74 2F 13 C9 EB 1A 91 48 C1 E0 08 AC FF 53 04 3D 00 7D }
    condition:
        $a at pe.entry_point

}

rule themida_1005_httpwwworeanscom_additional: PEiD
{
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 }
    condition:
        $a at pe.entry_point

}

rule ABKprot_v100_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 CD 21 86 E0 3D ?? ?? 73 ?? 9C 8C C0 06 5B 59 51 53 BA ?? ?? 87 F2 56 CF 0E 1F 0E 07 }
    condition:
        $a at pe.entry_point

}

rule CICompress_v10_additional: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B D5 81 ED A2 30 40 00 2B 95 91 33 40 00 81 EA 0B 00 00 00 89 95 9A 33 40 00 80 BD 99 33 40 00 00 74 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60_additional: PEiD
{
    strings:
        $a = { EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA }
    condition:
        $a at pe.entry_point

}

rule PerlApp_602_ActiveState_additional: PEiD
{
    strings:
        $a = { 68 9C E1 40 00 FF 15 A4 D0 40 00 85 C0 59 74 0F 50 FF 15 1C D1 40 00 85 C0 59 89 45 FC 75 62 6A 00 8D 45 F8 FF 75 0C F6 45 14 01 50 8D 45 14 50 E8 9B 01 00 00 83 C4 10 85 C0 0F 84 E9 00 00 00 8B 45 F8 83 C0 14 50 FF D6 85 C0 59 89 45 FC 75 0E FF 75 14 FF 15 78 D0 40 00 E9 C9 00 00 00 68 8C E1 40 00 FF 75 14 50 }
    condition:
        $a at pe.entry_point

}

rule Exe_Shield_27b_additional: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 }
    condition:
        $a at pe.entry_point

}

rule UPX_wwwupxsourceforgenet_additional: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? 00 8D BE ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_DEF_10_Anorganix: PEiD
{
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 E9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_MFC_additional: PEiD
{
    strings:
        $a = { C0 ?? ?? 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 ?? 00 00 00 00 00 ?? 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig2_additional: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 0F 84 ?? ?? 00 00 83 FE 01 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2xx_max_compressed_resources_wwwstrongbitcom_SignByhaggar_additional: PEiD
{
    strings:
        $a = { 56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89 }
    condition:
        $a at pe.entry_point

}

rule Upack_v038_beta_Dwing_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 38 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? ?? 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 33 D2 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B 7E 34 0F 82 97 FE FF FF 58 5F 59 E3 1B 8A 07 47 04 18 3C 02 73 F7 8B 07 3C ?? 75 F1 B0 00 0F C8 03 46 38 2B C7 AB E2 E5 5E 5D 59 51 59 46 AD 85 C0 74 1F }
    condition:
        $a at pe.entry_point

}

rule SVKP_v143_Pavol_Cerven_h_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC CE 05 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_v30_additional: PEiD
{
    strings:
        $a = { 83 ?? ?? 6A 00 FF 15 F8 10 0B B0 8D ?? ?? ?? 51 6A 08 6A 00 6A 00 68 }
    condition:
        $a at pe.entry_point

}

rule Elicense_System_V4000_ViaTech_Inc_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 63 79 62 00 65 6C 69 63 65 6E 34 30 2E 64 6C 6C 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ADEX_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 50 49 43 54 00 08 ?? 02 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_PESHiELD_025: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_PiMP_Stub_SFX: PEiD
{
    strings:
        $a = { 81 EC ?? ?? ?? ?? 53 55 56 }
    condition:
        $a at pe.entry_point

}

rule Splasher_v10_v30: PEiD
{
    strings:
        $a = { 9C 60 8B 44 24 24 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 50 E8 ED 02 ?? ?? 8C C0 0F 84 }
    condition:
        $a at pe.entry_point

}

rule Anticrack_Software_Protector_v109_ACProtect_additional: PEiD
{
    strings:
        $a = { 60 ?? ?? ?? ?? ?? 90 5D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 DD }
    condition:
        $a at pe.entry_point

}

rule PECompact_v092_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 BD ?? ?? ?? ?? B9 02 ?? ?? ?? B0 90 8D BD A5 4F 40 ?? F3 AA 01 AD 04 51 40 ?? FF B5 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v275a_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 68 ?? ?? ?? 68 D0 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 24 }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encryptor_v113_Stone: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 97 ?? 3B 40 2B 95 2D ?? 3C 40 83 EA ?? 0B 89 95 36 3C 40 01 ?? 95 24 3C 40 01 ?? 95 28 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_vxxxx_Obsidium_Software: PEiD
{
    strings:
        $a = { E8 47 19 }
    condition:
        $a at pe.entry_point

}

rule DCrypt_Private_09b_drmist: PEiD
{
    strings:
        $a = { B9 ?? ?? ?? 00 E8 00 00 00 00 58 68 ?? ?? ?? 00 83 E8 0B 0F 18 00 D0 00 48 E2 FB C3 }
    condition:
        $a at pe.entry_point

}

rule UPX_051_PE: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 00 00 00 FF 57 8D B0 D8 01 00 00 83 CD FF 31 DB 90 90 90 90 01 DB 75 07 8B 1E 83 EE FC 11 DB 73 0B 8A 06 46 88 07 47 EB EB 90 90 90 B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 EF 75 }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Dongle_V54200_Rainbow_Technologies_SignByfly_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 }
    condition:
        $a at pe.entry_point

}

rule unknown_by_Mr_Wicked: PEiD
{
    strings:
        $a = { BE 03 01 8B FE 8B CE 33 C0 8E D8 C7 06 0E 00 00 00 C6 06 04 00 0D 26 AC BA 00 00 52 FE 0E 04 00 74 0B E8 F7 FF D0 C8 FE C8 32 06 0E 00 C3 AA FF 0E 0E 00 75 DC 0E 1F BE 00 00 BF 00 01 2B CF 57 F3 A4 C3 }
    condition:
        $a at pe.entry_point

}

rule VMProtect_07x_08_PolyTech_additional: PEiD
{
    strings:
        $a = { 5B 20 56 4D 50 72 6F 74 65 63 74 20 76 20 30 2E 38 20 28 43 29 20 50 6F 6C 79 54 65 63 68 20 5D }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_LZMA_430_ap0xnbsp_nbsp_Sign_by_fly_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 }
    condition:
        $a at pe.entry_point

}

rule Upack_V03X_Dwing_additional: PEiD
{
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 C9 5E 87 0E }
    condition:
        $a at pe.entry_point

}

rule EPExE_Pack_V14_lite_b2_6aHguT_g_l_u_k: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 }
    condition:
        $a at pe.entry_point

}

rule LE_Exe_Executable_Image: PEiD
{
    strings:
        $a = { 4C 45 }
    condition:
        $a at pe.entry_point

}

rule TXT2COM_v206_additional: PEiD
{
    strings:
        $a = { 8D 26 ?? ?? E8 ?? ?? B8 ?? ?? CD 21 CD 20 54 58 54 32 43 4F 4D 20 }
    condition:
        $a at pe.entry_point

}

rule Unnamed_Scrambler_12B_p0ke_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D8 53 56 57 33 C0 89 45 D8 89 45 DC 89 45 E0 89 45 E4 89 45 E8 B8 70 3A 40 00 E8 C4 EC FF FF 33 C0 55 68 5C 3F 40 00 64 FF 30 64 89 20 E8 C5 D7 FF FF E8 5C F5 FF FF B8 20 65 40 00 33 C9 BA 04 01 00 00 E8 D3 DB FF FF 68 04 01 00 00 68 20 65 40 00 6A 00 FF 15 10 55 40 00 BA 6C 3F 40 00 B8 14 55 40 00 E8 5A F4 FF FF 85 C0 0F 84 1B 04 00 00 BA 18 55 40 00 8B 0D 14 55 40 00 E8 16 D7 FF FF 8B 05 88 61 40 00 8B D0 B8 54 62 40 00 E8 D4 E3 FF FF B8 54 62 40 00 E8 F2 E2 FF FF 8B D0 B8 18 55 40 00 8B 0D 88 61 40 00 E8 E8 D6 FF FF FF 35 34 62 40 00 FF 35 30 62 40 00 FF 35 3C 62 40 00 FF 35 38 62 40 00 8D 55 E8 A1 88 61 40 00 E8 E3 F0 FF FF 8B 55 E8 }
    condition:
        $a at pe.entry_point

}

rule Upack_037_beta_Dwing: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 37 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
        $b = { BE E0 11 ?? ?? FF 36 E9 C3 00 00 00 48 01 ?? ?? 0B 01 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPX_v062_DLL_additional: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 95 01 00 00 60 E8 00 00 00 00 58 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_V12_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_239_compressed_resources: PEiD
{
    strings:
        $a = { 51 68 ?? ?? ?? ?? 59 81 F1 12 3C CB 98 E9 53 2C 00 00 F7 D7 E9 EB 60 00 00 83 45 F8 02 E9 E3 36 00 00 F6 45 F8 20 0F 84 1E 21 00 00 55 E9 80 62 00 00 87 0C 24 8B E9 ?? ?? ?? ?? 00 00 23 C1 81 E9 ?? ?? ?? ?? 57 E9 ED 00 00 00 0F 88 ?? ?? ?? ?? E9 2C 0D 00 00 81 ED BB 43 CB 79 C1 E0 1C E9 9E 14 00 00 0B 15 ?? ?? ?? ?? 81 E2 2A 70 7F 49 81 C2 9D 83 12 3B E8 0C 50 00 00 E9 A0 16 00 00 59 5B C3 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 E8 41 42 00 00 E9 93 33 00 00 31 DB 89 D8 59 5B C3 A1 ?? ?? ?? ?? 8A 00 2C 99 E9 82 30 00 00 0F 8A ?? ?? ?? ?? B8 01 00 00 00 31 D2 0F A2 25 FF 0F 00 00 E9 72 21 00 00 0F 86 57 0B 00 00 E9 ?? ?? ?? ?? C1 C0 03 E8 F0 36 00 00 E9 41 0A 00 00 81 F7 B3 6E 85 EA 81 C7 ?? ?? ?? ?? 87 3C 24 E9 74 52 00 00 0F 8E ?? ?? ?? ?? E8 5E 37 00 00 68 B1 74 96 13 5A E9 A1 04 00 00 81 D1 49 C0 12 27 E9 50 4E 00 00 C1 C8 1B 1B C3 81 E1 96 36 E5 }
    condition:
        $a at pe.entry_point

}

rule EPW_v12: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E ?? ?? ?? ?? 8C C0 05 ?? ?? 2E ?? ?? ?? 8E D8 A1 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule SCRAMBLE_02_beta3: PEiD
{
    strings:
        $a = { 60 9C FC 00 00 01 00 00 01 BA 13 00 01 55 01 2A D2 FF E7 B9 00 00 57 51 F3 A4 59 5E 03 F1 05 00 B4 00 00 31 04 E2 FA 9D 61 68 00 01 C3 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_v50_for_Windows_Hint_WIN_EP: PEiD
{
    strings:
        $a = { EB ?? 53 51 06 33 C0 50 9A ?? ?? ?? ?? 58 07 59 5B 9A }
    condition:
        $a at pe.entry_point

}

rule Yodas_Protector_v1032_Beta2_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEiD_Bundle_v100_BoB_BobSoft_additional: PEiD
{
    strings:
        $a = { 60 E8 21 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A }
    condition:
        $a at pe.entry_point

}

rule ANDpakk2_018_Dmitry_Andreev: PEiD
{
    strings:
        $a = { FC BE D4 00 40 00 BF 00 ?? ?? 00 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8? }
    condition:
        $a at pe.entry_point

}

rule MPEG_movie_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 00 01 BA 2F FF FD E6 C1 80 18 61 00 00 01 BB }
    condition:
        $a at pe.entry_point

}

rule kkryptor_3_rsc: PEiD
{
    strings:
        $a = { EB 66 87 DB 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? B8 }
    condition:
        $a at pe.entry_point

}

rule Private_EXE_Protector_18_SetiSoft_h: PEiD
{
    strings:
        $a = { A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 31 FF 31 F6 C3 }
    condition:
        $a at pe.entry_point

}

rule IProtect_10_Fxlibdll_mode_by_FuXdas: PEiD
{
    strings:
        $a = { EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 4C 69 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED 71 10 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 63 10 40 00 8D 85 3C 10 40 00 50 FF B5 63 10 40 00 E8 92 00 00 00 0B C0 74 13 89 85 5F 10 40 00 8D 85 49 10 40 00 50 FF 95 5F 10 40 00 8B 85 67 10 40 00 89 44 24 1C 61 FF E0 8B 7C 24 04 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 53 10 40 00 89 20 89 68 04 8D 9D 0A 11 40 00 89 58 08 64 89 25 00 00 00 00 81 E7 00 00 FF FF 66 81 3F 4D 5A 75 0F 8B F7 03 76 3C 81 3E 50 45 00 00 75 02 EB 17 81 EF 00 00 01 00 81 FF 00 00 00 70 73 07 BF 00 00 F7 BF EB 02 EB D3 97 64 8F 05 00 00 00 00 83 C4 04 C2 04 00 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 53 10 40 00 89 20 89 68 04 8D 9D 0A 11 40 00 89 58 08 64 89 25 00 00 00 00 8B 74 24 0C 66 81 3E 4D 5A 74 05 E9 8A 00 00 00 03 76 3C 81 3E 50 45 00 00 74 02 EB 7D 8B 7C 24 10 B9 96 00 00 00 32 C0 F2 AE 8B CF 2B 4C 24 10 8B 56 78 03 54 24 0C 8B 5A 20 03 5C 24 0C 33 C0 8B 3B 03 7C 24 0C 8B 74 24 10 51 F3 A6 75 05 83 C4 04 EB 0A 59 83 C3 04 40 3B 42 18 75 E2 3B 42 18 75 02 EB 35 8B 72 24 03 74 24 0C 52 BB 02 00 00 00 33 D2 F7 E3 5A 03 C6 33 C9 66 8B 08 8B 7A 1C 33 D2 BB 04 00 00 00 8B C1 F7 E3 03 44 24 0C 03 C7 8B 00 03 44 24 0C EB 02 33 C0 64 8F 05 00 00 00 00 83 C4 04 C2 08 00 E8 FA FD FF FF }
        $b = { EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 4C 69 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED 71 10 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 63 10 40 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule DJoin_v07_public_xor_encryption_drmist: PEiD
{
    strings:
        $a = { C6 05 ?? ?? 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Packman_Executable_Image_Packer_0001_bubba: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 8D A8 ?? ?? FF FF 8D 98 ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule Morphnah_Beta_Kas: PEiD
{
    strings:
        $a = { 2E 6E 61 68 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 A0 00 00 E0 }
    condition:
        $a at pe.entry_point

}

rule CRYPT_Version_17_c_Dismember_COM: PEiD
{
    strings:
        $a = { 0E 17 9C 58 F6 C4 01 ?? ?? ?? ?? ?? B4 01 BE ?? ?? BF ?? ?? B9 ?? ?? 68 ?? ?? 68 ?? ?? 68 ?? ?? 57 F3 A4 C3 B0 02 E6 21 60 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V11X_V12X_Method2_bagie_additional: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        $a at pe.entry_point

}

rule XE_Executable_Image_using_DOSExtender: PEiD
{
    strings:
        $a = { 58 45 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v184_additional: PEiD
{
    strings:
        $a = { 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2021_wwwstrongbitcom_SignByhaggar: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF ?? 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
        $b = { A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SVK_Protector_v143_wwwanticrackingsk_additional: PEiD
{
    strings:
        $a = { 78 4E 88 4C 0E B0 3C 78 4E 97 56 7B 94 90 00 00 08 DB 5C 50 20 00 05 6? }
    condition:
        $a at pe.entry_point

}

rule dUP2_diablo2oo2_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V041_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 02 D2 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F ?? ?? ?? ?? ?? BB ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 ?? 68 3C 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 59 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 ?? E8 1A 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPXFreak_v01_Borland_Delphi_HMX0101_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 00 ?? ?? ?? 00 03 00 00 00 ?? ?? ?? ?? 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 ?? F6 ?? 00 B2 4F 45 00 ?? F9 ?? 00 EF 4F 45 00 ?? F6 ?? 00 8C D1 42 00 ?? 56 ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_1992_1994: PEiD
{
    strings:
        $a = { 8C C8 8E D8 8C 1E ?? ?? 8C 06 ?? ?? 8C 06 ?? ?? 8C 06 }
    condition:
        $a at pe.entry_point

}

rule Upack_01x_Dwing: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_2_additional: PEiD
{
    strings:
        $a = { FA FC 0E 1F E8 ?? ?? 8C C0 66 0F B7 C0 66 C1 E0 ?? 66 67 A3 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_Small_build_029_GlOFF: PEiD
{
    strings:
        $a = { 50 32 C4 8A C3 58 E8 DE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 50 32 C4 8A C3 58 E8 DE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Copy_Protector_v20_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 2E A2 ?? ?? 53 51 52 1E 06 B4 ?? 1E 0E 1F BA ?? ?? CD 21 1F }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_PEX_099_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 55 83 C4 04 E8 01 00 00 00 90 5D 81 FF FF FF 00 01 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_for_Windows_2_additional: PEiD
{
    strings:
        $a = { 8C D8 ?? 45 55 8B EC 1E 8E D8 57 56 89 }
    condition:
        $a at pe.entry_point

}

rule UPX_200_30X_Markus_Oberhumer_amp_Laszlo_Molnar_amp_John_Reiser_additional: PEiD
{
    strings:
        $a = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF }
    condition:
        $a at pe.entry_point

}

rule Upack_v035_alpha_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { 8B F2 8B CA 03 4C 19 1C 03 54 1A 20 }
    condition:
        $a at pe.entry_point

}

rule CALS_Raster_graphics_format: PEiD
{
    strings:
        $a = { 73 72 63 64 6F 63 69 64 3A 20 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_regular_additional: PEiD
{
    strings:
        $a = { E9 8C CA 81 C3 ?? ?? 3B 16 ?? ?? 76 ?? BA ?? ?? B4 09 CD 21 CD 20 0D }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v300_v301_Relocations_pack_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BE ?? ?? BA ?? ?? BF ?? ?? B9 ?? ?? 8C CD 8E DD 81 ED ?? ?? 06 06 8B DD 2B DA 8B D3 FC }
    condition:
        $a at pe.entry_point

}

rule dePACK_deNULL_additional: PEiD
{
    strings:
        $a = { EB 01 DD 60 68 00 ?? ?? ?? 68 ?? ?? ?? 00 E8 ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1250_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MicroJoiner_15_coban2k_additional: PEiD
{
    strings:
        $a = { BF 00 ?? 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8 ?? ?? ?? 00 8B 30 8B 78 04 BB ?? ?? ?? 00 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 5E EB DB B9 ?? ?? 00 00 BE 00 ?? ?? 00 EB 01 00 BF ?? ?? ?? 00 EB 21 00 ?? ?? 00 00 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 C0 00 F3 A4 E9 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 00 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 C0 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encryptor_v20_Stone: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 81 ED 42 30 40 ?? FF 95 32 35 40 ?? B8 37 30 40 ?? 03 C5 2B 85 1B 34 40 ?? 89 85 27 34 40 ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Exact_Audio_Copy_UnknownCompiler: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule EXEPACK_LINK_v360_v364_v365_or_50121_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C C0 05 ?? ?? 0E 1F A3 ?? ?? 03 ?? ?? ?? 8E C0 8B ?? ?? ?? 8B ?? 4F 8B F7 FD F3 A4 50 B8 ?? ?? 50 CB }
    condition:
        $a at pe.entry_point

}

rule ass_crypter_by_santasdad_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B }
    condition:
        $a at pe.entry_point

}

rule Prepared_by_SLR_OPTLINK: PEiD
{
    strings:
        $a = { 87 C0 55 56 57 52 51 53 50 9C FC 8C DA 83 ?? ?? 16 07 0E 1F }
    condition:
        $a at pe.entry_point

}

rule Encrypted_by_RSCC286_v101: PEiD
{
    strings:
        $a = { FE 52 53 43 43 2F 31 2E 30 31 FE }
    condition:
        $a at pe.entry_point

}

rule FCRYPT_v100_1990_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 50 53 51 BE ?? ?? BF ?? ?? 8B EF B9 ?? ?? FC AC 32 C1 AA E2 ?? 59 5B 58 FF }
    condition:
        $a at pe.entry_point

}

rule MultiEdits_compiled_macros: PEiD
{
    strings:
        $a = { 1E AA }
    condition:
        $a at pe.entry_point

}

rule PKTiny_162: PEiD
{
    strings:
        $a = { 1E 0E 1F B8 F0 FF 8E C0 26 8A 1E 0E 00 80 FB FD 72 0E B4 09 BA 58 01 CD 21 1F B8 00 4C CD 21 E9 FA 55 89 E5 8D 06 46 00 05 00 01 50 83 C4 02 31 DB C7 07 E9 DD C7 47 02 01 F4 C7 87 57 02 B9 08 8B 5E FE FF E3 EA FB 31 DB B8 0D 0E CD 10 B4 03 }
    condition:
        $a at pe.entry_point

}

rule XorCom_v10_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FC BE ?? ?? BF ?? ?? 57 B9 ?? ?? AC 34 ?? AA E2 ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Vx_Noon1163: PEiD
{
    strings:
        $a = { E8 ?? ?? 5B 50 56 B4 CB CD 21 3C 07 ?? ?? 81 ?? ?? ?? 2E ?? ?? 4D 5A ?? ?? BF 00 01 89 DE FC }
    condition:
        $a at pe.entry_point

}

rule Upack_022_023_beta_Dwing: PEiD
{
    strings:
        $a = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 }
        $b = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 59 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Pelock_10x: PEiD
{
    strings:
        $a = { 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 4B 45 }
    condition:
        $a at pe.entry_point

}

rule beria_v007_public_WIP_symbiont: PEiD
{
    strings:
        $a = { 83 EC 18 53 8B 1D 00 30 ?? ?? 55 56 57 68 30 07 00 00 33 ED 55 FF D3 8B F0 3B F5 74 0D 89 AE 20 07 00 00 E8 88 0F 00 00 EB 02 33 F6 6A 10 55 89 35 30 40 ?? ?? FF D3 8B F0 3B F5 74 09 89 2E E8 3C FE FF FF EB 02 33 F6 6A 18 55 89 35 D8 43 ?? ?? FF D3 8B F0 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_ASPack_211d_emadicius_h: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig2: PEiD
{
    strings:
        $a = { C2 ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig1: PEiD
{
    strings:
        $a = { CC FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Rpoly_crypt_by_Vaska_200307_1841: PEiD
{
    strings:
        $a = { 58 ?? ?? ?? ?? ?? ?? ?? E8 00 00 00 58 E8 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? 04 }
    condition:
        $a at pe.entry_point

}

rule Vx_Hafen809: PEiD
{
    strings:
        $a = { E8 ?? ?? 1C ?? 81 EE ?? ?? 50 1E 06 8C C8 8E D8 06 33 C0 8E C0 26 ?? ?? ?? 07 3D }
    condition:
        $a at pe.entry_point

}

rule PROTECT_EXECOM_v60_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 1E B4 30 CD 21 3C 02 73 ?? CD 20 BE ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule ASPack_105b_by_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 75 00 E9 }
    condition:
        $a at pe.entry_point

}

rule PureBasic_4x_Neil_Hodgson_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? 00 00 68 00 00 00 00 68 ?? ?? ?? 00 E8 ?? ?? ?? 00 83 C4 0C 68 00 00 00 00 E8 ?? ?? ?? 00 A3 ?? ?? ?? 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 ?? ?? ?? 00 A3 }
    condition:
        $a at pe.entry_point

}

rule tElock_v041x_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v12x_additional: PEiD
{
    strings:
        $a = { 00 00 68 01 ?? ?? ?? C3 AA }
    condition:
        $a at pe.entry_point

}

rule RLPack_120_Basic_Edition_aPLib_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 }
    condition:
        $a at pe.entry_point

}

rule Werus_Crypter_10_by_Kas_additional: PEiD
{
    strings:
        $a = { BB E8 12 40 00 80 33 05 E9 7D FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v50_additional: PEiD
{
    strings:
        $a = { 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        $a at pe.entry_point

}

rule UPX_v30_DLL_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser_additional: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 0B 00 00 60 BE 00 ?? ?? ?? 8D BE 00 ?? ?? FF 57 89 E5 8D 9C 24 80 C1 FF FF 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_2628_Jtit: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 BB 34 1D 00 00 2B C3 50 68 00 00 40 00 68 00 40 00 00 68 BC 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 }
    condition:
        $a at pe.entry_point

}

rule Themida_10xx_18xx_no_compression_Oreans_Technologies_h: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00 }
        $b = { 55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8D 45 80 8B 5D 08 C7 85 7C FF FF FF 00 00 00 00 8B 8D 7C FF FF FF D1 C3 88 18 41 89 8D 7C FF FF FF 81 BD 7C FF FF FF 80 00 00 00 75 E3 C7 85 7C FF FF FF 00 00 00 00 8D BA ?? ?? ?? ?? 8D 75 80 8A 0E BB F4 01 00 00 B8 AB 37 54 78 D3 D0 8A 0F D3 D0 4B 75 F7 0F AF C3 47 46 8B 8D 7C FF FF FF 41 89 8D 7C FF FF FF 81 F9 80 00 00 00 75 D1 61 C9 C2 04 00 55 8B EC 83 C4 F0 8B 75 08 C7 45 FC 00 00 00 00 EB 04 FF 45 FC 46 80 3E 00 75 F7 BA 00 00 00 00 8B 75 08 8B 7D 0C EB 7F C7 45 F8 00 00 00 00 EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule aPack_061_COM: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 8B 01 BF 00 01 50 57 FC B6 01 BD 6C 01 FF D5 73 4C FF D5 73 18 FF D5 73 2A BB 83 01 33 C9 FF D3 FF D3 FF D3 FF D3 8B D9 43 B1 01 EB 26 E8 3B 00 49 49 AC 8A E1 93 E8 32 00 83 FB 40 73 15 83 C1 04 EB 10 AC }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_PENightMare_2_Beta: PEiD
{
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        $a at pe.entry_point

}

rule MinGW_GCC_3x_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? 55 }
    condition:
        $a at pe.entry_point

}

rule PocketPC_MIB: PEiD
{
    strings:
        $a = { E8 FF BD 27 14 00 BF AF 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF 24 00 A7 AF ?? ?? ?? 0C 00 00 00 00 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F ?? ?? ?? 0C 24 00 A7 8F ?? ?? ?? 0C 25 20 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 ?? FF BD 27 18 00 ?? AF ?? 00 }
        $b = { E8 FF BD 27 14 00 BF AF 18 00 A4 AF 1C 00 A5 AF 20 00 A6 AF 24 00 A7 AF ?? ?? ?? 0C 00 00 00 00 18 00 A4 8F 1C 00 A5 8F 20 00 A6 8F ?? ?? ?? 0C 24 00 A7 8F ?? ?? ?? 0C 25 20 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 ?? FF BD 27 18 00 ?? AF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MinGW_32x_WinMain_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 E4 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 E4 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 00 41 40 00 89 EC 5D }
    condition:
        $a at pe.entry_point

}

rule Netopsystems_FEAD_Optimizer_2: PEiD
{
    strings:
        $a = { 50 E8 00 00 00 00 5B 81 EB A2 01 00 00 B9 ?? ?? 01 00 2B D9 8B F3 81 EB 00 ?? ?? 00 8B FB 81 EB 00 10 00 00 57 51 56 E8 89 FE FF FF 83 C4 0C 8B AB C0 00 00 00 8D 2C 2B 4D 8A 4D 00 80 F9 CC 74 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_16c_by_Vaska_UsAr_sign_21032007_2225_additional: PEiD
{
    strings:
        $a = { 33 D0 68 40 A1 14 13 FF D2 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 BB 40 EB F3 33 C0 C3 }
    condition:
        $a at pe.entry_point

}

rule PEiD_1658_3DMark_Database_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 33 44 4D 61 72 6B 20 44 61 74 61 62 61 73 65 20 46 69 6C 65 }
    condition:
        $a at pe.entry_point

}

rule AHpack_01_FEUERRADER_h: PEiD
{
    strings:
        $a = { 60 68 54 ?? ?? ?? B8 48 ?? ?? ?? FF 10 68 B3 ?? ?? ?? 50 B8 44 ?? ?? ?? FF 10 68 00 ?? ?? ?? 6A 40 FF D0 89 05 CA ?? ?? ?? 89 C7 BE 00 10 ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 }
        $b = { 60 68 54 ?? ?? ?? B8 48 ?? ?? ?? FF 10 68 B3 ?? ?? ?? 50 B8 44 ?? ?? ?? FF 10 68 00 ?? ?? ?? 6A 40 FF D0 89 05 CA ?? ?? ?? 89 C7 BE 00 10 ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule TrueType_Font_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 4C 54 53 48 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v100_v103_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 8C DB 03 D8 3B }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_LZMA_430_ap0: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Cpp_50p_MFC_Anorganix: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2117_StrongbitSoftComplete_Development_h_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF 7F 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V12_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 77 1E 00 00 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_12DLLDemo_SIS_Team: PEiD
{
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF }
        $b = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule StarForce_V1X_V3X_StarForce_Copy_Protection_System: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PackMan_v0001: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 8D A8 ?? ?? FF FF 8D 98 ?? ?? ?? FF 8D ?? ?? 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule ORiEN_v211_DEMO: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F }
        $b = { E9 5D 01 00 00 CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D 20 2D 0D 0A 2D 2D 2D 2D 2D 2D 20 43 72 65 61 74 65 64 20 62 79 20 41 2E 20 46 69 73 75 6E 2C 20 31 39 39 34 2D 32 30 30 33 20 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 20 57 57 57 3A 20 68 74 74 70 3A 2F 2F 7A 61 6C 65 78 66 2E 6E 61 72 6F 64 2E 72 75 2F 20 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 20 65 2D 6D 61 69 6C 3A 20 7A 61 6C 65 78 66 40 68 6F 74 6D 61 69 6C 2E 72 75 20 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule COMPACK_51: PEiD
{
    strings:
        $a = { BD 00 00 50 06 8C CB 03 DD 8C D2 4B 8E DB BE 4A 00 BF 00 07 8E C2 B9 08 00 F3 A5 4A 4D 75 EC 8B F7 8E DA 0E 07 06 16 BF 63 06 57 33 FF F9 CB 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 31 20 57 20 43 6F 6C 6C 69 73 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_v022_v023Beta: PEiD
{
    strings:
        $a = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule FFSE_04R: PEiD
{
    strings:
        $a = { 60 E9 B2 00 EB 01 C7 E8 6C 00 FC 0F 21 D1 FA 68 00 00 07 06 1F FF E1 52 91 A7 B5 D8 6A 50 A8 67 76 6E 30 86 D8 87 91 A7 40 88 92 71 25 EB 03 EB FC 83 66 C1 CC 10 EB 01 F7 E8 3A 00 B9 EB 03 EB FC C6 B9 00 08 33 F6 BF EB 03 EB FC C0 8B FE 8B }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1258_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Rec_038: PEiD
{
    strings:
        $a = { 06 1E B4 30 CD 21 3C 02 73 05 33 C0 06 50 CB BF 66 23 8B 36 02 00 2B F7 81 FE 00 10 EB 0A B4 4A CD 21 BF 77 13 B9 81 17 00 00 EB 04 00 EB FB 9A EB }
    condition:
        $a at pe.entry_point

}

rule FASM_v13x_additional: PEiD
{
    strings:
        $a = { 6A ?? FF 15 ?? ?? ?? ?? A3 }
    condition:
        $a at pe.entry_point

}

rule Hardlock_dongle_Alladin_additional: PEiD
{
    strings:
        $a = { 5B 53 50 45 43 5D E8 ?? ?? ?? ?? 5D 8B C5 81 ED 41 24 40 ?? 2B 85 89 26 40 ?? 83 E8 0B 89 85 8D 26 40 ?? 0F B6 B5 91 26 40 ?? 8B FD }
    condition:
        $a at pe.entry_point

}

rule FIDO_mail_packet_Hint_FILE_START: PEiD
{
    strings:
        $a = { 03 00 03 00 CD 07 }
    condition:
        $a at pe.entry_point

}

rule Morphine_v12_DLL: PEiD
{
    strings:
        $a = { 00 00 00 ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 5B ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 66 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Extended_Datafile_Version: PEiD
{
    strings:
        $a = { 23 03 45 58 54 44 ?? ?? 3A 03 }
    condition:
        $a at pe.entry_point

}

rule CSV_v01_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FC BE ?? ?? 8B FE B9 ?? ?? 51 56 57 B4 ?? 04 ?? AC ?? ?? 2A C4 32 C4 AA E2 ?? 5F 5E 59 }
    condition:
        $a at pe.entry_point

}

rule CipherWall_Self_ExtratorDecryptor_GUI_v15_additional: PEiD
{
    strings:
        $a = { 90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 F9 89 C7 6A 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 }
    condition:
        $a at pe.entry_point

}

rule Cracked_by_Autohack_2: PEiD
{
    strings:
        $a = { 0E 1F B4 09 BA ?? ?? CD 21 FA 8E 06 ?? ?? BE ?? ?? 8B 0E ?? ?? 83 F9 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_VOB_ProtectCD_5_Anorganix: PEiD
{
    strings:
        $a = { 36 3E 26 8A C0 60 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Eddie2100_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 4F 4F 0E E8 ?? ?? 47 47 1E FF ?? ?? CB E8 ?? ?? 84 C0 ?? ?? 50 53 56 57 1E 06 B4 51 CD 21 8E C3 ?? ?? ?? ?? ?? ?? ?? 8B F2 B4 2F CD 21 AC }
    condition:
        $a at pe.entry_point

}

rule VProtector_11A_12_vcasm_additional: PEiD
{
    strings:
        $a = { 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 76 63 61 73 6D 5F 70 72 6F 74 65 63 74 5F 32 30 30 35 5F 33 5F 31 38 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 58 EB 13 C7 83 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 AD CD 20 EB 01 0F 31 F0 EB 0C 33 C8 EB 03 EB 09 0F 59 74 05 75 F8 51 EB F1 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 49 75 F1 EB 05 EB F9 EB F0 D6 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 C0 02 EB 01 E9 50 C3 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V10beta_ap0x_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        $a at pe.entry_point

}

rule aPack_090_COM: PEiD
{
    strings:
        $a = { 8C C8 80 C4 10 8E C0 FC B9 00 00 BE 00 01 8B FE 57 F3 A5 5F BE 00 01 06 68 20 01 1E 07 8E D8 CB 06 57 B2 80 BD 00 01 50 A4 FF D5 73 FB FF D5 73 14 FF D5 73 00 33 DB B1 04 FF D5 13 DB E2 FA 75 00 93 AA EB E4 E8 00 00 49 E2 07 5B 53 E8 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_PEtite_21_emadicius: PEiD
{
    strings:
        $a = { B8 00 50 40 00 6A 00 68 BB 21 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 83 C4 04 61 66 9D 64 8F 05 00 00 00 00 83 C4 08 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Automatic_Protection_641_Safenet: PEiD
{
    strings:
        $a = { A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule GZIP_Archive: PEiD
{
    strings:
        $a = { 1F 8B 08 08 ?? ?? ?? 35 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1988_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C D8 BB ?? ?? 8E DB 8C D3 8B CC FA 8E ?? ?? ?? BC }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig2h: PEiD
{
    strings:
        $a = { C2 ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_12_Seek_and_Destroy_Patch: PEiD
{
    strings:
        $a = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_h_good_sig_but_is_it_MSVC: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? E9 8D FE FF FF CC CC CC CC CC 66 81 3D 00 00 00 01 4D 5A 74 04 33 C0 EB 51 A1 3C 00 00 01 81 B8 00 00 00 01 50 45 00 00 75 EB 0F B7 88 18 00 00 01 81 F9 0B 01 00 00 74 1B 81 F9 0B 02 00 00 75 D4 83 B8 84 00 00 01 0E 76 CB 33 C9 39 88 F8 00 00 01 EB 11 83 B8 74 00 00 01 0E 76 B8 33 C9 39 88 E8 00 00 01 0F 95 C1 8B C1 6A 01 A3 ?? ?? ?? 01 E8 ?? ?? 00 00 50 FF ?? ?? ?? 00 01 83 0D ?? ?? ?? 01 FF 83 0D ?? ?? ?? 01 FF 59 59 FF 15 ?? ?? 00 01 8B 0D ?? ?? ?? 01 89 08 FF 15 ?? ?? 00 01 8B 0D ?? ?? ?? 01 89 08 A1 ?? ?? 00 01 8B 00 A3 ?? ?? ?? 01 E8 ?? ?? 00 00 83 3D ?? ?? ?? 01 00 75 0C 68 ?? ?? ?? 01 FF 15 ?? ?? 00 01 59 E8 ?? ?? 00 00 33 C0 C3 CC CC CC CC CC }
        $b = { E8 ?? ?? ?? ?? E9 8D FE FF FF CC CC CC CC CC 66 81 3D 00 00 00 01 4D 5A 74 04 33 C0 EB 51 A1 3C 00 00 01 81 B8 00 00 00 01 50 45 00 00 75 EB 0F B7 88 18 00 00 01 81 F9 0B 01 00 00 74 1B 81 F9 0B 02 00 00 75 D4 83 B8 84 00 00 01 0E 76 CB 33 C9 39 88 F8 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule BeRoEXEPacker_v100_DLL_LZMA_BeRo_Farbrausch: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 }
    condition:
        $a at pe.entry_point

}

rule ASPack_1083: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 00 03 DD 2B 9D B1 50 44 00 83 BD AC 50 44 00 00 89 9D BB 4E 44 00 0F 85 17 05 00 00 8D 85 D1 50 44 00 50 FF 95 94 51 44 00 89 85 CD 50 44 00 8B F8 8D 9D DE 50 44 00 53 50 FF 95 90 51 44 00 }
    condition:
        $a at pe.entry_point

}

rule PassLock_2000_10_Eng_Moonlight_Software: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 50 40 00 66 2E F7 05 34 20 40 00 04 00 0F 85 98 00 00 00 E8 1F 01 00 00 C7 43 60 01 00 00 00 8D 83 E4 01 00 00 50 FF 15 F0 61 40 00 83 EC 44 C7 04 24 44 00 00 00 C7 44 24 2C 00 00 00 00 54 FF 15 E8 61 40 00 B8 0A 00 00 00 F7 44 24 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_12Demo_SIS_Team_additional: PEiD
{
    strings:
        $a = { E8 F7 FE FF FF 05 CB 22 00 00 FF E0 E8 EB FE FF FF 05 BB 19 00 00 FF E0 E8 BD 00 00 00 08 B2 62 00 01 52 17 0C 0F 2C 2B 20 7F 52 79 01 30 07 17 29 4F 01 3C 30 2B 5A 3D C7 26 11 26 06 59 0E 78 2E 10 14 0B 13 1A 1A 3F 64 1D 71 33 57 21 09 24 8B 1B 09 37 08 61 0F 1D 1D 2A 01 87 35 4C 07 39 0B }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_101_Ashkbiz_Danehkar_h: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 E8 03 00 00 00 EB 01 ?? E8 86 00 00 00 E8 03 00 00 00 EB 01 ?? E8 79 00 00 00 E8 03 00 00 00 EB 01 ?? E8 A4 00 00 00 E8 03 00 00 00 EB 01 ?? E8 97 00 00 00 E8 03 00 00 00 EB 01 ?? E8 2D 00 00 00 E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule COMPACK_v51_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BD ?? ?? 50 06 8C CB 03 DD 8C D2 4B 8E DB BE ?? ?? BF ?? ?? 8E C2 B9 ?? ?? F3 A5 4A 4D 75 ?? 8B F7 8E DA 0E 07 06 16 }
    condition:
        $a at pe.entry_point

}

rule Upack_v032_Beta_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? ?? AD 91 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule Trap_v121_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5B 83 ?? ?? ?? 8B D3 E8 ?? ?? ?? 5B 2E ?? ?? ?? 74 ?? ?? ?? 8B DA B9 ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule OS2_Icon_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 43 49 4E 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEQuake_v006_by_fORGAT_additional: PEiD
{
    strings:
        $a = { E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? 00 00 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB }
    condition:
        $a at pe.entry_point

}

rule EPW_v12_additional: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E ?? ?? ?? ?? 8C C0 05 ?? ?? 2E ?? ?? ?? 8E D8 A1 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule PLINK86_1984_1985: PEiD
{
    strings:
        $a = { FA 8C C7 8C D6 8B CC BA ?? ?? 8E C2 26 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v201: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 08 02 41 00 68 04 9A 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule SEA_AXE: PEiD
{
    strings:
        $a = { FC BC ?? ?? 0E 1F E8 ?? ?? 26 A1 ?? ?? 8B 1E ?? ?? 2B C3 8E C0 B1 ?? D3 E3 }
    condition:
        $a at pe.entry_point

}

rule App_Encryptor_Silent_Team: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 1F 1F 40 00 B9 7B 09 00 00 8D BD 67 1F 40 00 8B F7 AC }
    condition:
        $a at pe.entry_point

}

rule Packanoid_v1_Arkanoid_: PEiD
{
    strings:
        $a = { BF ?? ?? ?? ?? BE ?? ?? ?? ?? E8 9D 00 00 00 B8 ?? ?? ?? ?? 8B 30 8B 78 04 BB ?? ?? ?? ?? 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_MASM32_TASM32_Microsoft_Visual_Basic: PEiD
{
    strings:
        $a = { F7 D8 0F BE C2 BE 80 ?? ?? 00 0F BE C9 BF 08 3B 65 07 EB 02 D8 29 BB EC C5 9A F8 EB 01 94 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v50v60_MFC_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 }
    condition:
        $a at pe.entry_point

}

rule A_program_by_Jupiter_additional: PEiD
{
    strings:
        $a = { 2B C0 74 05 68 ?? ?? ?? ?? 50 }
    condition:
        $a at pe.entry_point

}

rule ORiEN_211_212_Fisun_Alexander_additional: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F }
    condition:
        $a at pe.entry_point

}

rule Splash_Bitmap_v100_With_Unpack_Code_BoB_Bobsoft: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 8B 6C 24 20 55 81 ED ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 29 F9 31 C0 FC F3 AA 8B 04 24 48 66 25 00 F0 66 81 38 4D 5A 75 F4 8B 48 3C 81 3C 01 50 45 00 00 75 E8 89 85 ?? ?? ?? ?? 6A 40 }
    condition:
        $a at pe.entry_point

}

rule LSI_C_86_Run_Time_Libray_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E C0 06 17 BC ?? ?? 26 8C ?? ?? ?? B4 30 CD 21 26 A3 ?? ?? FC }
    condition:
        $a at pe.entry_point

}

rule EXEHigh_101: PEiD
{
    strings:
        $a = { 8C CA 8B 2E 01 00 8E DA 8C 06 90 06 8C DA 2B EA 8B 3E 94 06 81 FF 00 01 73 07 BF 00 01 89 3E 94 06 81 C7 DE 16 03 3E 92 06 B1 04 D3 EF 47 D3 E7 FA 8E D2 8B E7 FB E8 00 00 56 57 55 8B EC B4 4A 8E 06 90 06 BB FF FF CD 21 B4 4A 8E 06 90 06 CD }
    condition:
        $a at pe.entry_point

}

rule NextSun_Audio_file: PEiD
{
    strings:
        $a = { 2E 73 6E 64 }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_v10_Alex_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V121build0909_Method2_bagie_additional: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 86 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        $a at pe.entry_point

}

rule PCShrink_071_beta_additional: PEiD
{
    strings:
        $a = { 01 AD 54 3A 40 00 FF B5 50 3A 40 00 6A 40 FF 95 88 3A 40 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Caz1204_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 83 EE 03 1E 06 B8 FF FF CD 2F 3C 10 }
    condition:
        $a at pe.entry_point

}

rule RAZOR_1911_encruptor_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? BF ?? ?? 3B FC 72 ?? B4 4C CD 21 BE ?? ?? B9 ?? ?? FD F3 A5 FC }
    condition:
        $a at pe.entry_point

}

rule DJoin_v07_public_RC4_encryption_drmist_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_vxxxx: PEiD
{
    strings:
        $a = { E9 5D 01 ?? ?? CE D1 CE CE 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 }
        $b = { E8 47 19 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule LameCrypt_LaZaRus: PEiD
{
    strings:
        $a = { 60 66 9C BB 00 ?? ?? 00 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61 B8 ?? ?? 40 00 FF E0 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v200_alpha_38: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F }
        $b = { B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F 00 50 57 56 FF D1 58 03 43 08 8B F8 8B 53 14 8B F0 8B 46 FC 83 C0 04 2B F0 89 56 08 8B 4B 10 89 4E 18 FF D7 89 85 BB 10 00 10 5E 5A 5F 59 5B 5D 9D FF E0 8B 80 BB 10 00 10 FF E0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule JDProtectV2009Xdemo_20090503: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 53 68 65 6C 6C 33 32 2E 64 6C 6C 00 00 00 53 68 65 6C 6C 45 78 65 63 75 74 65 41 00 }
    condition:
        $a at pe.entry_point

}

rule Amiga_AIFF_8SFX_Audio_file: PEiD
{
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 38 53 56 58 56 48 44 52 }
    condition:
        $a at pe.entry_point

}

rule Minke_V101_Codius: PEiD
{
    strings:
        $a = { 26 3D 4F 38 C2 82 37 B8 F3 24 42 03 17 9B 3A 83 01 00 00 CC 00 00 00 00 06 00 00 00 01 64 53 74 75 62 00 10 55 54 79 70 65 73 00 00 C7 53 79 73 74 65 6D 00 00 81 53 79 73 49 6E 69 74 00 0C 4B 57 69 6E 64 6F 77 73 00 00 8A 75 46 75 6E 63 74 69 6F 6E 73 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_MS_Visual_Cpp_Borland_Cpp_Watcom_Cpp: PEiD
{
    strings:
        $a = { EB 02 C7 85 1E EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 02 CD }
    condition:
        $a at pe.entry_point

}

rule SoftDefender_1x_Randy_Li_additional: PEiD
{
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 E6 01 00 00 03 C8 74 BD 75 BB E8 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_dulekxt_Microsoft_Visual_Cpp_70: PEiD
{
    strings:
        $a = { EB 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_or_Borland_Cpp: PEiD
{
    strings:
        $a = { BA ?? ?? 2E 89 16 ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA }
    condition:
        $a at pe.entry_point

}

rule Password_Protector_c_MiniSoft_1992: PEiD
{
    strings:
        $a = { 06 0E 0E 07 1F E8 00 00 5B 83 EB 08 BA 27 01 03 D3 E8 3C 02 BA EA }
    condition:
        $a at pe.entry_point

}

rule VITec_graphics_file_format: PEiD
{
    strings:
        $a = { 00 5B 07 20 00 00 00 2C }
    condition:
        $a at pe.entry_point

}

rule Crunch_v40: PEiD
{
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 }
        $b = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 03 00 00 89 85 D9 41 00 00 68 EC 49 7B 79 33 C0 50 E8 11 03 00 00 89 85 D1 41 00 00 E8 67 05 00 00 E9 56 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 5B 8B C2 C1 C0 10 66 8B C1 5A 59 C3 68 03 02 00 00 E8 80 04 00 00 0F 82 A8 02 00 00 96 8B 44 24 04 0F C8 8B D0 25 0F 0F 0F 0F 33 D0 C1 C0 08 0B C2 8B D0 25 33 33 33 33 33 D0 C1 C0 04 0B C2 8B D0 25 55 55 55 55 33 D0 C1 C0 02 0B C2 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WWPACK_v305c4_Unextr_Passwcheck_Vir_shield_Hint_DOS_EP_4_: PEiD
{
    strings:
        $a = { 03 05 C0 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_3_Portions_Copyright_c_198397_Borland_h: PEiD
{
    strings:
        $a = { 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 37 20 42 6F 72 6C 61 6E 64 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_Spanz: PEiD
{
    strings:
        $a = { E8 00 00 5E 81 EE ?? ?? 8D 94 ?? ?? B4 1A CD 21 C7 84 }
    condition:
        $a at pe.entry_point

}

rule DxPack_10_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 8B D5 81 ED ?? ?? ?? ?? 2B 95 ?? ?? ?? ?? 81 EA 06 ?? ?? ?? 89 95 ?? ?? ?? ?? 83 BD 45 }
    condition:
        $a at pe.entry_point

}

rule Datafile_from_Norton_Utilities_Hint_FILE_START: PEiD
{
    strings:
        $a = { 50 4E 43 49 }
    condition:
        $a at pe.entry_point

}

rule IcebergLock_Protector_V310141_Iceberg_Software_Lab_20081209: PEiD
{
    strings:
        $a = { E8 D7 FF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B EC 83 C4 ?? B8 A8 ?? ?? ?? E8 94 EC FD FF E8 43 DE FF FF B8 58 ?? ?? ?? E8 71 FE FF FF E8 F4 CD FD FF }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_SVKP_13x_FEUERRADER_additional: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 00 00 00 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 }
    condition:
        $a at pe.entry_point

}

rule CrypKey_Kenonic_Controls: PEiD
{
    strings:
        $a = { 8B 1D ?? ?? 3E 00 83 FB 00 75 0A E8 3C 00 00 00 E8 ?? 0A 00 00 8B 44 24 08 50 E8 ?? 02 00 00 A1 ?? ?? 3E 00 83 F8 01 74 06 FF 25 14 ?? 3E 00 C3 C8 00 00 00 53 8B 5D 08 33 C0 8B 4D 0C 8B 13 33 D3 83 C3 04 03 C2 49 75 F4 5B C9 C3 56 68 ?? ?? 3E 00 E8 ?? 16 00 00 8B F0 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 }
    condition:
        $a at pe.entry_point

}

rule DSHIELD_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 E8 ?? ?? 5E 83 EE ?? 16 17 9C 58 B9 ?? ?? 25 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule TMT_Pascals_Unit_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 50 00 00 00 53 50 46 50 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V10E_vcasm_additional: PEiD
{
    strings:
        $a = { EB 0A 5B 56 50 72 6F 74 65 63 74 5D E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 74 F3 75 F1 EB 24 64 FF 35 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SLVc0deProtector_v06_SLV_additional: PEiD
{
    strings:
        $a = { E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 }
    condition:
        $a at pe.entry_point

}

rule Windows_or_OS2_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 42 4D }
    condition:
        $a at pe.entry_point

}

rule RLPack_V115_V116_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 83 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB 14 }
    condition:
        $a at pe.entry_point

}

rule AINEXE_v21: PEiD
{
    strings:
        $a = { A1 ?? ?? 2D ?? ?? 8E D0 BC ?? ?? 8C D8 36 A3 ?? ?? 05 ?? ?? 36 A3 ?? ?? 2E A1 ?? ?? 8A D4 B1 04 D2 EA FE C9 }
    condition:
        $a at pe.entry_point

}

rule ReversingLabsProtector_074_beta_Ap0x: PEiD
{
    strings:
        $a = { 68 00 00 41 00 E8 01 00 00 00 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule PE_Admin_10_EncryptPE_12003518_Sold_Flying_Cat: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 90 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22004810_V22005314_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Scrunch_102: PEiD
{
    strings:
        $a = { EB 13 73 43 65 66 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 BB FF FF B4 4A CD 21 81 EB F0 1F 73 18 BA 2B 01 B9 0F 00 E9 79 01 4F 75 74 20 6F 66 20 6D 65 6D 6F 72 79 2E 07 8C D8 A3 D2 02 05 00 10 A3 58 01 8E C0 E8 B4 01 B9 00 FF FC BE 00 }
    condition:
        $a at pe.entry_point

}

rule PEBundle_v310: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 00 87 DD ?? ?? ?? ?? 40 00 01 }
    condition:
        $a at pe.entry_point

}

rule EPW_v130_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 83 C0 10 2E }
    condition:
        $a at pe.entry_point

}

rule ATT_Group_4_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 01 00 ?? 00 3A 03 }
    condition:
        $a at pe.entry_point

}

rule Sharp_GPB_Graphics_format_additional: PEiD
{
    strings:
        $a = { 4D 00 00 00 00 ?? ?? ?? ?? 08 00 00 00 03 00 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v2xx_CopyMem_II_additional: PEiD
{
    strings:
        $a = { 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 89 65 ?? 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E ?? 89 0D ?? ?? ?? ?? 8B 46 ?? A3 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_32Lite_003_Anorganix: PEiD
{
    strings:
        $a = { 60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_v20_additional: PEiD
{
    strings:
        $a = { 83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 68 68 92 40 00 56 FF D3 E8 6A FF FF FF 85 C0 0F 84 59 01 00 00 BE 20 E4 42 00 56 FF 15 68 70 40 00 68 5C 92 40 00 56 E8 B9 28 00 00 57 FF 15 BC 70 40 00 BE 00 40 43 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 40 43 00 22 A3 20 EC 42 00 8B C6 75 0A C6 44 24 13 22 B8 01 40 43 00 8B 3D 18 72 40 00 EB 09 3A 4C 24 13 74 09 50 FF D7 8A 08 84 C9 75 F1 50 FF D7 8B F0 89 74 24 1C EB 05 56 FF D7 8B F0 80 3E 20 74 F6 80 3E 2F 75 44 46 80 3E 53 75 0C 8A 46 01 0C 20 3C 20 75 03 83 CD 02 81 3E 4E 43 52 }
    condition:
        $a at pe.entry_point

}

rule Ultra_Compressors_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 55 43 32 1A }
    condition:
        $a at pe.entry_point

}

rule LGLZ_v104_com_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BF ?? ?? 3B FC 72 19 B4 09 BA 12 01 CD 21 B4 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_1992_09_additional: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? C3 8C DF 8B 36 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule Goldeds_Output_text_file: PEiD
{
    strings:
        $a = { C4 20 5B }
    condition:
        $a at pe.entry_point

}

rule Wavelet_compressed_bitmap: PEiD
{
    strings:
        $a = { 57 49 }
    condition:
        $a at pe.entry_point

}

rule MinGW_GCC_2x_additional: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 FC 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 FC 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 18 41 40 00 89 EC 5D }
    condition:
        $a at pe.entry_point

}

rule Private_Exe_Protector_1x_setisoft: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? B9 ?? 90 01 ?? BE ?? 10 40 ?? 68 50 91 41 ?? 68 01 ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule SmartE_Microsoft: PEiD
{
    strings:
        $a = { EB 15 03 00 00 00 ?? 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 1D 00 00 00 8B C5 55 60 9C 2B 85 8F 07 00 00 89 85 83 07 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 2F 06 00 00 E8 8E 04 00 00 49 0F 88 23 06 }
    condition:
        $a at pe.entry_point

}

rule Program_Protector_XP_v10: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 58 83 D8 05 89 C3 81 C3 ?? ?? ?? ?? 8B 43 64 50 }
    condition:
        $a at pe.entry_point

}

rule Img_Software_Set_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 53 43 4D 49 20 20 20 31 41 54 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v134_v140b1: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A6 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 ?? 00 80 ?? 40 90 90 01 85 9E 80 ?? 40 BB F8 10 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v260b1: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 50 ?? ?? ?? 68 74 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 FC }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v260b2: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 90 ?? ?? ?? 68 24 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 60 ?? ?? ?? 33 D2 8A D4 89 15 3C }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_nSPack_13_emadicius_h: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_50_60_additional: PEiD
{
    strings:
        $a = { 8D 50 12 2B C9 B1 1E 8A 02 34 77 88 02 42 E2 F7 C8 8C }
    condition:
        $a at pe.entry_point

}

rule InstallShield_3x_Custom: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 00 A0 40 00 68 34 76 40 00 50 64 89 25 00 00 00 00 83 EC 60 53 56 57 89 65 E8 FF 15 8C E3 40 00 A3 70 B1 40 00 33 C0 A0 71 B1 40 00 A3 7C B1 40 00 A1 70 B1 }
    condition:
        $a at pe.entry_point

}

rule UPolyx_05_by_delikon: PEiD
{
    strings:
        $a = { 51 ?? C9 B9 ?? ?? ?? ?? 83 ?? 01 E2 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V22X_V2308_Jitit_Sign_by_fly_additional: PEiD
{
    strings:
        $a = { B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        $a at pe.entry_point

}

rule GameGuard_v20065xx_exe_additional: PEiD
{
    strings:
        $a = { 31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE 00 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_12_Beta_Demo_SIS_Team_additional: PEiD
{
    strings:
        $a = { 68 69 D6 00 00 E8 C6 FD FF FF 68 69 D6 00 00 E8 BC FD FF FF 83 C4 08 E8 A4 FF FF FF 84 C0 74 2F 68 04 01 00 00 68 B0 21 60 00 6A 00 FF 15 08 10 60 00 E8 29 FF FF FF 50 68 88 10 60 00 68 78 10 60 00 68 B0 21 60 00 E8 A4 FD FF FF 83 C4 10 33 C0 C2 10 00 90 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Prolog_1986: PEiD
{
    strings:
        $a = { FA B8 00 00 8E D8 B8 00 00 A3 00 00 8E D0 BC 00 01 FB 8C 06 00 00 26 8E 06 2C 00 8C 06 00 00 B8 00 00 A3 00 00 9A 00 00 00 00 89 1E 00 00 A3 00 00 9A 00 00 00 00 00 00 9A 00 00 00 00 83 C4 04 00 00 00 00 00 00 00 00 00 00 00 00 9A 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule pscrambler_12_by_p0ke: PEiD
{
    strings:
        $a = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 ?? ?? ?? ?? 10 E8 2D F3 FF FF 33 C0 55 68 E8 31 00 10 64 FF 30 64 89 20 8D 45 E0 E8 53 F5 FF FF 8B 45 E0 8D 55 E4 E8 30 F6 FF FF 8B 45 E4 8D 55 E8 E8 A9 F4 FF FF 8B 45 E8 8D 55 EC E8 EE F7 FF FF 8B 55 EC B8 C4 54 00 10 E8 D9 EC FF FF 83 3D C4 54 00 10 00 0F 84 05 01 00 00 80 3D A0 40 00 10 00 74 41 A1 C4 54 00 10 E8 D9 ED FF FF E8 48 E0 FF FF 8B D8 A1 C4 54 00 10 E8 C8 ED FF FF 50 B8 C4 54 00 10 E8 65 EF FF FF 8B D3 59 E8 69 E1 FF FF 8B C3 E8 12 FA FF FF 8B C3 E8 33 E0 FF FF E9 AD 00 00 00 B8 05 01 00 00 E8 0C E0 FF FF 8B D8 53 68 05 01 00 00 E8 57 F3 FF FF 8D 45 DC 8B D3 E8 39 ED FF FF 8B 55 DC B8 14 56 00 10 B9 00 32 00 10 E8 BB ED FF FF 8B 15 14 56 00 10 B8 C8 54 00 10 E8 53 E5 FF FF BA 01 00 00 00 B8 C8 54 00 10 E8 8C E8 FF FF E8 DF E0 FF FF 85 C0 75 52 6A 00 A1 C4 54 00 10 E8 3B ED FF FF 50 B8 C4 54 00 10 E8 D8 EE FF FF 8B D0 B8 C8 54 00 10 59 E8 3B E6 FF FF E8 76 E0 FF FF B8 C8 54 00 10 E8 4C E6 FF FF E8 67 E0 FF FF 6A 00 6A 00 6A 00 A1 14 56 00 10 E8 53 EE FF FF 50 6A 00 6A 00 E8 41 F3 FF FF 80 3D 9C 40 00 10 00 74 05 E8 EF FB FF FF 33 C0 5A 59 59 64 89 10 68 EF 31 00 10 8D 45 DC BA 05 00 00 00 E8 7D EB FF FF C3 E9 23 E9 FF FF EB EB 5B E8 63 EA FF FF 00 00 00 FF FF FF FF 08 00 00 00 74 65 6D 70 2E 65 78 65 }
        $b = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 ?? ?? ?? ?? 10 E8 2D F3 FF FF 33 C0 55 68 E8 31 00 10 64 FF 30 64 89 20 8D 45 E0 E8 53 F5 FF FF 8B 45 E0 8D 55 E4 E8 30 F6 FF FF 8B 45 E4 8D 55 E8 E8 A9 F4 FF FF 8B 45 E8 8D 55 EC E8 EE F7 FF FF 8B 55 EC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Solidshield_Protector_V1X_DLL_Solidshield_Technologies_SignByfly_additional: PEiD
{
    strings:
        $a = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF }
    condition:
        $a at pe.entry_point

}

rule Armadillo_410_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 D0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 7C A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 78 A5 4C 00 C1 E1 08 03 CA 89 0D 74 A5 4C 00 C1 E8 10 A3 70 A5 }
    condition:
        $a at pe.entry_point

}

rule Cracked_by_AutoHack_1: PEiD
{
    strings:
        $a = { FA 50 51 57 56 1E 06 2E 80 3E ?? ?? ?? 74 ?? 8E 06 ?? ?? 2B FF FC }
    condition:
        $a at pe.entry_point

}

rule SecurePE_V1X_wwwdeepzoneorg: PEiD
{
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3 }
    condition:
        $a at pe.entry_point

}

rule Vprotect_V17X_187_CoooLie: PEiD
{
    strings:
        $a = { 58 89 03 8B 07 8B 5F 0C 8B 4F 04 8B 57 08 8B 6F 14 8B 77 18 FF 77 24 9D 8B 67 10 C7 47 50 00 00 00 00 8B 7F 1C C3 }
    condition:
        $a at pe.entry_point

}

rule VPacker_ttui_additional: PEiD
{
    strings:
        $a = { 89 C6 C7 45 E0 01 00 00 00 F7 03 00 00 FF FF 75 18 0F B7 03 50 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 EB 13 53 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 83 C7 04 FF 45 E0 4E 75 C4 8B F3 83 3E 00 75 88 8B 45 E4 8B 40 10 03 45 DC 8B 55 14 83 C2 20 89 02 68 00 80 00 00 6A 00 8B 45 D4 50 FF 55 EC 8B 55 DC 8B 42 3C 03 45 DC 83 C0 04 8B D8 83 C3 14 8D 45 E0 50 6A 40 68 00 10 00 00 52 FF 55 E8 8D 43 60 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_V2X_DLL_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 ?? ?? 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ?? ?? ?? ?? 03 DD }
    condition:
        $a at pe.entry_point

}

rule PrincessSandy_v10_eMiNENCE_Process_Patcher_Patch: PEiD
{
    strings:
        $a = { 68 27 11 40 00 E8 3C 01 00 00 6A 00 E8 41 01 00 00 A3 00 20 40 00 8B 58 3C 03 D8 0F B7 43 14 0F B7 4B 06 8D 7C 18 18 81 3F 2E 4C 4F 41 74 0B 83 C7 28 49 75 F2 E9 A7 00 00 00 8B 5F 0C 03 1D 00 20 40 00 89 1D 04 20 40 00 8B FB 83 C7 04 68 4C 20 40 00 68 08 }
        $b = { 68 27 11 40 00 E8 3C 01 00 00 6A 00 E8 41 01 00 00 A3 00 20 40 00 8B 58 3C 03 D8 0F B7 43 14 0F B7 4B 06 8D 7C 18 18 81 3F 2E 4C 4F 41 74 0B 83 C7 28 49 75 F2 E9 A7 00 00 00 8B 5F 0C 03 1D 00 20 40 00 89 1D 04 20 40 00 8B FB 83 C7 04 68 4C 20 40 00 68 08 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 57 6A 00 E8 CE 00 00 00 85 C0 74 78 BD 50 C3 00 00 8B 3D 04 20 40 00 8B 07 8D 3C 07 83 C7 04 89 3D 04 20 40 00 8B 0F 83 C7 04 8B 1F 83 C7 04 4D 85 ED 74 57 60 6A 00 51 68 5C 20 40 00 53 FF 35 4C 20 40 00 E8 93 00 00 00 85 C0 61 74 E1 8B C1 60 BE 5C 20 40 00 F3 A6 74 03 61 EB D2 60 6A 00 50 57 53 FF 35 4C 20 40 00 E8 7A 00 00 00 85 C0 74 20 61 83 3C 07 00 74 2D 03 F8 EB A8 B8 5E 21 40 00 EB 13 B8 7C 21 40 00 EB 0C B8 9E 21 40 00 EB 05 B8 CF 21 40 00 6A 00 68 56 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Intel_DCX_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { B1 68 DE 3A 04 10 00 }
    condition:
        $a at pe.entry_point

}

rule FakeNinja_V28_Private_Spirit: PEiD
{
    strings:
        $a = { 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 17 E5 FF 60 }
    condition:
        $a at pe.entry_point

}

rule Video_CD_file: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 44 58 41 66 6D 74 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8 ?? ?? FB FF A1 ?? ?? ?? ?? 8B ?? E8 ?? ?? FF FF 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? E8 ?? ?? FF FF A1 ?? ?? ?? ?? 8B ?? E8 ?? ?? FF FF E8 ?? ?? FB FF 8D 40 }
    condition:
        $a at pe.entry_point

}

rule ProPack_214_m1_COM: PEiD
{
    strings:
        $a = { 83 EC 10 8B EC BE FA 02 FC E8 41 00 05 00 01 8B C8 E8 39 00 8B D0 03 C6 05 06 00 8B F8 E8 2D 00 AD 88 66 0A 32 E4 89 76 00 8B F7 03 C1 8B F8 3B FE 76 0E }
    condition:
        $a at pe.entry_point

}

rule ASPack_v108_additional: PEiD
{
    strings:
        $a = { 90 75 01 FF E9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_50_DLL: PEiD
{
    strings:
        $a = { ?? ?? 24 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 8B ?? 24 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule ASPack_102a_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 3E D9 43 00 B8 38 ?? ?? 00 03 C5 2B 85 0B DE 43 00 89 85 17 DE 43 00 80 BD 01 DE 43 00 00 75 15 FE 85 01 DE 43 00 E8 1D 00 00 00 E8 79 02 00 00 E8 12 03 00 00 8B 85 03 DE 43 00 03 85 17 DE 43 00 89 44 24 1C 61 FF }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v132: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 }
    condition:
        $a at pe.entry_point

}

rule Upack_v039_final_Dwing: PEiD
{
    strings:
        $a = { 56 10 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 }
        $b = { FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WebCops_EXE_LINK_Data_Security: PEiD
{
    strings:
        $a = { EB 03 05 EB 02 EB FC 55 EB 03 EB 04 05 EB FB EB 53 E8 04 00 00 00 72 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60_Debug_Version_additional: PEiD
{
    strings:
        $a = { 55 8B EC 51 ?? ?? ?? 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule TElock_v098b1_Modifly_by_forgothexer: PEiD
{
    strings:
        $a = { 9C 6A 03 73 0B EB 02 75 75 }
    condition:
        $a at pe.entry_point

}

rule VMware_ThinApp_VV339600_VMware_20090124: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB C1 20 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 2E 00 00 68 28 01 00 00 E8 2C FF FF FF E9 ?? FF FF FF CC CC CC CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V3X_V6X_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 60 33 C9 75 02 EB 15 EB 33 }
    condition:
        $a at pe.entry_point

}

rule RLPack_Full_Edition_117_LZMA_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 73 26 00 00 8D 9D 58 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v10061: PEiD
{
    strings:
        $a = { E8 47 }
        $b = { E8 AF 1C 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SimplePack_111_Method_1_bagieTMX_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B FA BD 00 00 ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0 74 55 0F B7 47 22 09 C0 74 4D 6A 04 68 00 10 00 00 FF 77 10 6A 00 FF 93 38 03 00 00 50 56 57 89 EE 03 77 0C 8B 4F 10 89 C7 89 C8 C1 E9 02 FC }
    condition:
        $a at pe.entry_point

}

rule PESpin_v07_Cyberbob_h_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 88 39 40 00 8B 42 3C 03 C2 89 85 92 39 40 00 EB 01 DB 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D A6 39 40 00 53 8F 85 4A 38 40 00 BB ?? 00 00 00 B9 EC 0A 00 00 8D BD 36 3A 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 56 44 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 B3 5F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D 99 39 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ACProtectUltraProtect_V10X_V20X_RiSco: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00 }
    condition:
        $a at pe.entry_point

}

rule aPack_096: PEiD
{
    strings:
        $a = { BE 0D 01 BF 00 70 8B CF FC 57 F3 A4 C3 BF 00 01 57 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2312_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { 6A 00 FF 15 ?? ?? ?? ?? E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule Maked_by_Grabber_v384_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? FC 8C DB 8C C8 8E D8 8E C0 89 1E ?? ?? E8 ?? ?? E8 ?? ?? E8 ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v70_additional: PEiD
{
    strings:
        $a = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 59 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_CracKed_By_shoooo_fly_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 C5 FA 81 }
    condition:
        $a at pe.entry_point

}

rule Unknown_encryptor_2_PK7Tjrvx_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 B4 52 CD 21 07 E8 ?? ?? B4 62 CD 21 E8 }
    condition:
        $a at pe.entry_point

}

rule vprotector_12_vcasm_h: PEiD
{
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D 00 E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 74 F3 75 F1 EB 24 64 FF 35 00 00 00 00 EB 12 FF 9C 74 03 75 01 E9 81 0C 24 00 01 00 00 9D 90 EB F4 64 89 25 00 00 00 00 EB E6 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 58 EB 13 C7 83 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 AD CD 20 E8 05 00 00 00 0F 01 EB 05 E8 EB FB 00 00 83 C4 04 E8 08 00 00 00 0F 01 83 C0 }
    condition:
        $a at pe.entry_point

}

rule Naked_Packer_V10_BigBoote_additional: PEiD
{
    strings:
        $a = { 60 FC 0F B6 05 ?? ?? ?? ?? 85 C0 75 31 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9A 00 00 00 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 83 3D ?? ?? ?? ?? 00 75 07 61 FF 25 ?? ?? ?? ?? 61 FF 74 24 04 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C3 FF 74 24 04 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v20_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D }
    condition:
        $a at pe.entry_point

}

rule Visual_Cpp_50: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 00 00 00 68 00 00 00 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 C4 00 53 56 57 89 65 E8 FF 15 }
    condition:
        $a at pe.entry_point

}

rule MacPaint_Graphics_format: PEiD
{
    strings:
        $a = { 00 00 00 02 FF FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v2xx_CopyMem_II: PEiD
{
    strings:
        $a = { 6A ?? 8B B5 ?? ?? ?? ?? C1 E6 04 8B 85 ?? ?? ?? ?? 25 07 ?? ?? 80 79 05 48 83 C8 F8 40 33 C9 8A 88 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 81 E2 07 ?? ?? 80 79 05 4A 83 CA F8 42 33 C0 8A 82 }
    condition:
        $a at pe.entry_point

}

rule Vx_Hymn1865: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 83 EE 4C FC 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 ?? ?? ?? FB 3B ?? ?? ?? ?? ?? 2E ?? ?? ?? ?? ?? 50 06 56 1E 0E 1F B8 00 C5 CD 21 }
    condition:
        $a at pe.entry_point

}

rule CrypKey_V56X_DLL_Kenonic_Controls_Ltd: PEiD
{
    strings:
        $a = { 8B 1D ?? ?? ?? ?? 83 FB 00 75 0A E8 ?? ?? ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule Packanoid_Arkanoid_additional: PEiD
{
    strings:
        $a = { BF 00 10 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8 }
    condition:
        $a at pe.entry_point

}

rule Inset_Systems_IGF_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 01 80 04 00 01 00 58 00 }
    condition:
        $a at pe.entry_point

}

rule NsPack_14_by_North_Star_Liu_Xing_Ping_: PEiD
{
    strings:
        $a = { 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v12_CGSoftLabs: PEiD
{
    strings:
        $a = { 45 78 50 72 2D 76 2E 31 2E 32 2E }
        $b = { 55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? ?? 2B 05 84 ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 03 05 80 ?? ?? ?? 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 68 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Anti007_V25_V26_LiuXingPing_SignByfly: PEiD
{
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 57 72 69 74 65 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 }
    condition:
        $a at pe.entry_point

}

rule Visual_Cpp_2005_DLL_Microsoft: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 83 7D 0C 01 }
    condition:
        $a at pe.entry_point

}

rule PECompact_09781: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 49 87 40 00 87 DD 8B 85 CE 87 40 00 01 85 3D 87 40 00 66 C7 85 3A 87 40 00 90 90 BB A6 09 00 00 03 9D D2 87 40 00 03 9D CE 87 40 00 53 53 53 58 2D A4 }
    condition:
        $a at pe.entry_point

}

rule PECompact_09784: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB D1 84 40 00 87 DD 8B 85 56 85 40 00 01 85 C5 84 40 00 66 C7 85 C2 84 40 00 90 90 BB A6 09 00 00 03 9D 5A 85 40 00 03 9D 56 85 40 00 53 53 53 58 2D 2C }
    condition:
        $a at pe.entry_point

}

rule Micrografix_Draw_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 01 FF 02 04 03 02 00 02 }
    condition:
        $a at pe.entry_point

}

rule ASPR_Stripper_v2x_unpacked: PEiD
{
    strings:
        $a = { BB ?? ?? ?? ?? E9 ?? ?? ?? ?? 60 9C FC BF ?? ?? ?? ?? B9 ?? ?? ?? ?? F3 AA 9D 61 C3 55 8B EC }
    condition:
        $a at pe.entry_point

}

rule tElock_099_Special_Build_heXer_forgot: PEiD
{
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule AIN_Archive_Hint_FILE_START_additional: PEiD
{
    strings:
        $a = { 21 12 00 }
    condition:
        $a at pe.entry_point

}

rule ORiEN_V212_Fisun_AV: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE CD 0D }
    condition:
        $a at pe.entry_point

}

rule Armadillo_4000053_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 20 8B 4B 00 68 80 E4 48 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4B 00 33 D2 8A D4 89 15 A4 A1 4B 00 8B C8 81 E1 FF 00 00 00 89 0D A0 A1 4B 00 C1 E1 08 03 CA 89 0D 9C A1 4B 00 C1 E8 10 A3 98 A1 }
    condition:
        $a at pe.entry_point

}

rule Vx_Doom666_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? 5E 83 EE ?? B8 CF 7B CD 21 3D CF 7B ?? ?? 0E 1F 81 C6 ?? ?? BF ?? ?? B9 ?? ?? FC F3 A4 06 1F 06 B8 ?? ?? 50 CB B4 48 BB 2C 00 CD 21 }
    condition:
        $a at pe.entry_point

}

rule FSG_v13: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 }
        $b = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? ?? 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE ?? 74 EF FE }
        $c = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? ?? 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_v12: PEiD
{
    strings:
        $a = { 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v11: PEiD
{
    strings:
        $a = { BB D0 01 40 ?? BF ?? 10 40 ?? BE ?? ?? ?? ?? FC B2 80 8A 06 46 88 07 47 02 D2 75 05 8A 16 }
    condition:
        $a at pe.entry_point

}

rule FSG_v10: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B }
    condition:
        $a at pe.entry_point

}

rule MinGW_32x_WinMain: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 FC 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 FC 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 18 41 40 00 89 EC 5D }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_yodas_cryptor_12_emadicius: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 AC 90 2C 8A C0 C0 78 90 04 62 EB 01 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule GP_Install_v50332: PEiD
{
    strings:
        $a = { 55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 57 B8 C4 1C 41 00 E8 6B 3E FF FF 33 C0 55 68 76 20 41 00 64 FF 30 64 89 20 BA A0 47 41 00 33 C0 E8 31 0A FF FF 33 D2 A1 A0 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v147_v150: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 5B 12 }
    condition:
        $a at pe.entry_point

}

rule Inno_Setup_Module_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 ?? 53 56 57 33 C0 89 45 F0 89 45 ?? 89 45 ?? E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF }
    condition:
        $a at pe.entry_point

}

rule ZealPack_10_Zeal_additional: PEiD
{
    strings:
        $a = { C7 45 F4 00 00 40 00 C7 45 F0 ?? ?? ?? ?? 8B 45 F4 05 ?? ?? ?? ?? 89 45 F4 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 55 F0 7D 22 8B 45 F4 03 45 FC 8A 08 88 4D F8 0F BE 55 F8 83 F2 0F 88 55 F8 8B 45 F4 03 45 FC 8A 4D F8 88 08 EB CD }
    condition:
        $a at pe.entry_point

}

rule VProtect2060702Cloud_CoooLie: PEiD
{
    strings:
        $a = { 66 8B C9 8D 89 F9 FF FF FF 8A D2 8D 89 07 00 00 00 66 53 8B C9 66 5B 9C 9D 8B 67 28 8D AD FF FF FF FF 66 F7 D1 9C 9D 66 F7 D1 8D AD 01 00 00 00 61 52 5A 9D 66 51 66 87 CD 66 87 CD 66 59 C3 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V01_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F 85 ?? ?? ?? ?? BB ?? ?? ?? ?? B9 A5 08 00 00 8D ?? ?? ?? ?? ?? 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Netsend_100: PEiD
{
    strings:
        $a = { 58 50 50 50 59 5A 49 51 44 5B 4C 2D 66 36 2D 67 34 31 47 44 53 58 75 27 40 2C 7E 50 5E 50 5F 4F 2C 21 28 47 55 28 47 5A 28 47 6E 75 35 2D 4E 45 54 53 45 4E 44 5F 56 31 2E 30 30 5F 4A 52 54 3D 0D 0A 43 46 46 46 52 58 2C 60 2C 60 32 24 46 3D }
    condition:
        $a at pe.entry_point

}

rule EXE_yy66: PEiD
{
    strings:
        $a = { 68 78 18 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 }
    condition:
        $a at pe.entry_point

}

rule WARNING_TROJAN_HuiGeZi_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 C4 ?? FE FF FF 53 56 57 33 C0 89 85 ?? FE FF FF }
    condition:
        $a at pe.entry_point

}

rule KGCrypt_vxx_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 5B 83 EB 05 EB 04 52 4E 44 21 EB 02 CD 20 EB }
    condition:
        $a at pe.entry_point

}

rule PackWin_10_202: PEiD
{
    strings:
        $a = { 8C C0 FA 8E D0 BC FE 00 FB 06 0E 1F 2E 8B 0E 0C 00 8B F1 4E 8B FE 8C DB 2E 03 1E 0A 00 8E C3 FD F3 A4 53 B8 38 00 50 CB 2E 8B 2E 08 00 8C DA 8B C5 3D 00 10 76 03 B8 00 10 2B E8 2B D0 2B D8 8E DA 8E C3 B1 03 D3 E0 8B C8 D1 E0 48 48 8B F0 8B }
    condition:
        $a at pe.entry_point

}

rule PKLITE32_11: PEiD
{
    strings:
        $a = { 50 4B 4C 49 54 45 33 32 20 43 6F 70 79 72 69 67 68 74 20 31 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v106b_additional: PEiD
{
    strings:
        $a = { 90 61 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v200b2_200b3: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 F2 40 00 68 C4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_v50_Unit: PEiD
{
    strings:
        $a = { 54 50 55 35 00 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V10_Build_20041213_test_vcasm: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1A 89 40 00 68 56 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 }
    condition:
        $a at pe.entry_point

}

rule SecuROM_V7X_Sony_DADC_SignByfly_20080114: PEiD
{
    strings:
        $a = { 9C 9C 83 EC 1C C7 44 24 18 ?? ?? ?? ?? C7 44 24 14 BF 03 01 00 89 74 24 10 BE F0 ?? ?? ?? C1 4C 24 18 18 ?? 89 6C 24 0C 8B 2E 01 6C 24 18 ?? 83 C6 04 66 FF 4C 24 14 52 5A 75 ED 80 64 24 18 FE ?? 8B 74 24 1C C1 E1 00 8B 6C 24 18 89 74 24 18 8B 74 24 10 89 6C 24 1C C1 E2 00 8B 6C 24 0C 83 C4 18 9D ?? 74 12 81 04 24 ?? ?? ?? ?? ?? 81 04 24 C3 D1 FF 00 EB FA 6B 81 04 24 ?? ?? ?? ?? 0F AC F8 00 81 04 24 C2 04 00 3E FF 74 24 04 9D EB F5 EE 93 9D }
        $b = { 9C 9C 83 EC 1C C7 44 24 18 ?? ?? ?? ?? C7 44 24 14 BF 03 01 00 89 74 24 10 BE F0 ?? ?? ?? C1 4C 24 18 18 ?? 89 6C 24 0C 8B 2E 01 6C 24 18 ?? 83 C6 04 66 FF 4C 24 14 52 5A 75 ED 80 64 24 18 FE ?? 8B 74 24 1C C1 E1 00 8B 6C 24 18 89 74 24 18 8B 74 24 10 89 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MEW_11_SE_v11: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MEW_11_SE_v12: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vprotect_V202_V203_CoooLie: PEiD
{
    strings:
        $a = { 66 F7 D7 66 50 66 58 66 F7 D7 9C 9D 8B 67 28 57 66 8B DB 5F 61 8D AD F4 FF FF FF 8D AD 0C 00 00 00 66 57 66 5F 8B FF 9D 9C 8D 80 F0 FF FF FF 8D 80 10 00 00 00 9D 66 F7 D2 66 F7 D2 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_for_Win16_1991: PEiD
{
    strings:
        $a = { 9A FF FF 00 00 0B C0 75 ?? E9 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? B8 FF FF 50 9A FF FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule TurboBAT_v310_50: PEiD
{
    strings:
        $a = { BA ?? ?? B4 09 ?? ?? 06 B8 ?? ?? 8E C0 B9 ?? ?? 26 ?? ?? ?? ?? 80 ?? ?? 26 ?? ?? ?? 24 0F 3A C4 ?? ?? 26 ?? ?? ?? 24 0F 3A C4 }
    condition:
        $a at pe.entry_point

}

rule BopCrypt_v10: PEiD
{
    strings:
        $a = { 60 BD ?? ?? ?? ?? E8 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule Special_EXE_Password_Protector_10_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E 77 }
    condition:
        $a at pe.entry_point

}

rule Setup_Factory_6x_Custom_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 90 61 40 00 68 70 3B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 14 61 40 00 33 D2 8A D4 89 15 5C 89 40 00 8B C8 81 E1 FF 00 00 00 89 0D 58 89 40 00 C1 E1 08 03 CA 89 0D 54 89 40 00 C1 E8 10 A3 50 89 }
    condition:
        $a at pe.entry_point

}

rule Exe_Guarder_v18_Exeiconcom: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 }
        $b = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 5D EC 8B 41 18 8B C8 49 85 C9 72 5A 41 33 C0 8B D8 C1 E3 02 03 DA 8B 3B 03 3E 81 3F 47 65 74 50 75 40 8B DF 83 C3 04 81 3B 72 6F 63 41 75 33 8B DF 83 C3 08 81 3B 64 64 72 65 75 26 83 C7 0C 66 81 3F 73 73 75 1C 8B D0 03 D2 03 55 F0 0F B7 12 C1 E2 02 03 55 EC 8B 12 03 16 8B 4D F4 89 51 08 EB 04 40 49 75 A9 8B 5D F4 8D 83 A1 00 00 00 50 8B 06 50 FF 53 08 89 43 0C 8D 83 AE 00 00 00 50 8B 06 50 FF 53 08 89 43 10 8D 83 BA 00 00 00 50 8B 06 50 FF 53 08 89 43 14 8D 83 C6 00 00 00 50 8B 06 50 FF 53 08 89 43 18 8D 83 D7 00 00 00 50 8B 06 50 FF 53 08 89 43 1C 8D 83 E0 00 00 00 50 8B 06 50 FF 53 08 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MASM_TASM_additional: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 42 30 40 ?? FF 95 32 35 40 ?? B8 37 30 40 ?? 03 C5 2B 85 1B 34 40 ?? 89 85 27 34 40 ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Lattice_C_v30_additional: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 8E D8 B8 ?? ?? 8E }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_VBOX_43_MTE: PEiD
{
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 E9 }
    condition:
        $a at pe.entry_point

}

rule dUP2_diablo2oo2: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75 19 BE ?? ?? ?? ?? 68 00 02 00 00 56 68 }
        $b = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_Borland_Delphi_60_70_Anorganix_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 53 8B D8 33 C0 A3 09 09 09 00 6A 00 E8 09 09 00 FF A3 09 09 09 00 A1 09 09 09 00 A3 09 09 09 00 33 C0 A3 09 09 09 00 33 C0 A3 09 09 09 00 E8 }
    condition:
        $a at pe.entry_point

}

rule CRYPT_Version_17_c_Dismember_EXE_additional: PEiD
{
    strings:
        $a = { 0E 17 9C 58 F6 ?? ?? 74 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule IBM_PictureMaker_graphics_file: PEiD
{
    strings:
        $a = { 00 ?? C1 ?? 00 ?? ?? ?? ?? 02 00 01 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_v13x_Eng_Pavol_Cerven_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Stelth_PE_101_Anorganix_additional: PEiD
{
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 BA ?? ?? ?? ?? FF E2 BA E0 10 40 00 B8 68 24 1A 40 89 02 83 C2 03 B8 40 00 E8 EE 89 02 83 C2 FD FF E2 2D 3D 5B 20 48 69 64 65 50 45 20 5D 3D 2D 90 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule vprotector_12_vcasm: PEiD
{
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D 00 E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 74 F3 75 F1 EB 24 64 FF 35 00 00 00 00 EB 12 FF 9C 74 03 75 01 E9 81 0C 24 00 01 00 00 9D 90 EB F4 64 89 25 00 }
    condition:
        $a at pe.entry_point

}

rule Protect_Shareware_V11_eCompserv_CMS_additional: PEiD
{
    strings:
        $a = { 53 00 74 00 72 00 69 00 6E 00 67 00 46 00 69 00 6C 00 65 00 49 00 6E 00 66 00 6F 00 00 00 ?? 01 00 00 01 00 30 00 34 00 30 00 39 00 30 00 34 00 42 00 30 00 00 00 34 00 ?? 00 01 00 43 00 6F 00 6D 00 70 00 61 00 6E 00 79 00 4E 00 61 00 6D 00 65 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Petite_13_additional: PEiD
{
    strings:
        $a = { 9C 60 50 8D 88 00 ?? ?? ?? 8D 90 ?? ?? 00 00 8B DC 8B E1 68 00 00 ?? ?? 53 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 DA 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_1401_SoftComplete_Development: PEiD
{
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80 }
    condition:
        $a at pe.entry_point

}

rule Vx_Compiler: PEiD
{
    strings:
        $a = { 8C C3 83 C3 10 2E 01 1E ?? 02 2E 03 1E ?? 02 53 1E }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_UPX_06_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 00 00 00 FF 57 8D B0 E8 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Yodas_Protector_102_Anorganix: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 90 90 E9 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_13013_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 02 ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 02 ?? ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 03 ?? ?? ?? E8 13 26 00 00 }
    condition:
        $a at pe.entry_point

}

rule XPack_167_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 8C D3 15 33 75 81 3E E8 0F 00 9A E8 F9 FF 9A 9C EB 01 9A 59 80 CD 01 51 9D EB }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v200b2_200b3_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 F2 40 00 68 C4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_Small_build_035_GlOFF: PEiD
{
    strings:
        $a = { 51 33 CB 86 C9 59 E8 9E FD FF FF 66 87 DB 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 51 33 CB 86 C9 59 E8 9E FD FF FF 66 87 DB 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Borland_Delphi_vxx_Component_additional: PEiD
{
    strings:
        $a = { C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6 EB 02 56 7B 2A D3 E8 01 00 00 00 ED 58 88 16 13 C3 46 EB 02 CD 20 4B EB 02 CD 20 2B C9 3B D9 75 A1 E8 02 00 00 00 D7 6B 58 EB 00 9E 96 6A 28 67 AB 69 54 03 3E 7F ?? ?? ?? 31 0D 63 44 35 38 37 18 87 9F 10 8C 37 C6 41 80 4C 5E 8B DB 60 4C 3A 28 08 30 BF 93 05 D1 58 13 2D B8 86 AE C8 58 16 A6 95 C5 94 03 33 6F FF 92 20 98 87 9C E5 B9 20 B5 68 DE 16 4A 15 C1 7F 72 71 65 3E A9 85 20 AF 5A 59 54 26 66 E9 3F 27 DE 8E 7D 34 53 61 F7 AF 09 29 5C F7 36 83 60 5F 52 92 5C D0 56 55 C9 61 7A FD EF 7E E8 70 F8 6E 7B EF }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V36_LiuXingPing: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D ?? ?? ?? ?? ?? 83 38 01 0F 84 47 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_v0896_v102_v105_v122: PEiD
{
    strings:
        $a = { 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 8A 07 72 EB B8 01 ?? ?? ?? 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 }
        $b = { 80 7C 24 08 01 0F 85 ?? ?? ?? 00 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule eXPressor_v1501_Options_Light_Full_support_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? 02 00 00 53 56 57 83 A5 ?? FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 }
    condition:
        $a at pe.entry_point

}

rule ESO_Eclipse_Operating_System_v208_p_DOS_Extender_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8C C8 8E D8 BA ?? ?? E8 ?? ?? BB ?? ?? 8C C0 2B D8 B4 4A CD 21 BA ?? ?? 73 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule PE_Protector_093_CRYPToCRACk_additional: PEiD
{
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 }
    condition:
        $a at pe.entry_point

}

rule COM2EXE: PEiD
{
    strings:
        $a = { F0 FF FE FF }
    condition:
        $a at pe.entry_point

}

rule Alloy_4x_PGWare_LLC: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 6A 04 68 00 10 00 00 68 00 02 00 00 6A 00 FF 95 A8 33 40 00 0B C0 0F 84 F6 01 00 00 89 85 2E 33 40 00 83 BD E8 32 40 00 01 74 0D 83 BD E4 32 40 00 01 74 2A 8B F8 EB 3E 68 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v_If_you_know_this_version_post_on_PEiD_board_h2_additional: PEiD
{
    strings:
        $a = { 33 C0 E9 ?? ?? FF FF ?? 1C ?? ?? 40 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_V2021_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF ?? 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule JExeCompressor_10_by_Arash_Veyskarami_additional: PEiD
{
    strings:
        $a = { 8D 2D D3 4A E5 14 0F BB F7 0F BA E5 73 0F AF D5 8D 0D 0C 9F E6 11 C0 F8 EF F6 DE 80 DC 5B F6 DA 0F A5 C1 0F C1 F1 1C F3 4A 81 E1 8C 1F 66 91 0F BE C6 11 EE 0F C0 E7 33 D9 64 F2 C0 DC 73 0F C0 D5 55 8B EC BA C0 1F 41 00 8B C2 B9 97 00 00 00 80 32 79 50 B8 02 00 00 00 50 03 14 24 58 58 51 2B C9 B9 01 00 00 00 83 EA 01 E2 FB 59 E2 E1 FF E0 }
    condition:
        $a at pe.entry_point

}

rule Trap_121_EXE: PEiD
{
    strings:
        $a = { E8 00 00 5B 83 C3 2B 90 8B D3 E8 01 00 01 5B 2E 80 3F 00 74 19 90 90 8B DA B9 94 04 EB 01 90 2E C0 07 00 2E 80 37 00 2E 80 2F 00 43 E2 F1 }
    condition:
        $a at pe.entry_point

}

rule Crunch_5_Fusion_4_additional: PEiD
{
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 55 E8 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_PiMP_Install_System_v1x_additional: PEiD
{
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 ?? ?? 40 00 05 E8 03 00 00 BE ?? ?? ?? 00 89 44 24 10 B3 20 FF 15 28 ?? 40 00 68 00 04 00 00 FF 15 ?? ?? 40 00 50 56 FF 15 ?? ?? 40 00 80 3D ?? ?? ?? 00 22 75 08 80 C3 02 BE ?? ?? ?? 00 8A 06 8B 3D ?? ?? 40 00 84 C0 74 ?? 3A C3 74 0B 56 FF D7 8B F0 8A 06 84 C0 75 F1 80 3E 00 74 05 56 FF D7 8B F0 89 74 24 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 3E 2F }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt_v102: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 5B 83 EB 05 EB 04 52 4E 44 }
    condition:
        $a at pe.entry_point

}

rule LHA_SFX_Archive_v213L_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? FC BC ?? ?? 8C C8 05 ?? ?? 8E C0 E8 ?? ?? BB ?? ?? E8 ?? ?? 06 1F B4 30 CD 21 8B D8 1E }
    condition:
        $a at pe.entry_point

}

rule TTPpack: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5D 81 ED F5 8F 40 00 60 33 F6 E8 11 00 00 00 8B 64 24 08 64 8F 05 }
    condition:
        $a at pe.entry_point

}

rule GX_Protector_12_GurueXe_additional: PEiD
{
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule LGLZ_v104b_additional: PEiD
{
    strings:
        $a = { FC 1E 06 0E 8C C8 ?? ?? ?? ?? BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 ?? ?? F3 A5 4B 48 4A 79 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_emadicius: PEiD
{
    strings:
        $a = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        $a at pe.entry_point

}

rule mkfpack_llydd_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5B 81 EB 05 00 00 00 8B 93 9F 08 00 00 53 6A 40 68 00 10 00 00 52 6A 00 FF 93 32 08 00 00 5B 8B F0 8B BB 9B 08 00 00 03 FB 56 57 E8 86 08 00 00 83 C4 08 8D 93 BB 08 00 00 52 53 FF E6 }
    condition:
        $a at pe.entry_point

}

rule Watcom_CCpp_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? 00 00 03 10 40 00 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 69 6D 65 20 73 79 73 74 65 6D 2E 20 28 63 29 20 43 6F 70 79 72 69 67 68 74 20 62 79 20 57 41 54 43 4F 4D 20 49 6E 74 65 72 6E 61 74 69 6F 6E 61 6C 20 43 6F 72 70 2E 20 }
    condition:
        $a at pe.entry_point

}

rule Ice_100: PEiD
{
    strings:
        $a = { BE 26 01 8B FE 8B 0E 08 01 8B 16 02 01 B8 77 01 50 FC AD 33 C2 AB 8B D0 E2 F8 00 00 00 00 00 8D 0F 47 8C 77 F4 37 C6 FE 41 FC 0F 4D 0C BD 59 78 53 CD 7C 48 8D 0F 47 8C 7F F4 3F 85 AD 7F 55 83 85 08 FF F1 81 86 01 94 15 7B 2A 45 48 D1 DE EF }
    condition:
        $a at pe.entry_point

}

rule CrypKey_v5_v6_CrypKey_Canada_Inc: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 58 83 E8 05 50 5F 57 8B F7 81 EF ?? ?? ?? ?? 83 C6 39 BA ?? ?? ?? ?? 8B DF B9 0B ?? ?? ?? 8B 06 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_PC_Guard_4xx_emadicius: PEiD
{
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 58 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Upack_v032_Beta_Patch_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule SecurePE_1X_additional: PEiD
{
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3 }
    condition:
        $a at pe.entry_point

}

rule Trap_119_EXE: PEiD
{
    strings:
        $a = { 8C D0 BB 99 CB 8E D3 33 D2 8E D0 B9 7D 04 EB 04 90 EA CD 20 E2 F8 33 D2 E5 21 50 B9 00 05 EB 03 90 CD 20 81 F9 E2 03 74 0F 90 90 83 C1 FE 83 C2 01 EB EB FA EB FE EA F0 FA B8 FE 00 E7 21 58 E7 21 66 8C E3 66 B8 00 00 01 00 8E E0 66 8C E0 8E }
    condition:
        $a at pe.entry_point

}

rule Image_Systems_Technology_Graphics_format: PEiD
{
    strings:
        $a = { 03 3A ?? ?? 00 ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule CrunchPE_v50_additional: PEiD
{
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_ASM_: PEiD
{
    strings:
        $a = { E8 01 00 00 00 5A 5E E8 02 00 00 00 BA DD 5E 03 F2 EB 01 64 BB 80 ?? ?? 00 8B FA EB 01 A8 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_Help_File_additional: PEiD
{
    strings:
        $a = { 54 55 52 ?? ?? ?? 50 41 53 ?? ?? ?? ?? 48 45 4C 50 }
    condition:
        $a at pe.entry_point

}

rule unknown_by_Woody: PEiD
{
    strings:
        $a = { B8 B9 0F 8E D8 8C 1E 04 00 8C 1E 08 00 8C C8 A3 00 00 E9 54 36 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V2010_p_Hide_from_PE_scanners_Type2: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule CorelDraw_CMX_Graphics_format_additional: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 4D 58 31 }
    condition:
        $a at pe.entry_point

}

rule Rec_Small_103: PEiD
{
    strings:
        $a = { 8C D8 1E E8 00 00 83 C0 0F 5D B9 00 00 81 ED EA 03 40 8E D8 2B DB B2 00 00 17 FE C2 43 83 FB 10 75 F6 E2 ED 1F 8C C0 03 C3 2E 01 86 27 04 2E 03 86 2B 04 FA BC 05 00 8E D0 2E 8B A6 29 04 EB 00 EA 01 00 00 00 7E 01 }
    condition:
        $a at pe.entry_point

}

rule Rec_Small_102: PEiD
{
    strings:
        $a = { 8C D8 1E E8 00 00 83 C0 0F 5D B9 00 00 81 ED BA 03 40 8E D8 2B DB B2 00 00 17 FE C2 43 83 FB 10 75 F6 E2 ED 1F 8C C0 03 C3 2E 01 86 F5 03 2E 03 86 F9 03 FA 2E 8B A6 F7 03 8E D0 FB EB 00 EA }
    condition:
        $a at pe.entry_point

}

rule Rec_Small_101: PEiD
{
    strings:
        $a = { 8C D8 1E E8 00 00 5D 83 C0 0F 81 ED BA 03 B9 00 00 40 8E D8 2B DB B2 00 00 17 FE C2 43 83 FB 10 75 F6 E2 ED 1F 8C C0 03 C3 2E 01 86 F5 03 2E 03 86 F9 03 FA 2E 8B A6 F7 03 8E D0 FB EB 00 EA 00 00 00 00 7E 01 }
    condition:
        $a at pe.entry_point

}

rule UPolyX_v05_: PEiD
{
    strings:
        $a = { 55 8B EC ?? 00 BD 46 00 8B ?? B9 ?? 00 00 00 80 ?? ?? 51 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2717_V2719_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 C1 FE FF FF E9 97 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 }
    condition:
        $a at pe.entry_point

}

rule VProtector_13X_vcasm_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 60 8B B4 24 24 00 00 00 8B BC 24 28 00 00 00 FC C6 C2 80 33 DB A4 C6 C3 02 E8 A9 00 00 00 0F 83 F1 FF FF FF 33 C9 E8 9C 00 00 00 0F 83 2D 00 00 00 33 C0 E8 8F 00 00 00 0F 83 37 00 00 00 C6 C3 02 41 C6 C0 10 E8 7D 00 00 00 10 C0 0F 83 F3 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule NsPack_31_North_Star_h: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt_WinRAR_SFX: PEiD
{
    strings:
        $a = { 80 E9 A1 C1 C1 13 68 E4 16 75 46 C1 C1 05 5E EB 01 9D 68 64 86 37 46 EB 02 8C E0 5F F7 D0 }
    condition:
        $a at pe.entry_point

}

rule PEQuake_v006_by_fORGAT: PEiD
{
    strings:
        $a = { E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 }
        $b = { E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? 00 00 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule DCrypt_Private_09b_drmist_additional: PEiD
{
    strings:
        $a = { B9 ?? ?? ?? 00 E8 00 00 00 00 58 68 ?? ?? ?? 00 83 E8 0B 0F 18 00 D0 00 48 E2 FB C3 }
    condition:
        $a at pe.entry_point

}

rule Fish_PE_Shield_112116_HellFish_additional: PEiD
{
    strings:
        $a = { 60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 ?? ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 ?? ?? 00 ?? ?? 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 00 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule eXPressorPacK_V150X_CGSoftLabs_Sign_by_fly: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 83 A5 ?? ?? ?? ?? ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C ?? 75 23 8B 45 08 A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 04 }
    condition:
        $a at pe.entry_point

}

rule Borland_Graphics_Interface_Driver: PEiD
{
    strings:
        $a = { 46 42 47 44 }
    condition:
        $a at pe.entry_point

}

rule Vx_Quake518_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 1E 06 8C C8 8E D8 ?? ?? ?? ?? ?? ?? ?? B8 21 35 CD 21 81 }
    condition:
        $a at pe.entry_point

}

rule Free_Pascal_v106_additional: PEiD
{
    strings:
        $a = { C6 05 ?? ?? 40 00 ?? E8 ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule EPW_v12_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E ?? ?? ?? ?? 8C C0 05 ?? ?? 2E ?? ?? ?? 8E D8 A1 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule TXTMaker_v122_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? B4 ?? 33 DB CD 10 80 ?? ?? 74 ?? B0 ?? EB ?? 8B }
    condition:
        $a at pe.entry_point

}

rule Upack_v024_v028_Alpha_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD ?? ?? 95 AD 91 F3 A5 AD }
    condition:
        $a at pe.entry_point

}

rule PRO_PACK_v208_additional: PEiD
{
    strings:
        $a = { 83 EC ?? 8B EC BE ?? ?? FC E8 ?? ?? 05 ?? ?? 8B C8 E8 ?? ?? 8B }
    condition:
        $a at pe.entry_point

}

rule AcidCrypt_AciDLeo: PEiD
{
    strings:
        $a = { 60 B9 ?? ?? ?? 00 BA ?? ?? ?? 00 BE ?? ?? ?? 00 02 38 40 4E 75 FA 8B C2 8A 18 32 DF C0 CB }
    condition:
        $a at pe.entry_point

}

rule PE_PaCK_v10_C_Copyright_1998_by_ANAKiN_additional: PEiD
{
    strings:
        $a = { C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 2D 3D FE 20 50 45 2D 50 41 43 4B 20 76 31 2E 30 20 2D FE 2D 20 28 43 29 20 43 6F 70 }
    condition:
        $a at pe.entry_point

}

rule ACProtect_V13X_risco_additional: PEiD
{
    strings:
        $a = { 60 1E E8 3B 01 BF CC 01 2E 03 3E CA 01 2E C7 05 }
    condition:
        $a at pe.entry_point

}

rule PackItBitch_10_archphase_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 28 ?? ?? ?? 35 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 41 ?? ?? ?? 50 ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 }
    condition:
        $a at pe.entry_point

}

rule Nuts_Bolts_Disk_Image: PEiD
{
    strings:
        $a = { 4E 42 69 6D }
    condition:
        $a at pe.entry_point

}

rule Upack_020_beta_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Yodas_Protector_102: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 90 90 E9 }
    condition:
        $a at pe.entry_point

}

rule ExeBundle_v30_standard_loader_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 60 BE 00 B0 42 00 8D BE 00 60 FD FF C7 87 B0 E4 02 00 31 3C 4B DF 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_239_compressed_resources_wwwstrongbitcom_additional: PEiD
{
    strings:
        $a = { CC ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? B4 ?? ?? ?? 08 ?? ?? ?? 00 00 00 00 FF FF FF FF E8 ?? ?? ?? 04 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 }
    condition:
        $a at pe.entry_point

}

rule PuNkMoD_11a_PuNkDuDe: PEiD
{
    strings:
        $a = { 94 B9 5E 01 00 00 BC ?? ?? ?? 00 80 34 0C ?? 80 2C 0C ?? D2 }
    condition:
        $a at pe.entry_point

}

rule CExe_v10a_TinyWare_Inc: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 0C 02 ?? ?? 56 BE 04 01 ?? ?? 8D 85 F8 FE FF FF 56 50 6A 00 FF 15 54 10 40 ?? 8A 8D F8 FE FF FF 33 D2 84 C9 8D 85 F8 FE FF FF 74 16 }
    condition:
        $a at pe.entry_point

}

rule PESpin_13beta_Cyberbob_h_additional: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 }
    condition:
        $a at pe.entry_point

}

rule ARM_Protector_01_by_SMoKE: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 }
        $b = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Pelles_C_2x_4x_DLL_Pelle_Orinius_additional: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 8B 5D 0C 8B 75 10 }
    condition:
        $a at pe.entry_point

}

rule PE_Intro_v10: PEiD
{
    strings:
        $a = { 8B 04 24 9C 60 E8 ?? ?? ?? ?? 5D 81 ED 0A 45 40 ?? 80 BD 67 44 40 ?? ?? 0F 85 48 }
    condition:
        $a at pe.entry_point

}

rule RLPack_118_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 A7 03 00 00 89 85 16 04 00 00 5B FF B5 16 04 00 00 56 FF D3 83 C4 ?? 8B B5 16 04 00 00 8B C6 EB 01 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_WWPack32_1x_emadicius_additional: PEiD
{
    strings:
        $a = { 60 BE 00 90 8B 00 8D BE 00 80 B4 FF 57 83 CD FF EB 3A 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 0B 75 19 8B 1E 83 EE FC 11 DB 72 10 58 61 90 EB 05 E8 EB 04 40 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_CAB_SFX: PEiD
{
    strings:
        $a = { E8 0A 00 00 00 E9 7A FF FF FF CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule yzpack_20_UsAr: PEiD
{
    strings:
        $a = { 25 ?? ?? ?? ?? 61 87 CC 55 45 45 55 81 ED CA 00 00 00 55 A4 B3 02 FF 14 24 73 F8 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 1F B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3C AA EB DC FF 54 24 04 2B CB 75 0F FF 54 24 08 EB 27 AC D1 E8 74 30 13 C9 EB 1B 91 48 C1 E0 08 AC FF 54 24 08 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 99 BD ?? ?? ?? ?? FF 65 28 }
    condition:
        $a at pe.entry_point

}

rule UPX_Modified_Stub_b_Farb_rausch_Consumer_Consulting_additional: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 66 ?? ?? ?? ?? ?? ?? 57 83 ?? ?? 31 DB EB }
    condition:
        $a at pe.entry_point

}

rule Obsidium_13013_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 02 ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 02 ?? ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 03 ?? ?? ?? E8 13 26 00 00 }
        $b = { EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule LaunchAnywhere_v4001_additional: PEiD
{
    strings:
        $a = { 5F 81 EF ?? ?? ?? ?? BE ?? ?? 40 ?? 8B 87 ?? ?? ?? ?? 03 C6 57 56 8C A7 ?? ?? ?? ?? FF 10 89 87 ?? ?? ?? ?? 5E 5F }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_32Lite_003_Anorganix: PEiD
{
    strings:
        $a = { 60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 }
    condition:
        $a at pe.entry_point

}

rule Blade_Joiner_v15_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 C4 E4 FE FF FF 53 56 57 33 C0 89 45 F0 89 85 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v251_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 B8 ?? ?? ?? 68 D0 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 20 }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_10_beta_2_by_Alex: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 EB 01 E9 FF FF 60 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 8B D8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 8B CA EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 0F 31 03 C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 13 D1 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 EB 05 68 F0 0F C7 C8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 85 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule AsCrypt_v01_SToRM: PEiD
{
    strings:
        $a = { 83 ?? ?? E2 ?? ?? E2 ?? FF }
        $b = { 81 ?? ?? ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? E2 ?? EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule aPack_090_099_d_s_EXE: PEiD
{
    strings:
        $a = { 8C CB BA 00 00 03 DA FC 33 F6 33 FF 4B 8E DB 8D 87 00 00 8E C0 B9 08 00 F3 A5 4A 75 EB 8E C3 8E D8 33 FF BE 2E 00 05 00 00 0E 50 6A 00 CB }
    condition:
        $a at pe.entry_point

}

rule PECompact_v25_Retail_Slim_Loader_Bitsum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v140b5_v140b6_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 8A 11 }
    condition:
        $a at pe.entry_point

}

rule SimbiOZ_PolyCryptor_vxx_Extranger: PEiD
{
    strings:
        $a = { 55 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_01_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? ?? BE ?? ?? BF ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule EPack_14_lite_final_by_6aHguT_additional: PEiD
{
    strings:
        $a = { 33 C0 8B C0 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 }
    condition:
        $a at pe.entry_point

}

rule BJFNT_11: PEiD
{
    strings:
        $a = { EB 01 EA 9C EB 01 EA 53 EB 01 EA 51 EB 01 EA 52 EB 01 EA 56 EB 01 C7 57 EB 01 C7 55 EB 02 CD 20 EB 02 C7 05 EB 01 EA EB 01 EA FC EB 01 EA E8 00 00 00 00 EB 01 C7 5E EB 02 CD 20 83 C6 50 EB 02 CD 20 8B FE EB 02 C7 05 B9 65 06 00 00 EB 02 C7 }
    condition:
        $a at pe.entry_point

}

rule BJFNT_12: PEiD
{
    strings:
        $a = { EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 02 CD 20 60 EB 03 3A 4D 3A E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 17 EB 02 CD 20 EB 03 CD 20 EB EB 01 EB FC EB 01 EB EB 02 CD 20 E8 00 00 00 00 EB 03 CD 20 17 5E EB 02 C7 }
    condition:
        $a at pe.entry_point

}

rule BJFNT_13: PEiD
{
    strings:
        $a = { EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 17 EB 02 CD 20 EB 03 3A 4D 3A FC EB 02 C7 85 E8 00 00 00 00 EB 02 C7 05 EB 02 CD 20 5E EB 02 CD 20 83 C6 3F }
    condition:
        $a at pe.entry_point

}

rule RLPack_V115_V116_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        $a at pe.entry_point

}

rule DrWeb_Virus_Finding_Engine_InSoft_EDV_Systeme_additional: PEiD
{
    strings:
        $a = { 2C E8 ?? ?? ?? ?? 5D 8B C5 81 ED F6 73 ?? ?? 2B 85 ?? ?? ?? ?? 83 E8 06 89 85 }
    condition:
        $a at pe.entry_point

}

rule PE_Armor_0760_0765_hying: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule aPack_v098b_com: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? 8B CF FC 57 F3 A4 C3 BF ?? ?? 57 57 BE ?? ?? B2 ?? BD ?? ?? 50 A4 }
    condition:
        $a at pe.entry_point

}

rule nPack_111502006Beta_NEOx_additional: PEiD
{
    strings:
        $a = { 83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_2545_Jitit: PEiD
{
    strings:
        $a = { E8 F2 FF FF FF 50 68 ?? ?? ?? ?? 68 40 1B 00 00 E8 42 FF FF FF E9 9D FF FF FF 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RE_Crypt_07x_Crudd_RET: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F3 1D 40 00 B9 7B 09 00 00 8D BD 3B 1E 40 00 8B F7 61 60 E8 00 00 00 00 5D 55 81 04 24 0A 00 00 00 C3 8B F5 81 C5 ?? ?? 00 00 89 6D 34 89 75 38 8B 7D 38 81 E7 00 FF FF FF 81 C7 48 00 00 00 47 03 7D 60 8B 4D 5C 83 F9 00 7E 0F 8B }
    condition:
        $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_V01_V015_DLL_NTkrnl_Software: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 8B 44 24 04 05 ?? ?? ?? ?? 50 E8 01 00 00 00 C3 C3 }
    condition:
        $a at pe.entry_point

}

rule Upack_v036_beta_Dwing_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 10 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? 00 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? 56 10 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 99 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B }
    condition:
        $a at pe.entry_point

}

rule SVKP_v143_Pavol_Cerven_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC CE 05 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67 }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi_50_KOLMCK: PEiD
{
    strings:
        $a = { 55 8B EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule _MSLRH_v031a: PEiD
{
    strings:
        $a = { 60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 0F C0 C9 D2 D1 0F C1 C0 D3 DA C0 D6 A8 EB 01 DE D0 EC 0F C1 CB D0 CF 0F C1 D1 D2 DB 0F C8 EB 01 BC C0 E9 C6 C1 D0 91 0F CB EB 01 73 0F CA 87 D9 87 D2 D0 CF 87 D9 0F C8 EB 01 C1 EB 01 A2 86 CA D0 E1 0F C0 CB 0F }
    condition:
        $a at pe.entry_point

}

rule InstallShield_3x_Custom_additional: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 00 A0 40 00 68 34 76 40 00 50 64 89 25 00 00 00 00 83 EC 60 53 56 57 89 65 E8 FF 15 8C E3 40 00 A3 70 B1 40 00 33 C0 A0 71 B1 40 00 A3 7C B1 40 00 A1 70 B1 }
    condition:
        $a at pe.entry_point

}

rule AVPack_12x_COM: PEiD
{
    strings:
        $a = { EB 12 41 56 50 41 43 4B 16 01 01 00 00 00 00 00 00 00 00 00 8C DA 03 16 12 01 39 16 02 00 73 18 B4 09 BA 28 01 CD 21 C3 4F 75 74 20 6F 66 20 6D 65 6D 6F 72 79 0D 0A 24 8B DC 83 EA 40 FA 8E D2 BC 00 04 FB 50 1E 53 8E C2 B9 00 01 8B F1 33 FF }
    condition:
        $a at pe.entry_point

}

rule PPC_PROTECT_V11X_Alexey_Gorchakov: PEiD
{
    strings:
        $a = { FF 5F 2D E9 20 00 9F E5 00 00 90 E5 18 00 8F E5 18 00 9F E5 00 00 90 E5 10 00 8F E5 01 00 A0 E3 00 00 00 EB 02 00 00 EA 04 F0 1F E5 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_R_Full_text_index_file_additional: PEiD
{
    strings:
        $a = { 6C 6C 2D 74 65 78 74 20 69 6E 64 65 78 }
    condition:
        $a at pe.entry_point

}

rule fasm_Tomasz_Grysztar_additional: PEiD
{
    strings:
        $a = { 53 55 56 8B 74 24 14 85 F6 57 B8 01 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEiD_Bundle_v100_v101_BoB_BobSoft_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A }
    condition:
        $a at pe.entry_point

}

rule MPRESS_V107_V125_MATCODE_Software_20080730: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 05 9E 02 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 51 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 8B D6 8B CF E8 56 00 00 00 5E 5A 83 EA 05 2B C9 3B CA 73 26 8B D9 AC 41 24 FE 3C E8 75 F2 43 83 C1 04 AD 0B C0 78 06 3B C2 73 E5 EB 06 03 C3 78 DF 03 C2 2B C3 89 46 FC EB D6 E8 00 00 00 00 5F 81 C7 8D FF FF FF B0 E9 AA B8 9A 02 00 00 AB E8 00 00 00 00 58 05 1C 02 00 00 E9 0C 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_12_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 68 01 ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_20_: PEiD
{
    strings:
        $a = { EB 01 56 E8 02 00 00 00 B2 D9 59 68 80 ?? 41 00 E8 02 00 00 00 65 32 59 5E EB 02 CD 20 BB }
    condition:
        $a at pe.entry_point

}

rule UPolyX_V01_Delikon: PEiD
{
    strings:
        $a = { E2 ?? FF ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Unknown_file_protector_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? BE ?? ?? BF ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule Berio_100_beta_h_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 01 12 00 00 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 B0 01 00 83 BD 22 04 00 00 00 89 9D 22 04 00 00 0F 85 65 03 00 00 8D 85 2E 04 00 00 50 FF 95 4D 0F }
    condition:
        $a at pe.entry_point

}

rule Zortech_C_v30_additional: PEiD
{
    strings:
        $a = { FA FC B8 ?? ?? ?? 8C C8 8E D8 }
    condition:
        $a at pe.entry_point

}

rule UPX_v080_v084: PEiD
{
    strings:
        $a = { 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB }
        $b = { 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 ?? ?? ?? 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 EF 75 09 8B 1E 83 EE FC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule NoodleCrypt_v200_Eng_NoodleSpa: PEiD
{
    strings:
        $a = { EB 01 9A E8 76 00 00 00 EB 01 9A E8 65 00 00 00 EB 01 9A E8 7D 00 00 00 EB 01 9A E8 55 00 00 00 EB 01 9A E8 43 04 00 00 EB 01 9A E8 E1 00 00 00 EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 9A E8 25 00 00 00 EB 01 9A E8 02 }
        $b = { EB 01 9A E8 76 00 00 00 EB 01 9A E8 65 00 00 00 EB 01 9A E8 7D 00 00 00 EB 01 9A E8 55 00 00 00 EB 01 9A E8 43 04 00 00 EB 01 9A E8 E1 00 00 00 EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 9A E8 25 00 00 00 EB 01 9A E8 02 04 00 00 EB 01 9A E8 19 07 00 00 EB 01 9A E8 9C 00 00 00 EB 01 9A E8 9C 06 00 00 E8 00 00 00 00 0F 7E F8 EB 01 9A 8B F8 C3 E8 00 00 00 00 58 EB 01 9A 25 00 F0 FF FF 8B F8 EB 01 9A 0F 6E F8 C3 8B D0 EB 01 9A 81 C2 C8 00 00 00 EB 01 9A B9 00 17 00 00 EB 01 9A C0 0A 06 EB 01 9A 80 2A 15 EB 01 9A 42 E2 EE 0F 6E C0 EB 01 9A 0F 7E C0 EB 01 9A 8B D0 00 85 EB A5 F5 65 4B 45 45 00 85 EB B3 65 07 45 45 00 85 EB 75 C7 C6 00 85 EB 65 CF 8A 00 85 EB D5 FD C0 00 85 EB 7F E5 05 05 05 00 85 EB 7F 61 06 45 45 00 85 EB 7F }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Obsidium_V1322_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 27 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 22 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 }
    condition:
        $a at pe.entry_point

}

rule WARNING_TROJAN_XiaoHui: PEiD
{
    strings:
        $a = { 60 9C E8 00 00 00 00 5D B8 ?? 85 40 00 2D ?? 85 40 00 }
    condition:
        $a at pe.entry_point

}

rule Unpacked_BS_SFX_Archive_v19_additional: PEiD
{
    strings:
        $a = { 55 8B EC B9 0B 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 6C 3E 40 00 E8 F7 EA FF FF 33 C0 55 68 60 44 40 00 64 FF 30 64 89 20 BA 70 44 40 00 B8 B8 6C 40 00 E8 62 F3 FF FF 8B D8 85 DB 75 07 6A 00 E8 A1 EB FF FF BA E8 64 40 00 8B C3 8B 0D B8 6C 40 00 E8 }
    condition:
        $a at pe.entry_point

}

rule SkD_Undetectabler_3_No_FSG_2_Method_SkD_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 10 02 00 00 68 00 02 00 00 8D 85 F8 FD FF FF 50 6A 00 FF 15 38 10 00 01 50 FF 15 3C 10 00 01 8D 8D F8 FD FF FF 51 E8 4F FB FF FF 83 C4 04 8B 15 ?? 16 00 01 52 A1 ?? 16 00 01 50 E8 50 FF FF FF 83 C4 08 A3 ?? 16 00 01 C7 85 F4 FD FF FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule Virogen_Crypt_v075_additional: PEiD
{
    strings:
        $a = { 9C 55 E8 ?? ?? ?? ?? 87 D5 5D 60 87 D5 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 57 56 AD 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_Small_build_031032_GlOFF: PEiD
{
    strings:
        $a = { 50 32 ?? 66 8B C3 58 E8 ?? FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 50 32 ?? 66 8B C3 58 E8 ?? FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule HEALTH_v51_by_Muslim_MPolyak_additional: PEiD
{
    strings:
        $a = { 1E E8 ?? ?? 2E 8C 06 ?? ?? 2E 89 3E ?? ?? 8B D7 B8 ?? ?? CD 21 8B D8 0E 1F E8 ?? ?? 06 57 A1 ?? ?? 26 }
    condition:
        $a at pe.entry_point

}

rule SVKP_v132_Pavol_Cerven_h_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 }
    condition:
        $a at pe.entry_point

}

rule Jam_221_COM: PEiD
{
    strings:
        $a = { 50 06 16 07 BE 06 02 8B FE B9 04 01 FD FA F3 2E A5 FB 06 BD 78 00 55 CB BE 00 00 8B FE BD 00 00 8D 9E 00 10 8D 97 00 00 B9 00 00 80 EF 10 8E DB 80 EE 10 8E C2 F3 A5 B5 80 3B DD 77 EE 33 C9 BE 00 00 8B FE 8E DA 8E C3 FC BA 01 00 EB 43 5D 2E }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_10x_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 E8 03 00 00 00 EB 01 }
        $b = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SoftSentry_v211_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 E9 50 }
    condition:
        $a at pe.entry_point

}

rule SkD_Undetectabler_Pro_20_No_UPX_Method_SkD: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 FC 26 00 10 E8 EC F3 FF FF 6A 0F E8 15 F5 FF FF E8 64 FD FF FF E8 BB ED FF FF 8D 40 }
    condition:
        $a at pe.entry_point

}

rule Unknown_SFX_Archive_aWAW_Hint_FILE_START: PEiD
{
    strings:
        $a = { 61 57 41 57 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v211d_additional: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 CD 20 E8 00 00 00 00 5E 2B C9 58 74 02 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Basic_60_DLL: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 5A 68 90 90 90 90 68 90 90 90 90 52 E9 90 90 FF }
    condition:
        $a at pe.entry_point

}

rule Cruncher_v10_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 2E ?? ?? ?? ?? 2E ?? ?? ?? B4 30 CD 21 3C 03 73 ?? BB ?? ?? 8E DB 8D ?? ?? ?? B4 09 CD 21 06 33 C0 50 CB }
    condition:
        $a at pe.entry_point

}

rule PESPin_v13_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 AC DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 AC DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 0D 4F 40 00 8B 42 3C 03 C2 89 85 17 4F 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D 2B 4F 40 00 53 8F 85 21 4D 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD D0 4F 40 00 8D 5B 04 8B 1B 89 9D D5 4F 40 00 E8 00 00 00 00 58 01 68 05 68 F7 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule iPB_Protect_013_017_forgot: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule InstallAnywhere_V61_Zero_G_Software_Inc: PEiD
{
    strings:
        $a = { 60 BE 00 A0 42 00 8D BE 00 70 FD FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 }
    condition:
        $a at pe.entry_point

}

rule Zortech_C: PEiD
{
    strings:
        $a = { FA FC B8 ?? ?? ?? 8C C8 8E D8 }
        $b = { E8 ?? ?? 2E FF ?? ?? ?? FC 06 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MSLRH_v01_emadicius_: PEiD
{
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 }
    condition:
        $a at pe.entry_point

}

rule eXpressor_v12_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? ?? 2B 05 84 ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 16 A1 ?? ?? ?? ?? 03 05 80 ?? ?? ?? 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 68 04 01 00 00 8D 85 F0 FE FF FF 50 6A 00 FF 15 }
    condition:
        $a at pe.entry_point

}

rule UPX_v103_v104_Modified_additional: PEiD
{
    strings:
        $a = { 01 DB ?? 07 8B 1E 83 EE FC 11 DB 8A 07 ?? EB B8 01 00 00 00 01 DB ?? 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_XCR_011: PEiD
{
    strings:
        $a = { 60 8B F0 33 DB 83 C3 01 83 C0 01 E9 }
    condition:
        $a at pe.entry_point

}

rule PE_Lock_NT_v201_additional: PEiD
{
    strings:
        $a = { EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 }
    condition:
        $a at pe.entry_point

}

rule PcShare_v40_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 90 34 40 00 68 B6 28 40 00 64 A1 }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V34_V35_LiuXingPing: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 01 0F 84 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v15x_CGSoftLabs: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 58 02 00 00 53 56 57 83 A5 CC FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C 01 75 23 }
    condition:
        $a at pe.entry_point

}

rule SLVc0deProtector_v061_SLV: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 }
        $b = { EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 31 00 00 00 78 E8 DD FF FF FF 38 E8 E3 FF FF FF 66 E8 0D 00 00 00 04 E8 E3 FF FF FF 70 E8 CB FF FF FF 69 E8 DD FF FF FF 58 E8 DD FF FF FF 69 E8 E3 FF FF FF 79 E8 BF FF FF FF 69 83 C4 40 E8 00 00 00 00 5D 81 ED 9D 11 40 00 8D 95 B4 11 40 00 E8 CB 2E 00 00 33 C0 F7 F0 69 8D B5 05 12 40 00 B9 5D 2E 00 00 8B FE AC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Alloy_v1x2000_Prakash_Gautam: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 00 87 DD 6A 04 68 00 10 ?? ?? 68 00 02 ?? ?? 6A 00 FF 95 46 23 40 ?? 0B }
    condition:
        $a at pe.entry_point

}

rule PESpin_1304_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 }
    condition:
        $a at pe.entry_point

}

rule Reg2Exe_224_by_Jan_Vorel_additional: PEiD
{
    strings:
        $a = { 6A 00 E8 2F 1E 00 00 A3 C4 35 40 00 E8 2B 1E 00 00 6A 0A 50 6A 00 FF 35 C4 35 40 00 E8 07 00 00 00 50 E8 1B 1E 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 C8 35 40 00 E8 76 16 00 00 83 C4 0C 8B 44 24 04 A3 CC 35 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 }
    condition:
        $a at pe.entry_point

}

rule Stones_PE_Encrypter_20: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 81 ED 42 30 40 00 FF 95 32 35 40 00 B8 37 30 40 00 03 C5 2B 85 1B 34 40 00 89 85 27 34 40 00 83 BD 0F 34 40 00 00 75 1D 90 90 90 90 C7 85 0F 34 40 00 01 00 00 00 E8 1E 00 00 00 E8 25 02 00 00 E8 DA 02 00 }
    condition:
        $a at pe.entry_point

}

rule UPack_011: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 1C F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9E 0C 10 00 00 B0 01 67 E3 29 8B D7 }
    condition:
        $a at pe.entry_point

}

rule Upack_012_beta_Dwing_additional: PEiD
{
    strings:
        $a = { BE 48 01 40 00 AD ?? ?? ?? A5 ?? C0 33 C9 ?? ?? ?? ?? ?? ?? ?? F3 AB ?? ?? 0A ?? ?? ?? ?? AD 50 97 51 ?? 87 F5 58 8D 54 86 5C ?? D5 72 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B6 5F FF C1 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_05_Smoke: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1300_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 22 EB 02 ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 01 ?? E8 D5 FF FF FF EB 02 ?? ?? EB 03 ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 02 ?? ?? E8 47 26 00 00 }
        $b = { EB 04 25 80 34 CA E8 29 00 00 00 EB 02 C1 81 EB 01 3A 8B 54 24 0C EB 02 32 92 83 82 B8 00 00 00 22 EB 02 F2 7F 33 C0 EB 04 65 7E 14 79 C3 EB 04 05 AD 7F 45 EB 04 05 65 0B E8 64 67 FF 36 00 00 EB 04 0D F6 A8 7F 64 67 89 26 00 00 EB 04 8D 68 C7 FB EB 01 6B }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Cpp_50_71: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 04 01 00 00 68 04 01 00 00 8D 85 FC FE FF FF 50 6A 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D FC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 8B E5 5D C2 10 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_V037_V039_Dwing: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 00 ?? ?? ?? 00 03 00 00 00 ?? ?? ?? ?? 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 ?? F6 ?? 00 B2 4F 45 00 ?? F9 ?? 00 EF 4F 45 00 ?? F6 ?? 00 8C D1 42 00 ?? 56 ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 34 50 45 00 ?? ?? ?? 00 FF FF 00 00 ?? 24 ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 40 00 00 C0 00 00 ?? ?? ?? ?? 00 00 ?? 00 00 00 ?? 1E ?? 00 ?? F7 ?? 00 A6 4E 43 00 ?? 56 ?? 00 AD D1 42 00 ?? F7 ?? 00 A1 D2 42 00 ?? 56 ?? 00 0B 4D 43 00 ?? F7 ?? 00 ?? F7 ?? 00 ?? 56 ?? 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? 77 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 77 ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? 00 }
        $b = { BE ?? ?? ?? ?? AD 50 FF ?? ?? EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule tElock_099_tE_additional: PEiD
{
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v300_v301_Extractable_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 6A ?? 06 06 8C D3 83 ?? ?? 53 6A ?? FC }
    condition:
        $a at pe.entry_point

}

rule tElock_051_tE_additional: PEiD
{
    strings:
        $a = { C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 5E 8B FE 68 79 01 00 00 59 EB 01 EB AC 54 E8 03 00 00 00 5C EB 08 8D 64 24 04 FF 64 24 FC 6A 05 D0 2C 24 72 01 E8 01 24 24 5C F7 DC EB 02 CD 20 8D 64 24 FE F7 DC EB 02 CD 20 FE C8 E8 00 00 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_V12_V14_SIS_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 91 02 6D 61 6C 6C 6F 63 00 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 C5 02 73 74 72 73 74 72 00 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00 }
    condition:
        $a at pe.entry_point

}

rule Interplays_MVE_file: PEiD
{
    strings:
        $a = { 49 6E 74 65 72 70 6C 61 79 20 4D 56 45 20 46 69 6C 65 1A 00 1A }
    condition:
        $a at pe.entry_point

}

rule RCryptor_V16c_Vaska_Sign_by_fly: PEiD
{
    strings:
        $a = { 8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule Unknown_packer_08_additional: PEiD
{
    strings:
        $a = { 8B C4 2D ?? ?? 24 00 8B F8 57 B9 ?? ?? BE ?? ?? F3 A5 FD C3 97 4F 4F }
    condition:
        $a at pe.entry_point

}

rule NSPack_Nort_Star_Software_urlwwwnsdsncom: PEiD
{
    strings:
        $a = { 83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08 83 7E 08 00 75 02 EB 7A 8B 5E 08 03 DA 53 52 56 8D BD ?? ?? FF FF 03 7E 04 83 C6 0C 57 }
        $b = { 83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Stones_PE_Encryptor_v113_additional: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 ED 97 3B 40 ?? 2B 95 2D 3C 40 ?? 83 EA 0B 89 95 36 3C 40 ?? 01 95 24 3C 40 ?? 01 95 28 }
    condition:
        $a at pe.entry_point

}

rule NsPacK_Net_LiuXingPing_Sign_by_fly: PEiD
{
    strings:
        $a = { 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 BB 01 47 65 74 53 79 73 74 65 6D 49 6E 66 6F 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 5E 00 5F 43 6F 72 ?? ?? ?? 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C }
    condition:
        $a at pe.entry_point

}

rule Pohernah_Crypter_V101_Kas_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED }
    condition:
        $a at pe.entry_point

}

rule MaskPE_V20_yzkzero: PEiD
{
    strings:
        $a = { B8 18 00 00 00 64 8B 18 83 C3 30 C3 40 3E 0F B6 00 C1 E0 ?? 83 C0 ?? 36 01 04 24 C3 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1200_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 3F 1E 00 00 }
    condition:
        $a at pe.entry_point

}

rule Ding_Boys_PE_lock_007: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 00 00 00 00 5D 8B D5 81 ED 23 35 40 00 BE 3D 35 40 00 03 F5 B9 E4 02 00 00 E8 E4 02 00 00 71 99 00 00 83 3E 32 B8 77 40 00 74 38 67 BE C0 63 76 40 83 69 E1 82 1C C8 6B 76 40 BE 09 80 77 40 03 F6 A3 A9 6A 06 A4 77 40 66 }
    condition:
        $a at pe.entry_point

}

rule nSPack_2x3x_NET_North_StarLiu_Xing_Ping: PEiD
{
    strings:
        $a = { FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ACProtect_v135_risco_software_Inc_Anticrack_Software_h_additional: PEiD
{
    strings:
        $a = { 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 }
    condition:
        $a at pe.entry_point

}

rule tElock_v095_tHE_EGOiSTE: PEiD
{
    strings:
        $a = { E9 D5 E4 FF FF 00 }
    condition:
        $a at pe.entry_point

}

rule PS_AdobeFont_v10: PEiD
{
    strings:
        $a = { 80 01 ?? ?? 00 00 25 21 50 53 2D 41 64 6F 62 65 46 6F 6E 74 2D 31 2E 30 3A }
    condition:
        $a at pe.entry_point

}

rule PESpin_0b_01_CyberBob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 }
    condition:
        $a at pe.entry_point

}

rule Fly_Crypter_10_ut1lz: PEiD
{
    strings:
        $a = { 53 56 57 55 BB 2C ?? ?? 44 BE 00 30 44 44 BF 20 ?? ?? 44 80 7B 28 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D 04 30 44 44 00 74 06 FF 15 58 30 44 44 80 7B 28 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C FF 15 20 30 44 44 80 7B 28 01 76 05 83 3E 00 74 22 8B 43 10 85 C0 74 1B FF 15 18 30 44 44 8B 53 10 8B 42 10 3B 42 04 74 0A 85 C0 74 06 50 E8 2F FA FF FF FF 15 24 30 44 44 80 7B 28 01 75 03 FF 53 24 80 7B 28 00 74 05 E8 35 FF FF FF 83 3B 00 75 17 83 3D 10 ?? ?? 44 00 74 06 FF 15 10 ?? ?? 44 8B 06 50 E8 51 FA FF FF 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E E9 73 FF FF FF 5D 5F 5E 5B C3 A3 00 30 44 44 E8 26 FF FF FF C3 }
        $b = { 55 8B EC 83 C4 F0 53 B8 18 22 44 44 E8 7F F7 FF FF E8 0A F1 FF FF B8 09 00 00 00 E8 5C F1 FF FF 8B D8 85 DB 75 05 E8 85 FD FF FF 83 FB 01 75 05 E8 7B FD FF FF 83 FB 02 75 05 E8 D1 FD FF FF 83 FB 03 75 05 E8 87 FE FF FF 83 FB 04 75 05 E8 5D FD FF FF 83 FB 05 75 05 E8 B3 FD FF FF 83 FB 06 75 05 E8 69 FE FF FF 83 FB 07 75 05 E8 5F FE FF FF 83 FB 08 75 05 E8 95 FD FF FF 83 FB 09 75 05 E8 4B FE FF FF 5B E8 9D F2 FF FF 90 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ExePack_10_: PEiD
{
    strings:
        $a = { 60 E8 36 FE FF FF C3 90 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v15_Private_Vaska_additional: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_SKE_23_Alexey_Solodovnikov_h: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 E5 0B 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C }
    condition:
        $a at pe.entry_point

}

rule mPACK_v002_DeltaAziz_h_additional: PEiD
{
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 E8 AA 00 00 00 4E ?? ?? 00 00 00 00 00 00 00 00 00 5E ?? ?? 00 4E ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? ?? 0C ?? ?? ?? CC E4 ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 5D 68 00 FE 9F 07 53 E8 5D 00 00 00 EB FF 71 E8 C2 50 00 EB D6 5E F3 68 89 74 24 48 74 24 58 FF 8D 74 24 58 5E 83 C6 4C 75 F4 59 8D 71 E8 75 09 81 F6 EB FF 51 B9 01 00 83 EE FC 49 FF 71 C7 75 19 8B 74 24 00 00 81 36 50 56 8B 36 EB FF 77 C4 36 81 F6 EB 87 34 24 8B 8B 1C 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 5B EB FF F3 EB FF C3 83 EB FD }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Borland_Delphi_30_Anorganix: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_PENightMare_2_Beta: PEiD
{
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        $a at pe.entry_point

}

rule kkrunchy_023_alpha_Ryd_additional: PEiD
{
    strings:
        $a = { BD 08 ?? ?? 00 C7 45 00 ?? ?? ?? 00 FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? 00 57 BE ?? ?? ?? 00 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 10 C9 73 F3 FF 45 0C 91 AA 83 C9 FF 8D 5C 8D 18 FF D6 74 DD E3 17 8D 5D 1C FF D6 74 10 8D 9D A0 08 00 00 E8 ?? 00 00 00 8B 45 10 EB 42 8D 9D A0 04 00 00 E8 ?? 00 00 00 49 49 78 40 8D 5D 20 74 03 83 C3 40 31 D2 42 E8 ?? 00 00 00 8D 0C 48 F6 C2 10 74 F3 41 91 8D 9D A0 08 00 00 E8 ?? 00 00 00 3D 00 08 00 00 83 D9 FF 83 F8 60 83 D9 FF 89 45 10 56 89 FE 29 C6 F3 A4 5E EB 90 BE ?? ?? ?? 00 BB ?? ?? ?? 00 55 46 AD 85 C0 74 ?? 97 56 FF 13 85 C0 74 16 95 AC 84 C0 75 FB 38 06 74 E8 78 ?? 56 55 FF 53 04 AB 85 C0 }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V11X_V12X_Method2_bagie: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 }
        $b = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PECompact_140_141: PEiD
{
    strings:
        $a = { EB 06 68 00 00 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 00 87 DD 8B 85 A6 A0 40 00 01 85 03 A0 40 00 66 C7 85 00 A0 40 00 90 90 01 85 9E A0 40 00 BB C3 11 00 00 03 9D AA A0 40 00 03 9D A6 A0 40 00 }
    condition:
        $a at pe.entry_point

}

rule ExeShield_Cryptor_13RC_Tom_Commander_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 8C 21 40 00 B9 51 2D 40 00 81 E9 E6 21 40 00 8B D5 81 C2 E6 21 40 00 8D 3A 8B F7 33 C0 EB 04 90 EB 01 C2 AC }
    condition:
        $a at pe.entry_point

}

rule RLPack_V111_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 4A 02 00 00 8D 9D 11 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_60_DLL_emadicius_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_v114_beta_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 67 02 00 00 8D 9D 2E 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 3B 00 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32_Brczi_Gbor_Pierre_Muller_Peter_Vreman: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? ?? 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
        $b = { C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 00 E8 C5 01 00 00 89 D8 E8 3E 02 00 00 E8 B9 01 00 00 E8 54 02 00 00 8B 5D FC C9 C3 8D 76 00 00 00 00 00 00 00 00 00 00 00 00 00 55 89 E5 C6 05 10 80 40 00 00 E8 D1 03 00 00 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? 70 40 00 55 31 ED 89 E0 A3 20 80 40 00 66 8C D5 89 2D 30 80 40 00 E8 B9 03 00 00 31 ED E8 72 FF FF FF 5D E8 BC 03 00 00 C9 C3 00 00 00 00 00 00 00 00 00 00 55 89 E5 83 EC 08 E8 15 04 00 00 A1 ?? 70 40 00 89 45 F8 B8 01 00 00 00 89 45 FC 3B 45 F8 7F 2A FF 4D FC 90 FF 45 FC 8B 45 FC 83 3C C5 ?? 70 40 00 00 74 09 8B 04 C5 ?? 70 40 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule StarForce_V3X_DLL_StarForce_Copy_Protection_System_: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V112_Sukhov_Vladimir: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 C5 FA 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        $a at pe.entry_point

}

rule Vx_XRCV1015: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 83 ?? ?? 53 51 1E 06 B4 99 CD 21 80 FC 21 ?? ?? ?? ?? ?? 33 C0 50 8C D8 48 8E C0 1F A1 ?? ?? 8B }
    condition:
        $a at pe.entry_point

}

rule UPX_v20_Markus_Laszlo_Reiser: PEiD
{
    strings:
        $a = { 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB ?? FF 96 ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? 00 00 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 }
        $b = { 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB ?? FF 96 ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? 00 00 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Stealth_PE_v11: PEiD
{
    strings:
        $a = { BA ?? ?? ?? 00 FF E2 BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 03 B8 ?? ?? ?? ?? 89 02 83 C2 FD FF E2 }
    condition:
        $a at pe.entry_point

}

rule MetaWare_High_C_p_Phar_Lap_DOS_Extender_1983_89_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E D8 B8 ?? ?? CD 21 A3 ?? ?? 3C 03 7D ?? B4 09 }
    condition:
        $a at pe.entry_point

}

rule NsPacK_V34_V35_LiuXingPing_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 01 0F 84 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cue_70_80: PEiD
{
    strings:
        $a = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 }
    condition:
        $a at pe.entry_point

}

rule EXE_Packer_v70_by_TurboPower_Software_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 1E 06 8C C3 83 ?? ?? 2E ?? ?? ?? ?? B9 ?? ?? 8C C8 8E D8 8B F1 4E 8B FE }
    condition:
        $a at pe.entry_point

}

rule MEW_11_SE_11_Northfox_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 00 00 00 02 00 00 00 0C 00 }
    condition:
        $a at pe.entry_point

}

rule ARM_Protector_03_by_SMoKE_additional: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 13 24 40 00 EB 02 83 09 8D B5 A4 24 40 00 EB 02 83 09 BA 4B 15 00 00 EB 01 00 8D 8D EF 39 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v12_Alexey_Solodovnikov_h1_additional: PEiD
{
    strings:
        $a = { 90 ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 }
    condition:
        $a at pe.entry_point

}

rule Unnamed_Scrambler_10_p0ke_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 33 C0 89 45 ?? ?? ?? ?? 40 00 E8 11 F4 FF FF BE 30 6B 40 00 33 C0 55 68 C9 42 40 00 64 FF 30 64 89 20 E8 C9 FA FF FF BA D8 42 40 00 8B ?? ?? ?? ?? FF FF 8B D8 B8 28 6B 40 00 8B 16 E8 37 F0 FF FF B8 2C 6B 40 00 8B 16 E8 2B F0 FF FF B8 28 6B 40 00 E8 19 F0 FF FF 8B D0 8B C3 8B 0E E8 42 E3 FF FF BA DC 42 40 00 8B C6 E8 2A FA FF FF 8B D8 B8 20 6B 40 00 8B 16 E8 FC EF FF FF B8 24 6B 40 00 8B 16 E8 F0 EF FF FF B8 20 6B 40 00 E8 DE EF FF FF 8B D0 8B C3 8B 0E E8 07 E3 FF FF 6A 00 6A 19 6A 00 6A 32 A1 28 6B 40 00 E8 59 EF FF FF 83 E8 05 03 C0 8D 55 EC E8 94 FE FF FF 8B 55 EC B9 24 6B 40 00 A1 20 6B 40 00 E8 E2 F6 FF FF 6A 00 6A 19 6A 00 6A 32 }
    condition:
        $a at pe.entry_point

}

rule FSG_v20_additional: PEiD
{
    strings:
        $a = { 87 25 ?? ?? ?? ?? 61 94 55 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_additional: PEiD
{
    strings:
        $a = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version_additional: PEiD
{
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 10 01 90 90 90 90 90 90 90 90 E8 00 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule PDS_graphics_file_format: PEiD
{
    strings:
        $a = { 49 4D 41 47 45 49 44 45 4E 54 49 46 49 45 52 20 }
    condition:
        $a at pe.entry_point

}

rule Sentinel_UltraPro_Dongle_V110_SafeNet_Inc_SignByfly: PEiD
{
    strings:
        $a = { A1 ?? ?? ?? ?? 85 C0 0F 85 59 06 00 00 55 56 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE ?? ?? ?? 0D 01 ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 BD 0F 00 00 83 C4 04 83 F8 64 7C E7 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 A1 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 66 8B 4D 00 83 C5 08 ?? ?? ?? ?? ?? ?? ?? 66 8B 75 FA ?? ?? ?? ?? ?? ?? 66 ?? ?? ?? ?? ?? ?? 8B 55 FC 81 E1 FF FF 00 00 81 F9 }
        $b = { A1 ?? ?? ?? ?? 85 C0 0F 85 59 06 00 00 55 56 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE ?? ?? ?? 0D 01 ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 BD 0F 00 00 83 C4 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Petite_v_after_v14: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule XMI_music_file: PEiD
{
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 58 4D 49 44 }
    condition:
        $a at pe.entry_point

}

rule Macs_StuffIt_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 53 49 54 21 00 }
    condition:
        $a at pe.entry_point

}

rule nPack_v113002006_Beta: PEiD
{
    strings:
        $a = { 83 3D 4C ?? ?? 00 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_444a_public_build_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 51 B9 00 08 00 00 B9 06 00 00 00 F7 D1 0F C8 F7 D1 41 41 41 41 41 41 41 83 C1 04 41 41 41 41 83 C1 03 41 41 41 41 41 41 49 41 FE C1 FE C1 FE C1 83 C1 0D FE C1 FE C1 FE C1 FE C1 FE C1 83 C1 0A 49 52 BA 04 00 00 00 03 CA 41 5A 0F C8 23 C1 59 F7 D8 1B C0 F7 D8 5A 89 45 F4 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? D1 E1 89 4D F8 83 7D F4 00 74 09 8B 55 F8 83 CA 01 89 55 F8 8B 45 F8 50 FF 15 ?? ?? ?? ?? 83 C4 04 5F 5E 5B 8B E5 5D C3 55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 53 BB 80 00 00 00 EB 05 BB 04 00 00 00 BB 32 00 00 00 F7 D3 0F C8 F7 D3 43 43 83 E0 00 83 C3 08 4B 51 B9 04 00 00 00 03 D9 43 59 0F C8 40 5B 89 45 F4 8B 0D ?? ?? ?? ?? 33 0D ?? ?? ?? ?? D1 E1 89 4D F8 83 7D F4 00 74 09 8B 55 F8 83 CA 01 89 55 F8 8B 45 F8 50 FF 15 ?? ?? ?? ?? 83 C4 04 5F 5E 5B 8B E5 5D C3 55 8B EC 83 EC 0C 53 56 57 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 70 07 7C 03 EB 05 E9 74 FB EB F9 53 BB FF FF 00 00 23 C3 51 B5 2C 80 ED 01 80 ED 20 FE CD FE CD 80 ED 04 FE CD 80 ED 03 FE CD 22 E5 B1 70 80 E9 02 FE C9 FE C9 FE C9 80 E9 06 F6 D0 0F C9 F6 D0 0F C9 FE C9 FE C9 80 E9 10 FE C9 FE C9 80 C1 0C FE C9 FE C9 FE C9 70 07 7C 03 EB 05 C7 74 FB EB F9 FE C9 FE C9 FE C9 FE C9 80 E9 10 80 E9 01 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 FE C9 F7 D1 0F C8 F7 D1 0F C8 FE C1 80 C1 02 22 C1 59 5B 85 C0 0F 85 94 00 00 00 8B 45 FC 53 BB 00 08 00 00 EB 05 BB 80 00 00 00 BB 72 00 00 00 F7 D3 0F C8 F7 D3 43 43 83 C3 08 4B 51 B9 04 00 00 00 03 D9 43 59 0F C8 23 C3 5B F7 D8 1B C0 40 5A 8B C8 51 8B 45 FC 52 BA FF FF }
    condition:
        $a at pe.entry_point

}

rule PKLite_100_COM: PEiD
{
    strings:
        $a = { B8 00 00 BA 00 00 3B C4 73 67 8B C4 2D 44 03 25 F0 FF 8B F8 B9 A2 00 BE 7C 01 FC F3 A5 8B D8 B1 04 D3 EB 8C D9 03 D9 53 33 DB 53 CB 00 01 50 4B 6C 69 74 65 20 43 6F 70 72 2E 20 31 39 39 30 20 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Bitmap_Graphics_format: PEiD
{
    strings:
        $a = { 01 00 09 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_Debug_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4E 65 6F 4C 69 74 65 }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_Small_build_035_GlOFF_additional: PEiD
{
    strings:
        $a = { 51 33 CB 86 C9 59 E8 9E FD FF FF 66 87 DB 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_206_additional: PEiD
{
    strings:
        $a = { 83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 }
    condition:
        $a at pe.entry_point

}

rule XWD_graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 00 00 71 00 00 00 07 00 00 00 02 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Cryptic_20_Tughack_additional: PEiD
{
    strings:
        $a = { B8 00 00 40 00 BB ?? ?? ?? 00 B9 00 10 00 00 BA ?? ?? ?? 00 03 D8 03 C8 03 D1 3B CA 74 06 80 31 ?? 41 EB F6 FF E3 }
    condition:
        $a at pe.entry_point

}

rule PESpin_13beta_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Packman_v0001: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 8D A8 ?? ?? FF FF 8D 98 ?? ?? ?? FF 8D ?? ?? 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_Microsoft_Visual_Cpp_60_additional: PEiD
{
    strings:
        $a = { C1 E0 06 EB 02 CD 20 EB 01 27 EB 01 24 BE 80 ?? 42 00 49 EB 01 99 8D 1D F4 00 00 00 EB 01 5C F7 D8 1B CA EB 01 31 8A 16 80 E9 41 EB 01 C2 C1 E0 0A EB 01 A1 81 EA A8 8C 18 A1 34 46 E8 01 00 00 00 62 59 32 D3 C1 C9 02 EB 01 68 80 F2 1A 0F BE C9 F7 D1 2A D3 EB 02 42 C0 EB 01 08 88 16 80 F1 98 80 C9 28 46 91 EB 02 C0 55 4B EB 01 55 34 44 0B DB 75 AD E8 01 00 00 00 9D 59 0B C6 EB 01 6C E9 D2 C3 82 C2 03 C2 B2 82 C2 00 ?? ?? 7C C2 6F DA BC C2 C2 C2 CC 1C 3D CF 4C D8 84 D0 0C FD F0 42 77 0D 66 F1 AC C1 DE CE 97 BA D7 EB C3 AE DE 91 AA D5 02 0D 1E EE 3F 23 77 C4 01 72 12 C1 0E 1E 14 82 37 AB 39 01 88 C9 DE CA 07 C2 C2 C2 17 79 49 B2 DA 0A C2 C2 C2 A9 EA 6E 91 AA 2E 03 CF 7B 9F CE 51 FA 6D A2 AA 56 8A E4 C2 C2 C2 07 C2 47 C2 C2 17 B8 42 C6 8D 31 88 45 BA 3D 2B BC }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b3_Jeremy_Collake: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 95 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V520Beta1_Silicon_Realms_Toolworks_20080214: PEiD
{
    strings:
        $a = { E8 8E 3F 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 9E 16 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 F5 14 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 86 14 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? ?? 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 07 13 00 00 59 89 7D FC FF 75 08 E8 AC 47 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 7C D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 C7 F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 AD 11 00 00 59 C3 }
    condition:
        $a at pe.entry_point

}

rule PureBasic_DLL_Neil_Hodgson_additional: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 75 ?? 8B 44 24 04 A3 ?? ?? ?? 10 E8 }
    condition:
        $a at pe.entry_point

}

rule MinGW_v32x_Dll_WinMain: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 ?? ?? ?? FF 15 E4 40 40 ?? E8 68 ?? ?? ?? 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 ?? ?? ?? FF 15 E4 40 40 ?? E8 48 ?? ?? ?? 89 EC 31 C0 5D C3 89 }
        $b = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 00 00 EB EB 8D B4 26 00 00 00 00 85 C0 75 D0 E8 47 00 00 00 EB C9 90 8D 74 26 00 C7 04 24 80 00 00 00 E8 A4 05 00 00 A3 00 30 00 10 85 C0 74 1A C7 00 00 00 00 00 A3 10 30 00 10 E8 1B 02 00 00 E8 A6 01 00 00 E9 75 FF FF FF E8 6C 05 00 00 C7 00 0C 00 00 00 31 C0 EB 98 89 F6 55 89 E5 83 EC 08 89 5D FC 8B 15 00 30 00 10 85 D2 74 29 8B 1D 10 30 00 10 83 EB 04 39 D3 72 0D 8B 03 85 C0 75 2A 83 EB 04 39 D3 73 F3 89 14 24 E8 1B 05 00 00 31 C0 A3 00 30 00 10 C7 04 24 00 00 00 00 E8 F8 04 00 00 8B 5D FC 89 EC 5D C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ROD_High_TECH_Ayman_additional: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 ED 63 3A 40 ?? 2B 95 C2 3A 40 ?? 83 EA 0B 89 95 CB 3A 40 ?? 8D B5 CA 3A 40 ?? 0F B6 36 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig4: PEiD
{
    strings:
        $a = { C3 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule RIX_graphics_file: PEiD
{
    strings:
        $a = { 52 49 58 33 }
    condition:
        $a at pe.entry_point

}

rule Themida_1201_compressed_Oreans_Technologies_h_additional: PEiD
{
    strings:
        $a = { B8 00 00 ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? 00 03 C7 B9 ?? ?? ?? 00 03 CF EB 0A B8 ?? ?? ?? ?? B9 5A ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9 AF 01 00 00 02 00 00 00 91 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE_yy66_additional: PEiD
{
    strings:
        $a = { 68 78 18 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 }
    condition:
        $a at pe.entry_point

}

rule Krypton_v05_yadolockless: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED 71 44 ?? 00 2B 85 64 60 ?? 00 EB 43 DF }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v15_Vaska_additional: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F }
    condition:
        $a at pe.entry_point

}

rule aPack_096_i_m: PEiD
{
    strings:
        $a = { 8C C8 05 00 00 8E C0 59 8E D0 51 BE 00 01 BF 00 01 50 57 FC B2 80 BD 00 01 50 AC F6 D0 AA FF D5 73 F8 FF D5 B1 01 73 13 FF D5 BB 10 00 72 25 FF D5 12 DB 73 FA 75 00 93 AA EB E3 B7 01 FF D5 12 FF 72 00 FF D5 72 F6 FF D5 13 C9 FF D5 72 F8 80 }
    condition:
        $a at pe.entry_point

}

rule UPX_V194_Markus_Oberhumer_amp_Laszlo_Molnar_amp_John_Reiser: PEiD
{
    strings:
        $a = { FF D5 80 A7 ?? ?? ?? ?? ?? 58 50 54 50 53 57 FF D5 58 61 8D 44 24 ?? 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        $a at pe.entry_point

}

rule UPX_0896_102_PE: PEiD
{
    strings:
        $a = { 60 BE 00 00 00 00 8D BE 00 00 00 FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 }
    condition:
        $a at pe.entry_point

}

rule DIET_v144_v145f_Hint_DOS_EP_p_11: PEiD
{
    strings:
        $a = { F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA ?? ?? 03 D0 52 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1300_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 04 83 A4 BC CE 60 EB 04 80 BC 04 11 E8 00 00 00 00 81 2C 24 CA C2 41 00 EB 04 64 6B 88 18 5D E8 00 00 00 00 EB 04 64 6B 88 18 81 2C 24 86 00 00 00 EB 04 64 6B 88 18 8B 85 9C C2 41 00 EB 04 64 6B 88 18 29 04 24 EB 04 64 6B 88 18 EB 04 64 6B 88 18 8B 04 24 EB 04 64 6B 88 18 89 85 9C C2 41 00 EB 04 64 6B 88 18 58 68 9F 6F 56 B6 50 E8 5D 00 00 00 EB FF 71 78 C2 50 00 EB D3 5B F3 68 89 5C 24 48 5C 24 58 FF 8D 5C 24 58 5B 83 C3 4C 75 F4 5A 8D 71 78 75 09 81 F3 EB FF 52 BA 01 00 83 EB FC 4A FF 71 0F 75 19 8B 5C 24 00 00 81 33 50 53 8B 1B 0F FF C6 75 1B 81 F3 EB 87 1C 24 8B 8B 04 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 58 EB FF F0 EB FF C0 83 E8 FD EB FF 30 E8 C9 00 00 00 89 E0 EB FF D0 EB FF 71 0F 83 C0 01 EB FF 70 F0 71 EE EB FA EB 83 C0 14 EB FF 70 ED }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_MASM32_: PEiD
{
    strings:
        $a = { EB 01 DB E8 02 00 00 00 86 43 5E 8D 1D D0 75 CF 83 C1 EE 1D 68 50 ?? 8F 83 EB 02 3D 0F 5A }
    condition:
        $a at pe.entry_point

}

rule EXE_Protector_137a: PEiD
{
    strings:
        $a = { 68 54 14 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 5C C3 4D EA 29 A6 D2 11 BB FF 44 45 53 54 00 00 00 00 00 00 00 00 01 00 00 00 00 00 B5 09 00 A0 70 72 66 45 6D 62 65 64 64 65 64 43 6F 64 65 }
    condition:
        $a at pe.entry_point

}

rule Gem_VDI_Image_graphics_file: PEiD
{
    strings:
        $a = { 00 01 00 ?? 00 ?? 00 01 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v114_v120_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 20 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1987_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? 9A ?? ?? ?? ?? B8 ?? ?? 50 9A ?? ?? ?? ?? 92 }
    condition:
        $a at pe.entry_point

}

rule Unknown_UPX_modifyer: PEiD
{
    strings:
        $a = { E8 02 00 00 00 CD 03 5A 81 C2 ?? ?? ?? ?? 81 C2 ?? ?? ?? ?? 89 D1 81 C1 3C 05 00 00 52 81 2A 33 53 45 12 83 C2 04 39 CA 7E F3 89 CA 8B 42 04 8D 18 29 02 BB 78 56 00 00 83 EA 04 3B 14 24 7D EC C3 }
    condition:
        $a at pe.entry_point

}

rule SC_Obfuscator_SuperCRacker: PEiD
{
    strings:
        $a = { 60 33 C9 8B 1D 00 ?? ?? ?? 03 1D 08 ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D 04 ?? ?? ?? 75 E7 A1 08 ?? ?? ?? 01 05 0C ?? ?? ?? 61 FF 25 0C }
    condition:
        $a at pe.entry_point

}

rule tElock_099c_Private_ECLIPSE_tE: PEiD
{
    strings:
        $a = { E9 3F DF FF FF 00 00 00 ?? ?? ?? ?? 04 ?? ?? 00 00 00 00 00 00 00 00 00 24 ?? ?? 00 14 ?? ?? 00 0C ?? ?? 00 00 00 00 00 00 00 00 00 31 ?? ?? 00 1C ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 }
        $b = { E9 3F DF FF FF 00 00 00 ?? ?? ?? ?? 04 ?? ?? 00 00 00 00 00 00 00 00 00 24 ?? ?? 00 14 ?? ?? 00 0C ?? ?? 00 00 00 00 00 00 00 00 00 31 ?? ?? 00 1C ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Noodlecrypt2_rsc: PEiD
{
    strings:
        $a = { EB 01 9A E8 76 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_for_Windows_1_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 33 ED 55 9A ?? ?? ?? ?? 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule ExeLock_v100_additional: PEiD
{
    strings:
        $a = { 06 8C C8 8E C0 BE ?? ?? 26 ?? ?? 34 ?? 26 ?? ?? 46 81 ?? ?? ?? 75 ?? 40 B3 ?? B3 ?? F3 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30x_3300_Thinstall_Inc: PEiD
{
    strings:
        $a = { CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 ?? ?? ?? 33 DB BA ?? ?? ?? ?? 43 33 C0 E8 19 01 ?? ?? 73 0E 8B 4D F8 E8 27 01 ?? ?? 02 45 F7 AA EB E9 E8 04 01 ?? ?? 0F 82 96 ?? ?? ?? E8 F9 ?? ?? ?? 73 5B B9 04 ?? ?? ?? E8 05 01 ?? ?? 48 74 DE 0F 89 ?? ?? ?? ?? E8 DF ?? ?? ?? 73 1B 55 BD ?? ?? ?? ?? E8 DF ?? ?? ?? 88 07 47 4D 75 F5 E8 C7 ?? ?? ?? 72 E9 5D }
    condition:
        $a at pe.entry_point

}

rule X_Hider_10_GlobaL_additional: PEiD
{
    strings:
        $a = { 85 D2 74 23 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 30 00 00 00 89 C2 58 52 8B 48 FC E8 48 FB FF FF 5A 58 EB 03 FF 42 F8 87 10 85 D2 74 13 8B 4A F8 49 7C 0D FF 4A F8 75 08 8D 42 F8 E8 5C FA FF FF C3 8D 40 00 85 C0 7E 24 50 83 C0 0A 83 E0 FE 50 E8 2F FA FF FF }
    condition:
        $a at pe.entry_point

}

rule RLPack_10_beta_ap0x_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 F9 01 00 00 89 85 48 02 00 00 5B FF B5 48 02 00 00 56 FF D3 83 C4 08 8B B5 48 02 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 83 C0 04 89 85 44 02 00 00 EB 7A 56 FF 95 F1 01 00 00 89 85 40 02 00 00 8B C6 EB 4F 8B 85 44 02 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 44 02 00 00 C7 00 20 20 20 00 EB 06 FF B5 44 02 00 00 FF B5 40 02 00 00 FF 95 F5 01 00 00 89 07 83 C7 04 8B 85 44 02 00 00 EB 01 40 80 38 00 75 FA 40 89 85 44 02 00 00 80 38 00 75 AC EB 01 46 80 3E 00 75 FA 46 40 8B 38 83 C0 04 89 85 44 02 00 00 80 3E 01 75 81 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 48 02 00 00 FF 95 FD 01 00 00 61 68 ?? ?? ?? ?? C3 60 8B 74 24 24 8B 7C }
    condition:
        $a at pe.entry_point

}

rule NsPack_v37_North_Star_h_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 8D ?? ?? ?? FF 80 39 01 0F 84 42 02 00 00 C6 01 01 8B C5 2B 85 ?? ?? ?? FF 89 85 ?? ?? ?? FF 01 85 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 01 06 55 56 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? ?? FF 85 C0 0F 84 69 03 00 00 89 85 ?? ?? ?? FF E8 00 00 00 00 5B B9 67 03 00 00 03 D9 50 53 E8 B0 02 00 00 5E 5D 8B 36 8B FD 03 BD ?? ?? ?? FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 34 01 13 8B 33 03 7B 04 57 51 53 FF B5 ?? ?? ?? FF FF B5 ?? ?? ?? FF 8B D6 8B CF 8B 85 ?? ?? ?? FF 05 AA 05 00 00 FF D0 5B 59 5F 83 F9 00 74 05 83 C3 08 EB C7 68 00 80 00 00 6A 00 FF B5 ?? ?? ?? FF FF 95 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 00 74 14 8A 1A 38 1F 75 E9 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 EB 0A 8A 5F 04 86 C4 C1 C0 10 86 C4 2B C7 03 C6 89 07 83 C7 05 80 EB E8 8B C3 E2 C6 E8 3A 01 00 00 8D 8D }
    condition:
        $a at pe.entry_point

}

rule AntiDote_V12_SIS_Team_Sign_by_fly: PEiD
{
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 91 02 6D 61 6C 6C 6F 63 00 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 C5 02 73 74 72 73 74 72 00 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_131_dulekxt_additional: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80 A4 B6 80 FF D3 73 F9 33 C9 FF D3 73 16 33 C0 FF D3 73 23 B6 80 41 B0 10 FF D3 12 C0 73 FA 75 42 AA EB E0 E8 46 00 00 00 02 F6 83 D9 01 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 48 13 C9 EB }
    condition:
        $a at pe.entry_point

}

rule RCryptor_v16x_Vaska_additional: PEiD
{
    strings:
        $a = { 60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule Encriptor_v100c_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? B9 ?? ?? BE ?? ?? BF ?? ?? AC D0 C8 AA E2 ?? BE ?? ?? BF ?? ?? AC AA }
    condition:
        $a at pe.entry_point

}

rule Anskya_Binder_v11_Anskya_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? 00 83 C6 01 FF E6 00 00 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? 02 ?? ?? 00 10 00 00 00 02 00 }
    condition:
        $a at pe.entry_point

}

rule Hyings_PE_Armor_076_Hying_CCG_h: PEiD
{
    strings:
        $a = { 01 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 56 69 72 74 75 61 6C 46 72 65 65 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 61 ?? ?? ?? 59 ?? ?? ?? ?? 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 8D ?? ?? ?? ?? 00 00 00 00 00 00 00 9D ?? ?? ?? 8D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 5D 81 ED F0 00 00 00 8D B5 07 01 00 00 55 56 81 C5 ?? ?? ?? ?? 55 C3 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_p_Password_checking_Hint_DOS_EP_4_: PEiD
{
    strings:
        $a = { 03 05 80 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule Hyings_PE_Armor_075exe_Hying_CCG_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 00 ?? ?? 01 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 74 ?? ?? ?? 00 00 00 00 00 00 00 00 84 ?? ?? ?? 74 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 5D 81 ED D7 00 00 00 8D B5 EE 00 00 00 55 56 81 C5 ?? ?? 00 00 55 C3 }
    condition:
        $a at pe.entry_point

}

rule PE_password_protector_by_SMT: PEiD
{
    strings:
        $a = { E8 04 00 00 00 8B EC 5D C3 33 C0 5D 8B FD 81 ED 33 26 40 00 81 EF 00 00 00 00 83 EF 05 89 AD 88 27 40 00 8D 9D 07 29 40 00 8D B5 62 28 40 00 46 80 3E 00 74 24 56 FF 95 9D 29 40 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 A1 29 40 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_V031_emadicius: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? C7 87 ?? ?? ?? ?? ?? ?? ?? ?? 57 83 CD FF EB 0E ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B }
        $b = { 60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Armadillo_v260b1_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 50 ?? ?? ?? 68 74 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 FC }
    condition:
        $a at pe.entry_point

}

rule DShield: PEiD
{
    strings:
        $a = { 06 E8 ?? ?? 5E 83 EE ?? 16 17 9C 58 B9 ?? ?? 25 ?? ?? 2E }
    condition:
        $a at pe.entry_point

}

rule Celsius_Crypt_21_Z3r0: PEiD
{
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 84 92 44 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 84 92 44 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D C4 92 44 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D AC 92 44 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 77 C2 00 00 90 90 90 90 90 90 90 55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3 }
        $b = { 55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_v031_beta_Dwing: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 31 }
    condition:
        $a at pe.entry_point

}

rule SEA_AXE_v22_additional: PEiD
{
    strings:
        $a = { FC BC ?? ?? 0E 1F A3 ?? ?? E8 ?? ?? A1 ?? ?? 8B ?? ?? ?? 2B C3 8E C0 B1 03 D3 E3 8B CB BF ?? ?? 8B F7 F3 A5 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_FSG_131_Anorganix: PEiD
{
    strings:
        $a = { BE 90 90 90 00 BF 90 90 90 00 BB 90 90 90 00 53 BB 90 90 90 00 B2 80 }
    condition:
        $a at pe.entry_point

}

rule Pelles_C_280_290_EXE_X86_CRT_LIB_additional: PEiD
{
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 ?? E8 ?? ?? ?? ?? 59 A3 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_vxx_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 CE FD }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_LCC_Win32_DLL_Anorganix: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V1X_NoCompression_SecureEngine_Oreans_Technologies: PEiD
{
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? ?? ?? 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Escargot_01_final_ppMeat_additional: PEiD
{
    strings:
        $a = { EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 }
    condition:
        $a at pe.entry_point

}

rule MPRESS_V200_V20X_MATCODE_Software_20090423: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 05 ?? ?? ?? ?? 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 51 49 8A 44 39 06 88 04 31 75 F6 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v20_additional: PEiD
{
    strings:
        $a = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2C }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Automatic_Protection_v640_Safenet: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 }
        $b = { A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 }
        $c = { 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE FF DF 3F 0D 01 00 20 00 A3 ?? ?? ?? ?? 33 C0 50 C7 04 85 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 83 F8 64 7C ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 A1 ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? 66 8B 55 00 83 C5 08 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Obsidium_1311_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 27 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 22 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 03 ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1341_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 C3 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32_Berczi_Gabor_Pierre_Muller_Peter_Vreman: PEiD
{
    strings:
        $a = { 55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_v30_1985_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 90 90 CD AB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 38 35 }
    condition:
        $a at pe.entry_point

}

rule UPX_030_EXE: PEiD
{
    strings:
        $a = { 8C CB B9 00 00 BE 00 00 89 F7 1E A9 B5 80 8D 87 05 00 8E D8 05 00 00 8E C0 FD F3 A5 FC 2E 80 6C 13 10 73 E8 AF AD 0E 0E 0E 06 1F 07 16 68 00 00 BD FF FF F7 E1 93 CB 55 50 58 21 04 03 02 07 }
    condition:
        $a at pe.entry_point

}

rule Lattice_C_v101_additional: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 05 ?? ?? B1 ?? D3 E8 8C CB 03 C3 8E D8 8E D0 26 ?? ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 ?? D3 E3 EB }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v123_RC4_build_0807_exe_Alexey_Solodovnikov_h_additional: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule PEBundle_015_Jeremy_Collake: PEiD
{
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 6A 04 68 00 10 00 00 68 00 02 00 00 6A 00 FF 95 A8 33 40 00 0B C0 0F 84 F6 01 00 00 89 85 2E 33 40 00 83 BD E8 32 40 00 01 74 0D 83 BD E4 32 40 00 01 74 2A }
    condition:
        $a at pe.entry_point

}

rule Vx_Eddie2000_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? FC 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 50 06 56 1E 8B FE 33 C0 50 8E D8 C5 ?? ?? ?? B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v212: PEiD
{
    strings:
        $a = { 60 E8 03 ?? ?? ?? E9 EB 04 5D 45 55 C3 E8 }
        $b = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_v211: PEiD
{
    strings:
        $a = { 60 E8 02 ?? ?? ?? EB 09 5D 55 81 ED 39 39 44 ?? C3 E9 3D }
        $b = { 60 E9 3D 04 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule RLPack_v118_Basic_DLL_aPLib: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
        $b = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ExeCode_100_COM: PEiD
{
    strings:
        $a = { 8B E8 BA 4C 01 B4 09 CD 21 2E A1 09 01 8C C3 03 C3 B1 02 2E 8B 1E 0F 01 F7 C3 03 00 74 03 83 C3 03 D3 EB 2E 89 1E 19 01 BE 09 01 BF F0 01 B9 09 00 F3 A5 03 C3 05 2D 00 8E C0 05 0E 00 03 C3 FA 8E D0 BC 00 02 FB 1E 8C D8 05 1F 00 8E D8 2E 8B }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2717_V2719_Jitit: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 C1 FE FF FF E9 97 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_PC_Guard_4xx_emadicius_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 }
    condition:
        $a at pe.entry_point

}

rule Crypto_Lock_V202_Eng_Ryan_Thian: PEiD
{
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 }
        $b = { 60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPXHiT_v001: PEiD
{
    strings:
        $a = { 94 BC ?? ?? ?? 00 B9 ?? 00 00 00 80 34 0C ?? E2 FA 94 FF E0 61 }
    condition:
        $a at pe.entry_point

}

rule nPack_v11_150_200_Beta_NEOx_additional: PEiD
{
    strings:
        $a = { 83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 }
    condition:
        $a at pe.entry_point

}

rule Password_Protector_for_the_UPX_030_g0d_additional: PEiD
{
    strings:
        $a = { C8 50 01 00 60 E8 EC 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 44 69 61 6C 6F 67 42 6F 78 49 6E 64 69 72 65 63 74 50 61 72 61 6D 41 00 53 65 6E 64 4D 65 73 73 61 67 65 41 00 45 6E 64 44 69 61 6C 6F 67 00 00 00 55 8B EC 57 BF 00 00 00 00 33 C0 81 6D 0C 10 01 00 00 75 03 40 EB 13 83 7D 0C 01 75 0D 66 83 7D 10 0B 75 0B FF 75 14 8F 47 E4 5F 5D C2 10 00 66 83 7D 10 02 77 F4 74 0E 8D 4F A0 51 6A 40 6A 0D FF 77 E4 FF 57 E8 50 FF 75 08 FF 57 EC EB DB 84 08 C8 90 00 00 00 00 01 00 64 00 64 00 64 00 14 00 00 00 00 00 45 00 6E 00 74 00 65 00 72 00 20 00 50 00 61 00 73 00 73 00 77 00 6F 00 72 00 64 00 00 00 A0 00 00 50 00 00 02 00 05 00 05 00 5A 00 0A 00 0B 00 FF FF 81 00 00 00 00 00 5E FC 8D BE AA FE FF FF 8D 86 }
    condition:
        $a at pe.entry_point

}

rule CryptEXE_10: PEiD
{
    strings:
        $a = { 50 FC 0E 1F 1E 07 BA 37 03 B4 09 CD 21 33 C9 8B FA 57 B4 00 CD 16 3C 1B 75 05 E8 E0 02 EB 35 3C 0D 74 36 3C 08 75 0A 80 F9 00 74 E6 FE C9 4F EB E1 3C 20 72 DD 3C EF 77 D9 80 F9 14 74 D4 3C 61 72 06 3C 7A 77 02 2C 20 AA FE C1 EB C5 BA 7E 03 }
    condition:
        $a at pe.entry_point

}

rule Scitech_Software_Display_Driver: PEiD
{
    strings:
        $a = { 56 42 45 41 46 2E 44 52 56 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ASPack_2xx_Heuristic_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        $a at pe.entry_point

}

rule PE_Diminisher_01_Teraphy_Phrozen_Crew: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B D5 81 ED A2 30 40 00 2B 95 91 33 40 00 81 EA 0B 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_12_Memory_Patch_additional: PEiD
{
    strings:
        $a = { E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        $a at pe.entry_point

}

rule BamBam_001: PEiD
{
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 FB ?? ?? 00 E8 6C FD FF FF B9 05 00 00 00 8B F3 BF FB ?? ?? 00 53 F3 A5 E8 8D 05 00 00 8B 3D 03 ?? ?? 00 A1 2B ?? ?? 00 66 8B 15 2F ?? ?? 00 B9 80 ?? ?? 00 2B CF 89 45 E8 89 0D 6B ?? ?? 00 66 89 55 EC 8B 41 3C 33 D2 03 C1 }
    condition:
        $a at pe.entry_point

}

rule ChinaProtect_dummy_SignByfly: PEiD
{
    strings:
        $a = { C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 56 8B ?? ?? ?? 6A 40 68 00 10 00 00 8D ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 89 30 83 C0 04 5E C3 8B 44 ?? ?? 56 8D ?? ?? 68 00 40 00 00 FF 36 56 E8 ?? ?? ?? ?? 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 5E C3 }
    condition:
        $a at pe.entry_point

}

rule Private_Personal_Packer_PPP_103_ConquestOfTroycom_additional: PEiD
{
    strings:
        $a = { E8 19 00 00 00 90 90 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_50: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 }
    condition:
        $a at pe.entry_point

}

rule UPolyX_03_by_delikon: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? 8B ?? B9 ?? ?? ?? ?? 80 }
        $b = { 8B ?? B9 ?? ?? ?? ?? 80 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule FSG_v110_Eng_dulekxt_Borland_Cue: PEiD
{
    strings:
        $a = { 23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB }
    condition:
        $a at pe.entry_point

}

rule PeCompact_2xx_BitSum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule HelpEXE_12: PEiD
{
    strings:
        $a = { FA 2E 8C 16 00 00 2E 89 26 00 00 8C C8 8E D0 8D 06 DC 00 89 C4 FB FC BE 81 00 AC 3C 20 74 FB 3C 3F 74 24 3C 2F 75 05 AC 3C 3F 74 1B 8C D8 05 10 00 2E 01 06 00 00 FA 2E 8E 16 00 00 2E 8B 26 00 00 FB 2E FF 2E 00 00 0E 1F BA 00 00 B4 09 CD 21 }
    condition:
        $a at pe.entry_point

}

rule aPack_v098_m: PEiD
{
    strings:
        $a = { 1E 06 8C C8 8E D8 05 ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B2 ?? BD ?? ?? 33 C9 50 A4 BB ?? ?? 3B F3 76 }
    condition:
        $a at pe.entry_point

}

rule NeoLite_v200_additional: PEiD
{
    strings:
        $a = { E9 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v190b4_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 08 E2 40 00 68 B4 96 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule RTPatch_software_update_package_data_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4B 2A }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v302_v302a_Extractable_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 33 C9 B1 ?? 51 06 06 BB ?? ?? 53 8C D3 }
    condition:
        $a at pe.entry_point

}

rule Vx_Necropolis1963_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 03 ?? ?? B8 00 12 CD 2F 3C FF B8 ?? ?? ?? ?? B4 4A BB 40 01 CD 21 ?? ?? FA 0E 17 BC ?? ?? E8 ?? ?? FB A1 ?? ?? 0B C0 }
    condition:
        $a at pe.entry_point

}

rule Adys_Glue_110: PEiD
{
    strings:
        $a = { 2E ?? ?? ?? ?? 0E 1F BF ?? ?? 33 DB 33 C0 AC }
    condition:
        $a at pe.entry_point

}

rule Borland_Pascal_v70_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E D8 8C ?? ?? ?? 8C D3 8C C0 2B D8 8B C4 05 ?? ?? C1 ?? ?? 03 D8 B4 ?? CD 21 0E }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_LCC_Win32_DLL_Anorganix: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V10X_V17X_DLL_Oreans_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? ?? ?? ?? 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 ?? 89 48 01 61 E9 }
        $b = { B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? ?? ?? ?? 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Exe_Shield_v27b: PEiD
{
    strings:
        $a = { EB 06 68 40 85 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 87 DD 8B 85 E6 90 40 00 01 85 33 90 40 00 66 C7 85 30 90 40 00 90 90 01 85 DA 90 40 00 01 85 DE 90 40 00 01 85 E2 90 40 00 BB 7B 11 00 00 03 9D EA 90 40 }
        $b = { EB 06 68 40 85 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 87 DD 8B 85 E6 90 40 00 01 85 33 90 40 00 66 C7 85 30 90 40 00 90 90 01 85 DA 90 40 00 01 85 DE 90 40 00 01 85 E2 90 40 00 BB 7B 11 00 00 03 9D EA 90 40 00 03 9D E6 90 40 00 53 8B C3 8B FB 2D AC 90 40 00 89 85 AD 90 40 00 8D B5 AC 90 40 00 B9 40 04 00 00 F3 A5 8B FB C3 BD 00 00 00 00 8B F7 83 C6 54 81 C7 FF 10 00 00 56 57 57 56 FF 95 DA 90 40 00 8B C8 5E 5F 8B C1 C1 F9 02 F3 A5 03 C8 83 E1 03 F3 A4 EB 26 D0 12 5B 00 AC 12 5B 00 48 12 5B 00 00 00 40 00 00 D0 5A 00 00 10 5B 00 87 DB 87 DB 87 DB 87 DB 87 DB 87 DB 87 DB 8B 0E B5 E6 90 40 07 56 03 76 EE 0F 18 83 C6 14 12 35 97 80 8D BD 63 39 0D B9 06 86 02 07 F3 A5 6A 04 68 06 10 12 1B FF B5 51 29 EE 10 22 95 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule SLR_OPTLINK_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BF ?? ?? 8E DF FA 8E D7 81 C4 ?? ?? FB B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule eXpressor_v13x: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 58 53 56 57 83 65 DC ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 }
    condition:
        $a at pe.entry_point

}

rule DIET_v100d_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC 06 1E 0E 8C C8 01 ?? ?? ?? BA ?? ?? 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_430a_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 41 4E 53 49 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 73 27 20 61 6E 64 20 27 25 73 27 00 00 00 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 55 4E 49 43 }
        $b = { 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 41 4E 53 49 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 73 27 20 61 6E 64 20 27 25 73 27 00 00 00 44 64 65 44 61 74 61 20 69 6E 69 74 69 61 6C 69 7A 65 64 20 28 55 4E 49 43 4F 44 45 29 2C 20 61 70 70 20 73 74 72 69 6E 67 73 20 61 72 65 20 27 25 53 27 20 61 6E 64 20 27 25 53 27 00 00 00 00 50 75 74 53 74 72 69 6E 67 28 27 25 73 27 29 00 47 65 74 53 74 72 69 6E 67 28 29 2C 20 66 61 6C 73 65 00 00 47 65 74 53 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Adlib_Sample_Audio_file_additional: PEiD
{
    strings:
        $a = { 47 4F 4C 44 20 53 41 4D 50 4C 45 }
    condition:
        $a at pe.entry_point

}

rule kryptor_5_additional: PEiD
{
    strings:
        $a = { E8 03 ?? ?? ?? E9 EB 68 58 33 D2 74 02 E9 E9 40 42 75 02 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_620_Anorganix: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 55 8B EC 83 EC 50 53 56 57 BE 90 90 90 90 8D 7D F4 A5 A5 66 A5 8B }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v50v60_MFC: PEiD
{
    strings:
        $a = { 55 8B EC ?? }
        $b = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ORiEN_v211_212_Fisun_Alexander_additional: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D 20 2D 0D 0A 2D 2D 2D 2D 2D 2D 20 43 72 65 61 74 65 64 20 62 79 20 41 2E 20 46 69 73 75 6E 2C 20 31 39 39 34 2D 32 30 30 33 20 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 20 57 57 57 3A 20 68 74 74 70 3A 2F 2F 7A 61 6C 65 78 66 2E 6E 61 72 6F 64 2E 72 75 2F 20 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 20 65 2D 6D 61 69 6C 3A 20 7A 61 6C 65 78 66 40 68 6F 74 6D 61 69 6C 2E 72 75 20 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D }
    condition:
        $a at pe.entry_point

}

rule Vx_TrojanTelefoon_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 60 1E E8 3B 01 BF CC 01 2E 03 3E CA 01 2E C7 05 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_123_RC4_build_0807_exe_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Maked_by_Graphic_WorkShops_Self_Displayer_v60_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? 2E C7 ?? ?? ?? ?? ?? B8 ?? ?? A9 ?? ?? 74 ?? 25 ?? ?? BB ?? ?? 2B D8 43 2E 01 1E ?? ?? E8 ?? ?? 3D }
    condition:
        $a at pe.entry_point

}

rule IProtect_10_FxSubdll_mode_by_FuXdas: PEiD
{
    strings:
        $a = { EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 53 75 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED B6 13 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 A8 13 40 00 8D 85 81 13 40 00 50 FF B5 A8 13 40 00 E8 92 00 00 00 0B C0 74 13 89 85 A4 13 40 00 8D 85 8E 13 40 00 50 FF 95 A4 13 40 00 8B 85 AC 13 40 00 89 44 24 1C 61 FF E0 8B 7C 24 04 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 81 E7 00 00 FF FF 66 81 3F 4D 5A 75 0F 8B F7 03 76 3C 81 3E 50 45 00 00 75 02 EB 17 81 EF 00 00 01 00 81 FF 00 00 00 70 73 07 BF 00 00 F7 BF EB 02 EB D3 97 64 8F 05 00 00 00 00 83 C4 04 C2 04 00 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 8B 74 24 0C 66 81 3E 4D 5A 74 05 E9 8A 00 00 00 03 76 3C 81 3E 50 45 00 00 74 02 EB 7D 8B 7C 24 10 B9 96 00 00 00 32 C0 F2 AE 8B CF 2B 4C 24 10 8B 56 78 03 54 24 0C 8B 5A 20 03 5C 24 0C 33 C0 8B 3B 03 7C 24 0C 8B 74 24 10 51 F3 A6 75 05 83 C4 04 EB 0A 59 83 C3 04 40 3B 42 18 75 E2 3B 42 18 75 02 EB 35 8B 72 24 03 74 24 0C 52 BB 02 00 00 00 33 D2 F7 E3 5A 03 C6 33 C9 66 8B 08 8B 7A 1C 33 D2 BB 04 00 00 00 8B C1 F7 E3 03 44 24 0C 03 C7 8B 00 03 44 24 0C EB 02 33 C0 64 8F 05 00 00 00 00 83 C4 04 C2 08 00 E8 B5 FA FF FF }
        $b = { EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 53 75 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED B6 13 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 A8 13 40 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Nullsoft_PIMP_Install_System_v1x_additional: PEiD
{
    strings:
        $a = { 83 EC 5C 53 55 56 57 FF 15 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60_DLL_additional: PEiD
{
    strings:
        $a = { 8B 44 ?? 08 }
    condition:
        $a at pe.entry_point

}

rule Windows_Type_1_font_metric_file: PEiD
{
    strings:
        $a = { 00 01 ?? ?? 00 00 43 6F 70 79 72 69 67 68 74 20 }
    condition:
        $a at pe.entry_point

}

rule SLVc0deProtector_v11_SLV_h: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 C6 00 EB C6 40 01 08 FF E0 E9 4C }
        $b = { E8 01 00 00 00 A0 5D EB 01 69 81 ED 5F 1A 40 00 8D 85 92 1A 40 00 F3 8D 95 83 1A 40 00 8B C0 8B D2 2B C2 83 E8 05 89 42 01 E8 FB FF FF FF 69 83 C4 08 E8 06 00 00 00 69 E8 F2 FF FF FF F3 B9 05 00 00 00 51 8D B5 BF 1A 40 00 8B FE B9 58 15 00 00 AC 32 C1 F6 D0 EB 01 00 D0 C0 FE C8 02 C1 AA E2 EF 59 E2 DE B7 FE AB E1 24 C8 0C 88 7A E1 B1 6A F7 95 83 1B A8 7F F8 A8 B0 1A 8B 08 91 47 6C 5A 88 6C 65 39 85 DB CB 54 3D B9 24 CF 4C AE C6 63 74 2C 63 F0 C8 18 0B 97 6B 79 63 A8 AB B8 78 A9 30 2F 2B DA 18 AC 35 45 36 BC 0D 7D 24 D1 51 3C E6 34 11 5A 43 06 24 89 FA 74 30 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule TMT_Pascals_Unit_file: PEiD
{
    strings:
        $a = { 50 00 00 00 53 50 46 50 }
    condition:
        $a at pe.entry_point

}

rule MEGALITE_v120a_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 2D 73 ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 90 }
    condition:
        $a at pe.entry_point

}

rule EmbedPE_v124_cyclotron_additional: PEiD
{
    strings:
        $a = { 83 EC 50 60 68 ?? ?? ?? ?? E8 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule PEiD_Bundle_V102_DLL_BoB_BobSoft: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 9C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 00 08 00 39 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_0896_PE_DLL: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 00 00 00 00 60 BE 1A 00 00 00 8D BE E6 00 00 FF 57 83 CD FF EB 0D 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC }
    condition:
        $a at pe.entry_point

}

rule XPack_167_EXE: PEiD
{
    strings:
        $a = { B8 8C D3 15 33 75 81 3E E8 0F 00 9A E8 F9 FF 9A 9C EB 01 9A 59 80 CD 01 51 9D EB 01 9A 1E 0E 1F 8B EC EB 01 9A FA 33 DB 8E D3 BC 04 00 8F 06 EA 03 8F 06 EF 03 EB 01 9A 0E BE E2 03 56 5E 17 8B E5 83 C4 10 FB 1F 59 E8 C6 FF 33 DB 1E 8E DB C7 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E }
    condition:
        $a at pe.entry_point

}

rule Vx_KBDflags1024_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 8B EC 2E 89 2E 24 03 BC 00 04 8C D5 2E 89 2E 22 }
    condition:
        $a at pe.entry_point

}

rule SecurePE_1X: PEiD
{
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3 }
        $b = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CopyMinder_MicrocosmLtd_additional: PEiD
{
    strings:
        $a = { 83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 }
    condition:
        $a at pe.entry_point

}

rule PCPEC_alpha_preview_additional: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 00 }
    condition:
        $a at pe.entry_point

}

rule yzPack_10_UsAr: PEiD
{
    strings:
        $a = { 60 33 C0 8D 48 07 50 E2 FD 8B EC 64 8B 40 30 78 0C 8B 40 0C }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_v29_Exeshield_Corp: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0B 20 40 00 B9 EB 08 00 00 8D BD 53 20 40 00 8B F7 AC }
    condition:
        $a at pe.entry_point

}

rule BDC_HelpSystem_Help_file_additional: PEiD
{
    strings:
        $a = { 42 44 43 20 48 65 6C 70 53 79 73 74 65 6D }
    condition:
        $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig1_additional: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? FF 5D E9 D6 FE FF FF CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule muckis_protector_mucki: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 E9 }
    condition:
        $a at pe.entry_point

}

rule Pksmart_10b: PEiD
{
    strings:
        $a = { BA ?? ?? 8C C8 8B C8 03 C2 81 ?? ?? ?? 51 B9 ?? ?? 51 1E 8C D3 }
    condition:
        $a at pe.entry_point

}

rule XCompXPack_V097_V098_JoKo_20080219: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 9C 60 E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 }
    condition:
        $a at pe.entry_point

}

rule XCompXPack_V097_V098_JoKo_20080218: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? 9C 60 E8 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 }
    condition:
        $a at pe.entry_point

}

rule PENightMare_2_Beta_additional: PEiD
{
    strings:
        $a = { 60 E9 ?? ?? ?? ?? EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_LCC_Win32_1x_Anorganix: PEiD
{
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PENightMare_2_Beta_Anorganix: PEiD
{
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A E9 }
    condition:
        $a at pe.entry_point

}

rule SC_Obfuscator_SuperCRacker_additional: PEiD
{
    strings:
        $a = { 60 33 C9 8B 1D 00 ?? ?? ?? 03 1D 08 ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D 04 ?? ?? ?? 75 E7 A1 08 ?? ?? ?? 01 05 0C ?? ?? ?? 61 FF 25 0C }
    condition:
        $a at pe.entry_point

}

rule COMPACK_v45_2: PEiD
{
    strings:
        $a = { BE ?? ?? E8 ?? ?? 5D 83 ?? ?? 55 50 53 51 52 0E 07 0E 1F 8B CE }
    condition:
        $a at pe.entry_point

}

rule AZProtect_0001_by_AlexZ_aka_AZCRC: PEiD
{
    strings:
        $a = { EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 60 BE 00 ?? ?? 00 BF 00 00 40 00 EB 17 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 00 00 FF 25 ?? ?? ?? 00 8B C6 03 C7 8B F8 57 55 8B EC 05 7F 00 00 00 50 E8 E5 FF FF FF BA 8C ?? ?? 00 89 02 E9 1A 01 00 00 ?? 00 00 00 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 47 65 74 56 6F 6C 75 6D 65 49 6E 66 6F 72 6D 61 74 69 6F 6E 41 00 4D 65 73 73 61 67 65 42 6F 78 41 00 45 78 69 74 50 72 6F 63 65 73 73 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 }
        $b = { FC 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 8B C2 C1 C0 10 66 8B C1 C3 F0 DA 55 8B EC 53 56 33 C9 33 DB 8B 4D 0C 8B 55 10 8B 75 08 4E 4A 83 FB 08 72 05 33 DB 43 EB 01 43 33 C0 8A 04 31 8A 24 13 2A C4 88 04 31 E2 E6 5E 5B C9 C2 0C }
        $c = { FC 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 8B C2 C1 C0 10 66 8B C1 C3 F0 DA 55 8B EC 53 56 33 C9 33 DB 8B 4D 0C 8B 55 10 8B 75 08 4E 4A 83 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule NoodleCrypt_v20_NoodleSpa: PEiD
{
    strings:
        $a = { EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 }
    condition:
        $a at pe.entry_point

}

rule Blade_Joiner_v15: PEiD
{
    strings:
        $a = { 55 8B EC 81 C4 E4 FE FF FF 53 56 57 33 C0 89 45 F0 89 85 }
    condition:
        $a at pe.entry_point

}

rule Alias_PIXVivid_IMG_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v25_Retail_Bitsum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_120b: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? 00 2B 05 84 ?? ?? 00 A3 ?? ?? ?? 00 83 3D ?? ?? ?? 00 00 74 16 A1 ?? ?? ?? 00 03 05 80 ?? ?? 00 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? 00 01 00 00 00 68 04 }
    condition:
        $a at pe.entry_point

}

rule Ding_Boys_PE_lock_Phantasm_12_Ding_Boy: PEiD
{
    strings:
        $a = { 55 57 56 52 51 53 9C FA 90 E8 00 00 00 00 5D 8B D5 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Stelth_PE_101: PEiD
{
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 BA ?? ?? ?? ?? FF E2 BA E0 10 40 00 B8 68 24 1A 40 89 02 83 C2 03 B8 40 00 E8 EE 89 02 83 C2 FD FF E2 2D 3D 5B 20 48 69 64 65 50 45 20 5D 3D 2D 90 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule nbuild_v10_soft_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B9 ?? ?? BB ?? ?? C0 ?? ?? 80 ?? ?? 43 E2 }
    condition:
        $a at pe.entry_point

}

rule Vx_August_16th_Iron_Maiden_additional: PEiD
{
    strings:
        $a = { BA 79 02 03 D7 B4 1A CD 21 B8 24 35 CD 21 5F 57 89 9D 4E 02 8C 85 50 02 }
    condition:
        $a at pe.entry_point

}

rule Compiled_InstallSHIELD_Installation_Script_Hint_FILE_START: PEiD
{
    strings:
        $a = { B8 C9 0C 00 }
    condition:
        $a at pe.entry_point

}

rule fasm_Tomasz_Grysztar_flat_additional: PEiD
{
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 ?? 2B 8D EE 32 40 00 83 E9 0B 89 8D F2 32 40 ?? 80 BD D1 32 40 ?? 01 0F 84 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_500_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 }
    condition:
        $a at pe.entry_point

}

rule Banners_font_file: PEiD
{
    strings:
        $a = { AB CD 00 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_v03_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 }
    condition:
        $a at pe.entry_point

}

rule ASPack_101b_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED D2 2A 44 00 B8 CC 2A 44 00 03 C5 2B 85 A5 2E 44 00 89 85 B1 2E 44 00 80 BD 9C 2E 44 }
    condition:
        $a at pe.entry_point

}

rule yzpack_112_UsAr: PEiD
{
    strings:
        $a = { 5A 52 45 60 83 EC 18 8B EC 8B FC 33 C0 64 8B 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 8B 40 34 83 C0 7C 8B 40 3C AB E9 ?? ?? ?? ?? B4 09 BA 00 00 1F CD 21 B8 01 4C CD 21 40 00 00 00 50 45 00 00 4C 01 02 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 E0 00 ?? ?? 0B 01 ?? ?? ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule eXpressor_Version_1501: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 50 02 00 00 53 56 57 83 A5 D0 FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PESHiELD_025_Anorganix: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC E9 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V071_cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22008618_WFS_20080626: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 43 72 65 61 74 65 46 69 6C 65 41 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 32 32 30 30 38 30 36 31 38 2E 45 50 45 00 00 00 45 6E 63 72 79 70 74 50 45 5F 49 6E 69 74 00 }
    condition:
        $a at pe.entry_point

}

rule ExeJoiner_V10_Yoda_f2f_additional: PEiD
{
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Intro_10: PEiD
{
    strings:
        $a = { 8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A E9 }
    condition:
        $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp_additional: PEiD
{
    strings:
        $a = { 0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt_Watcom_CCpp_EXE_: PEiD
{
    strings:
        $a = { EB 02 CD 20 03 ?? 8D ?? 80 ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 }
    condition:
        $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig1: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? FF 5D E9 D6 FE FF FF CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig2: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 0F 84 ?? ?? 00 00 83 FE 01 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2422_V2428_Jitit: PEiD
{
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D 9B 1A 00 00 B9 84 1A 00 00 BA 14 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD E0 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        $a at pe.entry_point

}

rule ZProtect_v146_lifeengines: PEiD
{
    strings:
        $a = { 87 ?? ?? ?? ?? ?? ?? ?? ?? 87 ?? ?? E9 ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Launcher_Generator_v103: PEiD
{
    strings:
        $a = { 68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00 }
        $b = { 68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00 74 51 C1 E0 02 A3 5C 20 40 00 BB 70 21 40 00 03 C3 8B 18 68 60 20 40 00 53 B8 F0 21 40 00 03 05 5C 20 40 00 8B D8 8B 03 05 70 20 40 00 50 B8 70 22 40 00 03 05 5C 20 40 00 FF 30 FF 35 00 20 40 00 E8 26 00 00 00 A1 58 20 40 00 40 A3 58 20 40 00 EB A2 6A FF E8 00 00 00 00 FF 25 5C 30 40 00 FF 25 60 30 40 00 FF 25 64 30 40 00 FF 25 68 30 40 00 FF 25 6C 30 40 00 FF 25 74 30 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Aspack_v212_wwwaspackcom: PEiD
{
    strings:
        $a = { ?8 ?? ?0 00 ?? ?? ?? ?? ?D ?? ?? ?? ?? ?? ?? ?? ?? ?? 5? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F ?? ?? ?3 ?? ?? ?? 8? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?F 95 ?? ?? ?? ?? 8? }
    condition:
        $a at pe.entry_point

}

rule Vx_VCL_encrypted: PEiD
{
    strings:
        $a = { 01 B9 ?? ?? 81 34 ?? ?? 46 46 E2 F8 C3 }
    condition:
        $a at pe.entry_point

}

rule MEW_10_Northfox: PEiD
{
    strings:
        $a = { 33 C0 E9 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_PESHiELD_025_Anorganix_additional: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC E9 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Microsoft_Visual_Cue_60_Debug_Version: PEiD
{
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 10 01 90 90 90 90 90 90 90 90 E8 00 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 E9 }
    condition:
        $a at pe.entry_point

}

rule AutoDesk_Animation_file: PEiD
{
    strings:
        $a = { ?? ?? ?? 00 12 AF ?? ?? 40 01 C8 }
        $b = { 00 12 AF ?? ?? 40 01 C8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_v2xx_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        $a at pe.entry_point

}

rule Rec_032: PEiD
{
    strings:
        $a = { 06 1E 52 B8 02 30 1E CD 21 86 E0 3D FE 02 73 02 CD 20 0E 1F B4 09 E8 03 00 24 24 EA 5A CD 21 EB 02 D8 88 1F 5A B4 30 CD 21 3C 03 73 02 CD 20 3C 03 73 02 33 C0 BF 01 02 8B 03 90 2B F7 90 BF 06 07 B9 01 02 53 BB EB 04 5B EB FB 9A EB 2D FE 20 }
    condition:
        $a at pe.entry_point

}

rule Thunderbolt_V002_deXep_forgot_SignByfly_additional: PEiD
{
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 E8 AA 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule CALS_Raster_graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 73 72 63 64 6F 63 69 64 3A 20 }
    condition:
        $a at pe.entry_point

}

rule Upack_V036_V037_DLL_Dwing_additional: PEiD
{
    strings:
        $a = { 0B 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 10 00 00 10 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 02 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 14 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 }
    condition:
        $a at pe.entry_point

}

rule Reg2Exe_225_by_Jan_Vorel: PEiD
{
    strings:
        $a = { 68 68 00 00 00 68 00 00 00 00 68 70 7D 40 00 E8 AE 20 00 00 83 C4 0C 68 00 00 00 00 E8 AF 52 00 00 A3 74 7D 40 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 9C 52 00 00 A3 70 7D 40 00 E8 24 50 00 00 E8 E2 48 00 00 E8 44 34 00 00 E8 54 28 00 00 E8 98 27 00 00 E8 93 20 00 00 68 01 00 00 00 68 D0 7D 40 00 68 00 00 00 00 8B 15 D0 7D 40 00 E8 89 8F 00 00 B8 00 00 10 00 68 01 00 00 00 E8 9A 8F 00 00 FF 35 A4 7F 40 00 68 00 01 00 00 E8 3A 23 00 00 8D 0D A8 7D 40 00 5A E8 5E 1F 00 00 FF 35 A8 7D 40 00 68 00 01 00 00 E8 2A 52 00 00 A3 B4 7D 40 00 FF 35 A4 7F 40 00 FF 35 B4 7D 40 00 FF 35 A8 7D 40 00 E8 5C 0C 00 00 8D 0D A0 7D 40 00 5A E8 26 1F 00 00 FF 35 }
        $b = { 68 68 00 00 00 68 00 00 00 00 68 70 7D 40 00 E8 AE 20 00 00 83 C4 0C 68 00 00 00 00 E8 AF 52 00 00 A3 74 7D 40 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 9C 52 00 00 A3 70 7D 40 00 E8 24 50 00 00 E8 E2 48 00 00 E8 44 34 00 00 E8 54 28 00 00 E8 98 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Virogens_PE_Shrinker_v014_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 9C 55 E8 ?? ?? ?? ?? 87 D5 5D 60 87 D5 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 57 56 AD 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_WAV_Audio_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 57 41 56 45 66 6D 74 }
    condition:
        $a at pe.entry_point

}

rule ASYLUM_Music_File_v10_Hint_FILE_START: PEiD
{
    strings:
        $a = { 41 53 59 4C 55 4D 20 4D 75 73 69 63 20 46 6F 72 6D 61 74 20 56 31 2E 30 00 }
    condition:
        $a at pe.entry_point

}

rule UPolyX_0x_Delikon_additional: PEiD
{
    strings:
        $a = { 81 FD 00 FB FF FF 83 D1 ?? 8D 14 2F 83 FD FC 76 ?? 8A 02 42 88 07 47 49 75 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_ZCode_101_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 E9 12 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E9 FB FF FF FF C3 68 00 00 00 00 64 FF 35 }
    condition:
        $a at pe.entry_point

}

rule FreePascal_200_Win32: PEiD
{
    strings:
        $a = { C6 05 ?? ?? ?? ?? 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
        $b = { C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule InterGraph_Graphics_format: PEiD
{
    strings:
        $a = { 08 09 FE 01 18 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKTINY_v10_with_TINYPROG_v38: PEiD
{
    strings:
        $a = { 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? E9 ?? ?? E8 ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule PE_Protector_V260hyings_PE_Armor_V0460_modify_Engprog_SignByfly_additional: PEiD
{
    strings:
        $a = { 55 53 51 52 56 57 E8 E1 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_2628_Jtit_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 BB 34 1D 00 00 2B C3 50 68 00 00 40 00 68 00 40 00 00 68 BC 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 }
    condition:
        $a at pe.entry_point

}

rule Goldeds_Output_text_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { C4 20 5B }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v2xx_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 F0 67 4D 00 68 50 92 4B 00 64 A1 }
    condition:
        $a at pe.entry_point

}

rule aPack_v082_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 1E 06 8C CB BA ?? ?? 03 DA 8D ?? ?? ?? FC 33 F6 33 FF 48 4B 8E C0 8E DB }
    condition:
        $a at pe.entry_point

}

rule PrivateEXE_v20a: PEiD
{
    strings:
        $a = { 06 60 C8 ?? ?? ?? 0E 68 ?? ?? 9A ?? ?? ?? ?? 3D ?? ?? 0F ?? ?? ?? 50 50 0E 68 ?? ?? 9A ?? ?? ?? ?? 0E }
    condition:
        $a at pe.entry_point

}

rule Silicon_Realms_Install_Stub: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3 }
        $b = { 55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3 ?? ?? 40 00 33 F6 56 E8 ?? ?? 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 ?? ?? 00 00 FF 15 ?? 91 40 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8 ?? ?? FF FF 89 75 D0 8D 45 A4 50 FF 15 ?? 91 40 00 E8 ?? ?? 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 ?? 91 40 00 50 E8 ?? ?? FF FF 89 45 A0 50 E8 ?? ?? FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 ?? ?? 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 ?? ?? FF FF 83 3D ?? ?? 40 00 01 75 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_PE_Intro_10_Anorganix: PEiD
{
    strings:
        $a = { 8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A E9 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v100_v103: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 8C DB 03 D8 3B }
    condition:
        $a at pe.entry_point

}

rule Exe_Shield_v27b_additional: PEiD
{
    strings:
        $a = { 03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 }
    condition:
        $a at pe.entry_point

}

rule Freshbind_v20_gFresh_additional: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 89 E5 6A FF 68 10 30 40 00 68 9A 10 40 }
    condition:
        $a at pe.entry_point

}

rule Enigma_Protector_11X_13X_Sukhov_Vladimir_Serge_N_Markin_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 00 10 40 00 E8 01 00 00 00 9A 83 C4 10 8B E5 5D E9 }
    condition:
        $a at pe.entry_point

}

rule XPack_167_com: PEiD
{
    strings:
        $a = { E9 53 00 FF FD FF FB FF F9 FF BC 03 00 8B E5 4C 4C C3 }
    condition:
        $a at pe.entry_point

}

rule CRYPToCRACKs_PE_Protector_V092_Lukas_Fleischer: PEiD
{
    strings:
        $a = { E8 01 00 00 00 E8 58 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 37 84 DB 75 33 8B F3 03 ?? ?? 81 3E 50 45 00 00 75 26 }
    condition:
        $a at pe.entry_point

}

rule ass_crypter_by_santasdad: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B D8 53 E8 DC EA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 F0 97 00 10 E8 C9 E7 FF FF B8 F0 97 00 10 E8 B7 E7 FF FF 8B CF 8B D6 E8 EE EA FF FF 53 E8 98 EA FF FF 8D 4D EC BA 9C 51 00 10 A1 F0 97 00 10 E8 22 EB FF FF 8B 55 EC B8 F0 97 00 10 E8 89 E6 FF FF B8 F0 97 00 10 E8 7F E7 FF FF E8 6E EC FF FF 33 C0 5A 59 59 64 89 10 68 7F 51 00 10 8D 45 EC E8 11 E6 FF FF C3 E9 FF DF FF FF EB F0 5F 5E 5B E8 0D E5 FF FF 00 53 45 54 54 49 4E 47 53 00 00 00 00 FF FF FF FF 1C 00 00 00 45 4E 54 45 52 20 59 4F 55 52 20 4F 57 4E 20 50 41 53 53 57 4F 52 44 20 48 45 52 45 }
        $b = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule File_Analyzer_Compiled_Datafile_Version: PEiD
{
    strings:
        $a = { 46 69 6C 65 20 41 6E 61 6C 79 7A 65 72 20 43 6F 6D 70 69 6C 65 64 20 44 61 74 61 66 69 6C 65 20 56 65 72 73 69 6F 6E }
    condition:
        $a at pe.entry_point

}

rule MINI_COM: PEiD
{
    strings:
        $a = { B8 00 00 BA 00 00 3B C4 73 46 8B C4 2D 24 03 90 25 F0 FF 8B F8 B9 92 00 90 BE 6C 01 FC F3 A5 8B D8 B1 04 D3 EB 8C D9 03 D9 53 33 DB 53 CB 00 4D 49 4E 49 20 28 43 29 20 76 31 2E 30 31 20 62 79 20 41 6C 62 65 72 74 20 53 65 6E 20 31 39 39 32 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V12003318_V12003518_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 }
        $b = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Armadillo_v220_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 10 12 41 00 68 F4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule Upack_024_027_beta_028_alpha_Dwing_: PEiD
{
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 AD 91 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 }
    condition:
        $a at pe.entry_point

}

rule WebCops_EXE_LINK_Data_Security_additional: PEiD
{
    strings:
        $a = { EB 03 05 EB 02 EB FC 55 EB 03 EB 04 05 EB FB EB 53 E8 04 00 00 00 72 }
    condition:
        $a at pe.entry_point

}

rule DIET_v102b_v110a_v120_additional: PEiD
{
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 3B FC 72 ?? B4 4C CD 21 FD F3 A5 FC }
    condition:
        $a at pe.entry_point

}

rule Borland_Delphi: PEiD
{
    strings:
        $a = { C3 E9 FF 8D }
        $b = { 55 8B EC 83 C4 F4 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PE_Lock_NT_v204_MARQUISDESOIRE: PEiD
{
    strings:
        $a = { EB ?? CD ?? ?? ?? ?? ?? CD ?? ?? ?? ?? ?? EB ?? EB ?? EB ?? EB ?? CD ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 50 C3 }
    condition:
        $a at pe.entry_point

}

rule AEP_v100_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? E4 21 2E ?? ?? ?? 33 C0 8B D8 5D B9 ?? ?? 50 B8 ?? ?? E6 21 0F A9 E6 ?? 53 }
    condition:
        $a at pe.entry_point

}

rule AEP_100: PEiD
{
    strings:
        $a = { E4 21 2E A3 64 00 33 C0 8B D8 5D B9 00 01 50 B8 FF 03 E6 21 0F A9 E6 A1 53 8B DF E4 21 23 D8 4B 0F A1 4B 66 65 FF 37 83 EB 04 49 75 F6 2E C6 06 9C 00 CB 68 17 00 C3 F4 02 41 05 FF 3E E7 5F 32 25 8A 2D 8C C8 F5 FC 8C C0 C0 FE 8C D0 C2 FE FE }
    condition:
        $a at pe.entry_point

}

rule Name_of_the_Packer_v10: PEiD
{
    strings:
        $a = { 50 E8 ?? ?? ?? ?? 58 25 ?? F0 FF FF 8B C8 83 C1 60 51 83 C0 40 83 EA 06 52 FF 20 9D C3 }
    condition:
        $a at pe.entry_point

}

rule NoobyProtect_SE_Public_V109X_Nooby_20081218: PEiD
{
    strings:
        $a = { 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 72 33 32 2E 64 6C 6C 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 ?? ?? ?? ?? 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ComprEXE_10_COM: PEiD
{
    strings:
        $a = { FC 1E 06 8C DD 83 C5 10 89 E8 BA 00 00 8B 1E 02 00 29 D3 53 8E D8 8E C3 31 F6 31 FF B9 08 00 F3 A5 40 43 4A 75 EE B8 2B 00 50 CB 0E 1F BE 2A 01 B3 01 8E C5 31 FF 81 FF 00 80 72 0B 8C C0 05 00 08 8E C0 81 EF 00 80 E8 8A 00 74 08 B7 08 E8 9D }
    condition:
        $a at pe.entry_point

}

rule PE_Prot_09: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 00 00 00 00 58 83 C0 07 C6 00 C3 EA E8 00 00 00 00 5D 8B D5 81 ED 68 45 40 00 60 8D 9D AC 45 40 00 B9 1D 03 00 00 B2 00 33 C0 02 03 D2 0B E8 0B 00 00 00 0F 21 C7 28 13 EB 02 9A EA 80 33 C3 43 }
    condition:
        $a at pe.entry_point

}

rule Morphine_v27_Holy_Father_Ratter29A_h: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule N_Joiner_01_Asm_Version_NEX: PEiD
{
    strings:
        $a = { 6A 00 68 00 14 40 00 68 00 10 40 00 6A 00 E8 14 00 00 00 6A 00 E8 13 00 00 00 CC FF 25 AC 12 40 00 FF 25 B0 12 40 00 FF 25 B4 12 40 00 FF 25 B8 12 40 00 FF 25 BC 12 40 00 FF 25 C0 12 40 00 FF 25 C4 12 40 00 FF 25 C8 12 40 00 FF 25 CC 12 40 00 FF 25 D0 12 40 00 FF 25 D4 12 40 00 FF 25 D8 12 40 00 FF 25 DC 12 40 00 FF 25 E4 12 40 00 FF 25 EC 12 40 00 }
        $b = { 6A 00 68 00 14 40 00 68 00 10 40 00 6A 00 E8 14 00 00 00 6A 00 E8 13 00 00 00 CC FF 25 AC 12 40 00 FF 25 B0 12 40 00 FF 25 B4 12 40 00 FF 25 B8 12 40 00 FF 25 BC 12 40 00 FF 25 C0 12 40 00 FF 25 C4 12 40 00 FF 25 C8 12 40 00 FF 25 CC 12 40 00 FF 25 D0 12 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASPack_v2001_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 72 05 00 00 EB 4C }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_12_Seek_and_Destroy_Patch_additional: PEiD
{
    strings:
        $a = { 6A 00 E8 9B 02 00 00 A3 7A 33 40 00 6A 00 68 8E 10 40 00 6A 00 6A 01 50 E8 B5 02 00 00 68 5A 31 40 00 68 12 31 40 00 6A 00 6A 00 6A 04 6A 01 6A 00 6A 00 68 A2 30 40 00 6A 00 E8 51 02 00 00 85 C0 74 31 FF 35 62 31 40 00 6A 00 6A 30 E8 62 02 00 00 E8 0B 01 }
    condition:
        $a at pe.entry_point

}

rule CalComp_Graphics_format: PEiD
{
    strings:
        $a = { 02 50 0A }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v20: PEiD
{
    strings:
        $a = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 }
        $b = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2C }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_PENightMare_2_Beta_Anorganix: PEiD
{
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        $a at pe.entry_point

}

rule InstallShield_Custom_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC 44 56 FF 15 ?? ?? 41 00 8B F0 85 F6 75 08 6A FF FF 15 ?? ?? 41 00 8A 06 57 8B 3D ?? ?? 41 00 3C 22 75 1B 56 FF D7 8B F0 8A 06 3C 22 74 04 84 C0 75 F1 80 3E 22 75 15 56 FF D7 8B }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_42_2: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? C7 }
    condition:
        $a at pe.entry_point

}

rule Lattice_C_v101_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 05 ?? ?? B1 ?? D3 E8 8C CB 03 C3 8E D8 8E D0 26 ?? ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 ?? D3 E3 EB }
    condition:
        $a at pe.entry_point

}

rule iPBProtect_013: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 68 53 56 57 89 65 FA 33 DB 89 5D F8 6A 02 EB 01 F8 58 5F 5E 5B 64 8B 25 00 00 00 00 64 8F 05 00 00 00 00 58 58 58 5D 68 9F 6F 56 B6 50 E8 5D 00 00 00 EB FF 71 78 }
    condition:
        $a at pe.entry_point

}

rule QrYPt0r_by_NuTraL_additional: PEiD
{
    strings:
        $a = { EB 00 E8 B5 00 00 00 E9 2E 01 00 00 64 FF 35 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 64 89 25 00 00 00 00 8B 44 24 04 }
    condition:
        $a at pe.entry_point

}

rule Vx_FaxFreeTopo_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA 06 33 C0 8E C0 B8 ?? ?? 26 ?? ?? ?? ?? 50 8C C8 26 ?? ?? ?? ?? 50 CC 58 9D 58 26 ?? ?? ?? ?? 58 26 ?? ?? ?? ?? 07 FB }
    condition:
        $a at pe.entry_point

}

rule PolyCryptor_by_SMT_Version_v3v4_additional: PEiD
{
    strings:
        $a = { EB ?? 28 50 6F 6C 79 53 63 72 79 70 74 20 ?? ?? ?? 20 62 79 20 53 4D 54 29 }
    condition:
        $a at pe.entry_point

}

rule A_program_by_Jupiter_: PEiD
{
    strings:
        $a = { 2B C0 74 05 68 ?? ?? ?? ?? 50 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Basic_v50_v60: PEiD
{
    strings:
        $a = { 5A 68 68 52 E9 }
        $b = { FF 25 ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? FF FF FF }
        $c = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 00 00 ?? 00 00 00 30 ?? 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_02_CD_Cops_II_Anorganix: PEiD
{
    strings:
        $a = { 53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 }
    condition:
        $a at pe.entry_point

}

rule XXPack_01_bagie: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 00 68 00 ?? ?? ?? C3 }
    condition:
        $a at pe.entry_point

}

rule PELOCKnt_204: PEiD
{
    strings:
        $a = { EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_vxx_DLL_additional: PEiD
{
    strings:
        $a = { 9C 60 50 8D 88 00 ?? ?? ?? 8D 90 ?? ?? 00 00 8B DC 8B E1 68 00 00 ?? ?? 53 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 DA 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 72 04 03 7A 08 8B 0A F3 A5 83 C2 0C FC EB D4 8B 7A 08 03 F8 8B 5A 04 85 DB 74 13 52 53 57 03 02 50 E8 7B 00 00 00 85 C0 74 2E 5F 5F 58 5A 8B 4A 0C C1 F9 02 F3 AB 8B 4A 0C 83 E1 03 F3 AA 83 C2 10 EB A0 45 52 52 4F 52 21 00 43 6F 72 72 75 70 74 20 44 61 74 61 21 00 8B 64 24 24 8B 04 24 83 C4 26 8B D0 66 81 C2 6D 01 6A 10 8B D8 66 05 66 01 50 52 6A 00 8B 13 FF 14 1A 6A FF FF 93 ?? ?? 00 00 56 57 8B 7C 24 0C 8B 74 24 10 8B 4C 24 14 C1 F9 02 F3 A5 8B 4C 24 14 83 E1 03 F3 A4 5F 5E C3 }
    condition:
        $a at pe.entry_point

}

rule Windows_Group_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 50 4D 43 43 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_15_Vaska: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? ?? EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        $a at pe.entry_point

}

rule EXE32Pack_v136_additional: PEiD
{
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED DC 8D 40 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1200_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 28 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 02 ?? ?? 58 EB 03 ?? ?? ?? EB 01 ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 4F 26 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKLite_112_120_COM: PEiD
{
    strings:
        $a = { B8 00 00 BA 00 00 3B C4 73 67 8B C4 2D 44 03 25 F0 FF 8B F8 B9 A2 00 BE 7C 01 FC F3 A5 8B D8 B1 04 D3 EB 8C D9 03 D9 53 33 DB 53 CB 0C 01 50 4B 4C 49 54 45 20 43 6F 70 72 2E 20 31 39 39 31 20 }
    condition:
        $a at pe.entry_point

}

rule Enigma_protector_110111_Vladimir_Sukhov_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        $a at pe.entry_point

}

rule Pelles_C_2x_4x_DLL_Pelle_Orinius: PEiD
{
    strings:
        $a = { 55 89 E5 53 56 57 8B 5D 0C 8B 75 10 }
    condition:
        $a at pe.entry_point

}

rule Themida_Oreans_Technologies_2004: PEiD
{
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_Limited_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BE ?? ?? 8B 04 3D ?? ?? 74 ?? BA ?? ?? B4 09 CD 21 CD 20 }
    condition:
        $a at pe.entry_point

}

rule UPX_Protector_v10x_additional: PEiD
{
    strings:
        $a = { EB ?? ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB }
    condition:
        $a at pe.entry_point

}

rule FreePascal_104_Win32_Berczi_Gabor_Pierre_Muller_Peter_Vreman_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 B8 53 56 57 33 C0 89 45 F0 89 45 BC 89 45 B8 E8 73 71 FF FF E8 DA 85 FF FF E8 81 A7 FF FF E8 C8 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_22x_SoftComplete_Developement_additional: PEiD
{
    strings:
        $a = { 50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1 }
    condition:
        $a at pe.entry_point

}

rule MegaLite_120: PEiD
{
    strings:
        $a = { B8 00 00 BA 00 00 05 00 00 3B 2D 73 67 72 1B B4 09 BA 18 01 CD 21 CD 90 4E 6F 74 20 65 6E 6F 75 67 68 20 6D 65 6D 6F 72 79 24 2D 20 00 8E D0 2D 00 00 8E C0 50 B9 00 00 33 FF 56 BE 42 01 FC F2 A5 CA FD 8C DB 53 83 C3 00 03 DA 8C CD 8B C2 80 }
    condition:
        $a at pe.entry_point

}

rule NakedPacker_10_by_BigBoote: PEiD
{
    strings:
        $a = { 60 FC 0F B6 05 34 ?? ?? ?? 85 C0 75 31 B8 50 ?? ?? ?? 2B 05 04 ?? ?? ?? A3 30 ?? ?? ?? A1 00 ?? ?? ?? 03 05 30 ?? ?? ?? A3 38 ?? ?? ?? E8 9A 00 00 00 A3 50 ?? ?? ?? C6 05 34 ?? ?? ?? 01 83 3D 50 ?? ?? ?? 00 75 07 61 FF 25 38 ?? ?? ?? 61 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 40 ?? ?? ?? C3 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 48 ?? ?? ?? C3 8B 4C 24 04 56 8B 74 24 10 57 85 F6 8B F9 74 0D 8B 54 24 10 8A 02 88 01 }
        $b = { 60 FC 0F B6 05 34 ?? ?? ?? 85 C0 75 31 B8 50 ?? ?? ?? 2B 05 04 ?? ?? ?? A3 30 ?? ?? ?? A1 00 ?? ?? ?? 03 05 30 ?? ?? ?? A3 38 ?? ?? ?? E8 9A 00 00 00 A3 50 ?? ?? ?? C6 05 34 ?? ?? ?? 01 83 3D 50 ?? ?? ?? 00 75 07 61 FF 25 38 ?? ?? ?? 61 FF 74 24 04 6A 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule eXPressor_v15x_CGSoftLabs_h: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 58 02 00 00 53 56 57 83 A5 CC FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C 01 75 23 }
    condition:
        $a at pe.entry_point

}

rule Windows_9x_registry_file: PEiD
{
    strings:
        $a = { 43 52 45 47 }
    condition:
        $a at pe.entry_point

}

rule CICompress_10: PEiD
{
    strings:
        $a = { 6A 04 68 00 10 00 00 FF 35 9C 14 40 00 6A 00 FF 15 38 10 40 00 A3 FC 10 40 00 97 BE 00 20 40 00 E8 71 00 00 00 3B 05 9C 14 40 00 75 61 6A 00 6A 20 6A 02 6A 00 6A 03 68 00 00 00 C0 68 94 10 40 00 FF 15 2C 10 40 00 A3 F8 10 40 00 6A 00 68 F4 10 40 00 FF 35 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_: PEiD
{
    strings:
        $a = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 94 00 00 00 53 6A 00 8B ?? ?? ?? ?? ?? FF D7 50 FF ?? ?? ?? ?? ?? 8B F0 85 F6 75 0A 6A 12 E8 ?? ?? ?? ?? 59 EB 18 89 1E 56 FF ?? ?? ?? ?? ?? 56 85 C0 75 14 50 FF D7 50 FF ?? ?? ?? ?? ?? B8 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_UPX_06: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 00 00 00 FF 57 8D B0 E8 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V118_Basic_Edition_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_ASPack_212_emadicius: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 73 00 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B }
        $b = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule UPack_v011_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 ?? F3 AB C1 E0 ?? B5 ?? F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C ?? 73 ?? B0 ?? 3C ?? 72 02 2C ?? 50 0F B6 5F FF C1 E3 ?? B3 ?? 8D 1C 5B 8D ?? ?? ?? ?? ?? ?? B0 ?? 67 E3 29 8B D7 }
    condition:
        $a at pe.entry_point

}

rule APatch_GUI_v11_additional: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 ?? ?? ?? ?? 58 83 C0 07 C6 ?? C3 }
    condition:
        $a at pe.entry_point

}

rule ACProtectUltraProtect_10X_20X_RiSco: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00 }
        $b = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule LY_WGKX_V2X_wwwszleyucom_SignByfly_20080122_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V18_SetiSoft_Team: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        $a at pe.entry_point

}

rule LCC_Win32_1x: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? 00 68 9A 10 40 00 50 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_10x_Ashkbiz_Danehkar_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 }
    condition:
        $a at pe.entry_point

}

rule HASP_HL_Protection_V1X_Aladdin_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 8B C4 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 04 E9 A5 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 }
    condition:
        $a at pe.entry_point

}

rule Pelles_C_28x_45x_Pelle_Orinius: PEiD
{
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC }
    condition:
        $a at pe.entry_point

}

rule Vx_Hafen1641: PEiD
{
    strings:
        $a = { E8 ?? ?? 01 ?? ?? ?? CE CC 25 ?? ?? 25 ?? ?? 25 ?? ?? 40 51 D4 ?? ?? ?? CC 47 CA ?? ?? 46 8A CC 44 88 CC }
    condition:
        $a at pe.entry_point

}

rule Vx_November_17768_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? 50 33 C0 8E D8 80 3E ?? ?? ?? 0E 1F ?? ?? FC }
    condition:
        $a at pe.entry_point

}

rule PENinja_modified_additional: PEiD
{
    strings:
        $a = { 5D 83 ED 06 EB 02 EA 04 8D }
    condition:
        $a at pe.entry_point

}

rule Reflexive_Arcade_Wrapper: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 98 68 42 00 68 14 FA 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 F8 50 42 00 33 D2 8A D4 89 15 3C E8 42 00 8B C8 81 E1 FF 00 00 00 89 0D 38 E8 42 00 C1 E1 08 03 CA 89 0D 34 E8 42 00 C1 E8 10 A3 30 E8 }
    condition:
        $a at pe.entry_point

}

rule NeoLite_v20: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4E 65 6F 4C 69 74 65 }
    condition:
        $a at pe.entry_point

}

rule REC_v032: PEiD
{
    strings:
        $a = { 06 1E 52 B8 ?? ?? 1E CD 21 86 E0 3D }
    condition:
        $a at pe.entry_point

}

rule Vx_Predator2448_additional: PEiD
{
    strings:
        $a = { 0E 1F BF ?? ?? B8 ?? ?? B9 ?? ?? 49 ?? ?? ?? ?? 2A C1 4F 4F ?? ?? F9 CC }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_CracKed_By_shoooo_fly_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 C5 FA 81 }
    condition:
        $a at pe.entry_point

}

rule Nullsoft_Install_System_20_RC2_additional: PEiD
{
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 20 71 40 00 05 E8 03 00 00 BE 60 FD 41 00 89 44 24 10 B3 20 FF 15 28 70 40 00 68 00 04 00 00 FF 15 28 71 40 00 50 56 FF 15 08 71 40 00 80 3D 60 FD 41 00 22 75 08 80 C3 02 BE 61 FD 41 00 8A 06 8B 3D F0 71 40 00 84 C0 74 0F 3A C3 74 }
    condition:
        $a at pe.entry_point

}

rule hmimys_Packer_V10_hmimys: PEiD
{
    strings:
        $a = { 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 00 00 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_ASPack_2xx_Heuristic_Anorganix_additional: PEiD
{
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_v12x_New_Strain: PEiD
{
    strings:
        $a = { 68 01 ?? ?? ?? E8 01 ?? ?? ?? C3 C3 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_v13037_Obsidium_Software_h: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 }
        $b = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Crinkler_V01_V02_Rune_LHStubbe_and_Aske_Simon_Christensen: PEiD
{
    strings:
        $a = { B9 ?? ?? ?? ?? 01 C0 68 ?? ?? ?? ?? 6A 00 58 50 6A 00 5F 48 5D BB 03 00 00 00 BE ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule Petite_14_additional: PEiD
{
    strings:
        $a = { 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC 8D A0 54 BC 00 00 50 8B C3 8D 90 ?? 16 00 00 68 00 00 ?? ?? 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 D8 14 00 00 8B 44 24 18 F6 }
    condition:
        $a at pe.entry_point

}

rule VIRUS_I_WormKLEZ_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 40 D2 40 ?? 68 04 AC 40 ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 BC D0 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V119_aPlib_043_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        $a at pe.entry_point

}

rule Password_Protector_c_MiniSoft_1992_additional: PEiD
{
    strings:
        $a = { 06 0E 0E 07 1F E8 00 00 5B 83 EB 08 BA 27 01 03 D3 E8 3C 02 BA EA }
    condition:
        $a at pe.entry_point

}

rule Vx_August_16th_Iron_Maiden_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BA 79 02 03 D7 B4 1A CD 21 B8 24 35 CD 21 5F 57 89 9D 4E 02 8C 85 50 02 }
    condition:
        $a at pe.entry_point

}

rule Morphine_v12_v13_additional: PEiD
{
    strings:
        $a = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_V2X_MoleStudiocom_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RCryptor_16_by_Vaska_Damrai_sign_20032007_2041_additional: PEiD
{
    strings:
        $a = { 83 2C 24 4F 68 40 A1 14 13 FF 54 24 04 83 44 24 04 4F B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 2B 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 19 40 EB F3 E8 00 00 00 00 C3 }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt_102_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 }
    condition:
        $a at pe.entry_point

}

rule xPEP_03x_xIkUg_additional: PEiD
{
    strings:
        $a = { 55 53 56 51 52 57 E8 16 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_v1051: PEiD
{
    strings:
        $a = { 60 EB 03 C7 84 E8 EB 03 C7 84 9A E8 00 00 00 00 5D 81 ED 10 00 00 00 EB 03 C7 84 E9 64 A0 23 00 00 00 EB }
    condition:
        $a at pe.entry_point

}

rule FSG_v12_additional: PEiD
{
    strings:
        $a = { 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PC_Guard_for_Win32_v500_SofProBlagoje_Ceklic_h: PEiD
{
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 ?? ?? ?? 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C }
        $b = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 ?? ?? ?? 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule kryptor_6_additional: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 BF A4 42 00 81 E9 8E 74 42 00 8B D5 81 C2 8E 74 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 63 29 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        $a at pe.entry_point

}

rule SEA_AXE_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC BC ?? ?? 0E 1F E8 ?? ?? 26 A1 ?? ?? 8B 1E ?? ?? 2B C3 8E C0 B1 ?? D3 E3 }
    condition:
        $a at pe.entry_point

}

rule theWRAP_by_TronDoc_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF 8B F0 B2 01 A1 B4 C3 40 00 E8 F1 5B F4 FF 89 03 33 D2 8B 03 E8 42 1E F5 FF 66 B9 02 00 BA FC FF FF FF 8B C6 8B 38 FF 57 0C BA B8 A7 4D 00 B9 04 00 00 00 8B C6 8B 38 FF 57 04 83 3D B8 A7 4D 00 00 0F 84 5E 01 00 00 8B 15 B8 A7 4D 00 83 C2 04 F7 DA 66 B9 02 00 8B C6 8B 38 FF 57 0C 8B 0D B8 A7 4D 00 8B D6 8B 03 E8 2B 1F F5 FF 8B C6 E8 B4 5B F4 FF 33 D2 8B 03 E8 DF 1D F5 FF BA F0 44 4E 00 B9 01 00 00 00 8B 03 8B 30 FF 56 04 80 3D F0 44 4E 00 0A 75 3F BA B8 A7 4D 00 B9 04 00 00 00 8B 03 8B 30 FF 56 04 8B 15 B8 A7 }
    condition:
        $a at pe.entry_point

}

rule Soft_Defender_v11x_Randy_Li: PEiD
{
    strings:
        $a = { 74 07 75 05 ?? ?? ?? ?? ?? 74 1F 75 1D ?? 68 ?? ?? ?? 00 59 9C 50 74 0A 75 08 ?? 59 C2 04 00 ?? ?? ?? E8 F4 FF FF FF ?? ?? ?? 78 0F 79 0D }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_CrunchPE_Heuristic: PEiD
{
    strings:
        $a = { 55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule HPA_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5E 8B D6 83 ?? ?? 83 ?? ?? 06 0E 1E 0E 1F 33 FF 8C D3 }
    condition:
        $a at pe.entry_point

}

rule aPack_v098b_exe: PEiD
{
    strings:
        $a = { 93 07 1F 05 ?? ?? 8E D0 BC ?? ?? EA }
    condition:
        $a at pe.entry_point

}

rule GHF_Protector_pack_only_GPcH: PEiD
{
    strings:
        $a = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 00 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 61 B9 FC FF FF FF 8B 1C 08 89 99 ?? ?? ?? ?? E2 F5 90 90 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 01 D6 8B 46 0C 85 C0 0F 84 87 00 00 00 01 D0 89 C3 50 B8 ?? ?? ?? ?? FF 10 85 C0 75 08 53 B8 ?? ?? ?? ?? FF 10 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 BA ?? ?? ?? ?? 8B 06 85 C0 75 03 8B 46 10 01 D0 03 05 ?? ?? ?? ?? 8B 18 8B 7E 10 01 D7 03 3D ?? ?? ?? ?? 85 DB 74 2B F7 C3 00 00 00 80 75 04 01 D3 43 43 81 E3 FF FF FF 0F 53 FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 89 07 83 05 ?? ?? ?? ?? 04 EB AE 83 C6 14 BA ?? ?? ?? ?? E9 6E FF FF FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 8B 15 ?? ?? ?? ?? 52 FF D0 61 BA ?? ?? ?? ?? FF E2 90 C3 }
        $b = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 00 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PE_Password_v02_SMTSMF_SMT: PEiD
{
    strings:
        $a = { E8 04 00 00 00 8B EC 5D C3 33 C0 5D 8B FD 81 ED 33 26 40 00 81 EF ?? ?? ?? ?? 83 EF 05 89 AD 88 27 40 ?? 8D 9D 07 29 40 ?? 8D B5 62 28 40 ?? 46 80 }
    condition:
        $a at pe.entry_point

}

rule PE_Armor_0460_0759_hying: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 }
        $b = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CRYPTCOM_11: PEiD
{
    strings:
        $a = { BF E1 FF 57 BE 0E 01 90 B9 1B 00 F3 A4 C3 8B 16 25 01 8B 0E 27 01 BF 00 01 57 BE 29 01 90 AD 33 C2 AB E2 FA C3 }
    condition:
        $a at pe.entry_point

}

rule SoftDefender_v112_Randy_Li: PEiD
{
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 BE 01 00 00 03 C8 74 BD 75 BB E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule SVKP_v142_Pavol_Cerven_h: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC EC 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67 }
    condition:
        $a at pe.entry_point

}

rule Jam_221_EXE: PEiD
{
    strings:
        $a = { 50 06 16 07 BE 24 02 8B FE B9 13 01 FD FA F3 2E A5 FB 06 BD 78 00 55 CB BE 00 00 8B FE BD 00 00 55 8D 9E 00 00 8D 97 00 00 B9 00 00 80 EF 10 8E DB 80 EE 10 8E C2 F3 A5 B5 80 3B DD 77 EE 33 C9 BE 00 00 8B FE 8E DA 8E C3 FC BA 01 00 EB 5F 5D }
    condition:
        $a at pe.entry_point

}

rule ProtEXE_30: PEiD
{
    strings:
        $a = { 9C 50 53 51 52 56 57 55 1E 06 FC B8 00 30 CD 21 84 C0 75 02 CD 20 A8 EB 04 00 EB FB 9A BA 21 00 EC 0C 02 EB 01 D0 EE BD 00 00 A8 EB 04 00 EB FB 9A BA 64 00 B0 AD EB 01 B1 EE B9 94 01 A8 EB 04 00 EB FB 9A 89 E8 34 00 2E 28 46 00 4D 49 74 02 }
    condition:
        $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_2_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA FC 0E 1F E8 ?? ?? 8C C0 66 0F B7 C0 66 C1 E0 ?? 66 67 A3 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_CodeSafe_20: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 }
    condition:
        $a at pe.entry_point

}

rule iLUCRYPT_v4018_exe: PEiD
{
    strings:
        $a = { 8B EC FA C7 ?? ?? ?? ?? 4C 4C C3 FB BF ?? ?? B8 ?? ?? 2E ?? ?? D1 C8 4F 81 }
    condition:
        $a at pe.entry_point

}

rule RLPack_v118_Basic_aPLib_Ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
    condition:
        $a at pe.entry_point

}

rule VMProtect_106107_PolyTech_additional: PEiD
{
    strings:
        $a = { 9C 60 68 00 00 00 00 8B 74 24 28 BF ?? ?? ?? ?? FC 89 F3 03 34 24 AC 00 D8 }
    condition:
        $a at pe.entry_point

}

rule UPX_072_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 83 CD FF 31 DB 5E }
    condition:
        $a at pe.entry_point

}

rule LSI_C_86_Run_Time_Libray_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E C0 06 17 BC ?? ?? 26 8C ?? ?? ?? B4 30 CD 21 26 A3 ?? ?? FC }
    condition:
        $a at pe.entry_point

}

rule PESpin_v11_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 C3 4B 40 00 8B 42 3C 03 C2 89 85 CD 4B 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D E1 4B 40 00 53 8F 85 D7 49 40 00 BB ?? 00 00 00 B9 FE 11 00 00 8D BD 71 4C 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 83 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 BD 2D 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC FF EA EB 01 C8 E8 01 00 00 00 68 58 FE 48 1F 0F 84 94 02 00 00 75 01 9A 81 70 03 E8 98 68 EA 83 C0 21 8? }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule COM_Crypt_II_386_by_ROSE_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? BF ?? ?? 57 B9 ?? ?? C7 ?? ?? ?? C6 ?? ?? ?? 81 ?? ?? ?? 47 47 E2 ?? 33 FF C3 }
    condition:
        $a at pe.entry_point

}

rule Imaging_Technology_Graphics_format: PEiD
{
    strings:
        $a = { 49 4D 00 00 }
    condition:
        $a at pe.entry_point

}


rule UPX_290_LZMA_Delphi_stub_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? C7 87 ?? ?? ?? ?? ?? ?? ?? ?? 57 83 CD FF 89 E5 8D 9C 24 ?? ?? ?? ?? 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? ?? 57 83 C3 04 53 68 ?? ?? ?? ?? 56 83 C3 04 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_v1501_Options_Light_Full_support_CGSoftLabs: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? 02 00 00 53 56 57 83 A5 ?? FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 }
    condition:
        $a at pe.entry_point

}

rule tElock_v100_tHE_EGOiSTE: PEiD
{
    strings:
        $a = { E9 E5 E2 FF FF }
    condition:
        $a at pe.entry_point

}

rule Upack_v035_alpha_Sign_by_hot_UNP: PEiD
{
    strings:
        $a = { 8B F2 8B CA 03 4C 19 1C 03 54 1A 20 }
    condition:
        $a at pe.entry_point

}

rule aPack_082_EXE: PEiD
{
    strings:
        $a = { 1E 06 8C CB BA 00 00 03 DA 8D 87 00 00 FC 33 F6 33 FF 48 4B 8E C0 8E DB B9 08 00 F3 A5 4A 75 EE 8E C3 8E D8 33 FF BE 31 00 05 00 00 0E 50 6A 00 CB }
    condition:
        $a at pe.entry_point

}

rule Virogens_PE_Shrinker_v014: PEiD
{
    strings:
        $a = { 9C 55 E8 ?? ?? ?? ?? 87 D5 5D 60 87 D5 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 57 56 AD 0B C0 74 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v107b_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 60 E8 2B 03 00 00 }
    condition:
        $a at pe.entry_point

}

rule MESS_v120_additional: PEiD
{
    strings:
        $a = { FA B9 ?? ?? F3 ?? ?? E3 ?? EB ?? EB ?? B6 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_Microsoft_Visual_Cpp_emadicius_additional: PEiD
{
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC 56 3B D2 74 02 81 85 57 E8 00 00 00 00 3B DB 74 01 90 83 C4 14 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 }
    condition:
        $a at pe.entry_point

}

rule FIDO_mail_packet: PEiD
{
    strings:
        $a = { 03 00 03 00 CD 07 }
    condition:
        $a at pe.entry_point

}

rule T_PACK_v05c_m2_additional: PEiD
{
    strings:
        $a = { 68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 CE FD }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_70_DLL_Anorganix_additional: PEiD
{
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_v230_Teggo_additional: PEiD
{
    strings:
        $a = { 42 04 E8 ?? ?? 00 00 A3 ?? ?? ?? 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 ?? 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC CC CC CC CC CC CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 20 61 58 FF D0 E8 ?? ?? 00 00 CC CC CC CC CC CC CC }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Windows_Enhanced_Metafile_Hint_FILE_START: PEiD
{
    strings:
        $a = { 01 00 00 00 58 }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1988_1995: PEiD
{
    strings:
        $a = { FB 83 89 E3 89 89 66 66 BB 29 C0 B4 30 CD }
        $b = { E9 ?? ?? ?? ?? ?? ?? ?? ?? 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule WATCOM_CCpp_32_Run_Time_System_1988_1994: PEiD
{
    strings:
        $a = { E9 57 }
        $b = { FB 83 ?? ?? 89 E3 89 ?? ?? ?? ?? ?? 89 ?? ?? ?? ?? ?? 66 ?? ?? ?? 66 ?? ?? ?? ?? ?? BB ?? ?? ?? ?? 29 C0 B4 30 CD 21 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PE_Ninja_v10_pDzA_kRAker_TNT_additional: PEiD
{
    strings:
        $a = { BE 5B 2A 40 00 BF 35 12 00 00 E8 40 12 00 00 3D 22 83 A3 C6 0F 85 67 0F 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        $a at pe.entry_point

}

rule KByS_V028_shoooo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v100b_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 3E D9 43 ?? B8 38 ?? ?? ?? 03 C5 2B 85 0B DE 43 ?? 89 85 17 DE 43 ?? 80 BD 01 DE 43 ?? ?? 75 15 FE 85 01 DE 43 ?? E8 1D ?? ?? ?? E8 79 02 ?? ?? E8 12 03 ?? ?? 8B 85 03 DE 43 ?? 03 85 17 DE 43 ?? 89 44 24 1C 61 FF }
    condition:
        $a at pe.entry_point

}

rule Upack_V036_Dwing_20080321: PEiD
{
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? C1 E5 08 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 18 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 1C 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 1C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 14 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 3C E2 E3 }
    condition:
        $a at pe.entry_point

}

rule ExeSplitter_12_Bill_Prisoner_TPOC: PEiD
{
    strings:
        $a = { E9 95 02 00 00 64 A1 00 00 00 00 83 38 FF 74 04 8B 00 EB F7 8B 40 04 C3 55 8B EC B8 00 00 00 00 8B 75 08 81 E6 00 00 FF FF B9 06 00 00 00 56 56 E8 B0 00 00 00 5E 83 F8 01 75 06 8B C6 C9 C2 04 00 81 EE 00 00 01 00 E2 E5 C9 C2 04 00 55 8B EC 8B 75 0C 8B DE 03 76 3C 8D 76 18 8D 76 60 8B 36 03 F3 56 8B 76 20 03 F3 33 D2 8B C6 8B 36 03 F3 8B 7D 08 B9 0E 00 00 00 FC F3 A6 0B C9 75 02 EB 08 }
        $b = { E9 95 02 00 00 64 A1 00 00 00 00 83 38 FF 74 04 8B 00 EB F7 8B 40 04 C3 55 8B EC B8 00 00 00 00 8B 75 08 81 E6 00 00 FF FF B9 06 00 00 00 56 56 E8 B0 00 00 00 5E 83 F8 01 75 06 8B C6 C9 C2 04 00 81 EE 00 00 01 00 E2 E5 C9 C2 04 00 55 8B EC 8B 75 0C 8B DE }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Borland_Cpp_for_Win32_1995_additional: PEiD
{
    strings:
        $a = { A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 57 51 33 C0 BF ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B CF 76 }
    condition:
        $a at pe.entry_point

}

rule Vx_Kuku448: PEiD
{
    strings:
        $a = { AE 75 ED E2 F8 89 3E ?? ?? BA ?? ?? 0E 07 BF ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule Joiner_sign_from_pinch_25032007_2010: PEiD
{
    strings:
        $a = { 81 EC 04 01 00 00 8B F4 68 04 01 00 00 56 6A 00 E8 7C 01 00 00 33 C0 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 56 E8 50 01 00 00 8B D8 6A 00 6A 00 6A 00 6A 02 6A 00 53 E8 44 01 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_V1033_Ashkbiz_Danehkar_Sign_by_fly: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8E 00 00 00 E8 03 00 00 00 EB 01 ?? E8 81 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B7 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AA 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2D E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 5D 81 ED 07 E2 40 00 8B D5 81 C2 56 E2 40 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 }
    condition:
        $a at pe.entry_point

}

rule LGLZ_v104b_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC 1E 06 0E 8C C8 ?? ?? ?? ?? BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 ?? ?? F3 A5 4B 48 4A 79 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v211c_Alexey_Solodovnikov: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 59 04 00 00 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    strings:
        $a = { F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? A7 BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68 }
    condition:
        $a at pe.entry_point

}

rule LCC_Win32: PEiD
{
    strings:
        $a = { 53 FF 15 58 70 40 00 B3 22 38 18 74 03 80 C3 FE 40 33 D2 8A 08 3A CA 74 10 3A CB 74 07 40 8A 08 3A CA 75 F5 38 10 74 01 40 52 50 52 52 FF 15 5C 70 40 00 50 E8 15 FB FF FF 50 FF 15 8C 70 40 00 5B }
        $b = { 64 A1 00 00 00 00 55 89 E5 6A FF 68 10 30 40 00 68 9A 10 40 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Inno_Setup_Module: PEiD
{
    strings:
        $a = { 49 6E 6E 6F 53 65 74 75 70 4C 64 72 57 69 6E 64 6F 77 00 00 53 54 41 54 49 43 }
        $b = { 55 8B EC 83 C4 ?? 53 56 57 33 C0 89 45 F0 89 45 ?? 89 45 ?? E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Cpp_70: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 ?? ?? 83 }
        $b = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 40 89 45 E4 8B 75 0C }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Cpp_71: PEiD
{
    strings:
        $a = { 8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 39 75 0C 0F 84 ?? ?? ?? ?? 33 C0 40 5E 5D C2 0C 00 }
        $b = { 8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 59 59 33 C0 40 5E 5D C2 0C 00 }
        $c = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 AB 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 74 7B 83 FE FF 74 7D 8D 0C 76 8B 44 8F 04 0B C0 74 59 56 55 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_239_compressed_resources_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 51 68 ?? ?? ?? ?? 59 81 F1 12 3C CB 98 E9 53 2C 00 00 F7 D7 E9 EB 60 00 00 83 45 F8 02 E9 E3 36 00 00 F6 45 F8 20 0F 84 1E 21 00 00 55 E9 80 62 00 00 87 0C 24 8B E9 ?? ?? ?? ?? 00 00 23 C1 81 E9 ?? ?? ?? ?? 57 E9 ED 00 00 00 0F 88 ?? ?? ?? ?? E9 2C 0D 00 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v211b_additional: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_V05_Smoke_additional: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 90 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_10b_Ashkbiz_Danehkar_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 }
    condition:
        $a at pe.entry_point

}

rule ASPack_105b_by: PEiD
{
    strings:
        $a = { 75 00 E9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_C_for_Windows_2_Hint_WIN_EP: PEiD
{
    strings:
        $a = { 8C D8 ?? 45 55 8B EC 1E 8E D8 57 56 89 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_MinGW_GCC_2x_Anorganix: PEiD
{
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 E9 }
    condition:
        $a at pe.entry_point

}

rule ACE_Archive_additional: PEiD
{
    strings:
        $a = { 2A 2A 41 43 45 2A 2A }
    condition:
        $a at pe.entry_point

}

rule Free_Pascal_09910: PEiD
{
    strings:
        $a = { E8 00 6E 00 00 55 89 E5 8B 7D 0C 8B 75 08 89 F8 8B 5D 10 29 }
    condition:
        $a at pe.entry_point

}

rule SoftProtect_SoftProtectbyru: PEiD
{
    strings:
        $a = { EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 60 E8 03 ?? ?? ?? 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 EB 01 83 9C EB 01 D5 EB 08 35 9D EB 01 89 EB 03 0B EB F7 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? 59 83 01 01 80 39 5C }
        $b = { E8 0C 15 00 00 8D 85 2F 14 00 00 C7 00 00 00 00 00 E8 29 0F 00 00 E8 F6 14 00 00 8D 85 20 01 00 00 50 E8 AA 16 00 00 83 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Armadillo_v200b1_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 00 F2 40 00 68 C4 9D 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        $a at pe.entry_point

}

rule PESHiELD_v0251_additional: PEiD
{
    strings:
        $a = { 5D 83 ED 06 EB 02 EA 04 8D }
    condition:
        $a at pe.entry_point

}

rule MetaWare_High_C_p_Phar_Lap_DOS_Extender_1983_89: PEiD
{
    strings:
        $a = { B8 ?? ?? 8E D8 B8 ?? ?? CD 21 A3 ?? ?? 3C 03 7D ?? B4 09 }
    condition:
        $a at pe.entry_point

}

rule UPX_200_Markus_Laszlo: PEiD
{
    strings:
        $a = { 32 2E 30 30 00 55 50 58 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_BJFNT_12_Anorganix: PEiD
{
    strings:
        $a = { EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_emadicius: PEiD
{
    strings:
        $a = { E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF FF FF 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C }
        $b = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Cue_80: PEiD
{
    strings:
        $a = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BB 94 00 00 00 53 6A 00 8B }
    condition:
        $a at pe.entry_point

}

rule Crypto_Lock_v202_Eng_Ryan_Thian_additional: PEiD
{
    strings:
        $a = { 60 BE 00 A0 42 00 8D BE 00 70 FD FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 }
    condition:
        $a at pe.entry_point

}

rule UG2002_Cruncher_v03b3_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? E8 0D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 58 }
    condition:
        $a at pe.entry_point

}

rule Shrinker_v34_Hint_DOS_EP: PEiD
{
    strings:
        $a = { BB ?? ?? BA ?? ?? 81 C3 07 00 B8 40 B4 B1 04 D3 E8 03 C3 8C D9 49 8E C1 26 03 0E 03 00 2B }
    condition:
        $a at pe.entry_point

}

rule Petite_v21_1: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM: PEiD
{
    strings:
        $a = { 6A 00 E8 ?? ?? 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_PEX_099_emadicius_h: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED FF 22 40 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule BookManager_v9510_additional: PEiD
{
    strings:
        $a = { FC A3 ?? ?? 89 1E ?? ?? 49 89 0E ?? ?? BB ?? ?? 8C 1F 83 ?? ?? 89 ?? ?? B8 ?? ?? 50 89 ?? ?? F7 D0 50 }
    condition:
        $a at pe.entry_point

}

rule Silicon_Realms_Install_Stub_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v1033_exescrcom_Ashkbiz_Danehkar_h_additional: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8E 00 00 00 E8 03 00 00 00 EB 01 ?? E8 81 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B7 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AA 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2D E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 5D 81 ED 07 E2 40 00 8B D5 81 C2 56 E2 40 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 4B 0C 41 00 81 E9 01 E3 40 00 8B D5 81 C2 01 E3 40 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 9C 22 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 CC CC CC CC AC }
    condition:
        $a at pe.entry_point

}

rule Crunch_5_Fusion_4: PEiD
{
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 55 E8 }
    condition:
        $a at pe.entry_point

}

rule OLE2_Document_WinWord_Excel_: PEiD
{
    strings:
        $a = { D0 CF 11 E0 A1 B1 1A E1 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_PE_Protect_09_Anorganix: PEiD
{
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9 }
    condition:
        $a at pe.entry_point

}

rule NE_Exe_Executable_Image_Hint_FILE_START: PEiD
{
    strings:
        $a = { 4E 45 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2117_StrongbitSoftComplete_Development_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 }
    condition:
        $a at pe.entry_point

}

rule EEXE_Version_112: PEiD
{
    strings:
        $a = { B4 30 CD 21 3C 03 73 ?? BA 1F 00 0E 1F B4 09 CD 21 B8 FF 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v200c_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 3B C4 73 ?? 8B C4 2D ?? ?? 25 ?? ?? 8B F8 B9 ?? ?? BE ?? ?? FC }
    condition:
        $a at pe.entry_point

}

rule Inno_Installer_v512_additional: PEiD
{
    strings:
        $a = { 60 64 A1 30 00 00 00 8B 40 0C 8B 40 0C 8D 58 20 C7 03 00 00 00 00 E8 00 00 00 00 5D 81 ED 4D 16 40 00 8B 9D 0E 17 40 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 83 F8 01 75 05 03 DB C1 CB 10 8B 8D 12 17 40 00 8B B5 06 17 40 00 51 81 3E 2E 72 73 72 74 65 8B }
    condition:
        $a at pe.entry_point

}

rule ARM_Protector_01_by_SMoKE_additional: PEiD
{
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 }
    condition:
        $a at pe.entry_point

}

rule LTC_v13: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 }
    condition:
        $a at pe.entry_point

}

rule StarForce_Protection_Driver_Protection_Technology_additional: PEiD
{
    strings:
        $a = { 57 68 ?? 0D 01 00 68 00 ?? ?? 00 E8 50 ?? FF FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_36x_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD AB 76 }
    condition:
        $a at pe.entry_point

}

rule WinZip_SFX: PEiD
{
    strings:
        $a = { 8A CB D3 E7 4F FF 4D D8 0F B7 08 23 FE 3B F9 75 E4 E9 9F FD FF FF FF 45 EC 8B 45 EC 39 45 E0 0F 8D 7F FD FF FF 83 7D DC 00 74 32 83 7D E0 01 74 2C B8 01 00 00 00 EB 27 83 7D D8 00 74 0E FF B5 38 FF FF FF E8 1D 00 00 00 83 C4 04 68 00 00 40 }
    condition:
        $a at pe.entry_point

}

rule Enigma_protector_110_unregistered_additional: PEiD
{
    strings:
        $a = { 60 8B DD E8 00 00 00 00 5D 95 32 C0 95 89 9D 80 00 00 00 B8 42 31 40 00 BB 41 30 40 00 2B C3 03 C5 33 D2 8A 10 40 B9 ?? ?? 00 00 8B F9 30 10 8A 10 40 49 75 F8 64 EF 86 3D 30 00 00 0F B9 FF 4B 89 52 5C 4C BD 77 C2 0C CE 88 4E 2D E8 00 00 00 5D 0D DB 5E 56 41 87 FC 0F F3 05 40 81 68 4B 93 71 40 BB 87 3C 40 40 8B 88 06 75 70 40 40 8B BB B3 43 C4 8F 93 2B F3 4A 88 06 07 30 F5 EA 2A 35 F0 4B 8A C3 07 C1 C6 02 C4 34 C0 74 74 32 02 C4 45 0B 3C 96 BE 0A 82 C3 DE 36 A9 7E 5A 51 A6 BC 63 A8 66 CB 30 58 20 8C CC 85 53 9F C1 E4 10 80 11 20 1E 48 D2 E8 F7 28 5C 26 89 5C 94 89 5A F8 1C 0B 74 7E 33 4E 9B 29 56 F2 2B 84 42 8A 95 16 76 64 08 7B 70 8F A0 0B A8 3A C1 C7 B5 3E D9 70 }
    condition:
        $a at pe.entry_point

}

rule Erdas_LANGIS_Image_graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 48 45 41 44 37 34 00 00 03 00 }
    condition:
        $a at pe.entry_point

}

rule VMware_ThinApp_V4012866_VMware_20090124: PEiD
{
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 72 13 00 00 2B C3 50 68 00 00 20 46 68 00 60 00 00 68 58 01 00 00 E8 71 FC FF FF E9 DA FC FF FF 55 8B EC 8B 48 3C 83 EC 0C 53 56 57 8D 7C 01 78 8B 0F 85 C9 74 7E 8B 77 04 83 FE 28 72 76 8D 1C 01 8B 53 18 85 D2 74 6C 8B 43 20 3B C1 72 65 8D 14 90 03 F1 3B F2 72 5C 83 65 FC 00 2B C1 03 C3 83 7B 18 00 89 45 F4 76 4B 8B 4D FC 8B 45 F4 8D 04 88 8B 0F 3B 08 77 31 8B 30 FF 75 08 8B C1 89 45 F8 FF 15 2C 30 20 46 8B 4F 04 03 4D F8 8D 44 30 01 3B C1 77 13 2B 75 F8 FF 75 08 03 F3 56 FF 15 28 30 20 46 85 C0 74 12 FF 45 FC 8B 45 FC 3B 43 18 72 B5 33 C0 5F 5E 5B C9 C3 8B 55 FC 39 53 14 76 F1 8B 43 1C 8B 0F 3B C1 72 E8 8D 04 90 8B 57 04 03 D1 8D 70 04 3B D6 72 D9 2B C1 8B 04 18 EB D4 FF 25 5C 14 20 46 00 00 00 00 56 6A 01 FF 74 24 14 6A 00 FF 74 24 18 E8 DC 07 00 00 8B F0 83 C4 10 85 F6 75 04 33 C0 EB 28 68 AB 14 20 46 E8 0B FF FF FF 59 85 C0 74 ED 8B 4C 24 14 68 5C 14 20 46 FF 74 24 10 03 C6 6A 01 C7 01 56 14 20 46 FF D0 5E C2 10 00 }
    condition:
        $a at pe.entry_point

}

rule Themida_1201_Oreans_Technologies: PEiD
{
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 }
        $b = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 11 02 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_Visual_Basic_v60_additional: PEiD
{
    strings:
        $a = { FF 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? FF FF FF ?? ?? ?? ?? ?? ?? 30 }
    condition:
        $a at pe.entry_point

}

rule HideProtect_V10X_SoftWar_Company: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
        $b = { 90 90 90 E9 D8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASProtect_v11_BRS: PEiD
{
    strings:
        $a = { 68 01 }
        $b = { 60 E9 ?? 05 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXE2COM_Method_1: PEiD
{
    strings:
        $a = { 8C DB BE ?? ?? 8B C6 B1 ?? D3 E8 03 C3 03 ?? ?? A3 ?? ?? 8C C8 05 ?? ?? A3 }
    condition:
        $a at pe.entry_point

}

rule Windows_Write_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { BE 00 00 00 AB 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PKZIP_SFX_v11_1989_90_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FC 2E 8C 0E ?? ?? A1 ?? ?? 8C CB 81 C3 ?? ?? 3B C3 72 ?? 2D ?? ?? 2D ?? ?? FA BC ?? ?? 8E D0 FB }
    condition:
        $a at pe.entry_point

}

rule tELock_051: PEiD
{
    strings:
        $a = { C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 5E 8B FE 68 79 01 00 00 59 EB 01 EB AC 54 E8 03 00 00 00 5C EB 08 8D 64 24 04 FF 64 24 FC 6A 05 D0 2C 24 72 01 E8 01 24 24 5C F7 DC EB 02 CD 20 8D 64 24 FE F7 DC EB 02 CD 20 }
    condition:
        $a at pe.entry_point

}

rule RLPack_117p: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? 00 00 8D 9D ?? ?? 00 00 33 FF E8 ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 37 FF D3 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_10_beta_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 }
    condition:
        $a at pe.entry_point

}

rule DBPE_v210_Ding_Boy: PEiD
{
    strings:
        $a = { EB 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9C 55 57 56 52 51 53 9C E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? EB 58 75 73 65 72 33 32 2E 64 6C 6C ?? 4D 65 73 73 61 67 65 42 6F 78 41 ?? 6B 65 72 6E 65 6C }
    condition:
        $a at pe.entry_point

}

rule Dev_Cpp_4992_Bloodshed_Software_additional: PEiD
{
    strings:
        $a = { 57 68 ?? 0D 01 00 68 00 ?? ?? 00 E8 50 ?? FF FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Vx_SYP_additional: PEiD
{
    strings:
        $a = { 47 8B C2 05 1E 00 52 8B D0 B8 02 3D CD 21 8B D8 5A }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Cpp_1999: PEiD
{
    strings:
        $a = { EB 02 CD 20 2B C8 68 80 ?? ?? 00 EB 02 1E BB 5E EB 02 CD 20 68 B1 2B 6E 37 40 5B 0F B6 C9 }
    condition:
        $a at pe.entry_point

}

rule Themida_Oreans_Technologies_2004_additional: PEiD
{
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 }
    condition:
        $a at pe.entry_point

}


rule Petite_12_c1998_Ian_Luck_h_additional: PEiD
{
    strings:
        $a = { 66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 09 00 0A 00 0B 00 0D 00 0F 00 11 00 13 00 17 00 1B 00 1F 00 23 00 2B 00 33 00 3B 00 43 00 53 00 63 00 73 00 83 00 A3 00 C3 00 E3 00 02 01 00 00 00 00 00 00 00 00 00 00 00 00 01 01 01 01 02 02 02 02 03 03 03 03 04 04 04 04 05 05 05 05 00 70 70 01 00 02 00 03 00 04 00 05 00 07 00 09 00 0D 00 11 00 19 00 21 00 31 00 41 00 61 00 81 00 C1 00 01 01 81 01 01 02 01 03 01 04 01 06 01 08 01 0C 01 10 01 18 01 20 01 30 01 40 01 60 00 00 00 00 01 01 02 02 03 03 04 04 05 05 06 06 07 07 08 08 09 09 0A 0A 0B 0B 0C 0C 0D 0D 10 11 12 00 08 07 09 06 0A 05 0B 04 0C 03 0D 02 0E 01 0F 58 2C 08 50 8B C8 8B D0 81 C1 ?? D2 00 00 81 C2 ?? ?? 00 00 89 20 8B E1 50 81 2C 24 00 ?? ?? ?? FF 30 50 80 04 24 }
    condition:
        $a at pe.entry_point

}

rule FileShield_additional: PEiD
{
    strings:
        $a = { 50 1E EB ?? 90 00 00 8B D8 }
    condition:
        $a at pe.entry_point

}

rule WWPack32_v1x_additional: PEiD
{
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2117_Strongbit_SoftComplete_Development_h: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 }
    condition:
        $a at pe.entry_point

}

rule UPX_v103_v104_Laszlo_Markus: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 8A 07 72 EB B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE FC }
    condition:
        $a at pe.entry_point

}

rule InterLok_V551_PACE_Anti_Piracy_SignByfly_additional: PEiD
{
    strings:
        $a = { EB 03 ?? ?? ?? 55 EB 03 ?? ?? ?? EB 04 ?? EB 06 ?? 8B EC EB F9 ?? EB 02 ?? ?? 81 EC A8 00 00 00 EB 02 ?? ?? EB 01 ?? 53 EB 03 ?? ?? ?? EB 05 ?? ?? EB 15 ?? EB 03 ?? ?? ?? 56 EB 04 ?? EB F2 ?? EB 01 ?? EB F8 ?? ?? ?? EB 0F ?? 33 F6 EB 10 ?? ?? ?? EB F7 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_MASM32_TASM32_Microsoft_Visual_Basic_: PEiD
{
    strings:
        $a = { F7 D8 0F BE C2 BE 80 ?? ?? 00 0F BE C9 BF 08 3B 65 07 EB 02 D8 29 BB EC C5 9A F8 EB 01 94 }
    condition:
        $a at pe.entry_point

}

rule tElock_v090_additional: PEiD
{
    strings:
        $a = { E8 02 00 00 00 E8 00 E8 00 00 00 00 5E 2B }
    condition:
        $a at pe.entry_point

}

rule Exe_Shield_v27_additional: PEiD
{
    strings:
        $a = { EB 06 68 C3 9C 60 E8 5D 55 5B 81 ED 8B 85 01 85 66 C7 85 }
    condition:
        $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Spalsher_1x_3x_FEUERRADER: PEiD
{
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 9C 60 8B 44 24 24 E8 00 00 00 00 5D 81 ED 00 00 00 00 50 E8 ED 02 00 00 8C C0 0F 84 }
    condition:
        $a at pe.entry_point

}

rule Cracked_by_Autohack_2_additional: PEiD
{
    strings:
        $a = { 0E 1F B4 09 BA ?? ?? CD 21 FA 8E 06 ?? ?? BE ?? ?? 8B 0E ?? ?? 83 F9 }
    condition:
        $a at pe.entry_point

}

rule Com4mail_v10_additional: PEiD
{
    strings:
        $a = { 42 45 47 49 4E 3D 3D 3D 74 66 75 64 23 6F 66 5F 43 6F 6D 34 4D 61 69 6C 5F 66 69 6C 65 23 0D 0A }
    condition:
        $a at pe.entry_point

}

rule Morphine_V33_Holy_Father_Ratter29A_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_v111_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 06 ?? ?? ?? 64 A0 23 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v110b3_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 49 }
    condition:
        $a at pe.entry_point

}

rule AINEXE_v230_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 0E 07 B9 ?? ?? BE ?? ?? 33 FF FC F3 A4 A1 ?? ?? 2D ?? ?? 8E D0 BC ?? ?? 8C D8 }
    condition:
        $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_Borland_Delphi_Borland_Cpp: PEiD
{
    strings:
        $a = { 0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB }
        $b = { 0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB EE 90 14 2C 77 2A D3 EB 01 87 2A D3 E8 01 00 00 00 92 59 88 16 EB 02 52 08 46 EB 02 CD 20 4B 80 F1 C2 85 DB 75 AE C1 E0 04 EB 00 DA B2 82 5C 9B C7 89 98 4F 8A F7 ?? ?? ?? B1 4D DF B8 AD AC AB D4 07 27 D4 50 CF 9A D5 1C EC F2 27 77 18 40 4E A4 A8 B4 CB 9F 1D D9 EC 1F AD BC 82 AA C0 4C 0A A2 15 45 18 8F BB 07 93 BE C0 BC A3 B0 9D 51 D4 F1 08 22 62 96 6D 09 73 7E 71 A5 3A E5 7D 94 A3 96 99 98 72 B2 31 57 7B FA AE 9D 28 4F 99 EF A3 25 49 60 03 42 8B 54 53 5E 92 50 D4 52 4D C1 55 76 FD F7 8A FC 78 0C 82 87 0F }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ORiEN_212_A_Fisun: PEiD
{
    strings:
        $a = { E9 5D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 78 3B }
    condition:
        $a at pe.entry_point

}

rule FreeJoiner_153_Stub_engine_171_GlOFF_additional: PEiD
{
    strings:
        $a = { 86 D6 90 86 F2 B9 93 60 08 FE 90 86 D6 90 86 F2 B9 9D 13 45 01 86 D6 90 86 F2 81 C2 93 60 08 FE 33 C9 B9 30 74 4D FF 86 D6 90 86 F2 33 C9 C7 05 B4 17 40 00 00 00 00 00 90 68 00 01 00 00 68 D1 17 40 00 6A 00 E8 CE 02 00 00 90 33 C9 86 D6 90 86 F2 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 D1 17 40 00 E8 9E 02 00 00 A3 CD 17 40 00 86 D6 }
    condition:
        $a at pe.entry_point

}

rule NsPack_29_North_Star_additional: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8B 06 83 F8 00 74 11 8D B5 ?? ?? FF FF 8B 06 83 F8 01 0F 84 4B 02 00 00 C7 06 01 00 00 00 8B D5 8B 85 ?? ?? FF FF 2B D0 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 8B 36 8B FD }
    condition:
        $a at pe.entry_point

}

rule RLPack_v118_Basic_aPLib_Ap0x_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_80_additional: PEiD
{
    strings:
        $a = { 3D 00 10 00 00 73 0E F7 D8 03 C4 83 C0 04 85 00 94 8B 00 50 C3 51 8D 4C 24 08 81 E9 00 10 00 00 2D 00 10 00 00 85 01 3D 00 10 00 00 73 EC 2B C8 8B C4 85 01 8B E1 8B 08 8B 40 04 50 C3 }
    condition:
        $a at pe.entry_point

}

rule Upack_V037_V039_Dwing_additional: PEiD
{
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 00 ?? ?? ?? 00 03 00 00 00 ?? ?? ?? ?? 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 ?? F6 ?? 00 B2 4F 45 00 ?? F9 ?? 00 EF 4F 45 00 ?? F6 ?? 00 8C D1 42 00 ?? 56 ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 34 50 45 00 ?? ?? ?? 00 FF FF 00 00 ?? 24 ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 40 00 00 C0 00 00 ?? ?? ?? ?? 00 00 ?? 00 00 00 ?? 1E ?? 00 ?? F7 ?? 00 A6 4E 43 00 ?? 56 ?? 00 AD D1 42 00 ?? F7 ?? 00 A1 D2 42 00 ?? 56 ?? 00 0B 4D 43 00 ?? F7 ?? 00 ?? F7 ?? 00 ?? 56 ?? 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? 77 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 77 ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Duals_eXe_Encryptor_10b_Dual: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 3A 04 00 00 89 28 33 FF 8D 85 80 03 00 00 8D 8D 3A 04 00 00 2B C8 8B 9D 8A 04 00 00 E8 24 02 00 00 8D 9D 58 03 00 00 8D B5 7F 03 00 00 46 80 3E 00 74 24 56 FF 95 58 05 00 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 5C 05 00 00 89 03 58 83 C3 04 EB E3 8D 85 69 02 00 00 FF D0 8D 85 56 04 00 00 50 68 1F 00 02 00 6A 00 8D 85 7A 04 00 00 50 }
        $b = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 3A 04 00 00 89 28 33 FF 8D 85 80 03 00 00 8D 8D 3A 04 00 00 2B C8 8B 9D 8A 04 00 00 E8 24 02 00 00 8D 9D 58 03 00 00 8D B5 7F 03 00 00 46 80 3E 00 74 24 56 FF 95 58 05 00 00 46 80 3E 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PowerBASICWin_800_additional: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 14 04 00 00 E9 19 02 }
    condition:
        $a at pe.entry_point

}

rule HP_48sx_graphics_format: PEiD
{
    strings:
        $a = { 48 50 48 50 34 38 2D 41 }
    condition:
        $a at pe.entry_point

}

rule nSpack_V11_LiuXingPing: PEiD
{
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 57 84 40 00 2D 50 84 40 00 }
    condition:
        $a at pe.entry_point

}

rule BGI_Stroked_Font_v11: PEiD
{
    strings:
        $a = { 50 4B 08 08 42 47 49 20 53 74 72 6F 6B 65 64 20 46 6F 6E 74 20 56 31 2E 31 }
    condition:
        $a at pe.entry_point

}

rule Upack_v039_final: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 39 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_ASPack_212_emadicius_h_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule VX_TibsZhelatin_StormWorm_variant: PEiD
{
    strings:
        $a = { FF 74 24 1C 58 8D 80 ?? ?? 77 04 50 68 62 34 35 04 E8 }
    condition:
        $a at pe.entry_point

}

rule pirit_v15_additional: PEiD
{
    strings:
        $a = { 5B 24 55 50 44 FB 32 2E 31 5D }
    condition:
        $a at pe.entry_point

}

rule SimplePack_1X_Method2_bagie: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Shrink_v10: PEiD
{
    strings:
        $a = { 50 9C FC BE ?? ?? BF ?? ?? 57 B9 ?? ?? F3 A4 8B ?? ?? ?? BE ?? ?? BF ?? ?? F3 A4 C3 }
    condition:
        $a at pe.entry_point

}

rule Private_exe_Protector_V314_SetiSoft_Team_Mato_20100705: PEiD
{
    strings:
        $a = { 50 00 72 00 69 00 76 00 61 00 74 00 65 00 20 00 65 00 78 00 65 00 20 00 50 00 72 00 6F 00 74 00 65 00 63 00 74 00 6F 00 72 00 00 00 34 00 08 00 01 00 50 00 72 00 6F 00 64 00 75 00 63 00 74 00 56 00 65 00 72 00 73 00 69 00 6F 00 6E 00 00 00 33 00 2E 00 31 00 2E 00 34 00 2E 00 30 }
    condition:
        $a at pe.entry_point

}

rule PowerBASICCC_40_: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 68 05 00 00 E9 6E 03 }
    condition:
        $a at pe.entry_point

}

rule tElock_v100_additional: PEiD
{
    strings:
        $a = { E9 E5 E2 FF FF }
    condition:
        $a at pe.entry_point

}

rule WinZip_Self_Extractor_22_personal_edition_WinZip_Computing: PEiD
{
    strings:
        $a = { 53 FF 15 58 70 40 00 B3 22 38 18 74 03 80 C3 FE 40 33 D2 8A 08 3A CA 74 10 3A CB 74 07 40 8A 08 3A CA 75 F5 38 10 74 01 40 52 50 52 52 FF 15 5C 70 40 00 50 E8 15 FB FF FF 50 FF 15 8C 70 40 00 5B }
    condition:
        $a at pe.entry_point

}

rule SimplePack_V11X_Method2_bagie: PEiD
{
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 }
        $b = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
        $c = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule BeRoEXEPacker_v100_LZBRS_additional: PEiD
{
    strings:
        $a = { 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 ?? ?? ?? ?? 72 03 A4 EB F2 E8 ?? ?? ?? ?? 8D 51 FF E8 ?? ?? ?? ?? 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_BJFNT_13_emadicius: PEiD
{
    strings:
        $a = { EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 61 9D 1F EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 }
    condition:
        $a at pe.entry_point

}

rule FSG_V130Eng_dulekxt: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? 00 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE 0F 74 EF FE 0F 75 06 47 FF 37 AF EB 09 FE 0F 0F 84 ?? ?? ?? FF 57 55 FF 53 04 09 06 AD 75 DB 8B EC C3 ?? ?? ?? 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v10802_additional: PEiD
{
    strings:
        $a = { 90 75 01 90 E9 }
    condition:
        $a at pe.entry_point

}

rule StarForce_V3X_DLL_StarForce_Copy_Protection_System: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2620_V2623_Jitit_Sign_by_fly: PEiD
{
    strings:
        $a = { E8 00 00 00 00 58 BB AC 1E 00 00 2B C3 50 68 ?? ?? ?? ?? 68 B0 21 00 00 68 C4 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule AntiDote_v14_osCE: PEiD
{
    strings:
        $a = { 68 95 01 00 00 E8 D0 FD FF FF 68 95 01 00 00 E8 C3 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_430_440_Silicon_Realms_Toolworks_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 40 ?? ?? 00 68 80 ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 ?? ?? 00 33 D2 8A D4 89 15 30 ?? ?? 00 8B C8 81 E1 FF 00 00 00 89 0D 2C ?? ?? 00 C1 E1 08 03 CA 89 0D 28 ?? ?? 00 C1 E8 10 A3 24 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_sig4_h_additional: PEiD
{
    strings:
        $a = { C3 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule TurboChainer_103: PEiD
{
    strings:
        $a = { BA 24 00 8E DA 8C D3 2B DA D1 E3 D1 E3 D1 E3 D1 E3 FA 8E D2 03 E3 FB B8 24 00 8E D8 1E FC 8D 06 B0 00 83 C0 0C 50 1E BE 80 00 8C C0 8E D8 07 5F 8B 0C 32 ED 51 46 F3 A4 59 1F 00 0E AF 00 1E B4 51 32 C0 CD 21 8E DB BB 2C 00 8B 07 8E D8 33 DB }
    condition:
        $a at pe.entry_point

}

rule PECompact_v133: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A6 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 00 80 40 ?? 90 90 01 85 9E 80 40 ?? BB E8 0E }
    condition:
        $a at pe.entry_point

}

rule ASPack_v2001_additional: PEiD
{
    strings:
        $a = { 60 E8 72 05 00 00 EB 33 87 DB 90 00 }
    condition:
        $a at pe.entry_point

}

rule Morphine_v12_additional: PEiD
{
    strings:
        $a = { 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? 00 00 00 66 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 51 66 ?? ?? ?? 59 }
    condition:
        $a at pe.entry_point

}

rule PocketPC_ARM: PEiD
{
    strings:
        $a = { F0 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 03 70 A0 E1 ?? 00 00 EB 07 30 A0 E1 06 20 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? EB F0 40 BD E8 ?? 00 00 EA ?? 40 2D E9 ?? ?? 9F E5 ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 9F E5 00 ?? ?? ?? ?? 00 }
        $b = { F0 40 2D E9 00 40 A0 E1 01 50 A0 E1 02 60 A0 E1 03 70 A0 E1 ?? 00 00 EB 07 30 A0 E1 06 20 A0 E1 05 10 A0 E1 04 00 A0 E1 ?? ?? ?? EB F0 40 BD E8 ?? 00 00 EA ?? 40 2D E9 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Packman_0001_Bubbasoft_h_additional: PEiD
{
    strings:
        $a = { 0F 85 ?? FF FF FF 8D B3 ?? ?? ?? ?? EB 3D 8B 46 0C 03 C3 50 FF 55 00 56 8B 36 0B F6 75 02 8B F7 03 F3 03 FB EB 1B D1 C1 D1 E9 73 05 0F B7 C9 EB 05 03 CB 8D 49 02 50 51 50 FF 55 04 AB 58 83 C6 04 8B 0E 85 C9 75 DF 5E 83 C6 14 8B 7E 10 85 FF 75 BC 8D 8B 00 00 ?? ?? B8 00 ?? ?? 00 0B C0 74 34 03 C3 EB 2A 8D 70 08 03 40 04 33 ED 33 D2 66 8B 2E 66 0F A4 EA 04 80 FA 03 75 0D 81 E5 FF 0F 00 00 03 EF 03 EB 01 4D 00 46 46 3B F0 75 DC 8B 38 85 FF 75 D0 61 E9 ?? FE FF FF 02 D2 75 05 8A 16 46 12 D2 C3 }
    condition:
        $a at pe.entry_point

}

rule Software_Compress_v14_LITE_BG_Software_Protect_Technologies_h: PEiD
{
    strings:
        $a = { E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A 41 00 8B 4A 64 89 8D 51 1A 41 00 8B 4A 74 89 8D 59 1A 41 00 68 00 20 00 00 E8 D2 00 00 00 50 8D 8D 00 1C 41 00 50 51 E8 1B 00 00 00 83 C4 08 58 8D 78 74 8D B5 49 1A 41 00 B9 18 00 00 00 F3 A4 05 A4 00 00 00 50 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 FF 74 24 24 6A 40 FF 95 4D 1A 41 00 89 44 24 1C 61 C2 04 }
        $b = { E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Vx_Horse1776_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? 5D 83 ?? ?? 06 1E 26 ?? ?? ?? ?? BF ?? ?? 1E 0E 1F 8B F7 01 EE B9 ?? ?? FC F3 A6 1F 1E 07 }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_DLL_BeRo_Farbrausch: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC B2 80 33 DB A4 B3 02 E8 ?? ?? ?? ?? 73 F6 33 C9 E8 ?? ?? ?? ?? 73 1C 33 C0 E8 ?? ?? ?? ?? 73 23 B3 02 41 B0 10 }
        $b = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_R_Incremental_Linker_Version_5128078_MASMTASM: PEiD
{
    strings:
        $a = { 6A 00 68 00 30 40 00 68 1E 30 40 00 6A 00 E8 0D 00 00 00 6A 00 E8 00 00 00 00 FF 25 00 20 40 00 FF 25 08 20 40 }
    condition:
        $a at pe.entry_point

}

rule Upack_v02_Beta_Dwing: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 95 A5 33 C0 33 }
    condition:
        $a at pe.entry_point

}

rule TopSpeed_v301_1989_Hint_DOS_EP: PEiD
{
    strings:
        $a = { 1E BA ?? ?? 8E DA 8B ?? ?? ?? 8B ?? ?? ?? FF ?? ?? ?? 50 53 }
    condition:
        $a at pe.entry_point

}

rule File_Analyzer_Extended_Datafile_Version_additional: PEiD
{
    strings:
        $a = { 23 03 45 58 54 44 ?? ?? 3A 03 }
    condition:
        $a at pe.entry_point

}

rule MIDI_Music_file_additional: PEiD
{
    strings:
        $a = { 4D 54 68 64 00 00 00 06 ?? ?? ?? ?? ?? ?? 4D 54 }
    condition:
        $a at pe.entry_point

}

rule Upack_v030_beta_Dwing: PEiD
{
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 30 }
    condition:
        $a at pe.entry_point

}

rule CodeCrypt_v015b_additional: PEiD
{
    strings:
        $a = { E9 2E 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F EB 03 FF 1D 34 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_2x_SoftComplete_Developement: PEiD
{
    strings:
        $a = { A4 ?? ?? 00 00 00 00 00 FF FF FF FF 3C ?? ?? 00 94 ?? ?? 00 D8 ?? ?? 00 00 00 00 00 FF FF FF FF }
    condition:
        $a at pe.entry_point

}

rule QuickLink_II_Fax_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 51 4C 49 49 46 41 58 20 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_123_RC4_build_0807_dll_Alexey_Solodovnikov_h: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_v30_DLL_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 0B 00 00 60 BE 00 ?? ?? ?? 8D BE 00 ?? ?? FF 57 89 E5 8D 9C 24 80 C1 FF FF 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule Turbo_C_1987_additional: PEiD
{
    strings:
        $a = { FB BA ?? ?? 2E 89 ?? ?? ?? B4 30 CD 21 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_LCC_Win32_1x_Anorganix: PEiD
{
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_With_CRC_check_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B3 ?? B9 ?? ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 43 49 32 E4 03 D0 E3 }
    condition:
        $a at pe.entry_point

}

rule XComp_V097_LZRW_JoKo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 9C 60 E8 9B 02 00 00 34 ?? ?? 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 34 ?? ?? 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ENIGMA_Protector_V11_Sukhov_Vladimir_: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 }
    condition:
        $a at pe.entry_point

}

rule Sun_Icon_Graphics_format: PEiD
{
    strings:
        $a = { 2F 2A 20 46 6F 72 6D 61 74 5F 76 65 72 73 69 6F 6E 3D 31 2C }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_V22006710_WFS_additional: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_SCRAMBLER_306_OnToL_additional: PEiD
{
    strings:
        $a = { E8 00 00 00 00 59 83 C1 07 51 C3 C3 BE ?? ?? ?? ?? 83 EC 04 89 34 24 B9 80 00 00 00 81 36 ?? ?? ?? ?? 50 B8 04 00 00 00 50 03 34 24 58 58 83 E9 03 E2 E9 EB D6 }
    condition:
        $a at pe.entry_point

}

rule Exact_Audio_Copy_UnknownCompiler_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule PESpin_11_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        $a at pe.entry_point

}

rule Alias_PIXVivid_IMG_Graphics_format_additional: PEiD
{
    strings:
        $a = { 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01 }
    condition:
        $a at pe.entry_point

}

rule MASM32_TASM32: PEiD
{
    strings:
        $a = { 2B C0 50 E8 }
    condition:
        $a at pe.entry_point

}

rule UPXHiT_001_DJ_Siba: PEiD
{
    strings:
        $a = { E2 FA 94 FF E0 61 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Upack_037_beta_Dwing_additional: PEiD
{
    strings:
        $a = { BE E0 11 ?? ?? FF 36 E9 C3 00 00 00 48 01 ?? ?? 0B 01 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C }
    condition:
        $a at pe.entry_point

}

rule Vx_GRUNT2Family_additional: PEiD
{
    strings:
        $a = { 48 E2 F7 C3 51 53 52 E8 DD FF 5A 5B 59 C3 B9 00 00 E2 FE C3 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1400Beta_Obsidium_Software_SignByfly_20080102_additional: PEiD
{
    strings:
        $a = { EB 01 ?? E8 2F 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 }
    condition:
        $a at pe.entry_point

}

rule InstallShield_Stub_2003: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 C8 3B 42 00 68 ?? B8 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 C0 31 42 00 33 D2 8A D4 89 15 ?? EB 42 00 8B C8 81 E1 FF 00 00 00 89 0D ?? EB 42 00 C1 E1 08 03 CA 89 0D ?? EB 42 00 C1 E8 10 A3 ?? EB 42 00 6A 01 E8 C0 1C 00 00 59 85 C0 75 08 6A }
    condition:
        $a at pe.entry_point

}

rule Thinstall_Embedded_V2312_Jitit_Sign_by_fly_additional: PEiD
{
    strings:
        $a = { B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 B9 FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098b2_tHE_EGOiSTE: PEiD
{
    strings:
        $a = { E9 1B E4 FF FF }
    condition:
        $a at pe.entry_point

}

rule Software_Compress_v14_LITE_BG_Software_Protect_Technologies: PEiD
{
    strings:
        $a = { E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_v13x_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? ?? 00 64 A0 23 }
    condition:
        $a at pe.entry_point

}

rule SDProtector_BasicPro_Edition_112_Randy_Li_h_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 7B 03 00 00 03 C8 74 C4 75 C2 E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E2 }
    condition:
        $a at pe.entry_point

}

rule Limit_Archive: PEiD
{
    strings:
        $a = { 4C 4D 1A }
    condition:
        $a at pe.entry_point

}

rule RoseTiny_095: PEiD
{
    strings:
        $a = { 50 53 B4 30 CD 21 86 E0 3D 00 03 73 02 CD 20 06 50 2B C0 8E C0 85 06 0B EA B8 EB 03 EB FC EA 26 81 36 05 00 D8 83 85 06 1C EA B8 EB 03 EB FC EA 26 81 36 0D 00 0B 9E 85 06 2D EA B8 EB 03 EB FC EA 26 81 36 41 00 BF B4 EB 01 81 58 07 50 B8 EB }
    condition:
        $a at pe.entry_point

}

rule Alex_Protector_v04_beta_1_by_Alex_additional: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 00 00 00 00 49 E8 01 00 00 00 68 83 C4 04 85 C9 75 DF E8 B9 02 00 00 E8 01 00 00 00 C7 83 C4 04 8D 95 63 14 40 00 E8 01 00 00 00 C7 83 C4 04 90 90 90 E8 CA 01 00 00 01 02 03 04 05 68 90 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v120: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 B4 4C CD 21 }
    condition:
        $a at pe.entry_point

}

rule Exe_Guarder_v18_Exeiconcom_h: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 }
        $b = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 5D EC 8B 41 18 8B C8 49 85 C9 72 5A 41 33 C0 8B D8 C1 E3 02 03 DA 8B 3B 03 3E 81 3F 47 65 74 50 75 40 8B DF 83 C3 04 81 3B 72 6F 63 41 75 33 8B DF 83 C3 08 81 3B 64 64 72 65 75 26 83 C7 0C 66 81 3F 73 73 75 1C 8B D0 03 D2 03 55 F0 0F B7 12 C1 E2 02 03 55 EC 8B 12 03 16 8B 4D F4 89 51 08 EB 04 40 49 75 A9 8B 5D F4 8D 83 A1 00 00 00 50 8B 06 50 FF 53 08 89 43 0C 8D 83 AE 00 00 00 50 8B 06 50 FF 53 08 89 43 10 8D 83 BA 00 00 00 50 8B 06 50 FF 53 08 89 43 14 8D 83 C6 00 00 00 50 8B 06 50 FF 53 08 89 43 18 8D 83 D7 00 00 00 50 8B 06 50 FF 53 08 89 43 1C 8D 83 E0 00 00 00 50 8B 06 50 FF 53 08 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ProtEXE_211_EXE: PEiD
{
    strings:
        $a = { 9C 9C 58 25 FF 0F 50 9D 9C 58 25 00 F0 3D 00 F0 74 2A 9C 58 25 FF 0F 0D 00 70 50 9D 9C 58 25 00 70 74 19 BA 64 00 B0 AD EB 01 88 EE EB 01 A0 0F 20 00 F8 BA 64 00 B0 AE EB 01 88 EE 9D 1E 06 33 C0 8E D8 FF 36 0C 00 FF 36 0E 00 B8 00 02 A3 0C }
    condition:
        $a at pe.entry_point

}

rule PESpin_v01_Cyberbob: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 B3 28 40 00 8B 42 3C 03 C2 89 85 BD 28 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D D1 28 40 00 53 8F 85 C4 27 40 00 BB ?? 00 00 00 B9 A5 08 00 00 8D BD 75 29 40 00 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D BD AA 30 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 07 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D C4 28 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 59 81 C1 1D 00 00 00 52 51 C1 E9 05 23 D1 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ENIGMA_Protector_Sukhov_Vladimir_additional: PEiD
{
    strings:
        $a = { 45 6E 69 67 6D 61 20 70 72 6F 74 65 63 74 6F 72 20 76 31 }
    condition:
        $a at pe.entry_point

}

rule PESpin_V03_cyberbob_20080312: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 CB 2C 40 00 8B 42 3C 03 C2 89 85 D5 2C 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D E9 2C 40 00 53 8F 85 B6 2B 40 00 BB ?? 00 00 00 B9 75 0A 00 00 8D BD 7E 2D 40 00 4F 30 1C 39 FE CB E2 F9 68 3C 01 00 00 59 8D BD B6 36 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 1F 53 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D DC 2C 40 00 }
    condition:
        $a at pe.entry_point

}

rule D1NS1G_D1N: PEiD
{
    strings:
        $a = { 18 37 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 F0 00 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 F0 00 00 60 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 18 37 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? 18 37 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Borland_PE_loader: PEiD
{
    strings:
        $a = { 8C C8 8E D8 8C 1E 42 00 8C 06 3C 00 8C 06 46 00 8C 06 4A 00 8B DC 83 C3 0F D1 EB D1 EB D1 EB D1 EB 8C D0 03 D8 2B 1E 3C 00 B8 00 4A CD 21 B8 42 FB BB 33 32 CD 2F 83 FB 00 0F 84 00 01 BA 52 00 1E 07 BB 3E 00 B8 00 4B CD 21 0F 83 00 01 8E 06 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v107b: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D B8 03 }
        $b = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 2B 85 ?? 0B DE ?? 89 85 17 DE ?? ?? 80 BD 01 DE }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Protect_60: PEiD
{
    strings:
        $a = { 1E B4 30 CD 21 3C 02 73 02 CD 20 BE 00 00 E8 18 00 E8 08 00 1F 8C D8 8E C0 E9 15 00 BB 00 00 B4 00 AC 04 00 AA 4B 75 F9 C3 0E 1F FC 0E 07 8B FE C3 }
    condition:
        $a at pe.entry_point

}

rule Themida_10xx_1800_compressed_engine_Oreans_Technologies_additional: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 }
    condition:
        $a at pe.entry_point

}

rule EXEJoiner_v10_additional: PEiD
{
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 C6 00 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 }
    condition:
        $a at pe.entry_point

}

rule MSLRH_032a_fake_yodas_cryptor_12_emadicius_additional: PEiD
{
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 20 64 65 63 6F 6D 70 72 65 73 73 69 6F 6E 20 72 6F 75 74 69 6E 65 20 76 65 72 73 69 6F 6E 20 31 2E 31 32 0D 0A 28 63 29 20 31 39 39 38 20 50 69 6F 74 72 20 57 61 72 65 7A 61 6B 20 61 6E 64 20 52 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098b1: PEiD
{
    strings:
        $a = { E9 1B E4 FF }
        $b = { E9 25 E4 FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule tElock_v098b2: PEiD
{
    strings:
        $a = { E9 FF FF ?? ?? ?? ?? ?? ?? ?? }
        $b = { E9 1B E4 FF FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ASProtect_10_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 90 5D 81 ED ?? ?? ?? 00 BB ?? ?? ?? 00 03 DD 2B 9D }
    condition:
        $a at pe.entry_point

}

rule RECSmall_v102_additional: PEiD
{
    strings:
        $a = { 8C D8 1E E8 ?? ?? 83 ?? ?? 5D B9 ?? ?? 81 ?? ?? ?? 40 8E D8 2B DB B2 ?? ?? ?? FE C2 43 83 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v305c4_Extractable: PEiD
{
    strings:
        $a = { 03 05 00 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        $a at pe.entry_point

}

rule RLPack_Full_Edition_117_LZMA: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 73 26 00 00 8D 9D 58 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A }
    condition:
        $a at pe.entry_point

}

rule WATCOM_CCpp_DLL_additional: PEiD
{
    strings:
        $a = { 53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F 87 }
    condition:
        $a at pe.entry_point

}

rule LY_WGKX_V2X_wwwszleyucom_20080122: PEiD
{
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule Themida_1920_additional: PEiD
{
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? ?? ?? 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 14 02 00 00 }
    condition:
        $a at pe.entry_point

}

rule tElock_096_tE_additional: PEiD
{
    strings:
        $a = { E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_70_80: PEiD
{
    strings:
        $a = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 }
    condition:
        $a at pe.entry_point

}

rule vfpexeNc_v600_Wang_JianGuo_additional: PEiD
{
    strings:
        $a = { 60 E8 01 00 00 00 63 58 E8 01 00 00 00 7A 58 2D 0D 10 40 00 8D 90 C1 10 40 00 52 50 8D 80 49 10 40 00 5D 50 8D 85 65 10 40 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC }
    condition:
        $a at pe.entry_point

}

rule _Protector_v1111_DDeM_PE_Engine_v09_DDeM_CI_v092: PEiD
{
    strings:
        $a = { 53 51 56 E8 00 00 00 00 5B 81 EB 08 10 00 00 8D B3 34 10 00 00 B9 F3 03 00 00 BA 63 17 2A EE 31 16 83 C6 04 }
    condition:
        $a at pe.entry_point

}

rule Vx_Einstein_additional: PEiD
{
    strings:
        $a = { 00 42 CD 21 72 31 B9 6E 03 33 D2 B4 40 CD 21 72 19 3B C1 75 15 B8 00 42 }
    condition:
        $a at pe.entry_point

}

rule UPX_com_additional: PEiD
{
    strings:
        $a = { B9 ?? ?? BE ?? ?? BF C0 FF FD }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v300_v301_Relocations_pack_additional: PEiD
{
    strings:
        $a = { BE ?? ?? BA ?? ?? BF ?? ?? B9 ?? ?? 8C CD 8E DD 81 ED ?? ?? 06 06 8B DD 2B DA 8B D3 FC }
    condition:
        $a at pe.entry_point

}

rule PESpin_07_Cyberbob_h: PEiD
{
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
        $b = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Obsidium_13037_Obsidium_Software: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        $a at pe.entry_point

}

rule tElock_099: PEiD
{
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 }
        $b = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule PseudoSigner_01_LTC_13_Anorganix: PEiD
{
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 E9 }
    condition:
        $a at pe.entry_point

}

rule RLPack_V112_LZMA_430_ap0x: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 60 }
    condition:
        $a at pe.entry_point

}

rule BeRoEXEPacker_v100_LZMA_BeRo_Farbrausch: PEiD
{
    strings:
        $a = { 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 }
    condition:
        $a at pe.entry_point

}

rule JPEG_Graphics_format_p_description_Hint_FILE_START: PEiD
{
    strings:
        $a = { FF D8 FF FE 00 27 }
    condition:
        $a at pe.entry_point

}

rule PKLITE_v150_1_additional: PEiD
{
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 ?? BA ?? ?? CD 21 B8 ?? ?? CD 21 }
    condition:
        $a at pe.entry_point

}

rule Upack_v037_v038_Beta_Strip_base_relocation_table_Option_Sign_by_hot_UNP: PEiD
{
    strings:
        $a = { 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 33 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V6X_Dll_Silicon_Realms_Toolworks_20081227: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 D0 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 80 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 42 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 }
    condition:
        $a at pe.entry_point

}

rule Vx_VirusConstructorIVPbased: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5D ?? ?? ?? ?? ?? 81 ED ?? ?? ?? ?? ?? ?? E8 ?? ?? 81 FC ?? ?? ?? ?? 8D ?? ?? ?? BF ?? ?? 57 A4 A5 }
    condition:
        $a at pe.entry_point

}

rule WWPACK_v300_v301_Relocations_pack: PEiD
{
    strings:
        $a = { BE ?? ?? BA ?? ?? BF ?? ?? B9 ?? ?? 8C CD 8E DD 81 ED ?? ?? 06 06 8B DD 2B DA 8B D3 FC }
    condition:
        $a at pe.entry_point

}

rule aPack_098_099_t_EXE: PEiD
{
    strings:
        $a = { 1E 06 0E 1F 0E 07 BE 13 00 BF 00 7F 8B CF FC 57 F3 A4 C3 33 FF BE 00 7F B2 80 BD 00 7F 50 A4 BB 10 00 FF D5 73 F8 FF D5 41 73 0F FF D5 72 24 FF D5 12 DB 73 FA 75 00 93 EB 00 B7 01 FF D5 12 FF 72 00 FF D5 72 F6 FF D5 13 C9 FF D5 72 F8 80 EF }
    condition:
        $a at pe.entry_point

}

rule XComp_V098_LZSS_JoKo: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? 00 9C 60 E8 E5 02 00 00 34 ?? ?? 00 00 00 00 00 00 00 00 00 4C ?? ?? 00 34 ?? ?? 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule COM2TXT_103_112: PEiD
{
    strings:
        $a = { 54 5F 4F 4F 57 57 33 3D 58 58 57 58 35 20 32 50 59 35 77 33 50 5F 2D 6C 2E 50 2D 4B 44 31 45 70 2D 4F 4C 50 5A 2D 70 4A 50 2D 70 77 34 30 50 51 58 35 66 73 50 75 0D 0A 00 00 00 00 00 00 00 00 00 00 00 00 35 46 65 2C 78 50 51 58 2D 3D 2E 50 }
    condition:
        $a at pe.entry_point

}

rule ASPack_100b_Solodovnikov_Alexey: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 92 1A 44 00 B8 8C 1A 44 00 03 C5 2B 85 CD 1D 44 00 89 85 D9 1D 44 00 80 BD C4 1D 44 }
    condition:
        $a at pe.entry_point

}

rule Code_Virtualizer_V1310_Oreans_Technologies: PEiD
{
    strings:
        $a = { 60 9C FC E8 00 00 00 00 5F 81 EF ?? ?? ?? ?? 8B C7 81 C7 ?? ?? ?? ?? 3B 47 2C 75 02 EB 2E 89 47 2C B9 A7 00 00 00 EB 05 01 44 8F ?? 49 0B C9 75 F7 83 7F 40 00 74 15 8B 77 40 03 F0 EB 09 8B 1E 03 D8 01 03 83 C6 04 83 3E 00 75 F2 8B 74 24 24 8B DE 03 F0 B9 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Windows_Update_CAB_SFX_module_additional: PEiD
{
    strings:
        $a = { E9 C5 FA FF FF 55 8B EC 56 8B 75 08 68 04 08 00 00 FF D6 59 33 C9 3B C1 75 0F 51 6A 05 FF 75 28 E8 2E 11 00 00 33 C0 EB 69 8B 55 0C 83 88 88 00 00 00 FF 83 88 84 00 00 00 FF 89 50 04 8B 55 10 89 50 0C 8B 55 14 89 50 10 8B 55 18 89 50 14 8B 55 1C 89 50 18 }
    condition:
        $a at pe.entry_point

}

rule CodeCrypt_0163b: PEiD
{
    strings:
        $a = { EB 02 0F 4D 55 EB 02 0F C7 E8 00 00 00 00 EB 02 83 3D 5D EB 03 0F CA 0F 81 ED 6D 23 40 00 52 8B 54 24 08 E8 A5 FD FF FF 89 95 59 2B 40 00 5A EB 02 0F 4D EB 02 FF 1D EB 02 0F C7 EB 02 0F C0 EB 03 0F CA 0F EB 03 FF 1D 34 EB 02 83 3D EB 02 C7 }
    condition:
        $a at pe.entry_point

}

rule HackStop_112_EXE: PEiD
{
    strings:
        $a = { 52 1E B4 30 CD 21 86 E0 3D FF 02 73 02 CD 20 0E 1F B4 09 E8 03 00 24 24 EA 5A CD 21 1F 5A 53 BB EB 04 5B EB FB 9A E8 7B 06 55 FA 8B EC C7 46 FE 00 00 8B 46 FE 50 9C 16 17 9D FB 58 A9 00 01 74 06 B0 FF B4 4C CD 21 5D E8 41 00 8D E8 E6 06 11 }
    condition:
        $a at pe.entry_point

}

rule EXECryptor_151_153_SoftComplete_Development: PEiD
{
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80 A1 C1 00 00 00 FE C3 31 C0 64 FF 30 64 89 20 CC C3 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_310: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 }
    condition:
        $a at pe.entry_point

}

rule EncryptPE_22004810_22005314_WFS: PEiD
{
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 7A }
    condition:
        $a at pe.entry_point

}

rule AZProtect: PEiD
{
    strings:
        $a = { EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 }
    condition:
        $a at pe.entry_point

}

rule Packman_0001_bubba_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 8D A8 ?? FE FF FF 8D 98 ?? ?? ?? FF 8D ?? ?? 01 00 00 }
    condition:
        $a at pe.entry_point

}

rule Xenocode_Virtual_Application_Studio_Xenocode_20090203: PEiD
{
    strings:
        $a = { 58 00 65 00 6E 00 6F 00 63 00 6F 00 64 00 65 00 20 00 56 00 69 00 72 00 74 00 75 00 61 00 6C 00 20 00 41 00 70 00 70 00 6C 00 69 00 61 00 6E 00 63 00 65 00 20 00 52 00 75 00 6E 00 74 00 69 00 6D 00 65 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 31 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 32 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 33 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 34 00 00 00 00 00 30 00 78 00 30 00 30 00 31 00 35 00 }
    condition:
        $a at pe.entry_point

}

rule Private_EXE_20a: PEiD
{
    strings:
        $a = { 53 E8 00 00 00 00 5B 8B C3 2D 00 00 00 00 50 81 EB 06 10 40 00 8B 83 E7 10 40 00 81 38 E8 2F F5 FD 0F 85 A4 00 00 00 8D 83 23 11 40 00 50 FF 93 EB 10 40 00 0B C0 74 78 90 90 90 90 89 83 1F 11 40 00 8D 83 27 11 40 00 50 FF B3 1F 11 40 00 FF }
    condition:
        $a at pe.entry_point

}

rule Crunch_40: PEiD
{
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 }
    condition:
        $a at pe.entry_point

}

rule nSpack_V23_LiuXingPing: PEiD
{
    strings:
        $a = { 9C 60 70 61 63 6B 24 40 }
    condition:
        $a at pe.entry_point

}

rule FSG_110_Eng_dulekxt_Borland_Cpp: PEiD
{
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 }
        $b = { 23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB F4 00 00 00 EB 02 04 FA EB 01 FA EB 01 5F EB 02 CD 20 8A 16 EB 02 11 31 80 E9 31 EB 02 30 11 C1 E9 11 80 EA 04 EB 02 F0 EA 33 CB 81 EA AB AB 19 08 04 D5 03 C2 80 EA }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Pelles_C_300_400_450_EXE_X86_CRT_LIB: PEiD
{
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 02 E8 ?? ?? ?? ?? 59 A3 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_14: PEiD
{
    strings:
        $a = { 1E 06 8C C8 8E D8 8C C0 A3 ?? ?? 83 C0 ?? A3 ?? ?? B4 30 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_11: PEiD
{
    strings:
        $a = { B4 51 CD 21 8E DB B8 ?? ?? 83 E8 ?? 8E C0 33 F6 33 FF B9 ?? ?? FC F3 A5 }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_13: PEiD
{
    strings:
        $a = { BF ?? ?? 8E DF FA 8E D7 81 C4 ?? ?? FB 33 DB B8 ?? ?? CD 21 }
    condition:
        $a at pe.entry_point

}

rule PROTECT_EXECOM_v40_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 5D 81 ED ?? ?? 33 C0 8E D8 8B F0 BF ?? ?? B9 ?? ?? FC F3 A5 }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_02_Microsoft_Visual_Basic_50_60: PEiD
{
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule RE_Crypt_v07x_Crudd_RET_h2_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 55 81 04 24 0A 00 00 00 C3 8B F5 81 C5 ?? ?? 00 00 89 6D 34 89 75 38 8B 7D 38 81 E7 00 FF FF FF 81 C7 48 00 00 00 47 03 7D 60 8B 4D 5C 83 F9 00 7E 0F 8B 17 33 55 58 89 17 83 C7 04 83 C1 FC EB EC 8B }
    condition:
        $a at pe.entry_point

}

rule fEaRzCrypter_v10_fEaRz: PEiD
{
    strings:
        $a = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 ?? 53 56 57 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 ?? 6A 00 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_1994_additional: PEiD
{
    strings:
        $a = { 8C CA 2E 89 ?? ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA A3 ?? ?? 8C }
    condition:
        $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_07_additional: PEiD
{
    strings:
        $a = { 2E 8C 1E ?? ?? BB ?? ?? 8E DB 1E E8 ?? ?? 1F 8B 1E ?? ?? 0B DB 74 ?? 8C D1 8B D4 FA 8E D3 BC ?? ?? FB }
    condition:
        $a at pe.entry_point

}

rule PECompact_v098: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB D7 84 40 ?? 87 DD 8B 85 5C 85 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v099: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 2F 85 40 ?? 87 DD 8B 85 B4 85 }
    condition:
        $a at pe.entry_point

}

rule Borland_Cpp_for_Win16_1991_additional: PEiD
{
    strings:
        $a = { 9A FF FF 00 00 0B C0 75 ?? E9 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? B8 FF FF 50 9A FF FF 00 00 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v090: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? 40 00 C3 9C 60 BD ?? ?? 00 00 B9 02 00 00 00 B0 90 8D BD 7A 42 40 00 F3 AA 01 AD D9 43 40 00 FF B5 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v092: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 BD ?? ?? ?? ?? B9 02 ?? ?? ?? B0 90 8D BD A5 4F 40 ?? F3 AA 01 AD 04 51 40 ?? FF B5 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v094: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 ?? ?? ?? ?? 5D 55 58 81 ED ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 01 85 ?? ?? ?? ?? 50 B9 02 }
    condition:
        $a at pe.entry_point

}

rule deep_CRyPTer_v01c_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E9 ?? ?? E8 ?? ?? 59 8B E9 81 ?? ?? ?? 81 ?? ?? ?? BE ?? ?? 8D ?? ?? ?? 66 ?? ?? 66 ?? ?? 8D ?? ?? ?? 8B D7 8B DF }
    condition:
        $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_vxx: PEiD
{
    strings:
        $a = { 53 55 56 8B 85 F6 57 B8 75 8B 85 C9 75 33 C0 5F 5E 5D 5B }
        $b = { 53 55 56 8B ?? ?? ?? 85 F6 57 B8 ?? ?? ?? ?? 75 ?? 8B ?? ?? ?? ?? ?? 85 C9 75 ?? 33 C0 5F 5E 5D 5B C2 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule InstallShield_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 2A AB 79 D8 }
    condition:
        $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp_ASM_: PEiD
{
    strings:
        $a = { EB 02 CD 20 EB 02 CD 20 EB 02 CD 20 C1 E6 18 BB 80 ?? ?? 00 EB 02 82 B8 EB 01 10 8D 05 F4 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v101b_additional: PEiD
{
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED CE 3A 44 ?? B8 C8 3A 44 ?? 03 C5 2B 85 B5 3E 44 ?? 89 85 C1 3E 44 ?? 80 BD AC 3E 44 }
    condition:
        $a at pe.entry_point

}

rule NoobyProtect_V1290_Nooby_20090218: PEiD
{
    strings:
        $a = { E9 ?? 00 00 00 4E 6F 6F 62 79 50 72 6F 74 65 63 74 20 53 45 20 31 2E 32 2E 39 2E 30 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_01_Morphine_12: PEiD
{
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 E2 90 90 90 EB 08 82 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 01 E9 }
        $b = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _v10_additional: PEiD
{
    strings:
        $a = { 64 A1 00 00 00 00 55 89 E5 6A FF 68 1C 30 40 00 }
    condition:
        $a at pe.entry_point

}

rule Exe_Guarder_v18_Exeiconcom_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D B2 04 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 }
    condition:
        $a at pe.entry_point

}

rule MoleBox_v20_additional: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? 60 E8 4F }
    condition:
        $a at pe.entry_point

}

rule Mew_501_NorthFox_HCC: PEiD
{
    strings:
        $a = { BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 ?? 04 ?? C0 C8 ?? AA E2 F4 C3 00 ?? ?? 00 ?? ?? ?? 00 00 10 40 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D }
        $b = { BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 ?? 04 ?? C0 C8 ?? AA E2 F4 C3 00 ?? ?? 00 ?? ?? ?? 00 00 10 40 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule EXECryptor_2xx_compressed_resources_wwwstrongbitcom: PEiD
{
    strings:
        $a = { 56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89 }
    condition:
        $a at pe.entry_point

}

rule PC_Shrinker_v071: PEiD
{
    strings:
        $a = { 9C 60 BD ?? ?? ?? ?? 01 AD 54 3A 40 ?? FF B5 50 3A 40 ?? 6A 40 FF 95 88 3A 40 ?? 50 50 2D ?? ?? ?? ?? 89 85 }
    condition:
        $a at pe.entry_point

}

rule EP_v01_CoDe_Inside: PEiD
{
    strings:
        $a = { 50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC AA 86 C4 }
    condition:
        $a at pe.entry_point

}

rule Symantec_WinFax_PRO_75_Coverpage_additional: PEiD
{
    strings:
        $a = { 0C BD 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 06 80 }
    condition:
        $a at pe.entry_point

}

rule PESHiELD_v01b_MTE: PEiD
{
    strings:
        $a = { E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B9 1B 01 ?? ?? D1 }
    condition:
        $a at pe.entry_point

}

rule HA_Archive_Hint_FILE_START: PEiD
{
    strings:
        $a = { 48 41 }
    condition:
        $a at pe.entry_point

}

rule GX_Protector_12_GurueXe: PEiD
{
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PeCompact_253_DLL_Slim_Loader_BitSum_Technologies: PEiD
{
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 00 08 0C 00 48 E1 01 56 57 53 55 8B 5C 24 1C 85 DB 0F 84 AB 21 E8 BD 0E E6 60 0D 0B 6B 65 72 6E 6C 33 32 }
    condition:
        $a at pe.entry_point

}

rule EXE_Shield_vxx_Exeshield_Corp: PEiD
{
    strings:
        $a = { 65 78 65 73 68 6C 2E 64 6C 6C C0 5D 00 }
    condition:
        $a at pe.entry_point

}

rule WinZip_32_bit_6x: PEiD
{
    strings:
        $a = { FF 15 FC 81 40 00 B1 22 38 08 74 02 B1 20 40 80 38 00 74 10 }
    condition:
        $a at pe.entry_point

}

rule Compiled_InstallSHIELD_Installation_Script: PEiD
{
    strings:
        $a = { B8 C9 0C 00 }
    condition:
        $a at pe.entry_point

}

rule MASMTASM_Lenguaje_Compilador: PEiD
{
    strings:
        $a = { 6A 00 E8 ?? ?? 00 00 A3 ?? ?? 40 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule PE_Protector_093_CRYPToCRACk: PEiD
{
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 }
    condition:
        $a at pe.entry_point

}

rule Inset_Systems_PIX_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 03 00 ?? 00 00 00 20 00 }
    condition:
        $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4093_Dll_SafeNet_SignByfly: PEiD
{
    strings:
        $a = { 80 7C 24 08 01 0F 85 19 FF FF FF E9 AF EC FF FF 90 90 90 90 90 55 8B EC 83 EC 18 53 56 57 8B 45 08 8B 00 C1 E8 10 89 45 FC 8B 45 08 8B 00 25 FF FF 00 00 89 45 F8 C7 45 F4 5A 01 00 00 C7 45 EC 35 4E 00 00 8B 45 F4 0F AF 45 F8 25 FF FF 00 00 89 45 F0 83 7D FC 00 74 0F 8B 45 EC 0F AF 45 FC 25 FF FF 00 00 01 45 F0 8B 45 EC 0F AF 45 F8 8B 4D F0 C1 E1 10 81 E1 00 00 FF FF 03 C1 40 89 45 E8 8B 45 E8 8B 4D 08 89 01 C1 6D E8 10 81 65 E8 FF 7F 00 00 66 8B 45 E8 EB 00 5F 5E 5B C9 C3 }
        $b = { 80 7C 24 08 01 0F 85 19 FF FF FF E9 AF EC FF FF 90 90 90 90 90 55 8B EC 83 EC 18 53 56 57 8B 45 08 8B 00 C1 E8 10 89 45 FC 8B 45 08 8B 00 25 FF FF 00 00 89 45 F8 C7 45 F4 5A 01 00 00 C7 45 EC 35 4E 00 00 8B 45 F4 0F AF 45 F8 25 FF FF 00 00 89 45 F0 83 7D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule XWD_graphics_format_additional: PEiD
{
    strings:
        $a = { 00 00 00 71 00 00 00 07 00 00 00 02 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_Packed: PEiD
{
    strings:
        $a = { BD ?? ?? 89 ?? ?? ?? 81 ?? ?? ?? ?? ?? 8C ?? ?? ?? 8C C8 05 ?? ?? 8E C0 BE ?? ?? 8B FE 0E 57 54 59 F3 A4 06 68 ?? ?? CB }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_CrunchPE_Heuristic: PEiD
{
    strings:
        $a = { 55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule EXE2COM_Encrypted_without_selfcheck_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B3 ?? B9 ?? ?? BE ?? ?? BF ?? ?? EB ?? 54 69 ?? ?? ?? ?? 03 ?? ?? 32 C3 AA 43 49 E3 ?? EB ?? BE ?? ?? 8B C6 }
    condition:
        $a at pe.entry_point

}

rule NOTA_Version_11_c_Novitex_1990_Hint_DOS_EP: PEiD
{
    strings:
        $a = { EB ?? 06 1E 33 C0 8E D8 BE ?? ?? 0E 07 BF ?? ?? B9 ?? ?? FC F3 A4 1F 8C D3 BE ?? ?? 8B D4 8E D6 BC ?? ?? 8B F4 }
    condition:
        $a at pe.entry_point

}

rule nSpack_V30_LiuXingPing: PEiD
{
    strings:
        $a = { 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? 2E C6 06 ?? ?? ?? E9 ?? ?? E8 ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_V500_V5X_Dll_Silicon_Realms_Toolworks: PEiD
{
    strings:
        $a = { 83 7C 24 08 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ?? ?? ?? ?? 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 57 57 57 57 57 }
    condition:
        $a at pe.entry_point

}

rule Vx_Number_One: PEiD
{
    strings:
        $a = { F9 07 3C 53 6D 69 6C 65 3E E8 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v10b_Ashkbiz_Danehkar_h: PEiD
{
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 }
    condition:
        $a at pe.entry_point

}

rule ASPack_v10801_additional: PEiD
{
    strings:
        $a = { 60 EB 0A 5D EB 02 FF 25 45 FF E5 E8 E9 E8 F1 FF FF FF E9 81 ED 23 6A 44 00 BB 10 ?? 44 00 03 DD 2B 9D 72 }
    condition:
        $a at pe.entry_point

}

rule Turbo_Cpp_30_1990: PEiD
{
    strings:
        $a = { 8C CA 2E 89 16 ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B ?? ?? ?? 8E DA A3 ?? ?? 8C 06 }
    condition:
        $a at pe.entry_point

}

rule Pelles_C_300_400_450_EXE_X86_CRT_DLL_additional: PEiD
{
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 BE ?? ?? ?? ?? EB }
    condition:
        $a at pe.entry_point

}

rule UPX_Shit_v01_500mhz: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5E 83 C6 14 AD 89 C7 AD 89 C1 AD 30 07 47 E2 FB AD FF E0 C3 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 01 ?? ?? ?? 00 55 50 58 2D 53 68 69 74 20 76 30 2E 31 20 2D 20 77 77 77 2E 62 6C 61 63 6B 6C 6F 67 69 63 2E 6E 65 74 20 2D 20 63 6F 64 65 20 62 79 }
        $b = { E8 00 00 00 00 5E 83 C6 14 AD 89 C7 AD 89 C1 AD 30 07 47 E2 FB AD FF E0 C3 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 01 ?? ?? ?? 00 55 50 58 2D 53 68 69 74 20 76 30 2E 31 20 2D 20 77 77 77 2E 62 6C 61 63 6B 6C 6F 67 69 63 2E 6E 65 74 20 2D 20 63 6F 64 65 20 62 79 20 5B 35 30 30 6D 68 7A 5D }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule ANDpakk2_006_by_Dmitry_AND_Andreev_additional: PEiD
{
    strings:
        $a = { 60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 }
    condition:
        $a at pe.entry_point

}

rule MicroJoiner_v17_coban2k: PEiD
{
    strings:
        $a = { BF 00 10 40 00 8D 5F 21 6A 0A 58 6A 04 59 60 57 E8 8E 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule NTKrnlPacker_Ashkbiz_Danehkar: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 }
    condition:
        $a at pe.entry_point

}

rule SVK_Protector_V13X_Pavol_Cerven: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule IBM_IOCA_Graphics_format_Hint_FILE_START: PEiD
{
    strings:
        $a = { 00 11 D3 A6 FB }
    condition:
        $a at pe.entry_point

}

rule Sentinel_SuperPro_Dongle_V54200_Rainbow_Technologies: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 50 1E DF 80 E8 ?? ?? ?? ?? 68 B9 10 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 12 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 07 2A A3 00 E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 88 B5 5B FF E8 ?? ?? ?? ?? 68 B9 30 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V2100_p_Oreans_Technologies_20090917: PEiD
{
    strings:
        $a = { 83 EC 04 50 53 E8 ?? ?? 00 00 CC 58 8B D8 40 2D ?? ?? ?? ?? 2D ?? ?? ?? ?? 05 ?? ?? ?? ?? 80 3B CC 75 19 C6 03 00 BB 00 10 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 50 E8 0A 00 00 00 83 C0 00 89 44 24 08 5B 58 C3 55 8B EC 60 8B 75 08 8B 4D 0C C1 E9 02 8B 45 10 8B 5D 14 EB 08 31 06 01 1E 83 C6 04 49 0B C9 75 F4 61 C9 C2 10 00 }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Byte_Patch: PEiD
{
    strings:
        $a = { E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 1D 03 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 14 03 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 05 03 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 F6 02 00 00 6A 00 FF 75 08 E8 C8 02 00 00 A3 B4 33 40 00 C7 05 BC 33 40 00 2C 00 00 00 C7 05 C0 33 40 00 10 00 00 00 C7 05 C4 33 40 00 00 08 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 97 02 00 00 C7 05 C4 33 40 00 00 00 00 00 C7 05 E0 33 40 00 00 30 40 00 C7 05 E4 33 40 00 01 00 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 65 02 00 00 EB 5F EB 54 }
        $b = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Krypton_v02_additional: PEiD
{
    strings:
        $a = { 8B 04 24 9C 60 E8 ?? ?? ?? ?? 5D 81 ED 0A 45 40 ?? 80 BD 67 44 40 ?? ?? 0F 85 48 }
    condition:
        $a at pe.entry_point

}

rule Upack_v010_v012Beta_Sign_by_hot_UNP: PEiD
{
    strings:
        $a = { BE 48 01 ?? ?? ?? ?? ?? 95 A5 33 C0 }
        $b = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Nullsoft_PIMP_Install_System_v13x_Nullsoft: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC ?? ?? 00 00 56 57 6A ?? BE ?? ?? ?? ?? 59 8D BD }
    condition:
        $a at pe.entry_point

}

rule CorelPhotoPaint_Image: PEiD
{
    strings:
        $a = { 43 50 54 37 46 49 4C 45 }
    condition:
        $a at pe.entry_point

}

rule Armadillo_v301_v305_additional: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 33 C9 75 02 EB 15 EB 33 C9 75 18 7A 0C 70 0E EB 0D E8 72 0E 79 F1 FF 15 00 79 09 74 F0 EB 87 DB 7A F0 A0 33 61 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 A0 8B 04 24 EB 03 7A 29 E9 C6 00 90 C3 E8 70 F0 87 D2 71 07 E9 00 40 8B DB 7A 11 EB 08 E9 EB F7 EB C3 E8 7A E9 70 DA 7B D1 71 F3 E9 7B }
    condition:
        $a at pe.entry_point

}

rule _PseudoSigner_01_MinGW_GCC_2x: PEiD
{
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 E9 }
    condition:
        $a at pe.entry_point

}

rule NeoLite_vxx: PEiD
{
    strings:
        $a = { E9 9B ?? ?? ?? }
        $b = { 9E 37 00 00 ?? ?? 48 ?? ?? ?? 6F 4C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 61 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MSLRH_v032a_fake_MSVCpp_70_DLL_Method_3_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule PE_Crypt32_v102: PEiD
{
    strings:
        $a = { E8 00 00 00 00 5B 83 ?? ?? EB ?? 52 4E 44 21 }
    condition:
        $a at pe.entry_point

}

rule Microsoft_FORTRAN_additional: PEiD
{
    strings:
        $a = { FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC 8C DB 8E C3 BB ?? ?? B9 ?? ?? 9A ?? ?? ?? ?? 80 ?? ?? ?? ?? 74 ?? E9 }
    condition:
        $a at pe.entry_point

}

rule Petite_22_c1998_99_Ian_Luck_h: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? F0 ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 68 ?? ?? ?? ?? 53 50 80 04 24 08 50 80 04 24 42 }
        $b = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 68 00 00 ?? ?? 8B 3C 24 8B 30 66 81 C7 80 07 8D 74 06 08 89 38 8B 5E 10 50 56 6A 02 68 80 08 00 00 57 6A ?? 6A 06 56 6A 04 68 80 08 00 00 57 FF D3 83 EE 08 59 F3 A5 59 66 83 C7 68 81 C6 ?? ?? 00 00 F3 A5 FF D3 58 8D 90 B8 01 00 00 8B 0A 0F BA F1 1F 73 16 8B 04 24 FD 8B F0 8B F8 03 72 04 03 7A 08 F3 A5 83 C2 0C FC EB E2 83 C2 10 8B 5A F4 85 DB 74 D8 8B 04 24 8B 7A F8 03 F8 52 8D 34 01 EB 17 58 58 58 5A 74 C4 E9 1C FF FF FF 02 D2 75 07 8A 16 83 EE FF 12 D2 C3 81 FB 00 00 01 00 73 0E 68 60 C0 FF FF 68 60 FC FF FF B6 05 EB 22 81 FB 00 00 04 00 73 0E 68 80 81 FF FF 68 80 F9 FF FF B6 07 EB 0C 68 00 83 FF FF 68 00 FB FF FF B6 08 6A 00 32 D2 4B A4 33 C9 83 FB 00 7E A4 E8 AA FF FF FF 72 17 A4 30 5F FF 4B EB ED 41 E8 9B FF FF FF 13 C9 E8 94 FF FF FF 72 F2 C3 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Private_exe_Protector_V25X_V27X_SetiSoft_Team_20080718: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 04 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule tElock_v098b1_additional: PEiD
{
    strings:
        $a = { E9 25 E4 FF FF }
    condition:
        $a at pe.entry_point

}

rule Upack_v032_Beta_Sign_by_hot_UNP: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 ?? F3 A5 }
        $b = { BE 88 01 ?? ?? AD 50 ?? ?? AD 91 F3 A5 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule NET_DLL_Microsoft_additional: PEiD
{
    strings:
        $a = { 00 00 00 00 00 00 00 00 5F 43 6F 72 44 6C 6C 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C 00 00 ?? 00 00 FF 25 }
    condition:
        $a at pe.entry_point

}

rule eXPressor_V13_CGSoftLabs_additional: PEiD
{
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 E9 B0 06 }
    condition:
        $a at pe.entry_point

}

rule ThemidaWinLicense_V1820_p_Oreans_Technologies_Sign_by_fly: PEiD
{
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 68 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule aPack_098_099_x_EXE: PEiD
{
    strings:
        $a = { 1E 06 8C CB BA 00 00 03 DA FC 33 F6 33 FF 4B 8E DB 8D 87 00 00 8E C0 B9 08 00 F3 A5 4A 75 EB 8E C3 8E D8 33 FF BE 00 00 05 00 00 0E 50 }
    condition:
        $a at pe.entry_point

}

rule Obsidium_V1400Beta_Obsidium_Software_SignByfly_20080102: PEiD
{
    strings:
        $a = { EB 01 ?? E8 2F 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 01 ?? E9 ?? ?? ?? ?? EB 01 ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 }
        $b = { EB 01 ?? E8 2F 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Upack_v032_Beta: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 ?? F3 A5 }
    condition:
        $a at pe.entry_point

}

rule UPX_v070_Laszlo_Markus: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 ?? ?? ?? FF 57 66 81 87 ?? ?? ?? ?? ?? ?? 8D B0 EC 01 ?? ?? 83 CD FF 31 DB EB 07 90 8A 06 46 88 07 47 01 DB 75 07 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_v1033_dllocx_Ashkbiz_Danehkar_h: PEiD
{
    strings:
        $a = { 60 }
        $b = { 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 00 00 00 00 5D 81 ED 07 E2 40 00 8B D5 81 C2 56 E2 40 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 4B 0C 41 00 81 E9 01 E3 40 00 8B D5 81 C2 01 E3 40 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 9C 22 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 CC CC CC CC AC }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_01_32Lite_003: PEiD
{
    strings:
        $a = { 60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 ?? ?? ?? ?? E9 }
    condition:
        $a at pe.entry_point

}

rule VOB_ProtectCD_5: PEiD
{
    strings:
        $a = { 5F 81 EF BE 40 8B 87 03 C6 57 56 8C A7 FF 10 89 87 5E }
        $b = { 36 3E 26 8A C0 60 E8 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule CDS_SS_10_beta1_CyberDoom: PEiD
{
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 00 E8 FC 03 00 00 0B C0 0F 84 CE 02 00 00 E8 1E 03 00 00 89 85 90 4E 40 00 8D 85 03 4D 40 00 50 FF B5 B8 4E 40 00 E8 D7 03 00 00 0B C0 0F 84 A9 02 00 00 E8 F9 02 00 00 89 85 94 4E 40 00 8D 85 12 4D 40 00 50 }
        $b = { 60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule V10_tjszlqq_20090823: PEiD
{
    strings:
        $a = { E9 15 AC 00 00 00 00 E9 ED 3A 01 00 00 00 E9 A1 9A 01 00 00 00 E9 CD 76 02 00 00 00 E9 8D FA 01 00 00 00 E9 CB 04 00 00 00 00 E9 A4 9F 00 00 00 00 66 B8 00 02 66 85 C0 0F 85 F0 5E 04 00 00 00 00 00 00 00 00 00 66 B8 00 00 E9 73 8F 02 00 00 00 00 00 00 E9 1A 57 03 00 00 00 E9 35 4E 04 00 00 00 E9 74 9D 00 00 00 00 E9 44 4D 02 00 00 00 E9 9B F2 03 00 00 00 E9 8B 63 03 00 00 00 E9 06 95 01 00 00 00 E9 77 7D 03 00 00 00 B0 02 E9 74 BB 02 00 00 00 00 00 00 00 00 E9 3C E5 03 00 00 00 E9 F4 83 02 00 00 00 E9 9D 9F 00 00 00 00 E9 72 CB 00 00 00 00 E9 88 C2 00 00 00 00 E9 42 3B 04 00 00 00 E9 F4 4C 00 00 00 00 E9 B8 28 04 00 00 00 E9 0F 4F 00 00 00 00 66 83 E8 00 E9 02 F4 00 00 00 00 00 00 00 84 C0 E9 B9 90 01 00 00 00 00 00 00 00 00 E9 78 C5 02 00 }
    condition:
        $a at pe.entry_point

}

rule UPX_200_30X_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    strings:
        $a = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF ?? ?? ?? ?? ?? 95 8A 07 47 08 C0 74 DC 89 F9 57 48 F2 AE 55 FF ?? ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB E1 FF ?? ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? ?? ?? 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 E9 }
        $b = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule MSLRH_v032a_fake_MSVCpp_60_DLL_emadicius: PEiD
{
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        $a at pe.entry_point

}

rule Turbo_Pascal_v30_1985_additional: PEiD
{
    strings:
        $a = { 90 90 CD AB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 38 35 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v0978_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB C3 11 }
    condition:
        $a at pe.entry_point

}

rule tElock_v085f_additional: PEiD
{
    strings:
        $a = { 60 E8 02 00 00 00 CD 20 E8 00 00 00 00 5E 2B C9 58 74 02 }
    condition:
        $a at pe.entry_point

}

rule Histogram_graphics_file_Hint_FILE_START: PEiD
{
    strings:
        $a = { 6D 68 77 61 6E 68 00 04 01 02 01 02 }
    condition:
        $a at pe.entry_point

}

rule _MSLRH_v01_emadicius: PEiD
{
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 }
    condition:
        $a at pe.entry_point

}

rule XCR_v012: PEiD
{
    strings:
        $a = { 60 9C E8 ?? ?? ?? ?? 8B DD 5D 81 ED ?? ?? ?? ?? 89 9D }
    condition:
        $a at pe.entry_point

}

rule VProtector_V10D_vcasm_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 CA 31 41 00 68 06 32 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 }
    condition:
        $a at pe.entry_point

}

rule Vx_Backfont900_Hint_DOS_EP: PEiD
{
    strings:
        $a = { E8 ?? ?? B4 30 CD 21 3C 03 ?? ?? B8 ?? ?? BA ?? ?? CD 21 81 FA ?? ?? ?? ?? BA ?? ?? 8C C0 48 8E C0 8E D8 80 ?? ?? ?? 5A ?? ?? 03 ?? ?? ?? 40 8E D8 80 ?? ?? ?? 5A ?? ?? 83 }
    condition:
        $a at pe.entry_point

}

rule Upack_v032_Beta_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 ?? F3 A5 }
    condition:
        $a at pe.entry_point

}

rule Com_Cryptor_BTS_912: PEiD
{
    strings:
        $a = { B7 00 E8 05 00 83 ED 02 EB 03 5D 55 C3 BF 1A 00 03 FD 8B F7 B9 71 02 AC 02 C7 AA E2 FA }
    condition:
        $a at pe.entry_point

}

rule MSLRH_v032a_fake_BJFNT_13_emadicius_h: PEiD
{
    strings:
        $a = { EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 61 9D 1F EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        $a at pe.entry_point

}

rule yodas_Protector_V1032_Ashkbiz_Danehkar_Sign_by_fly_additional: PEiD
{
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 BF A4 42 00 81 E9 8E 74 42 00 8B D5 81 C2 8E 74 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 63 29 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
    condition:
        $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Byte_Patch_additional: PEiD
{
    strings:
        $a = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_MEW_11_SE_10: PEiD
{
    strings:
        $a = { E9 09 00 00 00 00 00 00 02 00 00 00 0C 90 }
    condition:
        $a at pe.entry_point

}

rule Alias_PIXVivid_IMG_Graphics_format: PEiD
{
    strings:
        $a = { ?? ?? ?? ?? 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01 }
        $b = { 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule Microsoft_C_v104_Hint_DOS_EP: PEiD
{
    strings:
        $a = { FA B8 ?? ?? 8E D8 8E D0 26 8B ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 04 D3 E3 EB }
    condition:
        $a at pe.entry_point

}

rule Themida_v2018_c2007_Oreans_Technologies: PEiD
{
    strings:
        $a = { 83 EC 04 50 53 E8 00 00 00 00 58 8B D8 2D 00 ?? ?? 00 2D ?? ?? ?? 00 05 ?? ?? ?? 00 }
    condition:
        $a at pe.entry_point

}

rule PseudoSigner_02_CrunchPE_Heuristic_Anorganix: PEiD
{
    strings:
        $a = { 55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule PROTECT_EXECOM_v50_additional: PEiD
{
    strings:
        $a = { 1E 0E 0E 1F 07 }
    condition:
        $a at pe.entry_point

}

rule VProtector_V10A_vcasm_additional: PEiD
{
    strings:
        $a = { 55 8B EC 6A FF 68 8A 8E 40 00 68 C6 8E 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 }
    condition:
        $a at pe.entry_point

}

rule PECompact_v099_additional: PEiD
{
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 28 63 40 ?? 87 DD 8B 85 AD 63 }
    condition:
        $a at pe.entry_point

}

rule Mew_10_v10_Eng_Northfox: PEiD
{
    strings:
        $a = { 33 C0 E9 ?? ?? ?? FF }
    condition:
        $a at pe.entry_point

}

rule Obsidium_1334_Obsidium_Software_additional: PEiD
{
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 02 ?? ?? 33 C0 EB 01 ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 03 ?? ?? ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 03 }
    condition:
        $a at pe.entry_point

}

rule CopyMinder_MicrocosmLtd: PEiD
{
    strings:
        $a = { 83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 }
        $b = { 83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 }
    condition:
        for any of ($*) : ( $ at pe.entry_point )

}

rule _PseudoSigner_02_PESHiELD_025: PEiD
{
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC }
    condition:
        $a at pe.entry_point

}

rule EXEStealth_276_Unregistered_WebtoolMaster_additional: PEiD
{
    strings:
        $a = { EB ?? 45 78 65 53 74 65 61 6C 74 68 20 56 32 20 53 68 61 72 65 77 61 72 65 20 }
    condition:
        $a at pe.entry_point

}

rule Upack_v039_final_Sign_by_hot_UNP_additional: PEiD
{
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 39 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        $a at pe.entry_point

}

rule ASProtect_SKE_21x_dll_Alexey_Solodovnikov_h_additional: PEiD
{
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
    condition:
        $a at pe.entry_point

}

rule MEGALITE_v120a_Hint_DOS_EP: PEiD
{
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 2D 73 ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 90 }
    condition:
        $a at pe.entry_point

}

rule eXPressorLight_V1601_CGSoftLabs_20080308: PEiD
{
    strings:
        $a = { 55 8B EC 81 EC 68 02 00 00 53 56 57 83 A5 D0 FD FF FF 00 F3 EB 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 78 60 00 75 14 6A 10 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? E8 9C FF FF FF A3 ?? ?? ?? ?? 68 04 01 00 00 8D 85 F0 FD FF FF 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 84 05 EF FD FF FF 89 85 DC FD FF FF 8B 85 DC FD FF FF 0F BE 00 83 F8 5C 74 0F 8B 85 DC F