# Generated by Django 5.1.13 on 2025-11-06 16:20

import django.db.models.deletion

from django.db import migrations, models
from uuid6 import uuid7

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0069_resource_resource_group"),
    ]

    operations = [
        migrations.CreateModel(
            name="AttackPathsScan",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid7,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "state",
                    api.db_utils.StateEnumField(
                        choices=[
                            ("available", "Available"),
                            ("scheduled", "Scheduled"),
                            ("executing", "Executing"),
                            ("completed", "Completed"),
                            ("failed", "Failed"),
                            ("cancelled", "Cancelled"),
                        ],
                        default="available",
                    ),
                ),
                ("progress", models.IntegerField(default=0)),
                ("started_at", models.DateTimeField(blank=True, null=True)),
                ("completed_at", models.DateTimeField(blank=True, null=True)),
                (
                    "duration",
                    models.IntegerField(
                        blank=True, help_text="Duration in seconds", null=True
                    ),
                ),
                (
                    "update_tag",
                    models.BigIntegerField(
                        blank=True,
                        help_text="Cartography update tag (epoch)",
                        null=True,
                    ),
                ),
                (
                    "graph_database",
                    models.CharField(blank=True, max_length=63, null=True),
                ),
                (
                    "is_graph_database_deleted",
                    models.BooleanField(default=False),
                ),
                (
                    "ingestion_exceptions",
                    models.JSONField(blank=True, default=dict, null=True),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attack_paths_scans",
                        related_query_name="attack_paths_scan",
                        to="api.provider",
                    ),
                ),
                (
                    "scan",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="attack_paths_scans",
                        related_query_name="attack_paths_scan",
                        to="api.scan",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="attack_paths_scans",
                        related_query_name="attack_paths_scan",
                        to="api.task",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "attack_paths_scans",
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["tenant_id", "provider_id", "-inserted_at"],
                        name="aps_prov_ins_desc_idx",
                    ),
                    models.Index(
                        fields=["tenant_id", "state", "-inserted_at"],
                        name="aps_state_ins_desc_idx",
                    ),
                    models.Index(
                        fields=["tenant_id", "scan_id"],
                        name="aps_scan_lookup_idx",
                    ),
                    models.Index(
                        fields=["tenant_id", "provider_id"],
                        name="aps_active_graph_idx",
                        include=["graph_database", "id"],
                        condition=models.Q(("is_graph_database_deleted", False)),
                    ),
                    models.Index(
                        fields=["tenant_id", "provider_id", "-completed_at"],
                        name="aps_completed_graph_idx",
                        include=["graph_database", "id"],
                        condition=models.Q(
                            ("state", "completed"),
                            ("is_graph_database_deleted", False),
                        ),
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="attackpathsscan",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_attackpathsscan",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
