/**
 * Custom error thrown when the haveibeenpwned.com API responds with 429 Too
 * Many Requests. See the `retryAfterSeconds` property for the number of seconds
 * to wait before attempting the request again.
 *
 * @see https://haveibeenpwned.com/API/v3#RateLimiting
 */
export declare class RateLimitError extends Error {
    /**
     * The number of seconds to wait before attempting the request again. May be
     * `undefined` if the API does not provide a `retry-after` header, but this
     * should never happen.
     */
    retryAfterSeconds: number | undefined;
    constructor(retryAfter: ReturnType<Headers['get']>, message: string | undefined, options?: ErrorOptions);
}
