from ..core import ChepyCore
from typing import Any, TypeVar, Literal

CompressionT = TypeVar('CompressionT', bound='Compression')

class Compression(ChepyCore):
    def __init__(self, *data: Any) -> None: ...
    state: Any = ...
    def fix_zip_header(self: CompressionT) -> CompressionT: ...
    def zip_info(self: CompressionT) -> CompressionT: ...
    def zip_list_files(self: CompressionT) -> CompressionT: ...
    def unzip_one(self: CompressionT, file: str, password: str=...) -> CompressionT: ...
    def unzip_all(self: CompressionT, password: str=...) -> CompressionT: ...
    def create_zip_file(self: CompressionT, file_name: str) -> CompressionT: ...
    def zip_compress(self: CompressionT, file_name: str) -> CompressionT: ...
    def zip_compress_symlink(self: CompressionT, file_name: str, target_file: str) -> CompressionT: ...
    def tar_list_files(self: CompressionT, mode: Literal["gz", "bz2", "xz", ""]=...) -> CompressionT: ...
    def tar_extract_one(self: CompressionT, filename: str, mode: Literal["gz", "bz2", "xz", ""]=...) -> CompressionT: ...
    def tar_extract_all(self: CompressionT, mode: Literal["gz", "bz2", "xz", ""]=...) -> CompressionT: ...
    def tar_compress(self: CompressionT, filename: str, mode: Literal["gz", "bz2", "xz", ""]=...) -> CompressionT: ...
    def gzip_compress(self: CompressionT, file_name: str=...) -> CompressionT: ...
    def gzip_decompress(self: CompressionT) -> CompressionT: ...
    def bzip_compress(self: CompressionT) -> CompressionT: ...
    def bzip_decompress(self: CompressionT) -> CompressionT: ...
    def zlib_compress(self: CompressionT, level: int=...) -> CompressionT: ...
    def zlib_decompress(self: CompressionT) -> CompressionT: ...
    def lzma_compress(self: CompressionT) -> CompressionT: ...
    def lzma_decompress(self: CompressionT) -> CompressionT: ...
    def raw_inflate(self: CompressionT) -> CompressionT: ...
    def raw_deflate(self: CompressionT) -> CompressionT: ...
    def lz4_compress(self: CompressionT) -> CompressionT: ...
    def lz4_decompress(self: CompressionT) -> CompressionT: ...
    def lz77_compress(self: CompressionT, window_size: int = 13, lookahead_buffer_size: int = 6) -> CompressionT: ...
    def lz77_decompress(self: CompressionT, window_size: int = 13, lookahead_buffer_size: int = 6) -> CompressionT: ...
