# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from __future__ import annotations

from typing import MutableMapping, MutableSequence

import proto  # type: ignore

from google.cloud.monitoring_v3.types import common

__protobuf__ = proto.module(
    package="google.monitoring.v3",
    manifest={
        "Snooze",
    },
)


class Snooze(proto.Message):
    r"""A ``Snooze`` will prevent any alerts from being opened, and close
    any that are already open. The ``Snooze`` will work on alerts that
    match the criteria defined in the ``Snooze``. The ``Snooze`` will be
    active from ``interval.start_time`` through ``interval.end_time``.

    Attributes:
        name (str):
            Required. The name of the ``Snooze``. The format is:

            ::

                projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]

            The ID of the ``Snooze`` will be generated by the system.
        criteria (google.cloud.monitoring_v3.types.Snooze.Criteria):
            Required. This defines the criteria for applying the
            ``Snooze``. See ``Criteria`` for more information.
        interval (google.cloud.monitoring_v3.types.TimeInterval):
            Required. The ``Snooze`` will be active from
            ``interval.start_time`` through ``interval.end_time``.
            ``interval.start_time`` cannot be in the past. There is a 15
            second clock skew to account for the time it takes for a
            request to reach the API from the UI.
        display_name (str):
            Required. A display name for the ``Snooze``. This can be, at
            most, 512 unicode characters.
    """

    class Criteria(proto.Message):
        r"""Criteria specific to the ``AlertPolicy``\ s that this ``Snooze``
        applies to. The ``Snooze`` will suppress alerts that come from one
        of the ``AlertPolicy``\ s whose names are supplied.

        Attributes:
            policies (MutableSequence[str]):
                The specific ``AlertPolicy`` names for the alert that should
                be snoozed. The format is:

                ::

                    projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]

                There is a limit of 16 policies per snooze. This limit is
                checked during snooze creation.
        """

        policies: MutableSequence[str] = proto.RepeatedField(
            proto.STRING,
            number=1,
        )

    name: str = proto.Field(
        proto.STRING,
        number=1,
    )
    criteria: Criteria = proto.Field(
        proto.MESSAGE,
        number=3,
        message=Criteria,
    )
    interval: common.TimeInterval = proto.Field(
        proto.MESSAGE,
        number=4,
        message=common.TimeInterval,
    )
    display_name: str = proto.Field(
        proto.STRING,
        number=5,
    )


__all__ = tuple(sorted(__protobuf__.manifest))
