info = {
    "name": "sr",
    "date_order": "DMY",
    "january": [
        "јан",
        "јануар"
    ],
    "february": [
        "феб",
        "фебруар"
    ],
    "march": [
        "мар",
        "март"
    ],
    "april": [
        "апр",
        "април"
    ],
    "may": [
        "мај"
    ],
    "june": [
        "јун"
    ],
    "july": [
        "јул"
    ],
    "august": [
        "авг",
        "август"
    ],
    "september": [
        "сеп",
        "септембар"
    ],
    "october": [
        "окт",
        "октобар"
    ],
    "november": [
        "нов",
        "новембар"
    ],
    "december": [
        "дец",
        "децембар"
    ],
    "monday": [
        "пон",
        "понедељак"
    ],
    "tuesday": [
        "уто",
        "уторак"
    ],
    "wednesday": [
        "сре",
        "среда"
    ],
    "thursday": [
        "чет",
        "четвртак"
    ],
    "friday": [
        "пет",
        "петак"
    ],
    "saturday": [
        "суб",
        "субота"
    ],
    "sunday": [
        "нед",
        "недеља"
    ],
    "am": [
        "пре подне"
    ],
    "pm": [
        "по подне"
    ],
    "year": [
        "г",
        "год",
        "година"
    ],
    "month": [
        "м",
        "мес",
        "месец"
    ],
    "week": [
        "н",
        "нед",
        "недеља"
    ],
    "day": [
        "д",
        "дан"
    ],
    "hour": [
        "сат",
        "ч"
    ],
    "minute": [
        "мин",
        "минут"
    ],
    "second": [
        "с",
        "сек",
        "секунд"
    ],
    "relative-type": {
        "0 day ago": [
            "данас"
        ],
        "0 hour ago": [
            "овог сата"
        ],
        "0 minute ago": [
            "овог минута"
        ],
        "0 month ago": [
            "овог месеца"
        ],
        "0 second ago": [
            "сада"
        ],
        "0 week ago": [
            "ове недеље"
        ],
        "0 year ago": [
            "ове године"
        ],
        "1 day ago": [
            "јуче"
        ],
        "1 month ago": [
            "прошлог месеца"
        ],
        "1 week ago": [
            "прошле недеље"
        ],
        "1 year ago": [
            "прошле године"
        ],
        "in 1 day": [
            "сутра"
        ],
        "in 1 month": [
            "следећег месеца"
        ],
        "in 1 week": [
            "следеће недеље"
        ],
        "in 1 year": [
            "следеће године"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "пре (\\d+) д",
            "пре (\\d+) дана"
        ],
        "\\1 hour ago": [
            "пре (\\d+) сата",
            "пре (\\d+) сати",
            "пре (\\d+) ч"
        ],
        "\\1 minute ago": [
            "пре (\\d+) мин",
            "пре (\\d+) минута"
        ],
        "\\1 month ago": [
            "пре (\\d+) м",
            "пре (\\d+) мес",
            "пре (\\d+) месеца",
            "пре (\\d+) месеци"
        ],
        "\\1 second ago": [
            "пре (\\d+) с",
            "пре (\\d+) сек",
            "пре (\\d+) секунде",
            "пре (\\d+) секунди"
        ],
        "\\1 week ago": [
            "пре (\\d+) н",
            "пре (\\d+) нед",
            "пре (\\d+) недеља",
            "пре (\\d+) недеље"
        ],
        "\\1 year ago": [
            "пре (\\d+) г",
            "пре (\\d+) год",
            "пре (\\d+) година",
            "пре (\\d+) године"
        ],
        "in \\1 day": [
            "за (\\d+) д",
            "за (\\d+) дан",
            "за (\\d+) дана"
        ],
        "in \\1 hour": [
            "за (\\d+) сат",
            "за (\\d+) сати",
            "за (\\d+) ч"
        ],
        "in \\1 minute": [
            "за (\\d+) мин",
            "за (\\d+) минут",
            "за (\\d+) минута"
        ],
        "in \\1 month": [
            "за (\\d+) м",
            "за (\\d+) мес",
            "за (\\d+) месец",
            "за (\\d+) месеци"
        ],
        "in \\1 second": [
            "за (\\d+) с",
            "за (\\d+) сек",
            "за (\\d+) секунди",
            "за (\\d+) секунду"
        ],
        "in \\1 week": [
            "за (\\d+) н",
            "за (\\d+) нед",
            "за (\\d+) недеља",
            "за (\\d+) недељу"
        ],
        "in \\1 year": [
            "за (\\d+) г",
            "за (\\d+) год",
            "за (\\d+) година",
            "за (\\d+) годину"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
