#!/usr/bin/pyhton
#=======================================================================   
#                         GENERAL INFORMATION
#=======================================================================
""" Module that allows to write 1D profiles in OpenFoam format for boundary conditions imposition
"""
#
#---------------- Module General Import and Declarations ---------------
#
import numpy as np
import fluidfoam
#
# --------------------Module functions description----------------------
#
def create1Dprof(pathr,pathw,timeName,varList,Nx,Ny,Nz):
    """ Read 1D profiles at time timeName of pathr and write them in 
	openfoam format in the 1d_profil folder of pathw.
    """
#
#        --------------------Reading part---------------------
#
    X,Y,Z=fluidfoam.readmesh(pathr+'0/',shape=(Nx,Ny,Nz))
    Yp=Y[0,:,0]
    dct = {'y': Yp}
    if 'alpha' in varList:
    	alpha=fluidfoam.readscalar(pathr,timeName,'alpha',shape=(Nx,Ny,Nz))
        alphap=alpha[0,:,0]
        dct['alpha'] = alphap
    if 'k' in varList:
	k=fluidfoam.readscalar(pathr,timeName,'k',shape=(Nx,Ny,Nz))
    	kp=k[0,:,0]
        dct['k'] = kp
    if 'omega' in varList:
    	omega=fluidfoam.readscalar(pathr,timeName,'omega',shape=(Nx,Ny,Nz))
    	omegap=omega[0,:,0]
        dct['omega'] = omegap
    if 'epsilon' in varList:
    	epsilon=fluidfoam.readscalar(pathr,timeName,'epsilon',shape=(Nx,Ny,Nz))
    	epsilonp=epsilon[0,:,0]
        dct['epsilon'] = epsilonp
    if 'nut' in varList:
    	nut=fluidfoam.readscalar(pathr,timeName,'nut',shape=(Nx,Ny,Nz))
    	nutp=nut[0,:,0]
        dct['nut'] = nutp
    if 'p' in varList:
    	p=fluidfoam.readscalar(pathr,timeName,'p',shape=(Nx,Ny,Nz))
    	pp=p[0,:,0]
        dct['p'] = pp
    if 'pa' in varList:
    	pa=fluidfoam.readscalar(pathr,timeName,'pa',shape=(Nx,Ny,Nz))
    	pap=pb[0,:,0]
        dct['pa'] = pap
    if 'Ub' in varList:
    	Ub=fluidfoam.readvector(pathr,timeName,'Ub',shape=(Nx,Ny,Nz))
    	Ubp=Ub[0,:,0]
        dct['Ub'] = Ubp[0, :]
        dct['Vb'] = Ubp[2, :]
        dct['Wb'] = Ubp[1, :]
    if 'Ua' in varList:
    	Ua=fluidfoam.readvector(pathr,timeName,'Ua',shape=(Nx,Ny,Nz))
    	Uap=Ua[0,:,0]
        dct['Ua'] = Uap[0, :]
        dct['Va'] = Uap[2, :]
        dct['Wa'] = Uap[1, :]
#
#         --------------Write the profiles into files-----------
#
    fileName=''
    for i in varList:
    	fileName=''+i
    	filename=pathw+'1d_profil/'+fileName+'.xy'
    	f=open(filename, "w")
    	f.write('(\n')
    	np.savetxt(f, np.c_[Yp,dct[fileName]], fmt='(%s %s)')
    	f.write(')\n')
    	f.close()

    status='create 1D profiles: done'
    return status

