#!/usr/bin/pyhton
# =======================================================================
#                         GENERAL INFORMATION
# =======================================================================
""" Module that allows to read openFoam probe files
"""
#
# ---------------- Module General Import and Declarations ---------------
#
import os
import numpy as np
import re

def readProbeScalar(N,Np,rep,timeName,varName,readPos=1):
        """read OF probe scalar varName contained in repository rep
        at time timeName"""

        timerep = rep + 'postProcessing/probes/'+ timeName + varName
        print "Reading "+varName+" from: "+timerep
        
        myfile = open(timerep, "r") 
        yyy=myfile.readlines()
        if (readPos==1):
        	xxx=[re.sub('[\#\Probe\n\(\)]', '', y) for y in yyy[0:N*Np-1][:]]
        	posList=np.array([[float(y) for y in x.split()] for x in xxx])
        	probe_pos=np.zeros((N,3,Np))
        	for i in range(Np):
        		probe_pos[0:N-1,0,i]=posList[i*N:(i+1)*N-1,1]
        		probe_pos[0:N-1,1,i]=posList[i*N:(i+1)*N-1,2]
        		probe_pos[0:N-1,2,i]=posList[i*N:(i+1)*N-1,3]
			del xxx,posList
                        
        zzz=[re.sub('[\(\)]', '', y) for y in yyy[N*Np+2:][:]]
        varList=np.array([[float(x) for x in z.split()] for z in zzz])
        #	varList=np.genfromtxt(timerep,skip_header=N*Np+2)
        del yyy,zzz

## Initialization of Scalar matrix (time and space) from the probe
	varList = np.array(varList)
	Ntime = np.shape(varList)[0]
	
	timevec = np.zeros(Ntime)
	timevec[:] = varList[:,0]

	var = np.zeros((Ntime,N,Np))
		
	for i in range(Ntime):
		for j in range(Np):
			var[i,:,j] = varList[i,j*N+1:(j+1)*N+1]
	
        if (readPos==1):
        	return timevec, probe_pos, var
        elif (readPos==0):
        	return timevec, var

def readProbeArray(N,Np,rep, timeName, varName):
        """ read OF probe array varName contained in repository rep
        at time timeName"""

        timerep = rep + 'postProcessing/probes/'+timeName+varName
        print "Reading "+varName+" from: "+timerep
        
        myfile = open(timerep, "r") 
        yyy=myfile.readlines()

        xxx=[re.sub('[\#\Probe\n\(\)]', '', y) for y in yyy[0:N*Np][:]]
        posList=np.array([[float(y) for y in x.split()] for x in xxx])
        
        probe_pos=np.zeros((N,3,Np))
        for i in range(Np):
               print i, np.shape(posList[i*N:(i+1)*N,2]),N
               probe_pos[0:N,0,i]=posList[i*N:(i+1)*N,1]
               probe_pos[0:N,1,i]=posList[i*N:(i+1)*N,2]
               probe_pos[0:N,2,i]=posList[i*N:(i+1)*N,3]
                        
        zzz=[re.sub('[\(\)]', '', y) for y in yyy[N*Np+2:][:]]
        varList=np.array([[float(x) for x in z.split()] for z in zzz])
        del xxx
        del yyy
        del zzz

	Ntime = np.shape(varList)[0]

        timevec = np.zeros(Ntime)
	var = np.zeros((Ntime,N,3,Np))
	#~ print varList[0][0:3*N]
	for i in range(Ntime):
                timevec[i]=varList[i][0]
                
                for j in range(Np):
                      var[i,:,0,j] = varList[i][j*3*N+1:(j+1)*3*N+1:3]
                      var[i,:,1,j] = varList[i][j*3*N+2:(j+1)*3*N+2:3]
                      var[i,:,2,j] = varList[i][j*3*N+3:(j+1)*3*N+3:3]

	return timevec,probe_pos,var
