#!/usr/bin/pyhton
#=======================================================================   
#                         GENERAL INFORMATION
#=======================================================================
""" Module that allows to read sample files from openFoam
"""
#
#---------------- Module General Import and Declarations ---------------
#
import os 
import sys
import numpy as np
#
#
# Module functions description
#
#
def readSampleUaUbt(path,sampleName):
    """ Read sample files for the two velocity vectors Ua and Ub at all time 
        present in postProcessing/sets/
    """

    solpath=path+'postProcessing/sets/'
    
    list=os.listdir(solpath)

    # Number of outputs
    Nt=len(list)
    print 'Nt=',Nt

    # initialize output vectors
    t=np.zeros(Nt)

    yut = []
    uat = []
    vat = []
    wat = []
    ubt = []
    vbt = []
    wbt = []
    #
    # Reading SedFoam results
    #
    k=-1
    for i in list:
        k=k+1

        ufile=solpath+i+'/'+sampleName+'_Ua_Ub.xy'
        print 'Reading t=',i,' s / file: ',ufile 
        xu,yu,zu,ua,va,wa,ub,vb,wb=np.loadtxt(ufile,unpack=True)

        t[k]=float(i)
        yut.append(yu)
        uat.append(ua)
        vat.append(va)
        wat.append(wa)
        ubt.append(ub)
        vbt.append(vb)
        wbt.append(wb)

    xut=np.array(xut)
    yut=np.array(yut)
    zut=np.array(zut)

    uat=np.array(uat)
    vat=np.array(vat)
    wat=np.array(wat)
    ubt=np.array(ubt)
    vbt=np.array(vbt)
    wbt=np.array(wbt)

    N=np.size(yut,1)
    return Nt,N,t,xut,yut,zut,uat,vat,wat,ubt,vbt,wbt
#
#
#
def readSampleUaUb(path,sampleName):
    """ Read sample files for the two velocity vectors Ua and Ub
    """

    solpath=path+'postProcessing/sets/'
    list=os.listdir(solpath)

    # Number of outputs
    Nt=len(list)
    print 'Nt=',Nt

    #
    # Reading SedFoam results
    #
    i=list[Nt-1]

    ufile=solpath+i+'/'+sampleName+'_Ua_Ub.xy'
    print 'Reading t=',i,' s / file: ',ufile
    xu,yu,zu,ua,va,wa,ub,vb,wb=np.loadtxt(ufile,unpack=True)

    xu=np.array(xu)	
    yu=np.array(yu)
    zu=np.array(zu)

    ua=np.array(ua)
    va=np.array(va)
    wa=np.array(wa)
    ub=np.array(ub)
    vb=np.array(vb)
    wb=np.array(wb)

    N=np.size(yu)
    return Nt,N,xu,yu,zu,ua,va,wa,ub,vb,wb
#
#
#
def readSampleVarList(path,sampleName,varList):
    """ Read sample files for the two velocity vectors Ua and Ub
    """

    solpath=path+'postProcessing/sets/'
    list=os.listdir(solpath)

    # Number of outputs
    Nt=len(list)
    print 'Nt=',Nt

    #
    # Reading SedFoam results
    #
    i=list[Nt-1]

    varName=''
    for k in varList:
    	varName+='_'+k
    
    file=solpath+i+'/'+sampleName+varName+'.xy'
    print 'Reading t=',i,' s / file: ',file
    data=np.loadtxt(file)
    
    data=np.array(data)
# extracting coordinates
    x=data[:,0]
    y=data[:,1]    
    z=data[:,2]
# extracting data
    dataout=data[:,3:]

    N=np.size(x)

    return Nt,N,x,y,z,dataout
