#!/usr/bin/pyhton
# =======================================================================
#                         GENERAL INFORMATION
# =======================================================================
""" Module that allows to plot time series from openFoam files
"""
#
# ---------------- Module General Import and Declarations ---------------
#
import os
import numpy as np

import fluidfoam
from pylab import *
import matplotlib.gridspec as gridspec


def timeseriesScalar(rep, timeRange, Scalar, x=1e30, y=1e30, z=1e30):
        """ read OF Scalar and generate a time serie"""

        # import modules
        import time
        #
        # Change fontsize
        #
        matplotlib.rcParams.update({'font.size': 16})

        #
        # linewidth
        #
        lw = 3
        rc('lines', linewidth=lw)
        #
        # read mesh
        #
        X, Y, Z = fluidfoam.readmesh(rep+'0/')

        if (x == 1e30):
                x = 0.5*(np.min(X)+np.max(X))

        if (y == 1e30):
                y = 0.5*(np.min(Y)+np.max(Y))

        if (z == 1e30):
                z = 0.5*(np.min(Z)+np.max(Z))
                
        i = ((X-x)**2+(Y-y)**2+(Z-z)**2).argmin()

        timeN = []
        val = []
        
        # create a
        for t in timeRange:
            print 'Reading time: ', t, ' s'

            tab = fluidfoam.readscalar(rep, t+'/', Scalar)
            print tab
            val.append(tab[i])
            timeN.append(t)

        val = np.array(val)
        timeN = np.array(timeN)
        #
        # Plotting
        #
        write = 'no'
        if (write != 'no'):
            baseRep = rep+"Animation/"
            cmd = "mkdir "+baseRep
            os.system(cmd)
            baseName = baseRep+'anim'

        #
        #
        # Figure size
        #
        figwidth = 16
        figheight = 8

        # Open the figure
        fig = figure( figsize=(figwidth, figheight), dpi=60,
                     facecolor='w', edgecolor='w')
        gs = gridspec.GridSpec(2, 1)
        gs.update(left=0.1, right=0.95, top=0.95, bottom=0.1, wspace=0.25,
                  hspace=0.15)
        #
        # ax0
        #
        ax0 = subplot(gs[0, 0])
        l0 = ax0.plot(X, Y, '.k', markersize=3)
        l1 = ax0.plot(X[i], Y[i], 'or', markersize=12)

        xlabel("X (m)")
        ylabel("Y (m)")

        axis([np.min(X), np.max(X), np.min(Y), np.max(Y)])
        title('time serie')

        ax1 = subplot(gs[1, 0])
        l1 = ax1.plot(timeN, val)

        xlabel('t (s)')
        ylabel(Scalar)

        if ((write == 'png') | (write == 'eps')):
                fileName = baseName+t.replace('.', '_')+'.'+write
                print 'writing:', fileName
                show(block=False)
                savefig(fileName)

        show()

        return 0


def timeseriesVector(rep, timeRange, Vector, x=1e30, y=1e30, z=1e30):
        """ read OF Vector and generate a time serie"""

        # import modules
        import time
        #
        # Change fontsize
        #
        matplotlib.rcParams.update({'font.size': 16})

        #
        # linewidth
        #
        lw = 3
        rc('lines', linewidth=lw)
        #
        # read mesh
        #
        X, Y, Z = fluidfoam.readmesh(rep+'0/')

        if (x == 1e30):
                x = 0.5*(np.min(X)+np.max(X))

        if (y == 1e30):
                y = 0.5*(np.min(Y)+np.max(Y))
                
        if (z == 1e30):
                z = 0.5*(np.min(Z)+np.max(Z))
                
        i = ((X-x)**2+(Y-y)**2+(Z-z)**2).argmin()
        
        timeN = []
        vecX = []
        vecY = []
        vecZ = []
        #  create a
        for t in timeRange:
            print 'Reading time: ', t, ' s'

            vec = fluidfoam.readvector(rep, t+'/', Vector)
            if np.size(vec)==0:
                    print 'remove 0 folder from time list, vector is uniform'
            vecX.append(vec[i, 0])
            vecY.append(vec[i, 1])
            vecZ.append(vec[i, 2])
            timeN.append(t)

        vecX = np.array(vecX)
        vecY = np.array(vecY)
        vecZ = np.array(vecZ)
        timeN = np.array(timeN)
        #
        # Plotting
        #
        write = 'no'
        if (write != 'no'):
            baseRep = rep+"Animation/"
            cmd = "mkdir "+baseRep
            os.system(cmd)
            baseName = baseRep+'anim'

        #
        #
        # Figure size
        #
        figwidth = 16
        figheight = 12

        # Open the figure
        fig = figure( figsize=(figwidth, figheight), dpi=60,
                     facecolor='w', edgecolor='w')
        gs = gridspec.GridSpec(4, 1)
        gs.update(left=0.1, right=0.95, top=0.95, bottom=0.1, wspace=0.25,
                  hspace=0.15)

        #
        # ax0
        #
        ax0 = subplot(gs[0, 0])
        l0 = ax0.plot(X, Y, '.k', markersize=3)
        l1 = ax0.plot(X[i], Y[i], 'or', markersize=12)

        xlabel("X (m)")
        ylabel("Y (m)")

        axis([np.min(X), np.max(X), np.min(Y), np.max(Y)])
        title('time serie')
        #
        # ax1
        #
        ax1 = subplot(gs[1, 0])
        l1 = ax1.plot(timeN, vecX)
        ylabel(Vector+" X component")
        ax1.set_xticklabels([])
        #
        # ax2
        #
        ax2 = subplot(gs[2, 0])
        l2 = ax2.plot(timeN, vecY)
        ylabel(Vector+" Y component")
        ax2.set_xticklabels([])
        #
        # ax3
        #
        ax3 = subplot(gs[3, 0])
        l3 = ax3.plot(timeN, vecZ)
        ylabel(Vector+" Z component")
        xlabel("t (s)")

        if ((write == 'png') | (write == 'eps')):
                fileName = baseName+t.replace('.', '_')+'.'+write
                print 'writing:', fileName
                show(block=False)
                savefig(fileName)

        show()

        return 0
