## Contribution Guidelines

### Welcome to our project! We appreciate your interest in contributing. To ensure a smooth and effective collaboration, please adhere to the following guidelines:

1. **Inclusions**: Contributions are encouraged, but please refrain from including hidden folders or files associated with any IDE environment.

2. **Project Integrity**: Avoid large-scale deletions of project components. Contributions should focus on enhancing or adding to the existing codebase.

3. **Relevance**: Ensure that added files are pertinent to the project's objectives, and avoid incorporating files unrelated to the project.

4. **API Preservation**: Refrain from making direct API changes. Propose API modifications through the designated issue tracker as enhancements.

5. **Code Clarity**: Do not submit contributions with obfuscated code. Maintain clarity and readability for ease of understanding.

6. **Binaries and Dependencies**: Exclude binary files and ensure that dependencies point to the original sources, even if they are not actively maintained. Cloning to the organization is encouraged.

7. **Modular Contributions**: Submit small pull requests (PRs) to facilitate a quicker reviewing process.

8. **Test Coverage**: Include a concise test case to validate the functionality of your contribution.

9. **Algorithm Naming**: Avoid naming algorithms after yourself; instead, use brief, descriptive names that reflect the functionality of the algorithm.

10. **No Vanity**: Contributions should prioritize the project's success over personal recognition.

11. **Compliance Check**: Contributions not meeting these criteria will be rejected initially. Ensure adherence to the guidelines before resubmitting.

Thank you for contributing responsibly and helping us maintain the quality and integrity of our project!
