primes_txt = []
notprimes_txt = []
primes_int = []
notprimes_int = []
primes_txt_arry = []

# SRP rfc5054
# 1024 bit prime

primes_txt += [
    """EEAF0AB9 ADB38DD6 9C33F80A FA8FC5E8 60726187 75FF3C0B 9EA2314C
          9C256576 D674DF74 96EA81D3 383B4813 D692C6E0 E0D5D8E2 50B98BE4
          8E495C1D 6089DAD1 5DC7D7B4 6154D6B6 CE8EF4AD 69B15D49 82559B29
          7BCF1885 C529F566 660E57EC 68EDBC3C 05726CC0 2FD4CBF4 976EAA9A
          FD5138FE 8376435B 9FC61D2F C0EB06E3"""
]

# 1536 bit prime

primes_txt += [
    """9DEF3CAF B939277A B1F12A86 17A47BBB DBA51DF4 99AC4C80 BEEEA961
          4B19CC4D 5F4F5F55 6E27CBDE 51C6A94B E4607A29 1558903B A0D0F843
          80B655BB 9A22E8DC DF028A7C EC67F0D0 8134B1C8 B9798914 9B609E0B
          E3BAB63D 47548381 DBC5B1FC 764E3F4B 53DD9DA1 158BFD3E 2B9C8CF5
          6EDF0195 39349627 DB2FD53D 24B7C486 65772E43 7D6C7F8C E442734A
          F7CCB7AE 837C264A E3A9BEB8 7F8A2FE9 B8B5292E 5A021FFF 5E91479E
          8CE7A28C 2442C6F3 15180F93 499A234D CF76E3FE D135F9BB"""
]

# 2048 bit prime
primes_txt += [
    """AC6BDB41 324A9A9B F166DE5E 1389582F AF72B665 1987EE07 FC319294
          3DB56050 A37329CB B4A099ED 8193E075 7767A13D D52312AB 4B03310D
          CD7F48A9 DA04FD50 E8083969 EDB767B0 CF609517 9A163AB3 661A05FB
          D5FAAAE8 2918A996 2F0B93B8 55F97993 EC975EEA A80D740A DBF4FF74
          7359D041 D5C33EA7 1D281E44 6B14773B CA97B43A 23FB8016 76BD207A
          436C6481 F1D2B907 8717461A 5B9D32E6 88F87748 544523B5 24B0D57D
          5EA77A27 75D2ECFA 032CFBDB F52FB378 61602790 04E57AE6 AF874E73
          03CE5329 9CCC041C 7BC308D8 2A5698F3 A8D0C382 71AE35F8 E9DBFBB6
          94B5C803 D89F7AE4 35DE236D 525F5475 9B65E372 FCD68EF2 0FA7111F
          9E4AFF73"""
]

# 4096 bit prime
# generator:   2^4096 - 2^4032 - 1 + 2^64 * { [2^3966 pi] + 240904 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08
          8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B
          302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9
          A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE6
          49286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8
          FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
          670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C
          180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 95581718
          3995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D
          04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7D
          B3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226
          1AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
          BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFC
          E0FD108E 4B82D120 A93AD2CA FFFFFFFF FFFFFFFF"""
]

# 6144-bit Group
# This prime is: 2^6144 - 2^6080 - 1 + 2^64 * { [2^6014 pi] + 929484 }

primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08
          8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B
          302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9
          A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE6
          49286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8
          FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
          670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C
          180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 95581718
          3995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D
          04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7D
          B3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226
          1AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
          BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFC
          E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7 88719A10 BDBA5B26
          99C32718 6AF4E23C 1A946834 B6150BDA 2583E9CA 2AD44CE8 DBBBC2DB
          04DE8EF9 2E8EFC14 1FBECAA6 287C5947 4E6BC05D 99B2964F A090C3A2
          233BA186 515BE7ED 1F612970 CEE2D7AF B81BDD76 2170481C D0069127
          D5B05AA9 93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34028492
          36C3FAB4 D27C7026 C1D4DCB2 602646DE C9751E76 3DBA37BD F8FF9406
          AD9E530E E5DB382F 413001AE B06A53ED 9027D831 179727B0 865A8918
          DA3EDBEB CF9B14ED 44CE6CBA CED4BB1B DB7F1447 E6CC254B 33205151
          2BD7AF42 6FB8F401 378CD2BF 5983CA01 C64B92EC F032EA15 D1721D03
          F482D7CE 6E74FEF6 D55E702F 46980C82 B5A84031 900B1C9E 59E7C97F
          BEC7E8F3 23A97A7E 36CC88BE 0F1D45B7 FF585AC5 4BD407B2 2B4154AA
          CC8F6D7E BF48E1D8 14CC5ED2 0F8037E0 A79715EE F29BE328 06A1D58B
          B7C5DA76 F550AA3D 8A1FBFF0 EB19CCB1 A313D55C DA56C9EC 2EF29632
          387FE8D7 6E3C0468 043E8F66 3F4860EE 12BF2D5B 0B7474D6 E694F91E
          6DCC4024 FFFFFFFF FFFFFFFF"""
]

# 8192-bit Group
# 2^8192 - 2^8128 - 1 + 2^64 * { [2^8062 pi] + 4743158 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08
          8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B
          302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9
          A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE6
          49286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8
          FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
          670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C
          180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 95581718
          3995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D
          04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7D
          B3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226
          1AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
          BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFC
          E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7 88719A10 BDBA5B26
          99C32718 6AF4E23C 1A946834 B6150BDA 2583E9CA 2AD44CE8 DBBBC2DB
          04DE8EF9 2E8EFC14 1FBECAA6 287C5947 4E6BC05D 99B2964F A090C3A2
          233BA186 515BE7ED 1F612970 CEE2D7AF B81BDD76 2170481C D0069127
          D5B05AA9 93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34028492
          36C3FAB4 D27C7026 C1D4DCB2 602646DE C9751E76 3DBA37BD F8FF9406
          AD9E530E E5DB382F 413001AE B06A53ED 9027D831 179727B0 865A8918
          DA3EDBEB CF9B14ED 44CE6CBA CED4BB1B DB7F1447 E6CC254B 33205151
          2BD7AF42 6FB8F401 378CD2BF 5983CA01 C64B92EC F032EA15 D1721D03
          F482D7CE 6E74FEF6 D55E702F 46980C82 B5A84031 900B1C9E 59E7C97F
          BEC7E8F3 23A97A7E 36CC88BE 0F1D45B7 FF585AC5 4BD407B2 2B4154AA
          CC8F6D7E BF48E1D8 14CC5ED2 0F8037E0 A79715EE F29BE328 06A1D58B
          B7C5DA76 F550AA3D 8A1FBFF0 EB19CCB1 A313D55C DA56C9EC 2EF29632
          387FE8D7 6E3C0468 043E8F66 3F4860EE 12BF2D5B 0B7474D6 E694F91E
          6DBE1159 74A3926F 12FEE5E4 38777CB6 A932DF8C D8BEC4D0 73B931BA
          3BC832B6 8D9DD300 741FA7BF 8AFC47ED 2576F693 6BA42466 3AAB639C
          5AE4F568 3423B474 2BF1C978 238F16CB E39D652D E3FDB8BE FC848AD9
          22222E04 A4037C07 13EB57A8 1A23F0C7 3473FC64 6CEA306B 4BCBC886
          2F8385DD FA9D4B7F A2C087E8 79683303 ED5BDD3A 062B3CF5 B3A278A6
          6D2A13F8 3F44F82D DF310EE0 74AB6A36 4597E899 A0255DC1 64F31CC5
          0846851D F9AB4819 5DED7EA1 B1D510BD 7EE74D73 FAF36BC3 1ECFA268
          359046F4 EB879F92 4009438B 481C6CD7 889A002E D5EE382B C9190DA6
          FC026E47 9558E447 5677E9AA 9E3050E2 765694DF C81F56E8 80B96E71
          60C980DD 98EDD3DF FFFFFFFF FFFFFFFF"""
]

# TOR DH Primes

# TLS_DH_PRIME
primes_txt += [
    """D67DE440CBBBDC1936D693D34AFD0AD50C84D239A45F520BB88174CB98
BCE951849F912E639C72FB13B4B4D7177E16D55AC179BA420B2A29FE324A
467A635E81FF5901377BEDDCFD33168A461AAD3B72DAE8860078045B07A7
DBCA7874087D1510EA9FCC9DDD330507DD62DB88AEAA747DE0F4D6E2BD68
B0E7393E0F24218EB3"""
]

# OAKLEY_PRIME_2
primes_txt += [
    """FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E08
8A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B
302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9
A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE6
49286651ECE65381FFFFFFFFFFFFFFFF"""
]

# Mozilla FF dhe 2048

primes_int += [
    0x00FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B423861285C97FFFFFFFFFFFFFFFF
]

# Mozilla FF dhe 3072

primes_int += [
    0x00FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C023861B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91CAEFE130985139270B4130C93BC437944F4FD4452E2D74DD364F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0DABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF3C1B20EE3FD59D7C25E41D2B66C62E37FFFFFFFFFFFFFFFF
]

# Mozilla FF dhe 4096

primes_int += [
    0x00FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C023861B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91CAEFE130985139270B4130C93BC437944F4FD4452E2D74DD364F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0DABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF3C1B20EE3FD59D7C25E41D2B669E1EF16E6F52C3164DF4FB7930E9E4E58857B6AC7D5F42D69F6D187763CF1D5503400487F55BA57E31CC7A7135C886EFB4318AED6A1E012D9E6832A907600A918130C46DC778F971AD0038092999A333CB8B7A1A1DB93D7140003C2A4ECEA9F98D0ACC0A8291CDCEC97DCF8EC9B55A7F88A46B4DB5A851F44182E1C68A007E5E655F6AFFFFFFFFFFFFFFFF
]

# Primes in rfc5114
# https://tools.ietf.org/html/rfc5114

# 1024-bit MODP Group with 160-bit Prime Order Subgroup
# P
primes_txt += [
    """B10B8F96 A080E01D DE92DE5E AE5D54EC 52C99FBC FB06A3C6
9A6A9DCA 52D23B61 6073E286 75A23D18 9838EF1E 2EE652C0
13ECB4AE A9061123 24975C3C D49B83BF ACCBDD7D 90C4BD70
98488E9C 219A7372 4EFFD6FA E5644738 FAA31A4F F55BCCC0
A151AF5F 0DC8B4BD 45BF37DF 365C1A65 E68CFDA7 6D4DA708
DF1FB2BC 2E4A4371"""
]

# G
notprimes_txt += [
    """A4D1CBD5 C3FD3412 6765A442 EFB99905 F8104DD2 58AC507F
D6406CFF 14266D31 266FEA1E 5C41564B 777E690F 5504F213
160217B4 B01B886A 5E91547F 9E2749F4 D7FBD7D3 B9A92EE1
909D0D22 63F80A76 A6A24C08 7A091F53 1DBF0A01 69B6A28A
D662A4D1 8E73AFA3 2D779D59 18D08BC8 858F4DCE F97C2A24
855E6EEB 22B3B2E5"""
]

# q
primes_txt += ["F518AA87 81A8DF27 8ABA4E7D 64B7CB9D 49462353"]

# 2048-bit MODP Group with 224-bit Prime Order Subgroup
# P
primes_txt += [
    """D107E1E 9123A9D0 D660FAA7 9559C51F A20D64E5 683B9FD1
B54B1597 B61D0A75 E6FA141D F95A56DB AF9A3C40 7BA1DF15
EB3D688A 309C180E 1DE6B85A 1274A0A6 6D3F8152 AD6AC212
9037C9ED EFDA4DF8 D91E8FEF 55B7394B 7AD5B7D0 B6C12207
C9F98D11 ED34DBF6 C6BA0B2C 8BBC27BE 6A00E0A0 B9C49708
B3BF8A31 70918836 81286130 BC8985DB 1602E714 415D9330
278273C7 DE31EFDC 7310F712 1FD5A074 15987D9A DC0A486D
CDF93ACC 44328387 315D75E1 98C641A4 80CD86A1 B9E587E8
BE60E69C C928B2B9 C52172E4 13042E9B 23F10B0E 16E79763
C9B53DCF 4BA80A29 E3FB73C1 6B8E75B9 7EF363E2 FFA31F71
CF9DE538 4E71B81C 0AC4DFFE 0C10E64F"""
]

# G
notprimes_txt += [
    """AC4032EF 4F2D9AE3 9DF30B5C 8FFDAC50 6CDEBE7B 89998CAF
74866A08 CFE4FFE3 A6824A4E 10B9A6F0 DD921F01 A70C4AFA
AB739D77 00C29F52 C57DB17C 620A8652 BE5E9001 A8D66AD7
C1766910 1999024A F4D02727 5AC1348B B8A762D0 521BC98A
E2471504 22EA1ED4 09939D54 DA7460CD B5F6C6B2 50717CBE
F180EB34 118E98D1 19529A45 D6F83456 6E3025E3 16A330EF
BB77A86F 0C1AB15B 051AE3D4 28C8F8AC B70A8137 150B8EEB
10E183ED D19963DD D9E263E4 770589EF 6AA21E7F 5F2FF381
B539CCE3 409D13CD 566AFBB4 8D6C0191 81E1BCFE 94B30269
EDFE72FE 9B6AA4BD 7B5A0F1C 71CFFF4C 19C418E1 F6EC0179
81BC087F 2A7065B3 84B890D3 191F2BFA"""
]

# Q
primes_txt += [
    """801C0D34 C58D93FE 99717710 1F80535A 4738CEBC BF389A99
B36371EB"""
]

# 2048-bit MODP Group with 256-bit Prime Order Subgroup
# P
primes_txt += [
    """87A8E61D B4B6663C FFBBD19C 65195999 8CEEF608 660DD0F2
5D2CEED4 435E3B00 E00DF8F1 D61957D4 FAF7DF45 61B2AA30
16C3D911 34096FAA 3BF4296D 830E9A7C 209E0C64 97517ABD
5A8A9D30 6BCF67ED 91F9E672 5B4758C0 22E0B1EF 4275BF7B
6C5BFC11 D45F9088 B941F54E B1E59BB8 BC39A0BF 12307F5C
4FDB70C5 81B23F76 B63ACAE1 CAA6B790 2D525267 35488A0E
F13C6D9A 51BFA4AB 3AD83477 96524D8E F6A167B5 A41825D9
67E144E5 14056425 1CCACB83 E6B486F6 B3CA3F79 71506026
C0B857F6 89962856 DED4010A BD0BE621 C3A3960A 54E710C3
75F26375 D7014103 A4B54330 C198AF12 6116D227 6E11715F
693877FA D7EF09CA DB094AE9 1E1A1597"""
]

# G
notprimes_txt += [
    """3FB32C9B 73134D0B 2E775066 60EDBD48 4CA7B18F 21EF2054
07F4793A 1A0BA125 10DBC150 77BE463F FF4FED4A AC0BB555
BE3A6C1B 0C6B47B1 BC3773BF 7E8C6F62 901228F8 C28CBB18
A55AE313 41000A65 0196F931 C77A57F2 DDF463E5 E9EC144B
777DE62A AAB8A862 8AC376D2 82D6ED38 64E67982 428EBC83
1D14348F 6F2F9193 B5045AF2 767164E1 DFC967C1 FB3F2E55
A4BD1BFF E83B9C80 D052B985 D182EA0A DB2A3B73 13D3FE14
C8484B1E 052588B9 B7D2BBD2 DF016199 ECD06E15 57CD0915
B3353BBB 64E0EC37 7FD02837 0DF92B52 C7891428 CDC67EB6
184B523D 1DB246C3 2F630784 90F00EF8 D647D148 D4795451
5E2327CF EF98C582 664B4C0F 6CC41659"""
]

# Q
primes_txt += [
    """8CF83642 A709A097 B4479976 40129DA2 99B1A47D 1EB3750B
A308B0FE 64F5FBD3"""
]

# 192-bit Random ECP Group
# p = 2^(192) - 2^(64) - 1
# Group prime
primes_txt += ["FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFE FFFFFFFF FFFFFFFF"]
# A
notprimes_txt += ["FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFE FFFFFFFF FFFFFFFC"]
# B
notprimes_txt += ["64210519 E59C80E7 0FA7E9AB 72243049 FEB8DEEC C146B9B1"]
# gy
notprimes_txt += ["188DA80E B03090F6 7CBF20EB 43A18800 F4FF0AFD 82FF1012"]
# gx
notprimes_txt += ["07192B95 FFC8DA78 631011ED 6B24CDD5 73F977A1 1E794811"]

# Group order
primes_txt += ["FFFFFFFF FFFFFFFF FFFFFFFF 99DEF836 146BC9B1 B4D22831"]

# 224-bit Random ECP Group
# p = 2^(224) - 2^(96) + 1
# Group prime
primes_txt += [
    """FFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF 00000000 00000000
00000001"""
]
# A
notprimes_txt += [
    """FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFE FFFFFFFF FFFFFFFF
FFFFFFFE"""
]
# B
notprimes_txt += [
    """B4050A85 0C04B3AB F5413256 5044B0B7 D7BFD8BA 270B3943
2355FFB4"""
]
# gx
notprimes_txt += [
    """B70E0CBD 6BB4BF7F 321390B9 4A03C1D3 56C21122 343280D6
115C1D21"""
]
# gy
notprimes_txt += [
    """BD376388 B5F723FB 4C22DFE6 CD4375A0 5A074764 44D58199
85007E34"""
]
primes_txt += [
    """FFFFFFFF FFFFFFFF FFFFFFFF FFFF16A2 E0B8F03E 13DD2945
5C5C2A3D"""
]

# 256-bit Random ECP Group
# p = 2^(256)-2^(224)+2^(192)+2^(96)-1

# Group prime (in hexadecimal):
primes_txt += [
    """FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF
FFFFFFFF FFFFFFFF"""
]

# Group curve parameter A (in hexadecimal):
notprimes_txt += [
    """FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF FFFFFFFF FFFFFFFC"""
]
# Group curve parameter B (in hexadecimal):
notprimes_txt += [
    """5AC635D8 AA3A93E7 B3EBBD55 769886BC 651D06B0 CC53B0F6
3BCE3C3E 27D2604B"""
]
# gx
notprimes_txt += [
    """6B17D1F2 E12C4247 F8BCE6E5 63A440F2 77037D81 2DEB33A0
F4A13945 D898C296"""
]
# gy
notprimes_txt += [
    """4FE342E2 FE1A7F9B 8EE7EB4A 7C0F9E16 2BCE3357 6B315ECE
CBB64068 37BF51F5"""
]
# Group Order (in hexadecimal):
primes_txt += [
    """FFFFFFFF 00000000 FFFFFFFF FFFFFFFF BCE6FAAD A7179E84
F3B9CAC2 FC632551"""
]

# 384-bit Random ECP Group
# p = 2^(384)-2^(128)-2^(96)+2^(32)-1
# P
primes_txt += [
    """FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFE FFFFFFFF 00000000 00000000 FFFFFFFF"""
]
# A
notprimes_txt += [
    """FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFE FFFFFFFF 00000000 00000000 FFFFFFFC"""
]
# B
notprimes_txt += [
    """B3312FA7 E23EE7E4 988E056B E3F82D19 181D9C6E FE814112
0314088F 5013875A C656398D 8A2ED19D 2A85C8ED D3EC2AEF"""
]
# gx
notprimes_txt += [
    """AA87CA22 BE8B0537 8EB1C71E F320AD74 6E1D3B62 8BA79B98
59F741E0 82542A38 5502F25D BF55296C 3A545E38 72760AB7"""
]
# gy
notprimes_txt += [
    """3617DE4A 96262C6F 5D9E98BF 9292DC29 F8F41DBD 289A147C
E9DA3113 B5F0B8C0 0A60B1CE 1D7E819D 7A431D7C 90EA0E5F"""
]
# n
primes_txt += [
    """FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
C7634D81 F4372DDF 581A0DB2 48B0A77A ECEC196A CCC52973"""
]

# 521-bit Random ECP Group
# P
primes_txt += [
    """000001FF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF"""
]
# A
notprimes_txt += [
    """000001FF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFC"""
]
# B
notprimes_txt += [
    """00000051 953EB961 8E1C9A1F 929A21A0 B68540EE A2DA725B
99B315F3 B8B48991 8EF109E1 56193951 EC7E937B 1652C0BD
3BB1BF07 3573DF88 3D2C34F1 EF451FD4 6B503F00"""
]
# gx
notprimes_txt += [
    """000000C6 858E06B7 0404E9CD 9E3ECB66 2395B442 9C648139
053FB521 F828AF60 6B4D3DBA A14B5E77 EFE75928 FE1DC127
A2FFA8DE 3348B3C1 856A429B F97E7E31 C2E5BD66"""
]
# gy
notprimes_txt += [
    """00000118 39296A78 9A3BC004 5C8A5FB4 2C7D1BD9 98F54449
579B4468 17AFBD17 273E662C 97EE7299 5EF42640 C550B901
3FAD0761 353C7086 A272C240 88BE9476 9FD16650"""
]
# Group Order (in hexadecimal): n
primes_txt += [
    """000001FF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
FFFFFFFF FFFFFFFF FFFFFFFA 51868783 BF2F966B 7FCC0148
F709A5D0 3BB5C9B8 899C47AE BB6FB71E 91386409"""
]

# 1024-bit MODP Group with 160-bit Prime Order Subgroup
# xA
notprimes_txt += ["""B9A3B3AE 8FEFC1A2 93049650 7086F845 5D48943E"""]
# yA
notprimes_txt += [
    """2A853B3D 92197501
B9015B2D EB3ED84F 5E021DCC 3E52F109 D3273D2B 7521281C
BABE0E76 FF5727FA 8ACCE269 56BA9A1F CA26F202 28D8693F
EB10841D 84A73600 54ECE5A7 F5B7A61A D3DFB3C6 0D2E4310
6D8727DA 37DF9CCE 95B47875 5D06BCEA 8F9D4596 5F75A5F3
D1DF3701 165FC9E5 0C4279CE B07F9895 40AE96D5 D88ED776"""
]
# xB
notprimes_txt += ["""9392C9F9 EB6A7A6A 9022F7D8 3E7223C6 835BBDDA"""]
# yB
notprimes_txt += [
    """717A6CB0 53371FF4
A3B93294 1C1E5663 F861A1D6 AD34AE66 576DFB98 F6C6CBF9
DDD5A56C 7833F6BC FDFF0955 82AD868E 440E8D09 FD769E3C
ECCDC3D3 B1E4CFA0 57776CAA F9739B6A 9FEE8E74 11F8D6DA
C09D6A4E DB46CC2B 5D520309 0EAE6126 311E53FD 2C14B574
E6A3109A 3DA1BE41 BDCEAA18 6F5CE067 16A2B6A0 7B3C33FE"""
]
# Z
notprimes_txt += [
    """5C804F45 4D30D9C4
DF85271F 93528C91 DF6B48AB 5F80B3B5 9CAAC1B2 8F8ACBA9
CD3E39F3 CB614525 D9521D2E 644C53B8 07B810F3 40062F25
7D7D6FBF E8D5E8F0 72E9B6E9 AFDA9413 EAFB2E8B 0699B1FB
5A0CACED DEAEAD7E 9CFBB36A E2B42083 5BD83A19 FB0B5E96
BF8FA4D0 9E345525 167ECD91 55416F46 F408ED31 B63C6E6D"""
]


# 2048-bit MODP Group with 224-bit Prime Order Subgroup
# xA
notprimes_txt += ["""22E62601 DBFFD067 08A680F7 47F361F7 6D8F4F72 1A0548E4 83294B0C"""]
# yA
notprimes_txt += [
    """1B3A6345 1BD886E6 99E67B49 4E288BD7
F8E0D370 BADDA7A0 EFD2FDE7 D8F66145 CC9F2804 19975EB8
08877C8A 4C0C8E0B D48D4A54 01EB1E87 76BFEEE1 34C03831
AC273CD9 D635AB0C E006A42A 887E3F52 FB8766B6 50F38078
BC8EE858 0CEFE243 968CFC4F 8DC3DB08 4554171D 41BF2E86
1B7BB4D6 9DD0E01E A387CBAA 5CA672AF CBE8BDB9 D62D4CE1
5F17DD36 F91ED1EE DD65CA4A 06455CB9 4CD40A52 EC360E84
B3C926E2 2C4380A3 BF309D56 849768B7 F52CFDF6 55FD053A
7EF70697 9E7E5806 B17DFAE5 3AD2A5BC 568EBB52 9A7A61D6
8D256F8F C97C074A 861D827E 2EBC8C61 34553115 B70E7103
920AA16D 85E52BCB AB8D786A 68178FA8 FF7C2F5C 71648D6F"""
]
# xB
notprimes_txt += ["""4FF3BC96 C7FC6A6D 71D3B363 800A7CDF EF6FC41B 4417EA15 353B7590"""]
# yB
notprimes_txt += [
    """4DCEE992 A9762A13 F2F83844 AD3D77EE
0E31C971 8B3DB6C2 035D3961 182C3E0B A247EC41 82D760CD
48D99599 970622A1 881BBA2D C822939C 78C3912C 6661FA54
38B20766 222B75E2 4C2E3AD0 C7287236 129525EE 15B5DD79
98AA04C4 A9696CAC D7172083 A97A8166 4EAD2C47 9E444E4C
0654CC19 E28D7703 CEE8DACD 6126F5D6 65EC52C6 7255DB92
014B037E B621A2AC 8E365DE0 71FFC140 0ACF077A 12913DD8
DE894734 37AB7BA3 46743C1B 215DD9C1 2164A7E4 053118D1
99BEC8EF 6FC56117 0C84C87D 10EE9A67 4A1FA8FF E13BDFBA
1D44DE48 946D68DC 0CDD7776 35A7AB5B FB1E4BB7 B856F968
27734C18 4138E915 D9C3002E BCE53120 546A7E20 02142B6C"""
]
# Z
notprimes_txt += [
    """34D9BDDC 1B42176C 313FEA03 4C21034D
074A6313 BB4ECDB3 703FFF42 4567A46B DF75530E DE0A9DA5
229DE7D7 6732286C BC0F91DA 4C3C852F C099C679 531D94C7
8AB03D9D ECB0A4E4 CA8B2BB4 591C4021 CF8CE3A2 0A541D33
994017D0 200AE2C9 516E2FF5 14577926 9E862B0F B474A2D5
6DC31ED5 69A7700B 4C4AB16B 22A45513 531EF523 D7121207
7B5A169B DEFFAD7A D9608284 C7795B6D 5A5183B8 7066DE17
D8D671C9 EBD8EC89 544D45EC 061593D4 42C62AB9 CE3B1CB9
943A1D23 A5EA3BCF 21A01471 E67E003E 7F8A69C7 28BE490B
2FC88CFE B92DB6A2 15E5D03C 17C464C9 AC1A46E2 03E13F95
2995FB03 C69D3CC4 7FCB510B 6998FFD3 AA6DE73C F9F63869"""
]


# 2048-bit MODP Group with 256-bit Prime Order Subgroup
# xA
notprimes_txt += [
    """0881382C DB87660C
6DC13E61 4938D5B9 C8B2F248 581CC5E3 1B354543 97FCE50E"""
]
# yA
notprimes_txt += [
    """2E9380C8 323AF975 45BC4941 DEB0EC37
42C62FE0 ECE824A6 ABDBE66C 59BEE024 2911BFB9 67235CEB
A35AE13E 4EC752BE 630B92DC 4BDE2847 A9C62CB8 15274542
1FB7EB60 A63C0FE9 159FCCE7 26CE7CD8 523D7450 667EF840
E4919121 EB5F01C8 C9B0D3D6 48A93BFB 75689E82 44AC134A
F544711C E79A02DC C3422668 4780DDDC B4985941 06C37F5B
C7985648 7AF5AB02 2A2E5E42 F09897C1 A85A11EA 0212AF04
D9B4CEBC 937C3C1A 3E15A8A0 342E3376 15C84E7F E3B8B9B8
7FB1E73A 15AF12A3 0D746E06 DFC34F29 0D797CE5 1AA13AA7
85BF6658 AFF5E4B0 93003CBE AF665B3C 2E113A3A 4E905269
341DC071 1426685F 4EF37E86 8A8126FF 3F2279B5 7CA67E29"""
]
# xB
notprimes_txt += [
    """7D62A7E3 EF36DE61 7B13D1AF B82C780D 83A23BD4 EE670564 5121F371 F546A53D"""
]
# yB
notprimes_txt += [
    """575F0351 BD2B1B81 7448BDF8 7A6C362C
1E289D39 03A30B98 32C5741F A250363E 7ACBC7F7 7F3DACBC
1F131ADD 8E03367E FF8FBBB3 E1C57844 24809B25 AFE4D226
2A1A6FD2 FAB64105 CA30A674 E07F7809 85208863 2FC04923
3791AD4E DD083A97 8B883EE6 18BC5E0D D047415F 2D95E683
CF14826B 5FBE10D3 CE41C6C1 20C78AB2 0008C698 BF7F0BCA
B9D7F407 BED0F43A FB2970F5 7F8D1204 3963E66D DD320D59
9AD9936C 8F44137C 08B180EC 5E985CEB E186F3D5 49677E80
607331EE 17AF3380 A725B078 2317D7DD 43F59D7A F9568A9B
B63A84D3 65F92244 ED120988 219302F4 2924C7CA 90B89D24
F71B0AB6 97823D7D EB1AFF5B 0E8E4A45 D49F7F53 757E1913"""
]
# Z
notprimes_txt += [
    """86C70BF8 D0BB81BB 01078A17 219CB7D2
7203DB2A 19C877F1 D1F19FD7 D77EF225 46A68F00 5AD52DC8
4553B78F C60330BE 51EA7C06 72CAC151 5E4B35C0 47B9A551
B88F39DC 26DA14A0 9EF74774 D47C762D D177F9ED 5BC2F11E
52C879BD 95098504 CD9EECD8 A8F9B3EF BD1F008A C5853097
D9D1837F 2B18F77C D7BE01AF 80A7C7B5 EA3CA54C C02D0C11
6FEE3F95 BB873993 85875D7E 86747E67 6E728938 ACBFF709
8E05BE4D CFB24052 B83AEFFB 14783F02 9ADBDE7F 53FAE920
84224090 E007CEE9 4D4BF2BA CE9FFD4B 57D2AF7C 724D0CAA
19BF0501 F6F17B4A A10F425E 3EA76080 B4B9D6B3 CEFEA115
B2CEB878 9BB8A3B0 EA87FEBE 63B6C8F8 46EC6DB0 C26C5D7C"""
]

# 192-bit Random ECP Group
# dA
notprimes_txt += ["323FA316 9D8E9C65 93F59476 BC142000 AB5BE0E2 49C43426"]
# x_qA
notprimes_txt += ["CD46489E CFD6C105 E7B3D325 66E2B122 E249ABAA DD870612"]
# y_qA
notprimes_txt += ["68887B48 77DF51DD 4DC3D6FD 11F0A26F 8FD38443 17916E9A"]
# dB
notprimes_txt += ["631F95BB 4A67632C 9C476EEE 9AB695AB 240A0499 307FCF62"]
# x_qB
notprimes_txt += ["519A1216 80E00454 66BA21DF 2EEE47F5 973B5005 77EF13D5"]
# y_qB
notprimes_txt += ["FF613AB4 D64CEE3A 20875BDB 10F953F6 B30CA072 C60AA57F"]
# x_Z
notprimes_txt += ["AD420182 633F8526 BFE954AC DA376F05 E5FF4F83 7F54FEBE"]
# y_Z
notprimes_txt += ["4371545E D772A597 41D0EDA3 2C671112 B7FDDD51 461FCF32"]

# 224-bit Random ECP Group
# dA
notprimes_txt += ["""B558EB6C 288DA707 BBB4F8FB AE2AB9E9 CB62E3BC 5C7573E2 2E26D37F"""]
# x_qA
notprimes_txt += ["""49DFEF30 9F81488C 304CFF5A B3EE5A21 54367DC7 833150E0 A51F3EEB"""]
# y_qA
notprimes_txt += ["""4F2B5EE4 5762C4F6 54C1A0C6 7F54CF88 B016B51B CE3D7C22 8D57ADB4"""]
# dB
notprimes_txt += ["""AC3B1ADD 3D9770E6 F6A708EE 9F3B8E0A B3B480E9 F27F85C8 8B5E6D18"""]
# x_qB
notprimes_txt += ["""6B3AC96A 8D0CDE6A 5599BE80 32EDF10C 162D0A8A D219506D CD42A207"""]
# y_qB
notprimes_txt += ["""D491BE99 C213A7D1 CA3706DE BFE305F3 61AFCBB3 3E2609C8 B1618AD5"""]
# x_Z
notprimes_txt += ["""52272F50 F46F4EDC 91515690 92F46DF2 D96ECC3B 6DC1714A 4EA949FA"""]
# y_Z  =
notprimes_txt += ["""5F30C6AA 36DDC403 C0ACB712 BB88F176 3C3046F6 D919BD9C 524322BF"""]


# 256-bit Random ECP Group
# dA   =
notprimes_txt += [
    """81426414 5F2F56F2 E96A8E33 7A128499 3FAF432A 5ABCE59E 867B7291 D507A3AF"""
]
# x_qA
notprimes_txt += [
    """2AF502F3 BE8952F2 C9B5A8D4 160D09E9 7165BE50 BC42AE4A 5E8D3B4B A83AEB15"""
]
# y_qA
notprimes_txt += [
    """EB0FAF4C A986C4D3 8681A0F9 872D79D5 6795BD4B FF6E6DE3 C0F5015E CE5EFD85"""
]
# dB
notprimes_txt += [
    """2CE1788E C197E096 DB95A200 CC0AB26A 19CE6BCC AD562B8E EE1B5937 61CF7F41"""
]
# x_qB
notprimes_txt += [
    """B120DE4A A3649279 5346E8DE 6C2C8646 AE06AAEA 279FA775 B3AB0715 F6CE51B0"""
]
# y_qB
notprimes_txt += [
    """9F1B7EEC E20D7B5E D8EC685F A3F071D8 37270270 92A84113 85C34DDE 5708B2B6"""
]
# x_Z
notprimes_txt += [
    """DD0F5396 219D1EA3 93310412 D19A08F1 F5811E9D C8EC8EEA 7F80D21C 820C2788"""
]
# y_Z
notprimes_txt += [
    """0357DCCD 4C804D0D 8D33AA42 B848834A A5605F9A B0D37239 A115BBB6 47936F50"""
]


# 384-bit Random ECP Group
# dA
notprimes_txt += [
    """D27335EA 71664AF2 44DD14E9 FD126071 5DFD8A79 65571C48 D709EE7A 7962A156 D706A90C BCB5DF29 86F05FEA DB9376F1"""
]
# x_qA
notprimes_txt += [
    """793148F1 787634D5 DA4C6D90 74417D05 E057AB62 F82054D1 0EE6B040 3D627954 7E6A8EA9 D1FD7742 7D016FE2 7A8B8C66"""
]
# y_qA
notprimes_txt += [
    """C6C41294 331D23E6 F480F4FB 4CD40504 C947392E 94F4C3F0 6B8F398B B29E4236 8F7A6859 23DE3B67 BACED214 A1A1D128"""
]
# dB
notprimes_txt += [
    """52D1791F DB4B70F8 9C0F00D4 56C2F702 3B612526 2C36A7DF 1F802311 21CCE3D3 9BE52E00 C194A413 2C4A6C76 8BCD94D2"""
]
# x_qB
notprimes_txt += [
    """5CD42AB9 C41B5347 F74B8D4E FB708B3D 5B36DB65 915359B4 4ABC1764 7B6B9999 789D72A8 4865AE2F 223F12B5 A1ABC120"""
]
# y_qB
notprimes_txt += [
    """E171458F EAA939AA A3A8BFAC 46B404BD 8F6D5B34 8C0FA4D8 0CECA163 56CA9332 40BDE872 3415A8EC E035B0ED F36755DE"""
]
# x_Z
notprimes_txt += [
    """5EA1FC4A F7256D20 55981B11 0575E0A8 CAE53160 137D904C 59D926EB 1B8456E4 27AA8A45 40884C37 DE159A58 028ABC0E"""
]
# y_Z
notprimes_txt += [
    """0CC59E4B 046414A8 1C8A3BDF DCA92526 C48769DD 8D3127CA A99B3632 D1913942 DE362EAF AA962379 374D9F3F 066841CA"""
]


# 521-bit Random ECP Group
# dA
notprimes_txt += [
    """0113 F82DA825 735E3D97 276683B2 B74277BA D27335EA 71664AF2 430CC4F3 3459B966 9EE78B3F FB9B8683 015D344D CBFEF6FB 9AF4C6C4 70BE2545 16CD3C1A 1FB47362"""
]

# x_qA
notprimes_txt += [
    """01EB B34DD757 21ABF8AD C9DBED17 889CBB97 65D90A7C 60F2CEF0 07BB0F2B 26E14881 FD4442E6 89D61CB2 DD046EE3 0E3FFD20 F9A45BBD F6413D58 3A2DBF59 924FD35C"""
]

# y_qA
notprimes_txt += [
    """00F6 B632D194 C0388E22 D8437E55 8C552AE1 95ADFD15 3F92D749 08351B2F 8C4EDA94 EDB0916D 1B53C020 B5EECAED 1A5FC38A 233E4830 587BB2EE 3489B3B4 2A5A86A4"""
]

# dB
notprimes_txt += [
    """00CE E3480D86 45A17D24 9F2776D2 8BAE6169 52D1791F DB4B70F7 C3378732 AA1B2292 8448BCD1 DC2496D4 35B01048 066EBE4F 72903C36 1B1A9DC1 193DC2C9 D0891B96"""
]

# x_qB
notprimes_txt += [
    """010E BFAFC6E8 5E08D24B FFFCC1A4 511DB0E6 34BEEB1B 6DEC8C59 39AE4476 6201AF62 00430BA9 7C8AC6A0 E9F08B33 CE7E9FEE B5BA4EE5 E0D81510 C24295B8 A08D0235"""
]

# y_qB
notprimes_txt += [
    """00A4 A6EC300D F9E257B0 372B5E7A BFEF0934 36719A77 887EBB0B 18CF8099 B9F4212B 6E30A141 9C18E029 D36863CC 9D448F4D BA4D2A0E 60711BE5 72915FBD 4FEF2695"""
]

# x_Z
notprimes_txt += [
    """00CD EA89621C FA46B132 F9E4CFE2 261CDE2D 4368EB56 56634C7C C98C7A00 CDE54ED1 866A0DD3 E6126C9D 2F845DAF F82CEB1D A08F5D87 521BB0EB ECA77911 169C20CC"""
]

# y_Z
notprimes_txt += [
    """00F9 A7164102 9B7FC1A8 08AD07CD 4861E868 614B865A FBECAB1F 2BD4D8B5 5EBCB5E3 A53143CE B2C511B1 AE0AF5AC 827F60F2 FD872565 AC5CA0A1 64038FE9 80A7E4BD"""
]


# Primes found in RFC3526
# https://tools.ietf.org/html/rfc3526

# G13
# 2^1536 - 2^1472 - 1 + 2^64 * { [2^1406 pi] + 741804 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA237327 FFFFFFFF FFFFFFFF"""
]

# G14
# 2^2048 - 2^1984 - 1 + 2^64 * { [2^1918 pi] + 124476 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
15728E5A 8AACAA68 FFFFFFFF FFFFFFFF"""
]

# G15
# 2^3072 - 2^3008 - 1 + 2^64 * { [2^2942 pi] + 1690314 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
15728E5A 8AAAC42D AD33170D 04507A33 A85521AB DF1CBA64
ECFB8504 58DBEF0A 8AEA7157 5D060C7D B3970F85 A6E1E4C7
ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226 1AD2EE6B
F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31
43DB5BFC E0FD108E 4B82D120 A93AD2CA FFFFFFFF FFFFFFFF"""
]

# G16
# 2^4096 - 2^4032 - 1 + 2^64 * { [2^3966 pi] + 240904 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
15728E5A 8AAAC42D AD33170D 04507A33 A85521AB DF1CBA64
ECFB8504 58DBEF0A 8AEA7157 5D060C7D B3970F85 A6E1E4C7
ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226 1AD2EE6B
F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31
43DB5BFC E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7
88719A10 BDBA5B26 99C32718 6AF4E23C 1A946834 B6150BDA
2583E9CA 2AD44CE8 DBBBC2DB 04DE8EF9 2E8EFC14 1FBECAA6
287C5947 4E6BC05D 99B2964F A090C3A2 233BA186 515BE7ED
1F612970 CEE2D7AF B81BDD76 2170481C D0069127 D5B05AA9
93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34063199
FFFFFFFF FFFFFFFF"""
]

# G17
# 2^6144 - 2^6080 - 1 + 2^64 * { [2^6014 pi] + 929484 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08
8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B
302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9
A637ED6B 0BFF5CB6 F406B7ED EE386BFB 5A899FA5 AE9F2411 7C4B1FE6
49286651 ECE45B3D C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8
FD24CF5F 83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B E39E772C
180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9 DE2BCBF6 95581718
3995497C EA956AE5 15D22618 98FA0510 15728E5A 8AAAC42D AD33170D
04507A33 A85521AB DF1CBA64 ECFB8504 58DBEF0A 8AEA7157 5D060C7D
B3970F85 A6E1E4C7 ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226
1AD2EE6B F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31 43DB5BFC
E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7 88719A10 BDBA5B26
99C32718 6AF4E23C 1A946834 B6150BDA 2583E9CA 2AD44CE8 DBBBC2DB
04DE8EF9 2E8EFC14 1FBECAA6 287C5947 4E6BC05D 99B2964F A090C3A2
233BA186 515BE7ED 1F612970 CEE2D7AF B81BDD76 2170481C D0069127
D5B05AA9 93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34028492
36C3FAB4 D27C7026 C1D4DCB2 602646DE C9751E76 3DBA37BD F8FF9406
AD9E530E E5DB382F 413001AE B06A53ED 9027D831 179727B0 865A8918
DA3EDBEB CF9B14ED 44CE6CBA CED4BB1B DB7F1447 E6CC254B 33205151
2BD7AF42 6FB8F401 378CD2BF 5983CA01 C64B92EC F032EA15 D1721D03
F482D7CE 6E74FEF6 D55E702F 46980C82 B5A84031 900B1C9E 59E7C97F
BEC7E8F3 23A97A7E 36CC88BE 0F1D45B7 FF585AC5 4BD407B2 2B4154AA
CC8F6D7E BF48E1D8 14CC5ED2 0F8037E0 A79715EE F29BE328 06A1D58B
B7C5DA76 F550AA3D 8A1FBFF0 EB19CCB1 A313D55C DA56C9EC 2EF29632
387FE8D7 6E3C0468 043E8F66 3F4860EE 12BF2D5B 0B7474D6 E694F91E
6DCC4024 FFFFFFFF FFFFFFFF"""
]

# G18
# 2^8192 - 2^8128 - 1 + 2^64 * { [2^8062 pi] + 4743158 }
primes_txt += [
    """FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
15728E5A 8AAAC42D AD33170D 04507A33 A85521AB DF1CBA64
ECFB8504 58DBEF0A 8AEA7157 5D060C7D B3970F85 A6E1E4C7
ABF5AE8C DB0933D7 1E8C94E0 4A25619D CEE3D226 1AD2EE6B
F12FFA06 D98A0864 D8760273 3EC86A64 521F2B18 177B200C
BBE11757 7A615D6C 770988C0 BAD946E2 08E24FA0 74E5AB31
43DB5BFC E0FD108E 4B82D120 A9210801 1A723C12 A787E6D7
88719A10 BDBA5B26 99C32718 6AF4E23C 1A946834 B6150BDA
2583E9CA 2AD44CE8 DBBBC2DB 04DE8EF9 2E8EFC14 1FBECAA6
287C5947 4E6BC05D 99B2964F A090C3A2 233BA186 515BE7ED
1F612970 CEE2D7AF B81BDD76 2170481C D0069127 D5B05AA9
93B4EA98 8D8FDDC1 86FFB7DC 90A6C08F 4DF435C9 34028492
36C3FAB4 D27C7026 C1D4DCB2 602646DE C9751E76 3DBA37BD
F8FF9406 AD9E530E E5DB382F 413001AE B06A53ED 9027D831
179727B0 865A8918 DA3EDBEB CF9B14ED 44CE6CBA CED4BB1B
DB7F1447 E6CC254B 33205151 2BD7AF42 6FB8F401 378CD2BF
5983CA01 C64B92EC F032EA15 D1721D03 F482D7CE 6E74FEF6
D55E702F 46980C82 B5A84031 900B1C9E 59E7C97F BEC7E8F3
23A97A7E 36CC88BE 0F1D45B7 FF585AC5 4BD407B2 2B4154AA
CC8F6D7E BF48E1D8 14CC5ED2 0F8037E0 A79715EE F29BE328
06A1D58B B7C5DA76 F550AA3D 8A1FBFF0 EB19CCB1 A313D55C
DA56C9EC 2EF29632 387FE8D7 6E3C0468 043E8F66 3F4860EE
12BF2D5B 0B7474D6 E694F91E 6DBE1159 74A3926F 12FEE5E4
38777CB6 A932DF8C D8BEC4D0 73B931BA 3BC832B6 8D9DD300
741FA7BF 8AFC47ED 2576F693 6BA42466 3AAB639C 5AE4F568
3423B474 2BF1C978 238F16CB E39D652D E3FDB8BE FC848AD9
22222E04 A4037C07 13EB57A8 1A23F0C7 3473FC64 6CEA306B
4BCBC886 2F8385DD FA9D4B7F A2C087E8 79683303 ED5BDD3A
062B3CF5 B3A278A6 6D2A13F8 3F44F82D DF310EE0 74AB6A36
4597E899 A0255DC1 64F31CC5 0846851D F9AB4819 5DED7EA1
B1D510BD 7EE74D73 FAF36BC3 1ECFA268 359046F4 EB879F92
4009438B 481C6CD7 889A002E D5EE382B C9190DA6 FC026E47
9558E447 5677E9AA 9E3050E2 765694DF C81F56E8 80B96E71
60C980DD 98EDD3DF FFFFFFFF FFFFFFFF"""
]

# safecurves.cr.yp.to
# Anomalous
primes_int += [0xB0000000000000000000000953000000000000000000001F9D7]

# M-221 2^221 - 3
primes_int += [0x1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD]

# E-222 2^222 - 117
primes_int += [0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8B]

# NIST P-224 2^224 - 2^96 + 1
primes_int += [0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001]

# Curve1174  2^251 - 9
primes_int += [0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7]

# Curve25519 2^255 - 19
primes_int += [0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED]

# BN(2,254)
primes_int += [0x2523648240000001BA344D80000000086121000000000013A700000000000013]

# brainpoolP256t1
primes_int += [0xA9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377]

# ANSSI FRP256v1
primes_int += [0xF1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C03]

# NIST P-256  2^256 - 2^224 + 2^192 + 2^96 - 1
primes_int += [0xFFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF]

# secp256k1  2^256 - 2^32 - 977
primes_int += [0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F]

# E-382  2^382 - 105
primes_int += [
    0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF97
]

# M-383 2^383 - 187
primes_int += [
    0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF45
]

# Curve383187 2^383 - 187
primes_int += [
    0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF45
]

# brainpoolP384t1
primes_int += [
    0x8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B412B1DA197FB71123ACD3A729901D1A71874700133107EC53
]

# NIST P-384 2^384 - 2^128 - 2^96 + 2^32 - 1
primes_int += [
    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF
]

# Curve41417  2^414 - 17
primes_int += [
    0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF
]

# Ed448-Goldilocks
primes_int += [
    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
]

# M-511 2^511 - 187
primes_int += [
    0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF45
]

# E-521 2^521 - 1
primes_int += [
    0x1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
]

# basepoints

# Anomalous
primes_int += [0x101EFB35FD1963C4871A2D17EDAAFA7E249807F58F8705126C6]
primes_int += [0x22389A3954375834304BA1D509A97DE6C07148EA7F5951B20E7]

# M-221
# 0x4
primes_int += [0xF7ACDD2A4939571D1CEF14ECA37C228E61DBFF10707DC6C08C5056D]

# E-222
primes_int += [0x19B12BB156A389E55C9768C303316D07C23ADAB3736EB2BC3EB54E51]
# 0x1c

# NIST P-224
primes_int += [0xB70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21]
primes_int += [0xBD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34]

# Curve1174
primes_int += [0x37FBB0CEA308C479343AEE7C029A190C021D96A492ECD6516123F27BCE29EDA]
primes_int += [0x6B72F82D47FB7CC6656841169840E0C4FE2DEE2AF3F976BA4CCB1BF9B46360E]

# Curve25519
# 0x9
primes_int += [0x20AE19A1B8A086B4E01EDD2C7748D14C923D4D7E6D7C61B229E9C5A27ECED3D9]

# brainpoolP256t1
primes_int += [0xA3E8EB3CC1CFE7B7732213B23A656149AFA142C47AAFBC2B79A191562E1305F4]
primes_int += [0x2D996C823439C56D7F7B22E14644417E69BCB6DE39D027001DABE8F35B25C9BE]

# ANSSI FRP256v1
primes_int += [0xB6B3D4C356C139EB31183D4749D423958C27D2DCAF98B70164C97A2DD98F5CFF]
primes_int += [0x6142E0F7C8B204911F9271F0F3ECEF8C2701C307E8E4C9E183115A1554062CFB]

# NIST P-256
primes_int += [0x6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296]
primes_int += [0x4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5]

# secp256k1
primes_int += [0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798]
primes_int += [0x483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8]

# E-382
primes_int += [
    0x196F8DD0EAB20391E5F05BE96E8D20AE68F840032B0B64352923BAB85364841193517DBCE8105398EBC0CC9470F79603
]
# 0x11

# M-383
# 0xc
primes_int += [
    0x1EC7ED04AAF834AF310E304B2DA0F328E7C165F0E8988ABD3992861290F617AA1F1B2E7D0B6E332E969991B62555E77E
]

# Curve383187
# 0x5
primes_int += [
    0x1EEBE07DC1871896732B12D5504A32370471965C7A11F2C89865F855AB3CBD7C224E3620C31AF3370788457DD5CE46DF
]

# brainpoolP384t1
primes_int += [
    0x18DE98B02DB9A306F2AFCD7235F72A819B80AB12EBD653172476FECD462AABFFC4FF191B946A5F54D8D0AA2F418808CC
]
primes_int += [
    0x25AB056962D30651A114AFD2755AD336747F93475B7A1FCA3B88F2B6A208CCFE469408584DC2B2912675BF5B9E582928
]

# NIST P-384
primes_int += [
    0xAA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7
]
primes_int += [
    0x3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F
]

# Curve41417
primes_int += [
    0x1A334905141443300218C0631C326E5FCD46369F44C03EC7F57FF35498A4AB4D6D6BA111301A73FAA8537C64C4FD3812F3CBC595
]
# 0x22

# Ed448-Goldilocks
primes_int += [
    0x297EA0EA2692FF1B4FAFF46098453A6A26ADF733245F065C3C59D0709CECFA96147EAAF3932D94C63D96C170033F4BA0C7F0DE840AED939F
]
# 0x13

# M-511
# 0x5
primes_int += [
    0x2FBDC0AD8530803D28FDBAD354BB488D32399AC1CF8F6E01EE3F96389B90C809422B9429E8A43DBF49308AC4455940ABE9F1DBCA542093A895E30A64AF056FA5
]

# E-521
primes_int += [
    0x752CB45C48648B189DF90CB2296B2878A3BFD9F42FC6C818EC8BF3C9C0C6203913F6ECC5CCC72434B1AE949D568FC99C6059D0FB13364838AA302A940A2F19BA6C
]
# 0xc

# prime order
# Anomalous
primes_int += [0xB0000000000000000000000953000000000000000000001F9D7]

# M-221
primes_int += [0x40000000000000000000000000015A08ED730E8A2F77F005042605B]

# E-222
primes_int += [0xFFFFFFFFFFFFFFFFFFFFFFFFFFFF70CBC95E932F802F31423598CBF]

# NIST P-224
primes_int += [0xFFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D]

# Curve1174
primes_int += [0x1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF77965C4DFD307348944D45FD166C971]

# Curve25519
primes_int += [0x1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED]

# BN(2,254)
primes_int += [0x2523648240000001BA344D8000000007FF9F800000000010A10000000000000D]

# brainpoolP256t1
primes_int += [0xA9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7]

# ANSSI FRP256v1
primes_int += [0xF1FD178C0B3AD58F10126DE8CE42435B53DC67E140D2BF941FFDD459C6D655E1]

# NIST P-256
primes_int += [0xFFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551]

# secp256k1
primes_int += [0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141]

# E-382
primes_int += [
    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD5FB21F21E95EEE17C5E69281B102D2773E27E13FD3C9719
]

# M-383
primes_int += [
    0x10000000000000000000000000000000000000000000000006C79673AC36BA6E7A32576F7B1B249E46BBC225BE9071D7
]

# Curve383187
primes_int += [
    0x1000000000000000000000000000000000000000000000000E85A85287A1488ACD41AE84B2B7030446F72088B00A0E21
]

# brainpoolP384t1
primes_int += [
    0x8CB91E82A3386D280F5D6F7E50E641DF152F7109ED5456B31F166E6CAC0425A7CF3AB6AF6B7FC3103B883202E9046565
]

# NIST P-384
primes_int += [
    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973
]

# Curve41417
primes_int += [
    0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEB3CC92414CF706022B36F1C0338AD63CF181B0E71A5E106AF79
]

# Ed448-Goldilocks
primes_int += [
    0x3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7CCA23E9C44EDB49AED63690216CC2728DC58F552378C292AB5844F3
]

# M-511
primes_int += [
    0x100000000000000000000000000000000000000000000000000000000000000017B5FEFF30C7F5677AB2AEEBD13779A2AC125042A6AA10BFA54C15BAB76BAF1B
]

# E-521
primes_int += [
    0x7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD15B6C64746FC85F736B8AF5E7EC53F04FBD8C4569A8F1F4540EA2435F5180D6B
]

# Prime proofs

# Anomalous

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 41 43 47 59 79 89 97 103 113 127 139 151 163 179 191 211 227 229 283 337 373 389 557 631 653 691 769 1699 2089 2351 4093 5449 5849 6113 6871 7691 7901 8803 10111 11699 12227 13883 14107 15383 15803 124769 171179 250681 393203 530597 2013751 2707339 3415219 8199883 9265609 22911527 37062437 222374623 484778929 26510263489 34547787487 84178317913 323116924469 3938699322577 45456291673021 2376645121788851 2468656374749233 3560584187609609 161998547485626779 638388514873056719 4221402400821188431 1671675350725190618677 142215960774543971001476431146737 17676318486848893030961583018778670610489016512983351739677143"""
]

# M-221

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 71 73 79 89 101 131 137 139 149 151 163 173 179 181 191 193 233 239 263 331 347 349 359 409 419 433 439 443 449 479 523 569 659 661 709 743 769 787 839 947 1097 1103 1193 1487 1579 1733 1861 1933 2207 2837 2953 3793 3943 5231 5683 8329 8779 10399 10771 11497 12517 13241 13367 15173 17657 19301 38603 41597 45989 100517 105943 119611 129097 323131 497801 603103 774583 1003679 1569301 1931539 2298041 3460921 4206583 4951357 7817573 9435271 16826333 19851313 102244957 105465631 250162337 501783409 1075060097 1325514287 3398045597 5829032467 7240555601 31937378989 76031689039 391669282183 565665984379 2585077427327 6487537818497 9361973132609 50380057830419 705320809625867 12695774573265607 671165898617413417 41347742847751193213 168650669431260323389 4815314615204347717321 504842927415879955942747 293832518631314000633668609 255061103803346185973548526989 3803739800316731423245653299251 893113324603023226118586479389229 421249166674228746791672110734682167926895081980396304944335052891 842498333348457493583344221469362581248531362447993170180305534793 3369993333393829974333376885877453834204643052817571560137951281149"""
]

# E-222

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 79 89 97 103 127 131 137 157 163 173 181 193 211 229 233 263 281 337 347 389 409 431 521 541 613 617 659 773 811 863 929 937 1061 1571 1637 1747 2011 2083 2531 3001 3259 3319 4003 4177 5741 6131 6367 8111 11369 11483 12569 13037 19813 20249 22739 24019 24709 27481 42433 44959 63863 71741 104123 127727 133087 152809 181913 230393 336113 449591 464909 899183 1798367 3224909 4975457 5080793 6500537 17171153 26889041 33923599 59598109 125059657 135694397 190234753 200606689 750357943 760939013 4565634079 5336643803 17097494023 41734133317 62707855739 158769362377 380103483577 669274658641 7180178067871 7544066725621 19197701325821 28723789958641 67954897631837 1541424468855533 5576396455796813 16444797113475329 22153296627978863 2408429160161291633 1010536301839123457339 250381879990652588256601 1191729595807457796514621337 9533836766459662372116970697 14803246073281859780125586623 416717644037123426460673842301 12403365937452778821493785232092281 228728139988123081237499256083957678977837 123513195593586463868249598285337146648031981 3167286967475404111215579779960013343298694729431415913444417037 842498333348457493583344221469363549317452798028756632976214931843 1684996666696914987166688442938726735569737456760058294185521417407 1684996666696914987166688442938727098634905596057513265952429863687 6739986666787659948666753771754907668409286105635143120275902562187"""
]

# NIST P-224

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 79 89 101 127 131 139 173 179 181 197 233 239 257 263 269 347 349 359 373 463 467 509 631 641 659 727 859 1303 1319 1481 1999 2089 2153 2333 2551 2707 3001 3433 3761 7523 9049 10909 16657 17449 17957 20599 30011 30859 40927 42953 65537 85999 87739 145091 166571 166823 200639 221251 274177 823789 1163251 1206941 2413883 2998279 3015283 3878713 6700417 9466553 11105363 13928737 15930073 20187911 40375823 68232721 97911833 821796863 11549194661 16018527589 49081234303 325470079171 490812343031 67280421310721 267983539294927 432621809776543 3644673204770657 468848762208042289 136401162692544977256234449 203790284848123205080543111 34646440928557194402992574983797 177594041488131583478651368420021457 375503554633724504423937478103159147573209 388425074903852603481408727235725774844022299 50520606258875818707470860153287666700917696099933389351507 26959946667150639794667015087019625940457807714424391721682722368061 26959946667150639794667015087019630673557916260026308143510066298881"""
]

# Curve1174

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 71 73 83 89 97 101 113 131 137 149 163 191 193 227 251 263 271 293 307 401 419 431 449 463 521 523 577 601 607 743 1063 1163 1213 1229 1361 1373 1471 1487 1951 2459 2833 3121 3181 3571 4919 4967 5077 5113 5171 6277 7151 8209 8713 9461 9839 10141 10303 10889 10957 11783 15467 21143 33997 37663 42853 45677 56767 78713 115751 157427 231503 394049 400457 438281 453181 514313 545087 1135613 1947073 2833687 3203657 4531811 5662229 6153491 6254681 7071763 7889059 9063623 14072969 18127247 28145939 28287053 52357003 83295083 108763483 196911713 522528103 1109324011 2665442657 9816177919 39264711677 53308853141 176039071423 1364367483307 2032236244151 2053232229649 4310859807493 12320708804681 20387630040577 26312496861293 43305611570059 1632500449985791 7287687546097909 60171084739669153 95338435633553477 107338874501590423 152435752726607681 762707485068427817 359799907329331097897 447368281760320663747 1997278224258685136359 4473682817603206637471 297581916939273464475253 2151858718037429125511251 12110864880705284755213021 147147008300569209775838205151 161567415114024992333870349255799 19920925890426226515689032734344471 22645347980446549950250344634517843 7709728928696487373337941203521096567469726390276358190857709 30510656070643106182115999270826633842178510774222732476374386585332681 904625697166532776746648320380374280092339035279495474023489261773642975601 904625697166532776746648320380374280115004475121138339093035488349999675019 3618502788666131106986593281521497120414687020801267626233049500247285301239"""
]

# Curve25519

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 73 79 83 97 101 103 107 109 113 127 131 139 151 163 173 181 191 223 227 233 239 251 269 307 353 383 419 457 467 479 487 503 727 991 1361 1723 2281 2437 2551 2791 2851 2939 3637 3727 3797 3911 4153 4363 5879 6211 6263 7229 8053 9463 11351 12527 14851 15101 16451 17231 17659 22111 28859 30203 30703 32573 34123 34217 37853 41081 57467 65147 75707 82163 84457 117223 132049 132667 137849 173497 196993 208393 372661 409477 430751 531581 569003 693989 727169 1224481 1923133 5859383 6418733 8574133 14741173 58964693 122232809 150381227 292386187 743104567 1019532643 1110318119 2220636239 2773320623 9374403413 13481018963 72106336199 213441916511 1013266244677 5171003929967 1257559732178653 1919519569386763 6514380687527359 31757755568855353 4434155615661930479 22561162540501040539 243585722668023007729 3044861653679985063343 8312956054562778877481 172054593956031949258510691 198211423230930754013084525763697 75445702479781427272750846543864801 19757330305831588566944191468367130476339 203852586375664218368381551393371968928013 276602624281642239937218680557139826668747 104719073621178708975837602950775180438320278101 83326725728999296701078628838522133333655224556987 27413359092552162435694767700453926735143482401279781 74058212732561358302231226437062788676166966415465897661863160754340907 7237005577332262213973186563042994240857116359379907606001950938285454250989 14474011154664524427946373126085988481603263447650325797860494125407373907997 57896044618658097711785492504343953926634992332820282019728792003956564819949"""
]

# BN(2,254)

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 53 59 61 67 73 79 89 97 101 103 107 113 131 157 163 173 179 181 191 197 199 227 229 269 281 313 349 359 383 397 401 419 541 607 631 641 827 883 929 937 1013 1069 1597 1621 1999 2383 3137 3329 3491 3583 4013 4657 5623 5779 6521 9533 9719 13043 16843 16903 17923 25969 29179 62383 71693 101977 103393 127139 140977 159793 249533 260441 499067 709927 752881 767617 1019771 1033337 1302347 1545857 1562647 2749283 3736981 11799461 15698303 46879411 54897371 65982793 281276467 1389386771 1687658803 3572919677 5994341377 8336320627 23580350111 128262069029 188642800889 983685833987 1176035613847 1740482054401 16446708426521 298908837206431 14334859726775219 22009001472962227 101148471075752777 6848045079628454069 352576608953991537322303 11711184643015782903697616449 49603261419390422248082736481 1254043595354617963043866617659 16798108731015832284940804142231733909759579603404752749028378864165570215949 16798108731015832284940804142231733909889187121439069848933715426072753864723"""
]

# brainpoolP256t1

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 83 89 101 107 127 139 151 157 163 173 179 191 197 199 223 233 239 257 271 277 281 283 293 307 311 383 431 443 461 467 499 509 521 607 659 661 811 829 863 887 919 929 1019 1109 1213 1259 1319 1433 1543 1571 1609 1667 1783 1867 2069 2221 2549 2711 2719 2851 3187 4019 4139 6521 7649 8039 9311 9341 11987 12281 13043 13309 13327 21107 22709 24821 25951 27617 32309 32533 50123 50993 55799 74729 76471 80803 148927 149459 165703 175939 245621 252949 453119 858397 921589 943693 2295569 3016241 3686357 3774773 5621767 9105937 10019573 10434257 11616307 17543087 21384809 25659209 36423749 41802583 45297277 68632771 70825721 84032791 164918227 187816627 492167257 757986407 3100695749 4577554061 7224223543 8062915307 66891682553 151499460061 465104362351 719569513687 2590895598527 4233394996199 7675751843099 1674656872585139 57660685428664091 1752279189407036011 5924666185313169299 1139592334882447158893 190455129210693390224369129 401601867518226318515439169 298407043007230668716584089637 49712609355733181957277501974736893 114430077720284863765762092766225391679591020381 5991180651865208777371442029237375648904065304322611579 3059213862715144055733503214373292934438943635608167530247 4271386466502519123378319257166758282929862876911918307708639947947974242171 76884956397045344220809746629001649092737531784414529538755519063063536359079 76884956397045344220809746629001649093037950200943055203735601445031516197751"""
]

# ANSSI FRP256v1

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 29 31 37 41 43 53 59 61 67 71 73 79 83 89 97 101 103 107 109 127 131 149 151 173 181 191 199 241 251 263 269 307 317 367 397 439 491 503 509 541 569 641 701 757 787 853 877 1019 1031 1049 1063 1087 1117 1301 1607 1877 1993 2039 2099 2293 2543 2591 2857 3329 3529 4079 6113 6229 6659 8663 10273 12227 17183 29387 33797 34367 34871 41413 42307 58481 63589 67763 82913 121283 165437 172307 175463 327923 495959 734273 983809 1033843 1468547 4048673 5315399 7959649 8097347 8773151 10882031 14878771 27748561 47907599 61292713 108261709 162128261 213095137 243259963 275168401 280740833 324256523 653370847 1285908257 1293654617 2575831439 3986498609 6495702541 11760675247 21258969373 135382853293 649570254101 1624594239517 4244885885521 49290007066067 79806171026243 1390586390785817 1937551337942089 3617872258517821 9347238719917243 194995755782084489 1424961889141606181 548794774797769816735663 3972738854007370570932605213 10462814633518742617783767031 20850849555552798305550425353 1720805198043061735464389957585107660393 1758043857162342261873808298370022542631 837116414630376960702915782614178937699338555837 112356767778179104648003230782815205059434761578340093581 160847769765829662053086933326768494988741892623088564991 54727285665848639308835362515367564072984674823934369078600661778098011196929 109454571331697278617670725030735128145969349647868738157201323556196022393859 109454571331697278617670725030735128146004546811402412653072203207726079563233"""
]

# NIST P-256

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 61 67 71 73 89 97 101 107 127 131 139 151 157 163 173 179 181 197 199 229 241 257 263 269 293 311 313 337 347 353 373 389 577 587 641 643 647 653 659 661 673 727 757 797 857 919 1087 1201 1213 1297 1511 1531 1669 1861 2411 2729 3023 3079 3407 3571 3677 3769 3911 3919 4349 6247 9547 11311 16879 17449 18169 18911 26687 38189 42853 56783 65537 67219 67867 78283 104471 126241 131909 151289 155317 215531 250259 302579 393761 407203 490463 704251 761069 1387801 2420633 3969899 6700417 9350987 13610371 50711861 187019741 191039911 203333173 204061199 311245691 333814693 622491383 34282281433 66417393611 110244005101 456597257999 1002328039319 3848175851593 11290956913871 1386428608150177 5195037399650551 46076956964474543 124778574733515931 208150935158385979 718995365596683143 13374631042347059581 1869236796843064056413 1428624589419343516204097 2624747550333869278416773953 46523541035814968339936406074986559003387 774023187263532362759620327192479577272145303 835945042244614951780389953367877943453916927241 112600039977335252189018616651067202354555503111433 3317349640749355357762425066592395746459685764401801118712075735758936647 115792089210356248762697446949407573529996955224135760342422259061068512044369 115792089210356248762697446949407573530086143415290314195533631308867097853951"""
]

# secp256k1

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 53 59 67 71 73 79 83 89 97 101 103 109 113 131 149 163 179 199 239 241 271 293 311 313 349 409 419 443 461 631 683 797 887 971 1213 1373 1409 1427 1447 1627 1871 1879 2011 2621 2657 2731 2767 2861 2969 3319 3499 4051 4423 4909 5323 7723 9349 9781 13441 16699 20113 22549 22639 24809 28181 41201 85831 92083 96557 120233 152077 152083 166021 168631 177481 305873 1206781 1627771 2698097 4681609 7240687 13331831 25465723 44706919 107590001 545358713 2346158371 44774420161 297159362677 453934566793 4539345667931 23538849507889 25910585072550149 26886215762884663 107361793816595537 173378833005251801 174723607534414371449 22149492674086928081353 132896956044521568488119 1359580455984873519493666411 29047611873442575647497758179 132401351950596217829363773663 341948486974166000522343609283189 29235542524211150858901814862527031 255515944373312847190720520512484175977 1489008455352563922568011402972792902916827 1013176677300131846900870239606035638738100997248092069256697437031 205115282021455665897114700593932402728804164701536103180137503955397371 115792089237316195423570985008687907852837564279074904382605163141518161494337 115792089237316195423570985008687907853269984665640564039457584007908834671663"""
]

# E-382

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 73 79 83 89 97 101 103 107 109 113 131 137 139 157 163 167 173 179 191 193 211 229 233 241 269 277 281 283 293 307 313 347 367 409 461 563 599 631 643 673 691 761 881 929 1033 1069 1117 1361 1399 1709 2083 2293 2551 2767 2833 2843 2851 3373 3797 3931 4513 6679 6917 7433 7717 7829 8761 8999 10037 10301 11171 13759 14593 14717 14867 28771 29581 34381 37997 45131 45827 46723 48109 62633 67153 71429 71993 74449 75941 80897 87559 90263 105769 108881 118361 122299 124781 134921 151883 161839 207941 220663 256901 303767 375799 412771 442963 641579 670261 1283159 1512421 1736389 1746439 1749899 1814921 3258667 3499799 3670871 3824551 6945557 9080963 39295853 43153393 44573927 58480511 78591707 116961023 117411509 119194609 216558437 485175917 802330687 1300347341 1325740037 1458566971 1635296843 3270593687 4537129159 9610823281 72983678353 718558435081 878766598991 1249292843947 1557805355357 1757533197983 2619408491927 2949535533569 3462603391451 13823233105879 29862490908791 41293497469967 59724981817583 604703486621959 2089326636302777 2458171673961827 6510290076444307 18141104598658771 42110248155485387 60477271182120907 201439234573737379 387610748845807843 390024685630946447 3625906222327272823 29799794382272025079 221709676153655245063 300984643119527704331 1903129742795028023201 39504432196131312905021 79008864392262625810043 143868846306805039381043 486612738928707810813763 4110968708131511976589681529 533643001175551503349201469257 575535619138411676722555414061 3201858007053309020095208815543 17942476279071857634847638457723 738482592425650221847703733566702107 1176529195798022443468570606581645973 82357043705861571042799942460715218111 10266294221277769350489312192694310037089 209868713262055181656334059536197675522401 1890206079784759632867687927237221931415993 872357267323181399605475340121915583445030403 2276049073744046610293758829276943409701657013 3349165422878785925015878589251126153623290029037 38116200399806648171588966205760165042098583043261 127341149315694473480617920915957430442427972486810722042617 206313008356732063557587210852462234703789278064725964307040844617657 2462625387274654950767440006258975862817483704404090416745738034557663054564649171262659326683244604346084081047321 2462625387274654950767440006258975862817483704404090416747798640973052166872502155164123955177369850754744417740979 9850501549098619803069760025035903451269934817616361666987073351061430442874302652853566563721228910201656997576599"""
]

# M-383

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 101 103 107 109 113 127 131 137 151 173 179 181 191 193 197 227 229 241 251 281 311 317 331 353 401 419 431 461 491 503 571 619 661 673 739 743 839 883 907 929 983 1009 1021 1049 1091 1151 1373 1471 1531 1583 1601 1613 1657 1787 2141 2213 2237 2269 2549 2693 2861 3049 3089 3251 3259 3359 3449 4283 5443 5651 5659 6091 6563 6719 8191 9041 9187 9473 10211 11909 13463 14561 15661 18947 19319 20719 23819 27457 29123 31327 32371 33119 34487 37591 38713 69697 73043 78779 80629 81371 85831 109829 124471 153259 191519 193619 241453 256117 288773 343559 360863 361223 397429 407723 497993 577547 995987 1376827 1418023 3110999 3678217 5271793 5283269 5507309 5975923 7293089 7899817 13830319 14875631 22017043 27582403 28336003 35677501 40043063 73965767 113344013 251969987 899437463 923685781 998970029 2305472951 3788735183 5396885861 14924570207 15625838027 27157467587 62417726963 134384519429 280518779831 359300521211 575131529129 820326650873 1640653301747 9003095098793 19953467139239 24004372753289 25789488511363 47166934095163 78751358483857 115446396125903 309473862136357 2024595601273937 18702316172396287 119802223514406673 156765911253115553 324328607518902137 479208894057626693 715138273065985889 1595381333803862357 1631235845567066729 3678475954780960471 4740111526236655123 8874921343853306041 25946288601512170961 567955754834174999093 3981375605939564164049 7724799505040016989101 46176580450530517456831 289450259140102639080071069 2582420664331010792443772203 21561596637519154364530566979 138897064261279495097010689063 60934327561511008916380516463943361 68766914224904862224418909762329269 2493961260309239103759479389479268332988451545120507 140731847223860698993672433903061203299016858671554230293 4049025163741250788002858853398592895237291813181010865909 132514945648719450732625795951913634887948272656733637982269 34275585315876169535825731013955432020686980960977076060073381689104960386232837 6033870777901550694409388750181488091053823905087249736002431750549727835387319723 16475237022945471409272211849733819466846279153222801284256298041819798160529572178177777 23978163906116309806674273528410869974800147232588444606571758029980837570993229680578504611504832152780419 2462625387274654950767440006258975862817483704404090416746934574041288984234680883008327183083615266784870011007447 4925250774549309901534880012517951725634967408808180833493204202978852474404940886836912197553998376631916975561717 19701003098197239606139520050071806902539869635232723333974146702122860885748605305707133127442457820403313995153221"""
]

# Curve383187

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 73 79 83 89 97 101 103 107 113 131 137 139 149 151 167 173 179 191 197 227 241 251 263 281 283 317 347 373 397 419 431 461 491 499 503 601 619 631 683 743 769 809 811 821 839 919 929 937 983 1021 1049 1103 1123 1423 1447 1471 1499 1583 1613 1657 1699 1723 1993 2237 2371 2477 2549 2861 2999 3019 4451 5659 6011 7759 9733 10211 10501 12611 14561 14753 15661 18539 19211 19273 19319 20521 20707 21347 27457 28687 29123 38713 38933 43103 43319 69697 70627 71263 73043 77867 85831 109829 110273 113809 114749 116359 123127 149899 150041 163027 229499 354073 407723 497993 832327 853291 995987 5271793 5481473 5585233 5617163 5975923 13884229 14875631 16309109 20975237 22017043 31401709 40043063 78364019 99140441 165310801 198280883 278486521 377554267 681148913 855109789 880691887 923685781 991864807 3086977169 3788735183 4232756191 11602451687 14416805621 25396537147 62417726963 108654662777 134384519429 352173651449 354936430157 575131529129 869237302217 3415417404097 3529893208993 19953467139239 20492504424583 21325306200707 28591973599411 40024942543673 531909186161701 545892229581467 889917602181551 1157184950641651 1779835204363103 73868779472585473 156765911253115553 1631235845567066729 963926494829235139921 14753097342555346196473 621442270579440059553893689 21561596637519154364530566979 79879924901292653287162734017 59180993314580506221962671096753 8118493917152534667909188789691403 220355754737793598754693970385959669739 442454434174541737154207748628961512007 140731847223860698993672433903061203299016858671554230293 60591682859247895515955060045153912202093072202746374731848221245220210313 34275585315876169535825731013955432020686980960977076060073381689104960386232837 794313638957499499270577370679308530064362143769221875328034265471314993172778690817396407 18895059184283836713882776167547354480336145147521570807563207379026619142420663903487643611 1168118569486389440308203361557649499676771110259307362471795835525621803683357571467152044105461 2462625387274654950767440006258975862817483704404090416747124418612574880605944350369924877650606926799392131911201 4925250774549309901534880012517951725634967408808180833492824513836280681662413952113716808420015056602872733754209 19701003098197239606139520050071806902539869635232723333974146702122860885748605305707133127442457820403313995153221"""
]

# brainpoolP384t1

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 101 103 107 109 113 131 167 173 179 181 193 227 229 233 241 251 283 293 307 313 337 347 349 421 431 461 463 467 503 571 577 593 601 617 757 773 787 857 911 1049 1093 1229 1303 1423 1583 1693 1709 1777 1801 1811 1877 2017 2083 2281 2377 2459 2543 2593 2843 2887 3037 3469 3607 3623 4273 4481 4603 4759 4919 5413 5557 5743 6271 6803 6857 6997 7753 7759 8963 9341 9437 9473 9839 10061 10453 11131 11393 12721 18413 18947 19553 20707 28817 31627 33893 37409 37967 43397 60901 78713 95959 97151 119087 157427 285457 288467 598729 734647 748169 868583 991057 1559777 1560953 1866961 2084989 2520431 4977439 5071793 9535423 11201767 11543603 11594917 22842497 29822497 49645261 56117111 65390933 123606883 124822877 294639853 599219167 657021949 915473063 1454493979 1898722439 2663886769 8995256861 13843970897 25605588031 27678676889 59016512273 379795560371 1241450905117 27093605140967 49393939847159 53014379452169 288135026414491 8067780739605749 8076987940436711 11716083324473119 17561909847027569 726928914639303991 3012146720727260651 7057776167979264311 141700345513649190797 168233516889622588559 186766509188519991823 816170061203776523993317 12811352796235023217778801482819 15867926547803050208571480396443 9511259360250244436150360929400467 125972502705620325124785968921221517 37573380636081815018124278995574282493401057 2788900573532341797131599550190476443808598899 669909697361913545660898382546007419518544524592370543 4303872990401223419424669070518309027547364146662699977 90050068090664042551646936303486902724615855323314057604193773 151574876586344350951092838162750565943171857126657289419000711361563821 13857381403312519376221497559214358876512960238914501360589056738895920081 21659270770119316173069236842332604979796116387017648600075645274821611501358515537962695117368903252229601718723941 21659270770119316173069236842332604979796116387017648600081618503821089934025961822236561982844534088440708417973331"""
]

# NIST P-384

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 103 107 109 113 131 139 149 151 157 163 173 179 181 199 211 233 251 263 269 271 293 311 313 331 347 359 379 401 421 431 491 499 541 569 599 653 659 661 683 719 739 881 883 937 1033 1049 1087 1117 1129 1181 1237 1373 1553 1579 1879 2161 2213 2633 2777 3253 3517 3739 4297 4349 4451 5113 5233 5479 6317 6551 6761 7541 8389 8699 8839 9613 11243 13721 15083 16979 20693 21407 22679 33871 34429 37447 38557 60509 64901 142183 145709 145967 248431 250361 297191 312289 330563 336757 363557 455737 466717 490949 500723 568151 875803 1001447 1114261 1146787 1276987 1354841 1866869 2323423 4156739 4662689 6051631 8463023 9863677 10023031 11782777 17299349 74050321 85253989 105957871 154950581 176580149 246608641 272109983 290064143 362301523 513928823 532247449 532731547 1618781663 2862218959 3134327699 9538204373 12545359681 37081831291 53448597593 108598647457 228572385721 807145746439 936911738479 1436833069313 16864411292623 23314383343543 37344768852931 44925942675193 93575169138071 214692087848261 55942463741690639 76152123566553479 923162760505931681 1357291859799823621 1841796684943080163 52060951900024830751 426632512014427833817 463692400718849804323 529709925838459440593 35581458644053887931343 120699720968197491947347 1124679999981664229965379347 1495199339761412565498084319 5962933401120092733206902139 17942392077136950785977011829 23964610537191310276190549303 295429921339288635355502201959 862725979338887169942859774909 20705423504133292078628634597817 413244619895455989650825325680172591660047 12397338596863679689524759770405177749801411 1059392654943455286185473617842338478315215895509773412096307 11165728476386063307853657259304797238595952598104253398091264650988917 30461532566489734432033897907025322605647670983785646081730729521647935009277217 3055465788140352002733946906144561090641249606160407884365391979704929268480326390471 473067492335442271493300927295906676954200039911784049787606885062385680884289589892557 19173790298027098165721053155794528970226934547887232785722672956982046098136719667167519737147526097 39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643 39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319 39402006196394479212279040100143613805079739270465446667949681528863784143880477088695575868365581090168780292281997"""
]

# Curve41417

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 101 103 107 113 127 131 139 149 157 173 179 191 193 197 199 211 239 251 257 271 277 281 307 311 331 347 359 373 383 431 439 457 461 463 491 503 547 563 571 601 607 619 641 659 661 709 719 757 773 787 829 863 877 911 937 971 997 1013 1021 1033 1201 1279 1283 1439 1663 1693 2221 2287 2671 2837 2887 3187 3299 3331 3607 3643 4133 4327 4657 4723 5623 6053 6079 6299 6599 7207 7507 8009 8741 10601 12791 13009 13903 15137 16693 17389 17519 17579 18127 22871 24317 25583 26711 27109 29611 35537 38861 40927 46271 68477 68521 71471 87433 110947 114467 135193 208147 326257 407969 411679 550457 720869 833843 962161 1751993 2270249 2277413 2291581 2384153 2412961 3346351 13943143 19467793 21464983 28800823 44546539 83287801 213625567 384355469 457345879 499433731 854502269 900886289 904340159 1261073269 1942692491 4994337311 11534742073 16066359187 18473014193 30406113761 45265241663 115347420731 560513308871 3630997176263 4593488800753 12457521438949 13904599344773 19505309445451 39286345187279 629314117180951 858239144413883 1490039853025247 3041458943669203 3067692486481841 12165835774676813 21138543849953333 72092088130766173 131342845410725759 2928325597569402103 214824846426985860661 597386494759892631967 6015095699955604098509 2249645791783395932842367 24286359868392659038129333 351209660225850764954644159 9632869229268961407429404857 4868010057124911294296551654477037 419614160145355971032988144925355006655173 582976264895657809930367649386427562549872079 592299861982871449195634528262215319398393153 933937079203349671409932360755404077558846659923 3376384040438327312767543585515740988479041826522993 26662209338045324627822402579758961857427012457827101 254723693668765069288156859027433499782242697184918145687475956144269 112704357986686512751543694400357156875971984515762587440143302448053844671 2394768781123004469808382870696186422325158931040989687224220336205960556679 181015782627525661863876044430183339290714113279526328477904366773136146558252253 7005507114193524029414407471112866694107408372181827430432047949693881095742546770048184168812214569007093 104033754239631823712255190956345641806807791724720405509948501077933969978245219141810136352471050222510526161 5288447750321988791615322464262168318627237463714249754277190328831105466135348245791335989419337099796002495788978276839289 5288447750321988791615322464262168318627237463714249754277190395559387193645633287411691377616107457765456896611395456028803 42307582002575910332922579714097346549017899709713998034217522897561970639123926132812109468141778230245837569601494931472367"""
]

# Ed448-Goldilocks

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 101 107 109 113 131 137 139 149 151 167 173 179 181 191 193 197 211 223 227 229 233 239 241 263 271 277 293 307 311 313 337 347 349 359 367 373 379 409 421 431 433 443 463 523 593 607 613 617 641 659 661 677 691 719 727 773 821 991 1033 1049 1087 1193 1361 1399 1433 1481 1549 1601 1609 1933 1979 2111 2239 2437 2531 2683 2963 3203 3217 3319 3449 3491 3823 3853 4051 4211 4523 6197 6577 7853 8089 8423 9151 9227 9749 10067 14221 15413 15823 16657 16703 17449 18287 22157 28859 34483 39863 41389 42223 47119 47497 51473 58309 64817 74551 84869 114691 116989 121271 122579 139537 142211 189989 196687 208469 217003 227393 275027 324689 365357 379979 411743 552833 688147 701527 766223 816763 894613 1195891 1399417 1466449 1609403 1738691 1948699 2261713 2916841 3009341 3486877 3578453 4847597 6700417 7156907 9801157 13909529 15643211 35796097 36753053 47840521 77912789 77946443 91309423 225731161 550480097 671065561 765448337 999964351 1255525949 1335912079 1468672999 1764234391 3402277943 8464734851 10748006189 27301809421 30257753761 32061889897 85984049513 91450740527 163810856527 186062272787 342682509629 9437362120201 25136521679249 66721073718023 95024118539459 97859369123353 760192948315673 12779357438669681 27818066278401359 34741861125639557 2746144996771313789 31002614113816567181 36131535570665139281 38818558648101949187 1469495262398780123809 167773885276849215533569 596242599987116128415063 2703522806075700613189177 3458867485158836715058751 4019927965686165521481374447 163131120638915058577002756917 929098197455246849020086750707 1671380110708512442103829423217 6730519843040614479184435237013 3591893631361984318311655378233263 37414057161322375957408148834323969 392279121964710096549298451519713063 1011824009757342167700258385900659940913 32037243671365622938525385539447601257252076559602597 134209075623850670257907127035661234387627594536271696043327 509834927133261305493315894436753153401122015851834224693667 547972593843380542316719287015009101629889568888367769396279985548530313239 1293908032763388459087425944272364834610609736614628384140627657852601712102489824169817319028562969141747131097192516171 15041195721331390431432300003722835710980772495410359246993109171551790145621545430995362486502026757058902037026115456034470354492777 181709681073901722637330951972001133588410340171829515070372549795146003961539585716195755291692375963310293709091662304773755859649779 181709681073901722637330951972001133588410340171829515070372549795160160121825800627002436557645897001734148521830156375752993149532941 726838724295606890549323807888004534353641360687318060281490199180612328166730772686396383698676545930088884461843637361053498018365439"""
]

# M-511

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 83 89 97 101 103 107 113 127 131 137 139 149 151 157 167 173 179 193 211 223 229 233 239 241 257 263 277 281 293 307 313 331 337 349 397 409 419 421 431 433 443 467 479 487 547 593 601 613 641 661 677 727 733 773 809 853 887 977 1039 1063 1171 1373 1433 1451 1559 1613 1733 1979 2237 2287 2423 2467 2531 2683 2903 2909 3391 3413 3559 3607 3853 3943 4447 4523 4957 5791 6473 6553 6827 7349 7537 7757 8263 9967 10273 10831 11447 12377 14633 14699 14741 15413 15773 16183 17321 17683 18553 19603 23311 28661 29311 43633 46589 60757 63521 80491 93179 118747 132313 135049 143291 160507 173297 241601 272333 289249 308713 315461 337973 408311 473471 858467 879331 961549 972113 988937 1024633 1234853 1269391 1288531 1553407 3055649 3734491 3935887 4098533 4348819 4899733 5266351 7144903 8049101 8877889 14309621 14720401 27213313 35511557 43936391 55516481 73827037 99436943 111032963 138463057 188353237 230039351 235251347 365300797 402021673 450180037 479216833 716223737 1130119423 1840314809 2796876191 3863568481 5089297693 5842037431 6720124867 8025333451 39850487891 212102557441 330659614771 347582969077 426050702417 818488084109 1584017372081 5515321256273 11198022081713 12672138976649 16064717743999 24390926906057 24808504515989 67188132490279 72371792138339 665290456380049 806257589883349 7447165497053341 211191412011185201 245035279530995029 912026155762311229 1137346319589436823 1435773091665945871 24453091069698428153 235404890147362182521 1131014973702835376677 1515787470876961262599 52934372406331568616067 2810390965640035542416767 6422114145216731079184721 82346938205356038105099017 1940901878027589158559608212721 3752823319668658282198008768437 7545728982901378757453953508051 1401331155935919372480037129584563 21691107791071112804746088983950791 217699597736956946353518728155221031177 451891442863291858329691135763436236651 2291998858935929043684562366356035548933 3378892281805798826440512057402586184339 27727598583240555671506730615016813004130177 1622625176181408838334573296386488078938215217 146621177686829237856559365192161554600556965873 21682369618568459986649847415957985919370700162617 5928943045730601679673230900230929495199307291013218575943 40042367836462537109954173483078259560889892167509224859669902483113168741 1046598874349470040812238544166825597307092300404591085307326405812564486341 40207916671986113857497328863224192623039803613950016309508083637168042126527904219 15493986128158476657348900881244458351785958199592331238146398726181728333640083540874179214877522733 471155737497642486266649722911997034941785580633861408520357030668404527002692877857903580176417856629449583072727858932500851 837987995621412318723376562387865382967460363787024586107722590232610251879607410804876779383055508762141059258497448934987052508775626162460930737942299 1675975991242824637446753124775730765934920727574049172215445180465220503759171922590715015775614839398225846029626614843464365685435390161686550775636333 6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503041861"""
]

# E-521

primes_txt_arry += [
    """2 3 5 7 11 13 17 19 23 29 31 37 41 43 47 53 59 61 67 71 73 79 83 89 97 101 103 107 109 113 131 137 139 149 151 157 173 179 193 197 199 211 223 227 257 263 269 277 311 313 317 331 347 359 367 373 397 433 443 487 491 521 613 643 647 683 709 719 757 773 797 811 853 941 977 1051 1069 1237 1277 1381 1433 1439 1499 1511 1579 1613 1663 1669 1987 2141 2383 2437 2731 2879 3023 3191 3319 3413 4691 4871 5107 6131 6977 7583 7949 8081 8191 8821 9463 9743 11447 11519 11783 14153 14723 15217 19699 20593 21101 21871 23039 23189 23371 23609 24223 25121 25339 26161 26399 28307 28597 28793 29569 30773 33191 37853 42641 48487 49481 51481 55579 61547 61681 65099 78607 78797 82373 88339 96893 118093 118277 224563 290923 329053 354751 359767 409891 732191 783553 858001 861659 918583 995329 2245631 2955889 2995763 3028241 3075203 3286873 4670377 5121119 5676017 5746001 6030103 7623851 8436937 8620289 9211861 11636921 14944121 23956433 24120413 24217663 26979779 27869213 28430359 28452187 34110701 43462789 46596523 245161069 298882421 308761441 323757349 380059961 959170211 2103438853 2400573761 2534364967 14501006381 23658857317 24098228377 27563049583 45467703727 49736333249 65427463921 68681292269 115263316429 139862065649 674750394557 990435552551 2270119023421 3037491448319 7287076501559 9032166434783 16657196583967 50619101710669 102330720522739 108140989558681 145295143558111 8343868346871877 9821045892686953 10485409823782909 139759026803824079 274641681901431937 361725589517273017 2247646472029713793 6193811023329968617 204451032782023823759 408902065564047647519 3456146551018122488287 1288020826060799995852297 6114313750387749125096789 7721623655416232036046857 24711835904422729412278627 173308343918874810521923841 183429412511632473752903671 3352477528785765665039059407454939 104548497879097345351185737255380572327823 2205934966343040556770938144460047174606142921998789 8249394953716746686534168930091322753698210789463513 13626337181548781961065021039528065521362245802247457 33155235381061135339413842529253257652930251589295381 265746009039031277760011717913961871187634162371777607783 51854008820489653721386166877183100314125013148827513519511 28938774045863136338797101017419358636139979142479826529885118867 3076403577923417822298560225319886961076812195845551214932221395885381 38916407753682983861283783766663832991809018999410768212336775108672551624633480899 252243041490141992091916747959634815169496193136845853336769661422832941962389811668187387649516185742186371754593 22678127291974494752999082758512529677847838471000074610295040629304883810213774415831891245381957284486015221359371338545320928049961 60650177408485084925772397359452343492676178496622593868981522480243230848859484494326083587960346220877691092522597549044871215899368832200959 1716199415032652428745475199770348304317358825035826352348615864796385795849413675475876651663657849636693659065234142604319282948702542317993421293670108523 1716199415032652428745475199770348304317358825035826352348615864796385795849414350585403168667069427851954496630506286414241711051155779588293592851887420053 6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151"""
]

# AES256
# SBOX

notprimes_txt += [
    """637c777bf26b6fc53001672bfed7ab76
ca82c97dfa5947f0add4a2af9ca472c0
b7fd9326363ff7cc34a5e5f171d83115
04c723c31896059a071280e2eb27b275
09832c1a1b6e5aa0523bd6b329e32f84
53d100ed20fcb15b6acbbe394a4c58cf
d0efaafb434d338545f9027f503c9fa8
51a3408f929d38f5bcb6da2110fff3d2
cd0c13ec5f974417c4a77e3d645d1973
60814fdc222a908846eeb814de5e0bdb
e0323a0a4906245cc2d3ac629195e479
e7c8376d8dd54ea96c56f4ea657aae08
ba78252e1ca6b4c6e8dd741f4bbd8b8a
703eb5664803f60e613557b986c11d9e
e1f8981169d98e949b1e87e9ce5528df
8ca1890dbfe6426841992d0fb054bb16"""
]

# RBOX
notprimes_txt += [
    """52096ad53036a538bf40a39e81f3d7fb
7ce339829b2fff87348e4344c4dee9cb
547b9432a6c2233dee4c950b42fac34e
082ea16628d924b2765ba2496d8bd125
72f8f66486689816d4a45ccc5d65b692
6c704850fdedb9da5e154657a78d9d84
90d8ab008cbcd30af7e45805b8b34506
d02c1e8fca3f0f02c1afbd0301138a6b
3a9111414f67dcea97f2cfcef0b4e673
96ac7422e7ad3585e2f937e81c75df6e
47f11a711d29c5896fb7620eaa18be1b
fc563e4bc6d279209adbc0fe78cd5af4
1fdda8338807c731b11210592780ec5f
60517fa919b54a0d2de57a9f93c99cef
a0e03b4dae2af5b0c8ebbb3c83539961
172b047eba77d626e169146355210c7d"""
]


def load_system_consts():
    addpm1 = lambda n: [n - 1, n, n + 1] if n > 2 else [n, n + 1]
    global primes_txt, notprimes_txt, primes_int, primes_txt_arry
    primes_tmp0 = primes_txt
    primes_tmp0 = map(lambda x: x.replace("\n", ""), primes_tmp0)
    primes_tmp0 = map(lambda x: x.replace(" ", ""), primes_tmp0)
    primes_tmp0 = map(lambda x: int(x, 16), primes_tmp0)
    primes_tmp0 = sorted(set(primes_tmp0))
    notprimes_tmp0 = notprimes_txt
    notprimes_tmp0 = map(lambda x: x.replace("\n", ""), notprimes_tmp0)
    notprimes_tmp0 = map(lambda x: x.replace(" ", ""), notprimes_tmp0)
    notprimes_tmp0 = map(lambda x: int(x, 16), notprimes_tmp0)
    notprimes_tmp0 = sorted(set(notprimes_tmp0))
    primes_int = sorted(set(primes_int))
    primes_tmp1 = " ".join(primes_txt_arry).split(" ")
    primes_tmp1 = map(lambda x: int(x), primes_tmp1)
    primes_tmp1 = sorted(set(primes_tmp1))
    ALL = sorted(set(primes_tmp0 + notprimes_tmp0 + primes_int + primes_tmp1))
    return sorted(set(sum(map(addpm1, ALL), [])))
