# APIs for Windows 32-bit gdi32 library.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'gdi32.main_entry':( 'int', None, 'stdcall', 'gdi32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.abortdoc':( 'int', None, 'stdcall', 'gdi32.AbortDoc', (('int', None),) ),
    'gdi32.abortpath':( 'int', None, 'stdcall', 'gdi32.AbortPath', (('int', None),) ),
    'gdi32.addfontmemresourceex':( 'int', None, 'stdcall', 'gdi32.AddFontMemResourceEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.addfontresourcea':( 'int', None, 'stdcall', 'gdi32.AddFontResourceA', (('int', None),) ),
    'gdi32.addfontresourceexa':( 'int', None, 'stdcall', 'gdi32.AddFontResourceExA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.addfontresourceexw':( 'int', None, 'stdcall', 'gdi32.AddFontResourceExW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.addfontresourcetracking':( 'int', None, 'stdcall', 'gdi32.AddFontResourceTracking', (('int', None), ('int', None)) ),
    'gdi32.addfontresourcew':( 'int', None, 'stdcall', 'gdi32.AddFontResourceW', (('void *', 'ptr'),) ),
    'gdi32.anglearc':( 'int', None, 'stdcall', 'gdi32.AngleArc', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.animatepalette':( 'int', None, 'stdcall', 'gdi32.AnimatePalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.anylinkedfonts':( 'int', None, 'cdecl', 'gdi32.AnyLinkedFonts', () ),
    'gdi32.arc':( 'int', None, 'stdcall', 'gdi32.Arc', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.arcto':( 'int', None, 'stdcall', 'gdi32.ArcTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.brushobj_hgetcolortransform':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_hGetColorTransform', (('int', None),) ),
    'gdi32.brushobj_pvallocrbrush':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_pvAllocRbrush', (('int', None), ('int', None)) ),
    'gdi32.brushobj_pvgetrbrush':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_pvGetRbrush', (('int', None),) ),
    'gdi32.brushobj_ulgetbrushcolor':( 'int', None, 'stdcall', 'gdi32.BRUSHOBJ_ulGetBrushColor', (('int', None),) ),
    'gdi32.beginpath':( 'int', None, 'stdcall', 'gdi32.BeginPath', (('int', None),) ),
    'gdi32.bitblt':( 'int', None, 'stdcall', 'gdi32.BitBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_benum':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_bEnum', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_cenumstart':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_cEnumStart', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clipobj_ppogetpath':( 'int', None, 'stdcall', 'gdi32.CLIPOBJ_ppoGetPath', (('int', None),) ),
    'gdi32.canceldc':( 'int', None, 'stdcall', 'gdi32.CancelDC', (('int', None),) ),
    'gdi32.checkcolorsingamut':( 'int', None, 'stdcall', 'gdi32.CheckColorsInGamut', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.choosepixelformat':( 'int', None, 'stdcall', 'gdi32.ChoosePixelFormat', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.chord':( 'int', None, 'stdcall', 'gdi32.Chord', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.clearbitmapattributes':( 'int', None, 'stdcall', 'gdi32.ClearBitmapAttributes', (('int', None), ('int', None)) ),
    'gdi32.clearbrushattributes':( 'int', None, 'stdcall', 'gdi32.ClearBrushAttributes', (('int', None), ('int', None)) ),
    'gdi32.closeenhmetafile':( 'int', None, 'stdcall', 'gdi32.CloseEnhMetaFile', (('int', None),) ),
    'gdi32.closefigure':( 'int', None, 'stdcall', 'gdi32.CloseFigure', (('int', None),) ),
    'gdi32.closemetafile':( 'int', None, 'stdcall', 'gdi32.CloseMetaFile', (('int', None),) ),
    'gdi32.colorcorrectpalette':( 'int', None, 'stdcall', 'gdi32.ColorCorrectPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.colormatchtotarget':( 'int', None, 'stdcall', 'gdi32.ColorMatchToTarget', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.combinergn':( 'int', None, 'stdcall', 'gdi32.CombineRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.combinetransform':( 'int', None, 'stdcall', 'gdi32.CombineTransform', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.copyenhmetafilea':( 'int', None, 'stdcall', 'gdi32.CopyEnhMetaFileA', (('int', None), ('int', None)) ),
    'gdi32.copyenhmetafilew':( 'int', None, 'stdcall', 'gdi32.CopyEnhMetaFileW', (('int', None), ('StringW', None)) ),
    'gdi32.copymetafilea':( 'int', None, 'stdcall', 'gdi32.CopyMetaFileA', (('int', None), ('int', None)) ),
    'gdi32.copymetafilew':( 'int', None, 'stdcall', 'gdi32.CopyMetaFileW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.createbitmap':( 'int', None, 'stdcall', 'gdi32.CreateBitmap', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createbitmapindirect':( 'int', None, 'stdcall', 'gdi32.CreateBitmapIndirect', (('void *', 'ptr'),) ),
    'gdi32.createbrushindirect':( 'int', None, 'stdcall', 'gdi32.CreateBrushIndirect', (('void *', 'ptr'),) ),
    'gdi32.createcolorspacea':( 'int', None, 'stdcall', 'gdi32.CreateColorSpaceA', (('int', None),) ),
    'gdi32.createcolorspacew':( 'int', None, 'stdcall', 'gdi32.CreateColorSpaceW', (('void *', 'ptr'),) ),
    'gdi32.createcompatiblebitmap':( 'int', None, 'stdcall', 'gdi32.CreateCompatibleBitmap', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createcompatibledc':( 'int', None, 'stdcall', 'gdi32.CreateCompatibleDC', (('int', None),) ),
    'gdi32.createdca':( 'int', None, 'stdcall', 'gdi32.CreateDCA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createdcw':( 'int', None, 'stdcall', 'gdi32.CreateDCW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createdibpatternbrush':( 'int', None, 'stdcall', 'gdi32.CreateDIBPatternBrush', ( ('int', None), ('int', None)) ),
    'gdi32.createdibpatternbrushpt':( 'int', None, 'stdcall', 'gdi32.CreateDIBPatternBrushPt', (('int', None), ('int', None)) ),
    'gdi32.createdibsection':( 'int', None, 'stdcall', 'gdi32.CreateDIBSection', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.createdibitmap':( 'int', None, 'stdcall', 'gdi32.CreateDIBitmap', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.creatediscardablebitmap':( 'int', None, 'stdcall', 'gdi32.CreateDiscardableBitmap', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createellipticrgn':( 'int', None, 'stdcall', 'gdi32.CreateEllipticRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createellipticrgnindirect':( 'int', None, 'stdcall', 'gdi32.CreateEllipticRgnIndirect', (('int', None),) ),
    'gdi32.createenhmetafilea':( 'int', None, 'stdcall', 'gdi32.CreateEnhMetaFileA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'gdi32.createenhmetafilew':( 'int', None, 'stdcall', 'gdi32.CreateEnhMetaFileW', (('int', None), ('void *', 'ptr'), ('void *', 'obj'), ('int', None)) ),
    'gdi32.createfonta':( 'int', None, 'stdcall', 'gdi32.CreateFontA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createfontindirecta':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectA', (('void *', 'ptr'),) ),
    'gdi32.createfontindirectexa':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectExA', (('int', None),) ),
    'gdi32.createfontindirectexw':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectExW', (('void *', 'ptr'),) ),
    'gdi32.createfontindirectw':( 'int', None, 'stdcall', 'gdi32.CreateFontIndirectW', (('void *', 'ptr'),) ),
    'gdi32.createfontw':( 'int', None, 'stdcall', 'gdi32.CreateFontW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createhalftonepalette':( 'int', None, 'stdcall', 'gdi32.CreateHalftonePalette', (('int', None),) ),
    'gdi32.createhatchbrush':( 'int', None, 'stdcall', 'gdi32.CreateHatchBrush', (('int', None), ('int', None)) ),
    'gdi32.createica':( 'int', None, 'stdcall', 'gdi32.CreateICA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createicw':( 'int', None, 'stdcall', 'gdi32.CreateICW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createmetafilea':( 'int', None, 'stdcall', 'gdi32.CreateMetaFileA', (('int', None),) ),
    'gdi32.createmetafilew':( 'int', None, 'stdcall', 'gdi32.CreateMetaFileW', (('int', None),) ),
    'gdi32.createpalette':( 'int', None, 'stdcall', 'gdi32.CreatePalette', (('int', None),) ),
    'gdi32.createpatternbrush':( 'int', None, 'stdcall', 'gdi32.CreatePatternBrush', (('int', None),) ),
    'gdi32.createpen':( 'int', None, 'stdcall', 'gdi32.CreatePen', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createpenindirect':( 'int', None, 'stdcall', 'gdi32.CreatePenIndirect', (('void *', 'ptr'),) ),
    'gdi32.createpolypolygonrgn':( 'int', None, 'stdcall', 'gdi32.CreatePolyPolygonRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createpolygonrgn':( 'int', None, 'stdcall', 'gdi32.CreatePolygonRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.createrectrgn':( 'int', None, 'stdcall', 'gdi32.CreateRectRgn', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createrectrgnindirect':( 'int', None, 'stdcall', 'gdi32.CreateRectRgnIndirect', (('int', None),) ),
    'gdi32.createroundrectrgn':( 'int', None, 'stdcall', 'gdi32.CreateRoundRectRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createscalablefontresourcea':( 'int', None, 'stdcall', 'gdi32.CreateScalableFontResourceA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.createscalablefontresourcew':( 'int', None, 'stdcall', 'gdi32.CreateScalableFontResourceW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.createsolidbrush':( 'int', None, 'stdcall', 'gdi32.CreateSolidBrush', (('int', None),) ),
    'gdi32.dptolp':( 'int', None, 'stdcall', 'gdi32.DPtoLP', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry0':( 'int', None, 'stdcall', 'gdi32.DdEntry0', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry1':( 'int', None, 'stdcall', 'gdi32.DdEntry1', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry10':( 'int', None, 'stdcall', 'gdi32.DdEntry10', (('int', None), ('int', None)) ),
    'gdi32.ddentry11':( 'int', None, 'stdcall', 'gdi32.DdEntry11', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry12':( 'int', None, 'stdcall', 'gdi32.DdEntry12', (('int', None), ('int', None)) ),
    'gdi32.ddentry13':( 'int', None, 'stdcall', 'gdi32.DdEntry13', (('int', None), ('int', None)) ),
    'gdi32.ddentry14':( 'int', None, 'stdcall', 'gdi32.DdEntry14', (('int', None), ('int', None)) ),
    'gdi32.ddentry15':( 'int', None, 'stdcall', 'gdi32.DdEntry15', (('int', None),) ),
    'gdi32.ddentry16':( 'int', None, 'stdcall', 'gdi32.DdEntry16', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry17':( 'int', None, 'stdcall', 'gdi32.DdEntry17', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'gdi32.ddentry18':( 'int', None, 'stdcall', 'gdi32.DdEntry18', (('int', None), ('int', None)) ),
    'gdi32.ddentry19':( 'int', None, 'stdcall', 'gdi32.DdEntry19', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ddentry2':( 'int', None, 'stdcall', 'gdi32.DdEntry2', (('int', None),) ),
    'gdi32.ddentry20':( 'int', None, 'stdcall', 'gdi32.DdEntry20', (('int', None),) ),
    'gdi32.ddentry21':( 'int', None, 'stdcall', 'gdi32.DdEntry21', (('int', None),) ),
    'gdi32.ddentry22':( 'int', None, 'stdcall', 'gdi32.DdEntry22', (('int', None), ('int', None)) ),
    'gdi32.ddentry23':( 'int', None, 'stdcall', 'gdi32.DdEntry23', (('int', None), ('int', None)) ),
    'gdi32.ddentry24':( 'int', None, 'stdcall', 'gdi32.DdEntry24', (('int', None),) ),
    'gdi32.ddentry25':( 'int', None, 'stdcall', 'gdi32.DdEntry25', (('int', None), ('int', None)) ),
    'gdi32.ddentry26':( 'int', None, 'stdcall', 'gdi32.DdEntry26', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry27':( 'int', None, 'stdcall', 'gdi32.DdEntry27', (('int', None), ('int', None)) ),
    'gdi32.ddentry28':( 'int', None, 'stdcall', 'gdi32.DdEntry28', (('int', None), ('int', None)) ),
    'gdi32.ddentry29':( 'int', None, 'stdcall', 'gdi32.DdEntry29', (('int', None), ('int', None)) ),
    'gdi32.ddentry3':( 'int', None, 'stdcall', 'gdi32.DdEntry3', (('int', None),) ),
    'gdi32.ddentry30':( 'int', None, 'stdcall', 'gdi32.DdEntry30', (('int', None), ('int', None)) ),
    'gdi32.ddentry31':( 'int', None, 'stdcall', 'gdi32.DdEntry31', (('int', None), ('void *', 'ptr')) ),
    'gdi32.ddentry32':( 'int', None, 'stdcall', 'gdi32.DdEntry32', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry33':( 'int', None, 'stdcall', 'gdi32.DdEntry33', (('int', None), ('int', None)) ),
    'gdi32.ddentry34':( 'int', None, 'stdcall', 'gdi32.DdEntry34', (('int', None), ('int', None)) ),
    'gdi32.ddentry35':( 'int', None, 'stdcall', 'gdi32.DdEntry35', (('int', None), ('int', None)) ),
    'gdi32.ddentry36':( 'int', None, 'stdcall', 'gdi32.DdEntry36', (('int', None), ('int', None)) ),
    'gdi32.ddentry37':( 'int', None, 'stdcall', 'gdi32.DdEntry37', (('int', None), ('int', None)) ),
    'gdi32.ddentry38':( 'int', None, 'stdcall', 'gdi32.DdEntry38', (('int', None), ('int', None)) ),
    'gdi32.ddentry39':( 'int', None, 'stdcall', 'gdi32.DdEntry39', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry4':( 'int', None, 'stdcall', 'gdi32.DdEntry4', (('int', None),) ),
    'gdi32.ddentry40':( 'int', None, 'stdcall', 'gdi32.DdEntry40', (('int', None), ('int', None)) ),
    'gdi32.ddentry41':( 'int', None, 'stdcall', 'gdi32.DdEntry41', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ddentry42':( 'int', None, 'stdcall', 'gdi32.DdEntry42', (('int', None), ('int', None)) ),
    'gdi32.ddentry43':( 'int', None, 'stdcall', 'gdi32.DdEntry43', (('int', None), ('int', None)) ),
    'gdi32.ddentry44':( 'int', None, 'stdcall', 'gdi32.DdEntry44', (('int', None),) ),
    'gdi32.ddentry45':( 'int', None, 'stdcall', 'gdi32.DdEntry45', (('int', None), ('int', None)) ),
    'gdi32.ddentry46':( 'int', None, 'stdcall', 'gdi32.DdEntry46', (('int', None), ('int', None)) ),
    'gdi32.ddentry47':( 'int', None, 'stdcall', 'gdi32.DdEntry47', (('int', None), ('int', None)) ),
    'gdi32.ddentry48':( 'int', None, 'stdcall', 'gdi32.DdEntry48', (('int', None), ('int', None)) ),
    'gdi32.ddentry49':( 'int', None, 'stdcall', 'gdi32.DdEntry49', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry5':( 'int', None, 'stdcall', 'gdi32.DdEntry5', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry50':( 'int', None, 'stdcall', 'gdi32.DdEntry50', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry51':( 'int', None, 'stdcall', 'gdi32.DdEntry51', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry52':( 'int', None, 'stdcall', 'gdi32.DdEntry52', (('int', None), ('int', None)) ),
    'gdi32.ddentry53':( 'int', None, 'stdcall', 'gdi32.DdEntry53', (('int', None), ('int', None)) ),
    'gdi32.ddentry54':( 'int', None, 'stdcall', 'gdi32.DdEntry54', (('int', None), ('int', None)) ),
    'gdi32.ddentry55':( 'int', None, 'stdcall', 'gdi32.DdEntry55', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry56':( 'int', None, 'stdcall', 'gdi32.DdEntry56', (('int', None), ('int', None)) ),
    'gdi32.ddentry6':( 'int', None, 'stdcall', 'gdi32.DdEntry6', (('int', None),) ),
    'gdi32.ddentry7':( 'int', None, 'stdcall', 'gdi32.DdEntry7', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry8':( 'int', None, 'stdcall', 'gdi32.DdEntry8', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ddentry9':( 'int', None, 'stdcall', 'gdi32.DdEntry9', (('int', None), ('int', None)) ),
    'gdi32.deletecolorspace':( 'int', None, 'stdcall', 'gdi32.DeleteColorSpace', (('int', None),) ),
    'gdi32.deletedc':( 'int', None, 'stdcall', 'gdi32.DeleteDC', (('int', None),) ),
    'gdi32.deleteenhmetafile':( 'int', None, 'stdcall', 'gdi32.DeleteEnhMetaFile', (('int', None),) ),
    'gdi32.deletemetafile':( 'int', None, 'stdcall', 'gdi32.DeleteMetaFile', (('int', None),) ),
    'gdi32.deleteobject':( 'int', None, 'stdcall', 'gdi32.DeleteObject', (('int', None),) ),
    'gdi32.describepixelformat':( 'int', None, 'stdcall', 'gdi32.DescribePixelFormat', ( ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.devicecapabilitiesexa':( 'int', None, 'stdcall', 'gdi32.DeviceCapabilitiesExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.devicecapabilitiesexw':( 'int', None, 'stdcall', 'gdi32.DeviceCapabilitiesExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.drawescape':( 'int', None, 'stdcall', 'gdi32.DrawEscape', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.ellipse':( 'int', None, 'stdcall', 'gdi32.Ellipse', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.enableeudc':( 'int', None, 'stdcall', 'gdi32.EnableEUDC', (('int', None),) ),
    'gdi32.enddoc':( 'int', None, 'stdcall', 'gdi32.EndDoc', (('int', None),) ),
    'gdi32.endformpage':( 'int', None, 'stdcall', 'gdi32.EndFormPage', (('int', None),) ),
    'gdi32.endpage':( 'int', None, 'stdcall', 'gdi32.EndPage', (('int', None),) ),
    'gdi32.endpath':( 'int', None, 'stdcall', 'gdi32.EndPath', (('int', None),) ),
    'gdi32.engacquiresemaphore':( 'int', None, 'cdecl', 'gdi32.EngAcquireSemaphore', () ),
    'gdi32.engalphablend':( 'int', None, 'stdcall', 'gdi32.EngAlphaBlend', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engassociatesurface':( 'int', None, 'stdcall', 'gdi32.EngAssociateSurface', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engbitblt':( 'int', None, 'stdcall', 'gdi32.EngBitBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcheckabort':( 'int', None, 'stdcall', 'gdi32.EngCheckAbort', (('int', None),) ),
    'gdi32.engcomputeglyphset':( 'int', None, 'stdcall', 'gdi32.EngComputeGlyphSet', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcopybits':( 'int', None, 'stdcall', 'gdi32.EngCopyBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatebitmap':( 'int', None, 'stdcall', 'gdi32.EngCreateBitmap', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreateclip':( 'int', None, 'cdecl', 'gdi32.EngCreateClip', () ),
    'gdi32.engcreatedevicebitmap':( 'int', None, 'stdcall', 'gdi32.EngCreateDeviceBitmap', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatedevicesurface':( 'int', None, 'stdcall', 'gdi32.EngCreateDeviceSurface', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatepalette':( 'int', None, 'stdcall', 'gdi32.EngCreatePalette', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engcreatesemaphore':( 'int', None, 'cdecl', 'gdi32.EngCreateSemaphore', () ),
    'gdi32.engdeleteclip':( 'int', None, 'stdcall', 'gdi32.EngDeleteClip', (('int', None),) ),
    'gdi32.engdeletepalette':( 'int', None, 'stdcall', 'gdi32.EngDeletePalette', (('int', None),) ),
    'gdi32.engdeletepath':( 'int', None, 'stdcall', 'gdi32.EngDeletePath', (('int', None),) ),
    'gdi32.engdeletesemaphore':( 'int', None, 'stdcall', 'gdi32.EngDeleteSemaphore', (('void *', 'ptr'),) ),
    'gdi32.engdeletesurface':( 'int', None, 'stdcall', 'gdi32.EngDeleteSurface', (('int', None),) ),
    'gdi32.engerasesurface':( 'int', None, 'stdcall', 'gdi32.EngEraseSurface', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfillpath':( 'int', None, 'stdcall', 'gdi32.EngFillPath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfindresource':( 'int', None, 'stdcall', 'gdi32.EngFindResource', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engfreemodule':( 'int', None, 'cdecl', 'gdi32.EngFreeModule', () ),
    'gdi32.enggetcurrentcodepage':( 'int', None, 'stdcall', 'gdi32.EngGetCurrentCodePage', (('int', None), ('int', None)) ),
    'gdi32.enggetdrivername':( 'int', None, 'stdcall', 'gdi32.EngGetDriverName', (('int', None),) ),
    'gdi32.enggetprinterdatafilename':( 'int', None, 'stdcall', 'gdi32.EngGetPrinterDataFileName', (('int', None),) ),
    'gdi32.enggradientfill':( 'int', None, 'stdcall', 'gdi32.EngGradientFill', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.englineto':( 'int', None, 'stdcall', 'gdi32.EngLineTo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engloadmodule':( 'int', None, 'stdcall', 'gdi32.EngLoadModule', (('int', None),) ),
    'gdi32.englocksurface':( 'int', None, 'stdcall', 'gdi32.EngLockSurface', (('int', None),) ),
    'gdi32.engmarkbandingsurface':( 'int', None, 'stdcall', 'gdi32.EngMarkBandingSurface', (('int', None),) ),
    'gdi32.engmultibytetounicoden':( 'int', None, 'cdecl', 'gdi32.EngMultiByteToUnicodeN', () ),
    'gdi32.engmultibytetowidechar':( 'int', None, 'stdcall', 'gdi32.EngMultiByteToWideChar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engpaint':( 'int', None, 'stdcall', 'gdi32.EngPaint', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engplgblt':( 'int', None, 'stdcall', 'gdi32.EngPlgBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engqueryemfinfo':( 'int', None, 'stdcall', 'gdi32.EngQueryEMFInfo', (('int', None), ('int', None)) ),
    'gdi32.engquerylocaltime':( 'int', None, 'stdcall', 'gdi32.EngQueryLocalTime', (('int', None),) ),
    'gdi32.engreleasesemaphore':( 'int', None, 'cdecl', 'gdi32.EngReleaseSemaphore', () ),
    'gdi32.engstretchblt':( 'int', None, 'stdcall', 'gdi32.EngStretchBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstretchbltrop':( 'int', None, 'stdcall', 'gdi32.EngStretchBltROP', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstrokeandfillpath':( 'int', None, 'stdcall', 'gdi32.EngStrokeAndFillPath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engstrokepath':( 'int', None, 'stdcall', 'gdi32.EngStrokePath', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engtextout':( 'int', None, 'stdcall', 'gdi32.EngTextOut', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engtransparentblt':( 'int', None, 'stdcall', 'gdi32.EngTransparentBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.engunicodetomultibyten':( 'int', None, 'cdecl', 'gdi32.EngUnicodeToMultiByteN', () ),
    'gdi32.engunlocksurface':( 'int', None, 'stdcall', 'gdi32.EngUnlockSurface', (('int', None),) ),
    'gdi32.engwidechartomultibyte':( 'int', None, 'stdcall', 'gdi32.EngWideCharToMultiByte', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.enumenhmetafile':( 'int', None, 'stdcall', 'gdi32.EnumEnhMetaFile', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesa':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontfamiliesexa':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesExA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesexw':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesExW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'gdi32.enumfontfamiliesw':( 'int', None, 'stdcall', 'gdi32.EnumFontFamiliesW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontsa':( 'int', None, 'stdcall', 'gdi32.EnumFontsA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumfontsw':( 'int', None, 'stdcall', 'gdi32.EnumFontsW', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumicmprofilesa':( 'int', None, 'stdcall', 'gdi32.EnumICMProfilesA', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'gdi32.enumicmprofilesw':( 'int', None, 'stdcall', 'gdi32.EnumICMProfilesW', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'gdi32.enummetafile':( 'int', None, 'stdcall', 'gdi32.EnumMetaFile', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.enumobjects':( 'int', None, 'stdcall', 'gdi32.EnumObjects', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.equalrgn':( 'int', None, 'stdcall', 'gdi32.EqualRgn', (('int', None), ('int', None)) ),
    'gdi32.escape':( 'int', None, 'stdcall', 'gdi32.Escape', (('int', None), ('int', None), ('DWORD', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.eudcloadlinkw':( 'int', None, 'stdcall', 'gdi32.EudcLoadLinkW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.eudcunloadlinkw':( 'int', None, 'stdcall', 'gdi32.EudcUnloadLinkW', (('int', None), ('int', None)) ),
    'gdi32.excludecliprect':( 'int', None, 'stdcall', 'gdi32.ExcludeClipRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.extcreatepen':( 'int', None, 'stdcall', 'gdi32.ExtCreatePen', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.extcreateregion':( 'int', None, 'stdcall', 'gdi32.ExtCreateRegion', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.extescape':( 'int', None, 'stdcall', 'gdi32.ExtEscape', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.extfloodfill':( 'int', None, 'stdcall', 'gdi32.ExtFloodFill', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.extselectcliprgn':( 'int', None, 'stdcall', 'gdi32.ExtSelectClipRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.exttextouta':( 'int', None, 'stdcall', 'gdi32.ExtTextOutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None), ('int', None)) ),
    'gdi32.exttextoutw':( 'int', None, 'stdcall', 'gdi32.ExtTextOutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.fontobj_cgetallglyphhandles':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_cGetAllGlyphHandles', (('int', None), ('int', None)) ),
    'gdi32.fontobj_cgetglyphs':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_cGetGlyphs', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.fontobj_pqueryglyphattrs':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pQueryGlyphAttrs', (('int', None), ('int', None)) ),
    'gdi32.fontobj_pfdg':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pfdg', (('int', None),) ),
    'gdi32.fontobj_pifi':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pifi', (('int', None),) ),
    'gdi32.fontobj_pvtruetypefontfile':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pvTrueTypeFontFile', (('int', None), ('int', None)) ),
    'gdi32.fontobj_pxogetxform':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_pxoGetXform', (('int', None),) ),
    'gdi32.fontobj_vgetinfo':( 'int', None, 'stdcall', 'gdi32.FONTOBJ_vGetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.fillpath':( 'int', None, 'stdcall', 'gdi32.FillPath', (('int', None),) ),
    'gdi32.fillrgn':( 'int', None, 'stdcall', 'gdi32.FillRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.fixbrushorgex':( 'int', None, 'stdcall', 'gdi32.FixBrushOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.flattenpath':( 'int', None, 'stdcall', 'gdi32.FlattenPath', (('int', None),) ),
    'gdi32.floodfill':( 'int', None, 'stdcall', 'gdi32.FloodFill', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.fontislinked':( 'int', None, 'stdcall', 'gdi32.FontIsLinked', (('int', None),) ),
    'gdi32.framergn':( 'int', None, 'stdcall', 'gdi32.FrameRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiaddfontresourcew':( 'int', None, 'stdcall', 'gdi32.GdiAddFontResourceW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.gdiaddglsbounds':( 'int', None, 'stdcall', 'gdi32.GdiAddGlsBounds', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiaddglsrecord':( 'int', None, 'stdcall', 'gdi32.GdiAddGlsRecord', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdialphablend':( 'int', None, 'stdcall', 'gdi32.GdiAlphaBlend', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiartificialdecrementdriver':( 'int', None, 'stdcall', 'gdi32.GdiArtificialDecrementDriver', (('int', None), ('int', None)) ),
    'gdi32.gdicleancachedc':( 'int', None, 'stdcall', 'gdi32.GdiCleanCacheDC', (('int', None),) ),
    'gdi32.gdicomment':( 'int', None, 'stdcall', 'gdi32.GdiComment', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiconsoletextout':( 'int', None, 'stdcall', 'gdi32.GdiConsoleTextOut', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiconvertandcheckdc':( 'int', None, 'stdcall', 'gdi32.GdiConvertAndCheckDC', (('int', None),) ),
    'gdi32.gdiconvertbitmap':( 'int', None, 'stdcall', 'gdi32.GdiConvertBitmap', (('int', None),) ),
    'gdi32.gdiconvertbitmapv5':( 'int', None, 'stdcall', 'gdi32.GdiConvertBitmapV5', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiconvertbrush':( 'int', None, 'stdcall', 'gdi32.GdiConvertBrush', (('int', None),) ),
    'gdi32.gdiconvertdc':( 'int', None, 'stdcall', 'gdi32.GdiConvertDC', (('int', None),) ),
    'gdi32.gdiconvertenhmetafile':( 'int', None, 'stdcall', 'gdi32.GdiConvertEnhMetaFile', (('int', None),) ),
    'gdi32.gdiconvertfont':( 'int', None, 'stdcall', 'gdi32.GdiConvertFont', (('int', None),) ),
    'gdi32.gdiconvertmetafilepict':( 'int', None, 'stdcall', 'gdi32.GdiConvertMetaFilePict', (('int', None),) ),
    'gdi32.gdiconvertpalette':( 'int', None, 'stdcall', 'gdi32.GdiConvertPalette', (('int', None),) ),
    'gdi32.gdiconvertregion':( 'int', None, 'stdcall', 'gdi32.GdiConvertRegion', (('int', None),) ),
    'gdi32.gdiconverttodevmodew':( 'int', None, 'stdcall', 'gdi32.GdiConvertToDevmodeW', (('int', None),) ),
    'gdi32.gdicreatelocalenhmetafile':( 'int', None, 'stdcall', 'gdi32.GdiCreateLocalEnhMetaFile', (('int', None),) ),
    'gdi32.gdicreatelocalmetafilepict':( 'int', None, 'stdcall', 'gdi32.GdiCreateLocalMetaFilePict', (('int', None),) ),
    'gdi32.gdideletelocaldc':( 'int', None, 'stdcall', 'gdi32.GdiDeleteLocalDC', (('int', None),) ),
    'gdi32.gdideletespoolfilehandle':( 'int', None, 'stdcall', 'gdi32.GdiDeleteSpoolFileHandle', (('void *', 'ptr'),) ),
    'gdi32.gdidescribepixelformat':( 'int', None, 'stdcall', 'gdi32.GdiDescribePixelFormat', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdidllinitialize':( 'int', None, 'stdcall', 'gdi32.GdiDllInitialize', ( ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdidrawstream':( 'int', None, 'stdcall', 'gdi32.GdiDrawStream', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdienddocemf':( 'int', None, 'stdcall', 'gdi32.GdiEndDocEMF', (('int', None),) ),
    'gdi32.gdiendpageemf':( 'int', None, 'stdcall', 'gdi32.GdiEndPageEMF', (('int', None), ('int', None)) ),
    'gdi32.gdientry1':( 'int', None, 'stdcall', 'gdi32.GdiEntry1', (('int', None), ('int', None)) ),
    'gdi32.gdientry10':( 'int', None, 'stdcall', 'gdi32.GdiEntry10', (('int', None), ('int', None)) ),
    'gdi32.gdientry11':( 'int', None, 'stdcall', 'gdi32.GdiEntry11', (('int', None), ('int', None)) ),
    'gdi32.gdientry12':( 'int', None, 'stdcall', 'gdi32.GdiEntry12', (('int', None), ('int', None)) ),
    'gdi32.gdientry13':( 'int', None, 'cdecl', 'gdi32.GdiEntry13', () ),
    'gdi32.gdientry14':( 'int', None, 'stdcall', 'gdi32.GdiEntry14', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry15':( 'int', None, 'stdcall', 'gdi32.GdiEntry15', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry16':( 'int', None, 'stdcall', 'gdi32.GdiEntry16', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry2':( 'int', None, 'stdcall', 'gdi32.GdiEntry2', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdientry3':( 'int', None, 'stdcall', 'gdi32.GdiEntry3', (('int', None),) ),
    'gdi32.gdientry4':( 'int', None, 'stdcall', 'gdi32.GdiEntry4', (('int', None), ('int', None)) ),
    'gdi32.gdientry5':( 'int', None, 'stdcall', 'gdi32.GdiEntry5', (('int', None),) ),
    'gdi32.gdientry6':( 'int', None, 'stdcall', 'gdi32.GdiEntry6', (('int', None), ('int', None)) ),
    'gdi32.gdientry7':( 'int', None, 'stdcall', 'gdi32.GdiEntry7', (('int', None), ('int', None)) ),
    'gdi32.gdientry8':( 'int', None, 'stdcall', 'gdi32.GdiEntry8', (('int', None),) ),
    'gdi32.gdientry9':( 'int', None, 'stdcall', 'gdi32.GdiEntry9', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdifixuphandle':( 'int', None, 'stdcall', 'gdi32.GdiFixUpHandle', (('int', None),) ),
    'gdi32.gdiflush':( 'int', None, 'cdecl', 'gdi32.GdiFlush', () ),
    'gdi32.gdifullscreencontrol':( 'int', None, 'stdcall', 'gdi32.GdiFullscreenControl', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetbatchlimit':( 'int', None, 'cdecl', 'gdi32.GdiGetBatchLimit', () ),
    'gdi32.gdigetbitmapbitssize':( 'int', None, 'stdcall', 'gdi32.GdiGetBitmapBitsSize', (('int', None),) ),
    'gdi32.gdigetchardimensions':( 'int', None, 'stdcall', 'gdi32.GdiGetCharDimensions', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetcodepage':( 'int', None, 'stdcall', 'gdi32.GdiGetCodePage', (('int', None),) ),
    'gdi32.gdigetdc':( 'int', None, 'stdcall', 'gdi32.GdiGetDC', (('int', None),) ),
    'gdi32.gdigetdevmodeforpage':( 'int', None, 'stdcall', 'gdi32.GdiGetDevmodeForPage', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetlocalbrush':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalBrush', (('int', None),) ),
    'gdi32.gdigetlocaldc':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalDC', (('int', None),) ),
    'gdi32.gdigetlocalfont':( 'int', None, 'stdcall', 'gdi32.GdiGetLocalFont', (('int', None),) ),
    'gdi32.gdigetpagecount':( 'int', None, 'stdcall', 'gdi32.GdiGetPageCount', (('int', None),) ),
    'gdi32.gdigetpagehandle':( 'int', None, 'stdcall', 'gdi32.GdiGetPageHandle', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdigetspoolfilehandle':( 'int', None, 'stdcall', 'gdi32.GdiGetSpoolFileHandle', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigetspoolmessage':( 'int', None, 'stdcall', 'gdi32.GdiGetSpoolMessage', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdigradientfill':( 'int', None, 'stdcall', 'gdi32.GdiGradientFill', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiinitspool':( 'int', None, 'cdecl', 'gdi32.GdiInitSpool', () ),
    'gdi32.gdiinitializelanguagepack':( 'int', None, 'stdcall', 'gdi32.GdiInitializeLanguagePack', (('int', None),) ),
    'gdi32.gdiismetafiledc':( 'int', None, 'stdcall', 'gdi32.GdiIsMetaFileDC', (('int', None),) ),
    'gdi32.gdiismetaprintdc':( 'int', None, 'stdcall', 'gdi32.GdiIsMetaPrintDC', (('int', None),) ),
    'gdi32.gdiisplaymetafiledc':( 'int', None, 'stdcall', 'gdi32.GdiIsPlayMetafileDC', (('int', None),) ),
    'gdi32.gdiplaydcscript':( 'int', None, 'stdcall', 'gdi32.GdiPlayDCScript', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayEMF', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayjournal':( 'int', None, 'stdcall', 'gdi32.GdiPlayJournal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplaypageemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayPageEMF', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.gdiplayprivatepageemf':( 'int', None, 'stdcall', 'gdi32.GdiPlayPrivatePageEMF', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiplayscript':( 'int', None, 'stdcall', 'gdi32.GdiPlayScript', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiprinterthunk':( 'int', None, 'stdcall', 'gdi32.GdiPrinterThunk', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdiprocesssetup':( 'int', None, 'cdecl', 'gdi32.GdiProcessSetup', () ),
    'gdi32.gdiqueryfonts':( 'int', None, 'stdcall', 'gdi32.GdiQueryFonts', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gdiquerytable':( 'int', None, 'cdecl', 'gdi32.GdiQueryTable', () ),
    'gdi32.gdirealizationinfo':( 'int', None, 'stdcall', 'gdi32.GdiRealizationInfo', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gdireleasedc':( 'int', None, 'stdcall', 'gdi32.GdiReleaseDC', (('int', None),) ),
    'gdi32.gdireleaselocaldc':( 'int', None, 'stdcall', 'gdi32.GdiReleaseLocalDC', (('int', None),) ),
    'gdi32.gdiresetdcemf':( 'int', None, 'stdcall', 'gdi32.GdiResetDCEMF', (('int', None), ('int', None)) ),
    'gdi32.gdisetattrs':( 'int', None, 'stdcall', 'gdi32.GdiSetAttrs', (('int', None),) ),
    'gdi32.gdisetbatchlimit':( 'int', None, 'stdcall', 'gdi32.GdiSetBatchLimit', (('int', None),) ),
    'gdi32.gdisetlasterror':( 'int', None, 'stdcall', 'gdi32.GdiSetLastError', (('int', None),) ),
    'gdi32.gdisetpixelformat':( 'int', None, 'stdcall', 'gdi32.GdiSetPixelFormat', (('int', None), ('int', None)) ),
    'gdi32.gdisetserverattr':( 'int', None, 'stdcall', 'gdi32.GdiSetServerAttr', (('int', None), ('int', None)) ),
    'gdi32.gdistartdocemf':( 'int', None, 'stdcall', 'gdi32.GdiStartDocEMF', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.gdistartpageemf':( 'int', None, 'stdcall', 'gdi32.GdiStartPageEMF', (('int', None),) ),
    'gdi32.gdiswapbuffers':( 'int', None, 'stdcall', 'gdi32.GdiSwapBuffers', (('int', None),) ),
    'gdi32.gditransparentblt':( 'int', None, 'stdcall', 'gdi32.GdiTransparentBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gdivalidatehandle':( 'int', None, 'stdcall', 'gdi32.GdiValidateHandle', (('int', None),) ),
    'gdi32.getarcdirection':( 'int', None, 'stdcall', 'gdi32.GetArcDirection', (('int', None),) ),
    'gdi32.getaspectratiofilterex':( 'int', None, 'stdcall', 'gdi32.GetAspectRatioFilterEx', (('int', None), ('int', None)) ),
    'gdi32.getbitmapattributes':( 'int', None, 'stdcall', 'gdi32.GetBitmapAttributes', (('int', None),) ),
    'gdi32.getbitmapbits':( 'int', None, 'stdcall', 'gdi32.GetBitmapBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getbitmapdimensionex':( 'int', None, 'stdcall', 'gdi32.GetBitmapDimensionEx', (('int', None), ('int', None)) ),
    'gdi32.getbkcolor':( 'int', None, 'stdcall', 'gdi32.GetBkColor', (('int', None),) ),
    'gdi32.getbkmode':( 'int', None, 'stdcall', 'gdi32.GetBkMode', (('int', None),) ),
    'gdi32.getboundsrect':( 'int', None, 'stdcall', 'gdi32.GetBoundsRect', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getbrushattributes':( 'int', None, 'stdcall', 'gdi32.GetBrushAttributes', (('int', None),) ),
    'gdi32.getbrushorgex':( 'int', None, 'stdcall', 'gdi32.GetBrushOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getcharabcwidthsa':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsfloata':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsFloatA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsfloatw':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsFloatW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsi':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsI', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharabcwidthsw':( 'int', None, 'stdcall', 'gdi32.GetCharABCWidthsW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidth32a':( 'int', None, 'stdcall', 'gdi32.GetCharWidth32A', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidth32w':( 'int', None, 'stdcall', 'gdi32.GetCharWidth32W', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidtha':( 'int', None, 'stdcall', 'gdi32.GetCharWidthA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthfloata':( 'int', None, 'stdcall', 'gdi32.GetCharWidthFloatA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthfloatw':( 'int', None, 'stdcall', 'gdi32.GetCharWidthFloatW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharwidthi':( 'int', None, 'stdcall', 'gdi32.GetCharWidthI', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getcharwidthinfo':( 'int', None, 'stdcall', 'gdi32.GetCharWidthInfo', (('int', None), ('int', None)) ),
    'gdi32.getcharwidthw':( 'int', None, 'stdcall', 'gdi32.GetCharWidthW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharacterplacementa':( 'int', None, 'stdcall', 'gdi32.GetCharacterPlacementA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getcharacterplacementw':( 'int', None, 'stdcall', 'gdi32.GetCharacterPlacementW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getclipbox':( 'int', None, 'stdcall', 'gdi32.GetClipBox', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getcliprgn':( 'int', None, 'stdcall', 'gdi32.GetClipRgn', (('int', None), ('int', None)) ),
    'gdi32.getcoloradjustment':( 'int', None, 'stdcall', 'gdi32.GetColorAdjustment', (('int', None), ('int', None)) ),
    'gdi32.getcolorspace':( 'int', None, 'stdcall', 'gdi32.GetColorSpace', (('int', None),) ),
    'gdi32.getcurrentobject':( 'int', None, 'stdcall', 'gdi32.GetCurrentObject', (('int', None), ('int', None)) ),
    'gdi32.getcurrentpositionex':( 'int', None, 'stdcall', 'gdi32.GetCurrentPositionEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getdcbrushcolor':( 'int', None, 'stdcall', 'gdi32.GetDCBrushColor', (('int', None),) ),
    'gdi32.getdcorgex':( 'int', None, 'stdcall', 'gdi32.GetDCOrgEx', (('int', None), ('int', None)) ),
    'gdi32.getdcpencolor':( 'int', None, 'stdcall', 'gdi32.GetDCPenColor', (('int', None),) ),
    'gdi32.getdibcolortable':( 'int', None, 'stdcall', 'gdi32.GetDIBColorTable', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getdibits':( 'int', None, 'stdcall', 'gdi32.GetDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getdevicecaps':( 'int', None, 'stdcall', 'gdi32.GetDeviceCaps', (('int', None), ('int', None)) ),
    'gdi32.getdevicegammaramp':( 'int', None, 'stdcall', 'gdi32.GetDeviceGammaRamp', (('int', None), ('int', None)) ),
    'gdi32.getetm':( 'int', None, 'stdcall', 'gdi32.GetETM', (('int', None), ('void *', 'ptr')) ),
    'gdi32.geteudctimestamp':( 'int', None, 'cdecl', 'gdi32.GetEUDCTimeStamp', () ),
    'gdi32.geteudctimestampexw':( 'int', None, 'stdcall', 'gdi32.GetEUDCTimeStampExW', (('int', None),) ),
    'gdi32.getenhmetafilea':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileA', (('int', None),) ),
    'gdi32.getenhmetafilebits':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafiledescriptiona':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileDescriptionA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafiledescriptionw':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileDescriptionW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafileheader':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileHeader', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getenhmetafilepaletteentries':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFilePaletteEntries', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getenhmetafilepixelformat':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFilePixelFormat', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getenhmetafilew':( 'int', None, 'stdcall', 'gdi32.GetEnhMetaFileW', (('void *', 'ptr'),) ),
    'gdi32.getfontassocstatus':( 'int', None, 'stdcall', 'gdi32.GetFontAssocStatus', (('int', None),) ),
    'gdi32.getfontdata':( 'int', None, 'stdcall', 'gdi32.GetFontData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getfontlanguageinfo':( 'int', None, 'stdcall', 'gdi32.GetFontLanguageInfo', (('int', None),) ),
    'gdi32.getfontresourceinfow':( 'int', None, 'stdcall', 'gdi32.GetFontResourceInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getfontunicoderanges':( 'int', None, 'stdcall', 'gdi32.GetFontUnicodeRanges', (('int', None), ('int', None)) ),
    'gdi32.getglyphindicesa':( 'int', None, 'stdcall', 'gdi32.GetGlyphIndicesA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getglyphindicesw':( 'int', None, 'stdcall', 'gdi32.GetGlyphIndicesW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getglyphoutline':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutline', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinea':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinew':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getglyphoutlinewow':( 'int', None, 'stdcall', 'gdi32.GetGlyphOutlineWow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getgraphicsmode':( 'int', None, 'stdcall', 'gdi32.GetGraphicsMode', (('int', None),) ),
    'gdi32.gethfont':( 'int', None, 'stdcall', 'gdi32.GetHFONT', (('int', None),) ),
    'gdi32.geticmprofilea':( 'int', None, 'stdcall', 'gdi32.GetICMProfileA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.geticmprofilew':( 'int', None, 'stdcall', 'gdi32.GetICMProfileW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'gdi32.getkerningpairs':( 'int', None, 'stdcall', 'gdi32.GetKerningPairs', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getkerningpairsa':( 'int', None, 'stdcall', 'gdi32.GetKerningPairsA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getkerningpairsw':( 'int', None, 'stdcall', 'gdi32.GetKerningPairsW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getlayout':( 'int', None, 'stdcall', 'gdi32.GetLayout', (('int', None),) ),
    'gdi32.getlogcolorspacea':( 'int', None, 'stdcall', 'gdi32.GetLogColorSpaceA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getlogcolorspacew':( 'int', None, 'stdcall', 'gdi32.GetLogColorSpaceW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.getmapmode':( 'int', None, 'stdcall', 'gdi32.GetMapMode', (('int', None),) ),
    'gdi32.getmetafilea':( 'int', None, 'stdcall', 'gdi32.GetMetaFileA', (('int', None),) ),
    'gdi32.getmetafilebitsex':( 'int', None, 'stdcall', 'gdi32.GetMetaFileBitsEx', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getmetafilew':( 'int', None, 'stdcall', 'gdi32.GetMetaFileW', (('void *', 'ptr'),) ),
    'gdi32.getmetargn':( 'int', None, 'stdcall', 'gdi32.GetMetaRgn', (('int', None), ('int', None)) ),
    'gdi32.getmiterlimit':( 'int', None, 'stdcall', 'gdi32.GetMiterLimit', (('int', None), ('int', None)) ),
    'gdi32.getnearestcolor':( 'int', None, 'stdcall', 'gdi32.GetNearestColor', (('int', None), ('int', None)) ),
    'gdi32.getnearestpaletteindex':( 'int', None, 'stdcall', 'gdi32.GetNearestPaletteIndex', (('int', None), ('int', None)) ),
    'gdi32.getobjecta':( 'int', None, 'stdcall', 'gdi32.GetObjectA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getobjecttype':( 'int', None, 'stdcall', 'gdi32.GetObjectType', (('int', None),) ),
    'gdi32.getobjectw':( 'int', None, 'stdcall', 'gdi32.GetObjectW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getoutlinetextmetricsa':( 'int', None, 'stdcall', 'gdi32.GetOutlineTextMetricsA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getoutlinetextmetricsw':( 'int', None, 'stdcall', 'gdi32.GetOutlineTextMetricsW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpaletteentries':( 'int', None, 'stdcall', 'gdi32.GetPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpath':( 'int', None, 'stdcall', 'gdi32.GetPath', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpixel':( 'int', None, 'stdcall', 'gdi32.GetPixel', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getpixelformat':( 'int', None, 'stdcall', 'gdi32.GetPixelFormat', ( ('int', None),) ),
    'gdi32.getpolyfillmode':( 'int', None, 'stdcall', 'gdi32.GetPolyFillMode', (('int', None),) ),
    'gdi32.getrop2':( 'int', None, 'stdcall', 'gdi32.GetROP2', (('int', None),) ),
    'gdi32.getrandomrgn':( 'int', None, 'stdcall', 'gdi32.GetRandomRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getrasterizercaps':( 'int', None, 'stdcall', 'gdi32.GetRasterizerCaps', (('int', None), ('int', None)) ),
    'gdi32.getregiondata':( 'int', None, 'stdcall', 'gdi32.GetRegionData', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.getrelabs':( 'int', None, 'stdcall', 'gdi32.GetRelAbs', (('int', None), ('int', None)) ),
    'gdi32.getrgnbox':( 'int', None, 'stdcall', 'gdi32.GetRgnBox', (('int', None), ('int', None)) ),
    'gdi32.getstockobject':( 'int', None, 'stdcall', 'gdi32.GetStockObject', (('int', None),) ),
    'gdi32.getstretchbltmode':( 'int', None, 'stdcall', 'gdi32.GetStretchBltMode', (('int', None),) ),
    'gdi32.getstringbitmapa':( 'int', None, 'stdcall', 'gdi32.GetStringBitmapA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getstringbitmapw':( 'int', None, 'stdcall', 'gdi32.GetStringBitmapW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getsystempaletteentries':( 'int', None, 'stdcall', 'gdi32.GetSystemPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getsystempaletteuse':( 'int', None, 'stdcall', 'gdi32.GetSystemPaletteUse', (('int', None),) ),
    'gdi32.gettextalign':( 'int', None, 'stdcall', 'gdi32.GetTextAlign', (('int', None),) ),
    'gdi32.gettextcharacterextra':( 'int', None, 'stdcall', 'gdi32.GetTextCharacterExtra', (('int', None),) ),
    'gdi32.gettextcharset':( 'int', None, 'stdcall', 'gdi32.GetTextCharset', (('int', None),) ),
    'gdi32.gettextcharsetinfo':( 'int', None, 'stdcall', 'gdi32.GetTextCharsetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextcolor':( 'int', None, 'stdcall', 'gdi32.GetTextColor', (('int', None),) ),
    'gdi32.gettextextentexpointa':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointi':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointI', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointw':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentexpointwpri':( 'int', None, 'stdcall', 'gdi32.GetTextExtentExPointWPri', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentpoint32a':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPoint32A', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpoint32w':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPoint32W', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpointa':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextextentpointi':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointI', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextextentpointw':( 'int', None, 'stdcall', 'gdi32.GetTextExtentPointW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextfacea':( 'int', None, 'stdcall', 'gdi32.GetTextFaceA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextfacealiasw':( 'int', None, 'stdcall', 'gdi32.GetTextFaceAliasW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextfacew':( 'int', None, 'stdcall', 'gdi32.GetTextFaceW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.gettextmetricsa':( 'int', None, 'stdcall', 'gdi32.GetTextMetricsA', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gettextmetricsw':( 'int', None, 'stdcall', 'gdi32.GetTextMetricsW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.gettransform':( 'int', None, 'stdcall', 'gdi32.GetTransform', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.getviewportextex':( 'int', None, 'stdcall', 'gdi32.GetViewportExtEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getviewportorgex':( 'int', None, 'stdcall', 'gdi32.GetViewportOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getwinmetafilebits':( 'int', None, 'stdcall', 'gdi32.GetWinMetaFileBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.getwindowextex':( 'int', None, 'stdcall', 'gdi32.GetWindowExtEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getwindoworgex':( 'int', None, 'stdcall', 'gdi32.GetWindowOrgEx', (('int', None), ('void *', 'ptr')) ),
    'gdi32.getworldtransform':( 'int', None, 'stdcall', 'gdi32.GetWorldTransform', (('int', None), ('void *', 'ptr')) ),
    'gdi32.ht_get8bppformatpalette':( 'int', None, 'stdcall', 'gdi32.HT_Get8BPPFormatPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.ht_get8bppmaskpalette':( 'int', None, 'stdcall', 'gdi32.HT_Get8BPPMaskPalette', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.intersectcliprect':( 'int', None, 'stdcall', 'gdi32.IntersectClipRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.invertrgn':( 'int', None, 'stdcall', 'gdi32.InvertRgn', (('int', None), ('int', None)) ),
    'gdi32.isvalidenhmetarecord':( 'int', None, 'stdcall', 'gdi32.IsValidEnhMetaRecord', (('int', None), ('int', None)) ),
    'gdi32.isvalidenhmetarecordoffext':( 'int', None, 'stdcall', 'gdi32.IsValidEnhMetaRecordOffExt', (('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'gdi32.lptodp':( 'int', None, 'stdcall', 'gdi32.LPtoDP', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.linedda':( 'int', None, 'stdcall', 'gdi32.LineDDA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'gdi32.lineto':( 'int', None, 'stdcall', 'gdi32.LineTo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.maskblt':( 'int', None, 'stdcall', 'gdi32.MaskBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.mirrorrgn':( 'int', None, 'stdcall', 'gdi32.MirrorRgn', (('int', None), ('int', None)) ),
    'gdi32.modifyworldtransform':( 'int', None, 'stdcall', 'gdi32.ModifyWorldTransform', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.movetoex':( 'int', None, 'stdcall', 'gdi32.MoveToEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.namedescape':( 'int', None, 'stdcall', 'gdi32.NamedEscape', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetcliprgn':( 'int', None, 'stdcall', 'gdi32.OffsetClipRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetrgn':( 'int', None, 'stdcall', 'gdi32.OffsetRgn', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetviewportorgex':( 'int', None, 'stdcall', 'gdi32.OffsetViewportOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.offsetwindoworgex':( 'int', None, 'stdcall', 'gdi32.OffsetWindowOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_benum':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_bEnum', (('int', None), ('int', None)) ),
    'gdi32.pathobj_benumcliplines':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_bEnumClipLines', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_venumstart':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vEnumStart', (('int', None),) ),
    'gdi32.pathobj_venumstartcliplines':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vEnumStartClipLines', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathobj_vgetbounds':( 'int', None, 'stdcall', 'gdi32.PATHOBJ_vGetBounds', (('int', None), ('int', None)) ),
    'gdi32.paintrgn':( 'int', None, 'stdcall', 'gdi32.PaintRgn', (('int', None), ('int', None)) ),
    'gdi32.patblt':( 'int', None, 'stdcall', 'gdi32.PatBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.pathtoregion':( 'int', None, 'stdcall', 'gdi32.PathToRegion', (('int', None),) ),
    'gdi32.pie':( 'int', None, 'stdcall', 'gdi32.Pie', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.playenhmetafile':( 'int', None, 'stdcall', 'gdi32.PlayEnhMetaFile', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.playenhmetafilerecord':( 'int', None, 'stdcall', 'gdi32.PlayEnhMetaFileRecord', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.playmetafile':( 'int', None, 'stdcall', 'gdi32.PlayMetaFile', (('int', None), ('int', None)) ),
    'gdi32.playmetafilerecord':( 'int', None, 'stdcall', 'gdi32.PlayMetaFileRecord', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.plgblt':( 'int', None, 'stdcall', 'gdi32.PlgBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polybezier':( 'int', None, 'stdcall', 'gdi32.PolyBezier', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polybezierto':( 'int', None, 'stdcall', 'gdi32.PolyBezierTo', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polydraw':( 'int', None, 'stdcall', 'gdi32.PolyDraw', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypatblt':( 'int', None, 'stdcall', 'gdi32.PolyPatBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypolygon':( 'int', None, 'stdcall', 'gdi32.PolyPolygon', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polypolyline':( 'int', None, 'stdcall', 'gdi32.PolyPolyline', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.polytextouta':( 'int', None, 'stdcall', 'gdi32.PolyTextOutA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.polytextoutw':( 'int', None, 'stdcall', 'gdi32.PolyTextOutW', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.polygon':( 'int', None, 'stdcall', 'gdi32.Polygon', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polyline':( 'int', None, 'stdcall', 'gdi32.Polyline', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.polylineto':( 'int', None, 'stdcall', 'gdi32.PolylineTo', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.ptinregion':( 'int', None, 'stdcall', 'gdi32.PtInRegion', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.ptvisible':( 'int', None, 'stdcall', 'gdi32.PtVisible', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.queryfontassocstatus':( 'int', None, 'cdecl', 'gdi32.QueryFontAssocStatus', () ),
    'gdi32.realizepalette':( 'int', None, 'stdcall', 'gdi32.RealizePalette', (('int', None),) ),
    'gdi32.rectinregion':( 'int', None, 'stdcall', 'gdi32.RectInRegion', (('int', None), ('int', None)) ),
    'gdi32.rectvisible':( 'int', None, 'stdcall', 'gdi32.RectVisible', (('int', None), ('int', None)) ),
    'gdi32.rectangle':( 'int', None, 'stdcall', 'gdi32.Rectangle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontmemresourceex':( 'int', None, 'stdcall', 'gdi32.RemoveFontMemResourceEx', (('int', None),) ),
    'gdi32.removefontresourcea':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceA', (('int', None),) ),
    'gdi32.removefontresourceexa':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceExA', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontresourceexw':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceExW', ( ('int', None), ('int', None), ('int', None)) ),
    'gdi32.removefontresourcetracking':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceTracking', ( ('int', None), ('int', None)) ),
    'gdi32.removefontresourcew':( 'int', None, 'stdcall', 'gdi32.RemoveFontResourceW', ( ('void *', 'ptr'),) ),
    'gdi32.resetdca':( 'int', None, 'stdcall', 'gdi32.ResetDCA', (('int', None), ('int', None)) ),
    'gdi32.resetdcw':( 'int', None, 'stdcall', 'gdi32.ResetDCW', (('int', None), ('int', None)) ),
    'gdi32.resizepalette':( 'int', None, 'stdcall', 'gdi32.ResizePalette', (('int', None), ('int', None)) ),
    'gdi32.restoredc':( 'int', None, 'stdcall', 'gdi32.RestoreDC', (('int', None), ('int', None)) ),
    'gdi32.roundrect':( 'int', None, 'stdcall', 'gdi32.RoundRect', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_benum':( 'int', None, 'stdcall', 'gdi32.STROBJ_bEnum', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_benumpositionsonly':( 'int', None, 'stdcall', 'gdi32.STROBJ_bEnumPositionsOnly', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_bgetadvancewidths':( 'int', None, 'stdcall', 'gdi32.STROBJ_bGetAdvanceWidths', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.strobj_dwgetcodepage':( 'int', None, 'stdcall', 'gdi32.STROBJ_dwGetCodePage', (('int', None),) ),
    'gdi32.strobj_venumstart':( 'int', None, 'stdcall', 'gdi32.STROBJ_vEnumStart', (('int', None),) ),
    'gdi32.savedc':( 'int', None, 'stdcall', 'gdi32.SaveDC', (('int', None),) ),
    'gdi32.scaleviewportextex':( 'int', None, 'stdcall', 'gdi32.ScaleViewportExtEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.scalewindowextex':( 'int', None, 'stdcall', 'gdi32.ScaleWindowExtEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.selectbrushlocal':( 'int', None, 'stdcall', 'gdi32.SelectBrushLocal', (('int', None), ('int', None)) ),
    'gdi32.selectclippath':( 'int', None, 'stdcall', 'gdi32.SelectClipPath', (('int', None), ('int', None)) ),
    'gdi32.selectcliprgn':( 'int', None, 'stdcall', 'gdi32.SelectClipRgn', (('int', None), ('int', None)) ),
    'gdi32.selectfontlocal':( 'int', None, 'stdcall', 'gdi32.SelectFontLocal', (('int', None), ('int', None)) ),
    'gdi32.selectobject':( 'int', None, 'stdcall', 'gdi32.SelectObject', (('int', None), ('int', None)) ),
    'gdi32.selectpalette':( 'int', None, 'stdcall', 'gdi32.SelectPalette', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setabortproc':( 'int', None, 'stdcall', 'gdi32.SetAbortProc', (('int', None), ('int', None)) ),
    'gdi32.setarcdirection':( 'int', None, 'stdcall', 'gdi32.SetArcDirection', (('int', None), ('int', None)) ),
    'gdi32.setbitmapattributes':( 'int', None, 'stdcall', 'gdi32.SetBitmapAttributes', (('int', None), ('int', None)) ),
    'gdi32.setbitmapbits':( 'int', None, 'stdcall', 'gdi32.SetBitmapBits', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbitmapdimensionex':( 'int', None, 'stdcall', 'gdi32.SetBitmapDimensionEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbkcolor':( 'int', None, 'stdcall', 'gdi32.SetBkColor', (('int', None), ('int', None)) ),
    'gdi32.setbkmode':( 'int', None, 'stdcall', 'gdi32.SetBkMode', (('int', None), ('int', None)) ),
    'gdi32.setboundsrect':( 'int', None, 'stdcall', 'gdi32.SetBoundsRect', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setbrushattributes':( 'int', None, 'stdcall', 'gdi32.SetBrushAttributes', (('int', None), ('int', None)) ),
    'gdi32.setbrushorgex':( 'int', None, 'stdcall', 'gdi32.SetBrushOrgEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setcoloradjustment':( 'int', None, 'stdcall', 'gdi32.SetColorAdjustment', (('int', None), ('int', None)) ),
    'gdi32.setcolorspace':( 'int', None, 'stdcall', 'gdi32.SetColorSpace', (('int', None), ('int', None)) ),
    'gdi32.setdcbrushcolor':( 'int', None, 'stdcall', 'gdi32.SetDCBrushColor', (('int', None), ('int', None)) ),
    'gdi32.setdcpencolor':( 'int', None, 'stdcall', 'gdi32.SetDCPenColor', (('int', None), ('int', None)) ),
    'gdi32.setdibcolortable':( 'int', None, 'stdcall', 'gdi32.SetDIBColorTable', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setdibits':( 'int', None, 'stdcall', 'gdi32.SetDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setdibitstodevice':( 'int', None, 'stdcall', 'gdi32.SetDIBitsToDevice', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.setdevicegammaramp':( 'int', None, 'stdcall', 'gdi32.SetDeviceGammaRamp', (('int', None), ('int', None)) ),
    'gdi32.setenhmetafilebits':( 'int', None, 'stdcall', 'gdi32.SetEnhMetaFileBits', (('int', None), ('int', None)) ),
    'gdi32.setfontenumeration':( 'int', None, 'stdcall', 'gdi32.SetFontEnumeration', (('int', None),) ),
    'gdi32.setgraphicsmode':( 'int', None, 'stdcall', 'gdi32.SetGraphicsMode', (('int', None), ('int', None)) ),
    'gdi32.seticmmode':( 'int', None, 'stdcall', 'gdi32.SetICMMode', (('int', None), ('int', None)) ),
    'gdi32.seticmprofilea':( 'int', None, 'stdcall', 'gdi32.SetICMProfileA', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.seticmprofilew':( 'int', None, 'stdcall', 'gdi32.SetICMProfileW', ( ('int', None), ('void *', 'ptr')) ),
    'gdi32.setlayout':( 'int', None, 'stdcall', 'gdi32.SetLayout', (('int', None), ('int', None)) ),
    'gdi32.setlayoutwidth':( 'int', None, 'stdcall', 'gdi32.SetLayoutWidth', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setmagiccolors':( 'int', None, 'stdcall', 'gdi32.SetMagicColors', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setmapmode':( 'int', None, 'stdcall', 'gdi32.SetMapMode', (('int', None), ('int', None)) ),
    'gdi32.setmapperflags':( 'int', None, 'stdcall', 'gdi32.SetMapperFlags', (('int', None), ('int', None)) ),
    'gdi32.setmetafilebitsex':( 'int', None, 'stdcall', 'gdi32.SetMetaFileBitsEx', (('int', None), ('int', None)) ),
    'gdi32.setmetargn':( 'int', None, 'stdcall', 'gdi32.SetMetaRgn', (('int', None),) ),
    'gdi32.setmiterlimit':( 'int', None, 'stdcall', 'gdi32.SetMiterLimit', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpaletteentries':( 'int', None, 'stdcall', 'gdi32.SetPaletteEntries', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpixel':( 'int', None, 'stdcall', 'gdi32.SetPixel', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpixelformat':( 'int', None, 'stdcall', 'gdi32.SetPixelFormat', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setpixelv':( 'int', None, 'stdcall', 'gdi32.SetPixelV', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setpolyfillmode':( 'int', None, 'stdcall', 'gdi32.SetPolyFillMode', (('int', None), ('int', None)) ),
    'gdi32.setrop2':( 'int', None, 'stdcall', 'gdi32.SetROP2', (('int', None), ('int', None)) ),
    'gdi32.setrectrgn':( 'int', None, 'stdcall', 'gdi32.SetRectRgn', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setrelabs':( 'int', None, 'stdcall', 'gdi32.SetRelAbs', (('int', None), ('int', None)) ),
    'gdi32.setstretchbltmode':( 'int', None, 'stdcall', 'gdi32.SetStretchBltMode', (('int', None), ('int', None)) ),
    'gdi32.setsystempaletteuse':( 'int', None, 'stdcall', 'gdi32.SetSystemPaletteUse', (('int', None), ('int', None)) ),
    'gdi32.settextalign':( 'int', None, 'stdcall', 'gdi32.SetTextAlign', (('int', None), ('int', None)) ),
    'gdi32.settextcharacterextra':( 'int', None, 'stdcall', 'gdi32.SetTextCharacterExtra', (('int', None), ('int', None)) ),
    'gdi32.settextcolor':( 'int', None, 'stdcall', 'gdi32.SetTextColor', (('int', None), ('int', None)) ),
    'gdi32.settextjustification':( 'int', None, 'stdcall', 'gdi32.SetTextJustification', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.setviewportextex':( 'int', None, 'stdcall', 'gdi32.SetViewportExtEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setviewportorgex':( 'int', None, 'stdcall', 'gdi32.SetViewportOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setvirtualresolution':( 'int', None, 'stdcall', 'gdi32.SetVirtualResolution', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setwinmetafilebits':( 'int', None, 'stdcall', 'gdi32.SetWinMetaFileBits', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'gdi32.setwindowextex':( 'int', None, 'stdcall', 'gdi32.SetWindowExtEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setwindoworgex':( 'int', None, 'stdcall', 'gdi32.SetWindowOrgEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.setworldtransform':( 'int', None, 'stdcall', 'gdi32.SetWorldTransform', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startdoca':( 'int', None, 'stdcall', 'gdi32.StartDocA', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startdocw':( 'int', None, 'stdcall', 'gdi32.StartDocW', (('int', None), ('void *', 'ptr')) ),
    'gdi32.startformpage':( 'int', None, 'stdcall', 'gdi32.StartFormPage', (('int', None),) ),
    'gdi32.startpage':( 'int', None, 'stdcall', 'gdi32.StartPage', (('int', None),) ),
    'gdi32.stretchblt':( 'int', None, 'stdcall', 'gdi32.StretchBlt', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.stretchdibits':( 'int', None, 'stdcall', 'gdi32.StretchDIBits', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'gdi32.strokeandfillpath':( 'int', None, 'stdcall', 'gdi32.StrokeAndFillPath', (('int', None),) ),
    'gdi32.strokepath':( 'int', None, 'stdcall', 'gdi32.StrokePath', (('int', None),) ),
    'gdi32.swapbuffers':( 'int', None, 'stdcall', 'gdi32.SwapBuffers', ( ('int', None),) ),
    'gdi32.textouta':( 'int', None, 'stdcall', 'gdi32.TextOutA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'gdi32.textoutw':( 'int', None, 'stdcall', 'gdi32.TextOutW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('DWORD', None)) ),
    'gdi32.translatecharsetinfo':( 'int', None, 'stdcall', 'gdi32.TranslateCharsetInfo', (('int', None), ('int', None), ('int', None)) ),
    'gdi32.unloadnetworkfonts':( 'int', None, 'stdcall', 'gdi32.UnloadNetworkFonts', ( ('int', None),) ),
    'gdi32.unrealizeobject':( 'int', None, 'stdcall', 'gdi32.UnrealizeObject', (('int', None),) ),
    'gdi32.updatecolors':( 'int', None, 'stdcall', 'gdi32.UpdateColors', (('int', None),) ),
    'gdi32.updateicmregkeya':( 'int', None, 'stdcall', 'gdi32.UpdateICMRegKeyA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.updateicmregkeyw':( 'int', None, 'stdcall', 'gdi32.UpdateICMRegKeyW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.widenpath':( 'int', None, 'stdcall', 'gdi32.WidenPath', (('int', None),) ),
    'gdi32.xformobj_bapplyxform':( 'int', None, 'stdcall', 'gdi32.XFORMOBJ_bApplyXform', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.xformobj_igetxform':( 'int', None, 'stdcall', 'gdi32.XFORMOBJ_iGetXform', (('int', None), ('int', None)) ),
    'gdi32.xlateobj_cgetpalette':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_cGetPalette', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'gdi32.xlateobj_hgetcolortransform':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_hGetColorTransform', (('int', None),) ),
    'gdi32.xlateobj_ixlate':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_iXlate', (('int', None), ('int', None)) ),
    'gdi32.xlateobj_pivector':( 'int', None, 'stdcall', 'gdi32.XLATEOBJ_piVector', (('int', None),) ),
    'gdi32.binitsystemandfontsdirectoriesw':( 'int', None, 'stdcall', 'gdi32.bInitSystemAndFontsDirectoriesW', (('int', None), ('int', None)) ),
    'gdi32.bmakepathnamew':( 'int', None, 'stdcall', 'gdi32.bMakePathNameW', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.cgetttffromfot':( 'int', None, 'stdcall', 'gdi32.cGetTTFFromFOT', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'gdi32.gdiplayspoolstream':( 'int', None, 'stdcall', 'gdi32.gdiPlaySpoolStream', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    }
