# APIs for Windows 32-bit ole32 library.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'ole32.main_entry':( 'int', None, 'stdcall', 'ole32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'ole32.bindmoniker':( 'int', None, 'stdcall', 'ole32.BindMoniker', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.clipformat_userfree':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserFree', (('int', None), ('int', None)) ),
    'ole32.clipformat_usermarshal':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clipformat_usersize':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clipformat_userunmarshal':( 'int', None, 'stdcall', 'ole32.CLIPFORMAT_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.clsidfromole1class':( 'int', None, 'stdcall', 'ole32.CLSIDFromOle1Class', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.clsidfromprogid':( 'int', None, 'stdcall', 'ole32.CLSIDFromProgID', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.clsidfromprogidex':( 'int', None, 'stdcall', 'ole32.CLSIDFromProgIDEx', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.clsidfromstring':( 'int', None, 'stdcall', 'ole32.CLSIDFromString', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.coaddrefserverprocess':( 'int', None, 'cdecl', 'ole32.CoAddRefServerProcess', () ),
    'ole32.coallowsetforegroundwindow':( 'int', None, 'stdcall', 'ole32.CoAllowSetForegroundWindow', (('int', None), ('int', None)) ),
    'ole32.cobuildversion':( 'int', None, 'cdecl', 'ole32.CoBuildVersion', () ),
    'ole32.cocancelcall':( 'int', None, 'stdcall', 'ole32.CoCancelCall', (('int', None), ('int', None)) ),
    'ole32.cocopyproxy':( 'int', None, 'stdcall', 'ole32.CoCopyProxy', (('int', None), ('void *', 'ptr')) ),
    'ole32.cocreatefreethreadedmarshaler':( 'int', None, 'stdcall', 'ole32.CoCreateFreeThreadedMarshaler', (('int', None), ('int', None)) ),
    'ole32.cocreateguid':( 'int', None, 'stdcall', 'ole32.CoCreateGuid', (('void *', 'ptr'),) ),
    'ole32.cocreateinstance':( 'int', None, 'stdcall', 'ole32.CoCreateInstance', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cocreateinstanceex':( 'int', None, 'stdcall', 'ole32.CoCreateInstanceEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cocreateobjectincontext':( 'int', None, 'stdcall', 'ole32.CoCreateObjectInContext', (('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.codeactivateobject':( 'int', None, 'stdcall', 'ole32.CoDeactivateObject', (('int', None), ('int', None)) ),
    'ole32.codisablecallcancellation':( 'int', None, 'stdcall', 'ole32.CoDisableCallCancellation', (('int', None),) ),
    'ole32.codisconnectobject':( 'int', None, 'stdcall', 'ole32.CoDisconnectObject', ( ('int', None), ('int', None)) ),
    'ole32.codosdatetimetofiletime':( 'int', None, 'stdcall', 'ole32.CoDosDateTimeToFileTime', (('int', None), ('int', None), ('int', None)) ),
    'ole32.coenablecallcancellation':( 'int', None, 'stdcall', 'ole32.CoEnableCallCancellation', (('int', None),) ),
    'ole32.cofiletimenow':( 'int', None, 'stdcall', 'ole32.CoFileTimeNow', (('void *', 'ptr'),) ),
    'ole32.cofiletimetodosdatetime':( 'int', None, 'stdcall', 'ole32.CoFileTimeToDosDateTime', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cofreealllibraries':( 'int', None, 'cdecl', 'ole32.CoFreeAllLibraries', () ),
    'ole32.cofreelibrary':( 'int', None, 'cdecl', 'ole32.CoFreeLibrary', () ),
    'ole32.cofreeunusedlibraries':( 'int', None, 'cdecl', 'ole32.CoFreeUnusedLibraries', () ),
    'ole32.cofreeunusedlibrariesex':( 'int', None, 'stdcall', 'ole32.CoFreeUnusedLibrariesEx', (('int', None), ('int', None)) ),
    'ole32.cogetapartmentid':( 'int', None, 'stdcall', 'ole32.CoGetApartmentID', (('int', None), ('int', None)) ),
    'ole32.cogetcallcontext':( 'int', None, 'stdcall', 'ole32.CoGetCallContext', (('int', None), ('void *', 'ptr')) ),
    'ole32.cogetcallertid':( 'int', None, 'stdcall', 'ole32.CoGetCallerTID', (('int', None),) ),
    'ole32.cogetcancelobject':( 'int', None, 'stdcall', 'ole32.CoGetCancelObject', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetclassobject':( 'int', None, 'stdcall', 'ole32.CoGetClassObject', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetclassversion':( 'int', None, 'stdcall', 'ole32.CoGetClassVersion', (('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetcomcatalog':( 'int', None, 'stdcall', 'ole32.CoGetComCatalog', (('int', None), ('void *', 'ptr')) ),
    'ole32.cogetcontexttoken':( 'int', None, 'stdcall', 'ole32.CoGetContextToken', (('int', None),) ),
    'ole32.cogetcurrentlogicalthreadid':( 'int', None, 'stdcall', 'ole32.CoGetCurrentLogicalThreadId', (('int', None),) ),
    'ole32.cogetcurrentprocess':( 'int', None, 'cdecl', 'ole32.CoGetCurrentProcess', () ),
    'ole32.cogetdefaultcontext':( 'int', None, 'stdcall', 'ole32.CoGetDefaultContext', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinstancefromfile':( 'int', None, 'stdcall', 'ole32.CoGetInstanceFromFile', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('StringW', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinstancefromistorage':( 'int', None, 'stdcall', 'ole32.CoGetInstanceFromIStorage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinterceptor':( 'int', None, 'stdcall', 'ole32.CoGetInterceptor', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetinterceptorfromtypeinfo':( 'int', None, 'stdcall', 'ole32.CoGetInterceptorFromTypeInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetinterfaceandreleasestream':( 'int', None, 'stdcall', 'ole32.CoGetInterfaceAndReleaseStream', ( ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.cogetmalloc':( 'int', None, 'stdcall', 'ole32.CoGetMalloc', (('int', None), ('int', None)) ),
    'ole32.cogetmarshalsizemax':( 'int', None, 'stdcall', 'ole32.CoGetMarshalSizeMax', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.cogetobject':( 'int', None, 'stdcall', 'ole32.CoGetObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetobjectcontext':( 'int', None, 'stdcall', 'ole32.CoGetObjectContext', ( ('int', None), ('int', None)) ),
    'ole32.cogetpsclsid':( 'int', None, 'stdcall', 'ole32.CoGetPSClsid', ( ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetprocessidentifier':( 'int', None, 'stdcall', 'ole32.CoGetProcessIdentifier', (('int', None),) ),
    'ole32.cogetstandardmarshal':( 'int', None, 'stdcall', 'ole32.CoGetStandardMarshal', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cogetstate':( 'int', None, 'stdcall', 'ole32.CoGetState', (('int', None),) ),
    'ole32.cogetstdmarshalex':( 'int', None, 'stdcall', 'ole32.CoGetStdMarshalEx', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.cogetsystemsecuritypermissions':( 'int', None, 'stdcall', 'ole32.CoGetSystemSecurityPermissions', (('DWORD', None), ('int', None)) ),
    'ole32.cogettreatasclass':( 'int', None, 'stdcall', 'ole32.CoGetTreatAsClass', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.coimpersonateclient':( 'int', None, 'stdcall', 'ole32.CoImpersonateClient', () ),
    'ole32.coinitialize':( 'int', None, 'stdcall', 'ole32.CoInitialize', (('int', None),) ),
    'ole32.coinitializeex':( 'int', None, 'stdcall', 'ole32.CoInitializeEx', (('int', None), ('int', None)) ),
    'ole32.coinitializesecurity':( 'int', None, 'stdcall', 'ole32.CoInitializeSecurity', (('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coinitializewow':( 'int', None, 'stdcall', 'ole32.CoInitializeWOW', (('int', None), ('int', None)) ),
    'ole32.coinstall':( 'int', None, 'stdcall', 'ole32.CoInstall', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coinvalidateremotemachinebindings':( 'int', None, 'stdcall', 'ole32.CoInvalidateRemoteMachineBindings', (('int', None),) ),
    'ole32.coishandlerconnected':( 'int', None, 'stdcall', 'ole32.CoIsHandlerConnected', (('int', None),) ),
    'ole32.coisole1class':( 'int', None, 'stdcall', 'ole32.CoIsOle1Class', (('void *', 'ptr'),) ),
    'ole32.coloadlibrary':( 'int', None, 'stdcall', 'ole32.CoLoadLibrary', (('int', None), ('int', None)) ),
    'ole32.colockobjectexternal':( 'int', None, 'stdcall', 'ole32.CoLockObjectExternal', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.comarshalhresult':( 'int', None, 'stdcall', 'ole32.CoMarshalHresult', (('int', None), ('int', None)) ),
    'ole32.comarshalinterthreadinterfaceinstream':( 'int', None, 'stdcall', 'ole32.CoMarshalInterThreadInterfaceInStream', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.comarshalinterface':( 'int', None, 'stdcall', 'ole32.CoMarshalInterface', ( ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.copopservicedomain':( 'int', None, 'stdcall', 'ole32.CoPopServiceDomain', (('int', None),) ),
    'ole32.copushservicedomain':( 'int', None, 'stdcall', 'ole32.CoPushServiceDomain', (('int', None),) ),
    'ole32.coqueryauthenticationservices':( 'int', None, 'stdcall', 'ole32.CoQueryAuthenticationServices', (('int', None), ('int', None)) ),
    'ole32.coqueryclientblanket':( 'int', None, 'stdcall', 'ole32.CoQueryClientBlanket', ( ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.coqueryproxyblanket':( 'int', None, 'stdcall', 'ole32.CoQueryProxyBlanket', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coqueryreleaseobject':( 'int', None, 'stdcall', 'ole32.CoQueryReleaseObject', (('int', None),) ),
    'ole32.coreactivateobject':( 'int', None, 'stdcall', 'ole32.CoReactivateObject', ( ('int', None),) ),
    'ole32.coregisterchannelhook':( 'int', None, 'stdcall', 'ole32.CoRegisterChannelHook', (('int', None), ('int', None)) ),
    'ole32.coregisterclassobject':( 'int', None, 'stdcall', 'ole32.CoRegisterClassObject', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.coregisterinitializespy':( 'int', None, 'stdcall', 'ole32.CoRegisterInitializeSpy', (('int', None), ('int', None)) ),
    'ole32.coregistermallocspy':( 'int', None, 'stdcall', 'ole32.CoRegisterMallocSpy', ( ('int', None),) ),
    'ole32.coregistermessagefilter':( 'int', None, 'stdcall', 'ole32.CoRegisterMessageFilter', (('int', None), ('int', None)) ),
    'ole32.coregisterpsclsid':( 'int', None, 'stdcall', 'ole32.CoRegisterPSClsid', ( ('void *', 'ptr'), ('int', None)) ),
    'ole32.coregistersurrogate':( 'int', None, 'stdcall', 'ole32.CoRegisterSurrogate', (('int', None),) ),
    'ole32.coregistersurrogateex':( 'int', None, 'stdcall', 'ole32.CoRegisterSurrogateEx', ( ('int', None), ('int', None)) ),
    'ole32.coreleasemarshaldata':( 'int', None, 'stdcall', 'ole32.CoReleaseMarshalData', ( ('void *', 'ptr'),) ),
    'ole32.coreleaseserverprocess':( 'int', None, 'cdecl', 'ole32.CoReleaseServerProcess', () ),
    'ole32.coresumeclassobjects':( 'int', None, 'cdecl', 'ole32.CoResumeClassObjects', () ),
    'ole32.coretireserver':( 'int', None, 'stdcall', 'ole32.CoRetireServer', (('int', None),) ),
    'ole32.coreverttoself':( 'int', None, 'stdcall', 'ole32.CoRevertToSelf', () ),
    'ole32.corevokeclassobject':( 'int', None, 'stdcall', 'ole32.CoRevokeClassObject', (('int', None),) ),
    'ole32.corevokeinitializespy':( 'int', None, 'stdcall', 'ole32.CoRevokeInitializeSpy', (('int', None), ('int', None)) ),
    'ole32.corevokemallocspy':( 'int', None, 'cdecl', 'ole32.CoRevokeMallocSpy', () ),
    'ole32.cosetcancelobject':( 'int', None, 'stdcall', 'ole32.CoSetCancelObject', (('int', None),) ),
    'ole32.cosetproxyblanket':( 'int', None, 'stdcall', 'ole32.CoSetProxyBlanket', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.cosetstate':( 'int', None, 'stdcall', 'ole32.CoSetState', (('int', None),) ),
    'ole32.cosuspendclassobjects':( 'int', None, 'cdecl', 'ole32.CoSuspendClassObjects', () ),
    'ole32.coswitchcallcontext':( 'int', None, 'stdcall', 'ole32.CoSwitchCallContext', (('int', None), ('int', None)) ),
    'ole32.cotaskmemalloc':( 'int', None, 'stdcall', 'ole32.CoTaskMemAlloc', (('int', None),) ),
    'ole32.cotaskmemfree':( 'int', None, 'stdcall', 'ole32.CoTaskMemFree', (('void *', 'ptr'),) ),
    'ole32.cotaskmemrealloc':( 'int', None, 'stdcall', 'ole32.CoTaskMemRealloc', (('int', None), ('int', None)) ),
    'ole32.cotestcancel':( 'int', None, 'stdcall', 'ole32.CoTestCancel', () ),
    'ole32.cotreatasclass':( 'int', None, 'stdcall', 'ole32.CoTreatAsClass', (('int', None), ('void *', 'ptr')) ),
    'ole32.couninitialize':( 'int', None, 'cdecl', 'ole32.CoUninitialize', () ),
    'ole32.counloadingwow':( 'int', None, 'stdcall', 'ole32.CoUnloadingWOW', (('int', None),) ),
    'ole32.counmarshalhresult':( 'int', None, 'stdcall', 'ole32.CoUnmarshalHresult', (('int', None), ('int', None)) ),
    'ole32.counmarshalinterface':( 'int', None, 'stdcall', 'ole32.CoUnmarshalInterface', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.cowaitformultiplehandles':( 'int', None, 'stdcall', 'ole32.CoWaitForMultipleHandles', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.comps_cstdstubbuffer_addref':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_AddRef', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_connect':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Connect', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_countrefs':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_CountRefs', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_debugserverqueryinterface':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_DebugServerQueryInterface', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_debugserverrelease':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_DebugServerRelease', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_disconnect':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Disconnect', (('int', None),) ),
    'ole32.comps_cstdstubbuffer_invoke':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_Invoke', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_isiidsupported':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_IsIIDSupported', (('int', None), ('int', None)) ),
    'ole32.comps_cstdstubbuffer_queryinterface':( 'int', None, 'stdcall', 'ole32.ComPs_CStdStubBuffer_QueryInterface', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_iunknown_addref_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_AddRef_Proxy', (('int', None),) ),
    'ole32.comps_iunknown_queryinterface_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_QueryInterface_Proxy', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_iunknown_release_proxy':( 'int', None, 'stdcall', 'ole32.ComPs_IUnknown_Release_Proxy', (('int', None),) ),
    'ole32.comps_ndrcstdstubbuffer2_release':( 'int', None, 'stdcall', 'ole32.ComPs_NdrCStdStubBuffer2_Release', (('int', None), ('int', None)) ),
    'ole32.comps_ndrcstdstubbuffer_release':( 'int', None, 'stdcall', 'ole32.ComPs_NdrCStdStubBuffer_Release', (('int', None), ('int', None)) ),
    'ole32.comps_ndrclientcall2':( 'int', None, 'cdecl', 'ole32.ComPs_NdrClientCall2', (('int', None), ('int', None)) ),
    'ole32.comps_ndrclientcall2_va':( 'int', None, 'stdcall', 'ole32.ComPs_NdrClientCall2_va', (('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllcanunloadnow':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllCanUnloadNow', (('int', None),) ),
    'ole32.comps_ndrdllgetclassobject':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllGetClassObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllregisterproxy':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllRegisterProxy', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrdllunregisterproxy':( 'int', None, 'stdcall', 'ole32.ComPs_NdrDllUnregisterProxy', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrstubcall2':( 'int', None, 'stdcall', 'ole32.ComPs_NdrStubCall2', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.comps_ndrstubforwardingfunction':( 'int', None, 'stdcall', 'ole32.ComPs_NdrStubForwardingFunction', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.createantimoniker':( 'int', None, 'stdcall', 'ole32.CreateAntiMoniker', (('int', None),) ),
    'ole32.createbindctx':( 'int', None, 'stdcall', 'ole32.CreateBindCtx', (('int', None), ('void *', 'ptr')) ),
    'ole32.createclassmoniker':( 'int', None, 'stdcall', 'ole32.CreateClassMoniker', (('int', None), ('int', None)) ),
    'ole32.createdataadviseholder':( 'int', None, 'stdcall', 'ole32.CreateDataAdviseHolder', (('int', None),) ),
    'ole32.createdatacache':( 'int', None, 'stdcall', 'ole32.CreateDataCache', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.createerrorinfo':( 'int', None, 'stdcall', 'ole32.CreateErrorInfo', (('int', None),) ),
    'ole32.createfilemoniker':( 'int', None, 'stdcall', 'ole32.CreateFileMoniker', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.creategenericcomposite':( 'int', None, 'stdcall', 'ole32.CreateGenericComposite', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.createilockbytesonhglobal':( 'int', None, 'stdcall', 'ole32.CreateILockBytesOnHGlobal', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.createitemmoniker':( 'int', None, 'stdcall', 'ole32.CreateItemMoniker', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.createobjrefmoniker':( 'int', None, 'stdcall', 'ole32.CreateObjrefMoniker', (('int', None), ('int', None)) ),
    'ole32.createoleadviseholder':( 'int', None, 'stdcall', 'ole32.CreateOleAdviseHolder', (('int', None),) ),
    'ole32.createpointermoniker':( 'int', None, 'stdcall', 'ole32.CreatePointerMoniker', (('int', None), ('int', None)) ),
    'ole32.createstdprogressindicator':( 'int', None, 'stdcall', 'ole32.CreateStdProgressIndicator', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.createstreamonhglobal':( 'int', None, 'stdcall', 'ole32.CreateStreamOnHGlobal', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.dcomchannelsethresult':( 'int', None, 'stdcall', 'ole32.DcomChannelSetHResult', (('int', None), ('int', None), ('int', None)) ),
    'ole32.dlldebugobjectrpchook':( 'int', None, 'stdcall', 'ole32.DllDebugObjectRPCHook', (('int', None), ('int', None)) ),
    'ole32.dllgetclassobject':( 'int', None, 'stdcall', 'ole32.DllGetClassObject', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.dllgetclassobjectwow':( 'int', None, 'stdcall', 'ole32.DllGetClassObjectWOW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.dllregisterserver':( 'int', None, 'stdcall', 'ole32.DllRegisterServer', () ),
    'ole32.dodragdrop':( 'int', None, 'stdcall', 'ole32.DoDragDrop', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.enablehookobject':( 'int', None, 'stdcall', 'ole32.EnableHookObject', (('int', None), ('int', None)) ),
    'ole32.fmtidtopropstgname':( 'int', None, 'stdcall', 'ole32.FmtIdToPropStgName', (('int', None), ('int', None)) ),
    'ole32.freepropvariantarray':( 'int', None, 'stdcall', 'ole32.FreePropVariantArray', (('int', None), ('int', None)) ),
    'ole32.getclassfile':( 'int', None, 'stdcall', 'ole32.GetClassFile', (('StringW', None), ('void *', 'ptr')) ),
    'ole32.getconvertstg':( 'int', None, 'stdcall', 'ole32.GetConvertStg', (('int', None),) ),
    'ole32.getdocumentbitstg':( 'int', None, 'stdcall', 'ole32.GetDocumentBitStg', (('int', None),) ),
    'ole32.geterrorinfo':( 'int', None, 'stdcall', 'ole32.GetErrorInfo', (('int', None), ('int', None)) ),
    'ole32.gethglobalfromilockbytes':( 'int', None, 'stdcall', 'ole32.GetHGlobalFromILockBytes', (('int', None), ('void *', 'ptr')) ),
    'ole32.gethglobalfromstream':( 'int', None, 'stdcall', 'ole32.GetHGlobalFromStream', (('int', None), ('void *', 'ptr')) ),
    'ole32.gethookinterface':( 'int', None, 'stdcall', 'ole32.GetHookInterface', (('int', None),) ),
    'ole32.getrunningobjecttable':( 'int', None, 'stdcall', 'ole32.GetRunningObjectTable', (('int', None), ('void *', 'ptr')) ),
    'ole32.haccel_userfree':( 'int', None, 'stdcall', 'ole32.HACCEL_UserFree', (('int', None), ('int', None)) ),
    'ole32.haccel_usermarshal':( 'int', None, 'stdcall', 'ole32.HACCEL_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.haccel_usersize':( 'int', None, 'stdcall', 'ole32.HACCEL_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.haccel_userunmarshal':( 'int', None, 'stdcall', 'ole32.HACCEL_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_userfree':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserFree', (('int', None), ('int', None)) ),
    'ole32.hbitmap_usermarshal':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_usersize':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbitmap_userunmarshal':( 'int', None, 'stdcall', 'ole32.HBITMAP_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_userfree':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserFree', (('int', None), ('int', None)) ),
    'ole32.hbrush_usermarshal':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_usersize':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hbrush_userunmarshal':( 'int', None, 'stdcall', 'ole32.HBRUSH_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_userfree':( 'int', None, 'stdcall', 'ole32.HDC_UserFree', (('int', None), ('int', None)) ),
    'ole32.hdc_usermarshal':( 'int', None, 'stdcall', 'ole32.HDC_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_usersize':( 'int', None, 'stdcall', 'ole32.HDC_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hdc_userunmarshal':( 'int', None, 'stdcall', 'ole32.HDC_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_userfree':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserFree', (('int', None), ('int', None)) ),
    'ole32.henhmetafile_usermarshal':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_usersize':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.henhmetafile_userunmarshal':( 'int', None, 'stdcall', 'ole32.HENHMETAFILE_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_userfree':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserFree', (('int', None), ('int', None)) ),
    'ole32.hglobal_usermarshal':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_usersize':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hglobal_userunmarshal':( 'int', None, 'stdcall', 'ole32.HGLOBAL_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_userfree':( 'int', None, 'stdcall', 'ole32.HICON_UserFree', (('int', None), ('int', None)) ),
    'ole32.hicon_usermarshal':( 'int', None, 'stdcall', 'ole32.HICON_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_usersize':( 'int', None, 'stdcall', 'ole32.HICON_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hicon_userunmarshal':( 'int', None, 'stdcall', 'ole32.HICON_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_userfree':( 'int', None, 'stdcall', 'ole32.HMENU_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmenu_usermarshal':( 'int', None, 'stdcall', 'ole32.HMENU_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_usersize':( 'int', None, 'stdcall', 'ole32.HMENU_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmenu_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMENU_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_userfree':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmetafilepict_usermarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_usersize':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafilepict_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILEPICT_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_userfree':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserFree', (('int', None), ('int', None)) ),
    'ole32.hmetafile_usermarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_usersize':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hmetafile_userunmarshal':( 'int', None, 'stdcall', 'ole32.HMETAFILE_UserUnmarshal', (('int', None), ('int', None)) ),
    'ole32.hpalette_userfree':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserFree', (('int', None), ('int', None)) ),
    'ole32.hpalette_usermarshal':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hpalette_usersize':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hpalette_userunmarshal':( 'int', None, 'stdcall', 'ole32.HPALETTE_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_userfree':( 'int', None, 'stdcall', 'ole32.HWND_UserFree', (('int', None), ('int', None)) ),
    'ole32.hwnd_usermarshal':( 'int', None, 'stdcall', 'ole32.HWND_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_usersize':( 'int', None, 'stdcall', 'ole32.HWND_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hwnd_userunmarshal':( 'int', None, 'stdcall', 'ole32.HWND_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.hkoleregisterobject':( 'int', None, 'stdcall', 'ole32.HkOleRegisterObject', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.iidfromstring':( 'int', None, 'stdcall', 'ole32.IIDFromString', (('int', None), ('int', None)) ),
    'ole32.isaccelerator':( 'int', None, 'stdcall', 'ole32.IsAccelerator', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'ole32.isequalguid':( 'int', None, 'stdcall', 'ole32.IsEqualGUID', (('int', None), ('int', None)) ),
    'ole32.isvalidiid':( 'int', None, 'stdcall', 'ole32.IsValidIid', (('int', None),) ),
    'ole32.isvalidinterface':( 'int', None, 'stdcall', 'ole32.IsValidInterface', (('int', None),) ),
    'ole32.isvalidptrin':( 'int', None, 'stdcall', 'ole32.IsValidPtrIn', (('int', None), ('int', None)) ),
    'ole32.isvalidptrout':( 'int', None, 'stdcall', 'ole32.IsValidPtrOut', (('int', None), ('int', None)) ),
    'ole32.mkparsedisplayname':( 'int', None, 'stdcall', 'ole32.MkParseDisplayName', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.monikercommonprefixwith':( 'int', None, 'stdcall', 'ole32.MonikerCommonPrefixWith', (('int', None), ('int', None), ('int', None)) ),
    'ole32.monikerrelativepathto':( 'int', None, 'stdcall', 'ole32.MonikerRelativePathTo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.olebuildversion':( 'int', None, 'cdecl', 'ole32.OleBuildVersion', () ),
    'ole32.oleconvertistoragetoolestream':( 'int', None, 'stdcall', 'ole32.OleConvertIStorageToOLESTREAM', (('int', None), ('int', None)) ),
    'ole32.oleconvertistoragetoolestreamex':( 'int', None, 'stdcall', 'ole32.OleConvertIStorageToOLESTREAMEx', (('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None)) ),
    'ole32.oleconvertolestreamtoistorage':( 'int', None, 'stdcall', 'ole32.OleConvertOLESTREAMToIStorage', (('int', None), ('int', None), ('int', None)) ),
    'ole32.oleconvertolestreamtoistorageex':( 'int', None, 'stdcall', 'ole32.OleConvertOLESTREAMToIStorageEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreate':( 'int', None, 'stdcall', 'ole32.OleCreate', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreatedefaulthandler':( 'int', None, 'stdcall', 'ole32.OleCreateDefaultHandler', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreateembeddinghelper':( 'int', None, 'stdcall', 'ole32.OleCreateEmbeddingHelper', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreateex':( 'int', None, 'stdcall', 'ole32.OleCreateEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.olecreatefromdata':( 'int', None, 'stdcall', 'ole32.OleCreateFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromdataex':( 'int', None, 'stdcall', 'ole32.OleCreateFromDataEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromfile':( 'int', None, 'stdcall', 'ole32.OleCreateFromFile', (('void *', 'ptr'), ('StringW', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatefromfileex':( 'int', None, 'stdcall', 'ole32.OleCreateFromFileEx', ( ('void *', 'ptr'), ('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelink':( 'int', None, 'stdcall', 'ole32.OleCreateLink', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkfromdata':( 'int', None, 'stdcall', 'ole32.OleCreateLinkFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinkfromdataex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkFromDataEx', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinktofile':( 'int', None, 'stdcall', 'ole32.OleCreateLinkToFile', (('StringW', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatelinktofileex':( 'int', None, 'stdcall', 'ole32.OleCreateLinkToFileEx', ( ('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'ole32.olecreatemenudescriptor':( 'int', None, 'stdcall', 'ole32.OleCreateMenuDescriptor', (('int', None), ('int', None)) ),
    'ole32.olecreatestaticfromdata':( 'int', None, 'stdcall', 'ole32.OleCreateStaticFromData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oledestroymenudescriptor':( 'int', None, 'stdcall', 'ole32.OleDestroyMenuDescriptor', (('void *', 'ptr'),) ),
    'ole32.oledoautoconvert':( 'int', None, 'msfastcall', 'ole32.OleDoAutoConvert', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.oledraw':( 'int', None, 'stdcall', 'ole32.OleDraw', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oleduplicatedata':( 'int', None, 'stdcall', 'ole32.OleDuplicateData', (('int', None), ('int', None), ('int', None)) ),
    'ole32.oleflushclipboard':( 'int', None, 'cdecl', 'ole32.OleFlushClipboard', () ),
    'ole32.olegetautoconvert':( 'int', None, 'stdcall', 'ole32.OleGetAutoConvert', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.olegetclipboard':( 'int', None, 'stdcall', 'ole32.OleGetClipboard', (('int', None),) ),
    'ole32.olegeticonofclass':( 'int', None, 'stdcall', 'ole32.OleGetIconOfClass', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.olegeticonoffile':( 'int', None, 'stdcall', 'ole32.OleGetIconOfFile', (('StringW', None), ('int', None)) ),
    'ole32.oleinitialize':( 'int', None, 'stdcall', 'ole32.OleInitialize', (('int', None),) ),
    'ole32.oleinitializewow':( 'int', None, 'stdcall', 'ole32.OleInitializeWOW', (('int', None), ('int', None)) ),
    'ole32.oleiscurrentclipboard':( 'int', None, 'stdcall', 'ole32.OleIsCurrentClipboard', (('int', None),) ),
    'ole32.oleisrunning':( 'int', None, 'stdcall', 'ole32.OleIsRunning', (('int', None),) ),
    'ole32.oleload':( 'int', None, 'msfastcall', 'ole32.OleLoad', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oleloadfromstream':( 'int', None, 'stdcall', 'ole32.OleLoadFromStream', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.olelockrunning':( 'int', None, 'stdcall', 'ole32.OleLockRunning', (('int', None), ('int', None), ('int', None)) ),
    'ole32.olemetafilepictfromiconandlabel':( 'int', None, 'stdcall', 'ole32.OleMetafilePictFromIconAndLabel', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'ole32.olenoteobjectvisible':( 'int', None, 'stdcall', 'ole32.OleNoteObjectVisible', ( ('int', None), ('int', None)) ),
    'ole32.olequerycreatefromdata':( 'int', None, 'stdcall', 'ole32.OleQueryCreateFromData', (('int', None),) ),
    'ole32.olequerylinkfromdata':( 'int', None, 'stdcall', 'ole32.OleQueryLinkFromData', (('int', None),) ),
    'ole32.oleregenumformatetc':( 'int', None, 'stdcall', 'ole32.OleRegEnumFormatEtc', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.oleregenumverbs':( 'int', None, 'stdcall', 'ole32.OleRegEnumVerbs', (('void *', 'ptr'), ('int', None)) ),
    'ole32.olereggetmiscstatus':( 'int', None, 'stdcall', 'ole32.OleRegGetMiscStatus', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'ole32.olereggetusertype':( 'int', None, 'stdcall', 'ole32.OleRegGetUserType', (('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'ole32.olerun':( 'int', None, 'stdcall', 'ole32.OleRun', (('int', None),) ),
    'ole32.olesave':( 'int', None, 'stdcall', 'ole32.OleSave', (('int', None), ('int', None), ('int', None)) ),
    'ole32.olesavetostream':( 'int', None, 'stdcall', 'ole32.OleSaveToStream', (('int', None), ('int', None)) ),
    'ole32.olesetautoconvert':( 'int', None, 'stdcall', 'ole32.OleSetAutoConvert', (('void *', 'ptr'), ('int', None)) ),
    'ole32.olesetclipboard':( 'int', None, 'stdcall', 'ole32.OleSetClipboard', ( ('int', None),) ),
    'ole32.olesetcontainedobject':( 'int', None, 'stdcall', 'ole32.OleSetContainedObject', (('int', None), ('int', None)) ),
    'ole32.olesetmenudescriptor':( 'int', None, 'stdcall', 'ole32.OleSetMenuDescriptor', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.oletranslateaccelerator':( 'int', None, 'stdcall', 'ole32.OleTranslateAccelerator', (('int', None), ('int', None), ('void *', 'obj')) ),
    'ole32.oleuninitialize':( 'int', None, 'cdecl', 'ole32.OleUninitialize', () ),
    'ole32.openorcreatestream':( 'int', None, 'stdcall', 'ole32.OpenOrCreateStream', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.progidfromclsid':( 'int', None, 'stdcall', 'ole32.ProgIDFromCLSID', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.propstgnametofmtid':( 'int', None, 'stdcall', 'ole32.PropStgNameToFmtId', (('int', None), ('int', None)) ),
    'ole32.propsysallocstring':( 'int', None, 'stdcall', 'ole32.PropSysAllocString', (('void *', 'ptr'),) ),
    'ole32.propsysfreestring':( 'int', None, 'stdcall', 'ole32.PropSysFreeString', (('int', None),) ),
    'ole32.propvariantchangetype':( 'int', None, 'stdcall', 'ole32.PropVariantChangeType', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.propvariantclear':( 'int', None, 'stdcall', 'ole32.PropVariantClear', (('void *', 'ptr'),) ),
    'ole32.propvariantcopy':( 'int', None, 'stdcall', 'ole32.PropVariantCopy', (('void *', 'ptr'), ('int', None)) ),
    'ole32.readclassstg':( 'int', None, 'stdcall', 'ole32.ReadClassStg', (('int', None), ('void *', 'ptr')) ),
    'ole32.readclassstm':( 'int', None, 'stdcall', 'ole32.ReadClassStm', (('int', None), ('void *', 'ptr')) ),
    'ole32.readfmtusertypestg':( 'int', None, 'stdcall', 'ole32.ReadFmtUserTypeStg', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.readolestg':( 'int', None, 'stdcall', 'ole32.ReadOleStg', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.readstringstream':( 'int', None, 'stdcall', 'ole32.ReadStringStream', ( ('void *', 'ptr'),) ),
    'ole32.registerdragdrop':( 'int', None, 'stdcall', 'ole32.RegisterDragDrop', (('int', None), ('int', None)) ),
    'ole32.releasestgmedium':( 'int', None, 'stdcall', 'ole32.ReleaseStgMedium', (('void *', 'ptr'),) ),
    'ole32.revokedragdrop':( 'int', None, 'stdcall', 'ole32.RevokeDragDrop', (('int', None),) ),
    'ole32.snb_userfree':( 'int', None, 'stdcall', 'ole32.SNB_UserFree', (('int', None), ('int', None)) ),
    'ole32.snb_usermarshal':( 'int', None, 'stdcall', 'ole32.SNB_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.snb_usersize':( 'int', None, 'stdcall', 'ole32.SNB_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.snb_userunmarshal':( 'int', None, 'stdcall', 'ole32.SNB_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_userfree':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserFree', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'ole32.stgmedium_usermarshal':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserMarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_usersize':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserSize', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgmedium_userunmarshal':( 'int', None, 'stdcall', 'ole32.STGMEDIUM_UserUnmarshal', (('int', None), ('int', None), ('int', None)) ),
    'ole32.setconvertstg':( 'int', None, 'msfastcall', 'ole32.SetConvertStg', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.setdocumentbitstg':( 'int', None, 'msfastcall', 'ole32.SetDocumentBitStg', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.seterrorinfo':( 'int', None, 'stdcall', 'ole32.SetErrorInfo', (('int', None), ('int', None)) ),
    'ole32.stgconvertpropertytovariant':( 'int', None, 'stdcall', 'ole32.StgConvertPropertyToVariant', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgconvertvarianttoproperty':( 'int', None, 'stdcall', 'ole32.StgConvertVariantToProperty', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatedocfile':( 'int', None, 'stdcall', 'ole32.StgCreateDocfile', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatedocfileonilockbytes':( 'int', None, 'stdcall', 'ole32.StgCreateDocfileOnILockBytes', ( ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.stgcreatepropsetstg':( 'int', None, 'stdcall', 'ole32.StgCreatePropSetStg', (('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatepropstg':( 'int', None, 'stdcall', 'ole32.StgCreatePropStg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgcreatestorageex':( 'int', None, 'stdcall', 'ole32.StgCreateStorageEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stggetifilllockbytesonfile':( 'int', None, 'stdcall', 'ole32.StgGetIFillLockBytesOnFile', ( ('int', None), ('int', None)) ),
    'ole32.stggetifilllockbytesonilockbytes':( 'int', None, 'stdcall', 'ole32.StgGetIFillLockBytesOnILockBytes', (('int', None), ('int', None)) ),
    'ole32.stgisstoragefile':( 'int', None, 'stdcall', 'ole32.StgIsStorageFile', (('StringW', None),) ),
    'ole32.stgisstorageilockbytes':( 'int', None, 'stdcall', 'ole32.StgIsStorageILockBytes', (('int', None),) ),
    'ole32.stgopenasyncdocfileonifilllockbytes':( 'int', None, 'stdcall', 'ole32.StgOpenAsyncDocfileOnIFillLockBytes', ( ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenpropstg':( 'int', None, 'stdcall', 'ole32.StgOpenPropStg', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorage':( 'int', None, 'stdcall', 'ole32.StgOpenStorage', (('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageex':( 'int', None, 'stdcall', 'ole32.StgOpenStorageEx', (('StringW', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageonhandle':( 'int', None, 'stdcall', 'ole32.StgOpenStorageOnHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgopenstorageonilockbytes':( 'int', None, 'stdcall', 'ole32.StgOpenStorageOnILockBytes', ( ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'ole32.stgpropertylengthasvariant':( 'int', None, 'stdcall', 'ole32.StgPropertyLengthAsVariant', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stgsettimes':( 'int', None, 'stdcall', 'ole32.StgSetTimes', (('StringW', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.stringfromclsid':( 'int', None, 'stdcall', 'ole32.StringFromCLSID', (('int', None), ('void *', 'ptr')) ),
    'ole32.stringfromguid2':( 'int', None, 'stdcall', 'ole32.StringFromGUID2', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.stringfromiid':( 'int', None, 'stdcall', 'ole32.StringFromIID', (('int', None), ('int', None)) ),
    'ole32.updatedcomsettings':( 'int', None, 'cdecl', 'ole32.UpdateDCOMSettings', () ),
    'ole32.utconvertdvtd16todvtd32':( 'int', None, 'stdcall', 'ole32.UtConvertDvtd16toDvtd32', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.utconvertdvtd32todvtd16':( 'int', None, 'stdcall', 'ole32.UtConvertDvtd32toDvtd16', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'ole32.utgetdvtd16info':( 'int', None, 'stdcall', 'ole32.UtGetDvtd16Info', (('int', None), ('void *', 'ptr')) ),
    'ole32.utgetdvtd32info':( 'int', None, 'stdcall', 'ole32.UtGetDvtd32Info', (('int', None), ('void *', 'ptr')) ),
    'ole32.wdtpinterfacepointer_userfree':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserFree', (('int', None),) ),
    'ole32.wdtpinterfacepointer_usermarshal':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserMarshal', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.wdtpinterfacepointer_usersize':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserSize', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.wdtpinterfacepointer_userunmarshal':( 'int', None, 'stdcall', 'ole32.WdtpInterfacePointer_UserUnmarshal', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.writeclassstg':( 'int', None, 'stdcall', 'ole32.WriteClassStg', (('int', None), ('void *', 'ptr')) ),
    'ole32.writeclassstm':( 'int', None, 'stdcall', 'ole32.WriteClassStm', (('int', None), ('void *', 'ptr')) ),
    'ole32.writefmtusertypestg':( 'int', None, 'stdcall', 'ole32.WriteFmtUserTypeStg', (('int', None), ('int', None), ('int', None)) ),
    'ole32.writeolestg':( 'int', None, 'stdcall', 'ole32.WriteOleStg', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'ole32.writestringstream':( 'int', None, 'stdcall', 'ole32.WriteStringStream', ( ('void *', 'ptr'),) ),
    }
