The Voltron package and its dependencies must be installed somewhere the Python interpreter embedded in the debugger can find them. Voltron includes an install script which will attempt to detect the supported debuggers that are installed on the system, and will install Voltron and its Python dependencies using the appropriate version of Python for each debugger.

To install with the install script, download the source and run it from the root level of the source tree:

    $ ./install.sh

If you'd rather install to the system `site-packages` directory, pass the `-s` flag:

    $ ./install.sh -s

You can also install into a Python virtual environment for LLDB:

    $ ./install.sh -v /path/to/venv -b lldb

This install script should cover the vast majority of use cases, but if it fails to install properly on your system (or you'd rather install manually) the following instructions are provided for each platform.

## macOS

On macOS, LLDB (installed by Xcode) and GDB (installed by Homebrew) are both linked against the system's default version of Python, so Voltron must be installed using this version of Python. On systems without any other Python installation, you can just go ahead and install with `pip` as above.

On systems with other versions of Python installed (via Homebrew, MacPorts or other methods), you may need to explicitly specify the system version of Python:

    $ /usr/bin/python -m pip install voltron [ --user ]

Other installations of LLDB or GDB (manually compiled or installed with MacPorts) may be linked with other Python installations, so you'll need to install Voltron with whichever the debugger is linked against.

You can find out which version of Python your debugger is linked against with `otool`:

    $ otool -L /usr/local/bin/gdb|grep -i python
        /System/Library/Frameworks/Python.framework/Versions/2.7/Python (compatibility version 2.7.0, current version 2.7.5)

This version of GDB above is installed with Homebrew, so it's linked against the system Python. You'll have to figure out which installation of Python your debugger is linked with and where the `python` binary is on your own, but when you do you can install Voltron with:

    $ /path/to/python -m pip install voltron [ --user ]

## Linux

### Ubuntu

Ubuntu (at least 14.04) comes with Python versions 2 and 3. GDB is linked with Python 3, but `/usr/bin/python` is Python 2. In order to get Voltron to work you'll need to install Voltron into the Python 3 site-packages.

First, install some dependencies:

    $ sudo apt-get install libreadline6-dev python3-dev python3-setuptools python3-yaml

Then install Voltron:

    $ pip3 install voltron

### Other distros

You're mostly on your own here. You can figure out which version of Python the debugger is linked with using `readelf`:

    $ readelf -d `which gdb`|grep python
    0x0000000000000001 (NEEDED)             Shared library: [libpython3.4m.so.1.0]

Then you'll need to install Voltron using that version of Python, wherever it lives:

    $ /path/to/python -m pip install voltron [ --user ]

## Windows

### WinDbg

Voltron support for WinDbg is implemented by way of the [PyKD](https://pykd.codeplex.com/) module.

1. Install WinDbg via Windows SDK for your Windows version

2. Download the zip of the latest release of [PyKD](https://pykd.codeplex.com/releases/view/614442)

3. Install the PyKD module. If you know how to do this properly (install it to the WinDbg extensions dir, which I gave up on because it didn't want to work on my system), then do it. I just load it in WinDbg by absolute path.

4. Install the PyKD Python wheel with pip:

        $ pip install pykd-0.3.0.38-py2-none-win_amd64.whl

5. Install the [curses](http://www.lfd.uci.edu/~gohlke/pythonlibs/#curses) Python wheel:

        $ pip install curses-2.2-cp27-none-win_amd64.whl

#### Troubleshooting

1. Make sure you have the same bitness versions of Python and PyKD (possibly WinDbg but I don't think there's an option).

### VDB

TBC

## Virtual environments

Voltron can be installed into a Python virtual environment if you'd rather not install it (and all its dependencies) into your Python `site-packages` directory. You'll need to make sure you're using the correct installation of Python per the installation instructions above.

Create a virtual environment:

    $ virtualenv voltron_venv

Or, if you're using a Python installation that the `virtualenv` executable in your path does not belong to:

    $ /path/to/python -m virtualenv voltron_venv

Install Voltron into the virtual environment:

    $ voltron_venv/bin/pip install voltron

Now when you launch the debugger, you'll need to set your `PYTHONPATH` environment variable:

    $ PYTHONPATH=voltron_venv/lib/python2.7/site-packages lldb

Note the Python version in the path there - that will need to reflect whatever the actual path to the `site-packages` dir inside the virtual environment is. You could also set and export this variable in your shell init.

When you launch the views, you'll need to call the `voltron` executable inside the virtual environment:

    $ voltron_venv/bin/voltron view reg

You could also add the venv to your `PATH` environment variable.
