Voltron comes with a series of views for commonly used tasks. They can be run with the command `voltron view <viewname>`.

The included views are:

- [Registers view](#registers-view)
- [Disassembly view](#disassembly-view)
- [Memory view](#memory-view)
- [Stack view](#stack-view)
- [Command view](#command-view)
- [Breakpoints view](#breakpoints-view)

## Registers view

The register view displays the current values of the CPU registers at the time the debugger stopped. Registers that have changed since the last time the debugger stopped are highlighted in red.

### Usage

    usage: voltron view registers [-h] [--show-header] [--hide-header]
                                  [--show-footer] [--hide-footer] [--name NAME]
                                  [--horizontal | --vertical] [--general]
                                  [--no-general] [--sse] [--no-sse] [--fpu]
                                  [--no-fpu] [--info]

    optional arguments:
      -h, --help            show this help message and exit
      --show-header, -e     show header
      --hide-header, -E     hide header
      --show-footer, -f     show footer
      --hide-footer, -F     hide footer
      --name NAME, -n NAME  named configuration to use
      --horizontal, -o      horizontal orientation
      --vertical, -v        vertical orientation (default)
      --general, -g         show general registers
      --no-general, -G      hide general registers
      --sse, -s             show sse registers
      --no-sse, -S          hide sse registers
      --fpu, -p             show fpu registers
      --no-fpu, -P          hide fpu registers
      --info, -i            show info (pointer derefs, ascii) for registers

![registers](http://i.imgur.com/rFefTfI.png)

The `-i` option provides additional information for the general registers. An ascii representation of the data is displayed, and any valid pointers discovered in registers are dereferenced.

![registers_i](http://i.imgur.com/WkIbdaO.png)

Some extended registers can be displayed on x86 CPUs such as SSE (`-s`) and FPU registers (`-f`), with the `-G` option to suppress the display of the general registers.

![registers_sse](http://i.imgur.com/NcBYXxH.png)


## Disassembly view

The disassembly view displays disassembled code starting at the current instruction pointer. By default it utilises the debugger host's built in disassembly function, and then highlights the output with a Pygments lexer.

### Usage

    usage: voltron view disasm [-h] [--show-header] [--hide-header]
                               [--show-footer] [--hide-footer] [--name NAME]
                               [--use-capstone] [--address ADDRESS]

    optional arguments:
      -h, --help            show this help message and exit
      --show-header, -e     show header
      --hide-header, -E     hide header
      --show-footer, -f     show footer
      --hide-footer, -F     hide footer
      --name NAME, -n NAME  named configuration to use
      --use-capstone, -c    use capstone
      --address ADDRESS, -a ADDRESS
                            address (in hex or decimal) from which to start
                            disassembly

### Examples

LLDB default view (`voltron v d` when connected to LLDB):

![disasm_lldb](http://i.imgur.com/hwhlUDj.png)

GDB default view (`voltron v d` when connected to GDB):

![disasm_gdb](http://i.imgur.com/BAB4bmk.png)

Capstone view (in progress) (`voltron v d -c` when connected to LLDB or GDB):

![disasm_capstone](http://i.imgur.com/DYlecTK.png)


## Memory view

The memory view supports scrolling. The keys are as follows:

- `p` to page up
- `n` to page down
- up arrow to move up by a single line
- down arrow to move down by a single line
- enter to centre the view

### Usage

    usage: voltron view memory [-h] [--show-header] [--hide-header]
                               [--show-footer] [--hide-footer] [--name NAME]
                               [--deref | --bytes BYTES] [--reverse]
                               [--address ADDRESS | --command COMMAND | --register REGISTER]

    optional arguments:
      -h, --help            show this help message and exit
      --show-header, -e     show header
      --hide-header, -E     hide header
      --show-footer, -f     show footer
      --hide-footer, -F     hide footer
      --name NAME, -n NAME  named configuration to use
      --deref, -d           display the data in a column one CPU word wide and
                            dereference any valid pointers
      --bytes BYTES, -b BYTES
                            bytes per line (default 16)
      --reverse, -v         reverse the output
      --address ADDRESS, -a ADDRESS
                            address (in hex or decimal) from which to start
                            reading memory
      --command COMMAND, -c COMMAND
                            command to execute resulting in the address from which
                            to start reading memory. voltron will do his almighty
                            best to find an address. e.g. "print \$rip + 0x1234"
      --register REGISTER, -r REGISTER
                            register containing the address from which to start
                            reading memory

### Examples

Memory view showing memory at the address in the `RSP` register (`voltron v m -r rsp`):

![mem_addr](http://i.imgur.com/S5PplLg.png)

## Stack view

The stack view is a special case of the memory view with some preset options to display the memory pointed to by the stack pointer, always dereferencing pointers, and shown in reverse order. It responds to the same scrolling keys as the memory view.

### Usage

    usage: voltron view stack [-h] [--show-header] [--hide-header] [--show-footer]
                              [--hide-footer] [--name NAME]

    optional arguments:
      -h, --help            show this help message and exit
      --show-header, -e     show header
      --hide-header, -E     hide header
      --show-footer, -f     show footer
      --hide-footer, -F     hide footer
      --name NAME, -n NAME  named configuration to use

### Examples

Stack view showing stack memory with default options (`voltron v s`):

![stack](http://i.imgur.com/ZGoAsCO.png)

The stack view can be reproduced with a memory view and the appropriate options (`voltron v m -r sp -d -v`). Note that where registers are specified, the special names `pc` and `sp` can be used to refer to whichever register is the program counter or stack pointer on the current platform.


## Command view

The command view allows the user to specify a debugger command to be executed each time the debugger stops, and the command output displayed in the view. This allows for a great deal of flexibility, particular with regard to interoperability with other tools like [GEF](https://github.com/hugsy/gef), [PEDA](https://github.com/longld/peda), [PwnDbg](https://github.com/pwndbg/pwndbg) and [fG's gdbinit](https://github.com/gdbinit/gdbinit) that provide additional powerful command sets.

### Usage

    usage: voltron view command [-h] [--show-header] [--hide-header]
                                [--show-footer] [--hide-footer] [--name NAME]
                                [--lexer LEXER]
                                command

    positional arguments:
      command               command to run

    optional arguments:
      -h, --help            show this help message and exit
      --show-header, -e     show header
      --hide-header, -E     hide header
      --show-footer, -f     show footer
      --hide-footer, -F     hide footer
      --name NAME, -n NAME  named configuration to use
      --lexer LEXER, -l LEXER
                            apply a Pygments lexer to the command output (e.g.
                            "c")

### Examples

If the program you're debugging has source available, the command view could be used as a source viewer.

Using LLDB as a debugger, the command `voltron v c "source list -a \$rip -c 25"` will display a view like this:

![command](http://i.imgur.com/1CVBCzV.png)

[Pygments lexers](http://pygments.org/docs/lexers/) can be applied to command view output, so we can use the C lexer here to syntax highlight the source as C code, with the command `voltron v c --lexer c "source list -a \$rip -c 25"`:

![command_highlight](http://i.imgur.com/da5J1bD.png)


## Breakpoints

The breakpoint view displays a consistent view of breakpoints across debuggers. It shows the address and symbol at which the breakpoint is set, and the number of times the breakpoint has been hit.

### Examples

![breakpoint](http://i.imgur.com/zwRG8gn.png)

