#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2019/9/15 9:46 PM
# @Author  : w8ay
# @File    : sensitive_info.py
import re


def sensitive_bankcard(source):
    _ = r'\D(6\d{14,18})\D'
    texts = re.findall(_, source, re.M | re.I)
    out = []
    if texts:
        for i in set(texts):
            out.append({
                "type": "bankcard",
                "content": i
            })
    return out


def sensitive_idcard(source):
    _ = r'\D([123456789]\d{5}((19)|(20))\d{2}((0[123456789])|(1[012]))((0[123456789])|([12][0-9])|(3[01]))\d{3}[Xx0-9])\D'
    texts = re.findall(_, source, re.M | re.I)
    out = []
    if texts:
        for i in set(texts):
            if len(i[0]) < 18:
                continue
            out.append({
                "type": "idycard",
                "content": i[0]
            })
    return out


def sensitive_phone(source):
    _ = r'\D(1[3578]\d{9})\D'
    texts = re.findall(_, source, re.M | re.I)
    out = []
    if texts:
        for i in set(texts):
            out.append({
                "type": "phone",
                "content": i
            })
    return out


def sensitive_email(source):
    _ = r'(([a-zA-Z0-9]+[_|\-|\.]?)*[a-zA-Z0-9]+\@([a-zA-Z0-9]+[_|\-|\.]?)*[a-zA-Z0-9]+(\.[a-zA-Z]{2,3})+)'
    texts = re.findall(_, source, re.M | re.I)
    if texts:
        for i in set(texts):
            return {
                "type": "email",
                "content": i[0]
            }


def sensitive_page_error_message_check(source) -> list:
    errors = [
        {'regex': '"Message":"Invalid web service call', 'type': 'ASP.Net'},
        {'regex': 'Exception of type', 'type': 'ASP.Net'},
        {'regex': '--- End of inner exception stack trace ---', 'type': 'ASP.Net'},
        {'regex': 'Microsoft OLE DB Provider', 'type': 'ASP.Net'},
        {'regex': 'Error ([\d-]+) \([\dA-Fa-f]+\)', 'type': 'ASP.Net'},
        {'regex': 'at ([a-zA-Z0-9_]*\.)*([a-zA-Z0-9_]+)\([a-zA-Z0-9, \[\]\&\;]*\)', 'type': 'ASP.Net'},
        {'regex': '([A-Za-z]+[.])+[A-Za-z]*Exception: ', 'type': 'ASP.Net'},
        {'regex': 'in [A-Za-z]:\([A-Za-z0-9_]+\)+[A-Za-z0-9_\-]+(\.aspx)?\.cs:line [\d]+', 'type': 'ASP.Net'},
        {'regex': 'Syntax error in string in query expression', 'type': 'ASP.Net'},
        {'regex': '\.java:[0-9]+', 'type': 'Java'}, {'regex': '\.java\((Inlined )?Compiled Code\)', 'type': 'Java'},
        {'regex': '\.invoke\(Unknown Source\)', 'type': 'Java'}, {'regex': 'nested exception is', 'type': 'Java'},
        {'regex': '\.js:[0-9]+:[0-9]+', 'type': 'Javascript'}, {'regex': 'JBWEB[0-9]{{6}}:', 'type': 'JBoss'},
        {'regex': '((dn|dc|cn|ou|uid|o|c)=[\w\d]*,\s?){2,}', 'type': 'LDAP'},
        {'regex': '\[(ODBC SQL Server Driver|SQL Server|ODBC Driver Manager)\]', 'type': 'Microsoft SQL Server'},
        {'regex': 'Cannot initialize the data source object of OLE DB provider "[\w]*" for linked server "[\w]*"',
         'type': 'Microsoft SQL Server'}, {
            'regex': 'You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near',
            'type': 'MySQL'},
        {'regex': 'Illegal mix of collations \([\w\s\,]+\) and \([\w\s\,]+\) for operation', 'type': 'MySQL'},
        {'regex': 'at (\/[A-Za-z0-9\.]+)*\.pm line [0-9]+', 'type': 'Perl'},
        {'regex': '\.php on line [0-9]+', 'type': 'PHP'}, {'regex': '\.php</b> on line <b>[0-9]+', 'type': 'PHP'},
        {'regex': 'Fatal error:', 'type': 'PHP'}, {'regex': '\.php:[0-9]+', 'type': 'PHP'},
        {'regex': 'Traceback \(most recent call last\):', 'type': 'Python'},
        {'regex': 'File "[A-Za-z0-9\-_\./]*", line [0-9]+, in', 'type': 'Python'},
        {'regex': '\.rb:[0-9]+:in', 'type': 'Ruby'}, {'regex': '\.scala:[0-9]+', 'type': 'Scala'},
        {'regex': '\(generated by waitress\)', 'type': 'Waitress Python server'}, {
            'regex': '132120c8|38ad52fa|38cf013d|38cf0259|38cf025a|38cf025b|38cf025c|38cf025d|38cf025e|38cf025f|38cf0421|38cf0424|38cf0425|38cf0427|38cf0428|38cf0432|38cf0434|38cf0437|38cf0439|38cf0442|38cf07aa|38cf08cc|38cf04d7|38cf04c6|websealerror',
            'type': 'WebSEAL'},
        {'type': 'ASPNETPathDisclosure',
         'regex': "<title>Invalid\sfile\sname\sfor\smonitoring:\s'([^']*)'\.\sFile\snames\sfor\smonitoring\smust\shave\sabsolute\spaths\,\sand\sno\swildcards\.<\/title>"},
        {'type': 'Struts2DevMod',
         'regex': 'You are seeing this page because development mode is enabled.  Development mode, or devMode, enables extra'},
        {'type': 'Django DEBUG MODEL',
         'regex': "You're seeing this error because you have <code>DEBUG = True<\/code> in"},
        {'type': 'RailsDevMode', 'regex': '<title>Action Controller: Exception caught<\/title>'},
        {'type': 'RequiredParameter', 'regex': "Required\s\w+\sparameter\s'([^']+?)'\sis\snot\spresent"},
        {'type': 'Thinkphp3 Debug', 'regex': '<p class="face">:\(</p>'},
        {'type': 'xdebug', "regex": "class='xdebug-error xe-fatal-error'"}
    ]
    r = []
    for error in errors:
        regex = error["regex"]
        _type = error["type"]
        result = re.search(regex, source, re.I)
        if result:
            r.append({
                "text": result.group(),
                "type": _type
            })
    return r


if __name__ == '__main__':
    r = sensitive_page_error_message_check("11111111.php on line 123;axzczxc")
    print(r)
