from __future__ import annotations
from .preset import DecompilationPreset
from angr.analyses.decompiler.optimization_passes import (
    RegisterSaveAreaSimplifier,
    StackCanarySimplifier,
    WinStackCanarySimplifier,
    RegisterSaveAreaSimplifierAdvanced,
    BasePointerSaveSimplifier,
    DivSimplifier,
    ModSimplifier,
    ConstantDereferencesSimplifier,
    RetAddrSaveSimplifier,
    X86GccGetPcSimplifier,
    ITERegionConverter,
    ITEExprConverter,
    ExprOpSwapper,
    ReturnDuplicatorHigh,
    DeadblockRemover,
    SwitchDefaultCaseDuplicator,
    ConstPropOptReverter,
    DuplicationReverter,
    LoweredSwitchSimplifier,
    ReturnDuplicatorLow,
    ReturnDeduplicator,
    CrossJumpReverter,
    FlipBooleanCmp,
    InlinedStringTransformationSimplifier,
    InlinedStrlenSimplifier,
    CallStatementRewriter,
    SwitchReusedEntryRewriter,
    ConditionConstantPropagation,
    DetermineLoadSizes,
    PostStructuringPeepholeOptimizationPass,
    EagerStdStringConcatenationPass,
)

preset_full = DecompilationPreset(
    "full",
    [
        RegisterSaveAreaSimplifier,
        StackCanarySimplifier,
        WinStackCanarySimplifier,
        RegisterSaveAreaSimplifierAdvanced,
        BasePointerSaveSimplifier,
        DivSimplifier,
        ModSimplifier,
        ConstantDereferencesSimplifier,
        RetAddrSaveSimplifier,
        X86GccGetPcSimplifier,
        ITERegionConverter,
        ITEExprConverter,
        ExprOpSwapper,
        ReturnDuplicatorHigh,
        DeadblockRemover,
        SwitchDefaultCaseDuplicator,
        ConstPropOptReverter,
        DuplicationReverter,
        LoweredSwitchSimplifier,
        ReturnDuplicatorLow,
        ReturnDeduplicator,
        CrossJumpReverter,
        FlipBooleanCmp,
        InlinedStringTransformationSimplifier,
        InlinedStrlenSimplifier,
        CallStatementRewriter,
        SwitchReusedEntryRewriter,
        ConditionConstantPropagation,
        DetermineLoadSizes,
        PostStructuringPeepholeOptimizationPass,
        EagerStdStringConcatenationPass,
    ],
)


__all__ = ["preset_full"]
