from __future__ import annotations
from .preset import DecompilationPreset
from angr.analyses.decompiler.optimization_passes import (
    RegisterSaveAreaSimplifier,
    StackCanarySimplifier,
    WinStackCanarySimplifier,
    BasePointerSaveSimplifier,
    ConstantDereferencesSimplifier,
    RetAddrSaveSimplifier,
    X86GccGetPcSimplifier,
    ITERegionConverter,
    ITEExprConverter,
    ExprOpSwapper,
    ReturnDuplicatorHigh,
    SwitchDefaultCaseDuplicator,
    LoweredSwitchSimplifier,
    ReturnDuplicatorLow,
    ReturnDeduplicator,
    FlipBooleanCmp,
    InlinedStringTransformationSimplifier,
    InlinedStrlenSimplifier,
    CallStatementRewriter,
    DeadblockRemover,
    SwitchReusedEntryRewriter,
    ConditionConstantPropagation,
    RegisterSaveAreaSimplifierAdvanced,
    DetermineLoadSizes,
    PostStructuringPeepholeOptimizationPass,
    EagerStdStringConcatenationPass,
    EagerStdStringEvalPass,
    StaticVVarRewriter,
)

preset_malware = DecompilationPreset(
    "malware",
    [
        RegisterSaveAreaSimplifier,
        StackCanarySimplifier,
        WinStackCanarySimplifier,
        RegisterSaveAreaSimplifierAdvanced,
        BasePointerSaveSimplifier,
        ConstantDereferencesSimplifier,
        RetAddrSaveSimplifier,
        X86GccGetPcSimplifier,
        ITERegionConverter,
        ITEExprConverter,
        ExprOpSwapper,
        ReturnDuplicatorHigh,
        DeadblockRemover,
        SwitchDefaultCaseDuplicator,
        SwitchReusedEntryRewriter,
        LoweredSwitchSimplifier,
        ReturnDuplicatorLow,
        ReturnDeduplicator,
        FlipBooleanCmp,
        InlinedStringTransformationSimplifier,
        InlinedStrlenSimplifier,
        CallStatementRewriter,
        ConditionConstantPropagation,
        DetermineLoadSizes,
        PostStructuringPeepholeOptimizationPass,
        EagerStdStringConcatenationPass,
        EagerStdStringEvalPass,
        StaticVVarRewriter,
    ],
)


__all__ = ["preset_malware"]
