from .base import ModuleTestBase


class TestSubDomainRadar(ModuleTestBase):
    config_overrides = {"modules": {"subdomainradar": {"api_key": "asdf"}}}

    async def setup_before_prep(self, module_test):
        await module_test.mock_dns(
            {
                "blacklanternsecurity.com": {"A": ["127.0.0.88"]},
                "www.blacklanternsecurity.com": {"A": ["127.0.0.88"]},
                "asdf.blacklanternsecurity.com": {"A": ["127.0.0.88"]},
            }
        )
        module_test.httpx_mock.add_response(
            url="https://api.subdomainradar.io/profile",
            match_headers={"Authorization": "Bearer asdf"},
        )
        module_test.httpx_mock.add_response(
            url="https://api.subdomainradar.io/enumerate",
            method="POST",
            json={
                "tasks": {"blacklanternsecurity.com": "86de4531-0a67-41fe-b5e4-8ce8207d6245"},
                "message": "Tasks initiated",
            },
            match_headers={"Authorization": "Bearer asdf"},
        )
        module_test.httpx_mock.add_response(
            url="https://api.subdomainradar.io/tasks/86de4531-0a67-41fe-b5e4-8ce8207d6245",
            match_headers={"Authorization": "Bearer asdf"},
            json={
                "task_id": "86de4531-0a67-41fe-b5e4-8ce8207d6245",
                "status": "completed",
                "domain": "blacklanternsecurity.com",
                "subdomains": [
                    {
                        "subdomain": "www.blacklanternsecurity.com",
                        "ip": None,
                        "reverse_dns": [],
                        "country": None,
                        "timestamp": None,
                    },
                    {
                        "subdomain": "asdf.blacklanternsecurity.com",
                        "ip": None,
                        "reverse_dns": [],
                        "country": None,
                        "timestamp": None,
                    },
                ],
                "total_subdomains": 2,
                "rank": None,
                "whois": {
                    "domain_name": ["BLACKLANTERNSECURITY.COM", "blacklanternsecurity.com"],
                    "registrar": "MarkMonitor, Inc.",
                    "creation_date": ["1992-11-04T05:00:00", "1992-11-04T05:00:00+00:00"],
                    "expiration_date": ["2026-11-03T05:00:00", "2026-11-03T00:00:00+00:00"],
                    "last_updated": ["2024-10-02T10:15:20", "2024-10-02T10:15:20+00:00"],
                    "status": [
                        "clientDeleteProhibited https://icann.org/epp#clientDeleteProhibited",
                        "clientTransferProhibited https://icann.org/epp#clientTransferProhibited",
                        "clientUpdateProhibited https://icann.org/epp#clientUpdateProhibited",
                        "serverDeleteProhibited https://icann.org/epp#serverDeleteProhibited",
                        "serverTransferProhibited https://icann.org/epp#serverTransferProhibited",
                        "serverUpdateProhibited https://icann.org/epp#serverUpdateProhibited",
                        "clientUpdateProhibited (https://www.icann.org/epp#clientUpdateProhibited)",
                        "clientTransferProhibited (https://www.icann.org/epp#clientTransferProhibited)",
                        "clientDeleteProhibited (https://www.icann.org/epp#clientDeleteProhibited)",
                        "serverUpdateProhibited (https://www.icann.org/epp#serverUpdateProhibited)",
                        "serverTransferProhibited (https://www.icann.org/epp#serverTransferProhibited)",
                        "serverDeleteProhibited (https://www.icann.org/epp#serverDeleteProhibited)",
                    ],
                    "nameservers": [
                        "A1-12.AKAM.NET",
                        "A10-67.AKAM.NET",
                        "A12-64.AKAM.NET",
                        "A28-65.AKAM.NET",
                        "A7-66.AKAM.NET",
                        "A9-67.AKAM.NET",
                        "EDNS69.ULTRADNS.BIZ",
                        "EDNS69.ULTRADNS.COM",
                        "EDNS69.ULTRADNS.NET",
                        "EDNS69.ULTRADNS.ORG",
                        "edns69.ultradns.biz",
                        "a12-64.akam.net",
                        "edns69.ultradns.net",
                        "edns69.ultradns.org",
                        "a10-67.akam.net",
                        "a28-65.akam.net",
                        "a9-67.akam.net",
                        "a1-12.akam.net",
                        "a7-66.akam.net",
                        "edns69.ultradns.com",
                    ],
                    "emails": [
                        "abusecomplaints@markmonitor.com",
                        "admin@dnstinations.com",
                        "whoisrequest@markmonitor.com",
                    ],
                    "dnssec": "unsigned",
                    "org": "DNStination Inc.",
                    "address": "3450 Sacramento Street, Suite 405",
                    "city": "San Francisco",
                    "state": "CA",
                    "zipcode": None,
                    "country": "US",
                },
                "enumerators": ["Aquarius Enumerator", "Beta Enumerator", "Chi Enumerator", "Eta Enumerator"],
                "timestamp": "2024-10-06T02:48:10.075636",
                "error": None,
                "is_notification": False,
                "notification_domain_id": None,
                "demo": False,
                "user_id": 49,
                "time_to_finish": 41,
            },
        )
        module_test.httpx_mock.add_response(
            url="https://api.subdomainradar.io/enumerators/groups",
            match_headers={"Authorization": "Bearer asdf"},
            json=[
                {
                    "id": "1",
                    "name": "Fast",
                    "description": "Enumerators optimized for high-speed scanning and rapid data collection",
                    "enumerators": [
                        {"display_name": "Beta Enumerator"},
                        {"display_name": "Chi Enumerator"},
                        {"display_name": "Aquarius Enumerator"},
                        {"display_name": "Eta Enumerator"},
                    ],
                },
                {
                    "id": "2",
                    "name": "Medium",
                    "description": "Enumerators balanced for moderate speed with a focus on thoroughness",
                    "enumerators": [
                        {"display_name": "Kappa Enumerator"},
                        {"display_name": "Lambda Enumerator"},
                        {"display_name": "Mu Enumerator"},
                        {"display_name": "Pi Enumerator"},
                        {"display_name": "Tau Enumerator"},
                        {"display_name": "Beta Enumerator"},
                        {"display_name": "Chi Enumerator"},
                        {"display_name": "Psi Enumerator"},
                        {"display_name": "Aquarius Enumerator"},
                        {"display_name": "Zeta Enumerator"},
                        {"display_name": "Eta Enumerator"},
                    ],
                },
                {
                    "id": "3",
                    "name": "Deep",
                    "description": "Enumerators designed for exhaustive searches and in-depth data analysis",
                    "enumerators": [
                        {"display_name": "Alpha Enumerator"},
                        {"display_name": "Kappa Enumerator"},
                        {"display_name": "Lambda Enumerator"},
                        {"display_name": "Mu Enumerator"},
                        {"display_name": "Nu Enumerator"},
                        {"display_name": "Xi Enumerator"},
                        {"display_name": "Pi Enumerator"},
                        {"display_name": "Rho Enumerator"},
                        {"display_name": "Sigma Enumerator"},
                        {"display_name": "Tau Enumerator"},
                        {"display_name": "Beta Enumerator"},
                        {"display_name": "Chi Enumerator"},
                        {"display_name": "Omega Enumerator"},
                        {"display_name": "Psi Enumerator"},
                        {"display_name": "Phi Enumerator"},
                        {"display_name": "Axon Enumerator"},
                        {"display_name": "Aquarius Enumerator"},
                        {"display_name": "Pegasus Enumerator"},
                        {"display_name": "Petra Enumerator"},
                        {"display_name": "Oasis Enumerator"},
                        {"display_name": "Mike Enumerator"},
                        {"display_name": "Cat Enumerator"},
                        {"display_name": "Brutus Enumerator"},
                        {"display_name": "Dee Enumerator"},
                        {"display_name": "Jul Enumerator"},
                        {"display_name": "Eve Enumerator"},
                        {"display_name": "Frank Enumerator"},
                        {"display_name": "Gus Enumerator"},
                        {"display_name": "Hank Enumerator"},
                        {"display_name": "Delta Enumerator"},
                        {"display_name": "Ivy Enumerator"},
                        {"display_name": "Jack Enumerator"},
                        {"display_name": "Karl Enumerator"},
                        {"display_name": "Liam Enumerator"},
                        {"display_name": "Nora Enumerator"},
                        {"display_name": "Mars Enumerator"},
                        {"display_name": "Neptune Enumerator"},
                        {"display_name": "Orion Enumerator"},
                        {"display_name": "Oedipus Enumerator"},
                        {"display_name": "Pandora Enumerator"},
                        {"display_name": "Epsilon Enumerator"},
                        {"display_name": "Zeta Enumerator"},
                        {"display_name": "Eta Enumerator"},
                        {"display_name": "Theta Enumerator"},
                        {"display_name": "Iota Enumerator"},
                    ],
                },
            ],
        )

    def check(self, module_test, events):
        assert any(e.data == "www.blacklanternsecurity.com" for e in events), "Failed to detect subdomain #1"
        assert any(e.data == "asdf.blacklanternsecurity.com" for e in events), "Failed to detect subdomain #2"
