-- Run this as root (or another admin user), e.g.:
--   mysql -u root -p < init_db.sql

CREATE USER IF NOT EXISTS 'bt_user'@'localhost'
  IDENTIFIED BY 'YourStrongPasswordHere';

DROP DATABASE IF EXISTS BT_TRACKER;
CREATE DATABASE BT_TRACKER
  CHARACTER SET utf8mb4
  COLLATE utf8mb4_unicode_ci;

GRANT ALL PRIVILEGES ON BT_TRACKER.* TO 'bt_user'@'localhost';
FLUSH PRIVILEGES;

USE BT_TRACKER;

CREATE TABLE BT (
  ID      INT UNSIGNED NOT NULL AUTO_INCREMENT,
  MAC     VARCHAR(17)  DEFAULT NULL,    -- 17 covers "AA:BB:CC:DD:EE:FF"; can be NULL for sensor-only rows
  NAME    VARCHAR(255)      DEFAULT NULL,
  MOMENT  DATETIME      NOT NULL DEFAULT CURRENT_TIMESTAMP,
  LOC     VARCHAR(50)       DEFAULT NULL,
  SENSOR  VARCHAR(50)       DEFAULT NULL,
  PRIMARY KEY (ID),
  INDEX idx_moment (MOMENT),
  INDEX idx_mac    (MAC),
  INDEX idx_loc    (LOC),
  INDEX idx_sensor (SENSOR)
) ENGINE=InnoDB;

CREATE TABLE MAP (
  ID    INT UNSIGNED NOT NULL AUTO_INCREMENT,
  LOC   VARCHAR(50)  NOT NULL,
  X0    INT          NOT NULL,
  Y0    INT          NOT NULL,
  XMAX  INT          NOT NULL,
  YMAX  INT          NOT NULL,
  PRIMARY KEY (ID),
  UNIQUE KEY u_loc (LOC)
) ENGINE=InnoDB;

INSERT INTO MAP (LOC,X0,Y0,XMAX,YMAX) VALUES ('E2',30,222,131,465);
INSERT INTO MAP (LOC,X0,Y0,XMAX,YMAX) VALUES ('E1',147,222,250,465);
INSERT INTO MAP (LOC,X0,Y0,XMAX,YMAX) VALUES ('P1',271,24,391,260);
INSERT INTO MAP (LOC,X0,Y0,XMAX,YMAX) VALUES ('P2',404,24,498,260);
INSERT INTO MAP (LOC,X0,Y0,XMAX,YMAX) VALUES ('P3',511,24,629,260);
