/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import org.openide.util.WeakListeners;

class EntityRegistryTableModel
extends RowTableModel<MaltegoEntitySpec> {
    public static final String[] Columns = new String[]{"", "Display name", "Description", "Type", "Value property", "Default value"};
    private EntityRegistry _registry;
    private RegistryListener _listener;

    public EntityRegistryTableModel(EntityRegistry entityRegistry) {
        super(Columns, new ArrayList(entityRegistry.getAllVisible()));
        this._registry = entityRegistry;
        this._listener = new RegistryListener(){

            public void typeAdded(RegistryEvent registryEvent) {
                EntityRegistryTableModel.this.refresh();
            }

            public void typeRemoved(RegistryEvent registryEvent) {
                EntityRegistryTableModel.this.refresh();
            }

            public void typeUpdated(RegistryEvent registryEvent) {
                EntityRegistryTableModel.this.refresh();
            }
        };
        this._registry.addRegistryListener((RegistryListener)WeakListeners.create(RegistryListener.class, (EventListener)this._listener, (Object)this._registry));
    }

    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Image.class;
        }
        return String.class;
    }

    public void refresh() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EntityRegistryTableModel.this.setRows(new ArrayList(EntityRegistryTableModel.this._registry.getAllVisible()));
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public Object getValueFor(MaltegoEntitySpec maltegoEntitySpec, int n) {
        switch (n) {
            case 0: {
                return maltegoEntitySpec.getIcon(16);
            }
            case 1: {
                return maltegoEntitySpec.getDisplayName();
            }
            case 2: {
                return maltegoEntitySpec.getDescription();
            }
            case 3: {
                return maltegoEntitySpec.getTypeName();
            }
            case 4: {
                DisplayDescriptor displayDescriptor = maltegoEntitySpec.getValueProperty();
                return displayDescriptor == null ? "<none>" : displayDescriptor.getDisplayName();
            }
            case 5: {
                DisplayDescriptor displayDescriptor = maltegoEntitySpec.getValueProperty();
                return displayDescriptor == null ? "<none>" : displayDescriptor.getDefaultValue();
            }
        }
        return null;
    }
}

