/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformSetRepository
extends TransformSetRepository {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SET_FOLDER = "TransformSets";
    private static final String ATTR_DESCRIPTION = "description";
    private Set<TransformSet> _sets;

    public boolean put(TransformSet transformSet) {
        try {
            this.replaceSetFolder(transformSet);
            transformSet.markClean();
            TransformSet transformSet2 = this.get(transformSet.getName());
            if (transformSet2 != null) {
                this.sets().remove(transformSet2);
                this.sets().add(transformSet);
                this.fireItemChanged(transformSet);
            } else {
                this.sets().add(transformSet);
                this.fireItemAdded(transformSet);
            }
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public boolean remove(String string) {
        try {
            FileObject fileObject = FSTransformSetRepository.getOrCreateSetFolder();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 != null) {
                fileObject2.delete();
                TransformSet transformSet = this.get(string);
                this.sets().remove(transformSet);
                this.fireItemRemoved(transformSet);
                return true;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    private Set<TransformSet> sets() {
        if (this._sets == null) {
            this._sets = new HashSet<TransformSet>();
            try {
                FileObject fileObject = FSTransformSetRepository.getOrCreateSetFolder();
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    TransformSet transformSet = FSTransformSetRepository.loadSet(fileObject2);
                    transformSet.markClean();
                    this._sets.add(transformSet);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._sets;
    }

    public Set<TransformSet> allSets() {
        return Collections.unmodifiableSet(this.sets());
    }

    public boolean contains(String string) {
        TransformSet transformSet = this.get(string);
        return transformSet != null;
    }

    public TransformSet get(String string) {
        for (TransformSet transformSet : this.sets()) {
            if (!transformSet.getName().equals(string)) continue;
            return transformSet;
        }
        return null;
    }

    private TransformSet loadSet(String string) {
        try {
            FileObject fileObject = FSTransformSetRepository.getOrCreateSetFolder();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 != null) {
                return FSTransformSetRepository.loadSet(fileObject2);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private static TransformSet loadSet(FileObject fileObject) {
        TransformSet transformSet = new TransformSet(fileObject.getNameExt());
        transformSet.setDescription((String)fileObject.getAttribute(ATTR_DESCRIPTION));
        for (FileObject fileObject2 : fileObject.getChildren()) {
            transformSet.addTransform(fileObject2.getNameExt());
        }
        return transformSet;
    }

    private static FileObject getOrCreateSetFolder() throws IOException {
        return FSTransformSetRepository.getOrCreateFolder(FSTransformSetRepository.getOrCreateMaltegoFolder(), SET_FOLDER);
    }

    private static FileObject getOrCreateMaltegoFolder() throws IOException {
        FileObject fileObject = FileUtil.getConfigRoot();
        return FSTransformSetRepository.getOrCreateFolder(fileObject, MALTEGO_FOLDER);
    }

    private static FileObject getOrCreateFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject.getFileObject(string);
    }

    private boolean replaceSetFolder(TransformSet transformSet) throws IOException {
        FileObject fileObject = FSTransformSetRepository.getOrCreateSetFolder();
        FileObject fileObject2 = fileObject.getFileObject(transformSet.getName());
        boolean bl = false;
        if (fileObject2 != null) {
            this.deleteFolder(fileObject2);
            bl = true;
        }
        fileObject2 = fileObject.createFolder(transformSet.getName());
        fileObject2.setAttribute(ATTR_DESCRIPTION, (Object)(transformSet.getDescription() == null ? "" : transformSet.getDescription()));
        for (String string : transformSet.getAllTransforms()) {
            fileObject2.createData(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFolder(FileObject fileObject) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            fileObject.delete(fileLock);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }
}

