/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.repository.serializer.TransformSeedStub;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class TransformSeedSerializer {
    public static TransformSeedSerializer getDefault() {
        TransformSeedSerializer transformSeedSerializer = (TransformSeedSerializer)Lookup.getDefault().lookup(TransformSeedSerializer.class);
        if (transformSeedSerializer == null) {
            transformSeedSerializer = new DefaultTransformSeedSerializer();
        }
        return transformSeedSerializer;
    }

    public abstract void write(TransformSeed var1, OutputStream var2) throws XmlSerializationException;

    public abstract TransformSeed read(InputStream var1) throws XmlSerializationException;

    private static class DefaultTransformSeedSerializer
    extends TransformSeedSerializer {
        private DefaultTransformSeedSerializer() {
        }

        @Override
        public void write(TransformSeed transformSeed, OutputStream outputStream) throws XmlSerializationException {
            XmlSerializer xmlSerializer = new XmlSerializer();
            TransformSeedStub transformSeedStub = this.translate(transformSeed);
            xmlSerializer.write((Object)transformSeedStub, outputStream);
        }

        @Override
        public TransformSeed read(InputStream inputStream) throws XmlSerializationException {
            XmlSerializer xmlSerializer = new XmlSerializer();
            TransformSeedStub transformSeedStub = (TransformSeedStub)xmlSerializer.read(TransformSeedStub.class, inputStream);
            return this.translate(transformSeedStub);
        }

        private TransformSeedStub translate(TransformSeed transformSeed) {
            TransformSeedStub transformSeedStub = new TransformSeedStub();
            try {
                transformSeedStub.setUrl(transformSeed.getUrl().getURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            transformSeedStub.setName(transformSeed.getName());
            transformSeedStub.setDescription(transformSeed.getDescription());
            transformSeedStub.setEnabled(transformSeed.isEnabled());
            return transformSeedStub;
        }

        private TransformSeed translate(TransformSeedStub transformSeedStub) {
            TransformSeed transformSeed = new TransformSeed(new FastURL(transformSeedStub.getUrl().toString()), transformSeedStub.getName(), transformSeedStub.getDescription());
            transformSeed.setEnabled(transformSeedStub.isEnabled());
            return transformSeed;
        }
    }
}

