/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigFileIO {
    private static String _path = null;

    protected String getUserConfigFilePath() {
        if (_path == null) {
            _path = this.buildConfigFilePath(this.getVersion());
        }
        return _path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        InputStream is = this.getClass().getResourceAsStream("Maltego.properties");
        Properties props = new Properties();
        try {
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return props.getProperty("maltego.userdir.version", "dev");
    }

    private String buildConfigFilePath(String version) {
        StringBuilder configPath = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            configPath = new StringBuilder(System.getenv("HOME"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append("Library");
            configPath.append(File.separator);
            configPath.append("Application Support");
            configPath.append(File.separator);
            configPath.append("maltego");
        } else if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            configPath = new StringBuilder(System.getenv("APPDATA"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append(".maltego");
        } else {
            configPath = new StringBuilder(System.getenv("HOME"));
            if (!configPath.toString().endsWith(File.separator)) {
                configPath.append(File.separator);
            }
            configPath.append(".maltego");
        }
        configPath.append(File.separator);
        configPath.append(version);
        configPath.append(File.separator);
        configPath.append("etc");
        configPath.append(File.separator);
        configPath.append("maltego.conf");
        return configPath.toString();
    }
}

