/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class ExportProgressController
extends ValidatingController<JPanel> {
    private JTextArea _text = new JTextArea("");

    public ExportProgressController() {
        this.setName("Export");
    }

    protected JPanel createComponent() {
        JLabel jLabel = new JLabel("Export Complete");
        jLabel.setFont(new Font("Tahoma", 1, 12));
        this._text.setBackground(jLabel.getBackground());
        this._text.setTabSize(4);
        this._text.setEnabled(false);
        this._text.setDisabledTextColor(Color.BLACK);
        JLabel jLabel2 = new JLabel("Click Finish to close the wizard.");
        jLabel2.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jLabel, "North");
        jPanel.add(this._text);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jLabel2, "South");
        return jPanel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSettings(WizardDescriptor wizardDescriptor) {
        String string = "";
        File file = (File)wizardDescriptor.getProperty("selectedFile");
        boolean bl = (Boolean)wizardDescriptor.getProperty("encrypt");
        MaltegoArchiveWriter maltegoArchiveWriter = null;
        try {
            Object object;
            Object object2;
            Object object3;
            if (!bl) {
                maltegoArchiveWriter = new MaltegoArchiveWriter((OutputStream)new FileOutputStream(file));
            } else {
                object3 = (String)wizardDescriptor.getProperty("password");
                object2 = PasswordUtil.getZipParameters((String)object3);
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    object = new ZipFile(file);
                    maltegoArchiveWriter = new MaltegoArchiveWriter((ZipFile)object, (ZipParameters)object2);
                }
                catch (ZipException zipException) {
                    throw new IOException(zipException);
                }
            }
            object3 = (AllConfigsNode)((Object)this.getDescriptor().getProperty("allConfigs"));
            object2 = (Map)this.getDescriptor().getProperty("configsMap");
            object = new StringBuilder(string);
            for (Node node : object3.getChildren().getNodes()) {
                Config config = (Config)node.getLookup().lookup(Config.class);
                ConfigExporter configExporter = (ConfigExporter)object2.get(config);
                int n = configExporter.saveConfig(maltegoArchiveWriter, config);
                if (n <= 0) continue;
                ((StringBuilder)object).append("\t");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("\t");
                ((StringBuilder)object).append(node.getName());
                ((StringBuilder)object).append("\n");
            }
            string = ((StringBuilder)object).toString();
            string = string.isEmpty() ? "Nothing was exported." : "The following items were exported:\n\n" + string;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            string = "The following error occurred:\n\n" + iOException.getMessage();
        }
        finally {
            if (maltegoArchiveWriter != null) {
                try {
                    maltegoArchiveWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this._text.setText(string);
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
    }
}

