/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.MaltegoPartSpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.EditorDescriptor;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.ColorUtilities;
import java.awt.Color;
import java.awt.Image;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class MaltegoLinkSpec
extends MaltegoPartSpec<MaltegoLink> {
    public static final Color LINK_COLOR_TRANSFORM = Color.LIGHT_GRAY;
    public static final String PROP_NAME_MANUAL_TYPE = "maltego.link.manual.type";
    public static final String PROP_NAME_MANUAL_DESCRIPTION = "maltego.link.manual.description";
    public static final String PROP_NAME_TRANSFORM_NAME = "maltego.link.transform.name";
    public static final String PROP_NAME_TRANSFORM_DISPLAY = "maltego.link.transform.display-name";
    public static final String PROP_NAME_TRANSFORM_VERSION = "maltego.link.transform.version";
    public static final String PROP_NAME_TRANSFORM_DATE = "maltego.link.transform.run-date";
    public static final String PROP_NAME_SHOW_LABEL = "maltego.link.show-label";
    public static final String PROP_NAME_COLOR = "maltego.link.color";
    public static final String PROP_NAME_STYLE = "maltego.link.style";
    public static final String PROP_NAME_THICKNESS = "maltego.link.thickness";
    public static final String PROP_NAME_ATTACHMENTS = "maltego.link.attachments";
    public static final String SPEC_NAME_MANUAL = "maltego.link.manual-link";
    public static final String SPEC_NAME_TRANSFORM = "maltego.link.transform-link";
    private static final String SPEC_DISPLAY_NAME_MANUAL = "Manual Link";
    private static final String SPEC_DISPLAY_NAME_TRANSFORM = "Transform Link";
    private static MaltegoLinkSpec _manualLinkSpec;
    private static MaltegoLinkSpec _transformLinkSpec;

    public MaltegoLinkSpec() {
    }

    public MaltegoLinkSpec(String string, DisplayDescriptorCollection displayDescriptorCollection) {
        super(string, displayDescriptorCollection);
    }

    public MaltegoLinkSpec(String string, DisplayDescriptorCollection displayDescriptorCollection, GroupDefinitions groupDefinitions) {
        super(string, displayDescriptorCollection, groupDefinitions);
    }

    public MaltegoLinkSpec(String string, PropertyConfiguration propertyConfiguration) {
        super(string, propertyConfiguration);
    }

    public static MaltegoLinkSpec getSpec(String string) {
        if (SPEC_NAME_MANUAL.equals(string)) {
            return MaltegoLinkSpec.getManualSpec();
        }
        if (SPEC_NAME_TRANSFORM.equals(string)) {
            return MaltegoLinkSpec.getTransformSpec();
        }
        return null;
    }

    public static MaltegoLinkSpec getSpec(MaltegoLink maltegoLink) {
        return MaltegoLinkSpec.getSpec(maltegoLink.getTypeName());
    }

    public Image getIcon(int n) {
        String string = null;
        if (this == _manualLinkSpec) {
            string = "com/paterva/maltego/entity/api/manual_link";
        } else if (this == _transformLinkSpec) {
            string = "com/paterva/maltego/entity/api/transform_link";
        }
        if (n > 32) {
            string = string + "48";
        } else if (n > 16) {
            string = string + "32";
        }
        string = string + ".png";
        if (string != null) {
            return ImageUtilities.loadImage((String)string);
        }
        return null;
    }

    public static MaltegoLinkSpec getManualSpec() {
        if (_manualLinkSpec == null) {
            DisplayDescriptorList displayDescriptorList = new DisplayDescriptorList();
            displayDescriptorList.add((Object)new DisplayDescriptor(String.class, PROP_NAME_MANUAL_TYPE, "Label"));
            MaltegoLinkSpec.addDefaultLinkProperties((DisplayDescriptorCollection)displayDescriptorList);
            displayDescriptorList.add((Object)new DisplayDescriptor(String.class, PROP_NAME_MANUAL_DESCRIPTION, "Description"));
            _manualLinkSpec = new MaltegoLinkSpec(SPEC_NAME_MANUAL, (DisplayDescriptorCollection)displayDescriptorList);
            _manualLinkSpec.setDisplayName(SPEC_DISPLAY_NAME_MANUAL);
            MaltegoLinkSpec.setPropertyDefaults(_manualLinkSpec);
            MaltegoLinkSpec.setPropertyMappings(_manualLinkSpec);
            MaltegoLinkSpec.setPropertyEditors(_manualLinkSpec);
        }
        return _manualLinkSpec;
    }

    public static MaltegoLinkSpec getTransformSpec() {
        if (_transformLinkSpec == null) {
            DisplayDescriptorList displayDescriptorList = new DisplayDescriptorList();
            MaltegoLinkSpec.addDefaultLinkProperties((DisplayDescriptorCollection)displayDescriptorList);
            displayDescriptorList.add((Object)new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_NAME, "Transform"));
            displayDescriptorList.add((Object)new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_DISPLAY, "Transform name"));
            displayDescriptorList.add((Object)new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_VERSION, "Transform version"));
            displayDescriptorList.add((Object)new DisplayDescriptor(DateTime.class, PROP_NAME_TRANSFORM_DATE, "Date run"));
            displayDescriptorList.get(PROP_NAME_TRANSFORM_NAME).setHidden(true);
            displayDescriptorList.get(PROP_NAME_TRANSFORM_NAME).setReadonly(true);
            displayDescriptorList.get(PROP_NAME_TRANSFORM_DISPLAY).setReadonly(true);
            displayDescriptorList.get(PROP_NAME_TRANSFORM_VERSION).setReadonly(true);
            displayDescriptorList.get(PROP_NAME_TRANSFORM_DATE).setReadonly(true);
            _transformLinkSpec = new MaltegoLinkSpec(SPEC_NAME_TRANSFORM, (DisplayDescriptorCollection)displayDescriptorList);
            _transformLinkSpec.setDisplayName(SPEC_DISPLAY_NAME_TRANSFORM);
            MaltegoLinkSpec.setPropertyDefaults(_transformLinkSpec);
            MaltegoLinkSpec.setPropertyMappings(_transformLinkSpec);
            MaltegoLinkSpec.setPropertyEditors(_transformLinkSpec);
        }
        return _transformLinkSpec;
    }

    public static Color getDefaultManualLinkColor() {
        String string = NbPreferences.forModule(MaltegoLinkSpec.class).get("maltego.defaultManualLinkColor", null);
        Color color = null;
        if (string != null) {
            color = ColorUtilities.decode((String)string);
        }
        return color;
    }

    public static void setDefaultManualLinkColor(Color color) {
        NbPreferences.forModule(MaltegoLinkSpec.class).put("maltego.defaultManualLinkColor", ColorUtilities.encode((Color)color));
    }

    private static void addDefaultLinkProperties(DisplayDescriptorCollection displayDescriptorCollection) {
        displayDescriptorCollection.add((Object)MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_SHOW_LABEL, "Show Label"));
        displayDescriptorCollection.add((Object)MaltegoLinkSpec.createDefaultLinkProperty(Color.class, PROP_NAME_COLOR, "Color"));
        displayDescriptorCollection.add((Object)MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_STYLE, "Style"));
        displayDescriptorCollection.add((Object)MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_THICKNESS, "Thickness"));
    }

    private static DisplayDescriptor createDefaultLinkProperty(Class clazz, String string, String string2) {
        DisplayDescriptor displayDescriptor = new DisplayDescriptor(clazz, string, string2);
        displayDescriptor.setGroupName("");
        return displayDescriptor;
    }

    private static void setPropertyDefaults(MaltegoLinkSpec maltegoLinkSpec) {
        DisplayDescriptorCollection displayDescriptorCollection = maltegoLinkSpec.getProperties();
        if (maltegoLinkSpec == _manualLinkSpec) {
            displayDescriptorCollection.get(PROP_NAME_MANUAL_TYPE).setDefaultValue((Object)"");
            displayDescriptorCollection.get(PROP_NAME_MANUAL_DESCRIPTION).setDefaultValue((Object)"");
            displayDescriptorCollection.get(PROP_NAME_COLOR).setDefaultValue((Object)MaltegoLinkSpec.getDefaultManualLinkColor());
            displayDescriptorCollection.get(PROP_NAME_THICKNESS).setDefaultValue((Object)2);
        } else {
            displayDescriptorCollection.get(PROP_NAME_COLOR).setDefaultValue((Object)LINK_COLOR_TRANSFORM);
            displayDescriptorCollection.get(PROP_NAME_THICKNESS).setDefaultValue((Object)1);
        }
        displayDescriptorCollection.get(PROP_NAME_SHOW_LABEL).setDefaultValue((Object)0);
        displayDescriptorCollection.get(PROP_NAME_STYLE).setDefaultValue((Object)0);
    }

    private static void setPropertyMappings(MaltegoLinkSpec maltegoLinkSpec) {
        DisplayDescriptorCollection displayDescriptorCollection = maltegoLinkSpec.getProperties();
        if (maltegoLinkSpec == _manualLinkSpec) {
            maltegoLinkSpec.setValueProperty(displayDescriptorCollection.get(PROP_NAME_MANUAL_TYPE));
        } else if (maltegoLinkSpec == _transformLinkSpec) {
            maltegoLinkSpec.setValueProperty(displayDescriptorCollection.get(PROP_NAME_TRANSFORM_DISPLAY));
        }
        maltegoLinkSpec.setShowLabelProperty(displayDescriptorCollection.get(PROP_NAME_SHOW_LABEL));
        maltegoLinkSpec.setColorProperty(displayDescriptorCollection.get(PROP_NAME_COLOR));
        maltegoLinkSpec.setStyleProperty(displayDescriptorCollection.get(PROP_NAME_STYLE));
        maltegoLinkSpec.setThicknessProperty(displayDescriptorCollection.get(PROP_NAME_THICKNESS));
    }

    private static void setPropertyEditors(MaltegoLinkSpec maltegoLinkSpec) {
        int n;
        DisplayDescriptorCollection displayDescriptorCollection = maltegoLinkSpec.getProperties();
        DisplayDescriptor displayDescriptor = displayDescriptorCollection.get(PROP_NAME_SHOW_LABEL);
        OptionEditorDescriptor optionEditorDescriptor = new OptionEditorDescriptor(displayDescriptor.getType());
        for (n = 0; n < MaltegoLink.ShowLabel.length; ++n) {
            optionEditorDescriptor.getItems().add(MaltegoLink.ShowLabel[n], (Object)n);
        }
        displayDescriptor.setEditor((EditorDescriptor)optionEditorDescriptor);
        displayDescriptor = displayDescriptorCollection.get(PROP_NAME_STYLE);
        optionEditorDescriptor = new OptionEditorDescriptor(displayDescriptor.getType());
        for (n = 0; n < MaltegoLink.LineStyle.length; ++n) {
            optionEditorDescriptor.getItems().add(MaltegoLink.LineStyle[n], (Object)n);
        }
        displayDescriptor.setEditor((EditorDescriptor)optionEditorDescriptor);
        displayDescriptor = displayDescriptorCollection.get(PROP_NAME_THICKNESS);
        optionEditorDescriptor = new OptionEditorDescriptor(displayDescriptor.getType());
        for (n = 1; n <= 5; ++n) {
            optionEditorDescriptor.getItems().add(Integer.toString(n), (Object)n);
        }
        displayDescriptor.setEditor((EditorDescriptor)optionEditorDescriptor);
    }

    public void setWeightProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty("weight", displayDescriptor);
    }

    public DisplayDescriptor getWeightProperty() {
        return this.getSpecialProperty("weight");
    }

    public void setShowLabelProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty("show-label", displayDescriptor);
    }

    public DisplayDescriptor getShowLabelProperty() {
        return this.getSpecialProperty("show-label");
    }

    public void setColorProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty("color", displayDescriptor);
    }

    public DisplayDescriptor getColorProperty() {
        return this.getSpecialProperty("color");
    }

    public void setStyleProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty("style", displayDescriptor);
    }

    public DisplayDescriptor getStyleProperty() {
        return this.getSpecialProperty("style");
    }

    public void setThicknessProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty("thickness", displayDescriptor);
    }

    public DisplayDescriptor getThicknessProperty() {
        return this.getSpecialProperty("thickness");
    }
}

