/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Class<T> type;

    @Override
    public void captureHeader(CSVReader cSVReader) throws IOException {
        this.header = cSVReader.readNext();
    }

    @Override
    public PropertyDescriptor findDescriptor(int n) throws IntrospectionException {
        String string = this.getColumnName(n);
        return null != string && string.trim().length() > 0 ? this.findDescriptor(string) : null;
    }

    protected String getColumnName(int n) {
        return null != this.header && n < this.header.length ? this.header[n] : null;
    }

    protected PropertyDescriptor findDescriptor(String string) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap(this.getType());
        }
        return this.descriptorMap.get(string.toUpperCase().trim());
    }

    protected boolean matches(String string, PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().equals(string.trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap(Class<T> clazz) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray;
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = this.loadDescriptors(this.getType())) {
            hashMap.put(propertyDescriptor.getName().toUpperCase().trim(), propertyDescriptor);
        }
        return hashMap;
    }

    private PropertyDescriptor[] loadDescriptors(Class<T> clazz) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> clazz) {
        this.type = clazz;
    }
}

