/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory;

import com.paterva.maltego.imgfactory.ImageFactory;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.openide.util.Lookup;

public abstract class ImageCache
extends ImageFactory {
    public static final int MAX_SIZE = 240;
    private static ImageCache _default;

    public abstract void addImageIcon(Object var1, ImageIcon var2);

    public abstract ImageIcon resizeImageIcon(Object var1, ImageIcon var2, int var3, int var4, ImageCallback var5);

    public abstract void addImage(Object var1, Image var2);

    public abstract Image resizeImage(Object var1, Image var2, int var3, int var4, ImageCallback var5);

    public abstract boolean contains(Object var1);

    public abstract void remove(Object var1);

    public static ImageCache getDefault() {
        if (_default == null && (_default = (ImageCache)Lookup.getDefault().lookup(ImageCache.class)) == null) {
            _default = new TrivialImageCache();
        }
        return _default;
    }

    static class TrivialImageCache
    extends ImageCache {
        TrivialImageCache() {
        }

        @Override
        public ImageIcon getImageIcon(Object object, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public ImageIcon getImageIcon(Object object, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public Image getImage(Object object, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public Image getImage(Object object, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public void addImageIcon(Object object, ImageIcon imageIcon) {
            throw new UnsupportedOperationException("No image cache registered.");
        }

        @Override
        public ImageIcon resizeImageIcon(Object object, ImageIcon imageIcon, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image cache registered.");
        }

        @Override
        public void addImage(Object object, Image image) {
            throw new UnsupportedOperationException("No image cache registered.");
        }

        @Override
        public Image resizeImage(Object object, Image image, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image cache registered.");
        }

        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException("No image cache registered.");
        }

        @Override
        public void remove(Object object) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

