/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewReplace;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;

final class ViewBuilder {
    private static final int MAX_CHARS_FOR_CREATE_LOCAL_VIEWS = 2000;
    private static final Logger LOG = Logger.getLogger(ViewBuilder.class.getName());
    private final ViewReplace<DocumentView, ParagraphView> docReplace;
    private FactoryState[] factoryStates;
    private boolean createLocalViews;
    private int creationOffset;
    private int matchOffset;
    private int modLength;
    private int docViewStartOffset;
    private final int docViewEndBoundOffset;
    private Element lineRoot;
    private int lineIndex;
    private int lineEndOffset;
    private Element lineForParagraphView;
    private ViewReplace<ParagraphView, EditorView> firstReplace;
    private ViewReplace<ParagraphView, EditorView> localReplace;
    private List<ViewReplace<ParagraphView, EditorView>> allReplaces;

    ViewBuilder(DocumentView docView, EditorViewFactory[] viewFactories) {
        this.docReplace = new ViewReplace(docView);
        this.factoryStates = new FactoryState[viewFactories.length];
        for (int i = 0; i < viewFactories.length; ++i) {
            this.factoryStates[i] = new FactoryState(viewFactories[i]);
        }
        this.docViewStartOffset = docView.getStartOffset();
        this.docViewEndBoundOffset = docView.getEndBoundOffset();
        this.createLocalViews = docView.isAccurateSpan();
    }

    void initFullRebuild() {
        this.docReplace.removeTillEnd();
        this.creationOffset = this.docViewStartOffset;
        this.matchOffset = this.docViewEndBoundOffset;
    }

    void initParagraphs(int startRebuildIndex, int endRebuildIndex, int startOffset, int endOffset) {
        this.createLocalViews = true;
        this.docReplace.index = startRebuildIndex;
        this.docReplace.removeCount = endRebuildIndex - startRebuildIndex;
        this.creationOffset = startOffset;
        this.matchOffset = endOffset;
    }

    boolean initRebuild(OffsetRegion rRegion) {
        DocumentView docView = (DocumentView)this.docReplace.view;
        int startAffectedOffset = rRegion.startOffset();
        int endAffectedOffset = rRegion.endOffset();
        int startRebuildIndex = -1;
        if (!(docView.hasExtraStartBound() && endAffectedOffset < this.docViewStartOffset || docView.hasExtraEndBound() && startAffectedOffset >= this.docViewEndBoundOffset)) {
            startRebuildIndex = docView.getViewIndexFirst(startAffectedOffset);
        }
        if (startRebuildIndex == -1) {
            this.factoryStates = null;
            return false;
        }
        this.updateRebuildIndexes(startRebuildIndex, endAffectedOffset);
        this.checkCreateLocalViews(startAffectedOffset, endAffectedOffset);
        this.checkLocalRebuild(startAffectedOffset, endAffectedOffset, 0);
        return true;
    }

    boolean initModUpdate(int modOffset, int modLength, OffsetRegion rRegion) {
        this.modLength = modLength;
        DocumentView docView = (DocumentView)this.docReplace.view;
        int startAffectedOffset = modOffset;
        int endAffectedOffset = modOffset + Math.max(modLength, 1);
        if (rRegion != null) {
            startAffectedOffset = Math.min(startAffectedOffset, rRegion.startOffset());
            endAffectedOffset = Math.max(endAffectedOffset, rRegion.endOffset());
        }
        int startRebuildIndex = -1;
        boolean allowLocalRebuild = true;
        if (!(docView.hasExtraStartBound() && endAffectedOffset < this.docViewStartOffset || docView.hasExtraEndBound() && startAffectedOffset > this.docViewEndBoundOffset)) {
            if (docView.hasExtraStartBound() && modLength > 0 && modOffset + modLength == this.docViewStartOffset) {
                try {
                    docView.setStartPosition(docView.getDocument().createPosition(modOffset));
                    this.docViewStartOffset = modOffset;
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException("Unexpected BadLocationException", ex);
                }
                startRebuildIndex = 0;
                allowLocalRebuild = false;
            } else {
                startRebuildIndex = docView.getViewIndexFirst(startAffectedOffset);
                if (modLength > 0) {
                    if (endAffectedOffset == modOffset + modLength && startRebuildIndex + 1 < docView.getViewCount() && ((ParagraphView)docView.getEditorView(startRebuildIndex + 1)).getStartOffset() == modOffset + modLength) {
                        ++endAffectedOffset;
                        allowLocalRebuild = false;
                    }
                } else if (startAffectedOffset == modOffset && startRebuildIndex < docView.getViewCount() && ((ParagraphView)docView.getEditorView(startRebuildIndex)).getStartOffset() == modOffset) {
                    if (startRebuildIndex > 0) {
                        --startRebuildIndex;
                    } else {
                        allowLocalRebuild = false;
                    }
                }
            }
        }
        if (startRebuildIndex == -1) {
            this.factoryStates = null;
            return false;
        }
        this.updateRebuildIndexes(startRebuildIndex, endAffectedOffset);
        this.checkCreateLocalViews(startAffectedOffset, endAffectedOffset);
        if (allowLocalRebuild) {
            this.checkLocalRebuild(startAffectedOffset, endAffectedOffset, modLength);
        }
        return true;
    }

    private void updateRebuildIndexes(int startRebuildIndex, int endAffectedOffset) {
        DocumentView docView = (DocumentView)this.docReplace.view;
        this.docReplace.index = startRebuildIndex;
        this.creationOffset = startRebuildIndex != 0 ? ((ParagraphView)docView.getEditorView(startRebuildIndex)).getStartOffset() : this.docViewStartOffset;
        int pViewCount = docView.getViewCount();
        int endRebuildIndex = this.docReplace.index;
        this.matchOffset = this.docViewEndBoundOffset;
        if (endRebuildIndex < pViewCount && ++endRebuildIndex < pViewCount) {
            int nextParagraphViewOffset = docView.getView(endRebuildIndex).getStartOffset();
            if (endAffectedOffset > nextParagraphViewOffset) {
                endRebuildIndex = docView.getViewIndexFirst(endAffectedOffset) + 1;
                if (endRebuildIndex < pViewCount) {
                    this.matchOffset = docView.getView(endRebuildIndex).getStartOffset();
                }
            } else {
                this.matchOffset = nextParagraphViewOffset;
            }
        }
        this.docReplace.removeCount = endRebuildIndex - this.docReplace.index;
    }

    private void checkCreateLocalViews(int startAffectedOffset, int endAffectedOffset) {
        if (!this.createLocalViews) {
            this.createLocalViews = endAffectedOffset - startAffectedOffset < 2000;
        }
    }

    private void checkLocalRebuild(int startAffectedOffset, int endAffectedOffset, int modLength) {
        ParagraphView pView;
        if (this.docReplace.removeCount == 1 && (pView = (ParagraphView)((DocumentView)this.docReplace.view).getEditorView(this.docReplace.index)).getViewCount() > 0) {
            int startLocalIndex = pView.getViewIndexFirst(startAffectedOffset - 1);
            Object startLocalView = pView.getEditorView(startLocalIndex);
            int localViewCount = pView.getViewCount();
            int origEndAffectedOffset = endAffectedOffset - modLength;
            int pViewStartOffset = pView.getStartOffset();
            if (startAffectedOffset > pViewStartOffset && origEndAffectedOffset <= pView.getEndOffset()) {
                Object localView = pView.getEditorView(startLocalIndex);
                int endLocalIndex = origEndAffectedOffset <= ((View)localView).getEndOffset() ? startLocalIndex + 1 : Math.min(pView.getViewIndexFirst(origEndAffectedOffset) + 1, localViewCount);
                if (startLocalIndex > 0 || endLocalIndex < localViewCount) {
                    this.firstReplace = new ViewReplace(pView);
                    this.firstReplace.index = startLocalIndex;
                    this.firstReplace.removeCount = endLocalIndex - startLocalIndex;
                    this.creationOffset = ((View)startLocalView).getStartOffset();
                    if (endLocalIndex < localViewCount) {
                        this.matchOffset = pView.getView(endLocalIndex).getStartOffset() + modLength;
                    }
                    this.localReplace = this.firstReplace;
                    ++this.docReplace.index;
                    --this.docReplace.removeCount;
                }
            }
        }
    }

    void createViews() {
        if (this.creationOffset > this.matchOffset) {
            throw new IllegalStateException("creationOffset=" + this.creationOffset + " > matchOffset=" + this.matchOffset);
        }
        Document doc = ((DocumentView)this.docReplace.view).getDocument();
        this.lineRoot = doc.getDefaultRootElement();
        this.lineIndex = this.lineRoot.getElementIndex(this.creationOffset);
        Element line = this.lineRoot.getElement(this.lineIndex);
        this.lineEndOffset = line.getEndOffset();
        this.lineForParagraphView = line;
        for (int i = 0; i < this.factoryStates.length; ++i) {
            FactoryState state = this.factoryStates[i];
            state.init(this.creationOffset, this.matchOffset);
        }
        this.allReplaces = new ArrayList<ViewReplace<ParagraphView, EditorView>>(2);
        if (this.creationOffset < this.matchOffset) {
            while (this.createNextView()) {
            }
        }
        if (this.localReplace != null && this.localReplace != this.firstReplace) {
            assert (((DocumentView)this.docReplace.view).hasExtraEndBound()) : "No ending newline view for document view without explicit start bound.";
            int length = this.creationOffset - ((ParagraphView)this.localReplace.view).getStartOffset();
            ((ParagraphView)this.localReplace.view).setLength(length);
            this.localReplace = null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ViewBuilder-creationEndOffset=" + this.creationOffset + "\n");
        }
        if (LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finer("ViewBuilder-Original:\n" + ((DocumentView)this.docReplace.view).toStringDetail() + '\n');
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder.createViews():\n");
            sb.append("Creation for document: ").append(doc).append('\n');
            if (this.firstReplace != null) {
                sb.append("firstReplace:").append(this.firstReplace);
            }
            sb.append("docReplace:").append(this.docReplace);
            sb.append("pReplaceList:\n");
            int digitCount = ArrayUtilities.digitCount((int)this.allReplaces.size());
            for (int i = 0; i < this.allReplaces.size(); ++i) {
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append(this.allReplaces.get(i));
            }
            LOG.fine(sb.toString());
        }
    }

    boolean createNextView() {
        int limitOffset = this.matchOffset;
        for (int i = this.factoryStates.length - 1; i >= 0; --i) {
            FactoryState state = this.factoryStates[i];
            int cmp = state.nextViewStartOffset - this.creationOffset;
            if (cmp < 0) {
                state.updateNextViewStartOffset(this.creationOffset);
                cmp = state.nextViewStartOffset - this.creationOffset;
            }
            if (cmp == 0) {
                int index;
                boolean inFirstReplace;
                int createdViewEndOffset;
                EditorView view = null;
                if (this.createLocalViews) {
                    view = state.factory.createView(this.creationOffset, limitOffset);
                    if (view == null) continue;
                    int viewLength = view.getLength();
                    createdViewEndOffset = this.creationOffset + viewLength;
                    assert (viewLength > 0) : "viewLength=" + viewLength + " < 0";
                } else {
                    createdViewEndOffset = state.factory.viewEndOffset(this.creationOffset, limitOffset);
                    if (createdViewEndOffset == -1) continue;
                }
                this.updateLine(createdViewEndOffset);
                boolean eolView = createdViewEndOffset == this.lineEndOffset;
                boolean bl = inFirstReplace = this.localReplace == this.firstReplace && this.firstReplace != null;
                if (eolView && inFirstReplace) {
                    this.firstReplace.removeCount = ((ParagraphView)this.firstReplace.view).getViewCount() - this.firstReplace.index;
                    index = this.docReplace.removeEndIndex();
                    this.matchOffset = index < ((DocumentView)this.docReplace.view).getViewCount() ? ((ParagraphView)((DocumentView)this.docReplace.view).getEditorView(index)).getStartOffset() : this.docViewEndBoundOffset;
                }
                if (createdViewEndOffset > this.matchOffset) {
                    if (inFirstReplace) {
                        int localViewCount = ((ParagraphView)this.firstReplace.view).getViewCount();
                        while ((index = this.firstReplace.removeEndIndex()) < localViewCount) {
                            this.matchOffset += ((EditorView)((ParagraphView)this.localReplace.view).getEditorView(index)).getLength();
                            ++this.localReplace.removeCount;
                            if (createdViewEndOffset > this.matchOffset) continue;
                            break;
                        }
                    } else {
                        int pViewCount = ((DocumentView)this.docReplace.view).getViewCount();
                        if (this.docReplace.removeEndIndex() < pViewCount) {
                            do {
                                int index2;
                                if ((index2 = this.docReplace.removeNext()) >= pViewCount) {
                                    this.matchOffset = this.docViewEndBoundOffset;
                                    break;
                                }
                                this.matchOffset = ((ParagraphView)((DocumentView)this.docReplace.view).getEditorView(index2)).getStartOffset();
                            } while (createdViewEndOffset > this.matchOffset);
                        }
                    }
                }
                if (this.localReplace == null) {
                    Position startPos;
                    if (this.creationOffset == this.docViewStartOffset && this.docViewStartOffset != 0) {
                        startPos = ((DocumentView)this.docReplace.view).getStartPosition();
                    } else if (this.lineForParagraphView instanceof Position && this.creationOffset == this.lineForParagraphView.getStartOffset()) {
                        startPos = (Position)((Object)this.lineForParagraphView);
                    } else {
                        try {
                            startPos = ((DocumentView)this.docReplace.view).getDocument().createPosition(this.creationOffset);
                        }
                        catch (BadLocationException e) {
                            throw new IllegalStateException("Cannot create position at offset=" + this.creationOffset, e);
                        }
                    }
                    ParagraphView paragraphView = new ParagraphView(startPos);
                    this.docReplace.add(paragraphView);
                    this.localReplace = new ViewReplace(paragraphView);
                    if (this.createLocalViews) {
                        this.allReplaces.add(this.localReplace);
                    }
                }
                if (this.createLocalViews) {
                    this.localReplace.add(view);
                }
                if (eolView) {
                    if (this.localReplace != this.firstReplace) {
                        int length = createdViewEndOffset - ((ParagraphView)this.localReplace.view).getStartOffset();
                        ((ParagraphView)this.localReplace.view).setLength(length);
                    }
                    this.localReplace = null;
                    this.lineForParagraphView = this.lineIndex + 1 < this.lineRoot.getElementCount() ? this.lineRoot.getElement(this.lineIndex + 1) : null;
                }
                this.creationOffset = createdViewEndOffset;
                return this.creationOffset < this.matchOffset;
            }
            if (state.nextViewStartOffset >= limitOffset) continue;
            limitOffset = state.nextViewStartOffset;
        }
        throw new IllegalStateException("No factory returned view for offset=" + this.creationOffset);
    }

    private void replaceAndRepaintViews() {
        DocumentView docView = (DocumentView)this.docReplace.view;
        final JTextComponent textComponent = docView.getTextComponent();
        final Rectangle repaintBounds = new Rectangle(0, 0, -1, -1);
        assert (textComponent != null) : "Null textComponent";
        boolean docViewHeightChanged = false;
        boolean docViewWidthChanged = false;
        Rectangle2D.Double docViewBounds = docView.getAllocation();
        TextLayoutCache textLayoutCache = docView.getTextLayoutCache();
        VisualUpdate fUpdate = null;
        if (this.firstReplace != null && (fUpdate = this.firstReplace.replaceViews(this.modLength)) != null) {
            Shape childAlloc = docView.getChildAllocation(this.docReplace.index - 1, docViewBounds);
            fUpdate.updateSpansAndLayout(childAlloc);
            if (fUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= fUpdate.isWidthChanged();
                docViewHeightChanged |= fUpdate.isHeightChanged();
            }
            if (!fUpdate.getRepaintBounds().isEmpty()) {
                repaintBounds.add(fUpdate.getRepaintBounds());
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("firstReplace:REPAINT:" + ViewUtils.toString(fUpdate.getRepaintBounds()) + '\n');
                }
            }
        }
        for (int i = 0; i < this.docReplace.removeCount; ++i) {
            ParagraphView paragraphView = (ParagraphView)docView.getEditorView(this.docReplace.index + i);
            if (paragraphView.children == null) continue;
            textLayoutCache.remove(paragraphView);
        }
        this.docReplace.retainSpans();
        VisualUpdate dUpdate = this.docReplace.replaceViews(0);
        for (int i = 0; i < this.allReplaces.size(); ++i) {
            ViewReplace<ParagraphView, EditorView> replace = this.allReplaces.get(i);
            VisualUpdate pUpdate = replace.replaceViews(0);
            if (pUpdate == null) continue;
            Shape childAlloc = docView.getChildAllocation(this.docReplace.index + i, docViewBounds);
            pUpdate.updateSpansAndLayout(childAlloc);
            if (pUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= pUpdate.isWidthChanged();
                docViewHeightChanged |= pUpdate.isHeightChanged();
            }
            if (pUpdate.getRepaintBounds().isEmpty()) continue;
            repaintBounds.add(pUpdate.getRepaintBounds());
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.fine("pReplaceList[" + i + "]:REPAINT:" + ViewUtils.toString(pUpdate.getRepaintBounds()) + '\n');
        }
        if (dUpdate != null) {
            dUpdate.updateSpansAndLayout(docViewBounds);
            if (dUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= dUpdate.isWidthChanged();
                docViewHeightChanged |= dUpdate.isHeightChanged();
            }
            if (!dUpdate.getRepaintBounds().isEmpty()) {
                repaintBounds.add(dUpdate.getRepaintBounds());
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("docReplace:REPAINT:" + ViewUtils.toString(dUpdate.getRepaintBounds()) + '\n');
                }
            }
        }
        if (fUpdate != null && fUpdate.isPreferenceChanged()) {
            docView.preferenceChanged(this.docReplace.index - 1, fUpdate.isWidthChanged(), fUpdate.isHeightChanged(), false);
        }
        if (!repaintBounds.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.fine("REPAINT-bounds:" + ViewUtils.toString(repaintBounds) + '\n');
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewUtils.repaint(textComponent, repaintBounds);
                }
            });
        }
        if (docViewWidthChanged || docViewHeightChanged) {
            docView.preferenceChanged(null, docViewWidthChanged, docViewHeightChanged);
        }
    }

    void createReplaceAndRepaintViews() {
        this.createViews();
        this.replaceAndRepaintViews();
    }

    void finish() {
        if (this.factoryStates != null) {
            for (FactoryState factoryState : this.factoryStates) {
                factoryState.factory.finish();
            }
        }
        ((DocumentView)this.docReplace.view).checkIntegrityIfLoggable();
    }

    void updateLine(int offset) {
        while (offset > this.lineEndOffset) {
            ++this.lineIndex;
            Element line = this.lineRoot.getElement(this.lineIndex);
            this.lineEndOffset = line.getEndOffset();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("-------- ViewBuilder dump -------\n");
        sb.append("creationOffset=").append(this.creationOffset).append('\n');
        sb.append("docViewEndBoundOffset=").append(this.docViewEndBoundOffset).append('\n');
        sb.append("lineIndex=").append(this.lineIndex).append('\n');
        sb.append("lineEndOffset=").append(this.lineEndOffset).append('\n');
        sb.append("matchOffset=").append(this.matchOffset).append('\n');
        sb.append("modLength=").append(this.modLength).append('\n');
        sb.append("firstReplace=").append(this.firstReplace).append('\n');
        sb.append("docReplace=").append(this.docReplace).append('\n');
        sb.append("pReplace=").append(this.localReplace).append('\n');
        sb.append("pReplaceList=").append(this.allReplaces).append('\n');
        sb.append("-------- End of ViewBuilder dump -------\n");
        return sb.toString();
    }

    private static final class FactoryState {
        final EditorViewFactory factory;
        int nextViewStartOffset;

        FactoryState(EditorViewFactory factory) {
            this.factory = factory;
        }

        void init(int startOffset, int matchOffset) {
            this.factory.restart(startOffset, matchOffset);
            this.updateNextViewStartOffset(startOffset);
        }

        void updateNextViewStartOffset(int offset) {
            this.nextViewStartOffset = this.factory.nextViewStartOffset(offset);
            if (this.nextViewStartOffset < offset) {
                throw new IllegalStateException("Editor view factory " + this.factory + " returned nextViewStartOffset=" + this.nextViewStartOffset + " < offset=" + offset);
            }
        }
    }
}

