/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.image;

import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.view2d.ExportCookie;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAsImageAction
extends CookieAction<ExportCookie> {
    public ExportAsImageAction() {
        super(ExportCookie.class);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return "Export Graph As Image";
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected String iconResource() {
        return "com/paterva/maltego/reporting/resources/ExportImage.png";
    }

    protected void performAction(ExportCookie exportCookie) {
        Object object;
        Map map = exportCookie.getFileTypes();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (Map.Entry object22 : map.entrySet()) {
            object = new FileNameExtensionFilter((String)object22.getValue(), (String)object22.getKey());
            jFileChooser.addChoosableFileFilter((FileFilter)object);
        }
        JLabel jLabel = new JLabel("Scale image:");
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"100%", "200%", "300%", "400%", "500%"});
        jLabel.setAlignmentX(0.0f);
        jComboBox.setAlignmentX(0.0f);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(jLabel);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, 5)));
        ((Container)object).add(jComboBox);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "North");
        jFileChooser.setAccessory(jPanel);
        if (jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0];
            if (!file.getName().toLowerCase().endsWith("." + string.toLowerCase())) {
                file = new File(file.getPath() + "." + string);
            }
            try {
                exportCookie.exportToFile(file, (double)(jComboBox.getSelectedIndex() + 1));
                NotifyDescriptor.Message iOException = new NotifyDescriptor.Message((Object)"Image generated successfully.", 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)iOException);
            }
            catch (IOException iOException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Could not write to output file.\n" + iOException.getMessage()), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
    }
}

