/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.FileStore;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AttachmentsOpenAction
extends NodeAction {
    public String getName() {
        return "Open";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        List<Attachment> list = this.getAttachments(nodeArray);
        Desktop desktop = Desktop.getDesktop();
        for (Attachment attachment : list) {
            File file = null;
            try {
                file = FileStore.getDefault().get(attachment.getId());
                try {
                    desktop.open(file);
                }
                catch (IOException iOException) {
                    this.showCouldNotOpen(iOException, file.getName());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
        }
    }

    public boolean enable(Node[] nodeArray) {
        return Desktop.isDesktopSupported() && !this.getAttachments(nodeArray).isEmpty();
    }

    private List<Attachment> getAttachments(Node[] nodeArray) {
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (Node node : nodeArray) {
            Attachment attachment = (Attachment)node.getLookup().lookup(Attachment.class);
            if (attachment == null) continue;
            arrayList.add(attachment);
        }
        return arrayList;
    }

    private void showCouldNotOpen(IOException iOException, String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("The JVM was unable to find an application associated with the \"Open\" command for the file: " + string), 0);
        message.setTitle("Could not open file");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }
}

