/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ObjectEditor
extends JComponent {
    private DisplayDescriptor _descriptor;
    private ControlAdapter _adapter;
    private Component _component;
    private EventListenerList _listeners;
    private ActionListener _actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ObjectEditor.this.fireActionPerformed(actionEvent);
        }
    };
    private ChangeListener _changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ObjectEditor.this.fireChange(changeEvent);
        }
    };

    public ObjectEditor() {
        this(String.class);
    }

    public ObjectEditor(Class clazz) {
        this(new DisplayDescriptor(clazz, "value"));
    }

    public ObjectEditor(DisplayDescriptor displayDescriptor) {
        try {
            this.setDescriptor(displayDescriptor);
        }
        catch (UnsupportedEditorException unsupportedEditorException) {
            try {
                this.setDescriptor(new DisplayDescriptor(String.class, "value"));
            }
            catch (UnsupportedEditorException unsupportedEditorException2) {
                // empty catch block
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners().add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners().remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this._listeners != null) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    protected void fireChange(ChangeEvent changeEvent) {
        if (this._listeners != null) {
            ChangeListener[] changeListenerArray;
            for (ChangeListener changeListener : changeListenerArray = (ChangeListener[])this._listeners.getListeners(ChangeListener.class)) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners().add(ChangeListener.class, changeListener);
    }

    public void removeChangeistener(ChangeListener changeListener) {
        this.listeners().remove(ChangeListener.class, changeListener);
    }

    public Object getValue() {
        return this.getAdapter().getValue(this._component);
    }

    public void setValue(Object object) {
        this.getAdapter().setValue(this._component, object);
    }

    public Class getDataType() {
        return this._descriptor.getType();
    }

    public void setDataType(Class clazz) throws UnsupportedEditorException {
        this.setDescriptor(new DisplayDescriptor(clazz, "value"));
    }

    public DisplayDescriptor getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(DisplayDescriptor displayDescriptor) throws UnsupportedEditorException {
        this._descriptor = displayDescriptor;
        this.setAdapter(DefaultAdapterFactory.instance().create(displayDescriptor));
        this._component = this.getAdapter().createComponent();
        this.removeAll();
        Dimension dimension = this._component.getPreferredSize();
        this._component.setSize(this.getWidth(), dimension.height);
        this._component.setEnabled(this.isEnabled());
        this.add(this._component);
        this.revalidate();
        this.repaint();
    }

    private void setAdapter(ControlAdapter controlAdapter) {
        if (this._adapter != controlAdapter) {
            if (this._adapter != null) {
                this._adapter.removeActionListener(this._actionListener);
                this._adapter.removeChangeListener(this._changeListener);
            }
            this._adapter = controlAdapter;
            this._adapter.addActionListener(this._actionListener);
            this._adapter.addChangeListener(this._changeListener);
        }
    }

    private ControlAdapter getAdapter() {
        return this._adapter;
    }

    public boolean isEmpty() {
        return this.getAdapter().isEmpty(this._component);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._component != null) {
            this._component.setEnabled(bl);
        }
    }
}

