/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.controls.ArrayEditorPanel;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import com.paterva.maltego.typing.editing.propertygrid.editors.TypePropertyEditor;
import com.paterva.maltego.util.ArrayUtilities;
import java.awt.Component;
import java.text.Format;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

class ArrayPropertyEditor
extends TypePropertyEditor {
    private ArrayEditorPanel _editor;

    public ArrayPropertyEditor(Class clazz, Format format) {
        super(clazz, format);
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("The array editor can only used with array types");
        }
    }

    @Override
    public Component getCustomEditor() {
        if (this._editor == null) {
            try {
                this._editor = new ArrayEditorPanel(DefaultAdapterFactory.instance().create(this.getType().getComponentType(), this.getFormat()), this.getFormat());
            }
            catch (UnsupportedEditorException unsupportedEditorException) {
                Exceptions.printStackTrace((Throwable)unsupportedEditorException);
                return null;
            }
            this.updateEditor();
            this._editor.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ArrayPropertyEditor.this.updateValues();
                }
            });
        }
        return this._editor;
    }

    private void updateEditor() {
        if (this._editor != null) {
            this._editor.setValue((Object[])Converter.changeArrayType((Object)this.getValue(), (Class)Converter.getReferenceType(this.getType().getComponentType())));
        }
    }

    private void updateValues() {
        Class<?> clazz = this.getType().getComponentType();
        Object[] objectArray = this._editor.getValue();
        Class clazz2 = Converter.getReferenceType(clazz);
        Object[] objectArray2 = (Object[])Converter.changeArrayType((Object)objectArray, (Class)clazz2);
        if (!clazz.isPrimitive()) {
            this.setValue(objectArray2);
        } else {
            Class<?> clazz3 = objectArray2.getClass().getComponentType();
            if (Boolean.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Boolean[])((Boolean[])objectArray2)));
            } else if (Character.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Character[])((Character[])objectArray2)));
            } else if (Integer.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Integer[])((Integer[])objectArray2)));
            } else if (Byte.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Byte[])((Byte[])objectArray2)));
            } else if (Short.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Short[])((Short[])objectArray2)));
            } else if (Long.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Long[])((Long[])objectArray2)));
            } else if (Float.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Float[])((Float[])objectArray2)));
            } else if (Double.class.equals(clazz3)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Double[])((Double[])objectArray2)));
            }
        }
    }

    @Override
    public void setAsText(String string) {
        super.setAsText(string);
        this.updateEditor();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

