/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class OpenOptionProcessor
extends OptionProcessor {
    private static Option DEFAULT = Option.defaultArguments();
    private static Option OPEN = Option.additionalArguments((char)'o', (String)"open");

    protected Set<Option> getOptions() {
        HashSet<Option> hashSet = new HashSet<Option>();
        hashSet.add(DEFAULT);
        hashSet.add(OPEN);
        return hashSet;
    }

    protected void process(Env env, Map<Option, String[]> map) throws CommandException {
        final ArrayList<File> arrayList = new ArrayList<File>();
        OpenOptionProcessor.addFiles(arrayList, map.get(DEFAULT));
        OpenOptionProcessor.addFiles(arrayList, map.get(OPEN));
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                OpenOptionProcessor.openFiles(arrayList);
            }
        });
    }

    private static void openFiles(List<File> list) {
        for (File file : list) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                OpenCookie openCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject == null || (openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class)) == null) continue;
                openCookie.open();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    private static void addFiles(List<File> list, String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                File file = new File(string);
                if (!file.exists()) continue;
                list.add(file);
            }
        }
    }
}

