/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.ui.graph.BookmarkFactory;
import com.paterva.maltego.ui.graph.nodes.BookmarkPropertyEditor;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import yguard.A.A.Y;

public class EntityProperties
extends PartProperties {
    protected EntityProperties() {
    }

    public static Sheet createSheet(Node node, MaltegoEntity maltegoEntity, MaltegoEntitySpec maltegoEntitySpec) {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        Sheet.Set set = sheet.get("");
        set.put((Node.Property)new Type(node));
        EntityNode entityNode = (EntityNode)node;
        EntityRegistry entityRegistry = EntityProperties.getRegistry(entityNode);
        EntityProperties.addProperties((SpecRegistry)entityRegistry, sheet, (MaltegoPart)maltegoEntity, EntityProperties.getSpecPropertyConfig(entityRegistry, maltegoEntity.getTypeName()));
        Object object = InheritanceHelper.getValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (object != null) {
            set.put((Node.Property)new Value(node, object.getClass()));
        }
        Sheet.Set set2 = PropertySheetFactory.getSet((Sheet)sheet, (String)"graphinfo", (String)"Graph info", (String)"Properties related to the graph");
        set2.put((Node.Property)new Weight(node));
        set2.put((Node.Property)new IncomingLinks(node));
        set2.put((Node.Property)new OutgoingLinks(node));
        set2.put((Node.Property)new Bookmark(node));
        return sheet;
    }

    private static PropertyConfiguration getSpecPropertyConfig(EntityRegistry entityRegistry, String string) {
        DisplayDescriptorCollection displayDescriptorCollection = EntityProperties.getSpecProperties(entityRegistry, string);
        GroupDefinitions groupDefinitions = EntityProperties.getSpecGroups(entityRegistry, string);
        return new PropertyConfiguration((DisplayDescriptorEnumeration)displayDescriptorCollection, groupDefinitions);
    }

    private static DisplayDescriptorCollection getSpecProperties(EntityRegistry entityRegistry, String string) {
        return InheritanceHelper.getAggregatedProperties((SpecRegistry)entityRegistry, (String)string);
    }

    private static GroupDefinitions getSpecGroups(EntityRegistry entityRegistry, String string) {
        return InheritanceHelper.getAggregatedPropertyGroups((SpecRegistry)entityRegistry, (String)string);
    }

    private static EntityRegistry getRegistry(EntityNode entityNode) {
        EntityRegistry entityRegistry;
        GraphNode graphNode = entityNode.findGraphNode();
        if (graphNode != null && (entityRegistry = (EntityRegistry)graphNode.getLookup().lookup(EntityRegistry.class)) != null) {
            return entityRegistry;
        }
        return null;
    }

    public static Node.Property value() {
        return new Value(Node.EMPTY, Object.class);
    }

    public static Node.Property type() {
        return new Type(Node.EMPTY);
    }

    public static Node.Property weight() {
        return new Weight(Node.EMPTY);
    }

    public static Node.Property incomingLinks() {
        return new IncomingLinks(Node.EMPTY);
    }

    public static Node.Property outgoingLinks() {
        return new OutgoingLinks(Node.EMPTY);
    }

    public static Node.Property bookmark() {
        return new Bookmark(Node.EMPTY);
    }

    public static class Bookmark
    extends NodePropertySupport.ReadWrite<Integer> {
        private PropertyEditor _editor;

        public Bookmark(Node node) {
            super(node, "maltego.fixed.bookmark", Integer.class, "Bookmark", "The bookmark color of the entity if it is bookmarked.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            return maltegoEntity.getBookmark();
        }

        public void setValue(Integer n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            maltegoEntity.setBookmark(n);
        }

        public PropertyEditor getPropertyEditor() {
            if (this._editor == null) {
                OptionItemCollection optionItemCollection = new OptionItemCollection(Integer.TYPE, null);
                optionItemCollection.add(null);
                for (int i = 0; i < BookmarkFactory.getDefault().getBookmarkCount(); ++i) {
                    optionItemCollection.add((Object)i);
                }
                this._editor = new BookmarkPropertyEditor(optionItemCollection);
            }
            return this._editor;
        }
    }

    public static class Value
    extends NodePropertySupport.ReadOnly {
        public Value(Node node, Class clazz) {
            super(node, "maltego.calculated.value", String.class, "Value", "The main value of entity.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            EntityRegistry entityRegistry = EntityProperties.getRegistry((EntityNode)this.node());
            return InheritanceHelper.getValueString((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            EntityRegistry entityRegistry = EntityProperties.getRegistry((EntityNode)this.node());
            InheritanceHelper.setValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity, (Object)object);
        }
    }

    public static class OutgoingLinks
    extends NodePropertySupport.ReadOnly<Integer> {
        public OutgoingLinks(Node node) {
            super(node, "maltego.fixed.outgoinglinks", Integer.class, "Outgoing links", "The number of links that have this entity as a source.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            Y y = (Y)this.node().getLookup().lookup(Y.class);
            return y.C();
        }
    }

    public static class IncomingLinks
    extends NodePropertySupport.ReadOnly<Integer> {
        public IncomingLinks(Node node) {
            super(node, "maltego.fixed.incominglinks", Integer.class, "Incoming links", "The number of links that have this entity as a target.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            Y y = (Y)this.node().getLookup().lookup(Y.class);
            return y.O();
        }
    }

    public static class Weight
    extends NodePropertySupport.ReadOnly<Integer> {
        public Weight(Node node) {
            super(node, "maltego.fixed.weight", Integer.class, "Weight", "Weight is a measurement of the rank of an entity resulting from a search operation.");
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            return maltegoEntity.getWeight();
        }
    }

    public static class Type
    extends NodePropertySupport.ReadOnly<String> {
        public Type(Node node) {
            super(node, "maltego.fixed.type", String.class, "Type", "The type of entity.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)this.node().getLookup().lookup(MaltegoEntitySpec.class);
            if (maltegoEntitySpec == null) {
                MaltegoEntity maltegoEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
                return maltegoEntity.getTypeName();
            }
            return maltegoEntitySpec.getDisplayName();
        }
    }
}

