/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.nodes.EdgeToLinkConverter;
import com.paterva.maltego.ui.graph.nodes.EdgeToLinkSpecConverter;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import com.paterva.maltego.ui.graph.nodes.LinkProperties;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import yguard.A.A.H;

class LinkNode
extends AbstractNode {
    private PropertyChangeListener _linkListener;

    public LinkNode(H h, EdgeToLinkConverter edgeToLinkConverter) {
        this(h, edgeToLinkConverter, new InstanceContent());
    }

    public LinkNode(H h, EdgeToLinkConverter edgeToLinkConverter, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        instanceContent.add((Object)h);
        instanceContent.add((Object)h, (InstanceContent.Convertor)edgeToLinkConverter);
        instanceContent.add((Object)this, (InstanceContent.Convertor)EdgeToLinkSpecConverter.instance());
        this._linkListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("properties".equals(propertyChangeEvent.getPropertyName())) {
                    LinkNode.this.refreshProperties();
                } else if ("displayValue".equals(propertyChangeEvent.getPropertyName())) {
                    LinkNode.this.fireDisplayNameChange(null, null);
                }
            }
        };
        MaltegoLink maltegoLink = edgeToLinkConverter.getGraph().link(h);
        if (maltegoLink == null) {
            System.out.println("NULL link for graph" + Integer.toHexString(System.identityHashCode(edgeToLinkConverter.getGraph().getGraph())));
            return;
        }
        assert (maltegoLink != null);
        MaltegoLink maltegoLink2 = (MaltegoLink)this.getLookup().lookup(MaltegoLink.class);
        assert (maltegoLink == maltegoLink2);
        maltegoLink2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._linkListener, (Object)maltegoLink2));
    }

    public Image getIcon(int n) {
        return this.getLinkSpec().getIcon(this.getSize(n));
    }

    private int getSize(int n) {
        if (n == 1 || n == 3) {
            return 16;
        }
        return 32;
    }

    public String getDisplayName() {
        String string = InheritanceHelper.getDisplayString((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)this.getLink());
        if (StringUtilities.isNullOrEmpty((String)string)) {
            string = "maltego.link.transform-link".equals(this.getLinkSpec().getTypeName()) ? "transform" : "link";
        }
        return string;
    }

    private MaltegoLink getLink() {
        return (MaltegoLink)this.getLookup().lookup(MaltegoLink.class);
    }

    private MaltegoLinkSpec getLinkSpec() {
        return (MaltegoLinkSpec)this.getLookup().lookup(MaltegoLinkSpec.class);
    }

    private void refreshProperties() {
        this.setSheet(this.createSheet());
    }

    protected Sheet createSheet() {
        MaltegoLink maltegoLink = this.getLink();
        MaltegoLinkSpec maltegoLinkSpec = this.getLinkSpec();
        return LinkProperties.createSheet((Node)this, maltegoLink, maltegoLinkSpec);
    }

    public void destroy() throws IOException {
        super.destroy();
        this.findGraphNode().remove((Node)this);
    }

    GraphNode findGraphNode() {
        Node node;
        for (node = this.getParentNode(); node != null && !(node instanceof GraphNode); node = node.getParentNode()) {
        }
        if (node instanceof GraphNode) {
            return (GraphNode)node;
        }
        return null;
    }
}

