/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import com.paterva.maltego.ui.graph.nodes.PartProperties;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import yguard.A.A.H;

public class LinkProperties
extends PartProperties {
    protected LinkProperties() {
    }

    public static Sheet createSheet(Node node, MaltegoLink maltegoLink, MaltegoLinkSpec maltegoLinkSpec) {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        LinkProperties.addProperties((SpecRegistry)LinkRegistry.getDefault(), sheet, (MaltegoPart)maltegoLink, maltegoLinkSpec.getPropertyConfiguration());
        Sheet.Set set = sheet.get("");
        set.put((Node.Property)new Source(node));
        set.put((Node.Property)new Target(node));
        return sheet;
    }

    public static Node.Property source() {
        return new Source(Node.EMPTY);
    }

    public static Node.Property target() {
        return new Target(Node.EMPTY);
    }

    public static class Target
    extends NodePropertySupport.ReadOnly<String> {
        public Target(Node node) {
            super(node, "maltego.link.target", String.class, "Target", "The link target.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() {
            H h = (H)this.node().getLookup().lookup(H.class);
            if (h != null) {
                GraphNodeManager graphNodeManager = GraphNodeManager.getInstance(h.a());
                return graphNodeManager.getNode(h.V()).getDisplayName();
            }
            return null;
        }
    }

    public static class Source
    extends NodePropertySupport.ReadOnly<String> {
        public Source(Node node) {
            super(node, "maltego.link.source", String.class, "Source", "The link source.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", PartProperties.EMPTY_ICON);
        }

        public String getValue() {
            H h = (H)this.node().getLookup().lookup(H.class);
            if (h != null) {
                GraphNodeManager graphNodeManager = GraphNodeManager.getInstance(h.a());
                return graphNodeManager.getNode(h.X()).getDisplayName();
            }
            return null;
        }
    }
}

