/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.GraphHoverContext;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.ViewCallback;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.BendClearingMoveMode;
import com.paterva.maltego.ui.graph.view2d.CreateEdgeViewMode;
import com.paterva.maltego.ui.graph.view2d.Cursors;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewDescriptor;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewDropSupport;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewExporter;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewPrinter;
import com.paterva.maltego.ui.graph.view2d.MouseWheelZoomListener;
import com.paterva.maltego.ui.graph.view2d.NodeHelper;
import com.paterva.maltego.ui.graph.view2d.NodePopupMode;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.ui.graph.view2d.SelectionBoxViewMode;
import com.paterva.maltego.ui.graph.view2d.SelectionStateObserver;
import com.paterva.maltego.ui.graph.view2d.SloppyTooltipMode;
import com.paterva.maltego.util.ColorUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.I.;
import yguard.A.I.CC;
import yguard.A.I.DC;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.WA;
import yguard.A.I.X;
import yguard.A.I.Y;
import yguard.A.I.eA;
import yguard.A.I.fB;
import yguard.A.I.o;
import yguard.A.I.rA;
import yguard.A.J.M;

public class Graph2DViewAdapter
implements ViewControlAdapter {
    private S _view;
    private GraphSelectionHandler _graphHandler = new GraphSelectionHandler();
    private ExplorerSelectionHandler _explorerHandler = new ExplorerSelectionHandler();
    private ViewCallback _viewCallback;
    private Rectangle _initialZoom = null;
    private boolean _firstShowing = true;

    @Override
    public void setGraph(D d2) {
        if (d2 instanceof QA && this._view.H() != d2) {
            o o2;
            QA qA = (QA)d2;
            QA qA2 = this._view.H();
            if (qA2 != null) {
                qA2.B((Y)this._graphHandler);
                qA2.B((_)this._graphHandler);
            }
            this._view.A(qA);
            qA.A((Y)this._graphHandler);
            d2.A((_)this._graphHandler);
            .A a2 = this.getDescriptor().createDefaultNodeRealizer();
            if (a2 != null) {
                qA.B(a2);
            }
            if ((o2 = this.getDescriptor().createDefaultEdgeRealizer()) != null) {
                qA.A(o2);
            }
            qA.A(this._viewCallback.getCopyFactory());
            this.onGraphChanged(qA2, qA);
        }
    }

    public void setInitialZoom(Rectangle rectangle) {
        this._initialZoom = rectangle;
    }

    @Override
    public D getGraph() {
        return this._view.H();
    }

    protected void onGraphChanged(QA qA, QA qA2) {
    }

    @Override
    public void componentOpened() {
        ExplorerManager explorerManager = ExplorerManager.find((Component)this.getViewControl());
        explorerManager.removePropertyChangeListener((PropertyChangeListener)this._explorerHandler);
        explorerManager.addPropertyChangeListener((PropertyChangeListener)this._explorerHandler);
    }

    @Override
    public void componentClosed() {
        ExplorerManager explorerManager = ExplorerManager.find((Component)this.getViewControl());
        explorerManager.removePropertyChangeListener((PropertyChangeListener)this._explorerHandler);
        this._view = null;
    }

    @Override
    public JComponent getViewControl() {
        return this.getView();
    }

    protected S getView() {
        if (this._view == null) {
            this._view = this.createView();
        }
        return this._view;
    }

    protected S createView() {
        S s = new S();
        X x = new X();
        x.C(true);
        x.F(true);
        s.B((CC)x);
        s.\u00cb().addMouseWheelListener((MouseWheelListener)((Object)MouseWheelZoomListener.getInstance()));
        s.setDropTarget(new DropTarget((Component)s, new Graph2DViewDropSupport(s)));
        s.D((fB)this.createEditMode());
        s.D((fB)new eA());
        s.D((fB)new HoverViewMode());
        s.D((fB)new SloppyTooltipMode());
        return s;
    }

    protected rA createEditMode() {
        PopupAwareEditMode popupAwareEditMode = new PopupAwareEditMode();
        popupAwareEditMode.allowEdgeCreation(true);
        popupAwareEditMode.allowBendCreation(false);
        popupAwareEditMode.allowNodeCreation(false);
        popupAwareEditMode.allowEdgeCreation(true);
        popupAwareEditMode.allowLabelSelection(false);
        popupAwareEditMode.allowMoveLabels(false);
        popupAwareEditMode.setPopupMode((fB)new NodePopupMode());
        popupAwareEditMode.setMoveSelectionMode((fB)new BendClearingMoveMode());
        popupAwareEditMode.setSelectionBoxMode((fB)new SelectionBoxViewMode());
        popupAwareEditMode.setCreateEdgeMode((fB)new CreateEdgeViewMode());
        return popupAwareEditMode;
    }

    @Override
    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{new GraphViewAdapter(), new Graph2DViewPrinter(this.getView()), new Graph2DViewExporter(this.getView())});
    }

    @Override
    public void prepareToShow() {
    }

    @Override
    public void componentShowing() {
        if (this._firstShowing) {
            this._firstShowing = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Graph2DViewAdapter.this._view != null) {
                        Graph2DViewAdapter.this._view.\u00de();
                    }
                }
            });
        }
    }

    @Override
    public void componentHidden() {
    }

    @Override
    public void componentActivated() {
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public JComponent getToolbar() {
        Action[] actionArray = this.getViewActions();
        if (actionArray == null || actionArray.length == 0) {
            return null;
        }
        JToolBar jToolBar = new JToolBar();
        for (Action action : actionArray) {
            if (action == null) {
                jToolBar.addSeparator();
                continue;
            }
            jToolBar.add(action);
        }
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    protected Action[] getViewActions() {
        return null;
    }

    protected Graph2DViewDescriptor getDescriptor() {
        return (Graph2DViewDescriptor)this._viewCallback.getDescriptor();
    }

    @Override
    public void setViewCallback(ViewCallback viewCallback) {
        this._viewCallback = viewCallback;
        viewCallback.getTopComponent().getActionMap();
    }

    @Override
    public ViewCallback getViewCallback() {
        return this._viewCallback;
    }

    @Override
    public void onGraphUpdated(Set<yguard.A.A.Y> set, boolean bl) {
    }

    @Override
    public void addInput(KeyStroke keyStroke, Object object) {
        JComponent jComponent = this.getViewControl();
        if (jComponent != null) {
            jComponent.getInputMap(1).put(keyStroke, object);
        }
    }

    private void showSelectionStatus() {
        String string = null;
        QA qA = this._view.H();
        int n = qA.\u011c().size();
        int n2 = qA.\u0115().size();
        string = n > 0 ? n + " entities selected" : (n2 > 0 ? n2 + " links selected" : "0 items selected");
        if (string != null) {
            StatusDisplayer.getDefault().setStatusText(string);
        }
    }

    private static final class HoverViewMode
    extends fB {
        private Object _lastHovered;

        protected void setHoveredObject(Object object) {
            if (this._lastHovered != object) {
                this.fireHoverEvent(object);
            }
            this._lastHovered = object;
        }

        protected void fireHoverEvent(Object object) {
            GraphNodeManager graphNodeManager = GraphNodeManager.getInstance((D)this.view.H());
            if (object instanceof yguard.A.A.Y) {
                Node node = graphNodeManager.getNode((yguard.A.A.Y)object);
                GraphHoverContext.instance().setHover(node);
            } else if (object instanceof H) {
                Node node = graphNodeManager.getNode((H)object);
                GraphHoverContext.instance().setHover(node);
            } else {
                GraphHoverContext.instance().setHover(null);
            }
        }

        public void mouseMoved(double d2, double d3) {
            super.mouseMoved(d2, d3);
            DC dC = this.getHitInfo(d2, d3);
            if (dC != null) {
                if (dC.B()) {
                    this.setHoveredObject(dC.V());
                } else if (dC.X()) {
                    this.setHoveredObject(dC.T());
                } else {
                    this.setHoveredObject(null);
                }
            } else {
                this.setHoveredObject(null);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            this.setHoveredObject(null);
        }

        protected DC getHitInfo(double d2, double d3) {
            return new DC(this.getGraph2D(), d2, d3, true, 3, 4, -1, -1, -1, -1, -1);
        }
    }

    private final class GraphSelectionHandler
    extends SelectionStateObserver {
        private boolean _blocked = false;

        private GraphSelectionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void selectionChanged(QA qA) {
            if (!this._blocked) {
                try {
                    Graph2DViewAdapter.this._explorerHandler.block();
                    ExplorerManager explorerManager = ExplorerManager.find((Component)Graph2DViewAdapter.this.getViewControl());
                    Node[] nodeArray = NodeHelper.getSelection(qA);
                    Node[] nodeArray2 = explorerManager.getSelectedNodes();
                    explorerManager.setSelectedNodes(nodeArray);
                    if (nodeArray.length != nodeArray2.length) {
                        Graph2DViewAdapter.this.showSelectionStatus();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
                finally {
                    Graph2DViewAdapter.this._explorerHandler.unblock();
                }
            }
        }

        private void block() {
            this._blocked = true;
        }

        private void unblock() {
            this._blocked = false;
        }
    }

    private final class ExplorerSelectionHandler
    implements PropertyChangeListener {
        private boolean _blocked = false;

        private ExplorerSelectionHandler() {
        }

        private void block() {
            this._blocked = true;
        }

        private void unblock() {
            this._blocked = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this._blocked && "selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                try {
                    Graph2DViewAdapter.this._graphHandler.block();
                    QA qA = Graph2DViewAdapter.this._view.H();
                    qA.\u00e3();
                    qA.A(qA.\u00d1(), false);
                    qA.B(qA.\u00c9(), false);
                    qA.A((E)new Cursors.Node(GraphNodeManager.getEntityNodes(nodeArray)), true);
                    qA.B((Z)new Cursors.Edge(GraphNodeManager.getLinkNodes(nodeArray)), true);
                    qA.\u00d0();
                    qA.\u011b();
                    Graph2DViewAdapter.this.showSelectionStatus();
                }
                finally {
                    Graph2DViewAdapter.this._graphHandler.unblock();
                }
            }
        }
    }

    private final class GraphViewAdapter
    implements GraphViewCookie,
    GraphView {
        private WA _overview;

        private GraphViewAdapter() {
        }

        @Override
        public GraphView getGraphView() {
            return this;
        }

        @Override
        public void center(Node node) {
            H h;
            yguard.A.A.Y y = (yguard.A.A.Y)node.getLookup().lookup(yguard.A.A.Y.class);
            if (y != null) {
                h = Graph2DViewAdapter.this.getView().H().P(y);
                Graph2DViewAdapter.this.getView().D(h.A, h.D);
            }
            if ((h = (H)node.getLookup().lookup(H.class)) != null) {
                M m = Graph2DViewAdapter.this.getView().H().S(h);
                M m2 = Graph2DViewAdapter.this.getView().H().O(h);
                Graph2DViewAdapter.this.getView().D((m.A + m2.A) / 2.0, (m.D + m2.D) / 2.0);
            }
        }

        @Override
        public double getZoom() {
            return Graph2DViewAdapter.this.getView().\u00dd();
        }

        @Override
        public void setZoom(double d2) {
            Graph2DViewAdapter.this.getView().K(d2);
            Graph2DViewAdapter.this.getView().H().\u011b();
        }

        @Override
        public void fitContent() {
            Graph2DViewAdapter.this.getView().\u00de();
            Graph2DViewAdapter.this.getView().H().\u011b();
        }

        @Override
        public JComponent getOverview() {
            if (Graph2DViewAdapter.this._view == null) {
                return null;
            }
            if (this._overview == null) {
                this._overview = new WA(Graph2DViewAdapter.this.getView());
                this._overview.putClientProperty((Object)"Overview.AnimateScrollTo", (Object)Boolean.TRUE);
                this._overview.putClientProperty((Object)"Overview.PaintStyle", (Object)"Funky");
                this._overview.putClientProperty((Object)"Overview.Inverse", (Object)Boolean.TRUE);
                this._overview.putClientProperty((Object)"Overview.BorderColor", (Object)NodeRealizerSettings.getDefault().getOverviewFogColor());
                this._overview.putClientProperty((Object)"Overview.funkyTheta", (Object)new Double(0.8));
                Color color = ColorUtilities.makeTranslucent((Color)NodeRealizerSettings.getDefault().getOverviewFogColor(), (int)150);
                this._overview.putClientProperty((Object)"Overview.FogColor", (Object)color);
            }
            return this._overview;
        }

        @Override
        public JComponent getViewControl() {
            return Graph2DViewAdapter.this.getView();
        }

        @Override
        public ViewControlAdapter getViewControlAdapter() {
            return Graph2DViewAdapter.this;
        }
    }
}

