/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.util.ImageUtilities;

public class LayoutViewToolbar
extends JToolBar {
    public static final String PROP_LAYOUT_MODE = "layoutModeChanged";
    public static final String PROP_ALL_OR_NEW = "layoutAllOrNewChanged";
    private List<JToggleButton> _modeButtons;
    private ButtonGroup _modeButtonGroup;
    private JToggleButton _allOrNewButton;
    private JToggleButton _interactiveOrganicButton;
    private LayoutFactory.LayoutMode _oldMode = LayoutFactory.LayoutMode.BLOCK;

    public LayoutViewToolbar(boolean bl) {
        this._allOrNewButton = new JToggleButton();
        this._allOrNewButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/Unlocked.png", (boolean)false));
        this._allOrNewButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/layout/resources/Locked.png", (boolean)false));
        this._allOrNewButton.addActionListener(new AllOrNewButtonListener());
        this.add(this._allOrNewButton);
        this._modeButtonGroup = new ButtonGroup();
        LayoutButtonListener layoutButtonListener = new LayoutButtonListener();
        this._modeButtons = new ArrayList<JToggleButton>();
        this.addLayoutMode(LayoutFactory.LayoutMode.BLOCK, layoutButtonListener, this._modeButtonGroup);
        this.addLayoutMode(LayoutFactory.LayoutMode.HIERARCHICAL, layoutButtonListener, this._modeButtonGroup);
        this.addLayoutMode(LayoutFactory.LayoutMode.CIRCULAR, layoutButtonListener, this._modeButtonGroup);
        this.addLayoutMode(LayoutFactory.LayoutMode.ORGANIC, layoutButtonListener, this._modeButtonGroup);
        if (bl) {
            this.hideOnceOffLayoutButtons();
        } else {
            this.addSeparator();
        }
        this._interactiveOrganicButton = this.addLayoutMode(LayoutFactory.LayoutMode.INTERACTIVE_ORGANIC, layoutButtonListener, null);
    }

    private void hideOnceOffLayoutButtons() {
        this._allOrNewButton.setVisible(false);
        for (JToggleButton jToggleButton : this._modeButtons) {
            jToggleButton.setVisible(false);
        }
    }

    private JToggleButton addLayoutMode(LayoutFactory.LayoutMode layoutMode, LayoutButtonListener layoutButtonListener, ButtonGroup buttonGroup) {
        String string = LayoutFactory.getName(layoutMode);
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(ImageUtilities.loadImageIcon((String)("com/paterva/maltego/layout/resources/Layout" + string.replaceAll(" ", "") + ".png"), (boolean)false));
        String string2 = "Set layout mode to " + string;
        jToggleButton.setToolTipText(string2);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setActionCommand(string);
        jToggleButton.addActionListener(layoutButtonListener);
        if (buttonGroup != null) {
            buttonGroup.add(jToggleButton);
        }
        this.add(jToggleButton);
        this._modeButtons.add(jToggleButton);
        return jToggleButton;
    }

    public void setLayoutAll(boolean bl) {
        this._allOrNewButton.setSelected(!bl);
    }

    public boolean isLayoutAll() {
        return !this._allOrNewButton.isSelected();
    }

    public void setLayoutMode(LayoutFactory.LayoutMode layoutMode) {
        for (JToggleButton jToggleButton : this._modeButtons) {
            if (!LayoutFactory.getName(layoutMode).equals(jToggleButton.getActionCommand())) continue;
            jToggleButton.setSelected(true);
            break;
        }
    }

    public LayoutFactory.LayoutMode getLayoutMode() {
        for (JToggleButton jToggleButton : this._modeButtons) {
            if (!jToggleButton.isSelected()) continue;
            return LayoutFactory.getMode(jToggleButton.getActionCommand());
        }
        return null;
    }

    public void setInteractiveSelected(boolean bl) {
        this._interactiveOrganicButton.setSelected(bl);
        this.onInteractiveChanged();
        this.firePropertyChange(PROP_LAYOUT_MODE, null, (Object)this.getLayoutMode());
    }

    private void onInteractiveChanged() {
        if (this._interactiveOrganicButton.isSelected()) {
            this._oldMode = this.getLayoutMode();
            this._modeButtonGroup.clearSelection();
        } else {
            this.setLayoutMode(this._oldMode);
        }
    }

    private class AllOrNewButtonListener
    implements ActionListener {
        private AllOrNewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayoutViewToolbar.this.firePropertyChange(LayoutViewToolbar.PROP_ALL_OR_NEW, !LayoutViewToolbar.this.isLayoutAll(), LayoutViewToolbar.this.isLayoutAll());
        }
    }

    private class LayoutButtonListener
    implements ActionListener {
        private LayoutButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayoutFactory.LayoutMode layoutMode = LayoutFactory.getMode(actionEvent.getActionCommand());
            if (LayoutFactory.LayoutMode.INTERACTIVE_ORGANIC.equals((Object)layoutMode)) {
                LayoutViewToolbar.this.onInteractiveChanged();
            } else {
                LayoutViewToolbar.this._interactiveOrganicButton.setSelected(false);
            }
            LayoutViewToolbar.this.firePropertyChange(LayoutViewToolbar.PROP_LAYOUT_MODE, null, (Object)layoutMode);
        }
    }
}

