/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.DisplayInformationProvider;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.detailview.html.HtmlDetailViewSettings;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.Cursors;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;

class HtmlDetailViewRenderer {
    private static HtmlDetailViewRenderer _default;
    private boolean _isLink;
    private String _entityHeader;
    private String _linkHeader;
    private String _style;
    private String _notes;
    private String _snippet;
    private String _snippetGroup;
    private String _photo;
    private String _photoGroup;
    private String _linkGroup;
    private String _linkIncoming;
    private String _linkOutgoing;
    private String _linkLeft;
    private String _linkRight;
    private String _endpoints;

    public static HtmlDetailViewRenderer getDefault() {
        if (_default == null) {
            _default = new HtmlDetailViewRenderer();
        }
        return _default;
    }

    private HtmlDetailViewRenderer() {
    }

    public String render(Node node) {
        TypeSpec typeSpec = (TypeSpec)node.getLookup().lookup(TypeSpec.class);
        TypedPropertyBag typedPropertyBag = (TypedPropertyBag)node.getLookup().lookup(TypedPropertyBag.class);
        this._isLink = typedPropertyBag instanceof MaltegoLink;
        DisplayInformationProvider displayInformationProvider = (DisplayInformationProvider)node.getLookup().lookup(DisplayInformationProvider.class);
        String string = !this._isLink ? "<html>" + this.style() + "<body>" + this.formatEntityHeader(this.getRegistry(node), (MaltegoEntity)typedPropertyBag, typeSpec) + this.formatPhotos(typedPropertyBag) + this.formatLinks(node) + this.formatNotes((MaltegoPart)typedPropertyBag) + this.formatSnippets(displayInformationProvider) + "</body></html>" : "<html>" + this.style() + "<body>" + this.formatLinkHeader((MaltegoLink)typedPropertyBag, typeSpec) + this.formatPhotos(typedPropertyBag) + this.formatEndpoints(node) + this.formatNotes((MaltegoPart)typedPropertyBag) + this.formatSnippets(displayInformationProvider) + "</body></html>";
        return string;
    }

    private EntityRegistry getRegistry(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        return EntityRegistry.forGraph((D)y.H());
    }

    private String entityHeader() {
        if (this._entityHeader == null) {
            try {
                this._entityHeader = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLEntityHeader");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._entityHeader;
    }

    private String linkHeader() {
        if (this._linkHeader == null) {
            try {
                this._linkHeader = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkHeader");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkHeader;
    }

    private String notes() {
        if (this._notes == null) {
            try {
                this._notes = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLNotes");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._notes;
    }

    private String style() {
        if (this._style == null) {
            try {
                this._style = HtmlDetailViewRenderer.isMacOSX() ? HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLStyleMac") : HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLStyle");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._style;
    }

    private String snippetGroup() {
        if (this._snippetGroup == null) {
            try {
                this._snippetGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLSnippetGroup");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._snippetGroup;
    }

    private String snippet() {
        if (this._snippet == null) {
            try {
                this._snippet = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLSnippet");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._snippet;
    }

    private String photoGroup() {
        if (this._photoGroup == null) {
            try {
                this._photoGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLPhotoGroup");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._photoGroup;
    }

    private String photo() {
        if (this._photo == null) {
            try {
                this._photo = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLPhoto");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._photo;
    }

    private String linkGroup() {
        if (this._linkGroup == null) {
            try {
                this._linkGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkGroup");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkGroup;
    }

    private String linkIncoming() {
        if (this._linkIncoming == null) {
            try {
                this._linkIncoming = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkIncoming");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkIncoming;
    }

    private String linkOutoging() {
        if (this._linkOutgoing == null) {
            try {
                this._linkOutgoing = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkOutgoing");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkOutgoing;
    }

    private String linkLeft() {
        if (this._linkLeft == null) {
            try {
                this._linkLeft = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkLeft");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkLeft;
    }

    private String linkRight() {
        if (this._linkRight == null) {
            try {
                this._linkRight = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkRight");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._linkRight;
    }

    private String endpoints() {
        if (this._endpoints == null) {
            try {
                this._endpoints = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLEndpoints");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this._endpoints;
    }

    private static String load(String string) throws IOException {
        FileObject fileObject = FileUtil.getConfigRoot().getFileObject(string);
        if (fileObject != null) {
            return fileObject.asText();
        }
        return null;
    }

    private String formatEntityHeader(EntityRegistry entityRegistry, MaltegoEntity maltegoEntity, TypeSpec typeSpec) {
        String string;
        String string2 = string = maltegoEntity.getTypeName();
        if (typeSpec != null) {
            string2 = typeSpec.getDisplayName();
        }
        String string3 = "<empty>";
        Object object = InheritanceHelper.getDisplayValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (object != null) {
            string3 = object.toString();
        }
        String string4 = this.entityHeader().replace("${entity-display-value}", string3.toString());
        string4 = string4.replace("${entity-id}", maltegoEntity.getID().toString());
        string4 = string4.replace("${entity-type}", string);
        string4 = string4.replace("${entity-display-type}", string2);
        return string4;
    }

    private String formatLinkHeader(MaltegoLink maltegoLink, TypeSpec typeSpec) {
        String string;
        String string2 = "";
        String string3 = maltegoLink.getTypeName();
        if (typeSpec != null) {
            string3 = typeSpec.getDisplayName();
            string = typeSpec.getProperties().get("maltego.link.transform.name");
            if (string != null) {
                string2 = maltegoLink.getValue((PropertyDescriptor)string).toString();
            }
        }
        string = "<empty>";
        Object object = InheritanceHelper.getDisplayValue((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)maltegoLink);
        if (object != null) {
            string = object.toString();
        }
        String string4 = this.linkHeader().replace("${link-display-value}", string);
        string4 = string4.replace("${link-id}", maltegoLink.getID().toString());
        string4 = string4.replace("${link-type}", string2);
        string4 = string4.replace("${link-display-type}", string3);
        return string4;
    }

    private String formatSnippets(DisplayInformationProvider displayInformationProvider) {
        StringBuffer stringBuffer = new StringBuffer();
        DisplayInformationCollection displayInformationCollection = displayInformationProvider.getDisplayInformation();
        if (displayInformationCollection.size() > 0) {
            HashMap<String, DisplayInformationCollection> hashMap = new HashMap<String, DisplayInformationCollection>();
            for (Object object : displayInformationProvider.getDisplayInformation()) {
                Object object2 = (DisplayInformationCollection)hashMap.get(object.getName());
                if (object2 == null) {
                    object2 = new DisplayInformationCollection();
                    hashMap.put(object.getName(), (DisplayInformationCollection)object2);
                }
                object2.add((DisplayInformation)object);
            }
            int n = 1;
            for (Object object2 : hashMap.keySet()) {
                String string = this.formatSnippetGroup((String)object2, (DisplayInformationCollection)hashMap.get(object2), String.valueOf(n));
                stringBuffer.append(string);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private String formatSnippetGroup(String string, DisplayInformationCollection displayInformationCollection, String string2) {
        String string3 = this.snippetGroup().replace("${snippet-title}", string);
        string3 = string3.replace("${group-number}", string2);
        string3 = string3.replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("snippetBox" + string2));
        string3 = string3.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("snippetBox" + string2));
        StringBuffer stringBuffer = new StringBuffer();
        for (DisplayInformation displayInformation : displayInformationCollection) {
            String string4 = this.snippet().replace("${snippet-body}", displayInformation.getValue());
            stringBuffer.append(string4);
        }
        return string3.replace("${content}", stringBuffer.toString());
    }

    private String formatNotes(MaltegoPart maltegoPart) {
        String string = maltegoPart.getNotes();
        String string2 = "";
        if (!StringUtilities.isNullOrEmpty((String)string)) {
            string = string.replace("\n", "<br>");
            string = HtmlUtils.addHrefs((String)string);
            string2 = this.notes().replace("${notes}", string);
            string2 = string2.replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("noteBox"));
            string2 = string2.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("noteBox"));
        }
        return string2;
    }

    private String formatPhotos(TypedPropertyBag typedPropertyBag) {
        List list = AttachmentUtils.getImageAttachments((PropertyBag)typedPropertyBag);
        String string = "";
        if (!list.isEmpty()) {
            string = this.photoGroup().replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("photoBox"));
            string = string.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("photoBox"));
            StringBuffer stringBuffer = new StringBuffer();
            for (Attachment attachment : list) {
                try {
                    String string2 = FileStore.getDefault().get(attachment.getId()).toURI().toASCIIString();
                    String string3 = this.photo().replace("${photo-image}", string2);
                    string3 = string3.replace("${photo-title}", attachment.getFileName());
                    stringBuffer.append(string3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
            }
            string = string.replace("${content}", stringBuffer);
        }
        return string;
    }

    private String formatLinks(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        String string = "";
        if (y != null) {
            EntityRegistry entityRegistry = EntityRegistry.forGraph((D)y.H());
            if (y.N() > 0) {
                String string2;
                string = this.linkGroup().replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkBox"));
                string = string.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkBox"));
                StringBuffer stringBuffer = new StringBuffer();
                if (y.O() > 0) {
                    string2 = this.linkIncoming().replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkInBox"));
                    string2 = string2.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkInBox"));
                    string2 = string2.replace("${content}", this.formatSubLinks(entityRegistry, Cursors.parentEntities((Y)y)));
                    stringBuffer.append(string2);
                }
                if (y.C() > 0) {
                    string2 = this.linkOutoging().replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkOutBox"));
                    string2 = string2.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkOutBox"));
                    string2 = string2.replace("${content}", this.formatSubLinks(entityRegistry, Cursors.childEntities((Y)y)));
                    stringBuffer.append(string2);
                }
                string = string.replace("${content}", stringBuffer.toString());
            }
        }
        return string;
    }

    private String formatSubLinks(EntityRegistry entityRegistry, Iterable<MaltegoEntity> iterable) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (MaltegoEntity maltegoEntity : iterable) {
            String string = bl ? this.linkLeft() : this.linkRight();
            String string2 = string.replace("${link-reference}", this.getEntityReference(maltegoEntity));
            string2 = string2.replace("${link-title}", this.getEntityName(entityRegistry, maltegoEntity));
            stringBuffer.append(string2);
            bl = !bl;
        }
        if (bl) {
            Object object = this.linkRight().replace("${link-reference}", "");
            object = ((String)object).replace("${link-title}", "");
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    private String getEntityReference(MaltegoEntity maltegoEntity) {
        return "http://localhost:1/maltego/navigateTo/" + maltegoEntity.getID();
    }

    private String getEntityName(EntityRegistry entityRegistry, MaltegoEntity maltegoEntity) {
        Object object = InheritanceHelper.getDisplayValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        return object == null ? "<null>" : object.toString();
    }

    private String formatEndpoints(Node node) {
        H h = (H)node.getLookup().lookup(H.class);
        String string = "";
        if (h != null) {
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)h.a());
            EntityRegistry entityRegistry = EntityRegistry.forGraph((D)h.a());
            string = this.endpoints().replace("${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkBox"));
            string = string.replace("${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkBox"));
            Y y = h.X();
            MaltegoEntity maltegoEntity = graphWrapper.entity(y);
            string = string.replace("${source-reference}", this.getEntityReference(maltegoEntity));
            string = string.replace("${source-id}", maltegoEntity.getID().toString());
            string = string.replace("${source-title}", this.getEntityName(entityRegistry, maltegoEntity));
            Y y2 = h.V();
            MaltegoEntity maltegoEntity2 = graphWrapper.entity(y2);
            string = string.replace("${target-reference}", this.getEntityReference(maltegoEntity2));
            string = string.replace("${target-id}", maltegoEntity2.getID().toString());
            string = string.replace("${target-title}", this.getEntityName(entityRegistry, maltegoEntity2));
        }
        return string;
    }

    private static boolean isMacOSX() {
        return "Mac OS X".equalsIgnoreCase(System.getProperty("os.name"));
    }
}

