/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CustomErrorHandler
extends Handler {
    private Handler _delegate;

    public CustomErrorHandler() {
        this(CustomErrorHandler.findErrorManager());
    }

    public CustomErrorHandler(Handler handler) {
        this._delegate = handler;
    }

    private static Handler findErrorManager() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = classLoader.loadClass("org.netbeans.core.NbErrorManager");
            return (Handler)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Exceptions.printStackTrace((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        return null;
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.block(logRecord.getThrown()) && this._delegate != null) {
            this._delegate.publish(logRecord);
        }
    }

    @Override
    public void flush() {
        if (this._delegate != null) {
            this._delegate.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this._delegate != null) {
            this._delegate.close();
        }
    }

    private boolean block(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return throwable instanceof ArrayIndexOutOfBoundsException;
    }
}

