/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.propertyview.AddImageForm;
import com.paterva.maltego.propertyview.PropertyTypes;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.openide.WizardDescriptor;

class AddImageFormController
extends ValidatingController<AddImageForm> {
    public static final String UNIQUE_NAME = "uniqueName";
    public static final String TYPE_DESCRIPTOR = "typeDescriptor";
    public static final String DISPLAY_NAME = "displayName";
    public static final String IS_EDIT_MODE = "isEditMode";

    protected String getFirstError(AddImageForm addImageForm) {
        String string = addImageForm.getDisplayName();
        if (string.trim().length() == 0) {
            return "Display name is required";
        }
        String string2 = addImageForm.getUniqueName();
        if ((string2 = string2.trim()).length() == 0) {
            return "Unique type name is required";
        }
        if (!this.checkChars(string2)) {
            return "Only alphabetic characters, full stops and digits are allowed in the unique type name.";
        }
        if (addImageForm.getDataType() == null) {
            return "Data type is required";
        }
        return null;
    }

    protected AddImageForm createComponent() {
        final AddImageForm addImageForm = new AddImageForm();
        addImageForm.addChangeListener(this.changeListener());
        addImageForm.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string;
                if (!AddImageFormController.this.isEditMode() && (string = addImageForm.getUniqueName()).trim().length() == 0) {
                    addImageForm.setUniqueName(AddImageFormController.this.createID(addImageForm.getDisplayName()));
                }
            }
        });
        return addImageForm;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty(IS_EDIT_MODE) == Boolean.TRUE;
    }

    private String createID(String string) {
        string = string.replaceAll(" ", "");
        string = string.toLowerCase();
        return "properties." + string;
    }

    private boolean checkChars(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isLetter(c) || c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void readSettings(WizardDescriptor wizardDescriptor) {
        AddImageForm addImageForm = (AddImageForm)this.component();
        addImageForm.setDataTypes(PropertyTypes.allTypes());
        addImageForm.setDataType((TypeDescriptor)wizardDescriptor.getProperty(TYPE_DESCRIPTOR));
        addImageForm.setDisplayName((String)wizardDescriptor.getProperty(DISPLAY_NAME));
        addImageForm.setUniqueName((String)wizardDescriptor.getProperty(UNIQUE_NAME));
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
        AddImageForm addImageForm = (AddImageForm)this.component();
        wizardDescriptor.putProperty(UNIQUE_NAME, (Object)addImageForm.getUniqueName());
        wizardDescriptor.putProperty(TYPE_DESCRIPTOR, (Object)addImageForm.getDataType());
        wizardDescriptor.putProperty(DISPLAY_NAME, (Object)addImageForm.getDisplayName());
    }
}

