/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.startpage;

import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.welcome.startpage.HtmlRenderListener;
import com.paterva.maltego.welcome.startpage.RecentFilesListModel;
import com.paterva.maltego.welcome.startpage.StartPageOptions;
import com.paterva.maltego.welcome.startpage.StartPageRenderContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="StartPageTopComponent", iconBase="com/paterva/maltego/welcome/resources/StartPage.png", persistenceType=2)
public final class StartPageTopComponent
extends TopComponent
implements HtmlRenderListener {
    private HtmlPanel _htmlPanel;
    private StartPageRenderContext _renderContext;
    private JLabel _statusLabel;
    private JList _recentFilesList;
    private JCheckBox _showOnOpenCheckBox;
    private JSplitPane _splitPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public StartPageTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(StartPageTopComponent.class, (String)"CTL_StartPageTopComponent"));
        this.setToolTipText(NbBundle.getMessage(StartPageTopComponent.class, (String)"HINT_StartPageTopComponent"));
        this._htmlPanel = new HtmlPanel();
        this._statusLabel = new JLabel();
        this._statusLabel.setForeground(Color.DARK_GRAY);
        this._statusLabel.setHorizontalAlignment(0);
        this._statusLabel.setVerticalAlignment(0);
        this._showOnOpenCheckBox.setSelected(StartPageOptions.getDefault().isShowOnStartup());
        this._showOnOpenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartPageOptions.getDefault().setShowOnStartup(StartPageTopComponent.this._showOnOpenCheckBox.isSelected());
            }
        });
        this._splitPane.setRightComponent((Component)this._htmlPanel);
        HoverListCellRenderer hoverListCellRenderer = new HoverListCellRenderer(this._recentFilesList);
        this._recentFilesList.setCellRenderer(hoverListCellRenderer);
        this._recentFilesList.removeAll();
        this._recentFilesList.setModel(new RecentFilesListModel());
        this._recentFilesList.addMouseListener(new RecentFilesClickListener());
    }

    private void initComponents() {
        this._splitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._recentFilesList = new JList();
        this._showOnOpenCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this._splitPane.setDividerLocation(140);
        this.jPanel1.setLayout(new BorderLayout());
        this._recentFilesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this._recentFilesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this._recentFilesList);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this._showOnOpenCheckBox, (String)NbBundle.getMessage(StartPageTopComponent.class, (String)"StartPageTopComponent._showOnOpenCheckBox.text"));
        this._showOnOpenCheckBox.setHorizontalAlignment(0);
        this._showOnOpenCheckBox.setMaximumSize(new Dimension(140, 23));
        this._showOnOpenCheckBox.setMinimumSize(new Dimension(140, 23));
        this._showOnOpenCheckBox.setPreferredSize(new Dimension(140, 23));
        this.jPanel1.add((Component)this._showOnOpenCheckBox, "South");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(StartPageTopComponent.class, (String)"StartPageTopComponent.jLabel1.text"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.add((Component)this.jLabel1, "First");
        this._splitPane.setLeftComponent(this.jPanel1);
        this.add(this._splitPane, "Center");
    }

    public void componentOpened() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://www.paterva.com/cgi-bin/splash.pl");
        stringBuilder.append("?branding=");
        stringBuilder.append(System.getProperty("maltego.branding-code", ""));
        stringBuilder.append("&version=");
        stringBuilder.append(System.getProperty("maltego.version", ""));
        stringBuilder.append("&build=");
        stringBuilder.append(System.getProperty("maltego.buildnumber", ""));
        stringBuilder.append("&subtitle=");
        stringBuilder.append(System.getProperty("maltego.version-subtitle", ""));
        stringBuilder.append("&oem=");
        stringBuilder.append(System.getProperty("maltego.oem", ""));
        String string = stringBuilder.toString();
        try {
            this._statusLabel.setText("<html><center>Loading...</center></html>");
            this._splitPane.setRightComponent(this._statusLabel);
            if (this._renderContext != null) {
                this._renderContext.removeListener(this);
            }
            this._renderContext = new StartPageRenderContext(this._htmlPanel, (UserAgentContext)new SimpleUserAgentContext());
            this._renderContext.addListener(this);
            this._renderContext.showURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    void writeProperties(Properties properties) {
        properties.setProperty("version", "1.0");
    }

    void readProperties(Properties properties) {
    }

    @Override
    public void onError(Exception exception) {
        this._statusLabel.setText("<html><center>Could not connect to the Maltego site.<br>Please check your network and proxy settings.</center></html>");
        this._splitPane.setRightComponent(this._statusLabel);
    }

    @Override
    public void onSuccess() {
        this._splitPane.setRightComponent((Component)this._htmlPanel);
    }

    private class RecentFilesClickListener
    extends MouseAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block11: {
                Rectangle rectangle;
                int n = StartPageTopComponent.this._recentFilesList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    rectangle = StartPageTopComponent.this._recentFilesList.getCellBounds(n, n);
                    boolean bl = rectangle != null && rectangle.contains(mouseEvent.getPoint());
                    int n2 = n = bl ? n : -1;
                }
                if (n != -1) {
                    try {
                        WindowUtil.showWaitCursor();
                        rectangle = RecentFiles.getInstance().getMRUFileList().get(n);
                        if (!(rectangle instanceof String)) break block11;
                        String string = (String)((Object)rectangle);
                        try {
                            File file = new File(new URI(string));
                            FileObject fileObject = FileUtil.toFileObject((File)file);
                            if (fileObject == null) {
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                RecentFiles.getInstance().removeFile(string);
                            } else {
                                DataObject dataObject = DataObject.find((FileObject)fileObject);
                                if (dataObject != null) {
                                    OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                                    openCookie.open();
                                }
                            }
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        }
                    }
                    finally {
                        WindowUtil.hideWaitCursor();
                    }
                }
            }
        }
    }

    static class HoverListCellRenderer
    extends DefaultListCellRenderer {
        private static final Color HOVER_COLOR = Color.BLUE;
        private int _hoverIndex = -1;
        private Icon _icon;

        public HoverListCellRenderer(JList jList) {
            HoverMouseHandler hoverMouseHandler = new HoverMouseHandler(jList);
            jList.addMouseListener(hoverMouseHandler);
            jList.addMouseMotionListener(hoverMouseHandler);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, false, bl2);
            this.setForeground(n == this._hoverIndex ? HOVER_COLOR : jList.getForeground());
            return this;
        }

        @Override
        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/welcome/startpage/Graph.png", (boolean)false);
            }
            return this._icon;
        }

        private class HoverMouseHandler
        extends MouseAdapter {
            private final JList _list;

            public HoverMouseHandler(JList jList) {
                this._list = jList;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.setHoverIndex(-1);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = this._list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    Rectangle rectangle = this._list.getCellBounds(n, n);
                    boolean bl = rectangle != null && rectangle.contains(mouseEvent.getPoint());
                    n = bl ? n : -1;
                }
                this.setHoverIndex(n);
            }

            private void setHoverIndex(int n) {
                if (HoverListCellRenderer.this._hoverIndex == n) {
                    return;
                }
                String string = "";
                if (n != -1) {
                    try {
                        String string2 = (String)RecentFiles.getInstance().getMRUFileList().get(n);
                        File file = new File(new URI(string2));
                        string = file.getAbsolutePath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    }
                }
                StatusDisplayer.getDefault().setStatusText(string);
                HoverListCellRenderer.this._hoverIndex = n;
                this._list.repaint();
            }
        }
    }

    private static class MyHtmlPanel
    extends HtmlPanel {
        private MyHtmlPanel() {
        }

        protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext) {
            return new HtmlBlockPanel(userAgentContext, htmlRendererContext, (FrameContext)this){

                public void setRootNode(NodeImpl nodeImpl) {
                    if (nodeImpl != null) {
                        RBlock rBlock = new RBlock(nodeImpl, 0, this.ucontext, this.rcontext, this.frameContext, (RenderableContainer)this);
                        rBlock.setDefaultPaddingInsets(new Insets(0, 0, 0, 0));
                        nodeImpl.setUINode((UINode)rBlock);
                        this.rblock = rBlock;
                    } else {
                        this.rblock = null;
                    }
                    this.invalidate();
                    this.validateAll();
                    this.repaint();
                }
            };
        }
    }
}

