"""
Data related to Kamstrup Management Protocol
"""

RESPONSES = {
    'H': {
        'H': b'==============================================================================\r\nService Menu\r\n==============================================================================\r\nH:   Help [cmd].\r\nQ:   Close connection.\r\n!AC: Access control.\r\n!AS: Alarm Server.\r\n!GC: Get Config.\r\n!GV: Software version.\r\n!SA: Set KAP Server IP and port (*1).\r\n!SB: Set 2nd KAP Server IP and port.\r\n!SC: Set Config (*1).\r\n!SD: Set device name (*1).\r\n!SH: Set KAP Server lookup (DNS or DHCP)\r\n!SI: Set IP (enter either valid IP or 0 to force DHCP)(*1).\r\n!SK: Set KAP watchdog timeout(WDT).\r\n!SN: Set IP for DNS Name servers to use.\r\n!SP: Set IP Ports\r\n!SS: Set Serial Settings.\r\n!RC: Request connect\r\n!RR: Request restart (*1).\r\n!WM: Wink module.\r\n==============================================================================\r\n(*1) Forces system restart\r\n==============================================================================\r\nKamstrup (R)\r\n',
        '!AC': b"!AC: Access control.\r\n     Used for simple IP address firewall filtering.\r\n     If enabled only the listed IP's can assess this module.\r\n      Format:  !AC [En/Dis [ID IP]]\r\n      Example: !AC\r\n               Lists the setup.\r\n      Example: !AC 0\r\n               Disables the filter allowing everybody to access.\r\n      Example: !AC 0 1 192.168.1.211\r\n               !AC 0 2 10.0.0.1\r\n               !AC 0 3 195.215.168.45\r\n               !AC 1\r\n               Only connections from 192.168.1.211, \r\n               10.0.0.1 or 195.215.168.45 are possible.\r\n",
        '!AS': b'!AS: Alarm Server.\r\n     Used to set IP and port of server to handle alarm notifications.\r\n      Format:  !AS [SrvIP [SrvPort]]\r\n      Example: !AS 195.215.168.45 \r\n               Alarms are sent to 195.215.168.45.\r\n      Example: !AS 195.215.168.45 4000\r\n               Alarms are sent to to port 4000 on 195.215.168.45.\r\n      Example: !AS 0.0.0.0\r\n               Alarm reporting is disabled.\r\n',
        '!GC': b'!GC: Get Config.\r\n     Returns the module configuration.\r\n',
        '!GV': b'!GV: Software version.\r\n     Returns the software revision of the module.\r\n',
        '!SA': b'!SA: Set KAP Server IP and port (*1).\r\n     Used for setting the IP of the Server to receive KAP-pacakeges.\r\n     UDP port on server can be provided optionally.\r\n      Format:  !SA SrvIP [SrvPort]\r\n      Example: !SA 195215168045 \r\n               KAP packages are hereafter sent to 195.215.168.45.\r\n      Example: !SA 195.215.168.45 \r\n               Same result as "!SA 195215168045".\r\n      Example: !SA 192168001002 61000\r\n               KAP packages are hereafter sent to 192.168.1.2:61000\r\n               from module port 8000.\r\n      Example: !SA 0.0.0.0 \r\n               Disables KAP.\r\n',
        '!SB': b'!SB: Set 2nd KAP Server IP and port.\r\n     Used for redundancy with two KAP servers.\r\n     When enabled every second KAP is send to the IP defined by !SB.\r\n     NB: The KAP interval to each individual server is half of KAPINT\r\n         defined by !SK.\r\n     NB: !SA must be enabled (not 0.0.0.0) \r\n      Format:  !SB SrvIP [SrvPort]\r\n      Example: !SB 195.215.168.45 \r\n               KAP packages are hereafter also sent to 195.215.168.45.\r\n      Example: !SB 0.0.0.0 \r\n               Disabled.\r\n      Example: !SB 192.168.1.2 61000\r\n               KAP packages are hereafter sent to 192.168.1.2:61000\r\n               from module port 8000.\r\n',
        '!SC': b'!SC: Set Config (*1).\r\n     Configures the module.\r\n      Format:  !SC DHCP IP SUB GW DNS1 DNS2 DNS3 SRV_IP DEVICENAME SRV_DNS\r\n               DHCP        1 for DHCP, 0 for static IP.\r\n               IP..        Static IP settings.\r\n               SRV_IP      IP of remote server (Only if SRV_DNS is 0).\r\n               DEVICENAME  User label for for individual naming.\r\n               SRV_DNS     DNS name of remote server (0 to disable DNS lookup)\r\n',
        '!SD': b'!SD: Set device name (*1).\r\n     Option for individual naming of the module (0-20 chars).\r\n',
        '!SH': b'!SH: Set KAP Server lookup (DNS or DHCP)\r\n     Used for setting the DNS name of the Server to receive KAP-pacakeges.\r\n     Using the keyword "DHCP_OPTION:xxx" makes the module request the IP using DHCP option xxx.\r\n     The settings are first activated when the module is reset (using !RR).\r\n      Example: !SH 0 \r\n               Lookup Disabled.\r\n               The module will send KAP to the IP listed by !SA. \r\n      Example: !SH hosting.kamstrup_meter.dk \r\n               Use DNS lookup.\r\n               The module will send KAP to the IP listed by !SA until it resolves the DNS,\r\n               hereafter the KAP will be sent to hosting.kamstrup_meter.dk\r\n      Example: !SH DHCP_OPTION:129\r\n               Use DHCP Option.\r\n               The module will send KAP to the IP provided by DHCP (in this case option 129).\r\n               The module uses the IP provided by !SA if the DHCP offer dos not include option xxx data.\r\n',
        '!SI': b"!SI: Set IP (enter either valid IP or 0 to force DHCP)(*1).\r\n     Used for changing the module IP.\r\n     (Use !SC if you need to change subnet/Gateway too).\r\n     Entering a '0' will enable DHCP.\r\n      Format:  !SI IP\r\n      Example: !SI 0\r\n               The module will reboot and acuire the IP settings using DHCP.\r\n      Example: !SI 192168001200\r\n               The module will reboot using static IP addr 192.168.1.200.\r\n               (SUB, GW and DNS unchanged)\r\n      Example: !SI 192.168.1.200\r\n               Same as !SI 192168001200.\r\n",
        '!SK': b'!SK: Set KAP watchdog timeout(WDT).\r\n     Used for setting KeepAlive watchdog timing.\r\n      Format:  !SK [WDT] [MISSING] [KAPINT]\r\n      Example: !SK\r\n      Example: !SK 3600\r\n      Example: !SK 3600 60 10\r\n               WDT     The module reboots after WDT?KAPINT seconds\r\n                       without an ACK from the server.\r\n                       0 = disable WDT.\r\n               MISSING After MISSING?KAPINT seconds without an ACK,\r\n                       the Err LED starts blinking.\r\n                       (Used for indication of missing link to the server)\r\n               KAPINT  Interval in seconds for how often KeepAlivePackages\r\n                       are send to the KAP server.\r\n     The WDT and MISSING timeout counts are both reset by an ACK from the server.                       \r\n',
        '!SN': b'!SN: Set IP for DNS Name servers to use.\r\n      Format:  !SN DNS1 DNS2 DNS3\r\n      Example: !SN 192168001200 192168001201 000000000000\r\n      Example: !SN 172.16.0.83 172.16.0.84 0.0.0.0\r\n',
        '!SP': b'!SP: Set IP Ports\r\n      Format:  !SP [KAP CHA CHB CFG]\r\n      Example: !SP 333\r\n               KAP packages are hereafter sent to port 333 on the server.\r\n      Example: !SP 50 1025 1026 50100\r\n               KAP packages are sent to port 50.\r\n               Direct connections to UART channel A is on port 1025, B on 1026.\r\n               Config connection on port 50100.\r\n               (default values)\r\n      Example: !SP 0 0 80\r\n               UART channel B is on port 80 (KAP and ChA is ingored - unchanged).\r\n',
        '!SS': b"!SS: Set Serial Settings.\r\n     Used for setting the serial interface for channel A or B.\r\n      Format:  !SS [Channel Baud,DataBits,Parity,StopBits[,Ctrl]]\r\n      Example: !SS A Auto\r\n      Example: !SS A 9600,8,N,2\r\n      Example: !SS B 115200,8,E,1\r\n      Example: !SS B 115200,8,E,1,I\r\n      Example: !SS B 115200,8,E,1,L\r\n     The ctrl flag can be 'C'(check), 'I' (ignore framing errors) or 'L' (Link, ChB only).\r\n     Chanel A supports auto mode (Also enables load profile logger in old E-Meters).\r\n",
        '!RC': b'!RC: Request connect\r\n     Makes the module crate a ChA or ChB socket to a remote server.\r\n      Format:  !RC Action [IP [Port]]\r\n      Example: !RC A 195.215.168.45 200\r\n      Example: !RC B 195.215.168.45 201\r\n      Example: !RC D\r\n               Disconnects both A and B if open.\r\n      Example: !RC\r\n               Status only.\r\n'
    },
    '!AC': b'\r\nOK\r\n\r\nDISABLED \r\n [1] 0.0.0.0\r\n [2] 192.168.1.211\r\n [3] 0.0.0.0\r\n [4] 0.0.0.0\r\n [5] 0.0.0.0\r\n',
    '!AS': b'\r\nOK\r\n\r\nDISABLED \r\n [1] 0.0.0.0\r\n [2] 0.0.0.0\r\n [3] 0.0.0.0\r\n [4] 0.0.0.0\r\n [5] 0.0.0.0\r\n',
    '!GC': b'Device Name         : \r\nUse DHCP            : YES\r\nIP addr.            : 192.168.1.210\r\nIP Subnet           : 255.255.255.0\r\nGateway addr.       : 192.168.1.1\r\nService server addr.: 202.202.202.1\r\nService server hostname.: kapserver.evilpowerprovider.org\r\nDNS Server No. 1: 0.0.0.0\r\nDNS Server No. 2: 0.0.0.0\r\nDNS Server No. 3: 0.0.0.0\r\nMAC addr. (HEX)     : 00:13:EA:00:00:00\r\nChannel A device meterno.: A1 06 A1 02 B7 34 12 00 00 03\r\nChannel B device meterno.: A1 06 A1 02 B7 34 12 00 00 03\r\nKeep alive timer (flash setting): ENABLED 10\r\nKeep alive timer (current setting): ENABLED 10\r\nHas the module received acknowledge from the server: NO\r\nKAP Server port: 50\r\nKAP Local port: 800\r\nSoftware watchdog: ENABLED 3600\r\n',
    '!GV': b'\r\nSoftware Version: 5.5 (E5)\r\n',
    '!SA': b'\r\nOK\r\nService server addr.: 192.168.1.2:61000\r\n',
    '!SB': b'\r\nOK\r\nService server addr.: 202.202.202.1:50 (from DNS)\r\nand fallback KAP to:  192.168.1.2:61000\r\n',
    '!SC': b'!SC: Set Config (*1).\r\n     Configures the module.\r\n      Format:  !SC DHCP IP SUB GW DNS1 DNS2 DNS3 SRV_IP DEVICENAME SRV_DNS\r\n               DHCP        1 for DHCP, 0 for static IP.\r\n               IP..        Static IP settings.\r\n               SRV_IP      IP of remote server (Only if SRV_DNS is 0).\r\n               DEVICENAME  User label for for individual naming.\r\n               SRV_DNS     DNS name of remote server (0 to disable DNS lookup)\r\n',
    '!SD': b'\r\nOK',
    '!SH': b'\r\nOK\r\nService server hostname.: hosting.kamstrup_meter.dk\r\n',
    '!SI': b'\r\nUse DHCP            : NO\r\n\r\nIP addr.            : 192.168.1.200\r\n',
    '!SK': b'\r\nOK\r\nSoftware watchdog: ENABLED 3600\r\nKAP Missing warning: ENABLED 60\r\nKeep alive timer (flash setting): ENABLED 10\r\n',
    '!SN': b'\r\nOK',
    '!SP': b'\r\nOK\r\nKAP on server: 50\r\nChA on module: 1025\r\nChB on module: 1026\r\nCfg on module: 50100\r\n',
    '!SS': b'\r\nOK\r\n',
    '!RC': b'\r\nOK\r\nStatus: 0100\r\n'
}