from os import walk

import importlib
import json

from prompt_toolkit import prompt
from prompt_toolkit.completion import WordCompleter
from prompt_toolkit.history import FileHistory
from prompt_toolkit.shortcuts import prompt

from veryprettytable import VeryPrettyTable

__author__ = "Jean Lejeune <jlejeune@immunit.ch>"
__copyright__ = "Copyright 2018, ImmunIT"


class Exploiter:
    """This class starts an internal shell allowing to test Drupal CVEs for exploit.
    """

    def __init__(self, request, logger, config):
        self.request = request
        self.config = config
        self.logger = logger
        self.cmds = {
            "exploit": self._exploit,
            "check": self._check,
            "list": self._list,
        }

        self.auto_cmds = WordCompleter(["quit", "list", "check", "exploit"], ignore_case=True)
        self.history = FileHistory('.drupwn-history')
        self._load()

    def _load(self):
        """Loads available CVEs fron configuration files.
        """

        directories = []
        for (dirpath, dirnames, filenames) in walk("./exploits/"):
            directories.extend(dirnames)
            break

        exploits = []
        for directory in directories:
            if directory != "__pycache__":
                with open("./exploits/" + directory + "/info.json") as fd:
                    data = json.load(fd)
                    exploits.append(tuple((data['cve'], data['description'], data['versions'])))

        self.exploits = exploits

    def run(self):
        buf = ""

        self.logger.handle("Commands available: list | quit | check [CVE_NUMBER] | exploit [CVE_NUMBER]", None)
        while True:
            buf = prompt("\nDrupwn> ", history=self.history, completer=self.auto_cmds, complete_while_typing=False)
            args = buf.split(" ")
            try:
                if args[0] == "quit":
                    break
                self.cmds[args[0]](args)
            except:
                pass

    def _exploit(self, args):
        """Instantiates the Exploit class associated to the asked CVE.

        Parameters
        ----------
        args : string array
            CVE to instantiate
        """

        if len(args) == 2:
            getattr(importlib.import_module("exploits." + args[1] + ".Exploit"), "Exploit")(self.request, self.config["target"], self.logger).run(self.config["version"])

    def _check(self, args):
        """Instantiates the Checker class associated to the asked CVE.

        Parameters
        ----------
        args : string array
            CVE to instantiate
        """

        if len(args) == 2:
            getattr(importlib.import_module("exploits." + args[1] + ".Checker"), "Checker")(self.request, self.logger).run(self.config["version"])

    def _list(self, args):
        """List the supported CVEs.
        """

        table = VeryPrettyTable()

        table.field_names = ["CVE", "Description", "Versions affected"]
        for exploit in self.exploits:
            table.add_row([exploit[0], exploit[1], exploit[2]])

        self.logger.handle(table.get_string(), None)
