"""errstr.py

Created by Thomas Mangin on 2011-03-29.
Copyright (c) 2009-2017 Exa Networks. All rights reserved.
License: 3-clause BSD. (See the COPYRIGHT file)
"""

from __future__ import annotations

import errno


def errstr(exc: BaseException) -> str:
    try:
        code: int = exc.args[0] if exc.args else getattr(exc, 'errno', 256)
        if code == 256:
            return f'[Errno unknown] {exc!s}'
        return f'[Errno {errno.errorcode.get(code, str(code))}] {exc!s}'
    except KeyError:
        return f'[Errno unknown (key)] {exc!s}'
    except AttributeError:
        return f'[Errno unknown (attr)] {exc!s}'
