﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Text.RegularExpressions;
using System.Net.Sockets;
using FuzzTalk.Actions;
using FuzzTalk.DataAnalysis;
using System.Reflection;

namespace FuzzTalk
{
    //public delegate void ObjectGraphWalkFunction(object Object)

    class Program
    {
        public static ActivityLog Log;

        public static int[] StringIndexes = null;

        #region Test
        static void StringFinderTest()
        {
            var finder = new StringFinder(new byte[]
            {
                0,
                0,
                0x42,
                0x42,
                0x42,
                0x42,
                0x41,
                0,
                0x43,
                0x43,
                0x43,
                0x41,
                0,
                0x44,
                0x44,
                0x44,
                0x41,
                0
            });

            finder.FindStrings();
        }

        static void FileMutateTest()
        {
            var file = new FileInfo(@"C:\temp\test.contact");
            var app = new FileInfo(@"C:\Program Files\Windows Mail\wab.exe");

            var args = Environment.GetCommandLineArgs();

            app = new FileInfo(args[1]);
            file = new FileInfo(args[2]);
            

            var bytes = file.ReadAllBytes();

            var finder = new StringFinder(bytes);

            var strings = finder.FindStrings();

            //RandomByteMutator mutator = new RandomByteMutator()
            //{
            //    Bytes = bytes,
            //    RandomizeChance = 1
            //};

            //RandomByteMutator mutator = new RandomByteMutator()
            //{
            //    Bytes = bytes,
            //    //RandomizeChance = 1
            //};

            RandomStringOverflowMutator mutator = new RandomStringOverflowMutator()
            {
                Bytes = bytes
            };

            var outputDir = new DirectoryInfo(@".\TestCases_" + DateTime.Now.Ticks);
            outputDir.Create();

            var debuggerPath = new FileInfo(System.Reflection.Assembly.GetExecutingAssembly().Location).DirectoryName +
                @"\Resources\Debugger.exe";

            int testCaseCount = 1024 * 1024;

            for (int i = 0; i < testCaseCount; i++)
            {
                mutator.Mutate();

                var mutationInfoFile = outputDir + "\\" + i + "_mutation.txt";

                using (var writer = new StreamWriter(File.Create(mutationInfoFile)))
                    foreach (var mutation in mutator.MutationActivity)
                        writer.WriteLine("0x{0}: 0x{1} > 0x{2}",
                            mutation.Offset.ToString("X4"),
                            mutation.OldValue.ToString("X2"),
                            mutation.NewValue.ToString("X2"));

                var outputFile = outputDir + "\\" + i + file.Extension.ToString();

                File.WriteAllBytes(outputFile, mutator.MutatedBytes);

                var p = System.Diagnostics.Process.Start(new System.Diagnostics.ProcessStartInfo()
                {
                    FileName = debuggerPath,
                    Arguments = "-s \"" + app.FullName + "\"  \"" + new FileInfo(outputFile).FullName + "\"",
                    //WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden,
                    UseShellExecute = true,
                    //CreateNoWindow = true,                    
                });

                System.Threading.Thread.Sleep(3000);

                p.Kill();

                Console.Write(".");
            }

            Environment.Exit(0);




        }
        #endregion

        static FuzzTalkScript ProcessArguments(string[] Args)
        {
            if (Args.Length == 0)
            {
                UI.DisplayDirections();                
                return null;
            }
            else if (!File.Exists(Args[0]))
            {
                UI.DisplayError("could not find script {0}", Args[0]);
                return null;
            }            

            var argDictionary = ArgumentReader.CreateDictionary(Args
                .Skip(1)
                .ToArray());

            var parameters = FuzzTalkScript.GetParameters(Args[0]);

            if (Args.Length > 1 && Args[1].ToLower() == "-p")
            {
                UI.DisplayParameters(parameters);
                return null;
            }

            var missingParameters = parameters
                .Where(x => 
                    x.DefaultValue == null && 
                    !argDictionary.Keys.Any(y => y == x.Name));

            if (missingParameters.Any())
            {
                UI.DisplayError("missing parameters");
                UI.DisplayParameters(missingParameters);
                return null;
            }

            return FuzzTalkScript.Deserialize(Args[0], argDictionary);
        }

        static void Main(string[] args)
        {
            //FileMutateTest();            

            UI.PrintHeader();

            FuzzTalkScript script = ProcessArguments(args);
            
            if (script == null)
                return;

            FuzzTalkScript.Current = script;

            Log = new ActivityLog(new FileInfo(args[0]).Name);

            var template = script.InitScript();

            StringIndexes = new int[template.Component.Count];

            ActionInterpreter interpreter = null;

            if (script.InitActions != null)
            {
                Console.WriteLine("Initializing script");

                interpreter = new ActionInterpreter(script.InitActions.ToArray());
                interpreter.Run();
            }

            Console.Write("Running script  ");

            while (true)
            {
                var indexPermutator = new IndexPermutator(template.Component
                    .Select(x => x.Reference != null ? x.Reference.Components.Count : 1)
                    .ToArray(), script.Configuration.SingleComponentMode);

                while ((StringIndexes = indexPermutator.GetNext()) != null)
                {
                    var asmTemplate = script.AssembleTemplate(StringIndexes);

                    interpreter = new ActionInterpreter(script.Actions.ToArray());
                    interpreter.SetFuzzBytes(asmTemplate.GetBytes());
                    interpreter.Run();

                    UI.Spinner();
                }

                if (!script.Configuration.Permute)
                    break;                

                script.Configuration.StringOverflowMultiplier += 
                    script.Configuration.StringOverflowMultiplierIncrement;

                var size = script.Configuration.StringOverflowMultiplier * 
                    script.Configuration.StringOverflowSize;

                if (script.Configuration.MaxSize > 0 && 
                    size > script.Configuration.MaxSize)
                    break;

                UI.ClearSpinner();
                Console.Write("\r\nMultiplier: {0}  ", 
                    script.Configuration.StringOverflowMultiplier);
            }

            UI.ClearSpinner();

            Console.WriteLine();


            if (script.CleanupActions != null)
            {
                Console.WriteLine("Cleaning up");

                interpreter = new ActionInterpreter(script.CleanupActions.ToArray());
                interpreter.Run();
            }
        }
    }
}
